<?php

/**
 * Manage wp-admin menu
 *
 */
function canon_admin_menu() {
    remove_menu_page( 'edit-comments.php' );
}
add_action( 'admin_menu', 'canon_admin_menu', 15 );

function canon_admin_styles() {
    ?>
    <style>
        .less-tall-wysiwyg-editor iframe {
            height: 70px !important;
            min-height: 70px;
        }
    </style>
    <?php
}
add_action('admin_head', 'canon_admin_styles');

/**
 *
 * Filter Yoast SEO Metabox Priority
 * @author Jacob Wise
 * @link http://swellfire.com/code/filter-yoast-seo-metabox-priority
 *
 */
function canon_filter_yoast_seo_metabox() {
    return 'low';
}
add_filter( 'wpseo_metabox_prio', 'canon_filter_yoast_seo_metabox' );

/**
 * Hide category and tags submenus in admin
 *
 */
function canon_remove_sub_menus() {
    remove_submenu_page('edit.php', 'edit-tags.php?taxonomy=category');
    remove_submenu_page('edit.php', 'edit-tags.php?taxonomy=post_tag');
    remove_menu_page('edit.php');
}
add_action('admin_menu', 'canon_remove_sub_menus');

/**
 * Remove post meta boxes
 *
 */
function canon_remove_my_post_metaboxes() {
  remove_meta_box( 'categorydiv','post','normal' ); // Categories Metabox
  remove_meta_box( 'tagsdiv-post_tag','post','normal' ); // Tags Metabox
}
add_action('admin_menu','canon_remove_my_post_metaboxes');

/**
 * Hide columns from admin posts page
 *
 */
function canon_manage_columns( $columns ) {
  unset($columns['tags']);
  unset($columns['comments']);
  return $columns;
}
function canon_column_init() { add_filter( 'manage_posts_columns' , 'canon_manage_columns' ); }
add_action( 'admin_init' , 'canon_column_init' );

/**
 * Hide seo scores filter on admin posts page
 *
 */
function canon_remove_yoast_seo_posts_filter() {
    global $wpseo_meta_columns;

    if ( $wpseo_meta_columns ) {
        remove_action( 'restrict_manage_posts', array( $wpseo_meta_columns, 'posts_filter_dropdown' ) );
    }
}
add_action( 'admin_init', 'canon_remove_yoast_seo_posts_filter', 20 );