<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <script>
    (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
    (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
    m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
    })(window,document,'script','https://www.google-analytics.com/analytics.js','ga');

    ga('create', 'UA-630492-60', 'auto'); // canon id
    ga('send', 'pageview');
    </script>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php bloginfo('name'); ?> | <?php is_front_page() ? bloginfo('description') : wp_title(''); ?></title>
    <link rel="apple-touch-icon" sizes="180x180" href="<?=get_stylesheet_directory_uri()?>/assets/favicons/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="<?=get_stylesheet_directory_uri()?>/assets/favicons/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="<?=get_stylesheet_directory_uri()?>/assets/favicons/favicon-16x16.png">
    <link rel="manifest" href="<?=get_stylesheet_directory_uri()?>/assets/favicons/manifest.json">
    <link rel="mask-icon" href="<?=get_stylesheet_directory_uri()?>/assets/favicons/safari-pinned-tab.svg" color="#d02139">
    <meta name="theme-color" content="#ffffff">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<div class="container">
    <header class="header">
        <a href="<?=home_url()?>" class="header__logo">
            <h1><?=bloginfo('title')?></h1>
        </a>
        <button class="header__mobile-menu-button js-mobile-menu-button">menu</button>
        <nav class="header__nav">
            <?php
                wp_nav_menu( array(
                    'theme_location' => 'main',
                    'menu_class'     => 'menu',
                ) );
            ?>
        </nav>
    </header>
</div>