<?php

/**
 *  Enqueue styles and js
 *
 */
function canon_enqueue_scripts() {

    $debug = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG == true ) || ( isset( $_GET['script_debug'] ) ) ? true : false;
    $suffix = ( true === $debug ) ? '' : '.min';

    wp_register_style( 'theme.css', get_stylesheet_directory_uri() . '/assets/css/style' . $suffix . '.css', [], filemtime( get_template_directory() . '/assets/css/style' . $suffix . '.css' ) );
    wp_register_script( 'theme.js', get_stylesheet_directory_uri() . '/assets/js/theme' . $suffix . '.js', array( 'jquery' ), filemtime( get_template_directory() . '/assets/js/theme' . $suffix . '.js'), true );

    wp_enqueue_style( 'theme.css' );
    wp_enqueue_script( 'theme.js' );

    wp_localize_script( 'js/theme.js', 'fb', array(
        'stylesheet_directory_uri' => get_stylesheet_directory_uri(),
        'ajaxurl'                  => admin_url( 'admin-ajax.php' )
    ) );

}

add_action( 'wp_enqueue_scripts', 'canon_enqueue_scripts' );