<?php /** Template Name: Kaart */

get_header();
the_post();
?>

<div class="map-wrapper">

    <div class="container --map">

        <div class="content">
            <?=the_content()?>
        </div>

    </div>

    <div class="acf-map" style="display:none">

        <?php

        // all vensters
        $all_locations = new WP_Query(
            array(
                'post_type' => array('venster'),
                'posts_per_page' => -1
            )
        );

        if ($all_locations->have_posts()):

            while ($all_locations->have_posts()) :
                $all_locations->the_post();

                if( have_rows('locations') ):
                    while( have_rows('locations') ): the_row();

                        $location = get_sub_field('location');
                        $title = get_the_title();
                        $space_position = strpos( $title, ' ');
                        $label = substr( get_the_title(), 0, $space_position);

                        ?>

                        <div class="marker" data-lat="<?=$location['lat']?>" data-lng="<?=$location['lng']?>" data-label="<?=$label?>">
                            <h3 class="marker__title"><?php the_title(); ?></h3>
                            <p class="marker__content"><a href="<?php the_permalink(); ?>">Bekijk dit venster</a></p>
                        </div>

                    <?php endwhile;

                endif;
            endwhile;

        endif;

        wp_reset_query();

        ?>

    </div>

    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyARipGQRlx0eeBqdcZfzKcd9p8HFhGdGbo"></script>
    <script src="<?php echo get_stylesheet_directory_uri(); ?>/assets/js/vendor/markerclusterer.js"></script>
    <script type="text/javascript">
    (function($) {

    function new_map( $el ) {

        // var
        var $markers = $el.find('.marker');

        // vars
        var args = {
            zoom        : 16,
            center      : new google.maps.LatLng(0, 0),
            mapTypeId   : google.maps.MapTypeId.ROADMAP
        };

        // create map
        var map = new google.maps.Map( $el[0], args);

        // add a markers reference
        map.markers = [];

        // add markers
        $markers.each(function(){
            add_marker( $(this), map );
        });

        // center map
        center_map( map );

        var markerCluster = new MarkerClusterer(map, map.markers, {
            styles: [{
                url: '<?php echo get_stylesheet_directory_uri(); ?>/assets/images/markerclusterer/m3-canon.png',
                width: 66,
                height: 65,
                textSize: 16,
                textWeight: 400,
                textColor: "white",
            }]
        });

        $el.show();

        // return
        return map;

    }

    function add_marker( $marker, map ) {

        // var
        var latlng = new google.maps.LatLng( $marker.attr('data-lat'), $marker.attr('data-lng') );

        var mIcon = new google.maps.MarkerImage('/wp-content/themes/canoncuracao/assets/images/marker.png');

        // create marker
        var marker = new google.maps.Marker({
            icon        : mIcon,
            position    : latlng,
            map         : map,
            label       : {color: '#fff', fontSize: '16px', fontWeight: '400', text: $marker.attr('data-label')}
        });

        // add to array
        map.markers.push( marker );

        // if marker contains HTML, add it to an infoWindow
        if( $marker.html() )
        {
            // create info window
            var infowindow = new google.maps.InfoWindow({
                content     : $marker.html()
            });

            // show info window when marker is clicked
            google.maps.event.addListener(marker, 'click', function() {
                infowindow.open( map, marker );
            });
        }

    }

    function center_map( map ) {

        // vars
        var bounds = new google.maps.LatLngBounds();

        // loop through all markers and create bounds
        $.each( map.markers, function( i, marker ){

            var latlng = new google.maps.LatLng( marker.position.lat(), marker.position.lng() );

            bounds.extend( latlng );

        });

        if( map.markers.length == 1 )
        {
            map.setCenter( bounds.getCenter() );
            map.setZoom( 16 );
        }
        else
        {
            map.fitBounds( bounds );
        }

    }

    var map = null;
    $(document).ready(function(){
        $('.acf-map').each(function(){
            map = new_map( $(this) );
        });
    });

    })(jQuery);
    </script>

</div>

<?php get_footer();