CREATE TABLE `wp_posts` (  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',  `post_content` longtext NOT NULL,  `post_title` text NOT NULL,  `post_excerpt` text NOT NULL,  `post_status` varchar(20) NOT NULL DEFAULT 'publish',  `comment_status` varchar(20) NOT NULL DEFAULT 'open',  `ping_status` varchar(20) NOT NULL DEFAULT 'open',  `post_password` varchar(255) NOT NULL DEFAULT '',  `post_name` varchar(200) NOT NULL DEFAULT '',  `to_ping` text NOT NULL,  `pinged` text NOT NULL,  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',  `post_content_filtered` longtext NOT NULL,  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',  `guid` varchar(255) NOT NULL DEFAULT '',  `menu_order` int(11) NOT NULL DEFAULT '0',  `post_type` varchar(20) NOT NULL DEFAULT 'post',  `post_mime_type` varchar(100) NOT NULL DEFAULT '',  `comment_count` bigint(20) NOT NULL DEFAULT '0',  PRIMARY KEY (`ID`),  KEY `post_name` (`post_name`(191)),  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),  KEY `post_parent` (`post_parent`),  KEY `post_author` (`post_author`)) ENGINE=InnoDB AUTO_INCREMENT=1621 DEFAULT CHARSET=utf8;
/*!40000 ALTER TABLE `wp_posts` DISABLE KEYS */;
SET FOREIGN_KEY_CHECKS = 0;
SET UNIQUE_CHECKS = 0;
INSERT INTO `wp_posts` VALUES('2', '1', '2017-05-08 18:34:29', '2017-05-08 16:34:29', '<a href=\"https://canoncuracao.cw/overzicht-van-de-vensters/\">Lijst met alle vensters</a>', 'Home', '', 'publish', 'closed', 'open', '', 'home', '', '', '2020-11-19 09:50:19', '2020-11-19 08:50:19', '', '0', 'http://canon.bramperry.nl/?page_id=2', '0', 'page', '', '0');
INSERT INTO `wp_posts` VALUES('4', '1', '2017-05-08 18:36:20', '2017-05-08 16:36:20', 'Tot de komst van de West-Indische Compagnie (W.I.C.) in 1634 werden de Benedenwindse Eilanden bewoond door Caquetio, die na 1499 werden bestuurd door <a href=\"https://canoncuracao.cw/2-de-spaanse-periode/\">Spanjaarden</a>. Johan van Walbeeck stuurde alle Spanjaarden en een groot gedeelte van de Caquetio naar het vasteland. Daardoor raakte Curaçao vrijwel ontvolkt.\r\n\r\nDe komst van de <a href=\"https://canoncuracao.cw/3-verovering-van-curacao-door-de-wic-en-de-komst-van-de-hollanders/\">W.I.C. </a>zorgde ervoor dat de bevolking in de eerste Nederlandse jaren voornamelijk uit Europese mannen bestond. Dat leidde tot een nogal ruwe samenleving, waar de dominee regelmatig over klaagde. De opeenvolgende directeuren van de W.I.C. op Curaçao vroegen de bewindhebbers in Nederland regelmatig om ‘nette’ vrouwen te sturen, maar er was nog weinig aantrekkelijks voor deze vrouwen om naar Curaçao te komen. Pas toen Peter Stuyvesant en zijn opvolger Mathias Beck het directeurschap op zich namen rond 1645, verbeterden de leefomstandigheden op de eilanden.\r\n\r\nVooral de zorgelijke voedselsituatie kreeg aandacht: de W.I.C. was een bedrijf dat winst moest maken en voedsel importeren was een kostbare zaak. Daarom nodigde Stuyvesant tijdens zijn bewind Sefardische joden uit, die oorspronkelijk uit Spanje en Portugal kwamen en in Brazilië ervaring met plantagelandbouw hadden opgedaan en vanwege de Inquisitie naar Nederland waren gevlucht. Zij konden konden <a href=\"https://canoncuracao.cw/13-plantagesysteem-op-curacao/\">plantages</a> beginnen op Curaçao om lokaal voedsel te produceren. Eenmaal op het eiland aangekomen, werd een aantal joodse families echter ook actief in de handel. Ook veranderde de manier waarop de Compagnie Curaçao wilde gebruiken: was eerst de Kaapvaart een belangrijk argument om Curaçao in bezit te nemen, in de praktijk bleek dat die te weinig opleverde. Maar, door de in Brazilië opgedane kennis over de Trans-Atlantische slavenhandel realiseerde de W.I.C. zich dat Curaçao ideaal was als regionale <a href=\"https://canoncuracao.cw/5-de-slavenhandel-en-slaverij/\">slavenmarkt</a>. Dit leidde uiteindelijk tot drie groepen bewoners op het eiland: de overgebleven <a href=\"https://canoncuracao.cw/1-de-oorspronkelijke-bewoners/\">Caquetio</a>, de christelijke en joodse Europeanen en de tot slaaf gemaakte Afrikanen, die de W.I.C. uit gebieden aan de West-Afrikaanse kust haalde van Guinee tot aan Angola. Zij vormden vanaf de tweede helft van de zeventiende eeuw de bevolking.\r\n\r\nDeze samenleving ontwikkelde zich tot een ‘gesegmenteerde’ maatschappij. Een segment was een groep mensen die bij elkaar hoorde door geboorte, afkomst, huidskleur, geloof en sociaal-economische positie. Wisselen van segment was vrijwel onmogelijk. Tevens hadden de leden van sommige segmenten meer rechten dan anderen. De indeling liep van de hoge blanke protestant, zoals de kooplieden en hoge W.I.C.-ambtenaren met veel rechten en een beperkte vorm van macht tot de tot slaaf gemaakt Afrikanen die geen enkel recht hadden en na verloop van tijd vrijwel allemaal katholiek gedoopt waren. Daartussen bewogen zich de andere groepen:\r\n\r\n– de Sefardische joden, die ondanks hun vaak hoge inkomen en bezit geen politieke macht hadden omdat zij niet het protestantse geloof aanhingen;\r\n\r\n– de lage blanke protestanten: Europese soldaten, matrozen, handwerkslieden en winkeliers;\r\n\r\n– de zogenoemde kleurlingen, ontstaan uit (vaak gedwongen) relaties tussen witte mannen en zwarte vrouwen, die een soort sociale tussenlaag gingen vormen en op Curaçao als een apart segment werden gezien.\r\n\r\n&nbsp;\r\n\r\n&nbsp;', '4. Nieuwe bewoners in de zeventiende eeuw', '', 'publish', 'closed', 'closed', '', '4-nieuwe-bewoners-in-de-zeventiende-eeuw', '', '', '2020-01-28 15:25:19', '2020-01-28 14:25:19', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=4', '3', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('5', '1', '2017-05-08 18:36:20', '2017-05-08 16:36:20', 'Nieuwe bewoners in de zeventiende eeuw Tot de komst van de Westindische Compagnie in 1634 werden de Benedenwindse Eilanden bewoond door clans van de Caiquetios, die na 1499 werden bestuurd door Spanjaarden. Johan van Walbeeck verwijderde alle Spanjaarden en een groot gedeelte van de Caiquetios van de eilanden. Daarmee zijn deze in feite vrijwel zonder inwoners. De komst van de WIC zorgt ervoor dat de bevolking in de eerste Nederlandse jaren voornamelijk uit Europese mannen bestaat. Dat leidt tot een nogal woeste samenleving, waar de dominee regelmatig over klaagt. De opeenvolgende Directeuren van de WIC vragen de WIC regelmatig om ‘nette’ vrouwen te sturen, maar er is nog weinig aantrekkelijks voor deze vrouwen om naar Curaçao te komen. Pas als Peter Stuyvesant en zijn opvolger Mathias Beck het Directeurschap op zich nemen rond 1645, let men meer op de leefomstandigheden op de eilanden. Vooral de zorgelijke voedselsituatie krijgt aandacht: de WIC is een bedrijf dat winst moet maken, dan is de noodzaak om voedsel te importeren een kostbare zaak. Daarom nodigt Stuyvesant tijdens zijn bewind Sefardische joden, die uit Spanje en Portugal naar Nederland waren gevlucht voor de Inquisitie, uit om plantages te starten op de eilanden, zodat hiermee lokaal voldoende voedsel kon worden geproduceerd. Ook verandert de manier waarop de compagnie Curaçao wil gebruiken: was eerst de Kaapvaart het argument om de Benedenwindse Eilanden in bezit te nemen, in de praktijk blijkt dat die te weinig oplevert. Maar, de in Brazilië opgedane kennis over de Transatlantische Slavenhandel zorgt ervoor dat de WIC zich realiseert dat Curaçao ideaal is als regionale slavenmarkt. Dit leidt tot vier groepen bewoners: het restant Caiquetios (vooral op Aruba), de Europeanen, de Sefardische Joden en de tot slaaf gemaakte Afrikanen vormen vanaf de tweede helft van de zeventiende eeuw de bevolking. Deze samenleving ontwikkelt een manier van omgaan en indeling die lijkt op die van de standensamenleving in Europa: de gesegmenteerde maatschappij. Een segment is een groep mensen die daartoe behoren door geboorte, afkomst, huidskleur en geloof, waarbij het wisselen van segment vrijwel onmogelijk is. Tevens hebben de leden van sommige segmenten meer rechten dan anderen. De indeling loopt van de hoge blanke protestant, zoals de kooplieden en hoge WIC ambtenaren met veel rechten tot de tot slaaf gemaakt Afrikanen die geen enkel recht hebben. Daartussen bewegen zich de andere groepen, zoals de Sefardische Joden, lage blanke protestanten en de kleurlingen, de laatste groep het gevolg van relaties tussen Europeanen en Afrikanen.', '4. Nieuwe bewoners in de zeventiende eeuw', '', 'inherit', 'closed', 'closed', '', '4-revision-v1', '', '', '2017-05-08 18:36:20', '2017-05-08 16:36:20', '', '4', 'http://canon.bramperry.nl/2017/05/08/4-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('6', '1', '2017-05-08 18:36:40', '2017-05-08 16:36:40', '<em>De Benedenwindse eilanden</em>\r\n\r\nDe geschiedenis van Bonaire en Aruba is sterk verbonden met die van Curaçao. Deze twee eilanden werden in 1635 (Bonaire) en 1636 (Aruba) veroverd om te verhinderen dat Spanje ze zou kunnen gebruiken als basis om Curaçao aan te vallen. Ofschoon de <a href=\"https://canoncuracao.cw/3-verovering-van-curacao-door-de-wic-en-de-komst-van-de-hollanders/\">W.I.C.</a> niet veel belangstelling had voor Aruba en Bonaire, vonden op deze eilanden toch gedurende de hele W.I.C.-periode (1634-1791) op kleine schaal economische activiteiten plaats. Op Aruba, dat gebruikt werd als een grote ‘hacienda’, hielden de <a href=\"https://canoncuracao.cw/1-de-oorspronkelijke-bewoners/\">Caquetio</a> zich bezig met veeteelt, met name met het fokken van muilezels en paarden. Hoewel in de negentiende eeuw goud en fosfaat werd gewonnen op Aruba, zorgde dit niet voor veel economische voorspoed. Pas toen in de twintigste eeuw ook op Aruba een raffinaderij werd gevestigd, veranderde de economie op dit eiland radicaal. Na de <a href=\"https://canoncuracao.cw/25-tweede-wereldoorlog/\">Tweede Wereldoorlog</a> zorgde het toerisme voor veel voorspoed.\r\n\r\nOp Bonaire vond tijdens de W.I.C.-periode landbouw plaats en er werd zout gewonnen. Toen in de twintigste eeuw de <a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">raffinaderijen</a> van Aruba en Curaçao veel arbeidskrachten nodig hadden, gingen veel Bonaireaanse mannen daar werken. Zij stuurden een deel van hun salaris naar Bonaire en de vrouwen vulden dit daar aan met huisindustrie en landbouw.\r\n\r\nAruba stapte in 1985 uit het staatsverband van de Nederlandse Antillen en heeft vanaf die datum de status van apart land binnen het Koninkrijk der Nederlanden. Bonaire kreeg in <a href=\"https://canoncuracao.cw/34-staatkundige-ontwikkelingen-vanaf-statuut-tot-10-oktober-2010/\">2010</a> de status van ‘bijzondere gemeente’ en valt nu direct onder Nederlands bestuur.\r\n\r\n<em>De Bovenwindse eilanden</em>\r\n\r\nOp de Bovenwindse eilanden ontstond een andere samenleving: hier waren het vooral de Zeeuwse handelaren, die geïnvesteerd hadden in de W.I.C., die het voortouw namen. Eerst werd in 1630 Sint Maarten kortstondig veroverd, vooral om haar ligging op de route van de Spaanse Zilvervloot zodat deze makkelijker gekaapt zou kunnen worden. Die bezetting werd snel beëindigd door Spanje en pas in 1648 werd het eiland definitief samen met Frankrijk veroverd en onderling verdeeld, waarna men zich vooral concentreerde op landbouw en zoutwinning. Van veel groter belang werd vanaf 1636 Sint Eustatius: het eiland bezat een beschermde rede die door de Zeeuwse handelaren vooral voor de trans-Atlantische <a href=\"https://canoncuracao.cw/5-de-slavenhandel-en-slaverij/\">slavenhandel</a> werd gebruikt. Dit leverde veel geld op, waardoor Sint Eustatius in de achttiende eeuw de bijnaam ‘The Golden Rock’ kreeg. Deze voorspoed verdween toen de <a href=\"https://canoncuracao.cw/9-curacao-rond-1800/\">spanningen tussen de Europese grote landen </a>Groot-Brittannië en Frankrijk en tussen Groot-Brittannië en Amerika ook in het Caribisch gebied werden uitgevochten. De Britten waren zeer geïrriteerd toen op 16 november 1776 de Andrew Dorea, een schip dat de Amerikaanse vlag voerde, officieel met kanonschoten werd begroet door Sint Eustatius. Dit was de eerste maal dat Amerika als onafhankelijk land werd erkend. In 1781 verwoestten de Britten onder admiraal Rodney Sint Eustatius, een klap die het niet meer te boven kwam.\r\n\r\nNet als Aruba en Bonaire vervulde Saba slechts een bijrol: het werd in 1640 veroverd ter bescherming van Sint Eustatius.\r\n\r\nIn de negentiende en de eerste helft van de twintigste eeuw werden de drie Bovenwindse eilanden totaal verwaarloosd. Daarom vond er vooral vanaf 1920 veel arbeidsmigratie plaats vanaf deze eilanden naar Aruba en Curaçao. Pas toen het cruise- en verblijfstoerisme zich na 1960 op Sint Maarten ontwikkelde, ontstond er op dat eiland weer een enorme bevolkingsgroei.\r\n\r\nSint Maarten is nu een apart land binnen het Koninkrijk der Nederlanden. Saba en Sint Eustatius zijn sinds 2010 ‘bijzondere gemeenten’ en vallen daarmee direct onder Nederlands bestuur.\r\n\r\n&nbsp;', '47. De andere eilanden van de voormalige Nederlandse Antillen', '', 'publish', 'closed', 'closed', '', '47-de-andere-eilanden-van-de-nederlandse-antillen', '', '', '2020-01-28 20:17:31', '2020-01-28 19:17:31', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=6', '46', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('7', '1', '2017-05-08 18:36:40', '2017-05-08 16:36:40', 'De geschiedenis van Aruba en Bonaire is sterk verbonden met die van Curaçao. Deze twee eilanden worden in 1634 veroverd om te verhinderen dat Spanje via hen Curaçao zou kunnen aanvallen. Niettemin vinden er tijdens de periode van de Westindische Compagnie (WIC, 1634-1791) ook lokale activiteiten plaats: in Aruba dankzij het droge klimaat vooral veeteelt, de overgebleven Caiquetios gaan door met het fokken van muilezels en paarden. Hoewel in de negentiende eeuw goud en fosfaat werd gewonnen op Aruba, zorgde dit niet voor veel economische voorspoed. Pas toen in de twintigste eeuw ook op Aruba een raffinaderij werd gevestigd veranderde de economie radicaal. Na de Tweede Wereldoorlog zorgt het toerisme voor veel voorspoed. Op Bonaire vindt tijdens de WIC-periode landbouw plaats en de bestaande Spaanse zoutpannen worden intensief gebruikt. Dit blijft zo tot in de twintigste eeuw, dan probeert de mannelijke Bonaireaan zijn inkomen vooral op Aruba of Curaçao te verdienen in de daar ontstane industrie. Dit zorgt voor een zogenaamde postwissel-economie: deze mannen sturen een deel van hun salaris naar Bonaire en de vrouwen vullen dit aan met huisindustrie en landbouw. Op de Bovenwindse Eilanden ontstaat een andere samenleving: hier zijn het vooral de Zeeuwse steden, die investeren in de WIC, die het voortouw nemen. Eerst wordt in 1630 kortstondig St.-Maarten veroverd, vooral om haar ligging op de route van de Spaanse Zilvervloot om deze makkelijker te kunnen kapen. Die bedreiging beëindigt Spanje heel snel, pas in 1648 zal het eiland samen met Frankrijk veroverd en verdeeld worden, waarna het vooral landbouw en zoutwinning oplevert. Van veel groter belang wordt vanaf 1636 St.- Eustatius: het heeft een natuurlijke haven die door de Zeeuwse handelaren vooral voor de Transatlantische slavenhandel wordt gebruikt. Dit levert veel geld op, waardoor St.-Eustatius in de achttiende eeuw de bijnaam ‘The Golden Rock’ krijgt. Deze voorspoed verdwijnt als de spanningen tussen de Europese grote landen Groot-Brittannië en Frankrijk ook in het Caribisch Gebied wordt uitgevochten. In 1781 verwoesten de Britten St.-Eustatius, een klap die het niet te boven komt. Saba speelt in de Bovenwinden de rol van Aruba en Bonaire: veroverd in 1640 ter bescherming van St.-Eustatius. In de negentiende en de eerste helft van de twintigste eeuw worden de drie Bovenwindse Eilanden totaal verwaarloosd. Daarom vindt er vooral vanaf 1920 veel arbeidsmigratie plaats naar Aruba en Curaçao. Pas als het cruise- en casinotoerisme zich na 1960 vooral op St.-Maarten ontwikkelt, ontstaat er weer bevolkingsgroei.', '47. De andere eilanden van de Nederlandse Antillen', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2017-05-08 18:36:40', '2017-05-08 16:36:40', '', '6', 'http://canon.bramperry.nl/2017/05/08/6-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('8', '1', '2017-05-08 19:31:32', '2017-05-08 17:31:32', 'De allervroegste aanwijzingen voor de aanwezigheid van mensen op Curaçao dateren van ongeveer 3400 voor Christus. Deze inwoners kwamen van het vasteland, van het huidige Venezuela en Colombia, per kano richting Curaçao. Archeologische resten uit deze vroege (pre-ceramische of archaïsche) periode vinden we terug bij onder andere Rooi Rincon, de Sint Jorisbaai en Seru Boca bij Santa Barbara. Deze vroege inwoners leefden voornamelijk van schelpdieren. Sporen van hun aanwezigheid zijn dan ook in groten getale gevonden in de vorm van zogenaamde schelphopen. Hierin zijn ook hun werktuigen van schelp, steen en koraal gevonden. Ze maakten zelf geen aardewerk en zullen bijvoorbeeld kalebassen of vlechtwerk gebruikt hebben als schalen of om dingen in te bewaren. Behalve schelpdieren zullen ze ook vruchten verzameld hebben.\r\n\r\nHoewel onduidelijk is of deze mensen daadwerkelijk op Curaçao hebben gewoond of dat ze alleen in bepaalde seizoenen langskwamen, is het vrijwel zeker dat er rond 2000 voor Christus echt sprake is van min of meer permanente bewoning op Curaçao. De oudste menselijke resten die zijn teruggevonden aan de voet van de Sint Michielsberg (circa 2000-1650 voor Christus), vormen hiervoor een aanwijzing. Het ligt voor de hand dat de verwanten van deze overledenen in de directe omgeving hebben gewoond, aangezien het gebruikelijk was om de overledenen binnen de nederzetting en zelfs binnen huizen te begraven.\r\n\r\nRond 1000 voor Christus wordt voor het eerst aardewerk gebruikt. Kleine onversierde fragmenten aardewerk met een grove structuur zijn in kleine hoeveelheden bij het Spaanse Water en de Vlakte van Hato aangetroffen. Het is nog onbekend of dit van het vasteland is meegenomen of lokaal gemaakt is. Vermoedelijk worden vanaf deze periode en mogelijk al eerder, rotstekeningen aangebracht op kalkstenen rotswanden en losse rotsblokken (bijvoorbeeld op Savonet).\r\n\r\nDe ceramische periode begint op Curaçao rond 800 na Christus met grote nederzettingen, bijvoorbeeld bij De Savaan, San Juan en Santa Cruz. Hier zijn resten gevonden van bewoning in de vorm van paalgaten, haardplaatsen en graven. Deze specifieke groep “Indianen”, zoals ze sinds de vergissing van Columbus toch steeds worden genoemd – maakten ‘Dabajuroid’ aardewerk. Dit is te herkennen aan de zwarte, bruine, rode en witte versiering door middel van voornamelijk lijnen en stippen. Soms werden op het aardewerk ook menselijke gezichten afgebeeld of dierenkoppen als pootjes aan de pot gevormd. Ook de Caquetio, de Indianen die op het eiland woonden toen de  <a href=\"https://canoncuracao.cw/2-de-spaanse-periode/\">Spanjaarden</a> het in 1499 innamen, hebben schelphopen achtergelaten, waarin echter niet alleen schelpen maar ook een grote hoeveelheid aardewerk, sieraden, bijlen, maalstenen, en andere werktuigen van steen, schelp, koraal en dierlijk bot zijn gevonden. De taal die de Caquetio spraken is waarschijnlijk een variant van de Arawak taalfamilie geweest, maar wordt al heel lang nergens meer gesproken. Naast schelpdieren zullen de Caquetio ook maniok, maïs en fruit gegeten hebben dat ze verbouwden in tuinen (horticultuur). Ze stonden bij de Spanjaarden bekend als goede landbouwers en kanovaarders. Het gebruik van maïs en maniok blijkt uit afslagen van vuursteen voor het raspen van maniok en maalstenen voor het bewerken van maïs. Ook aardewerk platen voor het maken van cassave- en maïskoeken zijn teruggevonden en een maïskorrel bij San Juan.', '1. De oorspronkelijke bewoners', '', 'publish', 'closed', 'closed', '', '1-de-oorspronkelijke-bewoners', '', '', '2020-01-28 15:11:26', '2020-01-28 14:11:26', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=8', '0', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('9', '1', '2017-05-08 19:31:32', '2017-05-08 17:31:32', '', '1. De oorspronkelijke bewoners', '', 'inherit', 'closed', 'closed', '', '8-revision-v1', '', '', '2017-05-08 19:31:32', '2017-05-08 17:31:32', '', '8', 'http://canon.bramperry.nl/8-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('10', '1', '2017-05-08 19:40:52', '2017-05-08 17:40:52', 'Van 1499 to 1634 stond Curaçao onder Spaans gezag.\r\n\r\nDe Spanjaarden kregen Curaçao voor het eerst in het vizier in 1499, tijdens een expeditie die onder leiding van Alonso de Ojeda het Caribisch gebied doorkruiste. Aan deze expeditie namen ook Amerigo Vespucci en Juan de la Cosa als <em>pilotos</em> (stuurlieden) deel. Alonso de Ojeda heeft overigens het eiland niet daadwerkelijk bezocht. Voor de Spaanse zeelieden waren de Indiaanse bewoners van Curaçao kennelijk erg groot en daarom werd het eiland <em>Isla de los</em> <em>Gigantes</em> (eiland der reuzen) genoemd. Over de oorsprong van de naam ‘Curaçao’ is veel gespeculeerd, maar er is geen duidelijke verklaring. Vast staat wel dat de naam van Indiaanse oorsprong is.\r\n\r\nVerspreid over Curaçao lag een aantal Indiaanse dorpen, waaronder Santa Cruz, waar de C<em>acique</em> (opperhoofd) woonde. Er waren in de eerste jaren nadat de Spanjaarden het eiland in 1499 hadden ingenomen geen Spaanse bestuurders op Curaçao. Waarschijnlijk kreeg Alonso de Ojeda van de Spaanse koningen wel de bevoegdheid om Curaçao te besturen, maar hij is nooit als bestuurder op het eiland geweest.\r\n\r\nDe wrede behandeling en de geringe weerstand tegen ziekten die de Europeanen meebrachten, veroorzaakten grote sterfte onder de Indiaanse bevolking van Hispaniola, het eiland waarop nu Haïti en de Dominicaanse Republiek liggen. Daardoor ontstond op dat eiland een nijpend tekort aan arbeidskrachten. In 1513 was dit tekort zo groot, dat Don Diego Colon, de zoon van Columbus, toestemming kreeg om Aruba, Curaçao en Bonaire tot <em>islas inútiles</em>, onnutte eilanden, te verklaren. Dit hield in dat officieel werd vastgesteld dat daar geen edele metalen werden gevonden en de eilanden ook niet geschikt waren voor de landbouw. Dit had tot gevolg dat de Indianen van deze eilanden gevangen genomen mochten worden en dat ze  vervoerd werden naar Hispaniola om daar als tot slaaf gemaakten te werken.\r\n\r\nIn 1526 kreeg Juan de Ampués, de Gouverneur van Venezuela, Curaçao in leen en de taak om Curaçao te herbevolken. Bovendien moest hij de Indianen kerstenen en het eiland tot een handelspost ontwikkelen voor onder andere verfhout en huiden. Tijdens het gouverneurschap van Juan de Ampués nam de bevolking van Curaçao toe tot ongeveer 150 inwoners.\r\n\r\nNa zijn dood in 1533 werd Curaçao bestuurd door zijn schoonzoon, Lázaro Bejarano, en zijn dochter María de Ampués. Lázaro Bejarano zou Curaçao ontwikkelen tot een grote <em>hacienda</em>, een plaats waar vee wordt gehouden.\r\n\r\nVervolgens kwam Curaçao eerst onder het directe bestuur van de <em>Audiencia de Hispañola</em> en kort daarop viel het eiland onder de gouverneur van Caracas. Curaçao werd toen lokaal bestuurd door <em>veedores</em>, opzichters. Van 1571-1634 was Curaçao ook een verversingsstation voor kapers, piraten en andere zeelieden.\r\n\r\nIn 1634 werd het eiland op de Spanjaarden veroverd door <a href=\"https://canoncuracao.cw/3-verovering-van-curacao-door-de-wic-en-de-komst-van-de-hollanders/\">Johan van Walbeeck</a>. Sinds die tijd, met korte onderbrekingen in <a href=\"https://canoncuracao.cw/9-curacao-rond-1800/\">1800-1803</a> en 1807-1816, toen de Britten Curaçao bestuurden, is het eiland met Nederland verbonden geweest.', '2. De Spaanse periode', '', 'publish', 'closed', 'closed', '', '2-de-spaanse-periode', '', '', '2020-01-28 15:14:57', '2020-01-28 14:14:57', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=10', '1', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('11', '1', '2017-05-08 19:40:52', '2017-05-08 17:40:52', '', '2. De Spaanse periode', '', 'inherit', 'closed', 'closed', '', '10-revision-v1', '', '', '2017-05-08 19:40:52', '2017-05-08 17:40:52', '', '10', 'http://canon.bramperry.nl/10-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('12', '1', '2017-05-08 19:41:46', '2017-05-08 17:41:46', '<em>De verovering van Curaçao</em>\r\n\r\nCuraçao werd in 1634 door de West-Indische Compagnie (W.I.C.) veroverd op de Spanjaarden. De Republiek was op dat moment verwikkeld in de Tachtigjarige Oorlog (1568-1648) met Spanje en Portugal. Deze landen waren sinds 1580 verenigd onder één staatshoofd, de Spaanse koning. De W.I.C. was in 1621 opgericht om te dienen als een instrument in die oorlog. Behalve met de uitvoering van een ambitieus plan, het <em>Groot Desseyn</em>, dat gericht was op het veroveren van Portugese gebieden in Afrika en Brazilië, was de W.I.C. vooral actief in de kaapvaart. Er bestond daarom behoefte aan een maritiem steunpunt in het operatiegebied van waaruit militaire acties konden worden ondernomen. Het strategisch gunstig gelegen Curaçao was daarvoor heel goed geschikt. Het eiland leek goed verdedigbaar en beschikte over een uitstekende natuurlijke haven, de Sint Annabaai.\r\n\r\nEen expeditie onder leiding van Johannes van Walbeeck en Pierre le Grand ontmoette weinig weerstand en nam Curaçao in bezit. De kleine Spaanse bezetting werd samen met het grootste deel van de inheemse bevolking gedeporteerd naar <a href=\"https://canoncuracao.cw/45-relatie-venezuela/\">Venezuela</a>. Daarna werd een begin gemaakt met het op orde brengen van de verdediging. Aan de oostelijke zijde van de ingang van de Sint Annabaai, op een landtong die <a href=\"https://canoncuracao.cw/10-ontwikkeling-willemstad/\">De Punt (Punda)</a> werd genoemd, werd een sterkte gebouwd, Fort Amsterdam.\r\n\r\n&nbsp;\r\n\r\n<em>Van oorlogsbasis naar vestigingskolonie</em>\r\n<p style=\"text-align: left;\">Gedurende de eerste jaren na de verovering verbleven er op Curaçao in hoofdzaak militairen. In 1635 waren slechts 20 van de 412 compagniesdienaren burgers. Er woonden verder zo’n 50 inheemse bewoners. Spoedig arriveerden ook <a href=\"https://canoncuracao.cw/4-nieuwe-bewoners-in-de-zeventiende-eeuw/\">tot slaaf gemaakte Afrikanen</a>. Dezen waren aanvankelijk vooral afkomstig van veroverde vijandelijke schepen. Maar hun aantallen waren tot midden zeventiende eeuw nog gering.</p>\r\n<p style=\"text-align: left;\">Vrijwel direct nadat bekend werd dat Curaçao was veroverd, ontstond er in Nederland belangstelling voor kolonisatieprojecten. Militairen en civiele beambten op het eiland, die hun contract hadden uitgediend, kregen ook de mogelijkheid om zich als landbouwer te vestigen. Maar dit leidde nauwelijks tot concrete resultaten.</p>\r\n<p style=\"text-align: left;\">In de jaren vijftig van de zeventiende eeuw vestigden zich <a href=\"https://canoncuracao.cw/4-nieuwe-bewoners-in-de-zeventiende-eeuw/\">joodse kolonisten</a> op het eiland. In 1665 woonden er, de inheemse bevolking niet meegerekend, zo’n 600 personen. Curaçao had inmiddels geen functie meer als oorlogsbasis, maar ontwikkelde zich nu, met de vanaf 1650 opkomende <a href=\"https://canoncuracao.cw/5-de-slavenhandel-en-slaverij/\">slavenhandel</a> als motor, tot een commercieel centrum. Rond deze tijd ontstond ten noorden van Fort Amsterdam een vestiging die uitgroeide tot een ommuurde stad: <a href=\"https://canoncuracao.cw/10-ontwikkeling-willemstad/\">Willemstad</a>. Het aantal <a href=\"https://canoncuracao.cw/13-plantagesysteem-op-curacao/\">plantages</a> en tuinen groeide ook. Deze richtten zich vooral op de voedselproductie voor de lokale markt waaronder ook de slaven in depots.</p>', '3. De verovering van Curaçao door de WIC en de komst van de Hollanders', '', 'publish', 'closed', 'closed', '', '3-verovering-van-curacao-door-de-wic-en-de-komst-van-de-hollanders', '', '', '2020-01-28 15:20:23', '2020-01-28 14:20:23', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=12', '2', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('13', '1', '2017-05-08 19:41:46', '2017-05-08 17:41:46', '', '3. Verovering van Curaçao door de WIC en de komst van de Hollanders', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2017-05-08 19:41:46', '2017-05-08 17:41:46', '', '12', 'http://canon.bramperry.nl/12-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('14', '1', '2017-05-08 19:42:12', '2017-05-08 17:42:12', 'Er waren veel arbeidskrachten nodig in de nieuwe koloniën in Noord- en Zuid-Amerika en het Caribisch gebied voor het werk in de goud- en zilvermijnen en om landbouwproducten voor de export te verbouwen. Om die reden werden ruim 12 miljoen tot slaaf gemaakte Afrikanen gedwongen naar de Amerika’s gebracht. Aan de kusten van Afrika, van Senegal tot Angola, werden handelsposten gebouwd voor deze trans-Atlantische slavenhandel. De vraag naar menselijke koopwaar werd zo groot dat sommige delen van West-Afrika ontvolkt raakten.\r\n\r\nCuraçao werd een belangrijk centrum voor de slavenhandel door de <a href=\"https://canoncuracao.cw/3-verovering-van-curacao-door-de-wic-en-de-komst-van-de-hollanders/\">W.I.C</a>., die van 1662 tot 1689 (in)direct het monopolie voor de levering van tot slaaf gemaakten aan de Spaanse gebieden had, het zogenaamde <em>asiento</em>. Van 1689 tot 1713 werden ook nog veel tot slaaf gemaakten via Curaçao verkocht. In 1713 verkreeg Engeland bij de Vrede van Utrecht echter het <em>asiento</em> en daardoor verloor Curaçao aan belang als handelscentrum voor tot slaaf gemaakten, hoewel het eiland, toen ook al een smokkelbolwerk, daarna nog steeds een rol bleef spelen in de illegale slavenhandel.\r\n\r\nDe meeste tot slaaf gemaakten werden doorverkocht. Degenen die op Curaçao achterbleven, werden ingeschakeld voor allerlei soorten werk. In de stad en haven moesten zij onder meer goederen in- en uitladen en helpen op de werven. Ze hielpen bij bouwwerkzaamheden en deden huishoudelijk werk. Op de schepen werkten ze als matrozen. Op de <a href=\"https://canoncuracao.cw/13-plantagesysteem-op-curacao/\">plantages </a>werd onderscheid gemaakt tussen de werkzaamheden van mannen en vrouwen en tussen ‘huisslaven’ en ‘veldslaven’.\r\n\r\nDe huisslaven waren vooral bedienden en hadden een iets betere positie. De veldslaven, de meerderheid, deden al het zware werk zoals het schoonmaken van terreinen, deze bewerken met de <em>chapi</em> (hak, schoffel) en oogsten. Zij moesten ook zorgen voor het vee, scheidingsmuren bouwen tussen de plantages en diepe putten graven. De <em>shon</em> (meester) of zijn <em>fitó</em> (bedrijfsleider) bepaalde welke werkzaamheden uitgevoerd moesten worden onder leiding van een opzichter, de <em>bomb</em>a, die meestal zelf ook een tot slaaf gemaakte persoon was. De gewassen die het meest werden verbouwd, waren kleine maïs, bonen en pompoenen, en iedere plantage had ook een schaduwrijk hofje waar vruchten en groenten werden verbouwd met water uit putten. Maar de belangrijkste activiteit was de extensieve veehouderij, naast de zoutwinning op bepaalde plantages. De plantage-eigenaren lieten koeien, geiten en schapen rondlopen in de <em>mondi</em> op de plantage waar deze beesten hun eten bij elkaar konden scharrelen.\r\n\r\nEr was nog een derde categorie tot slaaf gemaakten, met name op de grote plantages, de ‘ambachtsslaven’. Dit waren bijvoorbeeld timmerlieden, metselaars, kleermakers en smeden. Ze namen een tussenpositie in. Zij werden vaak verhuurd voor werkzaamheden op andere plantages of in de stad en hierdoor hadden zij meer bewegingsvrijheid. Zij moesten wel altijd een deel van hun opbrengst aan hun meester geven, maar ze konden zich ook vrij kopen door te sparen van wat zij zelf mochten houden. De ambachtslieden konden echter ook voor ander werk worden ingezet wanneer dat nodig werd geacht.\r\n\r\nDoor de veel voorkomende droogte en vaak slechte economische omstandigheden hadden de tot slaaf gemaakten vaak gebrek aan alles, vooral voedsel. De tot slaaf gemaakten werden als inferieur beschouwd en moesten zo lang mogelijk in een situatie van onderworpenheid en onwetendheid blijven. Zij waren nagenoeg rechteloos en eigendom van hun meester, de shon. Hun leven stond geheel in het teken van dienstbaarheid en werd volledig bepaald door de meester. Zij hadden ook geen eigen familienaam en mochten niet trouwen. In de loop van de tijd werden wel wettelijke regels opgesteld die hun betere bescherming boden. Ook was het mogelijk dat zij zichzelf vrij kochten of door hun meester werden vrijgemaakt. Dit laatste werd ‘manumissie’ genoemd. Manumissie was echter niet altijd gunstig: soms manumitteerden meesters juist de ouden en zieken omdat ze dan niet meer voor ze hoefden te zorgen.\r\n\r\n&nbsp;', '5. De slavenhandel en slavernij', '', 'publish', 'closed', 'closed', '', '5-de-slavenhandel-en-slaverij', '', '', '2020-01-28 15:43:06', '2020-01-28 14:43:06', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=14', '4', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('15', '1', '2017-05-08 19:42:12', '2017-05-08 17:42:12', '', '5. De slavenhandel en slaverij', '', 'inherit', 'closed', 'closed', '', '14-revision-v1', '', '', '2017-05-08 19:42:12', '2017-05-08 17:42:12', '', '14', 'http://canon.bramperry.nl/14-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('16', '1', '2017-05-08 19:42:30', '2017-05-08 17:42:30', 'De <a href=\"https://canoncuracao.cw/5-de-slavenhandel-en-slaverij/\">tot slaaf gemaakte Afrikanen</a> hebben zich, waar mogelijk, verzet tegen hun gevangenneming en transport. In het land van bestemming werden zij onder meer tewerkgesteld op plantages, in mijnen en in de woningen van hun nieuwe eigenaren. Zij kregen de status van slaaf, eigendom van degenen die hen gekocht hadden en die hen een nieuwe naam gaf. Zij moesten gehoorzaam zijn en eventueel verzet werd op allerlei mogelijke manieren gebroken. Hierbij werden veelvuldig zware lichamelijke straffen toegepast, ook om hen er steeds op te wijzen dat zij niets anders waren dan het bezit van de meester. Men probeerde hen ook geestelijk te breken opdat zij gehoorzaam en onderdanig zouden zijn.\r\n\r\nToch kwamen de tot slaaf gemaakten steeds weer in verzet tegen de mensonterende behandeling, ook op Curaçao. Dit verzet nam vele vormen aan, bijvoorbeeld door zich ziek voor te doen, door te weigeren opgedragen taken uit te voeren, door opzettelijk langzaam te werken, door sabotage, zelfmoordpogingen, hongerstakingen, weglopen en door gif te doen in het eten of drinken van hun eigenaren. Ook werden weleens wapens opgenomen tegen de eigenaren. Er waren georganiseerde slavenopstanden in 1716 te Sint Marie, in 1750 op de plantage Hato, en in 1795 vond de grote slavenopstand onder leiding van <a href=\"https://canoncuracao.cw/7-tula/\">Tula </a>plaats.\r\n\r\nOmdat Curaçao klein was en er geen dichte bossen, moerassen of hoge bergen waren, konden gevluchte tot slaaf gemaakte personen zich niet verbergen en nieuwe, vrije gemeenschappen vormen, zoals dat wel het geval was in bijvoorbeeld Suriname, Colombia, Hispaniola (nu: Haïti en de Dominicaanse Republiek), Dominica en Jamaica. Vluchtelingen werden meestal vrij snel gepakt en slechts enkelen wisten met grote moeite te overleven in het droge en relatief open Curaçaose landschap. De vele grotten boden soms een goede schuilplaats, maar deze waren ook bekend bij de slaveneigenaren. Om te overleven bleef de <em>katibu shimaron</em> ( de gevluchte tot slaaf gemaakte) afhankelijk van de plantages voor voedsel, water, kleding en andere artikelen. Belangrijk was dat hij daarbij hulp kreeg en vooral niet verraden werd. Tijdens de slavenopstand in 1795 bleken er toch een aantal katibu shimarons te zijn, die al jaren in vrijheid buiten de <a href=\"https://canoncuracao.cw/13-plantagesysteem-op-curacao/\">plantages</a> leefden.\r\n\r\nEr werden ook pogingen ondernomen om met bootjes de kust van <a href=\"https://canoncuracao.cw/45-relatie-venezuela/\">Venezuela</a> te bereiken en velen slaagden daar ook in, vooral nadat de Koning van Spanje had besloten om deze mensen niet terug te sturen indien zij de bedoeling hadden om katholiek te worden gedoopt. In Coro, een Venezolaans stadje, relatief gemakkelijk te bereiken vanuit Curaçao, woonde een behoorlijk grote groep voormalige Curaçaose slaven. Tot slaaf gemaakten werkten ook als matrozen aan boord van zeilschepen en kregen, als zij uitzeilden, een vrijbrief zodat zij, in het geval dat hun schip gekaapt werd, niet als slaaf zouden worden doorverkocht. Deze vrijbrief werd weer ingetrokken zodra zij weer op Curaçao waren, maar sommigen maakten van de gelegenheid gebruik om niet terug te keren naar Curaçao.\r\n\r\nHet slavenverzet zien wij ook terug in verhalen, zoals de bekende Nanzi-verhalen, en liedjes waarin de meester werd bespot en afbreuk werd gedaan aan zijn gezag.', '6. Slavernijverzet', '', 'publish', 'closed', 'closed', '', '6-slavernijverzet', '', '', '2020-01-28 15:48:38', '2020-01-28 14:48:38', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=16', '5', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('17', '1', '2017-05-08 19:42:30', '2017-05-08 17:42:30', '', '6. Slavernijverzet', '', 'inherit', 'closed', 'closed', '', '16-revision-v1', '', '', '2017-05-08 19:42:30', '2017-05-08 17:42:30', '', '16', 'http://canon.bramperry.nl/16-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('18', '1', '2017-05-08 20:37:19', '2017-05-08 18:37:19', '', 'Home', '', 'inherit', 'closed', 'closed', '', '2-revision-v1', '', '', '2017-05-08 20:37:19', '2017-05-08 18:37:19', '', '2', 'http://canon.bramperry.nl/2-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('19', '1', '2017-05-09 15:31:35', '2017-05-09 13:31:35', 'Op 17 augustus 1795 weigerden de <a href=\"https://canoncuracao.cw/5-de-slavenhandel-en-slaverij/\">tot slaaf gemaakten</a> op de plantage Knip, onder aanvoering van Tula, om aan het werk te gaan. De <a href=\"https://canoncuracao.cw/6-slavernijverzet/\">opstand</a> strekte zich al snel uit over heel Bandabou (het westelijk gedeelte van het eiland) en er waren ook sympathisanten op de rest van het eiland. Binnen een paar dagen kwamen nagenoeg 2000 tot slaaf gemaakten in beweging en hun leiders, van wie Tula de belangrijkste was, stelden duidelijke eisen. De opstand was een bewuste en geplande actie.\r\n\r\nDe omstandigheden waarin de bevolking moest leven waren sterk verslechterd aan het <a href=\"https://canoncuracao.cw/9-curacao-rond-1800/\">eind van de 18e eeuw</a> en vooral de tot slaaf gemaakten leden veel gebrek. Tegelijkertijd waren er grote politieke spanningen binnen de plaatselijke blanke burgerij, die samenhingen met gebeurtenissen in Nederland, die op straat uitgevochten werden. Aan de ene kant stonden de ‘<em>oranjegezinden’</em>, ook wel de<em> ‘prinsgezinden’ </em>genoemd, die als conservatieven de bestaande toestand wilden handhaven en aan de andere kant stonden de ’<em>patriotten’</em> die republikeins gezind waren en veranderingen in de geest van \'vrijheid, gelijkheid en broederschap\' nastreefden.\r\n\r\nDeze nieuwe ideeën hadden geleid tot de Franse Revolutie (1789) en in de nasleep daarvan tot de grote slavenopstanden op St Domingue (het huidige Haiti), in 1791 onder de mulattenleider Rigaud en in 1793 onder leiding van Toussaint Louverture. Uit angst voor navolging hiervan werd de onderdrukking van de tot slaaf gemaakten op Curaçao nog harder.\r\n\r\nFeit was dat Nederland in januari 1795 bezet werd door Frankrijk en dat in Frankrijk op dat moment de slavernij was afgeschaft. In de ogen van de tot slaaf gemaakten stond Curaçao op dat moment dus feitelijk onder Frans gezag en diende er daarom een einde te komen aan de slavernij. Tula bleek goed op de hoogte te zijn van deze ontwikkelingen, hetgeen erop wijst dat hij over goede contacten beschikte. Zeer waarschijnlijk bestond er een band tussen hem en bepaalde patriotten op het eiland, waaronder de plantage-eigenaresse Johanna Lesire. Zij stond toe dat opstandelingen zich verscholen in haar huizen in Scharloo en Kwartier en haar plantage Porto Marie werd het hoofdkwartier van Tula. Uit deze contacten blijkt dat Tula geen geïsoleerd bestaan leidde op Bandabou. Hij had waarschijnlijk meer bewegingsvrijheid dan andere slaven. Verder weten wij dat hij werd aangeduid als \'neger\', dat hij Papiaments sprak en dat hij een broer had die Nicolaas heette.\r\n\r\nNadat Tula op 19 september 1795 werd gearresteerd, nadat hij was verraden door een andere tot slaaf gemaakte, werd hij langdurig gemarteld en verhoord, omdat de autoriteiten meer wilden weten over de betrokkenheid van anderen bij de opstand.\r\n\r\nTula bezat een behoorlijke kennis van het katholicisme en kon een lang gesprek voeren met pater Schinck die hem probeerde over te halen de strijd te staken. Zijn woorden zijn toen opgetekend: “Heer pater, zijn wij niet allen uit Adam en Eva voortgekomen?\". Hij was vastberaden, getuige zijn opstelling tegenover kapitein Van Westerholt, die de slavenopstand uiteindelijk neersloeg, aan wie hij liet weten: \"wij zijn hier om te overwinnen of te sterven\".\r\n\r\nHij was een leider met een duidelijke visie, hij kon grote groepen slaven mobiliseren en had charisma en overwicht. In 2010 werd hij officieel erkend als nationale held en werden hij en zijn volgelingen gerehabiliteerd.\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;', '7. Tula', '', 'publish', 'closed', 'closed', '', '7-tula', '', '', '2020-01-28 15:56:23', '2020-01-28 14:56:23', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=19', '6', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('20', '1', '2017-05-09 15:31:35', '2017-05-09 13:31:35', '', '7. Tula', '', 'inherit', 'closed', 'closed', '', '19-revision-v1', '', '', '2017-05-09 15:31:35', '2017-05-09 13:31:35', '', '19', 'http://canon.bramperry.nl/19-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('21', '1', '2017-05-09 15:31:48', '2017-05-09 13:31:48', 'Op Curaçao spreken de meeste inwoners dagelijks Papiamentu. Dat gebeurt thuis, met familie en vrienden, op <a href=\"https://canoncuracao.cw/41-onderwijs-op-curacao/\">school</a> en op het werk. Op de andere twee <a href=\"https://canoncuracao.cw/47-de-andere-eilanden-van-de-nederlandse-antillen/\">Benedenwindse eilanden</a> Bonaire (Papiamentu) en Aruba (Papiamento) is het ook de meest gesproken taal, al verschilt het op de drie eilanden wel enigszins. De naam van deze algemene omgangstaal is afkomstig van het Portugese woord <em>papear</em>. De basis voor het Papiamentu werd gelegd door de vermenging van het Portugees (bijvoorbeeld <em>aind</em>a, <em>pretu</em>) dat vooral door <a href=\"https://canoncuracao.cw/4-nieuwe-bewoners-in-de-zeventiende-eeuw/\">Portugees-joodse</a> slaveneigenaren werd gesproken met de Afrikaanse talen die de <a href=\"https://canoncuracao.cw/5-de-slavenhandel-en-slaverij/\">tot slaaf gemaakten</a> meebrachten (bijv. <em>bakoba</em>, <em>chichi</em>) en –wat later- het Nederlands van de kolonisator (<em>stul</em>, <em>buki</em>). Woorden uit het Spaans (<em>mesa</em>, <em>kome</em>) dat in de meeste omringende landen werd gesproken, gingen uiteindelijk zelfs voor ruim tweederde het Papiamentu beïnvloeden en ook Engels kwam daar bij (<em>chèk</em>, <em>kòmpiuter</em>).\r\n\r\nDe vondst van een handgeschreven brief uit 1775 en andere schriftelijke bronnen laten zien dat het Papiamentu in die tijd niet alleen gesproken, maar ook al geschreven werd. De eerste schoolmeester, Paddenburgh, klaagde in 1818 dat het Papiamentu zo wijd verspreid was, dat zelfs de Nederlanders op het eiland beter Papiamentu spraken dan Nederlands. Om de <a href=\"https://canoncuracao.cw/4-nieuwe-bewoners-in-de-zeventiende-eeuw/\">vrije zwarte bevolking</a> of gemanumitteerden, die in tegenstelling tot de tot slaaf gemaakten mochten lezen en schrijven, grondiger te kunnen bekeren, drukten begin 19e eeuw de katholieke priesters Niewindt en Putman boeken in het Papiamentu. Putmans eerste woordenboek Papiamentu-Nederlands verscheen in 1859. Eind 19e eeuw zou Joseph Sickman Corsen het eerste echte gedicht, <em>Atardi </em> in het Papiamentu in het blad <em>La Cruz</em> publiceren, wat hem de naam opleverde van ‘vader’ van de Papiamentstalige literatuur.\r\n\r\nIn de twintigste eeuw werkten velen flink aan de uitbouw van deze taal. Op eilandelijk niveau nam de Curaçaose overheid in 1976 een fonologisch georiënteerde spelling aan, die Bonaire ook aanvaardde, terwijl Aruba voor een eigen etymologische schrijfwijze koos. Er verschenen meerdere woordenboeken Papiamentu, vertalend naar Nederlands en Engels en omgekeerd. In 1986 vond de overheid, na veel maatschappelijke discussie op Curaçao, het tijd om het Papiamentu als vak in te voeren in het basisonderwijs.\r\n\r\nHeel belangrijk is het feit dat uiteindelijk Papiamentu door de overheid in 2007 werd erkend als officiële taal, naast het Nederlands en het Engels, en een erkende spelling kreeg op landsniveau in 2008. Het <em>Buki di Oro</em>, dat de overheid in 2009 uitgaf, bevat een handleiding voor de officiële spelling en een lijst met gestandaardiseerde woorden die bij wet zijn vastgelegd. Dit bracht veel duidelijkheid en rust in het <a href=\"https://canoncuracao.cw/41-onderwijs-op-curacao/\">onderwijs </a>van Papiamentu. Deze lijst leidde op zijn beurt weer naar een vernieuwde elektronische spellingcontrole. Papiamentu werd nog krachtiger toen het in het nieuwe millennium bij wet een echt schoolvak en zelfs instructietaal op scholen werd, met moderne schoolboeken en kleurrijk materiaal. Na het taalmateriaal van het overheidsbureau <em>Sede di Papiamentu</em> (1983-1998), kwamen er vanaf 1998 bij de onderwijsvernieuwingen eigentijdse schoolboeken uit van het overheidsbureau <em>Fundashon pa</em> <em>Planifikashon di Idioma</em>. Er kwamen complete leergangen met taalboeken Papiamentu beschikbaar voor alle groepen en klassen, van groep 1 in het funderend onderwijs tot en met het HBO.\r\n\r\nDe Papiamentstalige literatuur is veelzijdig, waarbij alle genres vertegenwoordigd zijn. Er is toneel-, verhaal- en dichtkunst. Geaccrediteerde lerarenopleidingen Papiamentu op Bachelor- en Masterniveau bij de Universiteit van Curaçao, getuigen van een gewaardeerde plaats van deze taal in de gemeenschap.\r\n\r\nVoor de gebruikers en de nieuwe experts wordt nog steeds gewerkt aan spellingboekjes, woordenboeken en grammatica’s. Daarnaast is er aandacht van onderzoekers voor de taalstructuur, het taalleren, de literatuur en de literaire geschiedenis van deze taal in de vorm van internationale wetenschappelijke artikelen, boeken, scripties en dissertaties. Taalcomparisten beschouwen het Papiamentu als één van de best beschreven creooltalen met een hoge status.', '8. Papiamentu', '', 'publish', 'closed', 'closed', '', '8-papiamentu', '', '', '2020-11-20 19:17:37', '2020-11-20 18:17:37', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=21', '7', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('22', '1', '2017-05-09 15:31:48', '2017-05-09 13:31:48', '', '8. Papiamentu', '', 'inherit', 'closed', 'closed', '', '21-revision-v1', '', '', '2017-05-09 15:31:48', '2017-05-09 13:31:48', '', '21', 'http://canon.bramperry.nl/21-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('23', '1', '2017-05-09 15:32:06', '2017-05-09 13:32:06', '<em>Een patriotse machtsovername</em>\r\n\r\nToen in 1795 de <a href=\"https://canoncuracao.cw/6-slavernijverzet/\">slavenopstand</a> uitbrak, was er politieke onrust in Curaçao. Evenals in de Republiek der Zeven Verenigde Nederlanden (1588-1795) stonden patriotten en conservatieve Oranjegezinden tegenover elkaar. De patriotten streefden naar meer democratie, meer invloed van het volk, en keerden zich tegen de absolute macht van stadhouder Willem V en zijn aanhang. Binnen de Curaçaose koloniale context, waar onvrijheid en huidskleur bepalend waren voor de maatschappelijke verhoudingen, kreeg deze politieke tegenstelling een eigen karakter. Evenals in Nederland, waar in 1795 met Franse steun de stadhouder werd verdreven en de Bataafse Republiek (1795-1801) werd uitgeroepen, wisten ook patriotten in Curaçao, gesteund door Franse kapers, in 1796 de macht te grijpen. De Bataafse Republiek, een Franse vazalstaat, kwam als bondgenoot van Frankrijk in de oorlog met Groot-Brittannië. Curaçao werd een belangrijk maritiem steunpunt voor de Fransen.\r\n\r\n<em>Hervorming van de defensie</em>\r\n\r\nNa de machtswisseling verkeerde het defensieapparaat in chaos. Oranjegezinde officieren van het garnizoen vertrokken hals over kop van Curaçao. Kort daarna werd de gouverneur a.i., Jan Jacob Beaujon, die ervan werd verdacht Oranjegezind en pro-Brits te zijn, afgezet. Hij werd opgevolgd door de kapitein van de burgerij Johann Rudolf Lauffer, die de verdediging van Curaçao reorganiseerde. De oorspronkelijk exclusief blanke burgerwacht werd uitgebreid met vrije Afro-Curaçaoenaars en omgedoopt tot Nationale Garde. Deze ‘vrijen’ waren afkomstig uit de zeevarende bevolking en hadden ervaring met de bediening van scheepsgeschut. Afro-Curaçaose schippers kregen officiersrangen bij het onderdeel artillerie.\r\n\r\n<em>Revolutionaire onrust</em>\r\n\r\nGeïnspireerd door de leuzen ‘vrijheid’ en ‘gelijkheid’ van de Franse Revolutie (1789-1799), de succesvolle slavenopstand in de Franse kolonie Saint-Domingue (het huidige Haïti) in 1791, die overging in de Haïtiaanse Revolutie (1791-1804) en de Franse afschaffing van de slavernij in 1792, ontstond in de gehele regio revolutionaire onrust. Het streven van de patriotten naar politieke en maatschappelijke verandering raakte op Curaçao vervlochten met het verlangen van de Afro-Curaçaoënaars naar vrijheid en een gelijke behandeling. Dit leidde op het eiland tot spanningen. Ook de <a href=\"https://canoncuracao.cw/7-tula/\">grote slavenopstand</a> op Curaçao in 1795 moet in deze context worden bezien. De leiders van een mislukte opstand in Venezuela vluchtten in 1797 naar Curaçao en vonden onderdak in Otrobanda. Geruchten over hun uitlevering veroorzaakte bijna een muiterij onder het voornamelijk uit Afro-Curaçaoënaars bestaande onderdeel artillerie van de Nationale Garde. In 1799 werden drie Fransen gearresteerd omdat zij, volgens Lauffer, de leiders waren van een complot om een nieuwe slavenopstand te ontketenen en de macht te grijpen. Alle drie werden zij uitgewezen.\r\n\r\n<em>Aangevallen door de bondgenoot en gered door de vijand</em>\r\n\r\nIn 1800 verscheen een Franse militaire macht uit Guadeloupe voor de haven om, zo werd gemeld, Curaçao tegen de Britten te beschermen. Vermoed werd dat de Fransen uit waren op een machtsovername. Dit bleek inderdaad het geval. Na eerst op aandringen van het gouvernement te zijn vertrokken, landden de Fransen een dag later bij Sint Michielsbaai. Daarna veroverden deze voornamelijk uit zwarte soldaten bestaande troepenmacht, gesteund door een groot deel van de Curaçaose slavenbevolking, op Willemstad na vrijwel het gehele eiland. Toen een Brits oorlogsschip voor de haven verscheen en vervolgens ook twee Amerikaanse oorlogsschepen, besloot het gouvernement om hun hulp in te roepen. De Fransen werden verdreven, maar een Britse bezetting, die tot 1803 zou duren, was het gevolg.\r\n\r\n&nbsp;', '9. Curaçao rond 1800', '', 'publish', 'closed', 'closed', '', '9-curacao-rond-1800', '', '', '2020-01-28 16:13:57', '2020-01-28 15:13:57', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=23', '8', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('24', '1', '2017-05-09 15:32:06', '2017-05-09 13:32:06', '', '9. Curaçao rond 1800', '', 'inherit', 'closed', 'closed', '', '23-revision-v1', '', '', '2017-05-09 15:32:06', '2017-05-09 13:32:06', '', '23', 'http://canon.bramperry.nl/23-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('25', '1', '2017-05-09 15:32:22', '2017-05-09 13:32:22', 'Het gehele bewoonde gebied rondom het Schottegat, de grote natuurlijke <a href=\"https://canoncuracao.cw/23-de-haven/\">haven</a> van Curaçao, wordt tegenwoordig aangemerkt als Willemstad. Tot het begin van de twintigste eeuw had Willemstad echter een veel beperktere omvang en maakten de gronden rond het Schottegat vooral deel uit van <a href=\"https://canoncuracao.cw/13-plantagesysteem-op-curacao/\">plantages</a>. De stad zelf bestond toen uit de wijken Punda, Pietermaai, Scharloo en Otrobanda.\r\n\r\nDe <a href=\"https://canoncuracao.cw/3-verovering-van-curacao-door-de-wic-en-de-komst-van-de-hollanders/\">West-Indische Compagnie</a> (W.I.C.) nam Curaçao in 1634 in bezit, ondermeer als maritiem steunpunt in het Caribische gebied. De Sint Annabaai en het beschutte Schottegat waren daarvoor zeer geschikt. Om de haveningang te verdedigen werd reeds in 1635 begonnen met de bouw van het Fort Amsterdam, gelegen op de punt van de oostelijke oever van de Sint Annabaai. Dit gebied werd De Punt genoemd, later veranderd in Punda.\r\n\r\nIn de tweede helft van de zeventiende eeuw ontstond noordelijk van het fort, en onder bescherming daarvan, het stadje Willemstad. De stad werd aan drie zijden omsloten door een stadsmuur. Langs de Sint Annabaai was er geen muur. Daar legden de schepen aan voor het laden en lossen.\r\n\r\nOmstreeks 1700 was Willemstad al aan het volraken en ging men buiten de stadsmuren wonen. Zo ontstonden buiten Punda  de wijken Pietermaai, Scharloo en Otrobanda. Het Waaigat was destijds vele malen groter dan tegenwoordig en liep tot aan het huidige Julianaplein.\r\n\r\nOok de strook land tussen het Waaigat en de zee was veel smaller. Hier ontstond vanaf de 18e eeuw de wijk Pietermaai. Aan beide zijden van de weg, die naar het oostelijk deel van het eiland liep, werden huizen gebouwd. De stadsmuur werd tussen 1861 en 1866 afgebroken. Delen van het Waaigat werden gedempt en zowel Punda als Pietermaai breidden zich in noordelijke richting uit. Ook werd het tot dan toe onbebouwde gebied tussen deze twee stadsdelen bebouwd.\r\n\r\nLangs de noordzijde van het Waaigat, op de voormalige plantage Scharloo, werden vanaf de achttiende eeuw grote, verspreid staande woningen gebouwd. In de tweede helft van de negentiende eeuw werd het gebied verder verkaveld. Na 1870 nam de bouwactiviteit in snel tempo toe. In enkele tientallen jaren ontwikkelde Scharloo zich tot een vooraanstaande woonwijk.\r\n\r\nIn het begin van de achttiende eeuw werden de eerste kavels uitgegeven aan de overzijde - de ‘Otrobanda’ - van de Sint Annabaai. De nieuwe wijk ontstond aanvankelijk vooral langs de Sint Annabaai en de weg die naar het westen van het eiland liep, de latere Breedestraat (O). Doordat Otrobanda nooit ommuurd is geweest en men dus niet binnen een beperkte ruimte hoefde te bouwen, waren de panden hier aanvankelijk ruim van opzet. Het huis stond op een groot perceel met vrije ruimte er omheen. Aan de randen van deze vaak ommuurde ‘<em>kur</em>a’<em>s</em>’, werden kleine aaneengesloten woningen gebouwd. Otrobanda groeide snel en rond het midden van de achttiende eeuw was het al groter dan Punda. In de tweede helft van de negentiende eeuw breidde de wijk zich naar het noorden toe uit, de heuvel op.', '10. De ontwikkeling van Willemstad', '', 'publish', 'closed', 'closed', '', '10-ontwikkeling-willemstad', '', '', '2020-01-28 16:17:02', '2020-01-28 15:17:02', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=25', '9', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('26', '1', '2017-05-09 15:32:22', '2017-05-09 13:32:22', '', '10. De ontwikkeling van Willemstad', '', 'inherit', 'closed', 'closed', '', '25-revision-v1', '', '', '2017-05-09 15:32:22', '2017-05-09 13:32:22', '', '25', 'http://canon.bramperry.nl/25-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('27', '1', '2017-05-09 15:32:55', '2017-05-09 13:32:55', 'De eerste activiteit van de <a href=\"https://canoncuracao.cw/3-verovering-van-curacao-door-de-wic-en-de-komst-van-de-hollanders/\">West-Indische Compagnie</a> na de verovering van Curaçao in 1634 was het bouwen van een versterking, Fort Amsterdam. Rond dit fort ontstond de eerste nederzetting: Punda en de directe omgeving.\r\n\r\nOm voedsel voor de lokale bevolking te produceren stimuleerde de W.I.C. de vestiging van <a href=\"https://canoncuracao.cw/13-plantagesysteem-op-curacao/\">plantages</a>, die verspreid kwamen te liggen over het hele eiland. Alleen de minder goede gronden, de zogenaamde ‘savaangronden’, bleven in handen van de overheid. Op alle plantages werden in het zicht van de eigenaarswoning kleine lemen huisjes met daken van maisstrengels voor de slaafgemaakte bevolking neergezet, de zogenaamde <em>kas di pal’i maishi</em>. Na de afschaffing van de slavernij bleven deze dorpskernen meestal bestaan, met name in Bandabou (het westelijk deel van het eiland). De meeste ex-slaven bleven werken onder <a href=\"https://canoncuracao.cw/14-afschaffing-slavernij/\"><em>paga tera</em></a>-verhoudingen, d.w.z. dat zij een hun toegewezen stukje grond op de plantage konden bewerken voor eigen gebruik mits zij enige dagen per jaar zonder betaling werkzaamheden voor de plantage-eigenaar verrichtten en een deel van hun productie afstonden. Geleidelijk aan, vooral door conflicten met de plantage-eigenaren en achteruitgang van de plantage-productie verdwenen de meeste van deze buurtgemeenschappen. De dorpjes Knip en Soto zijn hierop uitzonderingen.\r\n\r\nIn de negentiende eeuw ontstonden er aanvullende en later deels vervangende nederzettingskernen op initiatief van de R.K. kerk. <a href=\"https://canoncuracao.cw/20-komst-religieuze-ordes-nederland-en-betekenis/\">Mgr. Niewindt</a> wilde godsdienst en <a href=\"https://canoncuracao.cw/41-onderwijs-op-curacao/\">onderwijs </a>brengen aan de buiten de stad woonachtige donkere bevolking. Daarom verdeelde hij het gebied buiten het stadsdistrict in een beperkt aantal grote parochies op goed bereikbare plaatsen. In de centra kwamen een kerkje en een <em>kunukuschooltje</em> (plattelandschooltje). Hier omheen ontwikkelden zich de eerste kerkdorpen, beginnend met Barber, daarna Santa Rosa en Santa Maria. Later werden de parochies opgesplitst en zo ontstonden bijvoorbeeld de parochies San Willibrordo en Montagne. In deze nederzettingen vestigden zich ex-slaven, die zich losmaakten van de plantages en het paga tera-systeem.\r\n\r\nNaast deze kerkelijke initiatieven waren er ook woonkernen van vrije lieden te Westpunt, San Pedro, Seru Fortuna en Boka Sami.\r\n\r\nNaast deze kernen ontstonden weer andere buurtschappen doordat al in de achttiende eeuw vrije lieden zich verspreid vestigden op de savaangronden. Deze ontwikkeling ging na de afschaffing van de slavernij door. Andere buurtschappen ontstonden doordat de overheid, vooral aan het eind van de negentiende eeuw, percelen domeingrond ging uitgeven. In het begin van de twintigste eeuw kocht de overheid ook plantages op om deze gronden te verkavelen in kleine percelen, waar men een huisje op kon bouwen en aan kleinlandbouw kon doen. Dit gebeurde bijvoorbeeld o.a. in Pannekoek, Dokterstuin, Flip en Mahuma. De kleinlandbouw leverde in de meeste gevallen niet voldoende op om van te kunnen leven.\r\n\r\nMet de komst van de <a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">Shell</a> breidde de stad zelf zich als een inktvlek uit en wel rondom het Schottegat. Naast de zelfbouwactiviteiten van onder andere lokale arbeiders, bouwde de raffinaderij woonwijken voor het hoger en middenkader en voor de buitenlandse werknemers.', '11. De ontwikkeling van bewoning buiten Willemstad', '', 'publish', 'closed', 'closed', '', '11-ontwikkeling-nederzettingen-en-barios-buiten-willemstad', '', '', '2020-01-28 16:21:05', '2020-01-28 15:21:05', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=27', '10', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('28', '1', '2017-05-09 15:32:55', '2017-05-09 13:32:55', '', '11. De ontwikkeling van nederzettingen en barios buiten Willemstad', '', 'inherit', 'closed', 'closed', '', '27-revision-v1', '', '', '2017-05-09 15:32:55', '2017-05-09 13:32:55', '', '27', 'http://canon.bramperry.nl/27-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('29', '1', '2017-05-09 15:33:20', '2017-05-09 13:33:20', 'Manuel Carlos Piar (1774 – 1817) en Luis Brion (1782-1821) waren tijdgenoten die veel met elkaar gemeen hadden. Om te beginnen hun geboorteplaats, ze werden allebei in Otrobanda geboren. Ook deelden ze de belangrijke ideeën van hun tijd over vrijheid, gelijkheid en onafhankelijke naties. Beiden verdedigden ze Curaçao tegen een <a href=\"https://canoncuracao.cw/9-curacao-rond-1800/\">Engelse inval in 1804</a>. Ze steunden beiden Simon Bolívar als de leider van de Zuid-Amerikaanse onafhankelijkheidsstrijd en onderscheidden zich beiden door het winnen van belangrijke zee- en veldslagen. Brion, als kundig zeeofficier en belangrijke financier, werd admiraal onder Bolívar en Piar was een van de belangrijkste generaals van zijn bevrijdingsleger. Beiden waren vrijmetselaar. Beiden stierven een tragische dood: Piar werd terechtgesteld en Brion stierf berooid en in de steek gelaten door Bolívar in Curaçao.\r\n\r\nHun achtergrond verschilt echter aanzienlijk. Luis Brion, zoon van succesvol zakenman Pierre Brion en María Detrox, vertrok al jong als student naar Nederland en streed in 1799 in dienst van het leger van de Bataafse Republiek tegen de Engelsen. Toen Curaçao bezet was door de Engelsen (1800-1803) ging hij economie en scheepvaartkunde studeren in de Verenigde Staten. In 1803, nadat het eiland weer in Nederlandse handen was, keerde hij terug naar Curaçao en werd zakenman en reder. In 1805 werd hij benoemd tot commandant op Fort Beekenburg. Hij wist op 20 juni 1806 de Engelsen, die opnieuw probeerden het eiland te veroveren, te verjagen. In 1813 verbond Brion zijn leven aan de onafhankelijkheidsstrijd van Bolívar en werd één van zijn trouwste volgelingen. en bekleedde zelfs voor korte tijd een van de hoogste posten in de revolutionaire regering\r\n\r\nManuel Piar, zoon van María Isabel Gomez, een <a href=\"https://canoncuracao.cw/15-opbouw-samenleving-19e-eeuw-verschillende-bevolkingsgroepen/\">mulattin</a>, en de zeeman Fernando Piar was, in tegenstelling tot Brion, van eenvoudige komaf. Met zijn moeder en broers vertrok hij als jongen naar <a href=\"https://canoncuracao.cw/45-relatie-venezuela/\">Venezuela</a>, waar hij in contact kwam met militairen en jonge revolutionairen. In 1798 was hij in Curaçao waar hij met Maria Martha Boom trouwde. In 1806 was hij vanuit Aruba betrokken bij een mislukte invasie van Francisco de Miranda in Venezuela. Zijn militaire ervaring stelde hij vanaf 1810 in dienst van de bevrijding van Venezuela.  Hij verschilde echter van strategisch inzicht met Bolívar. Zo wees hij Bolívar er herhaaldelijk op dat voor de bevrijding van Venezuela de bezetting van Guyana nodig was maar Bolívar weigerde dat in te zien. Piar, de hoogste kleurling in de <em>’independente</em>’ gelederen, veroverde bij de slag bij San Felix op 11 april 1817 Guyana. De eer ging echter naar Bolívar. Piar kon dat niet verkroppen en nam daarom ontslag. Hij werd gearresteerd en door een krijgsraad, onder voorzitterschap van Brion, veroordeeld en met instemming van Bolívar in 1821 geëxecuteerd. In 1827 werd hij echter door Bolívar zelf weer gerehabiliteerd.\r\n\r\nPiar en Brion behoren beiden tot de nationale helden van Venezuela. Beelden van de twee Curaçaoënaars staan op een prominente plek op de <em>Avenida de los Pr</em><em>ó</em><em>ceres</em> in Caracas.', '12. Brion, Piar en Bolivar', '', 'publish', 'closed', 'closed', '', '12-brion-piar-bolivar', '', '', '2020-01-28 16:23:52', '2020-01-28 15:23:52', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=29', '11', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('30', '1', '2017-05-09 15:33:20', '2017-05-09 13:33:20', '', '12. Brion, Piar, Bolivar', '', 'inherit', 'closed', 'closed', '', '29-revision-v1', '', '', '2017-05-09 15:33:20', '2017-05-09 13:33:20', '', '29', 'http://canon.bramperry.nl/29-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('31', '1', '2017-05-09 15:33:42', '2017-05-09 13:33:42', 'In 1634 veroverde de <a href=\"https://canoncuracao.cw/3-verovering-van-curacao-door-de-wic-en-de-komst-van-de-hollanders/\">West-Indische Compagnie</a> het eiland Curaçao. De W.I.C. begon al snel met het opzetten van compagnieplantages met als doel het voedsel te verbouwen voor hun personeel en de als <a href=\"https://canoncuracao.cw/5-de-slavenhandel-en-slaverij/\">tot slaaf gemaakte</a> hierheen gebrachte Afrikanen. Naast deze compagnieplantages kwamen er al zeer snel particuliere plantages. Vrienden en familieleden van de bestuurders kregen grote terreinen in bruikleen en al heel snel was het grootste deel van Curaçao onderverdeeld in plantages.\r\n\r\nDeze grote landbouwbedrijven oefenden een vorm van gemengd bedrijf uit. Normaal gesproken bestond zo’n bedrijf uit drie onderdelen: een hofje, onbewerkt land (de ‘mondi’) en akkers die in de regentijd werden gebruikt (de ‘kunuku’s).\r\n\r\nHet hofje was bijna altijd gelegen aan het uiteinde van een rooistelsel, waar de verweringslaag veel dikker was en waar de grondwaterspiegel het hoogst was. Daar plantte men de vruchtbomen en werd er wat groente gekweekt. De mondi werd gebruikt om schapen, geiten en koeien te laten grazen. Daarnaast waren er akkertjes voor de regenafhankelijke akkerbouw. Het gewas dat op deze akkers verbouwd werd, was het droogtebestendige sorghum (‘maishi chikí’), afkomstig uit West-Afrika. Als het regenseizoen (van november tot januari) goed was, werd er veel geproduceerd, maar zeer vaak viel het regenseizoen tegen en mislukte de oogst. De maishi chikíwas met name bestemd voor de bewoners van de plantage, zowel voor de tot slaaf gemaakte oorspronkelijk Afrikaanse bevolking als voor de eigenaarsfamilie. Hier werd het volksvoedsel ‘funchi’ van gemaakt. Inkomen verkreeg men door de verkoop van vee en melkproducten, fruit, houtskool, watapana peulen, die gebruikt werden bij het vervaardigen van looistof. Op sommige plantages werd ook verdiend aan de zoutwinning.\r\n\r\nDe meeste plantages waren niet erg rendabel, maar het bezit van een plantage was zeer belangrijk voor de status van de eigenaren.\r\n\r\nDe eigenaren behoorden meestal tot de groep van “hoge <a href=\"https://canoncuracao.cw/15-opbouw-samenleving-19e-eeuw-verschillende-bevolkingsgroepen/\">blanke protestanten</a>” en zij woonden meestal in de landhuizen. De werkbevolking bestond oorspronkelijk uit tot slaaf gemaakte Afrikanen. Zij woonden in een buurtgemeenschap, gebouwd uit <em>kas di pal’i maishi</em> (eenvoudige huisjes, meestal met leem bestreken en met een dak dat meestal bestond uit maisstengels). Na de afschaffing van de <a href=\"https://canoncuracao.cw/5-de-slavenhandel-en-slaverij/\">slavernij</a> in 1863 bleven vele ex-slaven op de plantages wonen met de verplichting om een aantal dagen in het jaar voor de plantage-eigenaar te werken (het zogenaamde <em>paga tera-systeem</em>).', '13. Het plantagesysteem op Curaçao', '', 'publish', 'closed', 'closed', '', '13-plantagesysteem-op-curacao', '', '', '2020-01-28 16:26:05', '2020-01-28 15:26:05', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=31', '12', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('32', '1', '2017-05-09 15:33:42', '2017-05-09 13:33:42', '', '13. Het plantagesysteem op Curaçao', '', 'inherit', 'closed', 'closed', '', '31-revision-v1', '', '', '2017-05-09 15:33:42', '2017-05-09 13:33:42', '', '31', 'http://canon.bramperry.nl/31-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('33', '1', '2017-05-09 15:33:57', '2017-05-09 13:33:57', 'Op 1 juli 1863 kondigde Koning Willem III de vrijheid van <a href=\"https://canoncuracao.cw/5-de-slavenhandel-en-slaverij/\">slavernij</a> in de Nederlandse kolonies af. Ongeveer een derde deel van de totale bevolking van Curaçao verkreeg op dat moment de vrijheid. De slaveneigenaars kregen een vergoeding van 200 gulden voor het vrijlaten van iedere tot slaaf gemaakte, maar de vrijgemaakten kregen zelf niets. In tegenstelling tot in Suriname bestond op Curaçao niet de verplichting om onder staatstoezicht nog tien jaar te werken voor een <a href=\"https://canoncuracao.cw/13-plantagesysteem-op-curacao/\">plantage-eigenaar</a>.\r\n\r\nDirect na de emancipatie was het moeilijk een stuk grond te krijgen voor het verbouwen van eigen voedsel en het bouwen van een huis. De meeste vruchtbare gronden waren reeds in handen van de plantage-eigenaren. Sommige vrijgemaakten bleven om die reden bij de <em>shons </em>(plantage-eigenaren) wonen op basis van het zogenoemde <em>paga tera systeem</em>, waarbij zij verplicht waren in ruil voor dit stuk grond een aantal dagen per jaar onbetaald voor de plantagehouders te werken. Ook dienden ze, op het moment dat de maïs geoogst was, de shon dit te laten weten, zodat hij de koeien langs kon sturen om de stengels op te eten. Als men weigerde om zich te houden aan deze  paga tera-verplichting, doordat men  bijvoorbeeld ergens anders werkte, kreeg men de zogenaamde <em>ora di porta</em>, waarbij  men de aanzegging kreeg om binnen 24 uur te vertrekken van de plantage. Men moest dan met het gezin heel snel ergens anders onderdak zien te vinden.\r\n\r\nHet bezit van een stuk grond was voor velen een garantie voor de fel begeerde onafhankelijkheid ten opzichte van de plantagehouders. Tegen het einde van de negentiende eeuw begon de overheid een <a href=\"https://canoncuracao.cw/11-ontwikkeling-nederzettingen-en-barios-buiten-willemstad/\">actief beleid</a> te voeren om gouvernementsgronden aan particulieren te verhuren.\r\n\r\nIn de stad konden de vrijgemaakten werk vinden als sjouwer in de haven bij het laden en lossen van schepen. Sommigen kregen na 1875 werk bij de <a href=\"https://canoncuracao.cw/19-mijnbouw/\">fosfaatwinning</a> op de Tafelberg bij Nieuwpoort. Ook de zeevaart vormde voor de vrijgemaakten een belangrijke bron van werkgelegenheid. Vrouwen konden werken als dienstboden op de plantages of in de stad en in de hoedenvlechterij. In de periode na de emancipatie draaide de economie echter niet goed en er heerste veel armoede, met name onder de zojuist vrijgemaakten.\r\n\r\nDe koloniale overheid poogde om via regelgeving het, in de ogen van de overheid vaak ongewenste sociale gedrag van de vrijgemaakten, te beïnvloeden. Zo werd bijvoorbeeld een verordening tegen zwerverij aangenomen. Ook de rooms-katholieke kerk spande zich in om mensen volgzaam te maken. Met name de <em>tamb</em><em>ú</em> was een doorn in het oog van de autoriteiten.\r\n\r\nMet de komst van de <a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">olie-industrie</a> en de industrialisatie in het eerste kwart van de twintigste eeuw ontstond er een breuk in de sociale geschiedenis van het eiland. De <a href=\"https://canoncuracao.cw/15-opbouw-samenleving-19e-eeuw-verschillende-bevolkingsgroepen/\">standenmaatschappij</a> kwam onder druk te staan en de verhoudingen tussen de groepen verschoof enigszins, waardoor de vrijgelatenen iets meer ruimte kregen om hun plaats in de maatschappij op te eisen.', '14. De afschaffing van de slavernij', '', 'publish', 'closed', 'closed', '', '14-afschaffing-slavernij', '', '', '2020-01-28 16:30:35', '2020-01-28 15:30:35', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=33', '13', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('34', '1', '2017-05-09 15:33:57', '2017-05-09 13:33:57', '', '14. De afschaffing van de slavernij', '', 'inherit', 'closed', 'closed', '', '33-revision-v1', '', '', '2017-05-09 15:33:57', '2017-05-09 13:33:57', '', '33', 'http://canon.bramperry.nl/33-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('35', '1', '2017-05-09 15:34:24', '2017-05-09 13:34:24', 'De Curaçaose maatschappij in de eerste helft van de negentiende eeuw was een typisch voorbeeld van een ‘slavenhoudersmaatschappij’, waarin de bewoners een vaste sociale status hadden die voornamelijk bepaald werd door hun huidskleur, blank, zwart of kleurling.\r\n\r\nDe voornaamste blanke bevolkingsgroepen op het eiland waren de protestantse Nederlanders en de <a href=\"https://canoncuracao.cw/4-nieuwe-bewoners-in-de-zeventiende-eeuw/\">sefardische joden</a>. De laatsten waren oorspronkelijk afkomstig uit Spanje of Portugal en waren via Nederland en Brazilië op Curaçao terecht gekomen.\r\n\r\nDe blanke bevolkingsgroepen waren de ‘heren’ in deze maatschappij en zij gedroegen zich ook conform het herengedragspatroon. Zij waren de bestuurders, ambtenaren, officieren, handelaren en reders. Zij woonden in <a href=\"https://canoncuracao.cw/10-ontwikkeling-willemstad/\">Willemstad</a> en omgeving en sommigen bezaten in de <a href=\"https://canoncuracao.cw/11-ontwikkeling-nederzettingen-en-barios-buiten-willemstad/\">buitendistricten</a> een <a href=\"https://canoncuracao.cw/13-plantagesysteem-op-curacao/\">plantage </a>waar slaven werkzaam waren. De protestantse Fortkerk en de joodse Synagoge in Willemstad waren uitsluitend toegankelijk voor deze twee groepen. De rooms-katholieke kerk ontfermde zich over de zorg van de zwarten en kleurlingen.\r\n\r\nCuraçao diende als slavenmarkt in de zeventiende en achttiende eeuw. Hier werden de uit Afrika ingevoerde slaven verhandeld met de regio. Slechts een kleine groep bleef achter om te werken in de landbouw, de zoutwinning of als huis- of ambachtsslaaf. Ook werkten sommige slaven als matrozen aan boord van de commerciële barkjes in de regio. De <a href=\"https://canoncuracao.cw/5-de-slavenhandel-en-slaverij/\">slavenhandel</a> werd in 1818 afgeschaft, maar in- en uitvoer met de regio bleef desondanks tot de <a href=\"https://canoncuracao.cw/14-afschaffing-slavernij/\">afschaffing van de slavernij</a> in 1863 voortbestaan. De tot slaaf gemaakte diende te voldoen aan het ‘slavengedragspatroon’: hij moest altijd werkzaam zijn, eerbied tonen en gehoorzaam zijn. De tot slaaf gemaakte werd als een object beschouwd. Vrouwelijke tot slaaf gemaakten waren vaak seksobjecten. De kinderen die zij baarden waren bezit van de eigenaar. Het was tot slaaf gemaakten niet toegestaan te trouwen.\r\n\r\nTot slaaf gemaakten werden door hun eigenaren soms vrijgelaten of ze kochten zichzelf of anderen vrij. Dit werd ‘manumissie’ genoemd. Als ze werden vrijgelaten door hun eigenaar, kon dat soms gezien worden als een gunst, maar het kwam nogal eens voor dat eigenaren oude en gebrekkige tot slaaf gemaakten  manumitteerden omdat ze dan niet langer voor hen hoefden te zorgen.\r\n\r\nDe heren- en slavengedragspatronen werden reeds in de achttiende eeuw bij de wet vastgesteld. Het doel was tot slaaf gemaakten en voormalig tot slaaf gemaakten in een ondergeschikte positie te houden. Het was bijvoorbeeld voor tot slaaf gemaakten verboden om met meer dan 6 personen bijeen te zijn, om ‘s avonds na 9 uur zonder toestemming op straat te zijn, wapens of stokken te dragen en muziek te maken. Men mocht op commercieel gebied de blanke ook niet beconcurreren.\r\n\r\nDe kleurlingen werden ingedeeld naar hun kleurschakering, van licht tot donker. De gebruikte benamingen waren Liplap, Liesties, Poesties, Casties, Mesties, Grief, Sambo en Mulat. De mogelijkheden voor de kleurlingen om in deze maatschappij vooruit te komen waren, afhankelijk van hun kleur, in het algemeen gunstiger dan voor de zwarten.\r\n\r\nEr was in de negentiende-eeuwse Curaçaose maatschappij wel sprake van een zekere sociale mobiliteit en in de alledaagse praktijk was het klassensysteem niet alleen maar star. Met name kleurlingen konden op de sociale ladder stijgen en maatschappelijke posities innemen die voorheen uitsluitend voorbehouden waren aan blanken. Ze werden echter toch als tweederangs burgers gezien.', '15. De opbouw van de samenleving in de eerste helft van de negentiende eeuw', '', 'publish', 'closed', 'closed', '', '15-opbouw-samenleving-19e-eeuw-verschillende-bevolkingsgroepen', '', '', '2020-01-28 16:35:56', '2020-01-28 15:35:56', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=35', '14', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('36', '1', '2017-05-09 15:34:24', '2017-05-09 13:34:24', '', '15. De opbouw van de samenleving in de 19e eeuw: de verschillende bevolkingsgroepen', '', 'inherit', 'closed', 'closed', '', '35-revision-v1', '', '', '2017-05-09 15:34:24', '2017-05-09 13:34:24', '', '35', 'http://canon.bramperry.nl/35-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('37', '1', '2017-05-09 15:34:36', '2017-05-09 13:34:36', 'Fort Amsterdam is het oudste gebouw op Curaçao. Het werd in 1635, een jaar nadat de <a href=\"https://canoncuracao.cw/3-verovering-van-curacao-door-de-wic-en-de-komst-van-de-hollanders/\">West- Indische Compagnie</a> het eiland op de Spanjaarden had veroverd, gebouwd op de oostelijke oever van de Sint Annabaai. Dit betekent dat op Curaçao geen bouwwerken bewaard zijn gebleven uit de <a href=\"https://canoncuracao.cw/1-de-oorspronkelijke-bewoners/\">precolumbiaanse tijd</a> en de <a href=\"https://canoncuracao.cw/2-de-spaanse-periode/\">Spaanse periode (1499-1634)</a>.\r\n\r\nAan de noordzijde van Fort Amsterdam ontstond in de loop van de zeventiende eeuw een kleine nederzetting die ‘<a href=\"https://canoncuracao.cw/10-ontwikkeling-willemstad/\">De Willemstad</a>’ werd genoemd. De eerste huizen die hier werden gebouwd zijn beïnvloed door de architectuur uit Amsterdam. Kenmerkend zijn de hoge smalle voorgevels en de diepe zijgevels. De voorgevels zijn voorzien van tuitgevels waarop een rechthoekig lijstwerk is geplaatst met daarop een klein fronton. Deze eerste bouwstijl uit de zeventiende eeuw, die de Curaçaos-Hollandse stijl wordt genoemd, werd niet alleen toegepast in Willemstad maar ook bij de huizen op de plantages, de landhuizen.\r\n\r\nEen kenmerkend onderdeel van de traditionele architectuur op Curaçao zijn de galerijen. Dit waren aanvankelijk open houten of stenen constructies die tegen de voorgevels van de huizen in de stad werden geplaatst. Later werden galerijen een structureel onderdeel van gebouwen zowel binnen als buiten de stad.\r\n\r\nIn de achttiende eeuw kwam de Curaçaose Barok in de mode met zijn sierlijke gebogen gevellijnen en arcades. Deze uitbundige bouwstijl werd in de eerste helft van de negentiende eeuw afgewisseld door een sobere bouwstijl die weer teruggreep op de tuitgevel uit de zeventiende eeuw. De afmeting en detaillering waren echter eenvoudiger geworden, waardoor deze stijl te onderscheiden is van de oudere stijl.\r\n\r\nDoor invloeden vanuit Nederland en de Verenigde Staten ontwikkelde zich in de tweede helft van de negentiende eeuw het neoclassicisme, een bouwstijl die gebaseerd was op de architectuur van de Grieken en Romeinen. De meest kenmerkende elementen van deze stijl zijn de toepassing van zuilen en frontons (driehoeken). Het neoclassicisme is gebruikt voor zowel stadsvilla’s als eenvoudige woonhuizen en eveneens voor landhuizen.\r\n\r\nIn de eerste helft van de twintigste eeuw kwam Curaçao in contact met de internationale bouwstijl die ook wel het ‘nieuwe bouwen’ wordt genoemd. Ook in deze periode zijn er duidelijke invloeden in de bouwkunst waar te nemen uit zowel Europa als de Verenigde Staten. Zo is bijvoorbeeld de voorgevel van de voormalige bioscoop Cinelandia geïnspireerd door de Art Deco in Miami en het voormalige KNSM-gebouw door de architectuur van de Nederlandse architect Dudok.\r\n\r\nNaast de formele westerse bouwstijlen ontwikkelde zich ook een architectuur met duidelijke Afrikaanse invloeden. Op de <a href=\"https://canoncuracao.cw/13-plantagesysteem-op-curacao/\">plantages</a> bouwden de slaven hutten van leem die met stro van maïs werden afgedekt, de zogenaamde <em>kas di pal’i maishi</em>. Na de afschaffing van de <a href=\"https://canoncuracao.cw/5-de-slavenhandel-en-slaverij/\">slavernij</a> heeft dit gebouwtype zich ontwikkeld tot kleine eenvoudige woonhuizen van steen en later ook van hout. De indeling van de <em>kas di yerba</em> bleef lang het uitgangspunt. Verspreid over het eiland ziet men nog veel van deze huizen, met hun schuin aflopende muren, staan.\r\n\r\nDe gebouwen op Curaçao hebben een Caribisch karakter gekregen door de invloeden van een multiculturele samenleving en het klimaat. De opvallende bonte kleuren op de gevels gaan terug op een verordening uit 1817, waarmee gouverneur Kikkert de eigenaren verplichtte om de wit gekalkte voorgevels in de binnenstad een kleur te geven.', '16. Gebouwen', '', 'publish', 'closed', 'closed', '', '16-gebouwen', '', '', '2020-01-28 16:39:40', '2020-01-28 15:39:40', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=37', '15', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('38', '1', '2017-05-09 15:34:36', '2017-05-09 13:34:36', '', '16. Gebouwen', '', 'inherit', 'closed', 'closed', '', '37-revision-v1', '', '', '2017-05-09 15:34:36', '2017-05-09 13:34:36', '', '37', 'http://canon.bramperry.nl/37-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('39', '1', '2017-05-09 15:35:22', '2017-05-09 13:35:22', 'De verdediging van Curaçao is altijd een problematische zaak geweest. De <a href=\"https://canoncuracao.cw/2-de-spaanse-periode/\">Spanjaarden</a> deden nauwelijks moeite om het eiland te verdedigen, maar zij vonden het eiland dan ook niet zo belangrijk. De <a href=\"https://canoncuracao.cw/3-verovering-van-curacao-door-de-wic-en-de-komst-van-de-hollanders/\">Nederlanders</a> maakten van de grootste binnenbaai, het Schottegat, een marinebasis, goed verdedigd door <a href=\"https://canoncuracao.cw/10-ontwikkeling-willemstad/\">Fort Amsterdam</a> aan de ingang van de baai. Maar omdat baaien die geschikt waren om landingen uit te voeren verspreid lagen over de hele zuidkust, had men een probleem. Dat werd gedeeltelijk opgelost door de baaien die het dichtst bij de stad lagen, te voorzien van forten; Fort Beekenburg, Fort Piscadera en Fort Sint Michiel.\r\n\r\nIn 1713 toonde de Franse admiraal/kaper Cassard echter aan dat het mogelijk was in een van de baaien in het westelijk deel van het eiland te landen, op te trekken naar de stad en die vanaf de landzijde effectief te belegeren. Daarop werd besloten ook forten te bouwen bij o.a. Porto Marie (nu Daaibooibaai), Santa Cruz, Lagun, Knip en Westpunt. In de roerige tijden van de tweede helft van de achttiende eeuw kregen bijna alle kleine baaien een klein fort of een batterij. Op een heuvel boven de Sint Annabaai werd het ‘Fort Republiek’ gebouwd, dat nu Fort Nassau wordt genoemd.\r\n\r\nToen bleek echter nog meer hoe onverdedigbaar Curaçao eigenlijk was; er was nog net geld beschikbaar voor het bouwen van deze verdedigingswerken, maar er was geen geld om ze te bemannen en te onderhouden. De Engelsen konden dan ook in <a href=\"https://canoncuracao.cw/9-curacao-rond-1800/\">1804</a> zonder tegenstand landen aan de Piscaderabaai omdat de soldaten in het fort niet over kogels beschikten. Daarna konden ze de stad vanaf de landzijde aanvallen. Na de Engelse periode, die afliep in 1816, werd de verdediging van het eiland weer geconcentreerd op Willemstad. Het Waterfort en het Riffort werden aan de ingang van de Sint Annabaai gebouwd. Andere plannen werden wegens gebrek aan fondsen niet uitgevoerd.\r\n\r\nDe Venezolaanse opstandeling <a href=\"https://canoncuracao.cw/45-relatie-venezuela/\">Urbina</a> toonde in 1929 aan hoe gemakkelijk het bestuur van Curaçao onder druk gezet kon worden. Hij overviel met zijn manschappen, die al op het eiland verbleven, het Waterfort, maakte wapens buit en slaagde erin naar Venezuela te varen met medeneming van de Gouverneur. De verdediging van het eiland was toen weer eens minimaal. Er was zelfs geen stationsschip aanwezig.\r\n\r\nIn de <a href=\"https://canoncuracao.cw/25-tweede-wereldoorlog/\">Tweede Wereldoorlog</a> werd de verdediging van het eiland opnieuw aangepakt omdat de <a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">raffinaderij </a>belangrijk was voor de brandstofvoorziening van de geallieerden. Om vijandelijke schepen tegen te houden werden er twee flinke kustbatterijen gebouwd: die van de Nederlanders op Steenrijk en die van de Amerikanen bij Blauwbaai. Bij de olie-installaties van Bullenbaai werd een kleine (Nederlandse) kustbatterij neergezet, die daadwerkelijk in actie kwam tegen een aanvallende Duitse onderzeeboot en die ook wist te verdrijven. Ook kwamen er verschillende luchtafweer- en uitkijkposten.\r\n\r\nNa de Tweede Wereldoorlog werd de verdediging weer ingekrompen, maar er is nog altijd een contingent Nederlandse militairen en een stationsschip op het eiland aanwezig. Ook de Amerikanen hebben een luchtmachtbasis met verkenningsvliegtuigen op het eiland.', '17. De verdediging van Curaçao', '', 'publish', 'closed', 'closed', '', '17-verdediging-curacao-en-forten', '', '', '2020-01-28 16:43:49', '2020-01-28 15:43:49', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=39', '16', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('40', '1', '2017-05-09 15:35:22', '2017-05-09 13:35:22', '', '17. De verdediging van Curaçao en forten', '', 'inherit', 'closed', 'closed', '', '39-revision-v1', '', '', '2017-05-09 15:35:22', '2017-05-09 13:35:22', '', '39', 'http://canon.bramperry.nl/39-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('41', '1', '2017-05-09 15:35:55', '2017-05-09 13:35:55', 'Armoede, gebrek aan werk en weinig mobiliteitskansen fungeerden op Curaçao als voornaamste stimulans voor emigratie in de periode na de <a href=\"https://canoncuracao.cw/14-afschaffing-slavernij/\">emancipatie</a> van de tot slaaf gemaakten in 1863. In 1838 werd de emigratie van arbeidskrachten bij wet verboden en dit verbod bleef tot 1883 in stand.\r\n\r\nVele Curaçaose arbeiders emigreerden desondanks naar landen in de regio. Zo werd er op 9 juli 1863, acht dagen na de afschaffing van de slavernij, een contract opgesteld tussen 25 vrijgemaakten en een Venezolaanse werkgever om te gaan werken in <a href=\"https://canoncuracao.cw/45-relatie-venezuela/\">Venezuela</a>. Op 10 juli 1863 werd er opnieuw een contract getekend met 25 Curaçaose mannen, om in Venezuela te gaan varen met lichters. Dit gebeurde opnieuw op 16 juli 1863. Velen vertrokken echter ook zonder een contract te tekenen.\r\n\r\nLater in de eeuw, in 1882, vertrokken 46 mannen uit Curaçao voor werk bij de bouw van het Panama kanaal. Daar werden ze opgenomen in een grotere groep van in totaal 130.000 arbeiders uit de Engelse Cariben. In dezelfde periode vertrokken er Curaçaoënaars naar Venezuela, Costa Rica en Colombia. Zij gingen daar seizoensarbeid verrichten op de suikerriet- en bananenplantages.\r\n\r\nCuraçaose arbeiders vertrokken ook naar de Dominicaanse Republiek. In 1862, bijvoorbeeld, gingen enkele metselaars, timmerlieden en dagloners daar een jaar lang werken. Behalve ambachtslieden emigreerden er ook arbeiders om te werken op de suikerrietplantages. Dit gebeurde vooral tijdens de onafhankelijkheidsoorlogen op Cuba, toen de suikerproductie aldaar verlegd werd naar de Dominicaanse Republiek.\r\n\r\nDe arbeidsmigratie naar Cuba begon in 1917 en kende pieken in de jaren 1918, 1919 en 1920. Deze migratie drukte een onmiskenbaar stempel op Curaçao, omdat toen grote aantallen mensen vertrokken. Ongeveer 50% van de mannelijke arbeidskrachten op het eiland vertrok in groepsverband. In Cuba werkten zij samen met een nog groter aantal mensen uit <a href=\"https://canoncuracao.cw/47-de-andere-eilanden-van-de-nederlandse-antillen/\">Aruba, Bonaire</a>, de Engelse Cariben, Haïti, Puerto Rico en de Nederlandse <a href=\"https://canoncuracao.cw/47-de-andere-eilanden-van-de-nederlandse-antillen/\">Bovenwinden</a>.\r\n\r\nMigratie was niet alleen maar een mannenaangelegenheid. Ook vrouwen emigreerden. Soms sloten zij al op Curaçao een contract met hun werkgevers in het buitenland, zoals het geval was met yaya’s (kindermeisjes) en kokkinnen van Curaçaose families van joodse en protestantse afkomst die naar een ander Caribisch eiland waren verhuisd. Soms emigreerden deze vrouwen echter ook op eigen gelegenheid en vonden ze in het land van bestemming werk als wasvrouw, werkster, kindermeisje en dergelijke.\r\n\r\nZelfs na de komst van de <a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">olie-maatschappij</a> in 1915 bleef de migratie van Curaçaose arbeiders naar landen in de Caribische regio aanhouden. Dit bleef tot ongeveer 1923 het geval.', '18. Werkgelegenheid en emigratie tussen 1863 en 1920', '', 'publish', 'closed', 'closed', '', '18-werkgelegenheid-en-emigratie-1863-en-1920', '', '', '2020-01-28 16:47:46', '2020-01-28 15:47:46', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=41', '17', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('42', '1', '2017-05-09 15:35:55', '2017-05-09 13:35:55', '', '18. Werkgelegenheid en emigratie tussen 1863 en 1920', '', 'inherit', 'closed', 'closed', '', '41-revision-v1', '', '', '2017-05-09 15:35:55', '2017-05-09 13:35:55', '', '41', 'http://canon.bramperry.nl/41-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('43', '1', '2017-05-09 15:36:16', '2017-05-09 13:36:16', 'In het verleden waren de twee belangrijkste vormen van mijnbouw op Curaçao de zoutwinning en de fosfaatwinning.\r\n\r\nIn Nederland was in de zeventiende eeuw de haringvisserij een belangrijk bestaansmiddel, waarbij zout diende om de haring te conserveren. Door de Tachtigjarige Oorlog (1568 – 1648) kon men geen zout in Portugal en Spanje meer kopen. Men moest op andere plaatsen zout gaan zoeken en onder andere om deze reden werd Curaçao veroverd. Na het einde van deze oorlog was de zoutwinning op deze eilanden veel minder belangrijk voor Nederland en het Curaçaose zout ging vanaf toen vooral naar de Verenigde Staten en de Caribische eilanden.\r\n\r\nPas in de negentiende eeuw ging men over tot de aanleg van nieuwe zoutpannen en verbeterde men de bestaande zoutpannen, die vaak ook uitgebreid werden. De resten hiervan kunnen nog steeds bij vele binnenbaaien gevonden worden. In de saliña Sint Marie hadden de vier plantages Hermanus, Jan Kok, Rif Sint Marie en Siberië ieder hun eigen zoutpannen. In de Santa Marthabaai lagen de zoutpannen van de <a href=\"https://canoncuracao.cw/13-plantagesysteem-op-curacao/\">plantages</a> Groot Santa Martha, Klein Santa Martha en San Nicolas. De plantages die naast hun agrarische activiteiten ook zout wonnen, werden zoutplantages genoemd. Door vele problemen met de afzet van het zout en het gebrek aan arbeidskrachten ging de zoutwinning in de twintigste eeuw op Curaçao ten onder.\r\n\r\nIn 1871 werd op Klein Curaçao ‘guano’ (dat voornamelijk uit vogel-uitwerpselen bestaat) ontdekt door de Engelse ingenieur John Godden en in de jaren daarna werd de laag, die ongeveer een halve meter dik was, afgegraven en als mest voor landbouw verkocht.\r\n\r\nIn 1875 werden rijke fosfaatafzettingen gevonden bij de Tafelberg op Santa Barbara. Fosfaat ontstaat uit guano-afzettingen. Dit drong door neerslag het kalkgesteente in en werd omgevormd tot fosfaat. De fosfaat op Curaçao had een hoge marktwaarde, omdat het weinig fluor bevatte en daardoor ook gebruikt kon worden als pluimveevoer. Aan de Fuikbaai bouwde Godden de infrastructuur en de gebouwen bij het dorpje Nieuwpoort die nodig waren om de fosfaatproductie op poten te zetten. In de jaren tachtig van de negentiende eeuw ontstonden er echter conflicten tussen Godden en de mede-eigenaren: de wereldmarktprijzen daalden en John Godden wilde daarom minder royalty’s uitkeren aan de mede-eigenaren. Dit leidde toen toch niet tot een oplossing van de problemen en Godden stopte daarom in 1895 met de uitvoer. Dit had fatale gevolgen voor de werkgelegenheid en overheidsinkomsten. Pas na 17 jaren werd in 1912 de fosfaatwinning hervat. In de jaren daarna ging men verder met de ontginning. Het gehalte van fosfaat werd echter steeds minder en uiteindelijk werd in 1979 de fosfaatwinning stopgezet. De mijnmaatschappij is nog steeds actief, maar de productie werd beperkt tot kalksteen dat vooral voor de lokale bouwmarkt bestemd is.\r\n\r\n&nbsp;', '19. Mijnbouw', '', 'publish', 'closed', 'closed', '', '19-mijnbouw', '', '', '2020-01-28 16:51:34', '2020-01-28 15:51:34', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=43', '18', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('44', '1', '2017-05-09 15:36:16', '2017-05-09 13:36:16', '', '19. Mijnbouw', '', 'inherit', 'closed', 'closed', '', '43-revision-v1', '', '', '2017-05-09 15:36:16', '2017-05-09 13:36:16', '', '43', 'http://canon.bramperry.nl/43-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('45', '1', '2017-05-09 15:37:19', '2017-05-09 13:37:19', 'Vanaf de vroege Spaanse tijd werd Curaçao bezocht door overwegend uit de regio afkomstige Spaanssprekende katholieke priesters. Deze priesters verbleven tijdelijk op het eiland om de tot slaaf gemaakten te dopen en zielzorg te bieden. In 1715 werd Curaçao formeel een katholiek missiegebied. Pas na 1800 ging de zielzorg gaandeweg over van regionale priesters naar de Nederlandse katholieke kerk.\r\n\r\nDat de Nederlandse katholieke missie in deze kolonie begin negentiende eeuw werd versterkt hing waarschijnlijk samen met de grote onrust in de regio na de succesvolle <a href=\"https://canoncuracao.cw/9-curacao-rond-1800/\">slavenopstand in Haïti</a> aan het eind van de achttiende eeuw. Uiteindelijk werd in 1824 voor Curaçao een doortastende geestelijke aangesteld: monseigneur Martinus Niewindt. Hij bleef hier tot zijn dood in 1860 en legde het fundament voor een duurzame katholieke missie. Zijn prioriteit werd het dopen van alle Afro-Curaçaoënaars en de vorming van leefgemeenschappen in parochies. In deze periode legden enkele priesters zich toe op de ontwikkeling van het geschreven Papiaments.\r\n\r\nToen Rome in 1868 besloot om de verantwoordelijkheid voor dit vicariaat aan de Nederlandse provincie van de orde der Dominicanen te geven, was dat met als doel het ‘beschaven’ van de overwegend arme, maar gedoopte Afro-Curaçaose bevolking, circa 85% van de totale bevolking. De priesters waren overwegend Nederlanders; dit was tot 1970 een contractueel vastgelegde afspraak. De missie kreeg daarmee een koloniale inslag: niet het ontwikkelen van een lokale katholieke kerk, maar het ‘beschavingswerk’ binnen een Nederlands katholiek kader stond centraal.\r\n\r\nDe invloed van de katholieke kerk op de bevolking werd in de loop van de negentiende eeuw aanzienlijk met de komst van de Zusters van Breda in de gezondheidszorg en de Zusters van Roosendaal en Fraters van Tilburg in het onderwijs. In 1920 werden ook de Zusters van Schijndel aangetrokken om het onderwijs in de <a href=\"https://canoncuracao.cw/11-ontwikkeling-nederzettingen-en-barios-buiten-willemstad/\">buitendistricten</a> en op de <a href=\"https://canoncuracao.cw/41-onderwijs-op-curacao/\">arme scholen</a> in de stad over te nemen. Dit maakte deel uit van een steeds verder doorgevoerd klassenonderscheid. De katholieke kerk droeg op deze wijze onmiskenbaar bij aan klassenonderscheid binnen de Curaçaose maatschappij.\r\n\r\nVooral de door de <a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">raffinaderij</a> ontstane katholieke middenklasse, rond 1935 circa 15% van de bevolking, kon medio twintigste eeuw op de aandacht van de katholieke kerk rekenen. Deze aandacht bestond uit de ontwikkeling van een katholiek stedelijk verenigingsleven en de uitbreiding van de <a href=\"https://canoncuracao.cw/50-media/\">katholieke pers</a>. In de politiek was de Katholieke Partij tussen 1937 en 1962 actief. <span lang=\"NL\">Een brede </span><span lang=\"NL\">‘</span><span lang=\"NL\">volkspartij</span><span lang=\"NL\">’</span><span lang=\"NL\"> is de KVP nooit geworden; voor de katholieke volksklasse was het steunen van de KVP op geen enkele wijze vanzelfsprekend.</span>', '20. De komst van katholieke religieuzen uit Nederland', '', 'publish', 'closed', 'closed', '', '20-komst-religieuze-ordes-nederland-en-betekenis', '', '', '2020-11-19 09:37:01', '2020-11-19 08:37:01', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=45', '19', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('46', '1', '2017-05-09 15:37:19', '2017-05-09 13:37:19', '', '20. De komst van de religieuze ordes uit Nederland en hun betekenis', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2017-05-09 15:37:19', '2017-05-09 13:37:19', '', '45', 'http://canon.bramperry.nl/45-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('47', '1', '2017-05-09 15:37:46', '2017-05-09 13:37:46', 'In 1912 had Shell een concessie verworven in het Mene Grande-veld, ten Oosten van het Lago de Maracaibo in <a href=\"https://canoncuracao.cw/45-relatie-venezuela/\">Venezuela</a>. Twee jaar later besloten ze een kleine opslagplaats op Curaçao te bouwen. Toen echter in 1915 duidelijk werd dat het Mene Grande-veld boordevol olie zat, werd besloten een raffinaderij op het eiland te vestigen. De slechte bereikbaarheid van het Lago de Maracaibo en het stabiele bestuur van Curaçao, speelde een rol in deze keuze.\r\n\r\nIn de eerste jaren werd op Curaçao nog voor een groot deel olie uit Mexico verwerkt. Nadat Mexico in 1938 de olie industrie nationaliseerde, ging Shell exclusief Venezolaanse olie verwerken.\r\n\r\nTot het einde van 1920 waren er minder dan 300 mensen in dienst van de raffinaderij. Dit zou uitgroeien tot 10.924 (inclusief de Curaçaosche Scheepvaart Maatschappij) in 1929. In die jaren werden arbeiders geworven uit de regio en uit <a href=\"https://canoncuracao.cw/22-de-nieuwe-immigranten-op-curacao-vanaf-het-begin-van-de-twintigste-eeuw/\">Portugal</a>. Al deze arbeiders werden in nieuwe wijken gehuisvest, niet ver van het raffinaderijcomplex. Daarbij werden ook allerlei voorzieningen gebouwd zoals wegen, scholen, winkels, buurtcentra, telefoon- en waterleidingen.\r\n\r\nDe economische crisis van de jaren dertig bracht het personeelsbestand drastisch terug maar dit zou vanaf 1934 geleidelijk weer toenemen. Pas na 1945 kwam het personeelsaantal weer boven de 10.000 uit.\r\n\r\nIn de <a href=\"https://canoncuracao.cw/25-tweede-wereldoorlog/\">oorlogsjaren</a> speelden de raffinaderijen op op Curaçao en Aruba een belangrijke rol in de brandstofvoorziening van de Geallieerden. Duitsland zette vanaf februari 1942 duikboten in rond Curaçao en Aruba om deze brandstoftoevoer af te snijden. In de oorlogsjaren kreeg de raffinaderij toestemming een zogenaamd “asfalt-meer” aan te leggen vanwege het gebrek aan schepen om het te vervoeren.\r\n\r\nIn <a href=\"https://canoncuracao.cw/45-relatie-venezuela/\">Venezuela</a> werden de activiteiten op Curaçao en Aruba met afgunst bekeken. Na het overlijden van president Gómez (1935) was het sentiment gekeerd tegen de “uitverkoop van nationale rijkdom.” In 1943 werd daarom wetgeving aangenomen waardoor de Antilliaanse raffinaderijen geen olie uit nieuwe concessies mochten verwerken. Shell werd gedwongen te investeren in een nieuwe raffinaderij in Venezuela, ten koste van de raffinaderij op Curaçao. De Shell-raffinaderij van Cardón, startte in 1947 haar activiteiten. In Venezuela ging men er in 1943 van uit dat de oude concessie nog ca. 10 jaar olie zou leveren voor Curaçao.\r\n\r\nShell berekende in 1954 echter dat de oude concessie nog zeker 15 jaar olie zou leveren. Hoewel de raffinaderij volgens die berekening dus tot 1969 op de oude concessie zou kunnen draaien, werd de raffinaderij ondertussen wel afgeslankt, met een reductie van 75% van het personeelsbestand tussen 1954 en 1969. Er werd nauwelijks meer gemoderniseerd of uitgebreid. In 1959 speelde ook de Amerikaanse import restricties op olieproducten de kop op. Op verzoek van m.n. de Texaanse olieproducenten ging de Verenigde Staten over op (tijdelijke) importquota. De Verenigde Staten importeerden in 1958 voor ruim 337 miljoen dollar aan olieproducten uit Curaçao en Aruba. De raffinaderij was in die periode verantwoordelijk voor meer dan helft van alle afgedragen loonbelasting op Curaçao en zorgde voor 37% van alle winstbelasting.\r\n\r\nIn de jaren zestig werd het systeem van “onderaannemers” ingevoerd waarbij arbeiders via externe bedrijven werden ingehuurd. Het arbeidsconflict over \'equal work - equal pay\' voor onderaannemers en Shell arbeiders, werd een directe aanleiding tot de uitbarsting die bekend werd onder de naam “<a href=\"https://canoncuracao.cw/30-dertig-mei-1969/\">30 mei 1969</a>”.', '21. De komst van de olie-industrie', '', 'publish', 'closed', 'closed', '', '21-de-komst-van-de-olie-industrie', '', '', '2020-11-19 09:38:01', '2020-11-19 08:38:01', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=47', '20', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('48', '1', '2017-05-09 15:37:46', '2017-05-09 13:37:46', '', '21. De komst van de olie-industrie', '', 'inherit', 'closed', 'closed', '', '47-revision-v1', '', '', '2017-05-09 15:37:46', '2017-05-09 13:37:46', '', '47', 'http://canon.bramperry.nl/47-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('49', '1', '2017-05-09 15:38:39', '2017-05-09 13:38:39', 'In het begin van de twintigste eeuw kwam een grote immigratiestroom richting Curaçao op gang. Dit was het directe gevolg van de vestiging van een grote Shell-<a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">raffinaderij </a>op het eiland, die behoefte had aan veel arbeidskrachten, zowel om de olieraffinaderij te bouwen als om deze te laten draaien. Veel Curaçaoënaars werden in dienst genomen, maar al gauw moesten noodgedwongen ook werklieden uit andere landen gehaald worden. Velen kwamen op contractbasis.\r\n\r\nNaast veel Nederlandse employees en werklieden kwamen de werknemers vooral van de andere eilanden van de <a href=\"https://canoncuracao.cw/47-de-andere-eilanden-van-de-nederlandse-antillen/\">Nederlandse Antillen</a>, uit Suriname, <a href=\"https://canoncuracao.cw/45-relatie-venezuela/\">Venezuela</a> en Colombia, maar ook van de Britse en Franse eilanden in het Caribisch gebied en zelfs van Madeira. In het begin kwamen voornamelijk mannen maar later ook vrouwen, van wie sommigen in het kader van de gezinshereniging. Zij gingen vaak als hulp in de huishouding werken. Er kwamen in deze tijd niet alleen arbeidsimmigranten naar Curaçao, maar ook kleine handelaren uit Libanon, Centraal- en Oost-Europa (met name de Ashkenazische joden), India en China, die door de economische vooruitgang werden aangetrokken.\r\n\r\nAlleen in jaren van crisis (1930-1935) en <a href=\"https://canoncuracao.cw/25-tweede-wereldoorlog/\">oorlog</a> (1939-1944) daalde de immigratie, maar direct daarna werd Curaçao weer een echt vestigingsland met zeer veel verschillende nationaliteiten. In 1936 waren de meeste immigranten afkomstig van Engelssprekende eilanden, Nederland en Suriname, maar de Portugezen uit Madeira vormden in 1951 het grootste contingent. Aangezien het voornamelijk arbeidsmigranten betrof, bleven de meesten maar korte tijd op Curaçao. De nakomelingen van degenen die zich hier permanent vestigden, wonen nu al meerdere generaties op het eiland en zijn goed geïntegreerd.\r\n\r\nDoordat de oliemarkt veranderde en door automatisering liep de <a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">werkgelegenheid</a> op de raffinaderij sterk terug in de jaren vijftig en zestig, met als gevolg dat veel arbeidscontractanten werden ontslagen en naar elders vertrokken. Maar omdat de economie redelijk stabiel was, er relatief goede sociale voorzieningen waren, goede mogelijkheden voor opwaartse sociale mobiliteit en relatieve politieke rust, kwamen vanaf de jaren tachtig weer veel immigranten uit de regio naar Curaçao. Deze nieuwe instroom bestaat voornamelijk uit Colombianen, Dominicanen, Haïtianen en Jamaicanen. Zij werken vooral in de dienstverlenende sector en in de bouw. Een aantal van hen beschikt over de juiste immigratiedocumenten, maar er zijn ook veel ongedocumenteerde personen. In de laatste twintig jaar zien wij veel Chinese immigranten en meer recentelijk ook veel Venezolanen. In 2017 heeft van alle in Curaçao geboren personen 60% minstens één ouder die buiten Curaçao geboren is.', '22. De nieuwe immigranten op Curaçao vanaf het begin van de twintigste eeuw', '', 'publish', 'closed', 'closed', '', '22-de-nieuwe-immigranten-op-curacao-vanaf-het-begin-van-de-twintigste-eeuw', '', '', '2020-01-28 18:14:06', '2020-01-28 17:14:06', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=49', '21', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('50', '1', '2017-05-09 15:38:39', '2017-05-09 13:38:39', '', '22. De nieuwe immigranten op Curaçao vanaf het begin van de twintigste eeuw', '', 'inherit', 'closed', 'closed', '', '49-revision-v1', '', '', '2017-05-09 15:38:39', '2017-05-09 13:38:39', '', '49', 'http://canon.bramperry.nl/49-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('51', '1', '2017-05-09 15:38:52', '2017-05-09 13:38:52', 'Voor een eiland zijn havens van cruciaal belang. Vroeger, voor de komst van de luchtvaart, was de zeevaart de enige mogelijkheid voor verkeer van personen en goederen. Momenteel vindt veel vervoer van mensen plaats per vliegtuig, maar het vervoer van goederen gebeurt nog steeds veruit het meest per schip. Voor het laden en lossen van goederen zijn faciliteiten in rustig water met voldoende diepgang van essentieel belang.\r\n\r\nRustig water vinden we aan de zuidkust van Curaçao en vooral in de handvormige binnenbaaien en de toegang hiernaartoe. Vanaf het begin van de Nederlandse tijd werd dan ook met name de Sint Annabaai gebruikt als haven en in de twintigste eeuw vooral de handvormige binnenbaai daarachter, het Schottegat. De voornaamste havens zijn op dit moment de Sint Annabaai, het Schottegat, de <a href=\"https://canoncuracao.cw/35-oil-as-king-tot-tourism-as-king/\">megapieren</a> (de cruiseport voor het Rif) en Bullenbaai. In het verleden waren ook de Caracasbaai en Fuikbaai van belang.\r\n\r\nDe goede potentiële havenmogelijkheden van de Sint Annabaai waren een belangrijke reden voor de Nederlanders om Curaçao op de Spanjaarden te <a href=\"https://canoncuracao.cw/3-verovering-van-curacao-door-de-wic-en-de-komst-van-de-hollanders/\">veroveren</a>. In de tijd van de <a href=\"https://canoncuracao.cw/3-verovering-van-curacao-door-de-wic-en-de-komst-van-de-hollanders/\">West Indische Compagnie</a> (1634-1791) diende de Sint Annabaai als uitvalsbasis voor de kaapvaart en als strategische handelspost voor de <a href=\"https://canoncuracao.cw/5-de-slavenhandel-en-slaverij/\">slavenhandel</a> en andere handel (o.a. smokkelhandel) en later als vrijhandelshaven. In de <a href=\"https://canoncuracao.cw/9-curacao-rond-1800/\">Engelse tijd</a> (1800-1803 en 1807-1816) werd door de Engelsen besloten dat Curaçao zijn vrijhavenstatus moest opgeven, waardoor de havenactiviteiten drastisch inkrompen.\r\n\r\nIn de negentiende eeuw fungeerde de haven vooral als transitohaven, en ook was er veel smokkelhandel (contrabanda) met het nabij gelegen vasteland.\r\n\r\nPas met de komst van de <a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">raffinaderij</a> in het begin van de twintigste eeuw werd het Schottegat de belangrijkste haven vanwege de aanvoer van ruwe olie naar de raffinaderij die aan het Schottegat gelegen was. De geraffineerde olieproducten werden deels ook weer via het Schottegat/Sint Annabaai afgevoerd, maar de gevaarlijke lichte producten werden wegens ontploffingsgevaar per pijpleiding naar de Bullenbaai vervoerd, dat een diepe haven heeft en waar er nauwelijks sprake is van bewoning. De Caracasbaai diende onder andere voor de opslag en afvoer van zware producten en de brandstofinname van schepen (bunkeren).\r\n\r\nTijdens de <a href=\"https://canoncuracao.cw/25-tweede-wereldoorlog/\">Tweede wereldoorlog</a> waren de raffinaderij en de havens van Curaçao zeer belangrijk voor de toevoer van o.a. vliegtuigbenzine naar de geallieerde strijdkrachten. In de jaren vijftig werd de nieuwe containerhaven aangelegd in het oostelijk deel van het Schottegat, waardoor de werven aan de Sint Annabaai vooral voor passagiersschepen konden worden gebruikt. In het Schottegat is scheepsreparatie ook een belangrijke havenactiviteit.\r\n\r\nDoor de sluiting van het Suezkanaal in 1967 werden de olietankers, die nu weer de lange route langs Zuid-Afrika moesten varen, binnen korte tijd veel en veel groter en begon Shell met het ontwikkelen van Bullenbaai als overslaghaven, waar zeer grote olietankers ruwe aardolie vanuit het Midden-Oosten kwamen brengen die vervolgens werd overgeladen in kleinere tankers, die de ruwe olie daarna naar o.a. de Verenigde Staten vervoerden. Momenteel is Bullenbaai vooral als opslagplaats voor olie zeer belangrijk.', '23. De haven', '', 'publish', 'closed', 'closed', '', '23-de-haven', '', '', '2020-01-28 18:17:39', '2020-01-28 17:17:39', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=51', '22', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('52', '1', '2017-05-09 15:38:52', '2017-05-09 13:38:52', '', '23. De haven', '', 'inherit', 'closed', 'closed', '', '51-revision-v1', '', '', '2017-05-09 15:38:52', '2017-05-09 13:38:52', '', '51', 'http://canon.bramperry.nl/51-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('53', '1', '2017-05-09 15:39:11', '2017-05-09 13:39:11', 'De arbeidersbeweging op Curaçao ontstond aan het begin van de twintigste eeuw. In het begin had de R.K. kerk veel invloed. In 1919 was de R.K. Volksbond opgericht door Antoine Pijpers en deze organisatie speelde een belangrijke rol in de beginjaren van de arbeidersbeweging. Het doel van deze bond was de arbeider geestelijk te verheffen en zijn sociale en economische positie te verbeteren, dit alles op basis van <a href=\"https://canoncuracao.cw/20-komst-religieuze-ordes-nederland-en-betekenis/\">katholieke principes</a>.\r\n\r\nDe katholieke priesters, zoals Pater Verriet, hadden de leiding over de eerste vakbonden. De R.K. Volksbond trad onder andere ook op als een soort vakbond, bijvoorbeeld tijdens de havenstaking van 1922. De rol van de R.K. Volksbond werd tijdens de staking echter overgenomen door een echte havenvakbond, de Liga di Trahadornan di Haf, later omgedoopt tot Liga San Telmo, die daarmee het voortouw nam voor de moderne arbeidersbeweging.\r\n\r\nIn de jaren veertig van de twintigste eeuw nam de invloed van de katholieke kerk op de arbeidersbeweging af. Haar plaats werd ingenomen door nieuw opgerichte politieke partijen, zoals de Democratische Partij (DP), die in 1944 werd opgericht. Prominente partijleden, zoals Ciro Kroon en Reggie Venloo, waren actief betrokken bij de oprichting van de vakbond voor werkers in de olie- industrie (PWFC) en de oprichting van de ‘Curaçaose Federatie van Werknemers’ (CFW). Zij speelden ook een belangrijke rol bij de mijnwerkersstaking in 1955. De DP nam in 1955 ook het initiatief voor de afschaffing van het verbod om te staken en leverde een belangrijke bijdrage aan het tot stand brengen van het Algemene Ouderdomspensioen.\r\n\r\nOver het algemeen hadden de opeenvolgende regeringen vaak onvoldoende oog voor de wensen van de vakbonden, waardoor, vooral in de jaren zestig, (wilde) stakingen ervoor moesten zorgen dat looneisen en eisen voor medezeggenschap werden ingewilligd. Dit culmineerde in de opstand van <a href=\"https://canoncuracao.cw/30-dertig-mei-1969/\">30 mei 1969</a>.\r\n\r\nDe jaren zeventig verliepen voorspoedig voor de vakbonden omdat zowel bij de overheid als het bedrijfsleven het besef doordrong dat participatie van de arbeidersbeweging van essentieel belang was voor de economische en sociale ontwikkeling van het land.\r\n\r\nDe jaren tachtig vormden echter een negatieve periode. De crisis in het begin van de jaren tachtig leidde tot inkrimpingen en massa-ontslagen, met als gevolg een groot aantal stakingen. De arbeidersbeweging trachtte toen, door het geven van politieke stemadviezen, invloed uit te oefenen op de politiek om het getij zo te doen keren, maar met weinig resultaat. De verdeeldheid binnen de vakbeweging zelf was daar in grote mate debet aan.\r\n\r\nIn het begin van de jaren negentig werd een aantal grote stakingen georganiseerd tegen de bezuinigingen bij de overheid en in het onderwijs, voor de gelijktrekking tussen de salarissen van mannen en vrouwen in overheidsbetrekking en voor de indexering van de overheidssalarissen.\r\n\r\nIn 1997 richtte een aantal vakbonden een eigen politieke partij op, de Partido Laboral Krusada Popular (PLKP), om politieke invloed te verkrijgen. Hierover bestond in de arbeidersbeweging geen eensgezindheid omdat velen van mening waren dat dit de autonome positie van de vakbonden uitholde. Hoewel deze partij in het begin enig succes boekte, nam haar invloed zienderogen af totdat zij geen enkele rol meer speelde in de politiek.\r\n\r\nIn de periode na 2000 is er wereldwijd, en ook op Curaçao, sprake van een toenemende onmacht van de arbeidersbeweging, als gevolg van het neoliberale beleid van de overheid. De arbeidersbeweging heeft weinig invloed uitgeoefend op de staatkundige ontwikkelingen die zich tussen 2005 en 2010 voltrokken. Toen in de periode na 2010 de overheid wegens financieringstekorten vele bezuinigingsmaatregelen introduceerde, was de arbeidersbeweging, wegens onderlinge verdeeldheid en gebrek aan visie, niet in staat hiertegen adequaat op te treden en flankerend beleid af te dwingen.\r\n\r\nAls pluspunt kan worden genoemd dat de vakbeweging, die nu een strategie hanteert waarin de nadruk ligt op de dialoog en niet zozeer op stakingen, geleidelijk meer betrokken wordt bij het tripartiete overleg met de overheid en het bedrijfsleven, zoals dat plaatsvindt in de Sociaal Economische Raad (SER) en de Nationale Dialoog.\r\n\r\n&nbsp;\r\n\r\n&nbsp;', '24. De arbeidersbeweging', '', 'publish', 'closed', 'closed', '', '24-de-arbeidersbeweging', '', '', '2020-01-28 18:23:45', '2020-01-28 17:23:45', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=53', '23', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('54', '1', '2017-05-09 15:39:11', '2017-05-09 13:39:11', '', '24. De arbeidersbeweging', '', 'inherit', 'closed', 'closed', '', '53-revision-v1', '', '', '2017-05-09 15:39:11', '2017-05-09 13:39:11', '', '53', 'http://canon.bramperry.nl/53-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('55', '1', '2017-05-09 15:56:41', '2017-05-09 13:56:41', 'Op 10 mei 1940, onmiddellijk na de Duitse inval in Nederland, werden zeven Duitse schepen in de buurt van Curaçao in beslag genomen. De staat van beleg werd afgekondigd en diverse maatregelen werden genomen. Duitsers en Oostenrijkers, onder wie ook joden die hier woonden of hierheen gevlucht waren, werden in interneringskampen op Bonaire ondergebracht. Ook werden personen die verdacht werden van communistische of nationaal-socialistische sympathieën opgesloten.\r\n\r\nVanwege het strategische belang van de raffinaderij voor de Geallieerde oorlogsvoering werden op verzoek van de naar Londen gevluchte Nederlandse regering vanaf december 1940 Britse troepen op het eiland gestationeerd. Tot begin 1942 ondervond Curaçao weinig last van de oorlog. Dit veranderde spoedig. Na de Japanse aanval op de Amerikaanse vlootbasis te Pearl Harbour, op 7 december 1941, waren ook de Verenigde Staten in de oorlog betrokken. In februari 1942 werden de Britse troepen vervangen door Amerikaanse. De aanwezigheid van de Amerikaanse militairen bracht grote bedrijvigheid met zich mee, onder meer door de verbetering van de infrastructuur van het eiland.\r\n\r\nHet Caribisch gebied werd toen ook het doelwit van aanvallen door Duitse duikboten. De duikbotenoorlog in het Caribisch gebied werd “Operation Paukenschlag” genoemd. De Duitse duikboten probeerden de olietransporten van het Lago de Maracaibo naar Curaçao en de levering van olieproducten van Curaçao aan de Geallieerden te ondermijnen. Op 16 februari 1942 werd de eerste van de vele aanvallen uitgevoerd. Veel schepen en mensenlevens zijn door duikbootaanvallen verloren gegaan. Aan het Waaigat staat een monument ter herinnering aan de vele slachtoffers.\r\n\r\nHet koloniale bestuur kwam in grote problemen bij de ‘Chinezenincident’ in april 1942.\r\n\r\nNa de eerste aanvallen van de Duitse duikboten weigerden ongeveer 400 Chinese matrozen te gaan varen. Ze eisten meer veiligheid op de tankers en verhoging van hun loon met een oorlogstoeslag, zoals die ook werd toegekend aan andere zeevarenden. Toen er geen oplossing werd gevonden, werden de Chinese stakers in maart 1942 opgesloten in een kamp bij Suffisant. Daar ontstond op 20 april een opstand waarbij vijftien Chinezen werden doodgeschoten en vierenveertig gewond raakten. Niemand werd aansprakelijk gesteld voor dit dodelijk geweld.\r\n\r\nTijdens de oorlog werden vele hulpacties georganiseerd door verschillende hulporganisaties die opgericht werden met het doel om de oorlogsslachtoffers in Nederland te ondersteunen met geld, hulpgoederen en kleding. Enkele van deze organisaties waren het Comité ‘Steun Aan de Nederlandse Oorlogsslachtoffers Curaçao’ (SANOC), onder leiding van de arts Chris Engels, het ‘Comité Nederland’ van de werknemers van de C.P.I.M. (<a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">raffinaderij</a>) en het ‘Steunfonds Katholiek Nederland’.\r\n\r\nHet streven naar autonomie werd tijdens de oorlog versterkt met name door een rede die Koningin Wilhelmina hield op 7 december 1942, waarin ze naar <a href=\"https://canoncuracao.cw/28-het-statuut/\">autonomie</a> verwees.', '25. De Tweede Wereldoorlog', '', 'publish', 'closed', 'closed', '', '25-tweede-wereldoorlog', '', '', '2020-11-20 13:46:32', '2020-11-20 12:46:32', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=55', '24', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('56', '1', '2017-05-09 15:56:41', '2017-05-09 13:56:41', '', '25. De Tweede Wereldoorlog', '', 'inherit', 'closed', 'closed', '', '55-revision-v1', '', '', '2017-05-09 15:56:41', '2017-05-09 13:56:41', '', '55', 'http://canon.bramperry.nl/55-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('57', '1', '2017-05-09 15:57:00', '2017-05-09 13:57:00', 'Moises Frumencio da Costa Gomez werd geboren in Otrobanda op 27 oktober 1907, als zoon van Pedro da Costa Gomez en Braulia Bikker. Het gezin woonde eerst in Otrobanda en verhuisde later naar de Penstraat. Op zijn 15e ging hij na voltooiing van de MULO naar Nederland, waar hij vanaf 1923 in Nijmegen het gymnasium volgde. Van 1925 tot 1929 studeerde hij rechten aan de Universiteit van Nijmegen. De jonge jurist werkte daarna als substituut-griffier in Den Haag en als advocaat en procureur in Nijmegen. Tegelijkertijd werkte hij aan zijn dissertatie en promoveerde aan de Universiteit van Amsterdam op 3 december 1935 op het proefschrift <em>‘Het wetgevend orgaan van Curaçao. Samenstelling en bevoegdheid bezien</em> <em>in het kader van de Nederlandse Koloniale politiek’</em>. Hij pleitte als eerste Antilliaan in een proefschrift voor autonomie en algemeen kiesrecht voor de bevolking van de Nederlandse Antillen. Hij was toen 28 jaar oud en vertrok onmiddellijk na zijn promotie met zijn gezin naar Curaçao, waar zij op 31 december 1935 aankwamen.\r\n\r\nOp het eiland noemden ze hem al spoedig ’Doktoor’. Da Costa Gomez was een staatsman met grote verdiensten voor Curaçao, de Nederlandse Antillen en het Koninkrijk der Nederlanden. In 1935 formuleerde hij de visie dat de bevolking van de Antillen bereid en in staat was zichzelf te besturen. Hij zag autonomie als een instrument om economische, sociale en culturele vooruitgang te bereiken. Hij stelde zich in de jaren veertig als missie: zelfbestuur voor de Antillen, een bestuur dat verantwoording verschuldigd was aan een parlement dat via <a href=\"https://canoncuracao.cw/27-algemeen-kiesrecht/\">algemeen kiesrecht</a> was verkozen, zelfbestuur door de eilanden voor eilandelijke zaken en samenwerking en bijstand tussen de delen van het koninkrijk. Zijn gedachtegoed paste goed in de tijdgeest: ook op de andere Caribische eilanden leefde de wens om zich los te koppelen van de kolonisator.\r\n\r\nHij had een enorme staat van dienst: hij verwoordde op inspirerende wijze de wens voor autonomie, hij droeg bij aan de bevordering van het politieke bewustzijn in de Antillen, hij organiseerde acties voor sociale ondersteuning in <em>Kas di Pueblo</em>, hij richtte de Nationale Volks Partij op en bevorderde de zelfwaardering van de arme kunuku-bewoners van Curaçao. Hij streefde op alle niveaus naar bestuurlijke samenwerking. Hij was een groot voorstander van een eigen universiteit. Hij trad op als leider van alle delegaties bij het autonomiestreven. Doktoor was de schakel tussen de Staten en de Nederlandse regering in Londen (1943) en in Den Haag (1947-1948). Hij was voorzitter of lid van diverse commissies voor het opstellen van staatsregelingen voor de Antillen en leverde een grote bijdrage aan de ontwerpen voor de gedeeltelijke autonomie van 1948, de interim-regeling van 1951 en het <a href=\"https://canoncuracao.cw/28-het-statuut/\">statuut </a>van 1954. Hij werd gezien als een zeer kundig spreker in de Staten. Hij stierf onverwacht op 22 november 1966.', '26. Dr. M. F. da Costa Gomez', '', 'publish', 'closed', 'closed', '', '26-dr-f-da-costa-gomez', '', '', '2020-01-28 18:27:58', '2020-01-28 17:27:58', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=57', '25', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('58', '1', '2017-05-09 15:57:00', '2017-05-09 13:57:00', '', '26. Dr. F da Costa Gomez', '', 'inherit', 'closed', 'closed', '', '57-revision-v1', '', '', '2017-05-09 15:57:00', '2017-05-09 13:57:00', '', '57', 'http://canon.bramperry.nl/57-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('59', '1', '2017-05-09 15:57:16', '2017-05-09 13:57:16', 'Op de Nederlandse Antillen werd in 1948 het algemeen kiesrecht voor zowel mannen als vrouwen, voor iedere ingezetene vanaf 23 jaar, ingevoerd. Dat was dus zo’n 30 jaar later dan in Nederland (algemeen kiesrecht voor mannen 1917 en algemeen kiesrecht voor vrouwen 1919). De eerste algemene verkiezingen vonden plaats in maart 1949.\r\n\r\nDe strijd om het kiesrecht op Curaçao begon rond 1870. In een artikel in het blad Civilisadó uit 1874 wordt de klacht geuit tegen Koning Willem III dat het kiesrecht ‘ons uit hoofde van bedrog onthouden werd ….. omdat wij rijp en meer dan rijp zijn voor dat recht’. In verschillende artikelen in diverse bladen zoals ‘De Wekker’, ‘Curaçaosche Courant’, en ‘De Vrijmoedige’ verschijnen artikelen die gaan over het verruimen van het census en capaciteitskiesrecht. Het meest bekende artikel is waarschijnlijk dat van Abraham Chumaceiro getiteld ‘Zal het kiesrecht tot kannibalisme leiden’ uit 1893. Hierin pleitte hij voor verruiming van het censuskiesrecht voor de joodse bevolkingsgroep, waartoe hij zelf behoorde, en het donkergekleurde bevolkingsdeel.\r\n\r\nEén van de voorvechters van het kiesrecht was de Curaçaose jurist <a href=\"https://canoncuracao.cw/26-dr-f-da-costa-gomez/\">Mr. Moises da Costa Gomez</a>. Hij was in 1935 in Amsterdam gepromoveerd en in zijn proefschrift had hij betoogd dat de Curaçaose bevolking recht had op algemeen kiesrecht.\r\n\r\nTijdens de <a href=\"https://canoncuracao.cw/25-tweede-wereldoorlog/\">Tweede Wereldoorlog</a> had Koningin Wilhelmina meer zelfbestuur en autonomie aan de koloniën (Indonesië, Suriname en de eilanden in de West) beloofd. Op Curaçao werd in de laatste jaren van de Tweede Wereldoorlog in dag- en <a href=\"https://canoncuracao.cw/50-media/\">weekbladen</a> intensief gediscussieerd over het al dan niet invoeren van het algemeen kiesrecht. Een groep vrouwen, onder leiding van <a href=\"https://canoncuracao.cw/31-vrouwenemancipatie/\">Adèle Rigaud</a>, de toenmalige voorzitter van de vrouwenvleugel van de Katholieke Volks Partij (KVP), spande zich in om informatie over het algemeen kiesrecht te verspreiden onder de vrouwen van Curaçao. Zij verzamelden handtekeningen voor een vrouwenpetitie voor vrouwenkiesrecht gericht aan de Tweede Kamer in Nederland.\r\n\r\n&nbsp;\r\n\r\n&nbsp;', '27. Algemeen kiesrecht', '', 'publish', 'closed', 'closed', '', '27-algemeen-kiesrecht', '', '', '2020-11-19 09:39:09', '2020-11-19 08:39:09', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=59', '26', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('60', '1', '2017-05-09 15:57:16', '2017-05-09 13:57:16', '', '27. Algemeen kiesrecht', '', 'inherit', 'closed', 'closed', '', '59-revision-v1', '', '', '2017-05-09 15:57:16', '2017-05-09 13:57:16', '', '59', 'http://canon.bramperry.nl/59-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('61', '1', '2017-05-09 15:57:33', '2017-05-09 13:57:33', 'Het Statuut van het Koninkrijk der Nederlanden is de grondwet van het Koninkrijk en regelt de relatie tussen Nederland en de Caribische eilanden. Het Statuut werd ondertekend op 15 december 1954 in de Ridderzaal te Den Haag door Nederland, Suriname en het land de Nederlandse Antillen, dat bestond uit de <a href=\"https://canoncuracao.cw/47-de-andere-eilanden-van-de-nederlandse-antillen/\">zes eilanden</a>, Aruba, Bonaire, Curaçao, Sint Maarten, Sint Eustatius en Saba.\r\n\r\nIn 1975 werd Suriname een zelfstandig land. Aruba trad in 1986 uit de constellatie van de Nederlandse Antillen en kreeg een aparte status binnen het Koninkrijk. In <a href=\"https://canoncuracao.cw/34-staatkundige-ontwikkelingen-vanaf-statuut-tot-10-oktober-2010/\">2010</a> werd het land ‘de Nederlandse Antillen’ opgeheven en werden Curaçao en Sint Maarten, net als Aruba, aparte landen binnen het Koninkrijk. Bonaire, Sint Eustatius en Saba kregen gezamenlijk de status van Nederlands gebiedsdeel in de Cariben en vallen nu bestuurlijk direct onder Nederland.\r\n\r\nDe volgende drie grondbeginselen zijn opgenomen in het Statuut:\r\n<ol>\r\n 	<li>De landen binnen het koninkrijk behartigen zelfstandig hun eigen belangen.</li>\r\n 	<li>Zij verzorgen op voet van gelijkwaardigheid de gemeenschappelijke belangen.</li>\r\n 	<li>Zij verlenen elkaar wederkerig bijstand.</li>\r\n</ol>\r\nDe gemeenschappelijke belangen die de landen binnen het <a href=\"https://canoncuracao.cw/34-staatkundige-ontwikkelingen-vanaf-statuut-tot-10-oktober-2010/\">Koninkrijk </a>gezamenlijk op voet van gelijkwaardigheid behartigen staan bekend als de ‘koninkrijksaangelegenheden’. Hiertoe behoren zaken betrekking hebbende op de handhaving van de onafhankelijkheid en verdediging van het Koninkrijk, buitenlandse betrekkingen, Nederlanderschap, waarborgen van de fundamentele rechten en vrijheden, de rechtszekerheid en de deugdelijkheid van het bestuur.\r\n\r\nDe vier voornaamste bestuursorganen van de landen Aruba, Curaçao en Sint Maarten zijn:\r\n<ol>\r\n 	<li>De Gouverneur, vertegenwoordiger van het hoofd van de regering van het koninkrijk en van de regering van het land.</li>\r\n 	<li>De Staten, het parlement, bestaande uit hooguit 21 leden. Om de vier jaar worden verkiezingen gehouden om de Staten te kiezen. Zij hebben als taak wetten goed te keuren of te verwerpen en de regering te controleren.</li>\r\n 	<li>De Raad van Ministers, het kabinet, steunt op de meerderheid in de Staten. Samen met de Gouverneur vormen de ministers de Regering. De ministers zijn verantwoording verschuldigd aan de Staten. De gouverneur is onschendbaar.</li>\r\n 	<li>De Raad van Advies adviseert bij het maken van wetten.</li>\r\n</ol>\r\nTer behartiging van de belangen van elk der landen maken drie ‘gevolmachtigde ministers’ van Curaçao, Aruba en Sint Maarten deel uit van de Rijksministerraad van het Koninkrijk in Nederland. Ook in de Raad van State, het adviescollege van zowel de regering in Nederland als het koninkrijk, is een vertegenwoordiger aanwezig van elk der landen.', '28. Het statuut', '', 'publish', 'closed', 'closed', '', '28-het-statuut', '', '', '2020-11-20 13:42:53', '2020-11-20 12:42:53', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=61', '27', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('62', '1', '2017-05-09 15:57:33', '2017-05-09 13:57:33', '', '28. Het statuut', '', 'inherit', 'closed', 'closed', '', '61-revision-v1', '', '', '2017-05-09 15:57:33', '2017-05-09 13:57:33', '', '61', 'http://canon.bramperry.nl/61-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('63', '1', '2017-05-09 15:57:58', '2017-05-09 13:57:58', 'In de Curaçaose samenleving hebben vrouwen verschillende posities gehad. Men kende tot slaafgemaakte vrouwen, vrije vrouwen maar ook vrouwelijke plantagehouders. Na de afschaffing van de slavernij op <a href=\"https://canoncuracao.cw/18-werkgelegenheid-en-emigratie-1863-en-1920/\">1 juli 1863 </a>bleef deze sociale ongelijkheid ook onder vrouwen voortbestaan. Vrouwen trokken naar de stad of soms ook naar het buitenland om werk te zoeken. Zij werkten vaak als huisbediende of kindermeisje (‘yaya’), of in de hoedenvlechterij, die een bloeiperiode kende in de eerste decennia van de twintigste eeuw.\r\n\r\nTerwijl de Curaçaose vrouw van Afrikaanse afkomst moest werken om te overleven, was het de vrouwen van de elitaire gezinnen niet toegestaan om betaald werk uit te voeren. Vrouwen van elitaire families deden liefdadigheids werk maar droegen ook hun steentje bij aan de emancipatie van de vrouw.\r\n\r\nEen belangrijke mijlpaal in de vrouwenemancipatiebeweging op Curaçao was de strijd voor het <a href=\"https://canoncuracao.cw/27-algemeen-kiesrecht/\">algemeen kiesrecht</a> van de vrouw, dat mede mogelijk werd gemaakt door de inzet van de vrouwen van de Katholieke Volkspartij, onder leiding van Adèle Rigaud en later de <em>Damanan di Djarason,</em> zogenoemd omdat zij altijd op woensdag bijeen kwamen. Deze vrouwenorganisaties hebben huis aan huis handtekeningen verzameld voor een speciale petitie gericht aan de Koloniale Raad in Den Haag met het verzoek vrouwen het algemene kiesrecht te verschaffen. Dit werd een feit in 1948, tegelijkertijd met het algemeen kiesrecht voor mannen. In Nederland hadden vrouwen in 1919 al kiesrecht gekregen.\r\n\r\nVrouwen mochten na hun huwelijk, volgens de Landsverordening Materieel Ambtenarenrecht  (LMA) niet meer in dienst zijn van de overheid. De eerste aanzet tot verandering van deze wetgeving vond plaats in 1968 en in 1975 werd de officiële wetsaanpassing aangenomen. Na deze wetsaanpassing werden ook andere discriminerende wettelijke bepalingen tegen vrouwen geschrapt, zodat vrouwen, die eerder niet het recht hadden om hun eigen financiële en juridische zaken te regelen zonder de toestemming van hun echtgenoot, dat nu zelfstandig konden doen.\r\n\r\nDe vrouwenemancipatiebeweging en ook het <a href=\"https://canoncuracao.cw/24-de-arbeidersbeweging/\">vakbondswezen</a>, vooral de onderwijzersvakbond, ondersteunden de vrouw in haar ontwikkeling en de strijd voor haar recht op gelijke kansen, gelijke betaling en gelijke behandeling. Dit resulteerde erin dat vrouwen diverse functies konden bekleden die voorheen alleen voor mannen waren bestemd. De eerste groep van 12 politievrouwen trad in overheidsdienst 1973; de eerste vrouw in de Staten werd beëdigd in 1949; de eerste vrouwelijke Minister President werd beëdigd in 1977; de eerste vrouwelijke gouverneur werd beëdigd in 2013 en de eerste vrouwelijke voorzitter van het Parlement werd beëdigd in 2016.\r\n\r\nTegenwoordig is het opleidingsniveau van vrouwen op Curaçao hoger dan dat van mannen.\r\n\r\nAan de andere kant wordt er geconstateerd dat er bij jongens en jonge mannen juist nu nieuwe problemen ontstaan. Net als meerdere landen in het Caribisch gebied moet Curaçao erkennen dat er een ‘boy problem’ is ontstaan: jongens doen het steeds slechter in het onderwijs en het percentage drop outs onder jongens is veel hoger dan onder meisjes. Deze actuele ontwikkelingen hebben een nieuwe disbalans doen ontstaan in de man-vrouw verhouding.', '31. Vrouwenemancipatie', '', 'publish', 'closed', 'closed', '', '31-vrouwenemancipatie', '', '', '2020-01-28 18:45:05', '2020-01-28 17:45:05', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=63', '30', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('64', '1', '2017-05-09 15:57:58', '2017-05-09 13:57:58', '', '29. Vrouwenemancipatie', '', 'inherit', 'closed', 'closed', '', '63-revision-v1', '', '', '2017-05-09 15:57:58', '2017-05-09 13:57:58', '', '63', 'http://canon.bramperry.nl/63-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('65', '1', '2017-05-09 15:58:22', '2017-05-09 13:58:22', 'Vroeg in de jaren zestig werd duidelijk dat bestaande verhoudingen in de Curaçaose samenleving ter discussie kwamen te staan. De verkiezingen voor het parlement van de Nederlandse Antillen van 1962 leverden een vurige strijd op tussen de Democratische Partij (DP), de partij van het lokale establishment, en de voorheen machtige bisschop. Deze keerde zich openlijk tegen alle grote partijen nu deze kritischer werden over de kerkelijke instellingen en kerkelijke invloed. De strijd kende enkel verliezers. De Katholieke Volks Partij verloor dusdanig, dat de partij voorgoed de politieke arena verliet. De DP liep een zware deuk op, maar kon toch de regering vormen door een gunstige coalitievorming. Zoals reeds vaker was gebeurd, was de grootste winnaar ook de grootste verliezer: de Nationale Volks Partij (NVP) won op het eiland Curaçao, maar belandde op landelijk niveau in de oppositie en maakte dus geen deel uit van de regering van het land de Nederlandse Antillen.\r\n\r\nDe lagere volksklasse – overwegend Afro-Curaçaos, laaggeschoold, katholiek en de NVP aanhangend – had in 1962 al veertien jaar stemrecht, maar zag haar stem niet terug in het centrum van de macht. Dezelfde groep werd vanaf eind jaren vijftig het meest getroffen door de economische crisis als gevolg van de <a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">veranderende oliemarkt</a>. Deze crisis zou gedurende de gehele jaren zestig aanhouden. Van de hoge verwachtingen van de Curaçaose volksklasse, dat zij zou kunnen delen in de economische en maatschappelijke voorspoed die in de jaren veertig tot ontwikkeling was gekomen, was bitter weinig terecht gekomen.\r\n\r\nMede onder invloed van het Tweede Vaticaanse Concilie, dat in 1962 van start ging, veranderde ook op Curaçao de aard van de maatschappelijke inspanningen van de katholieke kerk. Een centrale figuur hierin was pater Amado Römer, die zich inzette voor het vormen van <a href=\"https://canoncuracao.cw/24-de-arbeidersbeweging/\">vakbondsleiders</a> en de motor was achter coöperatieve verenigingen zoals de Credit Unions. Structurele armoedebestrijding gericht op de laagste volksklasse kwam echter niet tot stand, ook niet vanuit de overheid.\r\n\r\nIn de tweede helft van de jaren zestig nam het protest van de vakbonden tegen de loonpolitiek van de grote bedrijven toe. Ook groeide het maatschappelijk protest tegen de structurele armoede en achterstand op het eiland. Hoogopgeleide jongeren uitten felle kritiek op het politieke establishment en de sociale ongelijkheid via nieuw opgerichte tijdschriften, zoals Vitó, Ruku en Kambio.\r\n\r\nZoals op veel plaatsen in de wereld (denk bijvoorbeeld aan de studentenrevoltes in de zomer van 1968 in Parijs, de provobeweging in Nederland, Black Power, Black Panthers, ‘flowerpower’) ontstond er in de zestiger jaren op Curaçao een beweging die streefde naar verandering, een radicale breuk met het verleden. Deze tijdgeest was duidelijk herkenbaar op bijeenkomsten op het Gomezplein in Punda waar mensen bij elkaar kwamen rond de verkoop van het radicale tijdschrift Vitó.\r\n\r\nMet zware economische omstandigheden en een toenemende werkloosheid brak het jaar 1969 aan. Op<a href=\"https://canoncuracao.cw/30-dertig-mei-1969/\"> 30 mei</a> van dat jaar vond op Curaçao een grote protestmars plaats die ontaardde in een geweldsexplosie. Vanaf deze dag viel niet meer te ontkennen dat Curaçao een groot probleem had met een structureel maatschappelijk karakter.', '29. De jaren zestig – een sfeer van verandering', '', 'publish', 'closed', 'closed', '', '29-60er-jaren-sfeer-verandering', '', '', '2020-11-19 09:33:04', '2020-11-19 08:33:04', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=65', '28', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('66', '1', '2017-05-09 15:58:22', '2017-05-09 13:58:22', '', '30. De 60er jaren - een sfeer van verandering', '', 'inherit', 'closed', 'closed', '', '65-revision-v1', '', '', '2017-05-09 15:58:22', '2017-05-09 13:58:22', '', '65', 'http://canon.bramperry.nl/65-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('67', '1', '2017-05-09 15:58:48', '2017-05-09 13:58:48', 'Wereldwijd, en dus ook op Curaçao, waren <a href=\"https://canoncuracao.cw/29-60er-jaren-sfeer-verandering/\">de jaren zestig</a> een tijdperk van maatschappelijke verandering. Talrijke sociale bewegingen ageerden tegen sociale machtsstructuren die gebaseerd waren op kleur, klasse, en geslacht. Op Curaçao wordt  geen andere gebeurtenis sterker geassocieerd met deze periode als de opstand van <em>Trinta di Mei</em>, 30 mei 1969.\r\n\r\nDe <a href=\"https://canoncuracao.cw/24-de-arbeidersbeweging/\">arbeidsconflicten</a> die tot de opstand van 30 mei 1969 leidden, vonden hun oorsprong in de ontwikkelingen van de tweede helft van de jaren zestig. De Shell-olieraffinaderij, toen de grootste werkgever op Curaçao, besteedde een gedeelte van het werk uit aan verschillende onderaannemers, onder andere aan \"Werkspoor Caribbean\" (WESCAR). Door de uitbesteding waren werknemers die eerder voor de Shell hadden gewerkt, gedwongen om bij de <a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">onderaannemers</a> dezelfde arbeid te verrichten tegen een lager loon.\r\n\r\nIn de eerste week van mei 1969 ontstond er een impasse in de onderhandelingen tussen WESCAR en de Curaçao Federation of Workers (CFW) over de collectieve arbeidsovereenkomst (CAO), die op 6 mei 1969 zou aflopen. Voor CFW gold het principe van \"equal work equal pay\" en ze eiste daarom een loon dat gelijk was aan wat de Shell betaald had voordat de banen aan WESCAR werden uitbesteed. Toen WESCAR dit weigerde, kondigde de CFW in de laatste week van mei een algemene staking af voor alle leden. Al gauw volgde een sympathie-staking van de Shell-arbeidersvakbond \"Petroleum Workers Federation of Curaçao\" (PWFC). Politici, journalisten en activisten zoals Stanley Brown en Emily Henriquez, redacteuren van het linkse antikoloniale tijdschrift<em> Vitó</em>, steunden de stakende arbeiders.\r\n\r\nOp de ochtend van 30 mei 1969 verzamelden zich ongeveer vijfduizend stakers bij de hoofdingang van het Shell-terrein voor een protestmars naar het regeringscentrum in Fort Amsterdam, onder leiding van Ewald Ong-a-Kwie, leider van de CFW. De leiders van de havenarbeiders, Wilson \"Papa\" Godett en Amador Nita, sloten zich toen aan. De protestmars liep gaandeweg meer en meer uit de hand en escaleerde tot een ware opstand toen er bij Parera twee doden vielen, Manuel Gutierrez en Orlando Gerardina. Wilson \"Papa\" Godett werd in de rug geraakt door een politiekogel, toen hij met de handen omhoog de menigte probeerde te kalmeren.\r\n\r\nNu de zaak zo escaleerde, stemden Shell en WESCAR alsnog in met de eisen van gelijk loon voor gelijk werk<strong>.</strong> Het was echter al te laat. Een woedende menigte stroomde Punda en Otrobanda binnen. Gebouwen werden in brand gestoken en winkels werden geplunderd. De Gouverneur kondigde de noodtoestand af, het leger werd ingeschakeld, en mariniers uit Nederland werden ingevlogen om de opstand te bedwingen. Nadat de vakbondsleiders op de radio hadden bekendgemaakt dat Shell en de onderaannemers met de eisen van de vakbonden hadden ingestemd, keerde de rust terug.\r\n\r\nIn de nasleep van de opstand ontstond er een nieuwe politieke partij, <em>Frente Obrero Liberashon</em> <em>Trinta di Mei</em>, geleid door Wilson Godett, Stanley Brown en Amador Nita, die zou opkomen voor de belangen van de arbeidersklasse.\r\n\r\n30 mei wordt nu gezien als het kantelmoment waarop de raciaal gesegmenteerde koloniale machtsstructuur plaats moest maken voor een maatschappij waarin meer rekening werd gehouden met de belangen van de Afro-Curaçaose arbeidersklasse. In 1994 werd <em>Trinta di Mei</em> tot nationale herdenkingsdag verklaard. Alhoewel er onder Curaçaoënaars nog steeds meningsverschillen bestaan over de details, wordt <em>Trinta di Mei</em> toch algemeen beschouwd als een belangrijk keerpunt in de politieke geschiedenis van Curaçao.\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;', '30. Dertig Mei 1969', '', 'publish', 'closed', 'closed', '', '30-dertig-mei-1969', '', '', '2020-11-19 09:39:47', '2020-11-19 08:39:47', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=67', '29', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('68', '1', '2017-05-09 15:58:48', '2017-05-09 13:58:48', '', '31. Mei 1969', '', 'inherit', 'closed', 'closed', '', '67-revision-v1', '', '', '2017-05-09 15:58:48', '2017-05-09 13:58:48', '', '67', 'http://canon.bramperry.nl/67-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('69', '1', '2017-05-09 15:59:12', '2017-05-09 13:59:12', 'In de jaren 70, in de nasleep van de opstand op <a href=\"https://canoncuracao.cw/30-dertig-mei-1969/\">30 mei 1969</a>, kreeg de zwarte bevolkingsgroep veel meer aandacht voor de eigen <a href=\"https://canoncuracao.cw/37-kunst-en-cultuur-20e-eeuw/\">kunst en cultuur</a>. Dit vormde een breuk met de voorafgaande periode waarin men vooral gericht was geweest op Europa en met name op Nederland. Vooral de jongeren uit de zwarte bevolkingsgroep bezagen de geschiedenis van het eiland nu door eigen ogen. Men kreeg ook veel meer waardering voor de eigen taal, het <a href=\"https://canoncuracao.cw/8-papiamentu/\">Papiamentu</a>, die tot dan toe door velen als inferieur was beschouwd. Er werd met veel bevlogenheid gezocht naar een eigen culturele identiteit.\r\n\r\nCultuur en kunst kwamen volop in beweging door de inzet van jeugdorganisaties zoals bijvoorbeeld de groep <em>Hubentut 70</em> die het intereilandelijke kunstfestival <em>Festantil</em> organiseerde en de <em>Grupo Trinchera</em>. In de volkswijken verschenen vrolijk versierde bouwwerken gemaakt uit allerlei materialen, de zogenaamde ‘ high flying parks’ als bijzondere expressievormen van jongeren. Hieruit kwamen belangrijke artiesten voort zoals de keramisten Norva Sling en Nel Simons.\r\n\r\nOp muzikaal gebied brachten de beatbands met hun elektrische gitaren Amerikaanse muziekvormen voort zoals soulmuziek of rock. Er werd ook het accent gelegd op de eigen muzieksoorten van het eiland met teksten in het Papiamentu, zoals die van de componist en zanger Macario “Makai” Prudencia met zijn <em>Salsa Antiyano</em>. De percussie groep <em>Grupo Issoco</em> legde zich toe op de traditionele Curaçaose muziek van Afrikaanse herkomst. Vanaf het eind van de jaren zestig kwam het <a href=\"https://canoncuracao.cw/38-carnaval/\">carnaval</a> op, dat vanaf 1971 gepaard ging met het meer op de eigen cultuur afgestemde tumba-festival.\r\n\r\nKunstenaars voelden zich steeds meer betrokken bij de ontwikkelingen van de maatschappij en zij wilden dat hun kunst daarin een rol speelde. De Movementu Teatro Rex, het revolutionaire jazz trio bestaande uit Salsbach, Provence en Penso dat <em>Jazz Krioyo </em>ten gehore bracht en de band ‘Doble R’ met hun sociale en politiek bewogen teksten waren hier goede voorbeelden van, net als Julian Coco, Chin Behilia en Rudy Plaate.\r\n\r\nOok op het gebied van drama was men op zoek naar ‘het eigene’. Het toneelleven gebruikte het alledaagse leven en de sociale problematiek van het eiland als inspiratiebron voor haar werken, die uiteraard in het Papiamentu werden opgevoerd. Toneelgroepen uit die tijd waren bijvoorbeeld de ‘Toneelgroep Emmastad’ en ‘Grupo Thalia’. De ‘Grupo Eligio Melfor’ bracht voornamelijk komedie op de planken die ook doorspekt was met maatschappelijke kritiek. Kritische toneelschrijvers uit die tijd waren bijvoorbeeld Pacheco Domacassé met zijn werken <em>Tula</em> en <em>T</em><em>ò</em><em>chi </em>en Angel Salsbach en Edsel Samsom met hun stuk <em>Lucha Final</em>. De <em>Grupo Kaska di Pinda</em> en <em>Grupo Teatro Foro</em> brachten straattoneel.\r\n\r\nDe grotere aandacht voor het eigen karakter in de kunst en cultuur van Curaçao werd ondersteund door drie instituten die aan het eind van de jaren zestig waren opgericht. De schouwburg ‘Centro Pro Arte’ was in september 1968 opgeleverd. In 1969 werd de ‘Curaçaose Academie voor Beeldende Kunsten’ door de kunstenaars José Capricorne en Eddy Ayubi opgericht. In datzelfde jaar opende  het ‘Centraal Historisch Archief’ (<a href=\"https://www.nationaalarchief.cw/\">Nationaal Archief Curaçao</a>) haar deuren.\r\n\r\n&nbsp;\r\n\r\n&nbsp;', '32. De culturele dynamiek in de jaren zeventig', '', 'publish', 'closed', 'closed', '', '32-cultureel-levende-culturele-dynamiek-jaren-70', '', '', '2020-01-28 18:48:38', '2020-01-28 17:48:38', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=69', '31', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('70', '1', '2017-05-09 15:59:12', '2017-05-09 13:59:12', '', '32. Het cultureel leven/de culturele dynamiek in de jaren 70', '', 'inherit', 'closed', 'closed', '', '69-revision-v1', '', '', '2017-05-09 15:59:12', '2017-05-09 13:59:12', '', '69', 'http://canon.bramperry.nl/69-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('71', '1', '2017-05-09 15:59:37', '2017-05-09 13:59:37', 'Venezuela nationaliseerde de olie-industrie in 1976. Daarmee werd voor Shell voor het eerst sinds 1915 de keten van productie en verwerking die beide in beheer van Shell waren, verbroken. Samen met de afnemende hoeveelheid olie uit Venezuela en stijgende inkoopprijzen kwam een scenario voor vertrek voor Shell steeds nadrukkelijker in beeld.\r\n\r\nIn 1977 kwam <a href=\"https://canoncuracao.cw/45-relatie-venezuela/\">Venezuela</a> met een voorstel tot wederzijdse participatie van de Venezolaanse staatsoliemaatschappij en Shell in de <a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">raffinaderijen van Cardón</a> en Curaçao, waar Shell echter niet op in is gegaan. Venezuela daarentegen ging niet in op de wensen van Shell Curaçao om preferente prijzen te berekenen voor de raffinaderij van Curaçao. Vanaf begin jaren tachtig hing er daarom een crisissfeer rond de raffinaderij van Curaçao. De raffinaderij was verliesgevend en sluiting was voor Shell onafwendbaar.\r\n\r\nDe slepende onderhandelingen, waarbij ook de Nederlandse en Nederlands Antilliaanse regeringen betrokken waren, gingen uiteindelijk over het garanderen van werkgelegenheid voor de Antillen. Venezuela wilde alleen participeren in de bedrijfsvoering als Shell zou investeren in een moderniseringsprogramma. Shell wilde alleen een investeringsprogramma inzetten bij een gegarandeerde levering van ruwe olie, het liefst tegen preferente prijzen.\r\n\r\nVenezuela had uit commercieel technische overwegingen de voorkeur uitgesproken voor een voortgezet eigendom van Shell boven een eventueel eigendom van de Antilliaanse overheid. Uiteindelijk verkocht Shell de fabriek in 1985 echter toch aan de eilandelijke overheid van Curaçao en werd de bedrijfsvoering door het Venezolaanse Petróleos de Venezuela S.A. (PdVSA) uitgevoerd op basis van een leasecontract. Minister president Maria Liberia-Peters van de Nederlandse Antillen tekende namens de Antillen het lease contract en gold als redder van de werkgelegenheid.\r\n\r\nDe bedrijfsvoering van de raffinaderij werd in beheer van PdVSA wederom sterk gestroomlijnd. Productieprocessen werden veelal geautomatiseerd. Op het immense raffinaderijterrein waren slechts hier en daar arbeiders zichtbaar, het leeuwendeel was in de controlebunker te werk gesteld. De door Venezuela verlangde upgrading werd echter maar ten dele uitgevoerd. In het midden van de jaren negentig werd een nieuwe elektriciteitscentrale op het terrein van de raffinaderij gebouwd, maar verdere grote investeringen zijn achterwege gebleven; de fabriek draaide, op een uitzondering na, verder op de oude installaties. Er heeft ook geen toename van aanvoer van olie plaatsgevonden.\r\n\r\nDe in de jaren negentig vastgestelde Hinderwetvergunning zorgde voor een veelheid aan rechtszaken tegen de raffinaderij of tegen de overheid, hetzij om aan de milieunormen te voldoen of deze te handhaven. Rond de raffinaderij hing lange tijd de sfeer van een onzekere toekomst. De Verenigde Staten stelde vanaf januari 2019 een sanctie-regime tegen de PdVSA in terwijl grote investeringen voor een schonere en veilige fabriek nodig bleven. Om die reden werd naarstig gezocht naar kapitaalkrachtige partners. Het leasecontract met PdVSA verliep eind 2019. Hiermee kwam ook een eind aan 34 jaar PdVSA op Curaçao. Vanaf 2019 is de Refineria di Kòrsou (RdK) op zoek naar een nieuwe operator.', '33. Vertrek van Shell, komst en vertrek PdVSA', '', 'publish', 'closed', 'closed', '', '33-vertrek-shell-komst-en-vertrek-pdvsa', '', '', '2022-02-22 20:16:54', '2022-02-22 19:16:54', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=71', '32', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('72', '1', '2017-05-09 15:59:37', '2017-05-09 13:59:37', '', '33. Het vertrek van de Shell en de komst van de PDVSA', '', 'inherit', 'closed', 'closed', '', '71-revision-v1', '', '', '2017-05-09 15:59:37', '2017-05-09 13:59:37', '', '71', 'http://canon.bramperry.nl/71-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('73', '1', '2017-05-09 16:00:06', '2017-05-09 14:00:06', 'Het <a href=\"https://canoncuracao.cw/28-het-statuut/\">statuut</a> dat in 1954, na jarenlang ijveren en onderhandelen, werd getekend, gaf ruimte aan het land de Nederlandse Antillen en de afzonderlijke eilanden om het bestuur zelfstandig ter hand te nemen. Er kwam ook ruimte voor de decentralisatie van bestuur, die in de Eilandenregeling Nederlandse Antillen (1951) reeds in het vooruitzicht was gesteld. Maar tussen 1954 en 1969 verzuimden de Antilliaanse regeringen en de politieke partijen van alle eilanden, inclusief die van Aruba, om echt werk te maken van de gedane belofte om aan de afzonderlijke eilanden een zo groot mogelijke zelfstandigheid te verlenen.\r\n\r\nNa de opstand van <a href=\"https://canoncuracao.cw/30-dertig-mei-1969/\">30 mei 1969 </a>drong het besef door dat achter de ogenschijnlijke rust in de politiek op Curaçao de Afro-Curaçaoënaars zich politiek, sociaal en economisch ernstig achtergesteld voelden. De roep van de stakers om ’pan i rèspèt’ (brood en respect) klonk luid en Nederland besefte dat de waarborgfunctie die in artikel 43 van het Statuut aan Nederland was toebedeeld, geen loze letter was maar daadwerkelijk tot gedwongen Nederlands ingrijpen kon leiden, zoals dat in juni 1969 het geval was. De bezwaren bij zowel Nederlandse als de Antilliaanse politieke partijen tegen artikel 43 stimuleerde de bezinning over grotere verzelfstandiging op weg naar onafhankelijkheid. Op Aruba vroeg Betico Croes met zijn streven naar een \'status aparte\' (1971) hernieuwde aandacht voor de falende decentralisatie en voor de vrees van Aruba voor achterstelling binnen een onafhankelijke Antillen. Medio jaren zeventig onderschreven de Staten van de Nederlandse Antillen in twee moties het beginsel van recht op zelfbeschikking van ieder afzonderlijk eiland. Op de Ronde Tafel Conferenties van 1981 en 1983 sloot de Nederlandse regering zich aan bij het standpunt van de Staten en de Antilliaanse regering en erkende zij het zelfbeschikkingsrecht van ieder afzonderlijk eiland. In 1986 verwierf Aruba de status van land binnen het koninkrijk (‘status aparte’) met in het vooruitzicht onafhankelijkheid in 1996. De Antillen van de Vijf kwam met het vertrek van Aruba in 1986 tot stand. Van de Samenwerkingsregeling (1985) tussen Aruba en de Antillen van Vijf kwam door confrontaties tussen Aruba en Curaçao zeer weinig terecht.\r\n\r\nIn de periode 1985-1990 zochten Nederland, de Antillen van Vijf en Aruba naar een herstructurering van de verhoudingen binnen het koninkrijk. De onafhankelijkheid als oplossing verdween uit de agenda’s.\r\n\r\nDe periode 1990-2010 bracht ook geen rust. De staatkundige referenda die in 1994 op alle eilanden van de Antillen werden georganiseerd, gaven geen scherp beeld van de wensen. Hierna begon de regering van de Nederlandse Antillen een herstructureringsproces met als doel om via samenwerking welvaart en welzijn voor alle eilanden te bereiken. Het ‘status aparte’ referendum dat in 2000 op Sint Maarten werd gehouden, was het startpunt van een serie referenda op de andere eilanden. Het uiteindelijke resultaat was dat in 2010 het land ‘de Nederlandse Antillen’ werd opgeheven. Curaçao en Sint Maarten kregen, net als Aruba, de status van autonoom ‘land’ binnen het Koninkrijk. Bonaire, Sint Eustatius en Saba sloten zich als openbaar lichaam aan bij Nederland, waarbij aangetekend dient te worden dat niet alle inwoners van Bonaire en Sint Eustatius daar volledig achter staan. De bevolking van Sint Eustatius gaf in het referendum de voorkeur aan het behoud van de Nederlandse Antillen.\r\n\r\n&nbsp;', '34. De staatkundige ontwikkelingen vanaf het statuut tot 10 oktober 2010', '', 'publish', 'closed', 'closed', '', '34-staatkundige-ontwikkelingen-vanaf-statuut-tot-10-oktober-2010', '', '', '2020-01-28 19:09:52', '2020-01-28 18:09:52', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=73', '33', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('74', '1', '2017-05-09 16:00:06', '2017-05-09 14:00:06', '', '34. De staatkundige ontwikkelingen vanaf het statuut tot 10 oktober 2010', '', 'inherit', 'closed', 'closed', '', '73-revision-v1', '', '', '2017-05-09 16:00:06', '2017-05-09 14:00:06', '', '73', 'http://canon.bramperry.nl/73-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('75', '1', '2017-05-09 16:00:27', '2017-05-09 14:00:27', 'Door de komst van de <a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">olieraffinaderij</a> in het begin van de twintigste eeuw verdween de oude traditionele samenleving voorgoed en kwamen er veel immigranten naar het eiland. Van de 12.000 werknemers die in 1930 bij Shell werkten, op een totale bevolking van 50.165, waren er nog geen 1.800 van Curaçao zelf afkomstig en pas later nam het aandeel van lokale werknemers toe. De bevolking groeide vooral door immigratie van 35.083 in 1923 tot 125.181 in 1961. Tot in de jaren zeventig draaide het economisch leven op Curaçao bijna volledig rond de raffinaderij en aanverwante bedrijven zoals het scheepsreparatiedok.\r\n\r\nDe stad bleef weliswaar het handels- en bestuurscentrum maar het economisch zwaartepunt kwam aan de noordzijde van het Schottegat te liggen, met bunkerfaciliteiten bij Bullenbaai en Caracasbaai. De lokale bevolking trok van de buitendistricten naar de plekken in en rondom Willemstad, vanwaar de raffinaderij makkelijk bereikbaar was. Het nederzettingspatroon volgde de behoefte van de industrie en Shell bouwde ‘oliedorpen’ voor de employees en contractarbeiders en daarnaast ontstonden er diverse volkswijken.\r\n\r\nHet onderwijs moest voldoen aan de nieuwe eisen van de complexe, industriële samenleving. De voorzieningen in de medische en sociale sectoren groeiden sterk evenals faciliteiten voor recreatie en sport. Het cultureel leven kwam tot grote bloei en werd sterk beïnvloed door de nieuwe etnische groepen. Shell bezat een groot deel van het eiland en de directeur behoorde naast de gouverneur en de <a href=\"https://canoncuracao.cw/20-komst-religieuze-ordes-nederland-en-betekenis/\">bisschop</a> tot de meest invloedrijke personen. De invloed van de raffinaderij op het eiland was enorm en in de periode van 1920 tot eind jaren zestig fungeerde olie echt als koning.\r\n\r\nDe werkgelegenheid in de olie-industrie nam echter sterk af na de jaren 50 en in 1984 bedroeg het aantal werknemers niet meer dan 2.000 en dit zou verder alleen maar afnemen. De handel en financiële dienstverlening traden nu meer op de voorgrond. Het toerisme, dat zich vanaf de jaren zestig sterk begon te ontwikkelen, was in eerste instantie vooral gericht op belastingvrije luxeartikelen voor welgestelde cruisetoeristen. Later ontwikkelde zich vooral het koopjestoerisme vanuit de regio, met name <a href=\"https://canoncuracao.cw/45-relatie-venezuela/\">Venezuela</a>, en begon het verblijfstoerisme belangrijker te worden met de vestiging van grote, internationale hotelketens. Hoewel het aandeel van het toerisme in de werkgelegenheid nu officieel slechts 10% bedraagt en het ongeveer 25% van het nationaal product genereert, is haar bijdrage in werkelijkheid veel groter doordat er veel toeleverings- en onderhoudsbedrijven bij betrokken zijn. De bezoeker zelf gaat steeds meer gebruik maken van alternatieve accommodaties zoals appartementen, boetiekhotels en vakantiehuisjes, waardoor een bredere groep kleinere ondernemers profiteert. De luchthaven, vliegverbindingen, tourbedrijven en aan het toerisme gerelateerde instellingen (CTB, CHATA) zijn van strategisch belang terwijl het stadsbeeld steeds meer bepaald wordt door de megapieren en cruiseschepen.\r\n\r\nWillemstad staat op de werelderfgoed lijst van de UNESCO: hele wijken die tot in de jaren negentig verwaarloosd werden zijn inmiddels omgevormd tot kantoor- en horecadistricten. Er is een bruisend nachtleven en de vele festivals en conventies trekken veel bezoekers. Ook is er sprake van een grotere geografische spreiding van activiteiten over het eiland: bij bijna alle baaien aan de zuidkust vinden wij duikcentra en bij een groot aantal baaien is een resort gebouwd. Het toerisme is op dit moment een belangrijkere economische sector voor het eiland dan de olie-industrie. Het spanningsveld tussen de oude, vervuilende industrie aan de ene kant en het voor de toerist gewenste schone milieu aan de andere kant wordt echter steeds scherper. Het toerisme wordt langzamerhand de belangrijkste economische pijler. Het zal echter nog wel even duren voordat zij, net als de olie-industrie vroeger, de status van allesoverheersende ‘koning’ zal krijgen.', '35. Van \'Oil as King\' tot \'Tourism as King\'', '', 'publish', 'closed', 'closed', '', '35-oil-as-king-tot-tourism-as-king', '', '', '2020-01-28 19:13:00', '2020-01-28 18:13:00', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=75', '34', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('76', '1', '2017-05-09 16:00:27', '2017-05-09 14:00:27', '', '35. Van \'Oil as King\' tot \'Tourism as King\'', '', 'inherit', 'closed', 'closed', '', '75-revision-v1', '', '', '2017-05-09 16:00:27', '2017-05-09 14:00:27', '', '75', 'http://canon.bramperry.nl/75-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('77', '1', '2017-05-09 16:00:45', '2017-05-09 14:00:45', 'Curaçao kan met trots zeggen, dat het sportfiguren van een heel hoog niveau heeft voortgebracht. Beroemde landskinderen die zowel lokaal als internationaal uitblonken waren bijvoorbeeld voetballer en keeper Ergilio Hato, (1926-2003), gewichtsheffer Eduardo “Bèto” Adriana (1925 – 1997), de zwemster Enid Brigitha en de atleet Churandy Martina.\r\n\r\nDe laatste decennia laat Curaçao veel van zich horen op het gebied van honkbal. De bekendste speler is Andrew Rudolf Jones. Hij werd geboren op 23 april 1977 op Curaçao als zoon van Henry en Carmen Jones. Henry Jones was één van de beste honkbalspelers van het eiland in de  jaren zestig en zeventig en was de belangrijkste coach van Andrew. Op vroege leeftijd leerde hij hem de regels en spelsituaties van het honkbalspel. Het sprinten was ook een onderdeel van de training.\r\n\r\nAls 11-jarige werd Andrew uitgekozen voor de jeugdselectie om tijdens een toernooi in Japan te spelen. Hij kon op verschillende posities spelen vanwege zijn uitzonderlijk krachtige arm. Tijdens de ‘Latin American Games’ maakte hij ook deel uit van het nationale team. Als 15-jarige was hij de beste speler op het eiland, maar hij moest nog ontdekt worden door scouts uit de VS. Curaçao was bij hen niet bekend als honkbaleiland. De enige Curaçaoënaar die in die tijd honkbal op hoog niveau speelde, was Hensley Meulens die uitkwam voor de <em>New York Yankees</em>. Hierin kwam verandering door tussenkomst van de Caribische zakenman Giovanni Viceisza die ook coach was bij de honkbalclub <em>Atlanta Braves</em>. Hij zag Andrew spelen tijdens een toernooi in Puerto Rico en zijn spel maakte diepe indruk op hem. Hij spoorde Paul Snyder, scout van <em>Atlanta</em> <em>Braves</em> aan het eiland te bezoeken en het spel van Andrew te observeren. Deze scout was tevreden met wat hij zag, met als gevolg dat <em>Atlanta Braves</em> hem graag wilde contracteren. Zij konden de ouders uiteindelijk overtuigen hem naar een trainingskamp te sturen in februari 1993. Daar zaten verschillende tieners uit Latijns-Amerika die allemaal heel veel zin hadden om het te gaan maken in de hoogste honkbalorganisatie van de VS, de <em>Big League</em>. Door zijn meertaligheid kon hij gemakkelijk communiceren met iedereen in de organisatie.\r\n\r\nHij doorliep eerst verschillende lagere divisies van <em>Atlanta Braves</em>, opdat men hem beter kon observeren. De club projecteerde hem als hun toekomstige middenvelder voor 1999 of 2000. Een geluk voor Andrew was dat er spelers geblesseerd raakten en Atlanta een vervanger nodig had en de keus op hem viel. Zijn verdediging en snelheid waren op niveau, maar hij moest nog werken aan het slaan van de bal. Tijdens het hoogste kampioenschap in 1996 tegen de New York Yankees verrichtte hij briljant werk met twee homeruns, waarmee hij bewees dat hij een aanwinst was voor de <em>Major League</em>.\r\n\r\nHij werd later te duur voor <em>Atlanta Braves</em> en op 2 oktober 2008 maakte de club bekend dat hij niet meer terugkwam als één van hun spelers. Hij vervolgde zijn carrière bij verschillende andere honkbalclubs in de VS en in Japan. Andrew speelde ook voor het Nederlandse nationale elftal in 2013 en 2015.\r\n\r\nHij heeft tal van prijzen gewonnen. Naast zijn tien <em>Gold Glove Awards</em> heeft hij vijf keer deel uitgemaakt van de <em>All Star Game</em> en heeft hij ook verschillende records gebroken.\r\n\r\nAndrew, de rechtshandige aangewezen slagman en buitenvelder, is een rolmodel voor onze jeugd en heeft waarschijnlijk de deur geopend voor vele latere honkbalspelers uit Curaçao.\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;', '36. Sport - klein eiland - grote sportlieden- Andrew Jones', '', 'publish', 'closed', 'closed', '', '36-sport-klein-eiland-grote-sportlieden', '', '', '2020-01-28 19:20:09', '2020-01-28 18:20:09', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=77', '35', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('78', '1', '2017-05-09 16:00:45', '2017-05-09 14:00:45', '', '36. Sport - een klein eiland met grote sportlieden', '', 'inherit', 'closed', 'closed', '', '77-revision-v1', '', '', '2017-05-09 16:00:45', '2017-05-09 14:00:45', '', '77', 'http://canon.bramperry.nl/77-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('79', '1', '2017-05-09 16:01:05', '2017-05-09 14:01:05', 'Van de <a href=\"https://canoncuracao.cw/1-de-oorspronkelijke-bewoners/\">oorspronkelijke bewoners</a> van Curaçao zijn slechts wat grottekeningen bewaard gebleven. In de stad vinden we af en toe oudere architectonische versieringen, zoals vogels of pilaarfiguren. Daarvan zijn echter geen namen van de kunstenaars bekend. Pas in de negentiende eeuw leren we de namen van Curaçaose kunstenaars kennen, zoals Cornelis Gorsira, die vogelstillevens schilderde, John de Pool, die pentekeningen maakte en Johnny Ecke, die portretten schilderde. In de twintigste eeuw maakte de beeldende kunst een opleving door. Er ontstond een grote groep conventionele realistische schilders, zoals Herbert Boyé, Ati Schotborgh, Luigi Pinedo en Johannes Anemaet. Ru Jas, Charles Corsen en Lucila en Chris Engels waren meer internationaal georiënteerd. En daarnaast was er de stroming van de naïeve schilderkunst waartoe Hipolito Ocalia en <a href=\"https://canoncuracao.cw/40-elis-juliana-en-pater-brenneker/\">Elis Juliana</a> behoorden.\r\n\r\nNa 1960 werd de invloed van de internationale stromingen steeds sterker. Buitenlandse beeldende kunstenaars gaven cursussen op Curaçao of vestigden zich hier. Ook reisden Curaçaose schilders en beeldhouwers naar Amerika, naar Europa en naar de regio waar ze hun talenten verder ontwikkelden, onder wie de kunstschilders José Maria Capricorne, Wilson García, Jean Girigorie, Felix de Rooy, Tony Monsanto, Ashley Mauricio en de plastisch kunstenaars May Henriquez, Yubi Kirindongo, Nel Simon en Norva Sling. Maximiliano Nepomuceno en Elis Juliana daarentegen ontwikkelden hun talent voor plastische kunst op Curaçao zelf.\r\n\r\nHet is niet altijd duidelijk wat moet worden verstaan onder Curaçaose kunstenaars. Ellen Spijkstra, keramiste en ook internationaal doorgebroken als fotografe, is in Nederland geboren maar woont al lang op Curaçao en wordt in het buitenland ook als “van Curaçao” erkend. En Geerdine Kuijpers of Herman van Bergen, die een kathedraal bouwt van <em>sumpiña’s</em> (doornen), of een Philippe Zanolino die abstracte schilderijen maakt evenzo. Maar ook Curaçaoënaars die al jong naar het buitenland verhuisden, zoals Carlos Blaaker en Johannes Anemaet, blijven gewoon ‘Curaçaose’ kunstenaars. Beeldhouwwerken typerend voor de Curaçaose cultuur, zoals het Autonomiemonument (door Fresco) worden soms door buitenlandse kunstenaars in opdracht gemaakt, maar vaak ook door Curaçaose kunstenaars zoals bijvoorbeeld <em>Mama Baranka</em> van Hortence Brouwn. De belangstelling voor de beeldende kunst is de laatste decennia sterk gegroeid. Verschillende kunstenaars geven cursussen voor zowel jongeren als volwassenen, zoals Annemieke Dicke en Papy Adriana. Tirzo Martha en David Bade hebben het Instituto Buena Bista (IBB) opgezet, waar jongeren voorbereid worden op de opleiding aan een kunstacademie in Nederland. Dit IBB bevindt zich op het terrein van de Caprileskliniek en ook de patiënten doen mee aan de workshops.\r\n\r\nDe jongste generatie kunstenaars is veel meer internationaal georiënteerd en zij doen mee met solo- en groepsexposities op Curaçao, op de omringende eilanden, in Nederland, Europa en Zuid-Amerika.\r\n\r\n&nbsp;\r\n\r\n&nbsp;', '37. Beeldende kunst in de 20e eeuw', '', 'publish', 'closed', 'closed', '', '37-kunst-en-cultuur-20e-eeuw', '', '', '2020-01-28 19:26:17', '2020-01-28 18:26:17', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=79', '36', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('80', '1', '2017-05-09 16:01:05', '2017-05-09 14:01:05', '', '37. Kunst en cultuur in de 20e eeuw', '', 'inherit', 'closed', 'closed', '', '79-revision-v1', '', '', '2017-05-09 16:01:05', '2017-05-09 14:01:05', '', '79', 'http://canon.bramperry.nl/79-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('81', '1', '2017-05-09 16:01:18', '2017-05-09 14:01:18', 'Carnaval heeft een lange geschiedenis op het eiland, hoewel het pas vanaf de jaren zeventig van de vorige eeuw een echt volksfeest is. De eerste schriftelijke vermelding van de carnavalsviering op Curaçao stamt uit het \"Publicatieblad 1872 nr. 27\". Deze verordening opende de mogelijkheid om carnavalsoptochten te organiseren en deze te reguleren op openbare plaatsen. De Curaçaosche Courant schrijft in 1901 dat ‘volgens de Latijns-Amerikaanse gewoonten’ carnaval wordt gevierd op het eiland. De viering was een initiatief van Venezolaanse burgers die hier woonden en vond plaats in een privé club.\r\n\r\nDe eerste carnavalsviering op straat vond in 1945 plaats op initiatief van werknemers van de <a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">raffinaderij</a>, die afkomstig waren van de Britse Caribische eilanden. Zij speelden en dansten op steelbandmuziek vanaf Suffisant tot de ingang van de Isla.\r\n\r\nIn 1949 werd de stichting ‘Stichtingscommissie Carnavalsfeesten’ opgericht om carnaval te vieren met een gekozen Prins Carnaval. De bedoeling was om de gehele bevolking bij de viering te betrekken. De Chinese bewoners deden toen actief mee met prachtige praalwagens vol draken. Van de Europese Nederlanders op het eiland was een groot deel afkomstig uit Limburg en zij richtten in de jaren 50 de carnavalsvereniging de Limburgse Kabrieten op. De carnavalsvieringen bleven echter beperkt tot evenementen in sociale clubs en de algemene interesse vervaagde in de jaren vijftig.\r\n\r\nIn 1961 nam Elias Bronswinkel het initiatief om de belangstelling voor carnaval nieuw leven in te blazen door de oprichting van het Centraal Comité Carnaval Curaçao, de voorloper van het huidige Carnavalscomité. Er verschenen carnavaleske figu­ren op het toneel voor de titel van Prins Carnaval, zoals de komische Benjamin Wefer (‘Shon Benchi’) en de figuur van Pancho. In die tijd maakte ook Miss Carnaval furore. Maar nog steeds  beperkte de animo voor de viering van Carnaval als geheel zich tot hier en daar een feest in clubs van de gegoede burgers.\r\n\r\nIn 1970 kende het carnaval vrij abrupt een ongekende omvang. Het werd ineens gevierd als een massaal volksfeest. Naar de oorzaak van deze plotselinge populariteit kan men gissen. Misschien speelde het gevoel dat men zich van ketenen had ontdaan in <a href=\"https://canoncuracao.cw/30-dertig-mei-1969/\">mei 1969</a> een rol, of nam men een voorbeeld aan de carnavalsoptochten op andere Caribische eilanden, bijvoorbeeld Aruba.\r\n\r\nHet was Omalio Merien die eind jaren zestig al voorstelde om een festival te houden waarbij een band als winnaar zou worden gekozen voor het carnaval van dat jaar. De eerste festivals stonden in het teken van de calypso’s, maar in 1971 maakten die, op voorspraak van onder andere Boy Dap en Juan Camelia, plaats voor de tumba als het uitverkoren ritme voor de carnavalsparade van Curaçao. Het Tumbafestival is in de loop van de jaren uitgegroeid tot één van de grootste muzikale gebeurtenissen van het eiland.\r\n\r\nIn 1981 werd het Kindercarnaval geïntroduceerd en in de jaren negentig werd de Fundashon Karnaval Kòrsou  opgericht. In 1995 werd de Teener Parade toegevoegd aan de festiviteiten. Omdat de Emmabrug als te kwetsbaar werd beschouwd voor de grote voertuigen die tijdens de optocht worden gebruikt, werd de route gewijzigd. Deze begint sindsdien in Santa Maria en eindigt in Otrobanda, waar op dinsdagavond om twaalf uur \'s nachts op het Brionplein de pop Rei Momo wordt verbrand.', '38. Carnaval', '', 'publish', 'closed', 'closed', '', '38-carnaval', '', '', '2020-01-28 19:29:02', '2020-01-28 18:29:02', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=81', '37', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('82', '1', '2017-05-09 16:01:18', '2017-05-09 14:01:18', '', '38. Carnaval', '', 'inherit', 'closed', 'closed', '', '81-revision-v1', '', '', '2017-05-09 16:01:18', '2017-05-09 14:01:18', '', '81', 'http://canon.bramperry.nl/81-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('83', '1', '2017-05-09 16:01:39', '2017-05-09 14:01:39', 'Curaçao is gelegen in de Zuid-Caribische droogtegordel en heeft een steppeklimaat met steeds terugkerende perioden waarin weinig regen valt, waardoor ‘natuurlijk’ zoet water vaak schaars is. Voor permanente bewoning moet er echter steeds zoet water ter beschikking staan.\r\n\r\nDe <a href=\"https://canoncuracao.cw/1-de-oorspronkelijke-bewoners/\">eerste bewoners van Curaçao</a> - de Indiaanse bewoners - kwamen in droge tijden vooral aan water door het gebruik van natuurlijke bronnen zoals die bij Hato of San Pedro en loopputten of loopkuilen (<em>pos di pia</em>), die gegraven werden in zachte grond tot dieper dan de grondwaterspiegel. Deze loopputten waren vooral gelegen in rooien of in de omgeving van rooien, waar de grondwaterspiegel hoog was. Vaak was dit dicht bij de binnenbaaien.\r\n\r\nNa de komst van de <a href=\"https://canoncuracao.cw/2-de-spaanse-periode/\">Spanjaarden</a> en daarna de <a href=\"https://canoncuracao.cw/3-verovering-van-curacao-door-de-wic-en-de-komst-van-de-hollanders/\">Nederlanders</a> beschikte men over het benodigde gereedschap om ook in het harde rotsachtige gesteente diepe putten te kunnen slaan. Tevens begon men met de aanleg van dammen om het water niet naar zee te laten stromen, maar vast te houden en zodoende de grondwaterspiegel te verhogen. Men had echter steeds meer water nodig voor de <a href=\"https://canoncuracao.cw/13-plantagesysteem-op-curacao/\">plantages</a>, de stad, de schepen en voor de grote veestapel. Geleidelijk aan ging de grondwaterspiegel daarom door het veelvuldig gebruik van die putten dalen, vooral op plaatsen waar ook nog de vegetatie weggehaald werd. Rondom het Schottegat, bijvoorbeeld, werden veel putten geslagen voor water dat naar de <a href=\"https://canoncuracao.cw/10-ontwikkeling-willemstad/\">stad</a> vervoerd werd met bootjes. Men sprak over ‘waterplantages’.  Maar door overmatig gebruik werden veel putten uiteindelijk brakwaterputten.\r\n\r\nVeel stenen huizen, vooral in de stad, hadden regenbakken voor eigen gebruik en in de negentiende eeuw kon men ook water kopen bij door ezels getrokken waterkarren (<em>garoshi di awa</em>).\r\n\r\nIn de <a href=\"https://canoncuracao.cw/11-ontwikkeling-nederzettingen-en-barios-buiten-willemstad/\">buitendistricten </a>was men vooral afhankelijk van de geslagen putten, waarvan een aantal eigendom was van het gouvernement en dus openbaar bezit, maar ook soms nog steeds van loopputten. Veel mensen in de kunuku en in de stad vingen in de twintigste eeuw water op in grote tonnen. Men had wel een goot, maar geen regenbak. Regenbakken konden broedplaatsen worden voor gele koorts muggen en daarom was het beleid erop gericht om geen regenbakken te bouwen.\r\n\r\nIn de twintigste eeuw werd de watervoorziening steeds problematischer door de komst van de <a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">Shell</a> en de grote bevolkingstoename, waardoor de behoefte aan zoet water enorm toenam. De Shell kocht op grote schaal plantages op die gebruikt werden voor het oppompen van grondwater voor haar productieprocessen en voor de huizen van het personeel.\r\n\r\nDaarnaast ging de Shell in 1928 over op het destilleren van zeewater, waarbij het water eerst verhit werd en de zoutvrije damp daarna weer werd gecondenseerd, zodat zoet water overbleef. De overheid begon eind jaren twintig met het installeren van buizen voor de distributie van water in het stedelijk woongebied waarbij putwater en gedestilleerd zeewater gedistribueerd werd tot de kranen in de huizen.\r\n\r\nVoor de buitendistricten kwam er kosteloze waterverschaffing door de dienst Lands- watervoorziening (LWV) Hiervoor werden er vanaf de jaren veertig openbare tapplaatsen aangelegd, waarvoor of putwater van nabijgelegen putten gebruikt werd of leidingwater, dat met voertuigen (tankwagens) aangevoerd werd. In grote lege bakolieblikken, die vaak op het hoofd werden gedragen, werd dit water door vooral vrouwen vanaf het tappunt naar hun huizen gebracht. In de jaren zestig van de vorige eeuw waren bijna alle huizen op het eiland op het waterleidingnet aangesloten.\r\n\r\nDe zeewaterdestillatie is nu na zo’n 80 jaar op zijn retour. Momenteel wordt al het drinkwater geproduceerd met behulp van het systeem van ’omgekeerde osmose’, waarbij zeewater door membranen geperst wordt zodat de zoutdeeltjes eruit gefiltreerd worden en er zoet water overblijft.', '39. Water', '', 'publish', 'closed', 'closed', '', '39-water', '', '', '2020-01-28 19:40:49', '2020-01-28 18:40:49', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=83', '38', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('84', '1', '2017-05-09 16:01:39', '2017-05-09 14:01:39', '', '39. Volksfeesten (Seu, lele Toni)', '', 'inherit', 'closed', 'closed', '', '83-revision-v1', '', '', '2017-05-09 16:01:39', '2017-05-09 14:01:39', '', '83', 'http://canon.bramperry.nl/83-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('85', '1', '2017-05-09 16:01:56', '2017-05-09 14:01:56', 'De gedachtewereld van een bevolking kan vaak het best begrepen worden door kennis van ouderen te verzamelen en te documenteren.\r\n\r\nPater Paul Brenneker en Elis Juliana waren de voornaamste pioniers op dit gebied op Curaçao. Paul Brenneker, een katholieke geestelijke van de <a href=\"https://canoncuracao.cw/20-komst-religieuze-ordes-nederland-en-betekenis/\">Orde van Dominicanen</a>, geboren op 7 mei 1912 in Limburg, liet bij zijn overlijden op 7 februari 1996, een grote culturele erfenis achter: ruim honderd publicaties, prenten, foto’s, gedichten, duizenden artefacten en een grote collectie met geluidopnames van zang en verhalen die hij samen met Elis Juliana vanaf de jaren vijftig had verzameld op Curaçao, Bonaire, Aruba, Sint Maarten, Sint Eustatius en Saba. Zijn publicaties als <em>Lekete Minawa</em> (1958), <em>Benta</em> – oude liederen– (1959), <em>Curaçaoensia – volkskundige aantekeningen over Curaçao</em> (1961), <em>Brua</em> (1966), en de tien delen <em>Sambumbu</em> (1969–1975) vormen een onschatbare bron van informatie over bijvoorbeeld de ontwikkeling van de taal Guene als voorloper van het <a href=\"https://canoncuracao.cw/8-papiamentu/\">Papiamentu</a>, over volksreligie en <a href=\"https://canoncuracao.cw/6-slavernijverzet/\">verzet tegen de slavernij</a>. Brenneker combineerde zijn liefde voor de lokale cultuur met naastenliefde. Dat laatste  deed hij concreet via de stichting voor daklozen, <em>Kas Pa nos Tur</em> (een huis voor iedereen), en de stichting <em>Pam Pa mi Ruman</em> (brood voor mijn broeders en zusters) voor mensen die honger lijden.\r\n\r\nElis Juliana werd op 8 augustus 1927 in ‘Nieuw Nederland’, een stadswijk dichtbij Punda, geboren. Het was de tijd dat <a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">Shell </a>migranten uit het hele Caribische gebied naar Curaçao bracht. De radio deed zijn entree, de showbizz en het verenigingsleven vierden hoogtij. Geconfronteerd met de veranderingen van de moderne tijd ging de jonge Juliana op zoek naar de eigen identiteit, zowel die van zichzelf als die van het Curaçaose volk. Hij begon als voordrachtkunstenaar. Al spoedig ontpopte hij zich als een veelzijdig artiest – dichter, verteller, tekenaar, beeldhouwer, verhalenschrijver -, maar hij begaf zich, geïnspireerd door Paul Brenneker, ook op het pad van de onderzoeker naar de eigen cultuur. Wat begon uit nieuwsgierigheid en om inspiratie op te doen voor verhalen en voordrachten, groeide uit tot een passie: het bezoeken van ouderen als bron van informatie en kennis. Door hun verschillende culturele achtergrond – een Curaçaose volksjongen en een Limburgse priester –  vulden ze elkaar voortreffelijk aan. Elis Juliana kan bogen op een lijst van ruim 50 publicaties, waaronder zijn eerste dichtbundel Flor di datu, ziin verhalen als Wazo riba ròndu (1967, 1981, 1988), Guia Etnológiko I, II, III en zijn filosofie OPI I, II, III, IV, Organisashon Planifikashon Independensia, (1979, 1980, 1983, 1988). Hij overleed in 2013.\r\n\r\nDe grote verdienste van het onderzoek van Brenneker en Juliana is dat zij de volkscultuur van de twintigste eeuw op een systematische wijze hebben gedocumenteerd. Ze verzamelden ook vele objecten en stelden een unieke collectie van 1400 liederen, muziek en verhalen samen die in 1975 is overgedragen aan de Fundashon Zikinzá, en in 2010 weer is overgedragen aan de <a href=\"https://naam.cw/\">Stichting NAAM</a> (<em>National Archaeological Anthropological Memory Management</em>).\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;', '40. Elis Juliana en Pater Brenneker', '', 'publish', 'closed', 'closed', '', '40-elis-juliana-en-pater-brenneker', '', '', '2020-01-28 19:44:59', '2020-01-28 18:44:59', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=85', '39', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('86', '1', '2017-05-09 16:01:56', '2017-05-09 14:01:56', '', '40. Elis Juliana en Pater Brenneker', '', 'inherit', 'closed', 'closed', '', '85-revision-v1', '', '', '2017-05-09 16:01:56', '2017-05-09 14:01:56', '', '85', 'http://canon.bramperry.nl/85-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('87', '1', '2017-05-09 16:02:11', '2017-05-09 14:02:11', 'Tegenwoordig gaan nagenoeg alle kinderen en jongeren op ons eiland naar school maar in de achttiende en negentiende eeuw was dat helemaal niet het geval. In de achttiende eeuw was het bestuur in de kolonie in handen van de <a href=\"https://canoncuracao.cw/3-verovering-van-curacao-door-de-wic-en-de-komst-van-de-hollanders/\">W.I.C.</a>. De compagnie had een schooltje voor kinderen van de ambtenaren en soldaten, maar vaak was er geen onderwijzer op het eiland. Sommige inwoners hadden een particuliere school waarvoor schoolgeld betaald moest worden. Regelmatig onderwijs kwam er pas toen de koloniale overheid na de Britse bezetting (1807-1816) de verantwoordelijkheid op zich nam om landsscholen in de stadswijken Otrobanda en Punda op te richten. In 1819 kwam er een onderwijsverordening die uitging van de Nederlandse wet van 1806. Op de landsscholen waren er leerlingen van wie de ouders schoolgeld betaalden en leerlingen uit arme gezinnen die gratis onderwijs genoten. Naast deze openbare scholen waren er ook enkele particuliere scholen. Kinderen van tot slaaf gemaakten mochten tot 1857 geen schoolonderwijs volgen.\r\n\r\nVanaf 1837 mochten er weer particuliere scholen worden opgericht. Ouders die vermogend waren konden schoolgeld betalen en plaatsten hun kinderen op scholen waarbij meer vakken werden aangeboden zoals aardrijkskunde, geschiedenis en enkele vreemde talen. De openbare scholen boden alleen lezen, schrijven, rekenen en Nederlandse taal aan en werden op den duur scholen voor kinderen die kosteloos onderwijs genoten. Vanaf 1842 begon de katholieke kerk onder leiding van Mgr. Martinus Niewindt ook scholen op te richten; eerst in de <a href=\"https://canoncuracao.cw/10-ontwikkeling-willemstad/\">stad</a> en later in de <a href=\"https://canoncuracao.cw/11-ontwikkeling-nederzettingen-en-barios-buiten-willemstad/\">buitendistricten</a>. In 1865 stond naast iedere kerk op het eiland een school. De onderwijzeressen op deze scholen waren de <a href=\"https://canoncuracao.cw/20-komst-religieuze-ordes-nederland-en-betekenis/\">Zusters van Roosendaal</a>. Op den duur gingen de meeste leerlingen op het eiland naar een katholieke armenschool. Als gevolg hiervan werden ook andere onderwijscongregaties uit Nederland op het eiland actief zoals o.a. de <a href=\"https://canoncuracao.cw/20-komst-religieuze-ordes-nederland-en-betekenis/\">Fraters van Tilburg</a> (1886) en de <a href=\"https://canoncuracao.cw/20-komst-religieuze-ordes-nederland-en-betekenis/\">Zusters van Schijndel</a> (1920).\r\n\r\nAlle openbare, particuliere en bijzondere scholen moesten zich aan de onderwijswetten van de koloniale overheid houden: het onderwijspersoneel moest bevoegd zijn, jaarlijks werden de scholen op kwaliteit gecontroleerd en al het onderwijs moest neutraal zijn. Vanaf 1907 mocht godsdienstonderwijs op de katholieke scholen worden gegeven.\r\n\r\nPer januari 1885 ging een belangrijke onderwijswet in werking die het mogelijk maakte scholen voor meer uitgebreid onderwijs op te richten. De overheid richtte twee stadsscholen op voor kinderen van welvarende ouders die schoolgeld betaalden. De zusters en fraters volgden met hun eigen scholen in de verschillende stadswijken waarvoor de ouders ook schoolgeld moesten betalen. Op al deze scholen werden meer vakken en ook op een hoger niveau aangeboden. Vanaf de wet van 1897 werd gesproken van Muloscholen; daarnaast was er gratis elementair onderwijs voor arme kinderen. Het Mulodiploma zorgde ervoor dat veel gediplomeerden een goede baan op de arbeidsmarkt vonden. In 1941 werd de eerste openbare middelbare school opgericht (AMS); vrij snel daarna kwamen er ook katholieke middelbare scholen (Radulphus College, MIL). Na 1960 kwamen er ook opleidingen voor verschillende vormen van lager, middelbaar en hoger beroepsonderwijs. In 1971 opende de Rechtshogeschool haar deuren. Uit de Rechtshogeschool ontwikkelde zich de Universiteit van de Nederlandse Antillen (UNA), de huidige <a href=\"https://www.uoc.cw/\">University of Curaçao</a> (UoC).\r\n\r\nTot <a href=\"https://canoncuracao.cw/28-het-statuut/\">1954</a> was Curaçao een kolonie van Nederland en was het onderwijs qua personeel, inhoud en taal sterk gericht op Nederland. Na 1954 was de Antilliaanse regering verantwoordelijk voor het onderwijs maar tot 2000 werd iedere onderwijswetgeving in Nederland zonder meer overgenomen zoals in 1968 de Mammoetwet (mavo-havo-vwo) die de Mulo- en HBS-scholen verving. Door de Nederlandse onderwijswetgeving te volgen, gingen en gaan veel jongeren met een onderwijsdiploma en een overheidsbeurs in Nederland studeren.\r\n\r\nDe wetgeving van 2002 hield meer rekening met de Curaçaose omstandigheden en de invoering van het Papiaments als instructietaal. In het funderend onderwijs en de basisvorming is de ‘<a href=\"https://canoncuracao.cw/30-dertig-mei-1969/\">antillianisering</a>’ van lesstof en personeel sterk toegenomen.\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;', '41. Het onderwijs op Curaçao', '', 'publish', 'closed', 'closed', '', '41-onderwijs-op-curacao', '', '', '2020-11-19 09:41:32', '2020-11-19 08:41:32', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=87', '40', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('88', '1', '2017-05-09 16:02:11', '2017-05-09 14:02:11', '', '41. Het onderwijs op Curaçao', '', 'inherit', 'closed', 'closed', '', '87-revision-v1', '', '', '2017-05-09 16:02:11', '2017-05-09 14:02:11', '', '87', 'http://canon.bramperry.nl/87-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('89', '1', '2017-05-09 16:02:31', '2017-05-09 14:02:31', 'De bevolking van Curaçao groeide van het aantal van 33.361 in 1915 tot 118.858 in 1955. Deze enorme groei kwam doordat de <a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">olieraffinaderij</a> behoefte had aan personeel. De raffinaderij begon werkkrachten te importeren naar gelang de activiteiten van het bedrijf toenamen. Rond het jaar 1922 kwamen werklieden uit de Bovenwindse eilanden, Aruba en Bonaire gevolgd door de Engelstalige Caribische arbeiders. Deze laatsten werden binnen de raffinaderij ingezet als chauffeur, portier en bewaker. Ten aanzien van de lokale bevolking bestond bij de raffinaderij het vooroordeel dat zij niet geschikt waren voor werkzaamheden binnen de raffinaderij, zodoende werden zij ingezet om te werken bij onderaannemers of als havenarbeiders. Chinezen, Bonairianen en Sabanen werden ingezet op de olietankers. De blanke, Europese Nederlanders waren in de eerste plaats employés van de Shell maar er waren ook enkele arbeiders.\r\n\r\nDoor de groei van zowel de economie als de bevolking moest de overheid haar diensten uitbreiden en zo ook het ambtenarenapparaat. Politiemannen, onderwijspersoneel, geestelijken en diverse professionelen werden vanuit Europa hier ingezet.  Surinamers werkten zowel als arbeiders en employés bij de raffinaderij maar velen ook als onderwijzers. Venezolanen, Colombianen en ook Portugezen uit Madeira werden binnengehaald als oliearbeiders. De Portugezen werkten ook als straatveger, ijscoman, tuinman en als landbouwer bij de lokale tuinbedrijven. Libanezen, vormden een belangrijke handelsgroep. De eerste Libanezen kwamen hier voor de komst van de olieraffinaderij en hielden zich bezig met de verkoop huis aan huis.\r\n\r\nIn 1926 kwamen de Askenazische Joden, gevlucht voor de vervolgingen in Midden- en Oost-Europa en gingen zich bezighouden met handel in luxegoederen zoals modekleding, juwelen en huishoudelijke artikelen. Indiërs, kwamen naar Curaçao om te participeren in de detailhandel, vooral door de bloei van de <a href=\"https://canoncuracao.cw/35-oil-as-king-tot-tourism-as-king/\">toeristenindustrie</a>.Was de samenleving vroeger duidelijk te verdelen in blanken, kleurlingen en zwarten, nu werd de situatie complexer. De immigranten waren van verschillende nationaliteiten, culturen, talen en godsdiensten. De verdeeldheid werd geaccentueerd door de aangewezen woonplaatsen, type werk waarvoor arbeiders ingezet werden en de sociale afstand tussen de groepen.\r\n\r\n&nbsp;', '42. De pluriforme samenleving', '', 'publish', 'closed', 'closed', '', '42-pluriforme-samenleving', '', '', '2020-10-20 19:04:21', '2020-10-20 17:04:21', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=89', '41', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('90', '1', '2017-05-09 16:02:31', '2017-05-09 14:02:31', '', '42. De pluriforme samenleving', '', 'inherit', 'closed', 'closed', '', '89-revision-v1', '', '', '2017-05-09 16:02:31', '2017-05-09 14:02:31', '', '89', 'http://canon.bramperry.nl/89-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('91', '1', '2017-05-09 16:02:41', '2017-05-09 14:02:41', 'Het eiland Curaçao bestaat al zo’n 87 miljoen jaar, maar werd pas zo’n 3400 jaar geleden voor het eerst door mensen bewoond. De eerste mensen, uit de zogenaamde ‘pre-ceramische’ periode, waren voornamelijk verzamelaars. Zee- en landdieren, eetbare planten en enkele waterbronnen hielden deze kleine groep mensen in stand en op een aantal locaties op Curaçao geven stapels schelpresten nog steeds blijk van de aanwezigheid van deze groepen. Omstreeks 1500 jaar geleden kwam een andere groep, de <a href=\"https://canoncuracao.cw/1-de-oorspronkelijke-bewoners/\">Caquetio</a>, naar het eiland. Deze groep leefde in kleine dorpjes en deed aan kleinschalige akkerbouw. Hoewel er uiteraard een effect van deze bezigheden op de inheemse natuur te bemerken viel, zal dit, door de lage bevolkingsdichtheid en niet intensieve aanpak, beperkt zijn gebleven.\r\n\r\nDe omgang met de natuur onderging echter wel een drastische verandering na de inname van Curaçao door achtereenvolgens de <a href=\"https://canoncuracao.cw/2-de-spaanse-periode/\">Spanjaarden</a> (1499) en de <a href=\"https://canoncuracao.cw/3-verovering-van-curacao-door-de-wic-en-de-komst-van-de-hollanders/\">Nederlanders</a> (1634). De eerstgenoemden brachten paarden, runderen, ezels en geiten mee, die toen al een grote impact op de inheemse natuur hadden. Maar, omdat het aantal bewoners in de Spaanse periode nog zeer beperkt was, was het effect relatief gering. De Nederlanders hebben echter het landschap, en daarmee de natuur, van Curaçao grondig veranderd. De uitbreiding van de havenstad, het verdelen van bijna het hele eiland in <a href=\"https://canoncuracao.cw/13-plantagesysteem-op-curacao/\">plantages</a>, de <a href=\"https://canoncuracao.cw/19-mijnbouw/\">mijnbouw</a> en de <a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">raffinaderij</a> zijn de directe aanleiding geweest voor het aanleggen van een uitgebreid wegennet, grootschalige ontbossing voor het aanleggen van landbouwgronden, het kappen van bomen als pokhout (Wayaca), verfhout (Brasia – dat verwerkt werd in het rasphuis in Amsterdam om rode verfstof te verkrijgen) en mangroven (Palu di mangel), het verzilten van het grondwater en vervuiling van grond en binnenwater.\r\n\r\nDelen van het eiland die ‘onbruikbaar’ geacht werden, de zogenaamde ‘savaangronden’, bleven onontgonnen, of werden bij plantages getrokken als voedselbron voor het vee. Rooien werden ingedamd om het grondwater aan te vullen, inloopputten (uit)gegraven en putten geslagen voor de landbouw en veeteelt.\r\n\r\nDe grote aantallen geiten, schapen en koeien die op de plantages gehouden werden, werden de ‘vrije natuur’ ingestuurd, het achterland van de plantages, om te grazen. Deze begrazing door niet-inheemse dieren zorgde ervoor dat  de onderlaag van de vegetatie werd geëlimineerd waardoor regeneratie van de omgekapte bomen heel moeilijk werd en vaak niet meer mogelijk was. Ook het verbranden van hout uit de natuur tot houtskool (karbon), dat gebruikt werd om te koken, had een sterk negatief effect op de vegetatie. Door de afname van de landbouwinitiatieven kreeg de natuur op de plantages, eind negentiende eeuw en met de komst van de raffinaderij, echter kans om zich deels te herstellen.\r\n\r\nDe raffinaderij had echter ook een andere, negatieve, impact op de natuur. De behoefte aan zoet water voor het raffinageproces en voor de bevolking, die door de komst van de raffinaderij sterk gegroeid was, was onuitputtelijk en daarom werd het grondwater op grote schaal opgepompt, met verzilting als gevolg. De raffinaderij veroorzaakt ook vergaande vervuiling van de natuur die onder de wind ligt, en het Schottegat.\r\n\r\nDe verder toenemende bevolking en de daarmee gepaard gaande huizenbouw hebben voor grote fragmentatie gezorgd van de inheemse natuur: gebieden die vroeger een aaneensluitend geheel vormden, worden nu door wegen en woonwijken doorsneden en staan nu los van elkaar. Op het eiland zijn er nu bijvoorbeeld drie verschillende populaties van het inheemse hert, die onderling geen contact meer met elkaar hebben.\r\n\r\nHet planologisch beleid van de overheid heeft geresulteerd in het Eilandelijk Ontwikkelings Plan, waarin een aantal gebieden als natuurgebied staan aangemerkt. De Stichting Nationale Parken (Stinapa) beheert een aantal van die gebieden. ‘Oostpunt’, dat ongeveer 10% van het totale landoppervlak van Curaçao beslaat, is in particuliere handen en is tot nu vrijwel ongerept. De koraalriffen die voor de kust van dit gebied liggen, behoren tot de best bewaarde koraalriffen ter wereld. Er bestaan echter ver uitgewerkte plannen om Oostpunt te ontwikkelen.\r\n\r\n&nbsp;\r\n\r\n&nbsp;', '43. Omgaan met de natuur', '', 'publish', 'closed', 'closed', '', '43-omgaan-natuur', '', '', '2020-11-19 09:42:48', '2020-11-19 08:42:48', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=91', '42', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('92', '1', '2017-05-09 16:02:41', '2017-05-09 14:02:41', '', '43. Omgaan met de natuur', '', 'inherit', 'closed', 'closed', '', '91-revision-v1', '', '', '2017-05-09 16:02:41', '2017-05-09 14:02:41', '', '91', 'http://canon.bramperry.nl/91-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('93', '1', '2017-05-09 16:03:06', '2017-05-09 14:03:06', 'Het katholicisme is al eeuwenlang de belangrijkste godsdienst van de bewoners van Curaçao. De christelijke kerstening begon in de zestiende eeuw onder de <a href=\"https://canoncuracao.cw/1-de-oorspronkelijke-bewoners/\">Caquetio</a> indianen vanuit het Bisdom in Coro, Venezuela.\r\n\r\nMet de komst van de West-Indische Compagnie in de zeventiende eeuw maakte de Hervormde Kerk haar entree. Deze liet toe dat rooms-katholieke priesters vanuit het huidige <a href=\"https://canoncuracao.cw/45-relatie-venezuela/\">Venezuela</a> ook de geïmporteerde,<a href=\"https://canoncuracao.cw/5-de-slavenhandel-en-slaverij/\"> tot slaaf gemaakte</a> Afrikanen mochten dopen. In de negentiende eeuw deed de Nederlandse <a href=\"https://canoncuracao.cw/20-komst-religieuze-ordes-nederland-en-betekenis/\">katholieke missie</a> haar entree op Curaçao. Deze stelde de uitwassen van slavernij aan de kaak en zette zich in voor <a href=\"https://canoncuracao.cw/41-onderwijs-op-curacao/\">onderwijs</a> en gezondheidszorg onder de <a href=\"https://canoncuracao.cw/4-nieuwe-bewoners-in-de-zeventiende-eeuw/\">Afro-Curaçaose bevolking</a>. Ondanks de uitsluiting van de zwarte bevolking om te participeren in de activiteiten van de Hervormde Kerk, zijn er aanwijzingen dat al in de achttiende eeuw Afro-Curaçaoënaars deelnamen aan dit kerkgenootschap. Zo meldt het register van het protestantse kerkhof Fo’i Porta de namen onder vermelding van ‘neger’ of ‘negerin’ ‘maar lid van de hervormde gemeente’. Dat was niet het geval met de <a href=\"https://canoncuracao.cw/15-opbouw-samenleving-19e-eeuw-verschillende-bevolkingsgroepen/\">joodse gemeenschap </a>die zich hier ook vestigde in de zeventiende eeuw en tegen het einde van de achttiende eeuw de grootste en belangrijkste joodse gemeente op het Amerikaanse continent was. Afro-Curaçaoënaars woonden wel religieuze rituelen en vieringen van hun joodse eigenaars bij, maar werden niet toegelaten tot lidmaatschap.\r\n\r\nDe <a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">industrialisatie</a> in de twintigste eeuw bracht, met migranten uit het Caribisch Gebied, nieuwe christelijke godsdiensten naar het eiland. In de éénentwintigste eeuw kent Curaçao een veelheid aan religies: er zijn onder anderen Methodisten, Anglicanen, leden van de Evangelische Broedergemeente en de Pinkstergemeenschap, Adventisten, Hindoes, Jehovagetuigen en Moslims op het eiland. Culturele interacties tussen de verschillende etnische groepen leidde vaak tot syncretisch religieuze praktijken onder de bevolking, d.w.z. dat ze elkaar beïnvloeden en soms gebruiken van elkaar overnemen. Verschillende auteurs wijzen erop dat er een nauwe verwevenheid is tussen religie en magie en dat Europese en Afrikaanse vormen van magie niet ver uit elkaar liggen.\r\n\r\nOfschoon de meerderheid van de bevolking van Curaçao een Afrikaanse achtergrond heeft, is de Afrikaanse religiositeit, die nog duidelijk onderkend kan worden, onderbelicht. De aandacht beperkt zich tot overblijfselen of ‘echo’s’ uit Afrika, tot verschijningsvormen, zoals spirituele praktijken samengevat als brua en rituelen rondom de geboorte en de dood (‘Ocho Dia’ een acht dagen durende wake). Minder bekend is dat achter de viering van katholieke heiligen, zoals San Antonio of Lele Toni, Papa Legba wordt aangeroepen, een Loa of godheid die toestemming kan geven om met de geesten van Guinee te spreken. Een ander voorbeeld is San Miguel, ook bekend als Belié Belcán, de geest van een zwarte heilige, de heilige ‘van ons ras’ die allen beschermt. Ze horen thuis in het pantheon van de Afro-Curaçaose religieuze spiritualiteit ‘Montamentu’, dat overeenkomsten vertoont met de Vudu uit Haïti en de Dominicaanse Republiek. Het beleven van deze voorouderlijke spiritualiteit en het behoren tot een van de christelijke kerken van Curaçao sluiten elkaar blijkbaar niet uit.', '44. Religie en religieuze vieringen', '', 'publish', 'closed', 'closed', '', '44-religie-en-religieuze-vieringen', '', '', '2020-01-28 20:04:33', '2020-01-28 19:04:33', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=93', '43', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('94', '1', '2017-05-09 16:03:06', '2017-05-09 14:03:06', '', '44. Religie en religieuze vieringen', '', 'inherit', 'closed', 'closed', '', '93-revision-v1', '', '', '2017-05-09 16:03:06', '2017-05-09 14:03:06', '', '93', 'http://canon.bramperry.nl/93-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('95', '1', '2017-05-09 16:03:22', '2017-05-09 14:03:22', '<em>Handel vanaf het begin</em>\r\n\r\nCuraçao ligt zo dicht voor de kust van Venezuela dat je het op heldere dagen zelfs kunt zien. Al eeuwenlang voeren er <a href=\"https://canoncuracao.cw/1-de-oorspronkelijke-bewoners/\">indianen</a> op grote kano’s heen en weer tussen Venezuela en Curaçao en ongetwijfeld namen zij fruit en groente mee, zoals de barkjes nu nog steeds doen, maar nadat Curaçao in het begin van de zestiende eeuw was ingenomen door <a href=\"https://canoncuracao.cw/2-de-spaanse-periode/\">Spanje</a> en het eiland in 1634 was veroverd door de <a href=\"https://canoncuracao.cw/3-verovering-van-curacao-door-de-wic-en-de-komst-van-de-hollanders/\">Hollanders</a>, nam de handel toe. Van Curaçao naar Venezuela werden wapens, tot slaaf gemaakten en allerlei handelswaar vervoerd en van Venezuela naar Curaçao vooral cacao, tabak en dierenhuiden. Omdat de Spanjaarden de handel met Venezuela verboden hadden, ontstond er een levendige smokkelhandel (‘contrabanda’) die eeuwen zou duren.\r\n\r\n<em>Onrust na de onafhankelijkheid van Venezuela</em>\r\n\r\nDoordat Venezuela zich onder leiding van <a href=\"https://canoncuracao.cw/12-brion-piar-bolivar/\">Simón Bolívar</a> in 1821 losmaakte van Spanje, werd Curaçao steeds belangrijker voor wat er in Venezuela gebeurde. Na het mislukken van de eerste onafhankelijkheidsstrijd vluchtte Bolívar naar Curaçao, waar hij hulp kreeg van Curaçaoënaars, onder anderen Brion, die admiraal van zijn vloot werd en Piar, die generaal in zijn leger werd. Uiteindelijk werd de vrijheidsoorlog door Bolívar alsnog gewonnen, maar daarna werd het een onrustige tijd met veel burgeroorlogen in Venezuela. Afgezette leiders vluchtten vaak naar Curaçao, waar ze wapens kochten en weer in Venezuela aan de macht probeerden te komen. Door de nabije ligging had Curaçao zo de mogelijkheid het politieke systeem in Venezuela te beïnvloeden.\r\n\r\n<em>Relatieve rust na de komst van de olie-industrie</em>\r\n\r\nDe relatie veranderde toen er olie in Venezuela werd gevonden en de Shell na 1914 een grote raffinaderij op Curaçao bouwde waar de ruwe olie uit het Lago de Maracaibo werd verwerkt. Omdat dit economisch zo belangrijk was, kwam de relatie tussen Curaçao en Venezuela in een rustiger vaarwater terecht. Deze rust werd nog even verstoord toen de opstandeling Rafael Urbina in 1929 het Waterfort, bij Fort Amsterdam, met geweld overviel en met de buitgemaakte wapens en de gegijzelde gouverneur Fruytier op een schip naar Venezuela vertrok. Dit had echter geen langdurig negatief effect op de relatie.\r\n\r\n<em>Meer kans op spanningen in de relatie</em>\r\n\r\nIn de jaren 80 <a href=\"https://canoncuracao.cw/33-vertrek-shell-komst-en-vertrek-pdvsa/\">verliet de Shell Curaçao</a> en werd de raffinaderij voor lange termijn verhuurd aan de Venezolaanse staatoliemaatschappij PdVSA, waardoor de invloed van Venezuela op Curaçao groter werd. Door de sociaal-economische crisis in Venezuela na de dood van president Hugo Chávez in 2013, is nu de kans op spanningen in de relatie weer toegenomen. Met het vertrek van de PdVSA van Curaçao, zal er weer een nieuwe periode in de relatie aanbreken.\r\n\r\nAfgezien van bestuurlijke en handelsrelaties, zijn er in de loop van de eeuwen zeer veel familierelaties ontstaan tussen de bevolkingen van Curaçao en Venezuela. Ook op cultureel gebied (muziek, keuken) heeft Venezuela een sterke invloed gehad op Curaçao.\r\n\r\n&nbsp;', '45. De relatie met Venezuela', '', 'publish', 'closed', 'closed', '', '45-relatie-venezuela', '', '', '2020-11-05 16:47:24', '2020-11-05 15:47:24', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=95', '44', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('96', '1', '2017-05-09 16:03:22', '2017-05-09 14:03:22', '', '45. De relatie met Venezuela', '', 'inherit', 'closed', 'closed', '', '95-revision-v1', '', '', '2017-05-09 16:03:22', '2017-05-09 14:03:22', '', '95', 'http://canon.bramperry.nl/95-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('97', '1', '2017-05-09 16:04:21', '2017-05-09 14:04:21', 'Vanaf de late negentiende eeuw waren scholing en studie de belangrijkste redenen voor Curaçaoënaars om zich voor enkele jaren in Nederland te vestigen. Aanvankelijk betrof dit overwegend kinderen van de Protestantse elite. Joodse families gaven traditioneel de voorkeur aan een opleiding in de Verenigde Staten.\r\n\r\nAan het begin van de twintigste eeuw werd een studie in Nederland ook voor een kleine groep jongeren uit de overwegend Katholieke middenklasse mogelijk dankzij de steun van het Algemeen Nederlands Verbond of de <a href=\"https://canoncuracao.cw/20-komst-religieuze-ordes-nederland-en-betekenis/\">Fraters van Tilburg</a>. Bekende Curaçaoënaars die in deze periode hun opleiding in Nederland voltooiden zijn hoofdonderwijzer John Horris Sprockel en de juristen Dr. Charles Willem de la Try Ellis en <a href=\"https://canoncuracao.cw/26-dr-f-da-costa-gomez/\">Dr. Moises da Costa Gomez</a>. Het is niet verwonderlijk dat juist deze personen zich later hebben ingezet voor het bevorderen van onderwijskansen voor nieuwe generaties Curaçaoënaars. Zo was Sprockel verantwoordelijk voor het verhogen van de onderwijskwaliteit in de buitendistricten en Da Costa Gomez voor de introductie van een overheidsprogramma voor bursalen.\r\n\r\nHet feit dat een toenemend aantal jongeren in de late jaren ’50 en <a href=\"https://canoncuracao.cw/29-60er-jaren-sfeer-verandering/\">jaren ’60</a> ging studeren in Nederland zou grote gevolgen hebben voor de Curaçaose samenleving. In de eerste plaats vond een geleidelijke <a href=\"https://canoncuracao.cw/8-papiamentu/\">Antillianisering</a> plaats in het <a href=\"https://canoncuracao.cw/41-onderwijs-op-curacao/\">onderwijs</a>, de gezondheidszorg, het ambtenarenapparaat en in bestuur. Het leven in diaspora had daarnaast grote impact op de maatschappelijke houding van veel jonge professionals. Eenmaal terug op hun geboorte-eiland werden velen van hen fanatiek in de <a href=\"https://canoncuracao.cw/24-de-arbeidersbeweging/\">vakbond</a>, de <a href=\"https://canoncuracao.cw/31-vrouwenemancipatie/\">vrouwenbeweging</a> en in sociale protestacties. In <a href=\"https://canoncuracao.cw/32-cultureel-levende-culturele-dynamiek-jaren-70/\">de jaren ’70</a> en ’80 werd het steeds minder vanzelfsprekend om na de studie terug te keren. Dit leidde tot een enorm capaciteitsverlies voor de eilanden. Deze ‘brain drain’ - tot op heden een groot maatschappelijk probleem - was een belangrijke reden voor de oprichting van de Universiteit van de Nederlandse Antillen in 1979.\r\n\r\nVanaf de jaren ’80 kwamen Curaçaoënaars in Nederland steeds vaker negatief in het nieuws. De enorme economische malaise van begin jaren ’90 leidde tot een omvangrijke migratie van veelal kansarme, laagopgeleide eilandbewoners naar Nederland. Velen verging het niet goed. Het SCP-rapport “Integratie in zicht?” geeft cijfers over de Antilliaanse gemeenschap in Nederland over de periode 1994-2014. Aangezien het merendeel van de Antilliaanse gemeenschap in Nederland van Curaçaose afkomst is, geven deze cijfers een goed beeld van de Curaçaose gemeenschap. Zo wordt duidelijk dat in tegenstelling tot andere minderheidsgroepen bij deze bevolkingsgroep in de afgelopen twintig jaar geen stijging zichtbaar is in het onderwijsniveau. Er is structureel sprake van hoge werkloosheid in deze groep en een relatief hoge aanwezigheid in criminaliteitscijfers. Dit heeft aanleiding gegeven tot specifiek doelgroepenbeleid, zoals dat van de Taskforce Antilliaanse jongeren, 1993-1997.\r\n\r\nHet beeld van Curaçaoënaars in diaspora is echter niet alleen somber; velen hebben een prominente plek in hun discipline kunnen verwerven. In vrijwel alle gevallen bleven de banden met Curaçao warm; in toenemende mate wordt dit vertaald in concrete samenwerkingen binnen het <a href=\"https://canoncuracao.cw/28-het-statuut/\">Koninkrijk</a>. Inspanningen van Curaçaoënaars in diaspora hebben daardoor steeds vaker een transnationaal karakter, zoals de recente filmproductie Buladó en theaterproductie Papia.', '46. Het leven van Curaçaoënaars in de diaspora', '', 'publish', 'closed', 'closed', '', '46-het-leven-van-curacaoenaars-in-de-diaspora', '', '', '2020-11-19 09:43:25', '2020-11-19 08:43:25', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=97', '45', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('98', '1', '2017-05-09 16:04:21', '2017-05-09 14:04:21', '', '46. Het leven van Curaçaoënaars in de diaspora', '', 'inherit', 'closed', 'closed', '', '97-revision-v1', '', '', '2017-05-09 16:04:21', '2017-05-09 14:04:21', '', '97', 'http://canon.bramperry.nl/97-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('103', '1', '2017-05-09 16:06:49', '2017-05-09 14:06:49', 'De eerste “tele” communicatie middelen op Curaçao waren visuele signalen: licht (vuur, spiegels) en rook, later (zeemans) vlaggen. Curaçao werd in 1887 aangesloten op het wereldtelegraafnet via de Franse kabel. Spanningen met <a href=\"https://canoncuracao.cw/45-relatie-venezuela/\">Venezuela</a> in 1908 waren er de oorzaak van dat een draadloze vonkzender werd aangelegd voor de communicatie met de oorlogsschepen die Nederland hierheen had gestuurd. Het kuststation werd in oktober 1908 gebouwd op het Riffort onder leiding van officier A.J.W. van Anrooy.\r\n\r\nIn 1911 kwamen ook op Aruba en Bonaire draadloze zenders. Van Anrooy zorgde tevens voor de eerste telegrafistenopleiding. In 1912 werd de Landsradiodienst (LRD) opgericht, waar de telegrafisten kwamen te werken. De zenders werden in 1916 overgedragen aan het Gouvernement en werden geëxploiteerd door de LRD. In 1927 werd de LRD samengevoegd met de Telefoondienst: de Landsradio en Telefoondienst - later Landsradio en Telecommunicatiedienst (LRTD) ontstond. In de oorlogsjaren zorgde de Amerikaanse militaire aanwezigheid voor modernisering van apparatuur.\r\n\r\nDe telefoon was aanvankelijk een particuliere zaak van Abraham Ugueto, die 1892 zijn bedrijf opende. Toen de particuliere concessie in 1927 ten einde liep, nam het gouvernement de telefonie over. De <a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">olieraffinaderij</a> (C.P.I.M. – later Shell) had een eigen centrale ingericht. In 1927 waren er 310 telefoonaansluitingen (waarvan 279 in de stad) en het telefoonnet had een totale lengte van 480 km.\r\n\r\nMet het ingaan van de Interimregeling (1951) waarbij landstaken naar de pas ingestelde eilandgebieden werden overgedragen, werd de LRTD gesplitst. De lokale telefonie ging naar de eilandgebieden (1 oktober 1952). De internationale telefonie bleef een landsaangelegenheid. De splitsing heeft de bedrijfsvoering bemoeilijkt en pas in 1999 werden deze bedrijfsprocessen weer in één bedrijf samengevoegd. De lokale telefoondienst ging in 1979 over in een Naamloze Vennootschap – Setel NV. Met een moderniseringsprogramma nam het aantal abonnees spectaculair toe. De belangrijkste ontwikkeling in de internationale communicatie was de aanleg van een zeekabel tussen Curaçao – Sint Maarten – St. Thomas in 1973. Het telecomcentrum Vredenberg, aanlandingspunt van de zeekabel, werd in 1972 opgeleverd.\r\n\r\nDe eerste satellietontvangers kwamen in 1978. Door de verbeterde internationale communicatie kon vooral de offshore industrie in de jaren zeventig en tachtig opbloeien. Onder druk van de Amerikaanse Federal Communications Commission (FCC) werden vanaf 1996 wereldwijd de interconnectietarieven sterk verlaagd, een ontwikkeling die het wereldwijde Internet verkeer zou moeten faciliteren. Dat jaar werd LRTD omgezet in Antelecom NV. Setel NV en Antelecom NV zijn in 1999 samengegaan in een nieuwe holdersmaatschappij United Telecom Services (UTS).\r\n\r\nDe opkomst van mobiel telefoneren nam een hoge vlucht na 2000 en er kwamen vele participaties in fiber-optic zeekabels voor het toegenomen dataverkeer. De nieuwe wetgeving uit 1995 bepaalde dat de telecommunicatiemarkt in de Nederlandse Antillen in 2001 zou worden geliberaliseerd. Sindsdien zijn er meerdere aanbieders actief. Vanaf ca. 2010 nam de ontwikkeling van \"VOIP\" (<span class=\"st\">Voice over Internet Protocol) in rap tempo toe, waardoor winstmarges van UTS en andere providers afnamen. \"</span>Liberty Latin America\" nam in 2019 een meerderheidsbelang in UTS.', '48. De ontwikkeling van de telecommunicatie', '', 'publish', 'closed', 'closed', '', '48-de-ontwikkeling-van-het-electriciteitsnet-de-watervoorziening-en-het-telefoonnet', '', '', '2020-11-19 09:25:58', '2020-11-19 08:25:58', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=103', '48', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('104', '1', '2017-05-09 16:06:49', '2017-05-09 14:06:49', '', '49. De ontwikkeling van het electriciteitsnet, de watervoorziening en het telefoonnet', '', 'inherit', 'closed', 'closed', '', '103-revision-v1', '', '', '2017-05-09 16:06:49', '2017-05-09 14:06:49', '', '103', 'http://canon.bramperry.nl/103-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('105', '1', '2017-05-09 16:07:09', '2017-05-09 14:07:09', 'Wij rijden tegenwoordig per auto in iets meer dan een half uur van Westpunt naar <a href=\"https://canoncuracao.cw/10-ontwikkeling-willemstad/\">Punda</a>, maar vroeger ging men vanuit de <a href=\"https://canoncuracao.cw/11-ontwikkeling-nederzettingen-en-barios-buiten-willemstad/\">buitendistricten </a>te voet naar de stad en men deed er dan vaak een hele dag over en vaak nog langer. Als er koopwaar werd meegebracht, werd dit in een mand op het hoofd gedragen. Soms maakte men gebruik van een ezel of een paard. Sommige stadsbewoners gebruikten een <em>kitoki</em>, een paard met wagen bestuurd door een koetsier. Vanaf 1884 reed er een paardentram door de Breedestraat Punda via Pietermaai naar Scharloo. Vanaf 1911 was de tram gemotoriseerd. In 1920 werd de tramwegdienst opgeheven.\r\n\r\nVoordat de pontonbrug Punda en Otrobanda met elkaar verbond (1888), werden mensen over de Sint Annabaai vervoerd in pontjes (<em>ponchi</em>). De plek op de voorkant van de boot was gratis omdat men daar vaak werd natgespat. Dit verklaart de uitdrukking voor ‘een lift geven’ in het Papiaments: ‘duna un kabes di boto’.\r\n\r\nVoordat de waterleiding werd aangelegd, werd water vaak vervoerd met een ezelskarretje (<em>garoshi di awa</em>).\r\n\r\nDe eerste auto werd in 1910 geïmporteerd. In de jaren dertig en daarna nam het aantal auto’s sterk toe. Fietsen zijn nooit erg populair geweest op het eiland, met uitzondering van een korte periode van 1920 tot begin jaren vijftig toen veel werknemers van de <a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">raffinaderij </a>een fiets gebruikten voor korte afstanden.\r\n\r\nHet openbaar vervoer werd eerst verzorgd door particuliere autobusbedrijven, die vanaf 1918 bepaalde routes reden. Een ander vervoermiddel dat werd ingezet voor het openbaar vervoer waren grote station-wagons, in de volksmond aangeduid als trucks. De <a href=\"https://canoncuracao.cw/25-tweede-wereldoorlog/\">Tweede Wereldoorlog </a>bracht een grote vraag naar openbaar vervoer met zich mee en in die tijd is het model van openbaar vervoer zoals wij dat nu kennen, ontstaan: taxi’s/huurauto’s, kleine bussen en grote bussen (<em>konvois</em>). ‘ABC’, Autobus Bedrijf Curaçao, is in 1943 opgericht.\r\n\r\nDankzij de grote natuurlijke <a href=\"https://canoncuracao.cw/23-de-haven/\">haven</a> is Curaçao altijd een centrum geweest voor de scheepvaart. In de stad woonden dan ook altijd veel zeelui, zowel vrijen als <a href=\"https://canoncuracao.cw/5-de-slavenhandel-en-slaverij/\">tot slaaf gemaakten</a>. Curaçao was ook een uitvalsbasis voor Nederlandse kapers. Op de scheepswerven in de Sint Annabaai werden ook zeilschepen gebouwd. In 1827 voer het eerste stoomschip (met de toepasselijke naam de ‘Curaçao’) de haven binnen en vanaf 1910 werden schepen steeds meer gemotoriseerd. Reeds in 1901 kwam het eerste cruiseschip aan. Het <a href=\"https://canoncuracao.cw/35-oil-as-king-tot-tourism-as-king/\">cruisetoerisme</a> bereikte een hoogtepunt in 1976 en nam toen af omdat door de stijgende olieprijzen de scheepsreizen naar Curaçao te duur werden. Naderhand is het cruisetoerisme weer heel erg toegenomen.\r\n\r\nHet luchtverkeer begon in 1923 toen twee Amerikaanse watervliegtuigen hier landden. Vanaf 1924 probeerde de Sociedad Colombiana Alemana de Transporte Aereos (Scadta) een geregelde luchtvaartverbinding op te zetten tussen Barranquilla in Colombia en Curaçao, maar dat is nooit van de grond gekomen. Op een eilandje, het Scadta- eiland, waar later de Amstel Brouwerij was gevestigd, werd een klein vliegveld aangelegd. De luchtvaart nam echt een aanvang toen het KLM-toestel, de ‘Snip’, hier in 1934 landde. De KLM onderhield de trans-Atlantische verbinding, maar voor regionale verbindingen werd in 1964 de ALM opgericht die tot 2002 heeft bestaan. Lokale luchtvaartmaatschappijen die na het faillissement van de ALM zijn ontstaan, hebben het niet gemakkelijk, getuige de faillissementen van DCA, DCE en Insel Air.', '49. Transport', '', 'publish', 'closed', 'closed', '', '49-transport', '', '', '2020-11-19 09:43:51', '2020-11-19 08:43:51', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=105', '49', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('106', '1', '2017-05-09 16:07:09', '2017-05-09 14:07:09', '', '50. Transport', '', 'inherit', 'closed', 'closed', '', '105-revision-v1', '', '', '2017-05-09 16:07:09', '2017-05-09 14:07:09', '', '105', 'http://canon.bramperry.nl/105-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('107', '1', '2017-05-09 16:07:19', '2017-05-09 14:07:19', 'De opkomst van de media op Curaçao gaat terug naar het begin van de negentiende eeuw. Kleine Curaçaose drukkerijen, bijvoorbeeld die van Augustin Bethencourt, speelden in die tijd een belangrijke regionale rol. In veel buurlanden was censuur en daarom vond drukwerk dat controversieel leek in de ogen van de autoriteiten hier een plek. De eerste Curaçaose krant, de ‘Curaçao Gazette’ verscheen in 1812 in het Engels. De tweede krant, de ’Amigoe’, in het Nederlands, werd geïnitieerd door de rooms-katholieke Kerk en verscheen voor het eerst in 1883 en bestaat nog steeds. In 1889 verscheen: ‘La Union’ en in 1900 ‘La Cruz’, beide opgericht door de katholieke kerk om de bevolking in het Papiaments te kunnen bereiken. In 1930 begon de olieraffinaderij Shell met het publiceren van de ‘Beurs en Nieuwsberichten’, in het Nederlands. De eerste krant in het Spaans, La Prensa, verscheen in 1928. De opstand van <a href=\"https://canoncuracao.cw/30-dertig-mei-1969/\">30 mei 1969</a> leidde tot een groei van het aantal <a href=\"https://canoncuracao.cw/8-papiamentu/\">Papiamentstalige</a> kranten.\r\n\r\nDe media op Curaçao waren in de twintigste eeuw sterk verbonden met religie, politiek of beide, en hadden slechts weinig middelen. Zo waren de drie invloedrijke kranten, La Cruz, La Union en Amigoe in handen van de <a href=\"https://canoncuracao.cw/20-komst-religieuze-ordes-nederland-en-betekenis/\">katholieke kerk</a>. Media krijgen tot vandaag de dag veel kritiek op het gebrek aan onafhankelijke journalistiek, hun oppervlakkigheid en hun gebrek aan een kritische en analytische aanpak. Zo waarschuwde de UNESCO in 2016 dat de media op Curaçao niet in staat zijn hun rol als waakhond ten opzichte van de overheid en de andere machtige actoren in de samenleving goed te vervullen. Maar er zijn ook momenten in de geschiedenis geweest waarbij de media een belangrijke rol speelden. Zo werden er in de periode voor de opstand van 30 mei 1969 diverse bladen opgericht die de sociaal-economische ongelijkheid op Curaçao veroordeelden. Vooral het blad Vitó, dat in 1967 in het Papiaments begon te publiceren, kreeg een groot aantal aanhangers, ook onder de onderlaag van de bevolking. Hoofdredacteur Stanley Brown werd na de opstand veroordeeld voor het publiceren van opruiende teksten, die, naar men meende, aanleiding hadden gegeven tot de opstand in mei 1969. Frank Martinus Arion gaf in dezelfde tijd ‘Ruku’ uit, ook in het Papiaments, met gelijkluidende maatschappelijke aanklachten.\r\n\r\nCuraçao kent heden ten dage een groot aantal media: er zijn zo\'n 30 radiostations, zeven  kranten, vier tv-stations en diverse nieuwssites voor de bevolking van een eiland met iets meer dan 150.000 inwoners. Samen ondersteunen ze een levendige debatcultuur en vooral de radio, met talrijke populaire inbelprogramma’s, is niet weg te denken uit het dagelijks leven. Net als in de rest van de wereld spelen social media ook op Curaçao een steeds belangrijkere rol in de nieuwsvoorziening. Curaçaoënaars op het eiland en daarbuiten volgen opiniemakers en journalisten vooral via Facebook, maar starten ook zelf een online radiostation, blog of website over de actualiteiten.', '50. Media', '', 'publish', 'closed', 'closed', '', '50-media', '', '', '2020-11-19 09:26:21', '2020-11-19 08:26:21', '', '0', 'http://canon.bramperry.nl/?post_type=venster&#038;p=107', '50', 'venster', '', '0');
INSERT INTO `wp_posts` VALUES('108', '1', '2017-05-09 16:07:19', '2017-05-09 14:07:19', '', '51. Media', '', 'inherit', 'closed', 'closed', '', '107-revision-v1', '', '', '2017-05-09 16:07:19', '2017-05-09 14:07:19', '', '107', 'http://canon.bramperry.nl/107-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('110', '1', '2017-05-12 13:42:07', '2017-05-12 11:42:07', 'De geschiedenis van Aruba en Bonaire is sterk verbonden met die van Curaçao. Deze twee eilanden worden in 1634 veroverd om te verhinderen dat Spanje via hen Curaçao zou kunnen aanvallen. Niettemin vinden er tijdens de periode van de Westindische Compagnie (WIC, 1634-1791) ook lokale activiteiten plaats: in Aruba dankzij het droge klimaat vooral veeteelt, de overgebleven Caiquetios gaan door met het fokken van muilezels en paarden. Hoewel in de negentiende eeuw goud en fosfaat werd gewonnen op Aruba, zorgde dit niet voor veel economische voorspoed. Pas toen in de twintigste eeuw ook op Aruba een raffinaderij werd gevestigd veranderde de economie radicaal. Na de Tweede Wereldoorlog zorgt het toerisme voor veel voorspoed. Op Bonaire vindt tijdens de WIC-periode landbouw plaats en de bestaande Spaanse zoutpannen worden intensief gebruikt. Dit blijft zo tot in de twintigste eeuw, dan probeert de mannelijke Bonaireaan zijn inkomen vooral op Aruba of Curaçao te verdienen in de daar ontstane industrie. Dit zorgt voor een zogenaamde postwissel-economie: deze mannen sturen een deel van hun salaris naar Bonaireen de vrouwen vullen dit aan met huisindustrie en landbouw.\r\n\r\nOp de Bovenwindse Eilanden ontstaat een andere samenleving: hier zijn het vooral de Zeeuwse steden, die investeren in de WIC, die het voortouw nemen. Eerst wordt in 1630 kortstondig St.-Maarten veroverd, vooral om haar ligging op de route van de Spaanse Zilvervloot om deze makkelijker te kunnen kapen. Die bedreiging beëindigt Spanje heel snel, pas in 1648 zal het eiland samen met Frankrijk veroverd en verdeeld worden, waarna het vooral landbouw en zoutwinning oplevert. Van veel groter belang wordt vanaf 1636 St.-Eustatius: het heeft een natuurlijke haven die door de Zeeuwse handelaren vooral voor de Transatlantische slavenhandel wordt gebruikt. Dit levert veel geld op, waardoor St.-Eustatius in de achttiende eeuw de bijnaam ‘The Golden Rock’ krijgt. Deze voorspoed verdwijnt als de spanningen tussen de Europese grote landen Groot-Brittannië en Frankrijk ook in het Caribisch Gebied wordt uitgevochten. In 1781 verwoesten de Britten St.-Eustatius, een klap die het niet te boven komt. Saba speelt in de Bovenwinden de rol van Aruba en Bonaire: veroverd in 1640 ter bescherming van St.-Eustatius. In de negentiende en de eerste helft van de twintigste eeuw worden de drie Bovenwindse Eilanden totaal verwaarloosd. Daarom vindt er vooral vanaf 1920 veel arbeidsmigratie plaats naar Aruba en Curaçao. Pas als het cruise- en casinotoerisme zich na 1960 vooral op St.-Maarten ontwikkelt, ontstaat er weer bevolkingsgroei.', '47. De andere eilanden van de Nederlandse Antillen', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2017-05-12 13:42:07', '2017-05-12 11:42:07', '', '6', 'http://canon.bramperry.nl/6-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('111', '1', '2017-05-12 13:42:55', '2017-05-12 11:42:55', 'De geschiedenis van Aruba en Bonaire is sterk verbonden met die van Curaçao. Deze twee eilanden worden in 1634 veroverd om te verhinderen dat Spanje via hen Curaçao zou kunnen aanvallen. Niettemin vinden er tijdens de periode van de Westindische Compagnie (WIC, 1634-1791) ook lokale activiteiten plaats: in Aruba dankzij het droge klimaat vooral veeteelt, de overgebleven Caiquetios gaan door met het fokken van muilezels en paarden. Hoewel in de negentiende eeuw goud en fosfaat werd gewonnen op Aruba, zorgde dit niet voor veel economische voorspoed. Pas toen in de twintigste eeuw ook op Aruba een raffinaderij werd gevestigd veranderde de economie radicaal. Na de Tweede Wereldoorlog zorgt het toerisme voor veel voorspoed. Op Bonaire vindt tijdens de WIC-periode landbouw plaats en de bestaande Spaanse zoutpannen worden intensief gebruikt. Dit blijft zo tot in de twintigste eeuw, dan probeert de mannelijke Bonaireaan zijn inkomen vooral op Aruba of Curaçao te verdienen in de daar ontstane industrie. Dit zorgt voor een zogenaamde postwissel-economie: deze mannen sturen een deel van hun salaris naar Bonaire en de vrouwen vullen dit aan met huisindustrie en landbouw.\r\n\r\nOp de Bovenwindse Eilanden ontstaat een andere samenleving: hier zijn het vooral de Zeeuwse steden, die investeren in de WIC, die het voortouw nemen. Eerst wordt in 1630 kortstondig St.-Maarten veroverd, vooral om haar ligging op de route van de Spaanse Zilvervloot om deze makkelijker te kunnen kapen. Die bedreiging beëindigt Spanje heel snel, pas in 1648 zal het eiland samen met Frankrijk veroverd en verdeeld worden, waarna het vooral landbouw en zoutwinning oplevert. Van veel groter belang wordt vanaf 1636 St.-Eustatius: het heeft een natuurlijke haven die door de Zeeuwse handelaren vooral voor de Transatlantische slavenhandel wordt gebruikt. Dit levert veel geld op, waardoor St.-Eustatius in de achttiende eeuw de bijnaam ‘The Golden Rock’ krijgt. Deze voorspoed verdwijnt als de spanningen tussen de Europese grote landen Groot-Brittannië en Frankrijk ook in het Caribisch Gebied wordt uitgevochten. In 1781 verwoesten de Britten St.-Eustatius, een klap die het niet te boven komt. Saba speelt in de Bovenwinden de rol van Aruba en Bonaire: veroverd in 1640 ter bescherming van St.-Eustatius. In de negentiende en de eerste helft van de twintigste eeuw worden de drie Bovenwindse Eilanden totaal verwaarloosd. Daarom vindt er vooral vanaf 1920 veel arbeidsmigratie plaats naar Aruba en Curaçao. Pas als het cruise- en casinotoerisme zich na 1960 vooral op St.-Maarten ontwikkelt, ontstaat er weer bevolkingsgroei.', '47. De andere eilanden van de Nederlandse Antillen', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2017-05-12 13:42:55', '2017-05-12 11:42:55', '', '6', 'http://canon.bramperry.nl/6-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('112', '1', '2017-05-12 13:43:44', '2017-05-12 11:43:44', 'Tot de komst van de Westindische Compagnie in 1634 werden de Benedenwindse Eilanden bewoond door clans van de Caiquetios, die na 1499 werden bestuurd door Spanjaarden. Johan van Walbeeck verwijderde alle Spanjaarden en een groot gedeelte van de Caiquetios van de eilanden. Daarmee zijn deze in feite vrijwel zonder inwoners. De komst van de WIC zorgt ervoor dat de bevolking in de eerste Nederlandse jaren voornamelijk uit Europese mannen bestaat. Dat leidt tot een nogal woeste samenleving, waar de dominee regelmatig over klaagt. De opeenvolgende Directeuren van de WIC vragen de WIC regelmatig om ‘nette’ vrouwen te sturen, maar er is nog weinig aantrekkelijks voor deze vrouwen om naar Curaçao te komen. Pas als Peter Stuyvesant en zijn opvolger Mathias Beck het Directeurschap op zich nemen rond 1645, let men meer op de leefomstandigheden op de eilanden. Vooral de zorgelijke voedselsituatie krijgt aandacht: de WIC is een bedrijf dat winst moet maken, dan is de noodzaak om voedsel te importeren een kostbare zaak. Daarom nodigt Stuyvesant tijdens zijn bewind Sefardische joden, die uit Spanje en Portugal naar Nederland waren gevlucht voor de Inquisitie, uit om plantages te starten op de eilanden, zodat hiermee lokaal voldoende voedsel kon worden geproduceerd. Ook verandert de manier waarop de compagnie Curaçao wil gebruiken: was eerst de Kaapvaart het argument om de Benedenwindse Eilanden in bezit te nemen, in de praktijk blijkt dat die te weinig oplevert. Maar, de in Brazilië opgedane kennis over de Transatlantische Slavenhandel zorgt ervoor dat de WIC zich realiseert dat Curaçao ideaal is als regionale slavenmarkt. Dit leidt tot vier groepen bewoners: het restantCaiquetios (vooral op Aruba), de Europeanen, de Sefardische Joden en de tot slaaf gemaakte Afrikanen vormen vanaf de tweede helft van de zeventiende eeuw de bevolking. Deze samenleving ontwikkelt een manier van omgaan en indeling die lijkt op die van de standensamenleving in Europa: de gesegmenteerde maatschappij. Een segment is een groep mensen die daartoe behoren door geboorte, afkomst, huidskleur en geloof, waarbij het wisselen van segment vrijwel onmogelijk is. Tevens hebben de leden van sommige segmenten meer rechten dan anderen. De indeling loopt van de hoge blanke protestant, zoals de kooplieden en hoge WIC-ambtenaren met veel rechten tot de tot slaaf gemaakt Afrikanen die geen enkel recht hebben. Daartussen bewegen zich de andere groepen, zoals de Sefardische Joden, lage blanke protestanten en de kleurlingen, de laatste groep het gevolg van relaties tussen Europeanen en Afrikanen.', '4. Nieuwe bewoners in de zeventiende eeuw', '', 'inherit', 'closed', 'closed', '', '4-revision-v1', '', '', '2017-05-12 13:43:44', '2017-05-12 11:43:44', '', '4', 'http://canon.bramperry.nl/4-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('113', '1', '2017-05-12 13:44:44', '2017-05-12 11:44:44', '<h3>De verovering van Curaçao</h3>\r\nCuraçao werd in 1634 door de West-Indische Compagnie (WIC) veroverd op de Spanjaarden.\r\n\r\nDe Republiek was op dat moment verwikkeld in de Tachtigjarige Oorlog (1568-1648) met Spanje en metPortugal. Deze landen waren sinds 1580 verenigd waren onder één staatshoofd, de Spaanse koning. De WIC was in 1621 opgericht om te dienen als een instrument in die oorlog. Behalve met de uitvoering van een ambitieus plan, het ‘groot desseyn’,dat gericht was op het veroveren van Portugese gebieden in Afrika en Brazilië, was de WIC vooral actief in de kaapvaart. Er bestond daarom behoefte aan een maritiem steunpunt in het operatiegebied van waaruit militaire acties konden worden ondernomen.Het strategischgunstig gelegen Curaçao was daarvoor uitstekend geschikt. Het eiland was goed verdedigbaar en beschikte over een uitstekende natuurlijke haven, de Sint-Annabaai.\r\n\r\nEen expeditie onder leiding van Johannes van Walbeecken Pierre le Grand slaagde er vrij eenvoudigin om Curaçaote overmeesteren. De kleine Spaanse bezetting werd samen met het grootste deel van de inheemse bevolking gedeporteerd naar Venezuela. Daarna werd een begin gemaakt met het op orde brengen van de verdediging. Aan oostelijke zijde van de ingang van de Sint-Annabaai op een landtong die De Punt (Punda) werd genoemd werd een sterkte gebouwd, fort Amsterdam.\r\n\r\n&nbsp;\r\n<h3>Van oorlogsbasis naar vestigingskolonie</h3>\r\nGedurende de eerste jaren na de verovering verbleven er op Curaçao in hoofdzaak militairen. In 1635 waren slechts 20 van de 412 compagniesdienaren burgers. Er woondenverderzo’n 50 inheemse bewoners. Spoedig arriveerden ook Afrikaanse slaven. Deze waren aanvankelijk vooral afkomstig van veroverde vijandelijke schepen. Maar hun aantallen waren tot midden zeventiende eeuw nog gering.\r\n\r\nVrijwel direct nadat bekend werd dat Curaçao was veroverd, ontstond er in het moederland belangstelling voor kolonisatieprojecten. Militairen en civiele beambten op het eiland,die hun contract hadden uitgediend, kregen ook de mogelijkheid om zich als landbouwer te vestigen. Maar dit leidde nauwelijks tot concrete resultaten.\r\n\r\nIn de jaren vijftig van zeventiende eeuw vestigden zich joodse kolonisten op het eiland. In 1665 woonden er, de inheemse bevolking niet meegerekend, zo’n 600 personen.Curaçao had inmiddels geen functie meer als oorlogsbasis, maar ontwikkelde zich nu, met de vanaf 1650 opkomende slavenhandel als motor, tot een commercieel centrum.Rond deze tijd ontstond ten noorden van fort Amsterdam een vestiging die uitgroeide tot een ommuurde stad, Willemstad. Het aantal plantages en tuinen groeide ook. Deze richtten zich vooral op de lokale voedselproductie.\r\n\r\nHan Jordaan', '3. Verovering van Curaçao door de WIC en de komst van de Hollanders', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2017-05-12 13:44:44', '2017-05-12 11:44:44', '', '12', 'http://canon.bramperry.nl/12-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('114', '1', '2017-05-12 13:45:10', '2017-05-12 11:45:10', '<h3>De verovering van Curaçao</h3>\r\nCuraçao werd in 1634 door de West-Indische Compagnie (WIC) veroverd op de Spanjaarden.\r\n\r\nDe Republiek was op dat moment verwikkeld in de Tachtigjarige Oorlog (1568-1648) met Spanje en metPortugal. Deze landen waren sinds 1580 verenigd waren onder één staatshoofd, de Spaanse koning. De WIC was in 1621 opgericht om te dienen als een instrument in die oorlog. Behalve met de uitvoering van een ambitieus plan, het ‘groot desseyn’,dat gericht was op het veroveren van Portugese gebieden in Afrika en Brazilië, was de WIC vooral actief in de kaapvaart. Er bestond daarom behoefte aan een maritiem steunpunt in het operatiegebied van waaruit militaire acties konden worden ondernomen.Het strategisch gunstig gelegen Curaçao was daarvoor uitstekend geschikt. Het eiland was goed verdedigbaar en beschikte over een uitstekende natuurlijke haven, de Sint-Annabaai.\r\n\r\nEen expeditie onder leiding van Johannes van Walbeecken Pierre le Grand slaagde er vrij eenvoudig in om Curaçao te overmeesteren. De kleine Spaanse bezetting werd samen met het grootste deel van de inheemse bevolking gedeporteerd naar Venezuela. Daarna werd een begin gemaakt met het op orde brengen van de verdediging. Aan oostelijke zijde van de ingang van de Sint-Annabaai op een landtong die De Punt (Punda) werd genoemd werd een sterkte gebouwd, fort Amsterdam.\r\n\r\n&nbsp;\r\n<h3>Van oorlogsbasis naar vestigingskolonie</h3>\r\nGedurende de eerste jaren na de verovering verbleven er op Curaçao in hoofdzaak militairen. In 1635 waren slechts 20 van de 412 compagniesdienaren burgers. Er woonden verder zo’n 50 inheemse bewoners. Spoedig arriveerden ook Afrikaanse slaven. Deze waren aanvankelijk vooral afkomstig van veroverde vijandelijke schepen. Maar hun aantallen waren tot midden zeventiende eeuw nog gering.\r\n\r\nVrijwel direct nadat bekend werd dat Curaçao was veroverd, ontstond er in het moederland belangstelling voor kolonisatieprojecten. Militairen en civiele beambten op het eiland, die hun contract hadden uitgediend, kregen ook de mogelijkheid om zich als landbouwer te vestigen. Maar dit leidde nauwelijks tot concrete resultaten.\r\n\r\nIn de jaren vijftig van zeventiende eeuw vestigden zich joodse kolonisten op het eiland. In 1665 woonden er, de inheemse bevolking niet meegerekend, zo’n 600 personen.Curaçao had inmiddels geen functie meer als oorlogsbasis, maar ontwikkelde zich nu, met de vanaf 1650 opkomende slavenhandel als motor, tot een commercieel centrum.Rond deze tijd ontstond ten noorden van fort Amsterdam een vestiging die uitgroeide tot een ommuurde stad, Willemstad. Het aantal plantages en tuinen groeide ook. Deze richtten zich vooral op de lokale voedselproductie.\r\n\r\nHan Jordaan', '3. Verovering van Curaçao door de WIC en de komst van de Hollanders', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2017-05-12 13:45:10', '2017-05-12 11:45:10', '', '12', 'http://canon.bramperry.nl/12-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('115', '1', '2017-05-12 13:46:30', '2017-05-12 11:46:30', '<h3>Een patriotseputsch</h3>\nToen in1795 de slavenopstanduitbrak,was er politieke onrust in Curaçao. Evenals in de Republiekstonden patriotten en Oranjegezinden tegenover elkaar. En evenals in het moederland, waar in 1795 met Franse steun de Bataafse Republiek werd uitgeroepen, wisten patriotten in Curaçao, gesteund door Franse kapers,in 1796 de macht te grijpen. De Bataafse Republiek kwam als bondgenoot van Frankrijk in de oorlog met Groot-Brittannië. Curaçao werdeen belangrijk maritiem steunpunt voor de Fransen.\n\nHervorming van de defensie\n\nNa de machtswisseling verkeerde het defensieapparaat in chaos. Oranjegezinde officierenvan het garnizoen vertrokken hals over kop vanCuraçao. Kort daarna werd de gouverneur a.i., Jan Jacob Beaujon, die ervan werd verdacht Oranjegezind en pro-Brits te zijn, afgezet. Hij werd opgevolgd door de kapitein van de burgerij Johann RudolfLauffer, die de verdediging van Curaçao reorganiseerde. De oorspronkelijkexclusief blanke burgerwacht werd uitgebreid met vrije niet-blanken en omgedoopt tot Nationale Garde. Deze vrijenwaren afkomstig uit de zeevarende bevolking en hadden ervaring met de bediening van scheepsgeschut. Gekleurde schippers kregen officiersrangen bij het onderdeel artillerie. Dit leidde tot spanningen binnen de Nationale Garde.\n\n&nbsp;\n\nRevolutionaire onrust\n\nGeïnspireerd door de leuzen ‘vrijheid’ en ‘gelijkheid’ van de Franse Revolutie (1789-1799),de succesvolle slavenopstand in de Franse kolonie Saint-Domingue in 1791en de Franse afschaffing van de slavernij in 1792, ontstond in de gehele regio revolutionaire onrust. De leiders van een mislukte opstand in Venezuela vluchtten in 1797 naar Curaçao. Geruchten over hun uitlevering veroorzaakte bijna een muiterij onder artilleristen van de Nationale Garde. In 1799 werden drie Fransen gearresteerdomdat zij, volgens Lauffer, de leiders waren van een complot om een nieuwe slavenopstand te ontketenen en de macht te grijpen. Alle drie werden zij uitgewezen.\n\n&nbsp;\n\nAangevallen door de bondgenoot en gered door de vijand.\n\nIn 1800 verscheen een Franse militaire macht uit Guadeloupe voor de haven om, zo werd gemeld, Curaçao tegen de Britten te beschermen. Vermoed werddat de Fransen uit waren op eenmachtsovername. Dit bleek inderdaad het geval. Na op aandringen van het gouvernement te zijn vertrokken, landden de Franse troepeneen dag later bij Sint-Michielsbaai. Daarna veroverdenzij, gesteund door een groot deel van de Curaçaose slavenbevolking,op Willemstad na vrijwel het gehele eiland. Toen een Brits oorlogsschip voor de haven verscheen en vervolgens ook twee Amerikaanse oorlogsschepen, besloot het gouvernement hun hulp in te roepen. De Fransen werden verdreven, maar een Britse bezetting was het gevolg. In 1802 kwam Curaçao weer in Nederlandse handen.In 1807 veroverden de Britten Curaçao echter opnieuw.\n\n&nbsp;\n\n&nbsp;\n\nHan Jordaan', '9. Curaçao rond 1800', '', 'inherit', 'closed', 'closed', '', '23-autosave-v1', '', '', '2017-05-12 13:46:30', '2017-05-12 11:46:30', '', '23', 'http://canon.bramperry.nl/23-autosave-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('116', '1', '2017-05-12 13:47:20', '2017-05-12 11:47:20', '<h3>Een patriotseputsch</h3>\r\nToen in1795 de slavenopstanduitbrak, was er politieke onrust in Curaçao. Evenals in de Republiek stonden patriotten en Oranjegezinden tegenover elkaar. En evenals in het moederland, waar in 1795 met Franse steun de Bataafse Republiek werd uitgeroepen, wisten patriotten in Curaçao, gesteund door Franse kapers, in 1796 de macht te grijpen. De Bataafse Republiek kwam als bondgenoot van Frankrijk in de oorlog met Groot-Brittannië. Curaçao werd een belangrijk maritiem steunpunt voor de Fransen.\r\n<h3>Hervorming van de defensie</h3>\r\nNa de machtswisseling verkeerde het defensieapparaat in chaos. Oranjegezinde officieren van het garnizoen vertrokken hals over kop vanCuraçao. Kort daarna werd de gouverneur a.i., Jan Jacob Beaujon, die ervan werd verdacht Oranjegezind en pro-Brits te zijn, afgezet. Hij werd opgevolgd door de kapitein van de burgerij Johann RudolfLauffer, die de verdediging van Curaçao reorganiseerde. De oorspronkelijk exclusief blanke burgerwacht werd uitgebreid met vrije niet-blanken en omgedoopt tot Nationale Garde. Deze vrijen waren afkomstig uit de zeevarende bevolking en hadden ervaring met de bediening van scheepsgeschut. Gekleurde schippers kregen officiersrangen bij het onderdeel artillerie. Dit leidde tot spanningen binnen de Nationale Garde.\r\n<h3>Revolutionaire onrust</h3>\r\nGeïnspireerd door de leuzen ‘vrijheid’ en ‘gelijkheid’ van de Franse Revolutie (1789-1799),de succesvolle slavenopstand in de Franse kolonie Saint-Domingue in 1791en de Franse afschaffing van de slavernij in 1792, ontstond in de gehele regio revolutionaire onrust. De leiders van een mislukte opstand in Venezuela vluchtten in 1797 naar Curaçao. Geruchten over hun uitlevering veroorzaakte bijna een muiterij onder artilleristen van de Nationale Garde. In 1799 werden drie Fransen gearresteerd omdat zij, volgens Lauffer, de leiders waren van een complot om een nieuwe slavenopstand te ontketenen en de macht te grijpen. Alle drie werden zij uitgewezen.\r\n<h3>Aangevallen door de bondgenoot en gered door de vijand.</h3>\r\nIn 1800 verscheen een Franse militaire macht uit Guadeloupe voor de haven om, zo werd gemeld, Curaçao tegen de Britten te beschermen. Vermoed werd dat de Fransen uit waren op een machtsovername. Dit bleek inderdaad het geval. Na op aandringen van het gouvernement te zijn vertrokken, landden de Franse troepeneen dag later bij Sint-Michielsbaai. Daarna veroverden zij, gesteund door een groot deel van de Curaçaose slavenbevolking, op Willemstad na vrijwel het gehele eiland. Toen een Brits oorlogsschip voor de haven verscheen en vervolgens ook twee Amerikaanse oorlogsschepen, besloot het gouvernement hun hulp in te roepen. De Fransen werden verdreven, maar een Britse bezetting was het gevolg. In 1802 kwam Curaçao weer in Nederlandse handen.In 1807 veroverden de Britten Curaçao echter opnieuw.\r\n\r\nHan Jordaan', '9. Curaçao rond 1800', '', 'inherit', 'closed', 'closed', '', '23-revision-v1', '', '', '2017-05-12 13:47:20', '2017-05-12 11:47:20', '', '23', 'http://canon.bramperry.nl/23-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('117', '1', '2017-05-12 13:47:49', '2017-05-12 11:47:49', 'Venezuela nationaliseerde de olie-industrie in 1976. Daarmee werd voor Shell voor het eerst sinds 1915 de keten van productie en verwerking die beide in beheer van Shell waren, verbroken. Samen met de afnemende hoeveelheid olie uit Venezuela en stijgende inkoopprijzen kwam een scenario voor vertrek voor Shell steeds nadrukkelijker in beeld.\r\n\r\nIn 1977 kwam Venezuela met een voorstel tot wederzijdse participatie van de Venezolaanse staatsoliemaatschappij en Shell in de raffinaderijen van Cardón en Curaçao, waar Shell echter niet op in is gegaan. Venezuela daarentegen ging niet in op de wensen van Shell Curaçao om preferente prijzen te berekenen voor de raffinaderij van Curaçao. Vanaf begin jaren tachtig hing er daarom een crisissfeer rond de raffinaderij van Curaçao. De raffinaderij was verliesgevend en sluiting was voor Shell onafwendbaar.\r\n\r\nDe slepende onderhandelingen, waarbij ook de Nederlandse en Nederlands Antilliaanse regeringen betrokken waren, gingen uiteindelijk over het garanderen van werkgelegenheid voor de Antillen. Venezuela wilde alleen participeren in de bedrijfsvoering als Shell zou investeren in een moderniseringsprogramma. Shell wilde alleen een investeringsprogramma inzetten bij een gegarandeerde levering van ruwe olie, het liefst tegen preferente prijzen.\r\n\r\nVenezuela had uit commercieel technische overwegingen de voorkeur uitgesproken voor een voortgezet eigendom van Shell boven een eventueel eigendom van de Antilliaanse overheid. Uiteindelijk verkocht Shell de fabriek in 1985 echter toch aan de eilandelijke overheid van Curaçao en werd de bedrijfsvoering door het Venezolaanse Petróleos de Venezuela S.A. (PdVSA) uitgevoerd op basis van een leasecontract. Minister president Maria Liberia-Peters van de Nederlandse Antillen tekende namens de Antillen het lease contract en gold als redder van de werkgelegenheid.\r\n\r\nDe bedrijfsvoering van de raffinaderij werd in beheer van PdVSA wederom sterk gestroomlijnd. Productieprocessen zijn nu veelal geautomatiseerd. Op het immense raffinaderijterrein zijn slechts hier en daar arbeiders zichtbaar, het leeuwendeel is in de controlebunker te werk gesteld. De door Venezuela verlangde upgrading is echter maar ten dele uitgevoerd. In het midden van de jaren negentig werd een nieuwe elektriciteitscentrale op het terrein van de raffinaderij gebouwd, maar verdere grote investeringen zijn achterwege gebleven; de fabriek draait, op een uitzondering na, op de oude installaties. Er heeft ook geen toename van aanvoer van olie plaatsgevonden.\r\n\r\nDe in de jaren negentig vastgestelde Hinderwetvergunning zorgde voor een veelheid aan rechtzaken tegen de raffinaderij of tegen de overheid, hetzij om aan de milieunormen te voldoen of deze te handhaven. Rond de raffinaderij hangt nog steeds de sfeer van een onzekere toekomst. Grote investeringen voor een schonere en veilige fabriek blijven nodig, en om die reden wordt er gezocht naar kapitaalkrachtige partners.', '33. Het vertrek van de Shell en de komst van de PDVSA', '', 'inherit', 'closed', 'closed', '', '71-revision-v1', '', '', '2017-05-12 13:47:49', '2017-05-12 11:47:49', '', '71', 'http://canon.bramperry.nl/71-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('118', '1', '2017-05-12 13:49:55', '2017-05-12 11:49:55', 'In 1634 veroverde de W.I.C. het eiland Curacao. Punda werd het centrum. Hier en in de directe omgeving concentreerde zich de bevolking. Deze bevolking had voedsel nodig. Voor hun personeel en later ook voor de als slaaf hier gebrachte Afrikanen vond men het noodzakelijk om tenminste een deel van het voedsel hier zelf te produceren. Al snel was het grootste deel van Curacao onderverdeeld in plantages <em>(lijkt veel op begin canon 12: kan wel of niet?). </em>Alleen de minder goede gronden, de zogenaamde savaangronden bleven in handen van de overheid. Op al de plantages kwamen buurtgemeenschappen of ‘dorpen’ voor, waar de als slaaf werkzame Afrikanen woonden in ‘kas di pal\'i maishi\'. Dit waren de eerste nederzettingen buiten het stadsdistrict. Ook na de afschaffing van de slavernij bleven veelal deze nederzettingskernen bestaan. Dat was vooral in Banda\'bou het geval. De meeste ex-slaven bleven werken onder ‘paga tera-verhoudingen’. Geleidelijk aan, vooral door conflicten met de plantage-eigenaren en achteruitgang van het plantage-gebeuren verdwenen de meeste van deze buurtgemeenschappen. Knip en Soto zijn hierop uitzonderingen.\r\n\r\nIn de negentiende eeuw ontstonden er aanvullend en later deels vervangend nederzettingskernen op initiatief van de R.K.-kerk. Mgr. Niewindt wilde godsdienst en onderwijs brengen aan de buiten de stad woonachtige donkere bevolking. Daarom verdeelde hij het gebied buiten het stadsdistrict in een beperkt aantal grote parochies. Hij koos voor de centra van die parochies plaatsen die makkelijk bereikbaar waren. In de centra kwam een kerkje en een kunukuschooltje. Hier omheen ontwikkelden zich de eerste kerkdorpen, beginnend met Barber, daarna Santa Rosa en Santa Maria. Daarna werden ze opgesplitst en ontstond bijvoorbeeld de parochie San Willibrordo en Montagne. In deze nederzettingen vestigden zich ex-slaven, die zich losmaakten van de plantages en het paga terasysteem.\r\n\r\nNaast deze kerkelijke initiatieven waren er ook woonkernen van vrije lieden te Westpunt, San Pedro, Seru Fortuna en Boka Sami.\r\n\r\nNaast deze kernen vestigden zich al in de achttiende eeuw vrije lieden op de savaangronden en wel verspreid. Deze ontwikkeling ging na de afschaffing van de ‎slavernij door. De overheid ging vooral eind negentiende eeuw percelen domeingronden verhuren/verpachten. In het begin van de twintigste eeuw kocht de overheid ook plantages op om deze gronden te verkavelen in kleine percelen, waar men een huisje op kon bouwen en aan kleinlandbouw kon doen. Merendeels kon men hier niet van leven. Dit gebeurde bijvoorbeeld o.a. in Pannekoek, Dokterstuin, Phlip en Mahoema.\r\n\r\nMet de komst van de Shell breidde de stad zelf zich als een inktvlek uit en wel rondom het Schottegat. Naast de zelfbouwactiviteiten van onder andere lokale arbeiders, bouwden de Shell woonwijken voor de employes en voor de buitenlandse Shellwerknemers.', '21. De komst van de olie-industrie', '', 'inherit', 'closed', 'closed', '', '47-revision-v1', '', '', '2017-05-12 13:49:55', '2017-05-12 11:49:55', '', '47', 'http://canon.bramperry.nl/47-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('119', '1', '2017-05-12 13:50:28', '2017-05-12 11:50:28', 'In 1634 veroverde de West Indische Compagnie het eiland Curaçao. De W.I.C begon al snel met het opzetten van compagnieplantages met als doel het voedsel te verbouwen voor hun personeel en de als slaaf hierheen gebrachte Afrikanen. Naast deze compagnieplantages kwamen er al zeer snel particuliere plantages. Vrienden en familieleden van de bestuurders kregen grote terreinen in bruikleen en al heel snel was het grootste deel van Curacao onderverdeeld in plantages.\r\n\r\nDeze grote landbouwbedrijven oefenden een vorm van gemengd bedrijf uit. Normaal gesproken bestond zo’n bedrijf uit drie onderdelen: een hofje, onbewerkt land (de ‘mondi’) en akkers die in de regentijd werden gebruikt (de ‘kunuku’s).\r\n\r\nHet hofje was bijna altijd gelegen aan het uiteinde van een rooistelsel, waar de verweringslaag veel dikker was en waar de grondwaterspiegel het hoogst was. Daar plantte men de vruchtbomen en werd er wat groente gekweekt. De mondi werd gebruikt om schapen, geiten en koeien te laten grazen. Daarnaast waren er akkertjes voor de regenafhankelijke akkerbouw. Het gewas dat op deze akkers verbouwd werd, was het droogtebestendige sorghum (‘maishi chiki’), afkomstig uit West-Afrika. Als het regenseizoen (van november tot januari) goed was, werd er veel geproduceerd, maar zeer vaak viel het regenseizoen tegen en mislukte de oogst.   De maishi chiki was met name bestemd voor de bewoners van de plantage, zowel voor de tot slaaf gemaakte oorspronkelijk Afrikaanse bevolking en voor de eigenaarsfamilie. Hier werd het volksvoedsel ‘funchi’ van gemaakt. Inkomen verkreeg men door de verkoop van vee en melkproducten en de verkoop van fruit.\r\n\r\nDe meeste plantages waren niet erg rendabel, maar het bezit van een plantage was zeer belangrijk voor de status van de eigenaren.\r\n\r\nDe eigenaren behoorden meestal tot de groep van de “hoge blanke protestanten” en zij woonden meestal in de landhuizen.   De werkbevolking bestond oorspronkelijk uit tot slaaf gemaakte Afrikanen. Zij woonden in een buurtgemeenschap, gebouwd uit “kas di pal’i maishi” (eenvoudige lemen huisjes met een rieten dak) . Na de afschaffing van de slavernij in 1863 bleven vele ex-slaven op de plantages wonen met de verplichting om een aantal dagen in het jaar voor de plantage-eigenaar te werken (het zogenaamde ‘paga tera-systeem’).', '13. Het plantagesysteem op Curaçao', '', 'inherit', 'closed', 'closed', '', '31-revision-v1', '', '', '2017-05-12 13:50:28', '2017-05-12 11:50:28', '', '31', 'http://canon.bramperry.nl/31-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('120', '1', '2017-05-15 23:46:45', '2017-05-15 21:46:45', 'In 1634 veroverde de W.I.C. het eiland Curacao. Punda werd het centrum. Hier en in de directe omgeving concentreerde zich de bevolking. Deze bevolking had voedsel nodig. Voor hun personeel en later ook voor de als slaaf hier gebrachte Afrikanen vond men het noodzakelijk om tenminste een deel van het voedsel hier zelf te produceren. Al snel was het grootste deel van Curacao onderverdeeld in plantages <em>(lijkt veel op begin canon 12: kan wel of niet?). </em>Alleen de minder goede gronden, de zogenaamde savaangronden bleven in handen van de overheid. Op al de plantages kwamen buurtgemeenschappen of ‘dorpen’ voor, waar de als slaaf werkzame Afrikanen woonden in ‘kas di pal\'i maishi\'. Dit waren de eerste nederzettingen buiten het stadsdistrict. Ook na de afschaffing van de slavernij bleven veelal deze nederzettingskernen bestaan. Dat was vooral in Banda\'bou het geval. De meeste ex-slaven bleven werken onder ‘paga tera-verhoudingen’. Geleidelijk aan, vooral door conflicten met de plantage-eigenaren en achteruitgang van het plantage-gebeuren verdwenen de meeste van deze buurtgemeenschappen. Knip en Soto zijn hierop uitzonderingen.\r\n\r\nIn de negentiende eeuw ontstonden er aanvullend en later deels vervangend nederzettingskernen op initiatief van de R.K.-kerk. Mgr. Niewindt wilde godsdienst en onderwijs brengen aan de buiten de stad woonachtige donkere bevolking. Daarom verdeelde hij het gebied buiten het stadsdistrict in een beperkt aantal grote parochies. Hij koos voor de centra van die parochies plaatsen die makkelijk bereikbaar waren. In de centra kwam een kerkje en een kunukuschooltje. Hier omheen ontwikkelden zich de eerste kerkdorpen, beginnend met Barber, daarna Santa Rosa en Santa Maria. Daarna werden ze opgesplitst en ontstond bijvoorbeeld de parochie San Willibrordo en Montagne. In deze nederzettingen vestigden zich ex-slaven, die zich losmaakten van de plantages en het paga terasysteem.\r\n\r\nNaast deze kerkelijke initiatieven waren er ook woonkernen van vrije lieden te Westpunt, San Pedro, Seru Fortuna en Boka Sami.\r\n\r\nNaast deze kernen vestigden zich al in de achttiende eeuw vrije lieden op de savaangronden en wel verspreid. Deze ontwikkeling ging na de afschaffing van de ‎slavernij door. De overheid ging vooral eind negentiende eeuw percelen domeingronden verhuren/verpachten. In het begin van de twintigste eeuw kocht de overheid ook plantages op om deze gronden te verkavelen in kleine percelen, waar men een huisje op kon bouwen en aan kleinlandbouw kon doen. Merendeels kon men hier niet van leven. Dit gebeurde bijvoorbeeld o.a. in Pannekoek, Dokterstuin, Phlip en Mahoema.\r\n\r\nMet de komst van de Shell breidde de stad zelf zich als een inktvlek uit en wel rondom het Schottegat. Naast de zelfbouwactiviteiten van onder andere lokale arbeiders, bouwden de Shell woonwijken voor de employes en voor de buitenlandse Shellwerknemers.', '22. De nieuwe immigranten op Curaçao vanaf het begin van de twintigste eeuw', '', 'inherit', 'closed', 'closed', '', '49-revision-v1', '', '', '2017-05-15 23:46:45', '2017-05-15 21:46:45', '', '49', 'http://canon.bramperry.nl/49-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('121', '1', '2017-05-15 23:47:15', '2017-05-15 21:47:15', 'In 1912 had Shell een concessie verworven in het Mene Grande-veld, ten Oosten van het Meer van Maracaibo in Venezuela. Toen in 1914 duidelijk werd dat dit veld boordevol olie zat, had Shell al besloten om een kleine opslagplaats op Curaçao te bouwen. Een jaar later werd besloten er een raffinaderij te vestigen. De slechte bereikbaarheid van het Meer van Maracaibo en het stabiele bestuur van Curaçao, speelde een rol in deze keuze.\r\n\r\nIn de eerste jaren werd op Curaçao nog voor een groot deel olie uit Mexico verwerkt. Nadat Mexico in 1938 de olie industrie nationaliseerde, ging Shell exclusief Venezolaanse olie verwerken.\r\n\r\nTot het einde van 1920 waren er minder dan 300 mensen in dienst van de raffinaderij. Het zou uitgroeien tot 10.924 (inclusief de Curaçaosche Scheepvaart Maatschappij) in 1929. In die jaren werden arbeiders geworven uit de regio en uit Portugal. Al deze arbeiders werden in nieuwe wijken gehuisvest, niet ver van het raffinaderijcomplex. Daarbij werden ook allerlei voorzieningen gebouwd zoals wegen, scholen, winkels, buurtcentra, telefoon- en waterleidingen.\r\n\r\nDe economische crisis van de jaren dertig bracht het personeelsbestand drastisch terug en zou vanaf 1934 geleidelijk weer toenemen. Pas na 1945 kwam het personeelsaantal weer boven de 10.000 uit.\r\n\r\nIn de oorlogsjaren speelden de raffinaderijen op de Antillen een belangrijke rol voor de brandstofvoorziening van de Geallieerden. Duitsland zette vanaf februari 1942 duikboten in rond Curaçao en Aruba om deze brandstoftoevoer af te snijden. In de oorlogsjaren kreeg de raffinaderij toestemming een zogenaamd “asfalt-meer” aan te leggen vanwege het gebrek aan schepen om het te vervoeren.\r\n\r\nIn Venezuela werden de activiteiten op Curaçao en Aruba met jaloezie en afgunst bekeken. Na 1935 was het sentiment gekeerd tegen de “uitverkoop van nationale rijkdom”. In 1943 werd daarom wetgeving aangenomen waardoor de Antilliaanse raffinaderijen geen olie uit nieuwe concessies mochten verwerken. Shell werd gedwongen te investeren in een nieuwe raffinaderij in Venezuela. Dat werd de raffinaderij van Cardón, die in 1947 opstartte.\r\n\r\nZo werd Shell in de jaren vijftig gedwongen haar raffinaderij op Curaçao af te slanken. In 1959 speelde ook de Amerikaanse import restricties op olieproducten de kop op. Op verzoek van m.n. de Texaanse olieproducenten ging Amerika over op importquota.\r\n\r\nIn de jaren zestig werd het systeem van “onderaannemers” ingevoerd waarbij arbeiders via externe bedrijven werden ingehuurd. Doordat de onderaannemers minder betaalden dan Shell, leidde dit tot een uitbarsting die bekend werd onder de naam “30 mei 1969”.', '21. De komst van de olie-industrie', '', 'inherit', 'closed', 'closed', '', '47-revision-v1', '', '', '2017-05-15 23:47:15', '2017-05-15 21:47:15', '', '47', 'http://canon.bramperry.nl/47-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('123', '1', '2017-08-04 21:11:14', '2017-08-04 19:11:14', '', 'autumn', '', 'inherit', 'open', 'closed', '', 'autumn', '', '', '2017-08-10 20:11:58', '2017-08-10 18:11:58', '', '8', 'http://canon.bramperry.nl/wp-content/uploads/2017/08/autumn.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('124', '1', '2017-08-04 21:11:18', '2017-08-04 19:11:18', '', 'lake', '', 'inherit', 'open', 'closed', '', 'lake', '', '', '2017-08-10 20:11:53', '2017-08-10 18:11:53', '', '8', 'http://canon.bramperry.nl/wp-content/uploads/2017/08/lake.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('125', '1', '2017-08-10 19:59:45', '2017-08-10 17:59:45', 'De teksten binnen de 50 vensters zijn gepubliceerd met toestemming van de auteurs en kunnen zonder voorafgaande toestemming ‘hergebruikt’ worden, mits de bron en auteur vermeld worden. De Canoncommissie heeft voor de illustraties bij de vensters voor het merendeel gekozen voor collecties uit het Nationaal Archief Curaçao en voor zover het andere collecties betreft heeft ze gepoogd de rechthebbende op te sporen en toestemming gevraagd om de illustraties te mogen gebruiken voor deze Canon. De bron van de illustraties staan vermeld. Bij een aantal illustraties is het echter niet gelukt de rechthebbende op te sporen. Indien u meent rechthebbende te zijn van een van de illustraties die in deze Canon zijn gebruikt, kunt u contact opnemen met het Nationaal Archief Curaçao of de University of Curaçao. Het ‘hergebruik’ van de illustraties in deze Canon is tevens gebonden aan de regels waarover u <a href=\"https://www.merkenspot.nl/auteursrecht/foto/\">hier </a>meer kunt lezen.', 'Rechten', '', 'publish', 'closed', 'closed', '', 'rechten', '', '', '2020-11-05 16:58:44', '2020-11-05 15:58:44', '', '0', 'http://canon.bramperry.nl/?page_id=125', '0', 'page', '', '0');
INSERT INTO `wp_posts` VALUES('126', '1', '2017-08-10 19:59:45', '2017-08-10 17:59:45', '', 'Rechten', '', 'inherit', 'closed', 'closed', '', '125-revision-v1', '', '', '2017-08-10 19:59:45', '2017-08-10 17:59:45', '', '125', 'http://canon.bramperry.nl/125-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('128', '1', '2017-08-10 19:59:59', '2017-08-10 17:59:59', 'Het is de bedoeling om deze Canon voor educatieve doeleinden te gebruiken.\r\n\r\nDe tweede fase van het “Canon Project” bestaat uit het vertalen naar een Papiamentu versie van de Venster-teksten. Ook is het de bedoeling ‘verdiepingsteksten’ bij de venster-onderwerpen te introduceren en lesbrieven aan de onderwerpen te koppelen. Hieronder zijn al de volgende lesbrieven toegevoegd over de onderwerpen \"Statuut\" en vier lesbrieven over de Tweede Wereldoorlog. Ze staan ook op de desbetreffende vensterpagina.\r\n\r\n&nbsp;\r\n\r\n<a href=\"https://canoncuracao.cw/wp-content/uploads/2020/11/Lesbrief-Statuut_LR.pdf\">Lesbrief Statuut_LR</a>\r\n\r\n<a href=\"https://canoncuracao.cw/wp-content/uploads/2020/11/WOII_Lesbrief-Oorlogslachtoffers.pdf\">WOII_Lesbrief Oorlogslachtoffers</a>\r\n\r\n<a href=\"https://canoncuracao.cw/wp-content/uploads/2020/11/WOII_Lesbrief-Economie-en-Bestuur.pdf\">WOII_Lesbrief Economie en Bestuur</a>\r\n\r\n<a href=\"https://canoncuracao.cw/wp-content/uploads/2020/11/WOII_Lesbrief-Militaire-Zaken.pdf\">WOII_Lesbrief Militaire Zaken</a>\r\n\r\n<a href=\"https://canoncuracao.cw/wp-content/uploads/2020/11/WOII_Lesbrief-Dagelijks-leven-in-WOII.pdf\">WOII_Lesbrief Dagelijks leven in WOII</a>', 'Lesbrieven', '', 'publish', 'closed', 'closed', '', 'lesbrieven', '', '', '2020-11-20 13:54:49', '2020-11-20 12:54:49', '', '0', 'http://canon.bramperry.nl/?page_id=128', '0', 'page', '', '0');
INSERT INTO `wp_posts` VALUES('129', '1', '2017-08-10 19:59:59', '2017-08-10 17:59:59', '', 'Lesbrieven', '', 'inherit', 'closed', 'closed', '', '128-revision-v1', '', '', '2017-08-10 19:59:59', '2017-08-10 17:59:59', '', '128', 'http://canon.bramperry.nl/128-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('130', '1', '2017-08-10 20:00:26', '2017-08-10 18:00:26', '<h3>Waar kunt u de 50 vensters vinden op het eiland?</h3>\r\nDe locaties worden aangegeven door het symbool van de Canon van Curaçao.', 'Kaart', '', 'publish', 'closed', 'closed', '', 'kaart', '', '', '2017-08-11 22:18:32', '2017-08-11 20:18:32', '', '0', 'http://canon.bramperry.nl/?page_id=130', '0', 'page', '', '0');
INSERT INTO `wp_posts` VALUES('131', '1', '2017-08-10 20:00:26', '2017-08-10 18:00:26', '', 'Kaart', '', 'inherit', 'closed', 'closed', '', '130-revision-v1', '', '', '2017-08-10 20:00:26', '2017-08-10 18:00:26', '', '130', 'http://canon.bramperry.nl/130-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('132', '1', '2017-08-10 20:00:41', '2017-08-10 18:00:41', '<h3>Initiatiefnemers</h3>\r\nDe Algemene Faculteit van de Universiteit van Curaçao (UoC) heeft het initiatief genomen om een “Canon van de Geschiedenis van Curaçao” op te stellen. Het Nationaal Archief Curaçao, vertegenwoordigers uit het middelbaar onderwijs en andere deskundigen hebben zich bij dit initiatief aangesloten. Tezamen hebben zij een “canoncommissie” opgericht, waar inmiddels ook de Fundashon Material pa Skol (FMS) deel van uitmaakt. Het Prins Bernhard Cultuur Fonds Caribisch gebied heeft het project ondersteund.\r\n<h4><strong>Waarom een “Canon”?</strong></h4>\r\nStaf en docenten van de Algemene Faculteit  (AF) van de UoC constateren dat studenten vaak onvoldoende kennis hebben van de geschiedenis van Curaçao. Omdat wij ervan overtuigd zijn dat burgers een goed beeld moeten hebben van de geschiedenis van hun land, zodat zij op verantwoorde manier kunnen deelnemen aan het politieke en sociale leven, heeft de AF besloten om hieraan een bijdrage te leveren door een lijst op te stellen met onderwerpen uit de geschiedenis van Curaçao waar alle burgers kennis van zouden moeten hebben. Deze onderwerpen zouden met alle leerlingen, zowel in het primair als het secundair onderwijs, besproken kunnen worden. Deze gezamenlijke kennis van alle burgers van Curaçao zou de basis moeten vormen van versterkt burgerschap.\r\n\r\nDe AF heeft de “canoncommissie” verzocht om deze lijst samen te stellen. De commissie heeft haar taak inmiddels volbracht en heeft een lijst met 50 onderwerpen opgesteld.\r\n<h4><strong>Wat is een “Canon”?</strong></h4>\r\nEen lijst met 50 “vensters”, die gezamenlijk een goede doorkijk bieden op de geschiedenis van Curaçao. Dit zijn slechts \"etalages\" waarin 50 onderwerpen in het kort (ca. 400 woorden) \'geëtaleerd\' worden. De bedoeling van deze lijst is uitsluitend om structuur aan te brengen in het lesprogramma. De canon wordt niet gekenmerkt door politieke of ideologische motieven en geeft ook geen inhoudelijke richtlijnen. De leden van de commissie hebben tijdens hun werkzaamheden steeds voor ogen gehad dat de canon uitsluitend tot doel heeft een bijdrage te leveren aan het onderwijs. Het kan zowel voor het voortgezet onderwijs worden gebruikt als ook voor studenten van de universiteit.\r\n\r\n&nbsp;\r\n\r\nSamenstelling van de commissie (in alfabetische volgorde)\r\n\r\nDr. R. M. Allen, antropoloog, part-time docent AF\r\n\r\nDrs. E. Baetens, voormalig docent aardrijkskunde en medewerker van de FMS\r\n\r\nDrs. W. Kamps, voormalig stafmedewerker van de Algemene Faculteit\r\n\r\nDrs. M. Scriwanek, directeur van het Nationaal Archief\r\n\r\nDrs. R. Sille, voormalig docent geschiedenis en rector van het KAP\r\n\r\nDrs H. Vlinkervleugel, voorzitter van de vereniging van geschiedenisdocenten op Curaçao\r\n\r\nDrs. I. Witteveen, ex-directeur van het NAAM, voormalig medewerkster FMS\r\n\r\n&nbsp;\r\n\r\nHet Canon project wordt ondersteund door:\r\n\r\nDe University of Curaçao\r\n\r\nHet Nationaal Archief Curaçao\r\n\r\nDe Fundashon Material pa Skol\r\n\r\nHet Prins Bernhard Cultuurfonds Caribisch gebied\r\n\r\n&nbsp;\r\n\r\n&nbsp;', 'Over ons', '', 'publish', 'closed', 'closed', '', 'over-ons', '', '', '2020-11-19 18:12:01', '2020-11-19 17:12:01', '', '0', 'http://canon.bramperry.nl/?page_id=132', '0', 'page', '', '0');
INSERT INTO `wp_posts` VALUES('133', '1', '2017-08-10 20:00:41', '2017-08-10 18:00:41', '', 'Over ons', '', 'inherit', 'closed', 'closed', '', '132-revision-v1', '', '', '2017-08-10 20:00:41', '2017-08-10 18:00:41', '', '132', 'http://canon.bramperry.nl/132-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('134', '1', '2017-08-10 20:01:20', '2017-08-10 18:01:20', ' ', '', '', 'publish', 'closed', 'closed', '', '134', '', '', '2017-08-10 20:01:20', '2017-08-10 18:01:20', '', '0', 'http://canon.bramperry.nl/?p=134', '3', 'nav_menu_item', '', '0');
INSERT INTO `wp_posts` VALUES('135', '1', '2017-08-10 20:01:20', '2017-08-10 18:01:20', ' ', '', '', 'publish', 'closed', 'closed', '', '135', '', '', '2017-08-10 20:01:20', '2017-08-10 18:01:20', '', '0', 'http://canon.bramperry.nl/?p=135', '2', 'nav_menu_item', '', '0');
INSERT INTO `wp_posts` VALUES('136', '1', '2017-08-10 20:01:20', '2017-08-10 18:01:20', ' ', '', '', 'publish', 'closed', 'closed', '', '136', '', '', '2017-08-10 20:01:20', '2017-08-10 18:01:20', '', '0', 'http://canon.bramperry.nl/?p=136', '4', 'nav_menu_item', '', '0');
INSERT INTO `wp_posts` VALUES('137', '1', '2017-08-10 20:01:20', '2017-08-10 18:01:20', '', 'Vensters', '', 'publish', 'closed', 'closed', '', 'vensters', '', '', '2017-08-10 20:01:20', '2017-08-10 18:01:20', '', '0', 'http://canon.bramperry.nl/?p=137', '1', 'nav_menu_item', '', '0');
INSERT INTO `wp_posts` VALUES('138', '1', '2017-08-10 20:01:41', '2017-08-10 18:01:41', ' ', '', '', 'publish', 'closed', 'closed', '', '138', '', '', '2017-08-10 20:01:41', '2017-08-10 18:01:41', '', '0', 'http://canon.bramperry.nl/?p=138', '1', 'nav_menu_item', '', '0');
INSERT INTO `wp_posts` VALUES('139', '1', '2017-08-10 20:02:15', '2017-08-10 18:02:15', '<h2>Wat weet jij over Curaçao?</h2>\r\nAliquam et lectus in nisi commodo feugiat non sed dolor. Ut maximus maximus elit, vel posuere justo molestie molestie. Praesent varius lobortis hendrerit.\r\n<h2>Nieuws</h2>\r\nAliquam et lectus in nisi commodo feugiat non sed dolor. Ut maximus maximus elit, vel posuere justo molestie molestie. Praesent varius lobortis hendrerit.', 'Home', '', 'inherit', 'closed', 'closed', '', '2-revision-v1', '', '', '2017-08-10 20:02:15', '2017-08-10 18:02:15', '', '2', 'http://canon.bramperry.nl/2-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('143', '1', '2019-12-03 09:13:16', '2019-12-03 08:13:16', 'De allervroegste aanwijzingen voor de aanwezigheid van mensen op Curaçao dateren van ongeveer 3400 voor Christus. Zij kwamen van het vasteland, van het huidige Venezuela en Colombia, per kano richting Curaçao. Archeologische resten uit deze vroege (pre-ceramische of archaïsche) periode vinden we terug bij onder andere Rooi Rincon, de Sint Jorisbaai en Seru Boca. Deze vroege inwoners leefden voornamelijk van schelpdieren. Sporen van hun aanwezigheid zijn dan ook in groten getale gevonden in de vorm van zogenaamde schelphopen. Hierin zijn ook hun werktuigen van schelp, steen en koraal gevonden. Ze maakten zelf geen aardewerk en zullen bijvoorbeeld kalebassen of vlechtwerk gebruikt hebben als schalen of om dingen in te bewaren. Behalve schelpdieren zullen ze ook vruchten verzameld hebben.\n\nHoewel onduidelijk is of deze mensen daadwerkelijk op Curaçao hebben gewoond of dat ze alleen in bepaalde seizoenen langskwamen, is het vrijwel zeker dat er rond 2000 voor Christus echt sprake is van bewoning op Curaçao. De oudste menselijke resten die zijn teruggevonden aan de voet van de Sint Michielsberg (circa 2000-1650 voor Christus), vormen hiervoor een aanwijzing. Het ligt voor de hand dat de verwanten van deze overledenen in de directe omgeving hebben gewoond, aangezien het gebruikelijk was om de overledenen binnen de nederzetting en zelfs binnen huizen te begraven.\n\nRond 1000 voor Christus wordt voor het eerst aardewerk gebruikt. Kleine onversierde fragmenten aardewerk met een grove structuur zijn in kleine hoeveelheden bij het Spaanse Water en de Vlakte van Hato aangetroffen. Het is nog onbekend of dit van het vasteland is meegenomen of lokaal gemaakt. Vermoedelijk worden vanaf deze periode en mogelijk al eerder, rotstekeningen aangebracht op kalkstenen rotswanden en losse rotsblokken (bijvoorbeeld op Savonet).\n\nDe ceramische periode begint op Curaçao rond 800 na Christus met grote nederzettingen, bijvoorbeeld bij De Savaan, San Juan en Santa Cruz. Hier zijn resten terug gevonden van bewoning in de vorm van paalgaten, haardplaatsen en graven. Deze specifieke groep “Indianen”, zoals ze sinds de vergissing van Columbus toch steeds worden genoemd – maakten ‘Dabajuroid’ aardewerk. Dit is te herkennen aan de zwarte, bruine, rode en witte versiering door middel van voornamelijk lijnen en stippen. Soms werden op het aardewerk ook menselijke gezichten afgebeeld of dierenkoppen als pootjes aan de pot gevormd. Ook de Caquetio, de Indianen die op het eiland woonden toen de <a href=\"https://canoncuracao.cw/2-de-spaanse-periode/\">Spanjaarden</a> het in 1499 innamen, hebben schelphopen achtergelaten, waarin echter niet alleen schelpen maar ook een grote hoeveelheid aardewerk, sieraden, bijlen, maalstenen, en andere werktuigen van steen, schelp, koraal en dierlijk bot zijn gevonden. De taal die de Caquetio spraken is waarschijnlijk een variant van de Arawak taalfamilie geweest, maar wordt al heel lang nergens meer gesproken. Naast schelpdieren zullen de Caquetio ook maniok, maïs en fruit gegeten hebben dat ze verbouwden in tuinen (horticultuur). Ze stonden bij de Spanjaarden bekend als goede landbouwers en kanovaarders. Het gebruik van maïs en maniok blijkt uit afslagen van vuursteen voor het raspen van maniok en maalstenen voor het bewerken van maïs. Ook aardewerk platen voor het maken van cassave- en maïskoeken zijn teruggevonden en een maïskorrel bij San Juan.', '1. De oorspronkelijke bewoners', '', 'inherit', 'closed', 'closed', '', '8-autosave-v1', '', '', '2019-12-03 09:13:16', '2019-12-03 08:13:16', '', '8', 'http://canon.bramperry.nl/8-autosave-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('145', '1', '2017-08-10 20:06:32', '2017-08-10 18:06:32', 'Fusce nunc risus, varius ut ligula id, varius malesuada lectus. Nulla tincidunt magna id molestie blandit. Nullam non erat dictum arcu imperdiet viverra. Sed eleifend risus felis, nec blandit quam efficitur sed. Phasellus fermentum tortor augue, sit amet interdum turpis congue quis. Aliquam vulputate lacus purus, et tincidunt diam euismod a. Morbi dui nisi, suscipit id nisi quis, ultricies volutpat velit. Integer vehicula lacinia porta. Vestibulum pellentesque nec enim in suscipit. Ut auctor, neque nec porttitor facilisis, mauris est tincidunt nisi, non rhoncus urna turpis ac eros. Proin massa purus, lacinia vitae metus ac, pulvinar ultricies nibh. Morbi dictum sapien mauris. Quisque sapien odio, mollis rutrum volutpat sit amet, fringilla vitae ante.\r\n\r\nNulla sodales vestibulum porttitor. Pellentesque lacinia id purus non accumsan. Mauris pharetra eros sit amet elementum pretium. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum luctus fringilla mauris, sit amet tristique nisi dignissim tincidunt. Suspendisse vel tincidunt urna, ac pulvinar nisl. Cras tempor, felis vitae porttitor scelerisque, ante ex commodo est, in vestibulum dolor eros nec dui. Pellentesque accumsan nulla a leo congue, eget vestibulum purus laoreet. Sed vulputate vehicula felis, vitae interdum tortor vehicula sit amet. Nulla eu tincidunt mi.', '1. De oorspronkelijke bewoners', '', 'inherit', 'closed', 'closed', '', '8-revision-v1', '', '', '2017-08-10 20:06:32', '2017-08-10 18:06:32', '', '8', 'http://canon.bramperry.nl/8-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('146', '1', '2017-08-10 20:06:50', '2017-08-10 18:06:50', 'Fusce nunc risus, varius ut ligula id, varius malesuada lectus. Nulla tincidunt magna id molestie blandit. Nullam non erat dictum arcu imperdiet viverra. Sed eleifend risus felis, nec blandit quam efficitur sed. Phasellus fermentum tortor augue, sit amet interdum turpis congue quis. Aliquam vulputate lacus purus, et tincidunt diam euismod a. Morbi dui nisi, suscipit id nisi quis, ultricies volutpat velit. Integer vehicula lacinia porta. Vestibulum pellentesque nec enim in suscipit. Ut auctor, neque nec porttitor facilisis, mauris est tincidunt nisi, non rhoncus urna turpis ac eros. Proin massa purus, lacinia vitae metus ac, pulvinar ultricies nibh. Morbi dictum sapien mauris. Quisque sapien odio, mollis rutrum volutpat sit amet, fringilla vitae ante.\r\n\r\nNulla sodales vestibulum porttitor. Pellentesque lacinia id purus non accumsan. Mauris pharetra eros sit amet elementum pretium. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum luctus fringilla mauris, sit amet tristique nisi dignissim tincidunt. Suspendisse vel tincidunt urna, ac pulvinar nisl. Cras tempor, felis vitae porttitor scelerisque, ante ex commodo est, in vestibulum dolor eros nec dui. Pellentesque accumsan nulla a leo congue, eget vestibulum purus laoreet. Sed vulputate vehicula felis, vitae interdum tortor vehicula sit amet. Nulla eu tincidunt mi.', '1. De oorspronkelijke bewoners', '', 'inherit', 'closed', 'closed', '', '8-revision-v1', '', '', '2017-08-10 20:06:50', '2017-08-10 18:06:50', '', '8', 'http://canon.bramperry.nl/8-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('147', '1', '2017-08-10 20:08:36', '2017-08-10 18:08:36', '<h3>De verovering van Curaçao</h3>\r\nCuraçao werd in 1634 door de West-Indische Compagnie (WIC) veroverd op de Spanjaarden.\r\n\r\nDe Republiek was op dat moment verwikkeld in de Tachtigjarige Oorlog (1568-1648) met Spanje en metPortugal. Deze landen waren sinds 1580 verenigd waren onder één staatshoofd, de Spaanse koning. De WIC was in 1621 opgericht om te dienen als een instrument in die oorlog. Behalve met de uitvoering van een ambitieus plan, het ‘groot desseyn’,dat gericht was op het veroveren van Portugese gebieden in Afrika en Brazilië, was de WIC vooral actief in de kaapvaart. Er bestond daarom behoefte aan een maritiem steunpunt in het operatiegebied van waaruit militaire acties konden worden ondernomen.Het strategisch gunstig gelegen Curaçao was daarvoor uitstekend geschikt. Het eiland was goed verdedigbaar en beschikte over een uitstekende natuurlijke haven, de Sint-Annabaai.\r\n\r\nEen expeditie onder leiding van Johannes van Walbeecken Pierre le Grand slaagde er vrij eenvoudig in om Curaçao te overmeesteren. De kleine Spaanse bezetting werd samen met het grootste deel van de inheemse bevolking gedeporteerd naar Venezuela. Daarna werd een begin gemaakt met het op orde brengen van de verdediging. Aan oostelijke zijde van de ingang van de Sint-Annabaai op een landtong die De Punt (Punda) werd genoemd werd een sterkte gebouwd, fort Amsterdam.\r\n\r\n&nbsp;\r\n<h3>Van oorlogsbasis naar vestigingskolonie</h3>\r\nGedurende de eerste jaren na de verovering verbleven er op Curaçao in hoofdzaak militairen. In 1635 waren slechts 20 van de 412 compagniesdienaren burgers. Er woonden verder zo’n 50 inheemse bewoners. Spoedig arriveerden ook Afrikaanse slaven. Deze waren aanvankelijk vooral afkomstig van veroverde vijandelijke schepen. Maar hun aantallen waren tot midden zeventiende eeuw nog gering.\r\n\r\nVrijwel direct nadat bekend werd dat Curaçao was veroverd, ontstond er in het moederland belangstelling voor kolonisatieprojecten. Militairen en civiele beambten op het eiland, die hun contract hadden uitgediend, kregen ook de mogelijkheid om zich als landbouwer te vestigen. Maar dit leidde nauwelijks tot concrete resultaten.\r\n\r\nIn de jaren vijftig van zeventiende eeuw vestigden zich joodse kolonisten op het eiland. In 1665 woonden er, de inheemse bevolking niet meegerekend, zo’n 600 personen.Curaçao had inmiddels geen functie meer als oorlogsbasis, maar ontwikkelde zich nu, met de vanaf 1650 opkomende slavenhandel als motor, tot een commercieel centrum.Rond deze tijd ontstond ten noorden van fort Amsterdam een vestiging die uitgroeide tot een ommuurde stad, Willemstad. Het aantal plantages en tuinen groeide ook. Deze richtten zich vooral op de lokale voedselproductie.\r\n\r\nHan Jordaan', '3. Verovering van Curaçao door de WIC en de komst van de Hollanders', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2017-08-10 20:08:36', '2017-08-10 18:08:36', '', '12', 'http://canon.bramperry.nl/12-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('148', '1', '2017-08-10 20:08:48', '2017-08-10 18:08:48', '', 'water', '', 'inherit', 'open', 'closed', '', 'water', '', '', '2017-08-10 20:09:09', '2017-08-10 18:09:09', '', '12', 'http://canon.bramperry.nl/wp-content/uploads/2017/05/water.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('149', '1', '2017-08-10 20:08:52', '2017-08-10 18:08:52', '', 'stad', '', 'inherit', 'open', 'closed', '', 'stad', '', '', '2017-08-10 20:08:52', '2017-08-10 18:08:52', '', '12', 'http://canon.bramperry.nl/wp-content/uploads/2017/05/stad.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('150', '1', '2017-08-10 20:08:57', '2017-08-10 18:08:57', '', 'cricket', '', 'inherit', 'open', 'closed', '', 'cricket', '', '', '2017-08-10 20:08:57', '2017-08-10 18:08:57', '', '12', 'http://canon.bramperry.nl/wp-content/uploads/2017/05/cricket.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('151', '1', '2017-08-10 20:09:13', '2017-08-10 18:09:13', '<h3>De verovering van Curaçao</h3>\r\nCuraçao werd in 1634 door de West-Indische Compagnie (WIC) veroverd op de Spanjaarden.\r\n\r\nDe Republiek was op dat moment verwikkeld in de Tachtigjarige Oorlog (1568-1648) met Spanje en metPortugal. Deze landen waren sinds 1580 verenigd waren onder één staatshoofd, de Spaanse koning. De WIC was in 1621 opgericht om te dienen als een instrument in die oorlog. Behalve met de uitvoering van een ambitieus plan, het ‘groot desseyn’,dat gericht was op het veroveren van Portugese gebieden in Afrika en Brazilië, was de WIC vooral actief in de kaapvaart. Er bestond daarom behoefte aan een maritiem steunpunt in het operatiegebied van waaruit militaire acties konden worden ondernomen.Het strategisch gunstig gelegen Curaçao was daarvoor uitstekend geschikt. Het eiland was goed verdedigbaar en beschikte over een uitstekende natuurlijke haven, de Sint-Annabaai.\r\n\r\nEen expeditie onder leiding van Johannes van Walbeecken Pierre le Grand slaagde er vrij eenvoudig in om Curaçao te overmeesteren. De kleine Spaanse bezetting werd samen met het grootste deel van de inheemse bevolking gedeporteerd naar Venezuela. Daarna werd een begin gemaakt met het op orde brengen van de verdediging. Aan oostelijke zijde van de ingang van de Sint-Annabaai op een landtong die De Punt (Punda) werd genoemd werd een sterkte gebouwd, fort Amsterdam.\r\n\r\n&nbsp;\r\n<h3>Van oorlogsbasis naar vestigingskolonie</h3>\r\nGedurende de eerste jaren na de verovering verbleven er op Curaçao in hoofdzaak militairen. In 1635 waren slechts 20 van de 412 compagniesdienaren burgers. Er woonden verder zo’n 50 inheemse bewoners. Spoedig arriveerden ook Afrikaanse slaven. Deze waren aanvankelijk vooral afkomstig van veroverde vijandelijke schepen. Maar hun aantallen waren tot midden zeventiende eeuw nog gering.\r\n\r\nVrijwel direct nadat bekend werd dat Curaçao was veroverd, ontstond er in het moederland belangstelling voor kolonisatieprojecten. Militairen en civiele beambten op het eiland, die hun contract hadden uitgediend, kregen ook de mogelijkheid om zich als landbouwer te vestigen. Maar dit leidde nauwelijks tot concrete resultaten.\r\n\r\nIn de jaren vijftig van zeventiende eeuw vestigden zich joodse kolonisten op het eiland. In 1665 woonden er, de inheemse bevolking niet meegerekend, zo’n 600 personen.Curaçao had inmiddels geen functie meer als oorlogsbasis, maar ontwikkelde zich nu, met de vanaf 1650 opkomende slavenhandel als motor, tot een commercieel centrum.Rond deze tijd ontstond ten noorden van fort Amsterdam een vestiging die uitgroeide tot een ommuurde stad, Willemstad. Het aantal plantages en tuinen groeide ook. Deze richtten zich vooral op de lokale voedselproductie.\r\n\r\nHan Jordaan', '3. Verovering van Curaçao door de WIC en de komst van de Hollanders', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2017-08-10 20:09:13', '2017-08-10 18:09:13', '', '12', 'http://canon.bramperry.nl/12-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('152', '1', '2017-08-10 20:09:45', '2017-08-10 18:09:45', '<h3>De verovering van Curaçao</h3>\r\nCuraçao werd in 1634 door de West-Indische Compagnie (WIC) veroverd op de Spanjaarden.\r\n\r\nDe Republiek was op dat moment verwikkeld in de Tachtigjarige Oorlog (1568-1648) met Spanje en metPortugal. Deze landen waren sinds 1580 verenigd waren onder één staatshoofd, de Spaanse koning. De WIC was in 1621 opgericht om te dienen als een instrument in die oorlog. Behalve met de uitvoering van een ambitieus plan, het ‘groot desseyn’,dat gericht was op het veroveren van Portugese gebieden in Afrika en Brazilië, was de WIC vooral actief in de kaapvaart. Er bestond daarom behoefte aan een maritiem steunpunt in het operatiegebied van waaruit militaire acties konden worden ondernomen.Het strategisch gunstig gelegen Curaçao was daarvoor uitstekend geschikt. Het eiland was goed verdedigbaar en beschikte over een uitstekende natuurlijke haven, de Sint-Annabaai.\r\n\r\nEen expeditie onder leiding van Johannes van Walbeecken Pierre le Grand slaagde er vrij eenvoudig in om Curaçao te overmeesteren. De kleine Spaanse bezetting werd samen met het grootste deel van de inheemse bevolking gedeporteerd naar Venezuela. Daarna werd een begin gemaakt met het op orde brengen van de verdediging. Aan oostelijke zijde van de ingang van de Sint-Annabaai op een landtong die De Punt (Punda) werd genoemd werd een sterkte gebouwd, fort Amsterdam.\r\n<h3>Van oorlogsbasis naar vestigingskolonie</h3>\r\nGedurende de eerste jaren na de verovering verbleven er op Curaçao in hoofdzaak militairen. In 1635 waren slechts 20 van de 412 compagniesdienaren burgers. Er woonden verder zo’n 50 inheemse bewoners. Spoedig arriveerden ook Afrikaanse slaven. Deze waren aanvankelijk vooral afkomstig van veroverde vijandelijke schepen. Maar hun aantallen waren tot midden zeventiende eeuw nog gering.\r\n\r\nVrijwel direct nadat bekend werd dat Curaçao was veroverd, ontstond er in het moederland belangstelling voor kolonisatieprojecten. Militairen en civiele beambten op het eiland, die hun contract hadden uitgediend, kregen ook de mogelijkheid om zich als landbouwer te vestigen. Maar dit leidde nauwelijks tot concrete resultaten.\r\n\r\nIn de jaren vijftig van zeventiende eeuw vestigden zich joodse kolonisten op het eiland. In 1665 woonden er, de inheemse bevolking niet meegerekend, zo’n 600 personen.Curaçao had inmiddels geen functie meer als oorlogsbasis, maar ontwikkelde zich nu, met de vanaf 1650 opkomende slavenhandel als motor, tot een commercieel centrum.Rond deze tijd ontstond ten noorden van fort Amsterdam een vestiging die uitgroeide tot een ommuurde stad, Willemstad. Het aantal plantages en tuinen groeide ook. Deze richtten zich vooral op de lokale voedselproductie.', '3. Verovering van Curaçao door de WIC en de komst van de Hollanders', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2017-08-10 20:09:45', '2017-08-10 18:09:45', '', '12', 'http://canon.bramperry.nl/12-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('153', '1', '2017-08-10 20:10:34', '2017-08-10 18:10:34', '<h3>De verovering van Curaçao</h3>\r\nCuraçao werd in 1634 door de West-Indische Compagnie (WIC) veroverd op de Spanjaarden.\r\n\r\nDe Republiek was op dat moment verwikkeld in de Tachtigjarige Oorlog (1568-1648) met Spanje en metPortugal. Deze landen waren sinds 1580 verenigd waren onder één staatshoofd, de Spaanse koning. De WIC was in 1621 opgericht om te dienen als een instrument in die oorlog. Behalve met de uitvoering van een ambitieus plan, het ‘groot desseyn’,dat gericht was op het veroveren van Portugese gebieden in Afrika en Brazilië, was de WIC vooral actief in de kaapvaart. Er bestond daarom behoefte aan een maritiem steunpunt in het operatiegebied van waaruit militaire acties konden worden ondernomen.Het strategisch gunstig gelegen Curaçao was daarvoor uitstekend geschikt. Het eiland was goed verdedigbaar en beschikte over een uitstekende natuurlijke haven, de Sint-Annabaai.\r\n\r\nEen expeditie onder leiding van Johannes van Walbeecken Pierre le Grand slaagde er vrij eenvoudig in om Curaçao te overmeesteren. De kleine Spaanse bezetting werd samen met het grootste deel van de inheemse bevolking gedeporteerd naar Venezuela. Daarna werd een begin gemaakt met het op orde brengen van de verdediging. Aan oostelijke zijde van de ingang van de Sint-Annabaai op een landtong die De Punt (Punda) werd genoemd werd een sterkte gebouwd, fort Amsterdam.\r\n<h3>Van oorlogsbasis naar vestigingskolonie</h3>\r\nGedurende de eerste jaren na de verovering verbleven er op Curaçao in hoofdzaak militairen. In 1635 waren slechts 20 van de 412 compagniesdienaren burgers. Er woonden verder zo’n 50 inheemse bewoners. Spoedig arriveerden ook Afrikaanse slaven. Deze waren aanvankelijk vooral afkomstig van veroverde vijandelijke schepen. Maar hun aantallen waren tot midden zeventiende eeuw nog gering.\r\n\r\nVrijwel direct nadat bekend werd dat Curaçao was veroverd, ontstond er in het moederland belangstelling voor kolonisatieprojecten. Militairen en civiele beambten op het eiland, die hun contract hadden uitgediend, kregen ook de mogelijkheid om zich als landbouwer te vestigen. Maar dit leidde nauwelijks tot concrete resultaten.\r\n\r\nIn de jaren vijftig van zeventiende eeuw vestigden zich joodse kolonisten op het eiland. In 1665 woonden er, de inheemse bevolking niet meegerekend, zo’n 600 personen.Curaçao had inmiddels geen functie meer als oorlogsbasis, maar ontwikkelde zich nu, met de vanaf 1650 opkomende slavenhandel als motor, tot een commercieel centrum.Rond deze tijd ontstond ten noorden van fort Amsterdam een vestiging die uitgroeide tot een ommuurde stad, Willemstad. Het aantal plantages en tuinen groeide ook. Deze richtten zich vooral op de lokale voedselproductie.', '3. Verovering van Curaçao door de WIC en de komst van de Hollanders', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2017-08-10 20:10:34', '2017-08-10 18:10:34', '', '12', 'http://canon.bramperry.nl/12-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('154', '1', '2017-08-10 20:11:10', '2017-08-10 18:11:10', '<h3>De verovering van Curaçao</h3>\r\nCuraçao werd in 1634 door de West-Indische Compagnie (WIC) veroverd op de Spanjaarden.\r\n\r\nDe Republiek was op dat moment verwikkeld in de Tachtigjarige Oorlog (1568-1648) met Spanje en metPortugal. Deze landen waren sinds 1580 verenigd waren onder één staatshoofd, de Spaanse koning. De WIC was in 1621 opgericht om te dienen als een instrument in die oorlog. Behalve met de uitvoering van een ambitieus plan, het ‘groot desseyn’,dat gericht was op het veroveren van Portugese gebieden in Afrika en Brazilië, was de WIC vooral actief in de kaapvaart. Er bestond daarom behoefte aan een maritiem steunpunt in het operatiegebied van waaruit militaire acties konden worden ondernomen.Het strategisch gunstig gelegen Curaçao was daarvoor uitstekend geschikt. Het eiland was goed verdedigbaar en beschikte over een uitstekende natuurlijke haven, de Sint-Annabaai.\r\n\r\nEen expeditie onder leiding van Johannes van Walbeecken Pierre le Grand slaagde er vrij eenvoudig in om Curaçao te overmeesteren. De kleine Spaanse bezetting werd samen met het grootste deel van de inheemse bevolking gedeporteerd naar Venezuela. Daarna werd een begin gemaakt met het op orde brengen van de verdediging. Aan oostelijke zijde van de ingang van de Sint-Annabaai op een landtong die De Punt (Punda) werd genoemd werd een sterkte gebouwd, fort Amsterdam.\r\n<h3>Van oorlogsbasis naar vestigingskolonie</h3>\r\nGedurende de eerste jaren na de verovering verbleven er op Curaçao in hoofdzaak militairen. In 1635 waren slechts 20 van de 412 compagniesdienaren burgers. Er woonden verder zo’n 50 inheemse bewoners. Spoedig arriveerden ook Afrikaanse slaven. Deze waren aanvankelijk vooral afkomstig van veroverde vijandelijke schepen. Maar hun aantallen waren tot midden zeventiende eeuw nog gering.\r\n\r\nVrijwel direct nadat bekend werd dat Curaçao was veroverd, ontstond er in het moederland belangstelling voor kolonisatieprojecten. Militairen en civiele beambten op het eiland, die hun contract hadden uitgediend, kregen ook de mogelijkheid om zich als landbouwer te vestigen. Maar dit leidde nauwelijks tot concrete resultaten.\r\n\r\nIn de jaren vijftig van zeventiende eeuw vestigden zich joodse kolonisten op het eiland. In 1665 woonden er, de inheemse bevolking niet meegerekend, zo’n 600 personen.Curaçao had inmiddels geen functie meer als oorlogsbasis, maar ontwikkelde zich nu, met de vanaf 1650 opkomende slavenhandel als motor, tot een commercieel centrum.Rond deze tijd ontstond ten noorden van fort Amsterdam een vestiging die uitgroeide tot een ommuurde stad, Willemstad. Het aantal plantages en tuinen groeide ook. Deze richtten zich vooral op de lokale voedselproductie.', '3. Verovering door de WIC en de komst van de Hollanders', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2017-08-10 20:11:10', '2017-08-10 18:11:10', '', '12', 'http://canon.bramperry.nl/12-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('155', '1', '2017-08-10 20:12:01', '2017-08-10 18:12:01', 'Sed accumsan quam suscipit finibus molestie. In sollicitudin augue vitae tellus efficitur mollis. Vivamus vel vulputate tortor. Cras ac massa ex. Pellentesque sit amet massa sed ante consequat condimentum nec laoreet risus. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum in massa vel ex sodales semper in ac urna. Nullam at pulvinar ligula. Integer commodo felis et purus vestibulum, id porta nibh sollicitudin.\r\n\r\nFusce efficitur ac est sit amet ultricies. Maecenas gravida, arcu pellentesque congue tempus, nunc lacus gravida libero, in vestibulum purus tortor vitae elit. Nullam sit amet risus at turpis faucibus scelerisque et dapibus ante. Suspendisse non dolor mattis, finibus diam et, varius est. Curabitur suscipit tincidunt leo vel tristique. Phasellus molestie consectetur orci, eget maximus lorem malesuada ut. Nulla laoreet mattis pretium. Vestibulum placerat eu dolor laoreet accumsan. Ut varius purus in orci tempor vulputate. Curabitur consectetur tellus orci, at finibus enim pharetra sit amet. Vestibulum ligula purus, sodales lacinia magna in, aliquam ultrices ipsum.', '2. De Spaanse periode', '', 'inherit', 'closed', 'closed', '', '10-revision-v1', '', '', '2017-08-10 20:12:01', '2017-08-10 18:12:01', '', '10', 'http://canon.bramperry.nl/10-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('157', '1', '2017-08-10 20:14:24', '2017-08-10 18:14:24', '', 'logo-na', '', 'inherit', 'open', 'closed', '', 'logo-na', '', '', '2017-08-10 20:14:24', '2017-08-10 18:14:24', '', '132', 'http://canon.bramperry.nl/wp-content/uploads/2017/08/logo-na.png', '0', 'attachment', 'image/png', '0');
INSERT INTO `wp_posts` VALUES('158', '1', '2017-08-10 20:14:25', '2017-08-10 18:14:25', '', 'logo-uoc', '', 'inherit', 'open', 'closed', '', 'logo-uoc', '', '', '2017-08-10 20:14:25', '2017-08-10 18:14:25', '', '132', 'http://canon.bramperry.nl/wp-content/uploads/2017/08/logo-uoc.png', '0', 'attachment', 'image/png', '0');
INSERT INTO `wp_posts` VALUES('159', '1', '2017-08-10 20:14:38', '2017-08-10 18:14:38', '<h3>Initiatiefnemers</h3>\r\nNam posuere ornare suscipit. Donec ultricies efficitur tempus. Mauris vehicula arcu velit, vehicula pulvinar neque pulvinar vel. Quisque augue mi, suscipit sed mauris eu, ultricies laoreet arcu. Mauris commodo imperdiet interdum. Integer fringilla ut nisi et fermentum. Integer interdum ultrices vulputate. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum ante nunc, porttitor nec elementum in, rutrum eget libero. Vivamus vehicula quam vel lacus porttitor, vel luctus sem sagittis. Maecenas sit amet risus urna. Sed eu feugiat sem. Pellentesque quis nisl tincidunt, gravida mi laoreet, pharetra urna. Aliquam erat volutpat. Ut maximus libero ante, nec venenatis magna convallis eu.\r\n<h3>Sponsors</h3>\r\nUt vestibulum diam est. Suspendisse pellentesque diam neque, non iaculis leo efficitur vel. Nullam consequat fermentum lacus sed efficitur. In tristique vel tortor ut congue. In vehicula sem ac cursus lobortis. Mauris vestibulum id leo ut tristique. Sed a eleifend diam. Donec erat nibh, aliquet vel dictum dignissim, fermentum a nisi. Aenean hendrerit ligula nunc, quis semper dui ullamcorper sed. Suspendisse potenti. Fusce vitae dapibus mi.', 'Over ons', '', 'inherit', 'closed', 'closed', '', '132-revision-v1', '', '', '2017-08-10 20:14:38', '2017-08-10 18:14:38', '', '132', 'http://canon.bramperry.nl/132-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('160', '1', '2017-08-10 20:15:47', '2017-08-10 18:15:47', 'Fusce nunc risus, varius ut ligula id, varius malesuada lectus. Nulla tincidunt magna id molestie blandit. Nullam non erat dictum arcu imperdiet viverra. Sed eleifend risus felis, nec blandit quam efficitur sed. Phasellus fermentum tortor augue, sit amet interdum turpis congue quis. Aliquam vulputate lacus purus, et tincidunt diam euismod a. Morbi dui nisi, suscipit id nisi quis, ultricies volutpat velit. Integer vehicula lacinia porta. Vestibulum pellentesque nec enim in suscipit. Ut auctor, neque nec porttitor facilisis, mauris est tincidunt nisi, non rhoncus urna turpis ac eros. Proin massa purus, lacinia vitae metus ac, pulvinar ultricies nibh. Morbi dictum sapien mauris. Quisque sapien odio, mollis rutrum volutpat sit amet, fringilla vitae ante.\r\n\r\nNulla sodales vestibulum porttitor. Pellentesque lacinia id purus non accumsan. Mauris pharetra eros sit amet elementum pretium. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum luctus fringilla mauris, sit amet tristique nisi dignissim tincidunt. Suspendisse vel tincidunt urna, ac pulvinar nisl. Cras tempor, felis vitae porttitor scelerisque, ante ex commodo est, in vestibulum dolor eros nec dui. Pellentesque accumsan nulla a leo congue, eget vestibulum purus laoreet. Sed vulputate vehicula felis, vitae interdum tortor vehicula sit amet. Nulla eu tincidunt mi.', '1. De oorspronkelijke bewoners', '', 'inherit', 'closed', 'closed', '', '8-revision-v1', '', '', '2017-08-10 20:15:47', '2017-08-10 18:15:47', '', '8', 'http://canon.bramperry.nl/8-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('161', '1', '2017-08-10 20:16:11', '2017-08-10 18:16:11', 'Cras vitae faucibus nisl. Duis aliquet dui a velit sodales, vitae mollis tortor laoreet. Curabitur mattis tortor et urna ultrices mollis. Aliquam feugiat ipsum vel sem accumsan, vel pellentesque felis consequat. Vivamus a magna eu ex rutrum congue at eu purus. Nullam enim felis, convallis vel velit a, pulvinar bibendum lorem. Proin ac elit nec libero maximus tempus. Nunc sed tortor bibendum, pellentesque tortor quis, viverra eros. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. In sodales velit nibh, ut dictum nisl iaculis eget.\r\n\r\nNam purus urna, porttitor sed lobortis vitae, scelerisque a ex. Pellentesque blandit urna justo, eu euismod nisl interdum sit amet. Sed blandit diam non ultrices imperdiet. Vivamus molestie scelerisque egestas. Mauris euismod nec ex eget finibus. Morbi eu odio a diam dapibus mollis. Vestibulum eget sollicitudin quam. Curabitur nunc lectus, tempor ac dolor quis, pharetra sollicitudin neque. Aliquam consectetur et orci sed faucibus. Sed molestie interdum mattis. In ac arcu nulla.', 'Lesbrieven', '', 'inherit', 'closed', 'closed', '', '128-revision-v1', '', '', '2017-08-10 20:16:11', '2017-08-10 18:16:11', '', '128', 'http://canon.bramperry.nl/128-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('162', '1', '2017-08-10 20:16:38', '2017-08-10 18:16:38', 'Etiam quis lobortis nunc. Aliquam luctus risus in auctor consequat. Mauris sed purus lacus. Cras at blandit est, a hendrerit eros. Suspendisse condimentum egestas quam sed pellentesque. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Mauris sit amet est vitae ex ornare mollis. Duis porta justo vitae diam cursus, non vulputate odio molestie. Maecenas at erat est. Donec vel egestas nisi. Etiam lacinia, ante in commodo pretium, ante nisl pellentesque neque, eu euismod est purus consequat lorem. Curabitur convallis diam dictum tellus laoreet cursus.', 'Rechten', '', 'inherit', 'closed', 'closed', '', '125-revision-v1', '', '', '2017-08-10 20:16:38', '2017-08-10 18:16:38', '', '125', 'http://canon.bramperry.nl/125-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('163', '1', '2017-08-10 20:17:20', '2017-08-10 18:17:20', 'Sed accumsan quam suscipit finibus molestie. In sollicitudin augue vitae tellus efficitur mollis. Vivamus vel vulputate tortor. Cras ac massa ex. Pellentesque sit amet massa sed ante consequat condimentum nec laoreet risus. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum in massa vel ex sodales semper in ac urna. Nullam at pulvinar ligula. Integer commodo felis et purus vestibulum, id porta nibh sollicitudin.\r\n\r\nFusce efficitur ac est sit amet ultricies. Maecenas gravida, arcu pellentesque congue tempus, nunc lacus gravida libero, in vestibulum purus tortor vitae elit. Nullam sit amet risus at turpis faucibus scelerisque et dapibus ante. Suspendisse non dolor mattis, finibus diam et, varius est. Curabitur suscipit tincidunt leo vel tristique. Phasellus molestie consectetur orci, eget maximus lorem malesuada ut. Nulla laoreet mattis pretium. Vestibulum placerat eu dolor laoreet accumsan. Ut varius purus in orci tempor vulputate. Curabitur consectetur tellus orci, at finibus enim pharetra sit amet. Vestibulum ligula purus, sodales lacinia magna in, aliquam ultrices ipsum.', '2. De Spaanse periode', '', 'inherit', 'closed', 'closed', '', '10-revision-v1', '', '', '2017-08-10 20:17:20', '2017-08-10 18:17:20', '', '10', 'http://canon.bramperry.nl/10-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('164', '1', '2017-08-10 20:18:53', '2017-08-10 18:18:53', '', '7. Tula', '', 'inherit', 'closed', 'closed', '', '19-revision-v1', '', '', '2017-08-10 20:18:53', '2017-08-10 18:18:53', '', '19', 'http://canon.bramperry.nl/19-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('165', '1', '2017-08-10 20:21:08', '2017-08-10 18:21:08', 'Sed accumsan quam suscipit finibus molestie. In sollicitudin augue vitae tellus efficitur mollis. Vivamus vel vulputate tortor. Cras ac massa ex. Pellentesque sit amet massa sed ante consequat condimentum nec laoreet risus. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum in massa vel ex sodales semper in ac urna. Nullam at pulvinar ligula. Integer commodo felis et purus vestibulum, id porta nibh sollicitudin.\r\n\r\nFusce efficitur ac est sit amet ultricies. Maecenas gravida, arcu pellentesque congue tempus, nunc lacus gravida libero, in vestibulum purus tortor vitae elit. Nullam sit amet risus at turpis faucibus scelerisque et dapibus ante. Suspendisse non dolor mattis, finibus diam et, varius est. Curabitur suscipit tincidunt leo vel tristique. Phasellus molestie consectetur orci, eget maximus lorem malesuada ut. Nulla laoreet mattis pretium. Vestibulum placerat eu dolor laoreet accumsan. Ut varius purus in orci tempor vulputate. Curabitur consectetur tellus orci, at finibus enim pharetra sit amet. Vestibulum ligula purus, sodales lacinia magna in, aliquam ultrices ipsum.', '2. De Spaanse periode', '', 'inherit', 'closed', 'closed', '', '10-revision-v1', '', '', '2017-08-10 20:21:08', '2017-08-10 18:21:08', '', '10', 'http://canon.bramperry.nl/10-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('166', '1', '2017-08-10 20:23:49', '2017-08-10 18:23:49', '', '34. Staatkundige ontwikkelingen tot 10 oktober 2010', '', 'inherit', 'closed', 'closed', '', '73-revision-v1', '', '', '2017-08-10 20:23:49', '2017-08-10 18:23:49', '', '73', 'http://canon.bramperry.nl/73-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('167', '1', '2017-08-10 20:24:06', '2017-08-10 18:24:06', '', '34. De staatkundige ontwikkelingen vanaf het statuut tot 10 oktober 2010', '', 'inherit', 'closed', 'closed', '', '73-revision-v1', '', '', '2017-08-10 20:24:06', '2017-08-10 18:24:06', '', '73', 'http://canon.bramperry.nl/73-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('168', '1', '2017-08-10 20:24:19', '2017-08-10 18:24:19', '', '34. De staatkundige ontwikkelingen vanaf het statuut tot 10 oktober 2010', '', 'inherit', 'closed', 'closed', '', '73-revision-v1', '', '', '2017-08-10 20:24:19', '2017-08-10 18:24:19', '', '73', 'http://canon.bramperry.nl/73-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('171', '1', '2017-08-11 22:18:32', '2017-08-11 20:18:32', '<h3>Waar kunt u de 50 vensters vinden op het eiland?</h3>\r\nDe locaties worden aangegeven door het symbool van de Canon van Curaçao.', 'Kaart', '', 'inherit', 'closed', 'closed', '', '130-revision-v1', '', '', '2017-08-11 22:18:32', '2017-08-11 20:18:32', '', '130', 'http://canon.bramperry.nl/130-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('172', '1', '2017-08-11 22:20:14', '2017-08-11 20:20:14', 'In 1634 veroverde de West Indische Compagnie het eiland Curaçao. De W.I.C begon al snel met het opzetten van compagnieplantages met als doel het voedsel te verbouwen voor hun personeel en de als slaaf hierheen gebrachte Afrikanen. Naast deze compagnieplantages kwamen er al zeer snel particuliere plantages. Vrienden en familieleden van de bestuurders kregen grote terreinen in bruikleen en al heel snel was het grootste deel van Curacao onderverdeeld in plantages.\r\n\r\nDeze grote landbouwbedrijven oefenden een vorm van gemengd bedrijf uit. Normaal gesproken bestond zo’n bedrijf uit drie onderdelen: een hofje, onbewerkt land (de ‘mondi’) en akkers die in de regentijd werden gebruikt (de ‘kunuku’s).\r\n\r\nHet hofje was bijna altijd gelegen aan het uiteinde van een rooistelsel, waar de verweringslaag veel dikker was en waar de grondwaterspiegel het hoogst was. Daar plantte men de vruchtbomen en werd er wat groente gekweekt. De mondi werd gebruikt om schapen, geiten en koeien te laten grazen. Daarnaast waren er akkertjes voor de regenafhankelijke akkerbouw. Het gewas dat op deze akkers verbouwd werd, was het droogtebestendige sorghum (‘maishi chiki’), afkomstig uit West-Afrika. Als het regenseizoen (van november tot januari) goed was, werd er veel geproduceerd, maar zeer vaak viel het regenseizoen tegen en mislukte de oogst.   De maishi chiki was met name bestemd voor de bewoners van de plantage, zowel voor de tot slaaf gemaakte oorspronkelijk Afrikaanse bevolking en voor de eigenaarsfamilie. Hier werd het volksvoedsel ‘funchi’ van gemaakt. Inkomen verkreeg men door de verkoop van vee en melkproducten en de verkoop van fruit.\r\n\r\nDe meeste plantages waren niet erg rendabel, maar het bezit van een plantage was zeer belangrijk voor de status van de eigenaren.\r\n\r\nDe eigenaren behoorden meestal tot de groep van de “hoge blanke protestanten” en zij woonden meestal in de landhuizen.   De werkbevolking bestond oorspronkelijk uit tot slaaf gemaakte Afrikanen. Zij woonden in een buurtgemeenschap, gebouwd uit “kas di pal’i maishi” (eenvoudige lemen huisjes met een rieten dak) . Na de afschaffing van de slavernij in 1863 bleven vele ex-slaven op de plantages wonen met de verplichting om een aantal dagen in het jaar voor de plantage-eigenaar te werken (het zogenaamde ‘paga tera-systeem’).', '13. Het plantagesysteem op Curaçao', '', 'inherit', 'closed', 'closed', '', '31-revision-v1', '', '', '2017-08-11 22:20:14', '2017-08-11 20:20:14', '', '31', 'http://canon.bramperry.nl/31-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('173', '1', '2017-08-14 22:12:01', '2017-08-14 20:12:01', '', 'Brion', '', 'inherit', 'open', 'closed', '', 'brion', '', '', '2017-08-14 22:12:01', '2017-08-14 20:12:01', '', '29', 'http://canon.bramperry.nl/wp-content/uploads/2017/05/Brion.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('174', '1', '2017-08-14 22:12:23', '2017-08-14 20:12:23', '', '12. Brion, Piar, Bolivar', '', 'inherit', 'closed', 'closed', '', '29-revision-v1', '', '', '2017-08-14 22:12:23', '2017-08-14 20:12:23', '', '29', 'http://canon.bramperry.nl/29-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('175', '1', '2017-08-14 22:20:20', '2017-08-14 20:20:20', '', 'Grot tekeningen', '', 'inherit', 'open', 'closed', '', 'grot-tekeningen', '', '', '2017-09-06 21:41:17', '2017-09-06 19:41:17', '', '8', 'http://canon.bramperry.nl/wp-content/uploads/2017/05/Grot-tekeningen.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('176', '1', '2017-08-14 22:20:48', '2017-08-14 20:20:48', 'Fusce nunc risus, varius ut ligula id, varius malesuada lectus. Nulla tincidunt magna id molestie blandit. Nullam non erat dictum arcu imperdiet viverra. Sed eleifend risus felis, nec blandit quam efficitur sed. Phasellus fermentum tortor augue, sit amet interdum turpis congue quis. Aliquam vulputate lacus purus, et tincidunt diam euismod a. Morbi dui nisi, suscipit id nisi quis, ultricies volutpat velit. Integer vehicula lacinia porta. Vestibulum pellentesque nec enim in suscipit. Ut auctor, neque nec porttitor facilisis, mauris est tincidunt nisi, non rhoncus urna turpis ac eros. Proin massa purus, lacinia vitae metus ac, pulvinar ultricies nibh. Morbi dictum sapien mauris. Quisque sapien odio, mollis rutrum volutpat sit amet, fringilla vitae ante.\r\n\r\nNulla sodales vestibulum porttitor. Pellentesque lacinia id purus non accumsan. Mauris pharetra eros sit amet elementum pretium. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum luctus fringilla mauris, sit amet tristique nisi dignissim tincidunt. Suspendisse vel tincidunt urna, ac pulvinar nisl. Cras tempor, felis vitae porttitor scelerisque, ante ex commodo est, in vestibulum dolor eros nec dui. Pellentesque accumsan nulla a leo congue, eget vestibulum purus laoreet. Sed vulputate vehicula felis, vitae interdum tortor vehicula sit amet. Nulla eu tincidunt mi.', '1. De oorspronkelijke bewoners', '', 'inherit', 'closed', 'closed', '', '8-revision-v1', '', '', '2017-08-14 22:20:48', '2017-08-14 20:20:48', '', '8', 'http://canon.bramperry.nl/8-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('177', '1', '2017-08-14 22:23:49', '2017-08-14 20:23:49', '<h3>De verovering van Curaçao</h3>\r\nCuraçao werd in 1634 door de West-Indische Compagnie (WIC) veroverd op de Spanjaarden.\r\n\r\nDe Republiek was op dat moment verwikkeld in de Tachtigjarige Oorlog (1568-1648) met Spanje en metPortugal. Deze landen waren sinds 1580 verenigd waren onder één staatshoofd, de Spaanse koning. De WIC was in 1621 opgericht om te dienen als een instrument in die oorlog. Behalve met de uitvoering van een ambitieus plan, het ‘groot desseyn’,dat gericht was op het veroveren van Portugese gebieden in Afrika en Brazilië, was de WIC vooral actief in de kaapvaart. Er bestond daarom behoefte aan een maritiem steunpunt in het operatiegebied van waaruit militaire acties konden worden ondernomen.Het strategisch gunstig gelegen Curaçao was daarvoor uitstekend geschikt. Het eiland was goed verdedigbaar en beschikte over een uitstekende natuurlijke haven, de Sint-Annabaai.\r\n\r\nEen expeditie onder leiding van Johannes van Walbeecken Pierre le Grand slaagde er vrij eenvoudig in om Curaçao te overmeesteren. De kleine Spaanse bezetting werd samen met het grootste deel van de inheemse bevolking gedeporteerd naar Venezuela. Daarna werd een begin gemaakt met het op orde brengen van de verdediging. Aan oostelijke zijde van de ingang van de Sint-Annabaai op een landtong die De Punt (Punda) werd genoemd werd een sterkte gebouwd, fort Amsterdam.\r\n<h3>Van oorlogsbasis naar vestigingskolonie</h3>\r\nGedurende de eerste jaren na de verovering verbleven er op Curaçao in hoofdzaak militairen. In 1635 waren slechts 20 van de 412 compagniesdienaren burgers. Er woonden verder zo’n 50 inheemse bewoners. Spoedig arriveerden ook Afrikaanse slaven. Deze waren aanvankelijk vooral afkomstig van veroverde vijandelijke schepen. Maar hun aantallen waren tot midden zeventiende eeuw nog gering.\r\n\r\nVrijwel direct nadat bekend werd dat Curaçao was veroverd, ontstond er in het moederland belangstelling voor kolonisatieprojecten. Militairen en civiele beambten op het eiland, die hun contract hadden uitgediend, kregen ook de mogelijkheid om zich als landbouwer te vestigen. Maar dit leidde nauwelijks tot concrete resultaten.\r\n\r\nIn de jaren vijftig van zeventiende eeuw vestigden zich joodse kolonisten op het eiland. In 1665 woonden er, de inheemse bevolking niet meegerekend, zo’n 600 personen.Curaçao had inmiddels geen functie meer als oorlogsbasis, maar ontwikkelde zich nu, met de vanaf 1650 opkomende slavenhandel als motor, tot een commercieel centrum.Rond deze tijd ontstond ten noorden van fort Amsterdam een vestiging die uitgroeide tot een ommuurde stad, Willemstad. Het aantal plantages en tuinen groeide ook. Deze richtten zich vooral op de lokale voedselproductie.', '3. Verovering door de WIC en de komst van de Hollanders', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2017-08-14 22:23:49', '2017-08-14 20:23:49', '', '12', 'http://canon.bramperry.nl/12-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('178', '1', '2017-08-14 22:24:23', '2017-08-14 20:24:23', '', 'logoWIC', '', 'inherit', 'open', 'closed', '', 'logowic', '', '', '2017-08-14 22:25:49', '2017-08-14 20:25:49', '', '12', 'http://canon.bramperry.nl/wp-content/uploads/2017/05/logoWIC-.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('179', '1', '2017-08-14 22:24:32', '2017-08-14 20:24:32', '<h3>De verovering van Curaçao</h3>\r\nCuraçao werd in 1634 door de West-Indische Compagnie (WIC) veroverd op de Spanjaarden.\r\n\r\nDe Republiek was op dat moment verwikkeld in de Tachtigjarige Oorlog (1568-1648) met Spanje en metPortugal. Deze landen waren sinds 1580 verenigd waren onder één staatshoofd, de Spaanse koning. De WIC was in 1621 opgericht om te dienen als een instrument in die oorlog. Behalve met de uitvoering van een ambitieus plan, het ‘groot desseyn’,dat gericht was op het veroveren van Portugese gebieden in Afrika en Brazilië, was de WIC vooral actief in de kaapvaart. Er bestond daarom behoefte aan een maritiem steunpunt in het operatiegebied van waaruit militaire acties konden worden ondernomen.Het strategisch gunstig gelegen Curaçao was daarvoor uitstekend geschikt. Het eiland was goed verdedigbaar en beschikte over een uitstekende natuurlijke haven, de Sint-Annabaai.\r\n\r\nEen expeditie onder leiding van Johannes van Walbeecken Pierre le Grand slaagde er vrij eenvoudig in om Curaçao te overmeesteren. De kleine Spaanse bezetting werd samen met het grootste deel van de inheemse bevolking gedeporteerd naar Venezuela. Daarna werd een begin gemaakt met het op orde brengen van de verdediging. Aan oostelijke zijde van de ingang van de Sint-Annabaai op een landtong die De Punt (Punda) werd genoemd werd een sterkte gebouwd, fort Amsterdam.\r\n<h3>Van oorlogsbasis naar vestigingskolonie</h3>\r\nGedurende de eerste jaren na de verovering verbleven er op Curaçao in hoofdzaak militairen. In 1635 waren slechts 20 van de 412 compagniesdienaren burgers. Er woonden verder zo’n 50 inheemse bewoners. Spoedig arriveerden ook Afrikaanse slaven. Deze waren aanvankelijk vooral afkomstig van veroverde vijandelijke schepen. Maar hun aantallen waren tot midden zeventiende eeuw nog gering.\r\n\r\nVrijwel direct nadat bekend werd dat Curaçao was veroverd, ontstond er in het moederland belangstelling voor kolonisatieprojecten. Militairen en civiele beambten op het eiland, die hun contract hadden uitgediend, kregen ook de mogelijkheid om zich als landbouwer te vestigen. Maar dit leidde nauwelijks tot concrete resultaten.\r\n\r\nIn de jaren vijftig van zeventiende eeuw vestigden zich joodse kolonisten op het eiland. In 1665 woonden er, de inheemse bevolking niet meegerekend, zo’n 600 personen.Curaçao had inmiddels geen functie meer als oorlogsbasis, maar ontwikkelde zich nu, met de vanaf 1650 opkomende slavenhandel als motor, tot een commercieel centrum.Rond deze tijd ontstond ten noorden van fort Amsterdam een vestiging die uitgroeide tot een ommuurde stad, Willemstad. Het aantal plantages en tuinen groeide ook. Deze richtten zich vooral op de lokale voedselproductie.', '3. Verovering door de WIC en de komst van de Hollanders', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2017-08-14 22:24:32', '2017-08-14 20:24:32', '', '12', 'http://canon.bramperry.nl/12-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('180', '1', '2017-08-14 22:25:53', '2017-08-14 20:25:53', '<h3>De verovering van Curaçao</h3>\r\nCuraçao werd in 1634 door de West-Indische Compagnie (WIC) veroverd op de Spanjaarden.\r\n\r\nDe Republiek was op dat moment verwikkeld in de Tachtigjarige Oorlog (1568-1648) met Spanje en metPortugal. Deze landen waren sinds 1580 verenigd waren onder één staatshoofd, de Spaanse koning. De WIC was in 1621 opgericht om te dienen als een instrument in die oorlog. Behalve met de uitvoering van een ambitieus plan, het ‘groot desseyn’,dat gericht was op het veroveren van Portugese gebieden in Afrika en Brazilië, was de WIC vooral actief in de kaapvaart. Er bestond daarom behoefte aan een maritiem steunpunt in het operatiegebied van waaruit militaire acties konden worden ondernomen.Het strategisch gunstig gelegen Curaçao was daarvoor uitstekend geschikt. Het eiland was goed verdedigbaar en beschikte over een uitstekende natuurlijke haven, de Sint-Annabaai.\r\n\r\nEen expeditie onder leiding van Johannes van Walbeecken Pierre le Grand slaagde er vrij eenvoudig in om Curaçao te overmeesteren. De kleine Spaanse bezetting werd samen met het grootste deel van de inheemse bevolking gedeporteerd naar Venezuela. Daarna werd een begin gemaakt met het op orde brengen van de verdediging. Aan oostelijke zijde van de ingang van de Sint-Annabaai op een landtong die De Punt (Punda) werd genoemd werd een sterkte gebouwd, fort Amsterdam.\r\n<h3>Van oorlogsbasis naar vestigingskolonie</h3>\r\nGedurende de eerste jaren na de verovering verbleven er op Curaçao in hoofdzaak militairen. In 1635 waren slechts 20 van de 412 compagniesdienaren burgers. Er woonden verder zo’n 50 inheemse bewoners. Spoedig arriveerden ook Afrikaanse slaven. Deze waren aanvankelijk vooral afkomstig van veroverde vijandelijke schepen. Maar hun aantallen waren tot midden zeventiende eeuw nog gering.\r\n\r\nVrijwel direct nadat bekend werd dat Curaçao was veroverd, ontstond er in het moederland belangstelling voor kolonisatieprojecten. Militairen en civiele beambten op het eiland, die hun contract hadden uitgediend, kregen ook de mogelijkheid om zich als landbouwer te vestigen. Maar dit leidde nauwelijks tot concrete resultaten.\r\n\r\nIn de jaren vijftig van zeventiende eeuw vestigden zich joodse kolonisten op het eiland. In 1665 woonden er, de inheemse bevolking niet meegerekend, zo’n 600 personen.Curaçao had inmiddels geen functie meer als oorlogsbasis, maar ontwikkelde zich nu, met de vanaf 1650 opkomende slavenhandel als motor, tot een commercieel centrum.Rond deze tijd ontstond ten noorden van fort Amsterdam een vestiging die uitgroeide tot een ommuurde stad, Willemstad. Het aantal plantages en tuinen groeide ook. Deze richtten zich vooral op de lokale voedselproductie.', '3. Verovering door de WIC en de komst van de Hollanders', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2017-08-14 22:25:53', '2017-08-14 20:25:53', '', '12', 'http://canon.bramperry.nl/12-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('181', '1', '2017-08-14 22:26:58', '2017-08-14 20:26:58', '', 'landkaart 14e eeuw', '', 'inherit', 'open', 'closed', '', 'landkaart-14e-eeuw', '', '', '2017-08-14 22:27:03', '2017-08-14 20:27:03', '', '10', 'http://canon.bramperry.nl/wp-content/uploads/2017/05/landkaart-14e-eeuw.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('182', '1', '2017-08-14 22:27:17', '2017-08-14 20:27:17', 'Sed accumsan quam suscipit finibus molestie. In sollicitudin augue vitae tellus efficitur mollis. Vivamus vel vulputate tortor. Cras ac massa ex. Pellentesque sit amet massa sed ante consequat condimentum nec laoreet risus. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum in massa vel ex sodales semper in ac urna. Nullam at pulvinar ligula. Integer commodo felis et purus vestibulum, id porta nibh sollicitudin.\r\n\r\nFusce efficitur ac est sit amet ultricies. Maecenas gravida, arcu pellentesque congue tempus, nunc lacus gravida libero, in vestibulum purus tortor vitae elit. Nullam sit amet risus at turpis faucibus scelerisque et dapibus ante. Suspendisse non dolor mattis, finibus diam et, varius est. Curabitur suscipit tincidunt leo vel tristique. Phasellus molestie consectetur orci, eget maximus lorem malesuada ut. Nulla laoreet mattis pretium. Vestibulum placerat eu dolor laoreet accumsan. Ut varius purus in orci tempor vulputate. Curabitur consectetur tellus orci, at finibus enim pharetra sit amet. Vestibulum ligula purus, sodales lacinia magna in, aliquam ultrices ipsum.', '2. De Spaanse periode', '', 'inherit', 'closed', 'closed', '', '10-revision-v1', '', '', '2017-08-14 22:27:17', '2017-08-14 20:27:17', '', '10', 'http://canon.bramperry.nl/10-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('183', '1', '2017-08-14 22:28:15', '2017-08-14 20:28:15', '', 'vuist', '', 'inherit', 'open', 'closed', '', 'vuist', '', '', '2017-08-14 22:28:30', '2017-08-14 20:28:30', '', '14', 'http://canon.bramperry.nl/wp-content/uploads/2017/05/vuist.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('184', '1', '2017-08-14 22:28:33', '2017-08-14 20:28:33', '', '5. De slavenhandel en slaverij', '', 'inherit', 'closed', 'closed', '', '14-revision-v1', '', '', '2017-08-14 22:28:33', '2017-08-14 20:28:33', '', '14', 'http://canon.bramperry.nl/14-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('185', '1', '2017-08-14 22:31:28', '2017-08-14 20:31:28', '<p class=\"p1\"><span class=\"s1\">Om in de nieuwe koloniën zoveel mogelijk goud en zilver te ontginnen en landbouwproducten voor de export te verbouwen waren veel arbeidskrachten nodig en werden ruim 11 miljoen tot slaaf gemaakte Afrikanen, geïmporteerd.<span class=\"Apple-converted-space\">  </span>Aan de kusten van Afrika werden handelsposten gebouwd voor deze Trans Atlantische Slavenhandel en de vraag naar menselijk koopwaar werd zo groot dat grote delen van West Afrika ontvolkt raakten door rooftochten en oorlogen. </span></p>\n<p class=\"p1\"><span class=\"s1\">Curaçao werd een belangrijk centrum voor de slavenhandel door de WIC, welke van 1662 tot 1713 het monopolie voor de levering aan de Spaanse gebieden had. De meeste slaven werden doorverkocht en degenen die achterbleven moesten alle soorten werk doen. In de stad en haven moesten de slaven onder meer goederen in- en uitladen, helpen op de werven en bij bouwwerkzaamheden, op de schepen als matrozen werken en in de huishoudingen dienen.<span class=\"Apple-converted-space\"> </span></span></p>\n<p class=\"p1\"><span class=\"s1\">Op de plantages werd onderscheid gemaakt tussen de huisslaven en veldslaven. De huisslaven waren vooral bedienden en had een iets betere positie. De veldslaven, de meerderheid, moesten al het zware werk doen zoals het schoonmaken van terreinen en deze bewerken met de <i>chapi</i> en oogsten. Zij moesten ook zorgen voor het vee, en scheidingsmuren bouwen en diepe putten graven</span><span class=\"s2\">. </span></p>\n<p class=\"p1\"><span class=\"s1\">De <i>shon </i>of zijn <i>fitó</i> bepaalde welke werkzaamheden uitgevoerd moesten worden onder leiding van een opzichter, de <i>bomba</i>, meestal zelf een slaaf</span><span class=\"s2\">.</span><span class=\"s1\"> De gewassen die het meest werden verbouwd waren maïs, bonen en pompoenen</span><span class=\"s2\">,</span><span class=\"s1\"> maar het belangrijkst was wel de extensieve veehouderij. Iedere plantage had een schaduwrijk hofje waar vruchten en groenten werden verbouwd met water uit putten. Een tussenpositie namen de ambachtsslaven in; onder meer timmerlieden, metselaars, kleermakers en smeden. Zij werden ook vaak verhuurd voor werkzaamheden op andere plantages of in de stad en hierdoor hadden zij meer bewegingsvrijheid. Zij moesten altijd een deel van hun opbrengst aan hun meester geven, maar konden zich ook vrij kopen door te sparen van wat zij zelf mochten houden. De ambachtslieden konden echter ook voor ander werk worden ingezet wanneer nodig. Door de droogte en algemene economische malaise hadden de slaven vaak gebrek aan alles, vooral voedsel. De slaaf werd als inferieur beschouwd en moest zo lang mogelijk in een situatie van onderworpenheid en onwetendheid blijven. Hij was nagenoeg rechteloos en eigendom van zijn meester, de <i>shon</i>. Zijn leven stond geheel in het teken van dienstbaarheid en werd volledig bepaald door de meester. Hij had ook geen eigen familienaam en mocht niet trouwen.</span></p>', '5. De slavenhandel en slaverij', '', 'inherit', 'closed', 'closed', '', '14-autosave-v1', '', '', '2017-08-14 22:31:28', '2017-08-14 20:31:28', '', '14', 'http://canon.bramperry.nl/14-autosave-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('186', '1', '2017-08-14 22:31:35', '2017-08-14 20:31:35', '<p class=\"p1\"><span class=\"s1\">Om in de nieuwe koloniën zoveel mogelijk goud en zilver te ontginnen en landbouwproducten voor de export te verbouwen waren veel arbeidskrachten nodig en werden ruim 11 miljoen tot slaaf gemaakte Afrikanen, geïmporteerd.<span class=\"Apple-converted-space\">  </span>Aan de kusten van Afrika werden handelsposten gebouwd voor deze Trans Atlantische Slavenhandel en de vraag naar menselijk koopwaar werd zo groot dat grote delen van West Afrika ontvolkt raakten door rooftochten en oorlogen. </span></p>\r\n<p class=\"p1\"><span class=\"s1\">Curaçao werd een belangrijk centrum voor de slavenhandel door de WIC, welke van 1662 tot 1713 het monopolie voor de levering aan de Spaanse gebieden had. De meeste slaven werden doorverkocht en degenen die achterbleven moesten alle soorten werk doen. In de stad en haven moesten de slaven onder meer goederen in- en uitladen, helpen op de werven en bij bouwwerkzaamheden, op de schepen als matrozen werken en in de huishoudingen dienen.<span class=\"Apple-converted-space\"> </span></span></p>\r\n<p class=\"p1\"><span class=\"s1\">Op de plantages werd onderscheid gemaakt tussen de huisslaven en veldslaven. De huisslaven waren vooral bedienden en had een iets betere positie. De veldslaven, de meerderheid, moesten al het zware werk doen zoals het schoonmaken van terreinen en deze bewerken met de <i>chapi</i> en oogsten. Zij moesten ook zorgen voor het vee, en scheidingsmuren bouwen en diepe putten graven</span><span class=\"s2\">. </span></p>\r\n<p class=\"p1\"><span class=\"s1\">De <i>shon </i>of zijn <i>fitó</i> bepaalde welke werkzaamheden uitgevoerd moesten worden onder leiding van een opzichter, de <i>bomba</i>, meestal zelf een slaaf</span><span class=\"s2\">.</span><span class=\"s1\"> De gewassen die het meest werden verbouwd waren maïs, bonen en pompoenen</span><span class=\"s2\">,</span><span class=\"s1\"> maar het belangrijkst was wel de extensieve veehouderij. Iedere plantage had een schaduwrijk hofje waar vruchten en groenten werden verbouwd met water uit putten. Een tussenpositie namen de ambachtsslaven in; onder meer timmerlieden, metselaars, kleermakers en smeden. Zij werden ook vaak verhuurd voor werkzaamheden op andere plantages of in de stad en hierdoor hadden zij meer bewegingsvrijheid. Zij moesten altijd een deel van hun opbrengst aan hun meester geven, maar konden zich ook vrij kopen door te sparen van wat zij zelf mochten houden. De ambachtslieden konden echter ook voor ander werk worden ingezet wanneer nodig. </span></p>\r\n<p class=\"p1\"><span class=\"s1\">Door de droogte en algemene economische malaise hadden de slaven vaak gebrek aan alles, vooral voedsel. De slaaf werd als inferieur beschouwd en moest zo lang mogelijk in een situatie van onderworpenheid en onwetendheid blijven. Hij was nagenoeg rechteloos en eigendom van zijn meester, de <i>shon</i>. Zijn leven stond geheel in het teken van dienstbaarheid en werd volledig bepaald door de meester. Hij had ook geen eigen familienaam en mocht niet trouwen.</span></p>', '5. De slavenhandel en slaverij', '', 'inherit', 'closed', 'closed', '', '14-revision-v1', '', '', '2017-08-14 22:31:35', '2017-08-14 20:31:35', '', '14', 'http://canon.bramperry.nl/14-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('187', '1', '2017-08-14 22:33:26', '2017-08-14 20:33:26', '', 'slavenmonument 2 RR_2', '', 'inherit', 'open', 'closed', '', 'slavenmonument-2-rr_2', '', '', '2017-08-14 22:33:39', '2017-08-14 20:33:39', '', '19', 'http://canon.bramperry.nl/wp-content/uploads/2017/05/slavenmonument-2-RR_2.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('188', '1', '2017-08-14 22:33:42', '2017-08-14 20:33:42', '', '7. Tula', '', 'inherit', 'closed', 'closed', '', '19-revision-v1', '', '', '2017-08-14 22:33:42', '2017-08-14 20:33:42', '', '19', 'http://canon.bramperry.nl/19-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('189', '1', '2017-08-14 22:46:28', '2017-08-14 20:46:28', '<h3>De verovering van Curaçao</h3>\r\nCuraçao werd in 1634 door de West-Indische Compagnie (WIC) veroverd op de Spanjaarden.\r\n\r\nDe Republiek was op dat moment verwikkeld in de Tachtigjarige Oorlog (1568-1648) met Spanje en metPortugal. Deze landen waren sinds 1580 verenigd waren onder één staatshoofd, de Spaanse koning. De WIC was in 1621 opgericht om te dienen als een instrument in die oorlog. Behalve met de uitvoering van een ambitieus plan, het ‘groot desseyn’,dat gericht was op het veroveren van Portugese gebieden in Afrika en Brazilië, was de WIC vooral actief in de kaapvaart. Er bestond daarom behoefte aan een maritiem steunpunt in het operatiegebied van waaruit militaire acties konden worden ondernomen.Het strategisch gunstig gelegen Curaçao was daarvoor uitstekend geschikt. Het eiland was goed verdedigbaar en beschikte over een uitstekende natuurlijke haven, de Sint-Annabaai.\r\n\r\nEen expeditie onder leiding van Johannes van Walbeecken Pierre le Grand slaagde er vrij eenvoudig in om Curaçao te overmeesteren. De kleine Spaanse bezetting werd samen met het grootste deel van de inheemse bevolking gedeporteerd naar Venezuela. Daarna werd een begin gemaakt met het op orde brengen van de verdediging. Aan oostelijke zijde van de ingang van de Sint-Annabaai op een landtong die De Punt (Punda) werd genoemd werd een sterkte gebouwd, fort Amsterdam.\r\n<h3>Van oorlogsbasis naar vestigingskolonie</h3>\r\nGedurende de eerste jaren na de verovering verbleven er op Curaçao in hoofdzaak militairen. In 1635 waren slechts 20 van de 412 compagniesdienaren burgers. Er woonden verder zo’n 50 inheemse bewoners. Spoedig arriveerden ook Afrikaanse slaven. Deze waren aanvankelijk vooral afkomstig van veroverde vijandelijke schepen. Maar hun aantallen waren tot midden zeventiende eeuw nog gering.\r\n\r\nVrijwel direct nadat bekend werd dat Curaçao was veroverd, ontstond er in het moederland belangstelling voor kolonisatieprojecten. Militairen en civiele beambten op het eiland, die hun contract hadden uitgediend, kregen ook de mogelijkheid om zich als landbouwer te vestigen. Maar dit leidde nauwelijks tot concrete resultaten.\r\n\r\nIn de jaren vijftig van zeventiende eeuw vestigden zich joodse kolonisten op het eiland. In 1665 woonden er, de inheemse bevolking niet meegerekend, zo’n 600 personen.Curaçao had inmiddels geen functie meer als oorlogsbasis, maar ontwikkelde zich nu, met de vanaf 1650 opkomende slavenhandel als motor, tot een commercieel centrum.Rond deze tijd ontstond ten noorden van fort Amsterdam een vestiging die uitgroeide tot een ommuurde stad, Willemstad. Het aantal plantages en tuinen groeide ook. Deze richtten zich vooral op de lokale voedselproductie.', '3. Verovering door de WIC en de komst van de Hollanders', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2017-08-14 22:46:28', '2017-08-14 20:46:28', '', '12', 'http://canon.bramperry.nl/12-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('190', '1', '2017-08-14 22:49:13', '2017-08-14 20:49:13', '', 'logo-bernhard', '', 'inherit', 'open', 'closed', '', 'logo-bernhard', '', '', '2017-08-14 22:49:13', '2017-08-14 20:49:13', '', '132', 'http://canon.bramperry.nl/wp-content/uploads/2017/08/logo-bernhard.png', '0', 'attachment', 'image/png', '0');
INSERT INTO `wp_posts` VALUES('191', '1', '2017-08-14 22:49:21', '2017-08-14 20:49:21', '<h3>Initiatiefnemers</h3>\r\nNam posuere ornare suscipit. Donec ultricies efficitur tempus. Mauris vehicula arcu velit, vehicula pulvinar neque pulvinar vel. Quisque augue mi, suscipit sed mauris eu, ultricies laoreet arcu. Mauris commodo imperdiet interdum. Integer fringilla ut nisi et fermentum. Integer interdum ultrices vulputate. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum ante nunc, porttitor nec elementum in, rutrum eget libero. Vivamus vehicula quam vel lacus porttitor, vel luctus sem sagittis. Maecenas sit amet risus urna. Sed eu feugiat sem. Pellentesque quis nisl tincidunt, gravida mi laoreet, pharetra urna. Aliquam erat volutpat. Ut maximus libero ante, nec venenatis magna convallis eu.\r\n<h3>Sponsors</h3>\r\nUt vestibulum diam est. Suspendisse pellentesque diam neque, non iaculis leo efficitur vel. Nullam consequat fermentum lacus sed efficitur. In tristique vel tortor ut congue. In vehicula sem ac cursus lobortis. Mauris vestibulum id leo ut tristique. Sed a eleifend diam. Donec erat nibh, aliquet vel dictum dignissim, fermentum a nisi. Aenean hendrerit ligula nunc, quis semper dui ullamcorper sed. Suspendisse potenti. Fusce vitae dapibus mi.', 'Over ons', '', 'inherit', 'closed', 'closed', '', '132-revision-v1', '', '', '2017-08-14 22:49:21', '2017-08-14 20:49:21', '', '132', 'http://canon.bramperry.nl/132-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('193', '1', '2017-08-16 21:23:50', '2017-08-16 19:23:50', '<h3>De verovering van Curaçao</h3>\r\nCuraçao werd in 1634 door de West-Indische Compagnie (WIC) veroverd op de Spanjaarden.\r\n\r\nDe Republiek was op dat moment verwikkeld in de Tachtigjarige Oorlog (1568-1648) met Spanje en metPortugal. Deze landen waren sinds 1580 verenigd waren onder één staatshoofd, de Spaanse koning. De WIC was in 1621 opgericht om te dienen als een instrument in die oorlog. Behalve met de uitvoering van een ambitieus plan, het ‘groot desseyn’,dat gericht was op het veroveren van Portugese gebieden in Afrika en Brazilië, was de WIC vooral actief in de kaapvaart. Er bestond daarom behoefte aan een maritiem steunpunt in het operatiegebied van waaruit militaire acties konden worden ondernomen.Het strategisch gunstig gelegen Curaçao was daarvoor uitstekend geschikt. Het eiland was goed verdedigbaar en beschikte over een uitstekende natuurlijke haven, de Sint-Annabaai.\r\n\r\nEen expeditie onder leiding van Johannes van Walbeecken Pierre le Grand slaagde er vrij eenvoudig in om Curaçao te overmeesteren. De kleine Spaanse bezetting werd samen met het grootste deel van de inheemse bevolking gedeporteerd naar Venezuela. Daarna werd een begin gemaakt met het op orde brengen van de verdediging. Aan oostelijke zijde van de ingang van de Sint-Annabaai op een landtong die De Punt (Punda) werd genoemd werd een sterkte gebouwd, fort Amsterdam.\r\n<h3>Van oorlogsbasis naar vestigingskolonie</h3>\r\nGedurende de eerste jaren na de verovering verbleven er op Curaçao in hoofdzaak militairen. In 1635 waren slechts 20 van de 412 compagniesdienaren burgers. Er woonden verder zo’n 50 inheemse bewoners. Spoedig arriveerden ook Afrikaanse slaven. Deze waren aanvankelijk vooral afkomstig van veroverde vijandelijke schepen. Maar hun aantallen waren tot midden zeventiende eeuw nog gering.\r\n\r\nVrijwel direct nadat bekend werd dat Curaçao was veroverd, ontstond er in het moederland belangstelling voor kolonisatieprojecten. Militairen en civiele beambten op het eiland, die hun contract hadden uitgediend, kregen ook de mogelijkheid om zich als landbouwer te vestigen. Maar dit leidde nauwelijks tot concrete resultaten.\r\n\r\nIn de jaren vijftig van zeventiende eeuw vestigden zich joodse kolonisten op het eiland. In 1665 woonden er, de inheemse bevolking niet meegerekend, zo’n 600 personen.Curaçao had inmiddels geen functie meer als oorlogsbasis, maar ontwikkelde zich nu, met de vanaf 1650 opkomende slavenhandel als motor, tot een commercieel centrum.Rond deze tijd ontstond ten noorden van fort Amsterdam een vestiging die uitgroeide tot een ommuurde stad, Willemstad. Het aantal plantages en tuinen groeide ook. Deze richtten zich vooral op de lokale voedselproductie.', '3. Verovering door de WIC en de komst van de Hollanders', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2017-08-16 21:23:50', '2017-08-16 19:23:50', '', '12', 'http://canon.bramperry.nl/12-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('194', '1', '2017-08-16 21:26:51', '2017-08-16 19:26:51', '<h3>De verovering van Curaçao</h3>\r\nCuraçao werd in 1634 door de West-Indische Compagnie (WIC) veroverd op de Spanjaarden.\r\n\r\nDe Republiek was op dat moment verwikkeld in de Tachtigjarige Oorlog (1568-1648) met Spanje en metPortugal. Deze landen waren sinds 1580 verenigd waren onder één staatshoofd, de Spaanse koning. De WIC was in 1621 opgericht om te dienen als een instrument in die oorlog. Behalve met de uitvoering van een ambitieus plan, het ‘groot desseyn’,dat gericht was op het veroveren van Portugese gebieden in Afrika en Brazilië, was de WIC vooral actief in de kaapvaart. Er bestond daarom behoefte aan een maritiem steunpunt in het operatiegebied van waaruit militaire acties konden worden ondernomen.Het strategisch gunstig gelegen Curaçao was daarvoor uitstekend geschikt. Het eiland was goed verdedigbaar en beschikte over een uitstekende natuurlijke haven, de Sint-Annabaai.\r\n\r\nEen expeditie onder leiding van Johannes van Walbeecken Pierre le Grand slaagde er vrij eenvoudig in om Curaçao te overmeesteren. De kleine Spaanse bezetting werd samen met het grootste deel van de inheemse bevolking gedeporteerd naar Venezuela. Daarna werd een begin gemaakt met het op orde brengen van de verdediging. Aan oostelijke zijde van de ingang van de Sint-Annabaai op een landtong die De Punt (Punda) werd genoemd werd een sterkte gebouwd, fort Amsterdam.\r\n<h3>Van oorlogsbasis naar vestigingskolonie</h3>\r\nGedurende de eerste jaren na de verovering verbleven er op Curaçao in hoofdzaak militairen. In 1635 waren slechts 20 van de 412 compagniesdienaren burgers. Er woonden verder zo’n 50 inheemse bewoners. Spoedig arriveerden ook Afrikaanse slaven. Deze waren aanvankelijk vooral afkomstig van veroverde vijandelijke schepen. Maar hun aantallen waren tot midden zeventiende eeuw nog gering.\r\n\r\nVrijwel direct nadat bekend werd dat Curaçao was veroverd, ontstond er in het moederland belangstelling voor kolonisatieprojecten. Militairen en civiele beambten op het eiland, die hun contract hadden uitgediend, kregen ook de mogelijkheid om zich als landbouwer te vestigen. Maar dit leidde nauwelijks tot concrete resultaten.\r\n\r\nIn de jaren vijftig van zeventiende eeuw vestigden zich joodse kolonisten op het eiland. In 1665 woonden er, de inheemse bevolking niet meegerekend, zo’n 600 personen.Curaçao had inmiddels geen functie meer als oorlogsbasis, maar ontwikkelde zich nu, met de vanaf 1650 opkomende slavenhandel als motor, tot een commercieel centrum.Rond deze tijd ontstond ten noorden van fort Amsterdam een vestiging die uitgroeide tot een ommuurde stad, Willemstad. Het aantal plantages en tuinen groeide ook. Deze richtten zich vooral op de lokale voedselproductie.', '3. Verovering door de WIC en de komst van de Hollanders', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2017-08-16 21:26:51', '2017-08-16 19:26:51', '', '12', 'http://canon.bramperry.nl/12-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('195', '1', '2017-08-17 13:22:37', '2017-08-17 11:22:37', '<h3>Initiatiefnemers</h3>\r\nNam posuere ornare suscipit. Donec ultricies efficitur tempus. Mauris vehicula arcu velit, vehicula pulvinar neque pulvinar vel. Quisque augue mi, suscipit sed mauris eu, ultricies laoreet arcu. Mauris commodo imperdiet interdum. Integer fringilla ut nisi et fermentum. Integer interdum ultrices vulputate. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum ante nunc, porttitor nec elementum in, rutrum eget libero. Vivamus vehicula quam vel lacus porttitor, vel luctus sem sagittis. Maecenas sit amet risus urna. Sed eu feugiat sem. Pellentesque quis nisl tincidunt, gravida mi laoreet, pharetra urna. Aliquam erat volutpat. Ut maximus libero ante, nec venenatis magna convallis eu.\r\n<h3>Sponsors</h3>\r\nUt vestibulum diam est. Suspendisse pellentesque diam neque, non iaculis leo efficitur vel. Nullam consequat fermentum lacus sed efficitur. In tristique vel tortor ut congue. In vehicula sem ac cursus lobortis. Mauris vestibulum id leo ut tristique. Sed a eleifend diam. Donec erat nibh, aliquet vel dictum dignissim, fermentum a nisi. Aenean hendrerit ligula nunc, quis semper dui ullamcorper sed. Suspendisse potenti. Fusce vitae dapibus mi.', 'Over ons', '', 'inherit', 'closed', 'closed', '', '132-revision-v1', '', '', '2017-08-17 13:22:37', '2017-08-17 11:22:37', '', '132', 'http://canon.bramperry.nl/132-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('196', '1', '2017-08-17 13:23:28', '2017-08-17 11:23:28', '<h3>Initiatiefnemers</h3>\r\nNam posuere ornare suscipit. Donec ultricies efficitur tempus. Mauris vehicula arcu velit, vehicula pulvinar neque pulvinar vel. Quisque augue mi, suscipit sed mauris eu, ultricies laoreet arcu. Mauris commodo imperdiet interdum. Integer fringilla ut nisi et fermentum. Integer interdum ultrices vulputate. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum ante nunc, porttitor nec elementum in, rutrum eget libero. Vivamus vehicula quam vel lacus porttitor, vel luctus sem sagittis. Maecenas sit amet risus urna. Sed eu feugiat sem. Pellentesque quis nisl tincidunt, gravida mi laoreet, pharetra urna. Aliquam erat volutpat. Ut maximus libero ante, nec venenatis magna convallis eu.\r\n<h3>Sponsors</h3>\r\nUt vestibulum diam est. Suspendisse pellentesque diam neque, non iaculis leo efficitur vel. Nullam consequat fermentum lacus sed efficitur. In tristique vel tortor ut congue. In vehicula sem ac cursus lobortis. Mauris vestibulum id leo ut tristique. Sed a eleifend diam. Donec erat nibh, aliquet vel dictum dignissim, fermentum a nisi. Aenean hendrerit ligula nunc, quis semper dui ullamcorper sed. Suspendisse potenti. Fusce vitae dapibus mi.', 'Over ons', '', 'inherit', 'closed', 'closed', '', '132-revision-v1', '', '', '2017-08-17 13:23:28', '2017-08-17 11:23:28', '', '132', 'http://canon.bramperry.nl/132-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('197', '1', '2017-08-17 13:23:59', '2017-08-17 11:23:59', '<h3>Initiatiefnemers</h3>\r\nNam posuere ornare suscipit. Donec ultricies efficitur tempus. Mauris vehicula arcu velit, vehicula pulvinar neque pulvinar vel. Quisque augue mi, suscipit sed mauris eu, ultricies laoreet arcu. Mauris commodo imperdiet interdum. Integer fringilla ut nisi et fermentum. Integer interdum ultrices vulputate. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum ante nunc, porttitor nec elementum in, rutrum eget libero. Vivamus vehicula quam vel lacus porttitor, vel luctus sem sagittis. Maecenas sit amet risus urna. Sed eu feugiat sem. Pellentesque quis nisl tincidunt, gravida mi laoreet, pharetra urna. Aliquam erat volutpat. Ut maximus libero ante, nec venenatis magna convallis eu.\r\n<h3>Sponsors</h3>\r\nUt vestibulum diam est. Suspendisse pellentesque diam neque, non iaculis leo efficitur vel. Nullam consequat fermentum lacus sed efficitur. In tristique vel tortor ut congue. In vehicula sem ac cursus lobortis. Mauris vestibulum id leo ut tristique. Sed a eleifend diam. Donec erat nibh, aliquet vel dictum dignissim, fermentum a nisi. Aenean hendrerit ligula nunc, quis semper dui ullamcorper sed. Suspendisse potenti. Fusce vitae dapibus mi.', 'Over ons', '', 'inherit', 'closed', 'closed', '', '132-revision-v1', '', '', '2017-08-17 13:23:59', '2017-08-17 11:23:59', '', '132', 'http://canon.bramperry.nl/132-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('201', '1', '2017-09-04 17:20:17', '2017-09-04 15:20:17', '', 'bloem', '', 'inherit', 'open', 'closed', '', 'bloem', '', '', '2017-09-06 21:15:10', '2017-09-06 19:15:10', '', '0', 'http://canon.bramperry.nl/wp-content/uploads/2017/09/bloem.jpeg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('202', '1', '2017-09-05 14:22:58', '2017-09-05 12:22:58', '<h3>De verovering van Curaçao</h3>\r\nCuraçao werd in 1634 door de West-Indische Compagnie (WIC) veroverd op de Spanjaarden.\r\n\r\nDe Republiek was op dat moment verwikkeld in de Tachtigjarige Oorlog (1568-1648) met Spanje en metPortugal. Deze landen waren sinds 1580 verenigd waren onder één staatshoofd, de Spaanse koning. De WIC was in 1621 opgericht om te dienen als een instrument in die oorlog. Behalve met de uitvoering van een ambitieus plan, het ‘groot desseyn’,dat gericht was op het veroveren van Portugese gebieden in Afrika en Brazilië, was de WIC vooral actief in de kaapvaart. Er bestond daarom behoefte aan een maritiem steunpunt in het operatiegebied van waaruit militaire acties konden worden ondernomen.Het strategisch gunstig gelegen Curaçao was daarvoor uitstekend geschikt. Het eiland was goed verdedigbaar en beschikte over een uitstekende natuurlijke haven, de Sint-Annabaai.\r\n\r\nEen expeditie onder leiding van Johannes van Walbeecken Pierre le Grand slaagde er vrij eenvoudig in om Curaçao te overmeesteren. De kleine Spaanse bezetting werd samen met het grootste deel van de inheemse bevolking gedeporteerd naar Venezuela. Daarna werd een begin gemaakt met het op orde brengen van de verdediging. Aan oostelijke zijde van de ingang van de Sint-Annabaai op een landtong die De Punt (Punda) werd genoemd werd een sterkte gebouwd, fort Amsterdam.\r\n<h3>Van oorlogsbasis naar vestigingskolonie</h3>\r\nGedurende de eerste jaren na de verovering verbleven er op Curaçao in hoofdzaak militairen. In 1635 waren slechts 20 van de 412 compagniesdienaren burgers. Er woonden verder zo’n 50 inheemse bewoners. Spoedig arriveerden ook Afrikaanse slaven. Deze waren aanvankelijk vooral afkomstig van veroverde vijandelijke schepen. Maar hun aantallen waren tot midden zeventiende eeuw nog gering.\r\n<ul>\r\n 	<li>bleep</li>\r\n 	<li>bloop</li>\r\n 	<li>blap</li>\r\n</ul>\r\n<ol>\r\n 	<li>yes</li>\r\n 	<li>no</li>\r\n 	<li>what?</li>\r\n</ol>\r\nVrijwel direct nadat bekend werd dat Curaçao was veroverd, ontstond er in het moederland belangstelling voor kolonisatieprojecten. Militairen en civiele beambten op het eiland, die hun contract hadden uitgediend, kregen ook de mogelijkheid om zich als landbouwer te vestigen. Maar dit leidde nauwelijks tot concrete resultaten.\r\n\r\nIn de jaren vijftig van zeventiende eeuw vestigden zich joodse kolonisten op het eiland. In 1665 woonden er, de inheemse bevolking niet meegerekend, zo’n 600 personen.Curaçao had inmiddels geen functie meer als oorlogsbasis, maar ontwikkelde zich nu, met de vanaf 1650 opkomende slavenhandel als motor, tot een commercieel centrum.Rond deze tijd ontstond ten noorden van fort Amsterdam een vestiging die uitgroeide tot een ommuurde stad, Willemstad. Het aantal plantages en tuinen groeide ook. Deze richtten zich vooral op de lokale voedselproductie.', '3. Verovering door de WIC en de komst van de Hollanders', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2017-09-05 14:22:58', '2017-09-05 12:22:58', '', '12', 'http://canon.bramperry.nl/12-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('208', '4', '2017-09-06 20:24:58', '2017-09-06 18:24:58', 'In 1912 had Shell een concessie verworven in het Mene Grande-veld, ten Oosten van het Meer van Maracaibo in Venezuela. Toen in 1914 duidelijk werd dat dit veld boordevol olie zat, had Shell al besloten om een kleine opslagplaats op Curaçao te bouwen. Een jaar later werd besloten er een raffinaderij te vestigen. De slechte bereikbaarheid van het Meer van Maracaibo en het stabiele bestuur van Curaçao, speelde een rol in deze keuze.\r\n\r\nIn de eerste jaren werd op Curaçao nog voor een groot deel olie uit Mexico verwerkt. Nadat Mexico in 1938 de olie industrie nationaliseerde, ging Shell exclusief Venezolaanse olie verwerken.\r\n\r\nTot het einde van 1920 waren er minder dan 300 mensen in dienst van de raffinaderij. Het zou uitgroeien tot 10.924 (inclusief de Curaçaosche Scheepvaart Maatschappij) in 1929. In die jaren werden arbeiders geworven uit de regio en uit Portugal. Al deze arbeiders werden in nieuwe wijken gehuisvest, niet ver van het raffinaderijcomplex. Daarbij werden ook allerlei voorzieningen gebouwd zoals wegen, scholen, winkels, buurtcentra, telefoon- en waterleidingen.\r\n\r\nDe economische crisis van de jaren dertig bracht het personeelsbestand drastisch terug en zou vanaf 1934 geleidelijk weer toenemen. Pas na 1945 kwam het personeelsaantal weer boven de 10.000 uit.\r\n\r\nIn de oorlogsjaren speelden de raffinaderijen op de Antillen een belangrijke rol voor de brandstofvoorziening van de Geallieerden. Duitsland zette vanaf februari 1942 duikboten in rond Curaçao en Aruba om deze brandstoftoevoer af te snijden. In de oorlogsjaren kreeg de raffinaderij toestemming een zogenaamd “asfalt-meer” aan te leggen vanwege het gebrek aan schepen om het te vervoeren.\r\n\r\nIn Venezuela werden de activiteiten op Curaçao en Aruba met jaloezie en afgunst bekeken. Na 1935 was het sentiment gekeerd tegen de “uitverkoop van nationale rijkdom”. In 1943 werd daarom wetgeving aangenomen waardoor de Antilliaanse raffinaderijen geen olie uit nieuwe concessies mochten verwerken. Shell werd gedwongen te investeren in een nieuwe raffinaderij in Venezuela. Dat werd de raffinaderij van Cardón, die in 1947 opstartte.\r\n\r\nZo werd Shell in de jaren vijftig gedwongen haar raffinaderij op Curaçao af te slanken. In 1959 speelde ook de Amerikaanse import restricties op olieproducten de kop op. Op verzoek van m.n. de Texaanse olieproducenten ging Amerika over op importquota.\r\n\r\nIn de jaren zestig werd het systeem van “onderaannemers” ingevoerd waarbij arbeiders via externe bedrijven werden ingehuurd. Doordat de onderaannemers minder betaalden dan Shell, leidde dit tot een uitbarsting die bekend werd onder de naam “30 mei 1969”.', '21. De komst van het olie-industrietje', '', 'inherit', 'closed', 'closed', '', '47-revision-v1', '', '', '2017-09-06 20:24:58', '2017-09-06 18:24:58', '', '47', 'http://canon.bramperry.nl/47-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('209', '7', '2017-09-06 20:25:00', '2017-09-06 18:25:00', 'Sed accumsan quam suscipit finibus molestie. In sollicitudin augue vitae tellus efficitur mollis. Vivamus vel vulputate tortor. Cras ac massa ex. Pellentesque sit amet massa sed ante consequat condimentum nec laoreet risus. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum in massa vel ex sodales semper in ac urna. Nullam at pulvinar ligula. Integer commodo felis et purus vestibulum, id porta nibh sollicitudin.\r\n\r\nFusce efficitur ac est sit amet ultricies. Maecenas gravida, arcu pellentesque congue tempus, nunc lacus gravida libero, in vestibulum purus tortor vitae elit. Nullam sit amet risus at turpis faucibus scelerisque et dapibus ante. Suspendisse non dolor mattis, finibus diam et, varius est. Curabitur suscipit tincidunt leo vel tristique. Phasellus molestie consectetur orci, eget maximus lorem malesuada ut. Nulla laoreet mattis pretium. Vestibulum placerat eu dolor laoreet accumsan. Ut varius purus in orci tempor vulputate. Curabitur consectetur tellus orci, at finibus enim pharetra sit amet. Vestibulum ligula purus, sodales lacinia magna in, aliquam ultrices ipsum.', '2. De Spaanse periode ??', '', 'inherit', 'closed', 'closed', '', '10-revision-v1', '', '', '2017-09-06 20:25:00', '2017-09-06 18:25:00', '', '10', 'http://canon.bramperry.nl/10-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('210', '8', '2017-09-06 20:25:22', '2017-09-06 18:25:22', 'Fusce nunc risus, varius ut ligula id, varius malesuada lectus. Nulla tincidunt magna id molestie blandit. Nullam non erat dictum arcu imperdiet viverra. Sed eleifend risus felis, nec blandit quam efficitur sed. Phasellus fermentum tortor augue, sit amet interdum turpis congue quis. Aliquam vulputate lacus purus, et tincidunt diam euismod a. Morbi dui nisi, suscipit id nisi quis, ultricies volutpat velit. Integer vehicula lacinia porta. Vestibulum pellentesque nec enim in suscipit. Ut auctor, neque nec porttitor facilisis, mauris est tincidunt nisi, non rhoncus urna turpis ac eros. Proin massa purus, lacinia vitae metus ac, pulvinar ultricies nibh. Morbi dictum sapien mauris. Quisque sapien odio, mollis rutrum volutpat sit amet, fringilla vitae ante.\r\n\r\nNulla sodales vestibulum porttitor. Pellentesque lacinia id purus non accumsan. Mauris pharetra eros sit amet elementum pretium. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum luctus fringilla mauris, sit amet tristique nisi dignissim tincidunt. Suspendisse vel tincidunt urna, ac pulvinar nisl. Cras tempor, felis vitae porttitor scelerisque, ante ex commodo est, in vestibulum dolor eros nec dui. Pellentesque accumsan nulla a leo congue, eget vestibulum purus laoreet. Sed vulputate vehicula felis, vitae interdum tortor vehicula sit amet. Nulla eu tincidunt mi.', '1. De oorspronkelijke bewoners', '', 'inherit', 'closed', 'closed', '', '8-revision-v1', '', '', '2017-09-06 20:25:22', '2017-09-06 18:25:22', '', '8', 'http://canon.bramperry.nl/8-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('211', '7', '2017-09-06 20:56:58', '2017-09-06 18:56:58', '16 Gebouwen\n\nFort Amsterdam is het oudste gebouw op Curaçao. <a href=\"http://canoncuracao.cw/1-de-oorspronkelijke-bewoners/\">Het </a>werd in 1635, een jaar nadat de West- Indische Compagnie het eiland op de Spanjaarden had veroverd, gebouwd op de oostelijke oever van de Sint Annabaai. Dit betekent dat op Curaçao geen bouwwerken bewaard zijn gebleven uit de Spaanse periode (1499-1634) en evenmin uit de precolumbiaanse tijd.\n\nAan de noordzijde van Fort Amsterdam ontstond in de loop van de 17<sup>e</sup> eeuw een kleine nederzetting die ‘De Willemstad’ werd genoemd. De eerste huizen die hier werden gebouwd zijn beïnvloed door de architectuur uit Amsterdam. Kenmerkend zijn de hoge smalle voorgevels en de diepe zijgevels. De voorgevels zijn voorzien van tuitgevels waarop een rechthoekig lijstwerk is geplaatst met daarop een klein fronton. Deze eerste bouwstijl uit de zeventiende eeuw, die de Curaçaos-Hollandse stijl wordt genoemd, werd niet alleen toegepast in Willemstad maar ook bij de huizen op de plantages, de landhuizen.\n\nEen kenmerkend onderdeel van de traditionele architectuur op Curaçao zijn de galerijen. Dit waren aanvankelijk open houten of stenen constructies die tegen de voorgevels van de huizen in de stad werden geplaatst om de zon te weren. Later werden galerijen een structureel onderdeel van gebouwen zowel binnen als buiten de stad.\n\nIn de achttiende eeuw kwam de Curaçaose Barok in de mode met zijn sierlijke gebogen gevellijnen en arcades. Deze uitbundige bouwstijl werd in de eerste helft van de 19<sup>e</sup> eeuw afgewisseld door een sobere bouwstijl die weer teruggreep op de tuitgevel uit de 17<sup>e</sup> eeuw. De afmeting en detaillering was echter eenvoudiger geworden en kan daarom onderscheiden worden van de oudere stijl.\n\nDoor invloeden vanuit Nederland en de VS ontwikkelde zich in de tweede helft van de negentiende eeuw het ‘neoclassicisme’, een bouwstijl die gebaseerd was op de architectuur van de Grieken en Romeinen. De meest kenmerkende elementen van deze stijl waren de toepassing van zuilen en frontons (driehoeken). Het classicisme werd gebruikt voor zowel stadsvilla’s als eenvoudige woonhuizen en eveneens voor landhuizen.\n\nIn de eerste helft van de twintigste eeuw kwam Curaçao in contact met de internationale bouwstijl, die ook wel het ‘nieuwe bouwen’ wordt genoemd. Ook in deze periode zijn er duidelijke invloeden in de bouwkunst waar te nemen uit zowel Europa als de VS. Zo is bijvoorbeeld de voorgevel van de voormalige bioscoop Cinelandia geïnspireerd door de Art Deco architectuur in Miami en het voormalige KNSM-gebouw door de architectuur van de Nederlandse architect Dudoc.\n\nDe gebouwen op Curaçao hebben een Caraïbisch karakter gekregen door de invloeden van een multiculturele samenleving en het klimaat. De opvallende bonte kleuren op de gevels gaan terug op een verordening uit 1817, toen gouverneur Kikkert de eigenaren verplichte om de wit gekalkte voorgevels in binnenstad een kleur te geven.\n\nNB vragen of Gerda een alinea kan toevoegen over de huizen van het ‘gewone volk’, zoals knoekhuizen, houten huizen, huizen van blik.\n\n&nbsp;\n\n&nbsp;\n\n&nbsp;\n\nDe Spaanse periode  Sed accumsan quam suscipit finibus molestie. In sollicitudin augue vitae tellus efficitur mollis. Vivamus vel vulputate tortor. Cras ac massa ex. Pellentesque sit amet massa sed ante consequat condimentum nec laoreet risus. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum in massa vel ex sodales semper in ac urna. Nullam at pulvinar ligula. Integer commodo felis et purus vestibulum, id porta nibh sollicitudin.\n\nFusce efficitur ac est sit amet ultricies. Maecenas gravida, arcu pellentesque congue tempus, nunc lacus gravida libero, in vestibulum purus tortor vitae elit. Nullam sit amet risus at turpis faucibus scelerisque et dapibus ante. Suspendisse non dolor mattis, finibus diam et, varius est. Curabitur suscipit tincidunt leo vel tristique. Phasellus molestie consectetur orci, eget maximus lorem malesuada ut. Nulla laoreet mattis pretium. Vestibulum placerat eu dolor laoreet accumsan. Ut varius purus in orci tempor vulputate. Curabitur consectetur tellus orci, at finibus enim pharetra sit amet. Vestibulum ligula purus, sodales lacinia magna in, aliquam ultrices ipsum.', '2. De Spaanse periode ??', '', 'inherit', 'closed', 'closed', '', '10-autosave-v1', '', '', '2017-09-06 20:56:58', '2017-09-06 18:56:58', '', '10', 'http://canon.bramperry.nl/10-autosave-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('212', '7', '2017-09-06 20:28:18', '2017-09-06 18:28:18', 'De Spaanse periode  Sed accumsan quam suscipit finibus molestie. In sollicitudin augue vitae tellus efficitur mollis. Vivamus vel vulputate tortor. Cras ac massa ex. Pellentesque sit amet massa sed ante consequat condimentum nec laoreet risus. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum in massa vel ex sodales semper in ac urna. Nullam at pulvinar ligula. Integer commodo felis et purus vestibulum, id porta nibh sollicitudin.\r\n\r\nFusce efficitur ac est sit amet ultricies. Maecenas gravida, arcu pellentesque congue tempus, nunc lacus gravida libero, in vestibulum purus tortor vitae elit. Nullam sit amet risus at turpis faucibus scelerisque et dapibus ante. Suspendisse non dolor mattis, finibus diam et, varius est. Curabitur suscipit tincidunt leo vel tristique. Phasellus molestie consectetur orci, eget maximus lorem malesuada ut. Nulla laoreet mattis pretium. Vestibulum placerat eu dolor laoreet accumsan. Ut varius purus in orci tempor vulputate. Curabitur consectetur tellus orci, at finibus enim pharetra sit amet. Vestibulum ligula purus, sodales lacinia magna in, aliquam ultrices ipsum.', '2. De Spaanse periode ??', '', 'inherit', 'closed', 'closed', '', '10-revision-v1', '', '', '2017-09-06 20:28:18', '2017-09-06 18:28:18', '', '10', 'http://canon.bramperry.nl/10-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('213', '4', '2017-09-06 20:28:49', '2017-09-06 18:28:49', 'In 1912 had Shell een concessie verworven in het Mene Grande-veld, ten Oosten van het Meer van Maracaibo in Venezuela. Toen in 1914 duidelijk werd dat dit veld boordevol olie zat, had Shell al besloten om een kleine opslagplaats op Curaçao te bouwen. Een jaar later werd besloten er een raffinaderij te vestigen. De slechte bereikbaarheid van het Meer van Maracaibo en het stabiele bestuur van Curaçao, speelde een rol in deze keuze.\r\n\r\nIn de eerste jaren werd op Curaçao nog voor een groot deel olie uit Mexico verwerkt. Nadat Mexico in 1938 de olie industrie nationaliseerde, ging Shell exclusief Venezolaanse olie verwerken.\r\n\r\nTot het einde van 1920 waren er minder dan 300 mensen in dienst van de raffinaderij. Het zou uitgroeien tot 10.924 (inclusief de Curaçaosche Scheepvaart Maatschappij) in 1929. In die jaren werden arbeiders geworven uit de regio en uit Portugal. Al deze arbeiders werden in nieuwe wijken gehuisvest, niet ver van het raffinaderijcomplex. Daarbij werden ook allerlei voorzieningen gebouwd zoals wegen, scholen, winkels, buurtcentra, telefoon- en waterleidingen.\r\n\r\nDe economische crisis van de jaren dertig bracht het personeelsbestand drastisch terug en zou vanaf 1934 geleidelijk weer toenemen. Pas na 1945 kwam het personeelsaantal weer boven de 10.000 uit.\r\n\r\nIn de oorlogsjaren speelden de raffinaderijen op de Antillen een belangrijke rol voor de brandstofvoorziening van de Geallieerden. Duitsland zette vanaf februari 1942 duikboten in rond Curaçao en Aruba om deze brandstoftoevoer af te snijden. In de oorlogsjaren kreeg de raffinaderij toestemming een zogenaamd “asfalt-meer” aan te leggen vanwege het gebrek aan schepen om het te vervoeren.\r\n\r\nIn Venezuela werden de activiteiten op Curaçao en Aruba met jaloezie en afgunst bekeken. Na 1935 was het sentiment gekeerd tegen de “uitverkoop van nationale rijkdom”. In 1943 werd daarom wetgeving aangenomen waardoor de Antilliaanse raffinaderijen geen olie uit nieuwe concessies mochten verwerken. Shell werd gedwongen te investeren in een nieuwe raffinaderij in Venezuela. Dat werd de raffinaderij van Cardón, die in 1947 opstartte.\r\n\r\nZo werd Shell in de jaren vijftig gedwongen haar raffinaderij op Curaçao af te slanken. In 1959 speelde ook de Amerikaanse import restricties op olieproducten de kop op. Op verzoek van m.n. de Texaanse olieproducenten ging Amerika over op importquota.\r\n\r\nIn de jaren zestig werd het systeem van “onderaannemers” ingevoerd waarbij arbeiders via externe bedrijven werden ingehuurd. Doordat de onderaannemers minder betaalden dan Shell, leidde dit tot een uitbarsting die bekend werd onder de naam “30 mei 1969”.', '21. De komst van de olie-industrie', '', 'inherit', 'closed', 'closed', '', '47-revision-v1', '', '', '2017-09-06 20:28:49', '2017-09-06 18:28:49', '', '47', 'http://canon.bramperry.nl/47-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('215', '5', '2017-09-06 20:30:01', '2017-09-06 18:30:01', 'Tot de komst van de Westindische Compagnie in 1634 werden de Benedenwindse Eilanden bewoond door clans van de Caiquetios, die na 1499 werden bestuurd door Spanjaarden. Johan van Walbeeck verwijderde alle Spanjaarden en een groot gedeelte van de Caiquetios van de eilanden. Daarmee zijn deze in feite vrijwel zonder inwoners. De komst van de WIC zorgt ervoor dat de bevolking in de eerste Nederlandse jaren voornamelijk uit Europese mannen bestaat. Dat leidt tot een nogal woeste samenleving, waar de dominee regelmatig over klaagt. De opeenvolgende Directeuren van de WIC vragen de WIC regelmatig om ‘nette’ vrouwen te sturen, maar er is nog weinig aantrekkelijks voor deze vrouwen om naar Curaçao te komen. Pas als Peter Stuyvesant en zijn opvolger Mathias Beck het Directeurschap op zich nemen rond 1645, let men meer op de leefomstandigheden op de eilanden. Vooral de zorgelijke voedselsituatie krijgt aandacht: de WIC is een bedrijf dat winst moet maken, dan is de noodzaak om voedsel te importeren een kostbare zaak. Daarom nodigt Stuyvesant tijdens zijn bewind Sefardische joden, die uit Spanje en Portugal naar Nederland waren gevlucht voor de Inquisitie, uit om plantages te starten op de eilanden, zodat hiermee lokaal voldoende voedsel kon worden geproduceerd. Ook verandert de manier waarop de compagnie Curaçao wil gebruiken: was eerst de Kaapvaart het argument om de Benedenwindse Eilanden in bezit te nemen, in de praktijk blijkt dat die te weinig oplevert. Maar, de in Brazilië opgedane kennis over de Transatlantische Slavenhandel zorgt ervoor dat de WIC zich realiseert dat Curaçao ideaal is als regionale slavenmarkt. Dit leidt tot vier groepen bewoners: het restantCaiquetios (vooral op Aruba), de Europeanen, de Sefardische Joden en de tot slaaf gemaakte Afrikanen vormen vanaf de tweede helft van de zeventiende eeuw de bevolking. Deze samenleving ontwikkelt een manier van omgaan en indeling die lijkt op die van de standensamenleving in Europa: de gesegmenteerde maatschappij. Een segment is een groep mensen die daartoe behoren door geboorte, afkomst, huidskleur en geloof, waarbij het wisselen van segment vrijwel onmogelijk is. Tevens hebben de leden van sommige segmenten meer rechten dan anderen. De indeling loopt van de hoge blanke protestant, zoals de kooplieden en hoge WIC-ambtenaren met veel rechten tot de tot slaaf gemaakt Afrikanen die geen enkel recht hebben. Daartussen bewegen zich de andere groepen, zoals de Sefardische Joden, lage blanke protestanten en de kleurlingen, de laatste groep het gevolg van relaties tussen Europeanen en Afrikanen.', '4. Nieuwe bewoners in de zeventiende eeuw TEST', '', 'inherit', 'closed', 'closed', '', '4-revision-v1', '', '', '2017-09-06 20:30:01', '2017-09-06 18:30:01', '', '4', 'http://canon.bramperry.nl/4-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('216', '5', '2017-09-06 20:30:29', '2017-09-06 18:30:29', 'Tot de komst van de Westindische Compagnie in 1634 werden de Benedenwindse Eilanden bewoond door clans van de Caiquetios, die na 1499 werden bestuurd door Spanjaarden. Johan van Walbeeck verwijderde alle Spanjaarden en een groot gedeelte van de Caiquetios van de eilanden. Daarmee zijn deze in feite vrijwel zonder inwoners. De komst van de WIC zorgt ervoor dat de bevolking in de eerste Nederlandse jaren voornamelijk uit Europese mannen bestaat. Dat leidt tot een nogal woeste samenleving, waar de dominee regelmatig over klaagt. De opeenvolgende Directeuren van de WIC vragen de WIC regelmatig om ‘nette’ vrouwen te sturen, maar er is nog weinig aantrekkelijks voor deze vrouwen om naar Curaçao te komen. Pas als Peter Stuyvesant en zijn opvolger Mathias Beck het Directeurschap op zich nemen rond 1645, let men meer op de leefomstandigheden op de eilanden. Vooral de zorgelijke voedselsituatie krijgt aandacht: de WIC is een bedrijf dat winst moet maken, dan is de noodzaak om voedsel te importeren een kostbare zaak. Daarom nodigt Stuyvesant tijdens zijn bewind Sefardische joden, die uit Spanje en Portugal naar Nederland waren gevlucht voor de Inquisitie, uit om plantages te starten op de eilanden, zodat hiermee lokaal voldoende voedsel kon worden geproduceerd. Ook verandert de manier waarop de compagnie Curaçao wil gebruiken: was eerst de Kaapvaart het argument om de Benedenwindse Eilanden in bezit te nemen, in de praktijk blijkt dat die te weinig oplevert. Maar, de in Brazilië opgedane kennis over de Transatlantische Slavenhandel zorgt ervoor dat de WIC zich realiseert dat Curaçao ideaal is als regionale slavenmarkt. Dit leidt tot vier groepen bewoners: het restantCaiquetios (vooral op Aruba), de Europeanen, de Sefardische Joden en de tot slaaf gemaakte Afrikanen vormen vanaf de tweede helft van de zeventiende eeuw de bevolking. Deze samenleving ontwikkelt een manier van omgaan en indeling die lijkt op die van de standensamenleving in Europa: de gesegmenteerde maatschappij. Een segment is een groep mensen die daartoe behoren door geboorte, afkomst, huidskleur en geloof, waarbij het wisselen van segment vrijwel onmogelijk is. Tevens hebben de leden van sommige segmenten meer rechten dan anderen. De indeling loopt van de hoge blanke protestant, zoals de kooplieden en hoge WIC-ambtenaren met veel rechten tot de tot slaaf gemaakt Afrikanen die geen enkel recht hebben. Daartussen bewegen zich de andere groepen, zoals de Sefardische Joden, lage blanke protestanten en de kleurlingen, de laatste groep het gevolg van relaties tussen Europeanen en Afrikanen.', '4. Nieuwe bewoners in de zeventiende eeuw', '', 'inherit', 'closed', 'closed', '', '4-revision-v1', '', '', '2017-09-06 20:30:29', '2017-09-06 18:30:29', '', '4', 'http://canon.bramperry.nl/4-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('221', '8', '2017-09-06 20:41:37', '2017-09-06 18:41:37', '', 'Penguins', '', 'inherit', 'open', 'closed', '', 'penguins', '', '', '2017-09-06 20:46:59', '2017-09-06 18:46:59', '', '8', 'http://canon.bramperry.nl/wp-content/uploads/2017/05/Penguins.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('222', '4', '2017-09-06 20:42:02', '2017-09-06 18:42:02', 'In 1912 had Shell een concessie verworven in het Mene Grande-veld, ten Oosten van het Meer van Maracaibo in Venezuela. Toen in 1914 duidelijk werd dat dit veld boordevol olie zat, had Shell al besloten om een kleine opslagplaats op Curaçao te bouwen. Een jaar later werd besloten er een raffinaderij te vestigen. De slechte bereikbaarheid van het Meer van Maracaibo en het stabiele bestuur van Curaçao, speelde een rol in deze keuze.\r\n\r\nIn de eerste jaren werd op Curaçao nog voor een groot deel olie uit Mexico verwerkt. Nadat Mexico in 1938 de olie industrie nationaliseerde, ging Shell exclusief Venezolaanse olie verwerken.\r\n\r\nTot het einde van 1920 waren er minder dan 300 mensen in dienst van de raffinaderij. Het zou uitgroeien tot 10.924 (inclusief de Curaçaosche Scheepvaart Maatschappij) in 1929. In die jaren werden arbeiders geworven uit de regio en uit Portugal. Al deze arbeiders werden in nieuwe wijken gehuisvest, niet ver van het raffinaderijcomplex. Daarbij werden ook allerlei voorzieningen gebouwd zoals wegen, scholen, winkels, buurtcentra, telefoon- en waterleidingen.\r\n\r\nDe economische crisis van de jaren dertig bracht het personeelsbestand drastisch terug en zou vanaf 1934 geleidelijk weer toenemen. Pas na 1945 kwam het personeelsaantal weer boven de 10.000 uit.\r\n\r\nIn de oorlogsjaren speelden de raffinaderijen op de Antillen een belangrijke rol voor de brandstofvoorziening van de Geallieerden. Duitsland zette vanaf februari 1942 duikboten in rond Curaçao en Aruba om deze brandstoftoevoer af te snijden. In de oorlogsjaren kreeg de raffinaderij toestemming een zogenaamd “asfalt-meer” aan te leggen vanwege het gebrek aan schepen om het te vervoeren.\r\n\r\nIn Venezuela werden de activiteiten op Curaçao en Aruba met jaloezie en afgunst bekeken. Na 1935 was het sentiment gekeerd tegen de “uitverkoop van nationale rijkdom”. In 1943 werd daarom wetgeving aangenomen waardoor de Antilliaanse raffinaderijen geen olie uit nieuwe concessies mochten verwerken. Shell werd gedwongen te investeren in een nieuwe raffinaderij in Venezuela. Dat werd de raffinaderij van Cardón, die in 1947 opstartte.\r\n\r\nZo werd Shell in de jaren vijftig gedwongen haar raffinaderij op Curaçao af te slanken. In 1959 speelde ook de Amerikaanse import restricties op olieproducten de kop op. Op verzoek van m.n. de Texaanse olieproducenten ging Amerika over op importquota.\r\n\r\nIn de jaren zestig werd het systeem van “onderaannemers” ingevoerd waarbij arbeiders via externe bedrijven werden ingehuurd. Doordat de onderaannemers minder betaalden dan Shell, leidde dit tot een uitbarsting die bekend werd onder de naam “30 mei 1969”.', '21. De komst van de olie-industrie', '', 'inherit', 'closed', 'closed', '', '47-revision-v1', '', '', '2017-09-06 20:42:02', '2017-09-06 18:42:02', '', '47', 'http://canon.bramperry.nl/47-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('223', '8', '2017-09-06 20:42:15', '2017-09-06 18:42:15', 'Fusce nunc risus, varius ut ligula id, varius malesuada lectus. Nulla tincidunt magna id molestie blandit. Nullam non erat dictum arcu imperdiet viverra. Sed eleifend risus felis, nec blandit quam efficitur sed. Phasellus fermentum tortor augue, sit amet interdum turpis congue quis. Aliquam vulputate lacus purus, et tincidunt diam euismod a. Morbi dui nisi, suscipit id nisi quis, ultricies volutpat velit. Integer vehicula lacinia porta. Vestibulum pellentesque nec enim in suscipit. Ut auctor, neque nec porttitor facilisis, mauris est tincidunt nisi, non rhoncus urna turpis ac eros. Proin massa purus, lacinia vitae metus ac, pulvinar ultricies nibh. Morbi dictum sapien mauris. Quisque sapien odio, mollis rutrum volutpat sit amet, fringilla vitae ante.\r\n\r\nNulla sodales vestibulum porttitor. Pellentesque lacinia id purus non accumsan. Mauris pharetra eros sit amet elementum pretium. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum luctus fringilla mauris, sit amet tristique nisi dignissim tincidunt. Suspendisse vel tincidunt urna, ac pulvinar nisl. Cras tempor, felis vitae porttitor scelerisque, ante ex commodo est, in vestibulum dolor eros nec dui. Pellentesque accumsan nulla a leo congue, eget vestibulum purus laoreet. Sed vulputate vehicula felis, vitae interdum tortor vehicula sit amet. Nulla eu tincidunt mi.', '1. De oorspronkelijke bewoners', '', 'inherit', 'closed', 'closed', '', '8-revision-v1', '', '', '2017-09-06 20:42:15', '2017-09-06 18:42:15', '', '8', 'http://canon.bramperry.nl/8-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('224', '7', '2017-09-06 20:43:31', '2017-09-06 18:43:31', '', 'Blue hills', '', 'inherit', 'open', 'closed', '', 'blue-hills', '', '', '2017-09-06 20:43:45', '2017-09-06 18:43:45', '', '10', 'http://canon.bramperry.nl/wp-content/uploads/2017/05/Blue-hills.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('225', '7', '2017-09-06 20:44:00', '2017-09-06 18:44:00', 'De Spaanse periode  Sed accumsan quam suscipit finibus molestie. In sollicitudin augue vitae tellus efficitur mollis. Vivamus vel vulputate tortor. Cras ac massa ex. Pellentesque sit amet massa sed ante consequat condimentum nec laoreet risus. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum in massa vel ex sodales semper in ac urna. Nullam at pulvinar ligula. Integer commodo felis et purus vestibulum, id porta nibh sollicitudin.\r\n\r\nFusce efficitur ac est sit amet ultricies. Maecenas gravida, arcu pellentesque congue tempus, nunc lacus gravida libero, in vestibulum purus tortor vitae elit. Nullam sit amet risus at turpis faucibus scelerisque et dapibus ante. Suspendisse non dolor mattis, finibus diam et, varius est. Curabitur suscipit tincidunt leo vel tristique. Phasellus molestie consectetur orci, eget maximus lorem malesuada ut. Nulla laoreet mattis pretium. Vestibulum placerat eu dolor laoreet accumsan. Ut varius purus in orci tempor vulputate. Curabitur consectetur tellus orci, at finibus enim pharetra sit amet. Vestibulum ligula purus, sodales lacinia magna in, aliquam ultrices ipsum.', '2. De Spaanse periode ??', '', 'inherit', 'closed', 'closed', '', '10-revision-v1', '', '', '2017-09-06 20:44:00', '2017-09-06 18:44:00', '', '10', 'http://canon.bramperry.nl/10-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('226', '4', '2017-09-06 20:45:01', '2017-09-06 18:45:01', 'In 1912 had Shell een concessie verworven in het Mene Grande-veld, ten Oosten van het Meer van Maracaibo in Venezuela. Toen in 1914 duidelijk werd dat dit veld boordevol olie zat, had Shell al besloten om een kleine opslagplaats op Curaçao te bouwen. Een jaar later werd besloten er een raffinaderij te vestigen. De slechte bereikbaarheid van het Meer van Maracaibo en het stabiele bestuur van Curaçao, speelde een rol in deze keuze.\r\n\r\nIn de eerste jaren werd op Curaçao nog voor een groot deel olie uit Mexico verwerkt. Nadat Mexico in 1938 de olie industrie nationaliseerde, ging Shell exclusief Venezolaanse olie verwerken.\r\n\r\nTot het einde van 1920 waren er minder dan 300 mensen in dienst van de raffinaderij. Het zou uitgroeien tot 10.924 (inclusief de Curaçaosche Scheepvaart Maatschappij) in 1929. In die jaren werden arbeiders geworven uit de regio en uit Portugal. Al deze arbeiders werden in nieuwe wijken gehuisvest, niet ver van het raffinaderijcomplex. Daarbij werden ook allerlei voorzieningen gebouwd zoals wegen, scholen, winkels, buurtcentra, telefoon- en waterleidingen.\r\n\r\nDe economische crisis van de jaren dertig bracht het personeelsbestand drastisch terug en zou vanaf 1934 geleidelijk weer toenemen. Pas na 1945 kwam het personeelsaantal weer boven de 10.000 uit.\r\n\r\nIn de oorlogsjaren speelden de raffinaderijen op de Antillen een belangrijke rol voor de brandstofvoorziening van de Geallieerden. Duitsland zette vanaf februari 1942 duikboten in rond Curaçao en Aruba om deze brandstoftoevoer af te snijden. In de oorlogsjaren kreeg de raffinaderij toestemming een zogenaamd “asfalt-meer” aan te leggen vanwege het gebrek aan schepen om het te vervoeren.\r\n\r\nIn Venezuela werden de activiteiten op Curaçao en Aruba met jaloezie en afgunst bekeken. Na 1935 was het sentiment gekeerd tegen de “uitverkoop van nationale rijkdom”. In 1943 werd daarom wetgeving aangenomen waardoor de Antilliaanse raffinaderijen geen olie uit nieuwe concessies mochten verwerken. Shell werd gedwongen te investeren in een nieuwe raffinaderij in Venezuela. Dat werd de raffinaderij van Cardón, die in 1947 opstartte.\r\n\r\nZo werd Shell in de jaren vijftig gedwongen haar raffinaderij op Curaçao af te slanken. In 1959 speelde ook de Amerikaanse import restricties op olieproducten de kop op. Op verzoek van m.n. de Texaanse olieproducenten ging Amerika over op importquota.\r\n\r\nIn de jaren zestig werd het systeem van “onderaannemers” ingevoerd waarbij arbeiders via externe bedrijven werden ingehuurd. Doordat de onderaannemers minder betaalden dan Shell, leidde dit tot een uitbarsting die bekend werd onder de naam “30 mei 1969”.', '21. De komst van de olie-industrie', '', 'inherit', 'closed', 'closed', '', '47-revision-v1', '', '', '2017-09-06 20:45:01', '2017-09-06 18:45:01', '', '47', 'http://canon.bramperry.nl/47-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('227', '8', '2017-09-06 20:47:16', '2017-09-06 18:47:16', 'Fusce nunc risus, varius ut ligula id, varius malesuada lectus. Nulla tincidunt magna id molestie blandit. Nullam non erat dictum arcu imperdiet viverra. Sed eleifend risus felis, nec blandit quam efficitur sed. Phasellus fermentum tortor augue, sit amet interdum turpis congue quis. Aliquam vulputate lacus purus, et tincidunt diam euismod a. Morbi dui nisi, suscipit id nisi quis, ultricies volutpat velit. Integer vehicula lacinia porta. Vestibulum pellentesque nec enim in suscipit. Ut auctor, neque nec porttitor facilisis, mauris est tincidunt nisi, non rhoncus urna turpis ac eros. Proin massa purus, lacinia vitae metus ac, pulvinar ultricies nibh. Morbi dictum sapien mauris. Quisque sapien odio, mollis rutrum volutpat sit amet, fringilla vitae ante.\r\n\r\nNulla sodales vestibulum porttitor. Pellentesque lacinia id purus non accumsan. Mauris pharetra eros sit amet elementum pretium. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum luctus fringilla mauris, sit amet tristique nisi dignissim tincidunt. Suspendisse vel tincidunt urna, ac pulvinar nisl. Cras tempor, felis vitae porttitor scelerisque, ante ex commodo est, in vestibulum dolor eros nec dui. Pellentesque accumsan nulla a leo congue, eget vestibulum purus laoreet. Sed vulputate vehicula felis, vitae interdum tortor vehicula sit amet. Nulla eu tincidunt mi.', '1. De oorspronkelijke bewoners', '', 'inherit', 'closed', 'closed', '', '8-revision-v1', '', '', '2017-09-06 20:47:16', '2017-09-06 18:47:16', '', '8', 'http://canon.bramperry.nl/8-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('228', '7', '2017-09-06 20:50:04', '2017-09-06 18:50:04', 'De Spaanse periode  Sed accumsan quam suscipit finibus molestie. In sollicitudin augue vitae tellus efficitur mollis. Vivamus vel vulputate tortor. Cras ac massa ex. Pellentesque sit amet massa sed ante consequat condimentum nec laoreet risus. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum in massa vel ex sodales semper in ac urna. Nullam at pulvinar ligula. Integer commodo felis et purus vestibulum, id porta nibh sollicitudin.\r\n\r\nFusce efficitur ac est sit amet ultricies. Maecenas gravida, arcu pellentesque congue tempus, nunc lacus gravida libero, in vestibulum purus tortor vitae elit. Nullam sit amet risus at turpis faucibus scelerisque et dapibus ante. Suspendisse non dolor mattis, finibus diam et, varius est. Curabitur suscipit tincidunt leo vel tristique. Phasellus molestie consectetur orci, eget maximus lorem malesuada ut. Nulla laoreet mattis pretium. Vestibulum placerat eu dolor laoreet accumsan. Ut varius purus in orci tempor vulputate. Curabitur consectetur tellus orci, at finibus enim pharetra sit amet. Vestibulum ligula purus, sodales lacinia magna in, aliquam ultrices ipsum.', '2. De Spaanse periode ??', '', 'inherit', 'closed', 'closed', '', '10-revision-v1', '', '', '2017-09-06 20:50:04', '2017-09-06 18:50:04', '', '10', 'http://canon.bramperry.nl/10-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('229', '4', '2017-09-06 20:50:38', '2017-09-06 18:50:38', 'In 1912 had Shell een concessie verworven in het Mene Grande-veld, ten Oosten van het Meer van Maracaibo in Venezuela. Toen in 1914 duidelijk werd dat dit veld boordevol olie zat, had Shell al besloten om een kleine opslagplaats op Curaçao te bouwen. Een jaar later werd besloten er een raffinaderij te vestigen. De slechte bereikbaarheid van het Meer van Maracaibo en het stabiele bestuur van Curaçao, speelde een rol in deze keuze.\r\n\r\nIn de eerste jaren werd op Curaçao nog voor een groot deel olie uit Mexico verwerkt. Nadat Mexico in 1938 de olie industrie nationaliseerde, ging Shell exclusief Venezolaanse olie verwerken.\r\n\r\nTot het einde van 1920 waren er minder dan 300 mensen in dienst van de raffinaderij. Het zou uitgroeien tot 10.924 (inclusief de Curaçaosche Scheepvaart Maatschappij) in 1929. In die jaren werden arbeiders geworven uit de regio en uit Portugal. Al deze arbeiders werden in nieuwe wijken gehuisvest, niet ver van het raffinaderijcomplex. Daarbij werden ook allerlei voorzieningen gebouwd zoals wegen, scholen, winkels, buurtcentra, telefoon- en waterleidingen.\r\n\r\nDe economische crisis van de jaren dertig bracht het personeelsbestand drastisch terug en zou vanaf 1934 geleidelijk weer toenemen. Pas na 1945 kwam het personeelsaantal weer boven de 10.000 uit.\r\n\r\nIn de oorlogsjaren speelden de raffinaderijen op de Antillen een belangrijke rol voor de brandstofvoorziening van de Geallieerden. Duitsland zette vanaf februari 1942 duikboten in rond Curaçao en Aruba om deze brandstoftoevoer af te snijden. In de oorlogsjaren kreeg de raffinaderij toestemming een zogenaamd “asfalt-meer” aan te leggen vanwege het gebrek aan schepen om het te vervoeren.\r\n\r\nIn Venezuela werden de activiteiten op Curaçao en Aruba met jaloezie en afgunst bekeken. Na 1935 was het sentiment gekeerd tegen de “uitverkoop van nationale rijkdom”. In 1943 werd daarom wetgeving aangenomen waardoor de Antilliaanse raffinaderijen geen olie uit nieuwe concessies mochten verwerken. Shell werd gedwongen te investeren in een nieuwe raffinaderij in Venezuela. Dat werd de raffinaderij van Cardón, die in 1947 opstartte.\r\n\r\nZo werd Shell in de jaren vijftig gedwongen haar raffinaderij op Curaçao af te slanken. In 1959 speelde ook de Amerikaanse import restricties op olieproducten de kop op. Op verzoek van m.n. de Texaanse olieproducenten ging Amerika over op importquota.\r\n\r\nIn de jaren zestig werd het systeem van “onderaannemers” ingevoerd waarbij arbeiders via externe bedrijven werden ingehuurd. Doordat de onderaannemers minder betaalden dan Shell, leidde dit tot een uitbarsting die bekend werd onder de naam “30 mei 1969”.', '21. De komst van de olie-industrie', '', 'inherit', 'closed', 'closed', '', '47-revision-v1', '', '', '2017-09-06 20:50:38', '2017-09-06 18:50:38', '', '47', 'http://canon.bramperry.nl/47-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('231', '8', '2017-09-06 20:51:02', '2017-09-06 18:51:02', 'Fusce nunc risus, varius ut ligula id, varius malesuada lectus. Nulla tincidunt magna id molestie blandit. Nullam non erat dictum arcu imperdiet viverra. Sed eleifend risus felis, nec blandit quam efficitur sed. Phasellus fermentum tortor augue, sit amet interdum turpis congue quis. Aliquam vulputate lacus purus, et tincidunt diam euismod a. Morbi dui nisi, suscipit id nisi quis, ultricies volutpat velit. Integer vehicula lacinia porta. Vestibulum pellentesque nec enim in suscipit. Ut auctor, neque nec porttitor facilisis, mauris est tincidunt nisi, non rhoncus urna turpis ac eros. Proin massa purus, lacinia vitae metus ac, pulvinar ultricies nibh. Morbi dictum sapien mauris. Quisque sapien odio, mollis rutrum volutpat sit amet, fringilla vitae ante.\r\n\r\nNulla sodales vestibulum porttitor. Pellentesque lacinia id purus non accumsan. Mauris pharetra eros sit amet elementum pretium. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum luctus fringilla mauris, sit amet tristique nisi dignissim tincidunt. Suspendisse vel tincidunt urna, ac pulvinar nisl. Cras tempor, felis vitae porttitor scelerisque, ante ex commodo est, in vestibulum dolor eros nec dui. Pellentesque accumsan nulla a leo congue, eget vestibulum purus laoreet. Sed vulputate vehicula felis, vitae interdum tortor vehicula sit amet. Nulla eu tincidunt mi.', '1. De oorspronkelijke bewoners', '', 'inherit', 'closed', 'closed', '', '8-revision-v1', '', '', '2017-09-06 20:51:02', '2017-09-06 18:51:02', '', '8', 'http://canon.bramperry.nl/8-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('233', '4', '2017-09-06 20:55:06', '2017-09-06 18:55:06', 'In 1912 had Shell een concessie verworven in het Mene Grande-veld, ten Oosten van het Meer van Maracaibo in Venezuela. Toen in 1914 duidelijk werd dat dit veld boordevol olie zat, had Shell al besloten om een kleine opslagplaats op Curaçao te bouwen. Een jaar later werd besloten er een raffinaderij te vestigen. De slechte bereikbaarheid van het Meer van Maracaibo en het stabiele bestuur van Curaçao, speelde een rol in deze keuze.\r\n\r\nIn de eerste jaren werd op Curaçao nog voor een groot deel olie uit Mexico verwerkt. Nadat Mexico in 1938 de olie industrie nationaliseerde, ging Shell exclusief Venezolaanse olie verwerken.\r\n\r\nTot het einde van 1920 waren er minder dan 300 mensen in dienst van de raffinaderij. Het zou uitgroeien tot 10.924 (inclusief de Curaçaosche Scheepvaart Maatschappij) in 1929. In die jaren werden arbeiders geworven uit de regio en uit Portugal. Al deze arbeiders werden in nieuwe wijken gehuisvest, niet ver van het raffinaderijcomplex. Daarbij werden ook allerlei voorzieningen gebouwd zoals wegen, scholen, winkels, buurtcentra, telefoon- en waterleidingen.\r\n\r\nDe economische crisis van de jaren dertig bracht het personeelsbestand drastisch terug en zou vanaf 1934 geleidelijk weer toenemen. Pas na 1945 kwam het personeelsaantal weer boven de 10.000 uit.\r\n\r\nIn de oorlogsjaren speelden de raffinaderijen op de Antillen een belangrijke rol voor de brandstofvoorziening van de Geallieerden. Duitsland zette vanaf februari 1942 duikboten in rond Curaçao en Aruba om deze brandstoftoevoer af te snijden. In de oorlogsjaren kreeg de raffinaderij toestemming een zogenaamd “asfalt-meer” aan te leggen vanwege het gebrek aan schepen om het te vervoeren.\r\n\r\nIn Venezuela werden de activiteiten op Curaçao en Aruba met jaloezie en afgunst bekeken. Na 1935 was het sentiment gekeerd tegen de “uitverkoop van nationale rijkdom”. In 1943 werd daarom wetgeving aangenomen waardoor de Antilliaanse raffinaderijen geen olie uit nieuwe concessies mochten verwerken. Shell werd gedwongen te investeren in een nieuwe raffinaderij in Venezuela. Dat werd de raffinaderij van Cardón, die in 1947 opstartte.\r\n\r\nZo werd Shell in de jaren vijftig gedwongen haar raffinaderij op Curaçao af te slanken. In 1959 speelde ook de Amerikaanse import restricties op olieproducten de kop op. Op verzoek van m.n. de Texaanse olieproducenten ging Amerika over op importquota.\r\n\r\nIn de jaren zestig werd het systeem van “onderaannemers” ingevoerd waarbij arbeiders via externe bedrijven werden ingehuurd. Doordat de onderaannemers minder betaalden dan Shell, leidde dit tot een uitbarsting die bekend werd onder de naam “<a href=\"http://canoncuracao.cw/31-mei-1969/\">30 mei 1969</a>”.', '21. De komst van de olie-industrie', '', 'inherit', 'closed', 'closed', '', '47-revision-v1', '', '', '2017-09-06 20:55:06', '2017-09-06 18:55:06', '', '47', 'http://canon.bramperry.nl/47-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('235', '8', '2017-09-06 21:38:21', '2017-09-06 19:38:21', 'Fusce nunc risus, varius ut ligula id, varius <a href=\"https://www.readinga-z.com/\">r</a>eadingatoz s. Nulla tincidunt magna id molestie blandit. Nullam non erat dictum arcu imperdiet viverra. Sed eleifend risus felis, nec blandit quam efficitur sed. Phasellus fermentum tortor augue, sit amet interdum turpis congue quis. Aliquam vulputate lacus purus, et tincidunt diam euismod a. Morbi dui nisi, suscipit id nisi quis, ultricies volutpat velit. Integer vehicula lacinia porta. Vestibulum pellentesque nec enim in suscipit. Ut auctor, neque nec porttitor facilisis, mauris est tincidunt nisi, non rhoncus urna turpis ac eros. Proin massa purus, lacinia vitae metus ac, pulvinar ultricies nibh. Morbi dictum sapien mauris. Quisque sapien odio, mollis rutrum volutpat sit amet, fringilla vitae ante.\n\nNulla sodales vestibulum porttitor. Pellentesque lacinia id purus non accumsan. Mauris pharetra eros sit amet elementum pretium. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum luctus fringilla mauris, sit amet tristique nisi dignissim tincidunt. Suspendisse vel tincidunt urna, ac pulvinar nisl. Cras tempor, felis vitae porttitor scelerisque, ante ex commodo est, in vestibulum dolor eros nec dui. Pellentesque accumsan nulla a leo congue, eget vestibulum purus laoreet. Sed vulputate vehicula felis, vitae interdum tortor vehicula sit amet. Nulla eu tincidunt mi.', '1. De oorspronkelijke bewoners', '', 'inherit', 'closed', 'closed', '', '8-autosave-v1', '', '', '2017-09-06 21:38:21', '2017-09-06 19:38:21', '', '8', 'http://canon.bramperry.nl/8-autosave-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('236', '7', '2017-09-06 20:57:04', '2017-09-06 18:57:04', '16 Gebouwen\r\n\r\nFort Amsterdam is het oudste gebouw op Curaçao. <a href=\"http://canoncuracao.cw/1-de-oorspronkelijke-bewoners/\">Het </a>werd in 1635, een jaar nadat de West- Indische Compagnie het eiland op de Spanjaarden had veroverd, gebouwd op de oostelijke oever van de Sint Annabaai. Dit betekent dat op Curaçao geen bouwwerken bewaard zijn gebleven uit de Spaanse periode (1499-1634) en evenmin uit de precolumbiaanse tijd.\r\n\r\nAan de noordzijde van Fort Amsterdam ontstond in de loop van de 17<sup>e</sup> eeuw een kleine nederzetting die ‘De Willemstad’ werd genoemd. De eerste huizen die hier werden gebouwd zijn beïnvloed door de architectuur uit Amsterdam. Kenmerkend zijn de hoge smalle voorgevels en de diepe zijgevels. De voorgevels zijn voorzien van tuitgevels waarop een rechthoekig lijstwerk is geplaatst met daarop een klein fronton. Deze eerste bouwstijl uit de zeventiende eeuw, die de Curaçaos-Hollandse stijl wordt genoemd, werd niet alleen toegepast in Willemstad maar ook bij de huizen op de plantages, de landhuizen.\r\n\r\nEen kenmerkend onderdeel van de traditionele architectuur op Curaçao zijn de galerijen. Dit waren aanvankelijk open houten of stenen constructies die tegen de voorgevels van de huizen in de stad werden geplaatst om de zon te weren. Later werden galerijen een structureel onderdeel van gebouwen zowel binnen als buiten de stad.\r\n\r\nIn de achttiende eeuw kwam de Curaçaose Barok in de mode met zijn sierlijke gebogen gevellijnen en arcades. Deze uitbundige bouwstijl werd in de eerste helft van de 19<sup>e</sup> eeuw afgewisseld door een sobere bouwstijl die weer teruggreep op de tuitgevel uit de 17<sup>e</sup> eeuw. De afmeting en detaillering was echter eenvoudiger geworden en kan daarom onderscheiden worden van de oudere stijl.\r\n\r\nDoor invloeden vanuit Nederland en de VS ontwikkelde zich in de tweede helft van de negentiende eeuw het ‘neoclassicisme’, een bouwstijl die gebaseerd was op de architectuur van de Grieken en Romeinen. De meest kenmerkende elementen van deze stijl waren de toepassing van zuilen en frontons (driehoeken). Het classicisme werd gebruikt voor zowel stadsvilla’s als eenvoudige woonhuizen en eveneens voor landhuizen.\r\n\r\nIn de eerste helft van de twintigste eeuw kwam Curaçao in contact met de internationale bouwstijl, die ook wel het ‘nieuwe bouwen’ wordt genoemd. Ook in deze periode zijn er duidelijke invloeden in de bouwkunst waar te nemen uit zowel Europa als de VS. Zo is bijvoorbeeld de voorgevel van de voormalige bioscoop Cinelandia geïnspireerd door de Art Deco architectuur in Miami en het voormalige KNSM-gebouw door de architectuur van de Nederlandse architect Dudoc.\r\n\r\nDe gebouwen op Curaçao hebben een Caraïbisch karakter gekregen door de invloeden van een multiculturele samenleving en het klimaat. De opvallende bonte kleuren op de gevels gaan terug op een verordening uit 1817, toen gouverneur Kikkert de eigenaren verplichte om de wit gekalkte voorgevels in binnenstad een kleur te geven.\r\n\r\nNB vragen of Gerda een alinea kan toevoegen over de huizen van het ‘gewone volk’, zoals knoekhuizen, houten huizen, huizen van blik.\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\nDe Spaanse periode  Sed accumsan quam suscipit finibus molestie. In sollicitudin augue vitae tellus efficitur mollis. Vivamus vel vulputate tortor. Cras ac massa ex. Pellentesque sit amet massa sed ante consequat condimentum nec laoreet risus. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum in massa vel ex sodales semper in ac urna. Nullam at pulvinar ligula. Integer commodo felis et purus vestibulum, id porta nibh sollicitudin.\r\n\r\nFusce efficitur ac est sit amet ultricies. Maecenas gravida, arcu pellentesque congue tempus, nunc lacus gravida libero, in vestibulum purus tortor vitae elit. Nullam sit amet risus at turpis faucibus scelerisque et dapibus ante. Suspendisse non dolor mattis, finibus diam et, varius est. Curabitur suscipit tincidunt leo vel tristique. Phasellus molestie consectetur orci, eget maximus lorem malesuada ut. Nulla laoreet mattis pretium. Vestibulum placerat eu dolor laoreet accumsan. Ut varius purus in orci tempor vulputate. Curabitur consectetur tellus orci, at finibus enim pharetra sit amet. Vestibulum ligula purus, sodales lacinia magna in, aliquam ultrices ipsum.', '2. De Spaanse periode ??', '', 'inherit', 'closed', 'closed', '', '10-revision-v1', '', '', '2017-09-06 20:57:04', '2017-09-06 18:57:04', '', '10', 'http://canon.bramperry.nl/10-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('237', '8', '2017-09-06 20:57:05', '2017-09-06 18:57:05', '<a href=\"http://weetjewat.nl\">Fusce nunc risus, </a>varius ut ligula id, varius malesuada lectus. Nulla tincidunt magna id molestie blandit. Nullam non erat dictum arcu imperdiet viverra. Sed eleifend risus felis, nec blandit quam efficitur sed. Phasellus fermentum tortor augue, sit amet interdum turpis congue quis. Aliquam vulputate lacus purus, et tincidunt diam euismod a. Morbi dui nisi, suscipit id nisi quis, ultricies volutpat velit. Integer vehicula lacinia porta. Vestibulum pellentesque nec enim in suscipit. Ut auctor, neque nec porttitor facilisis, mauris est tincidunt nisi, non rhoncus urna turpis ac eros. Proin massa purus, lacinia vitae metus ac, pulvinar ultricies nibh. Morbi dictum sapien mauris. Quisque sapien odio, mollis rutrum volutpat sit amet, fringilla vitae ante.\r\n\r\nNulla sodales vestibulum porttitor. Pellentesque lacinia id purus non accumsan. Mauris pharetra eros sit amet elementum pretium. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum luctus fringilla mauris, sit amet tristique nisi dignissim tincidunt. Suspendisse vel tincidunt urna, ac pulvinar nisl. Cras tempor, felis vitae porttitor scelerisque, ante ex commodo est, in vestibulum dolor eros nec dui. Pellentesque accumsan nulla a leo congue, eget vestibulum purus laoreet. Sed vulputate vehicula felis, vitae interdum tortor vehicula sit amet. Nulla eu tincidunt mi.', '1. De oorspronkelijke bewoners', '', 'inherit', 'closed', 'closed', '', '8-revision-v1', '', '', '2017-09-06 20:57:05', '2017-09-06 18:57:05', '', '8', 'http://canon.bramperry.nl/8-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('238', '7', '2017-09-06 20:58:17', '2017-09-06 18:58:17', '16 Gebouwen\r\n\r\nFort Amsterdam is het oudste gebouw op Curaçao. Het werd in 1635, een jaar nadat de West- Indische Compagnie het eiland op de Spanjaarden had veroverd, gebouwd op de oostelijke oever van de Sint Annabaai. Dit betekent dat op Curaçao geen bouwwerken bewaard zijn gebleven uit de Spaanse periode (1499-1634) en evenmin uit de precolumbiaanse tijd.\r\n\r\nAan de noordzijde van Fort Amsterdam ontstond in de loop van de 17<sup>e</sup> eeuw een kleine nederzetting die ‘De Willemstad’ werd genoemd. De eerste huizen die hier werden gebouwd zijn beïnvloed door de architectuur uit Amsterdam. Kenmerkend zijn de hoge smalle voorgevels en de diepe zijgevels. De voorgevels zijn voorzien van tuitgevels waarop een rechthoekig lijstwerk is geplaatst met daarop een klein fronton. Deze eerste bouwstijl uit de zeventiende eeuw, die de Curaçaos-Hollandse stijl wordt genoemd, werd niet alleen toegepast in Willemstad maar ook bij de huizen op de plantages, de landhuizen.\r\n\r\nEen kenmerkend onderdeel van de traditionele architectuur op Curaçao zijn de galerijen. Dit waren aanvankelijk open houten of stenen constructies die tegen de voorgevels van de huizen in de stad werden geplaatst om de zon te weren. Later werden galerijen een structureel onderdeel van gebouwen zowel binnen als buiten de stad.\r\n\r\nIn de achttiende eeuw kwam de Curaçaose Barok in de mode met zijn sierlijke gebogen gevellijnen en arcades. Deze uitbundige bouwstijl werd in de eerste helft van de 19<sup>e</sup> eeuw afgewisseld door een sobere bouwstijl die weer teruggreep op de tuitgevel uit de 17<sup>e</sup> eeuw. De afmeting en detaillering was echter eenvoudiger geworden en kan daarom onderscheiden worden van de oudere stijl.\r\n\r\nDoor invloeden vanuit Nederland en de VS ontwikkelde zich in de tweede helft van de negentiende eeuw het ‘neoclassicisme’, een bouwstijl die gebaseerd was op de architectuur van de Grieken en Romeinen. De meest kenmerkende elementen van deze stijl waren de toepassing van zuilen en frontons (driehoeken). Het classicisme werd gebruikt voor zowel stadsvilla’s als eenvoudige woonhuizen en eveneens voor landhuizen.\r\n\r\nIn de eerste helft van de twintigste eeuw kwam Curaçao in contact met de internationale bouwstijl, die ook wel het ‘nieuwe bouwen’ wordt genoemd. Ook in deze periode zijn er duidelijke invloeden in de bouwkunst waar te nemen uit zowel Europa als de VS. Zo is bijvoorbeeld de voorgevel van de voormalige bioscoop Cinelandia geïnspireerd door de Art Deco architectuur in Miami en het voormalige KNSM-gebouw door de architectuur van de Nederlandse architect Dudoc.\r\n\r\nDe gebouwen op Curaçao hebben een Caraïbisch karakter gekregen door de invloeden van een multiculturele samenleving en het klimaat. De opvallende bonte kleuren op de gevels gaan terug op een verordening uit 1817, toen gouverneur Kikkert de eigenaren verplichte om de wit gekalkte voorgevels in binnenstad een kleur te geven.\r\n\r\nNB vragen of Gerda een alinea kan toevoegen over de huizen van het ‘gewone volk’, zoals knoekhuizen, houten huizen, huizen van blik.\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\nDe Spaanse periode  Sed accumsan quam suscipit finibus molestie. In sollicitudin augue vitae tellus efficitur mollis. Vivamus vel vulputate tortor. Cras ac massa ex. Pellentesque sit amet massa sed ante consequat condimentum nec laoreet risus. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum in massa vel ex sodales semper in ac urna. Nullam at pulvinar ligula. Integer commodo felis et purus vestibulum, id porta nibh sollicitudin.\r\n\r\nFusce efficitur ac est sit amet ultricies. Maecenas gravida, arcu pellentesque congue tempus, nunc lacus gravida libero, in vestibulum purus tortor vitae elit. Nullam sit amet risus at turpis faucibus scelerisque et dapibus ante. Suspendisse non dolor mattis, finibus diam et, varius est. Curabitur suscipit tincidunt leo vel tristique. Phasellus molestie consectetur orci, eget maximus lorem malesuada ut. Nulla laoreet mattis pretium. Vestibulum placerat eu dolor laoreet accumsan. Ut varius purus in orci tempor vulputate. Curabitur consectetur tellus orci, at finibus enim pharetra sit amet. Vestibulum ligula purus, sodales lacinia magna in, aliquam ultrices ipsum.', '2. De Spaanse periode ??', '', 'inherit', 'closed', 'closed', '', '10-revision-v1', '', '', '2017-09-06 20:58:17', '2017-09-06 18:58:17', '', '10', 'http://canon.bramperry.nl/10-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('239', '8', '2017-09-06 20:59:40', '2017-09-06 18:59:40', '<a href=\"http://weetjewat.nl\">Fusce nunc risus, </a>varius ut ligula id, varius <a href=\"https://www.readinga-z.com/\">readingatoz </a>s. Nulla tincidunt magna id molestie blandit. Nullam non erat dictum arcu imperdiet viverra. Sed eleifend risus felis, nec blandit quam efficitur sed. Phasellus fermentum tortor augue, sit amet interdum turpis congue quis. Aliquam vulputate lacus purus, et tincidunt diam euismod a. Morbi dui nisi, suscipit id nisi quis, ultricies volutpat velit. Integer vehicula lacinia porta. Vestibulum pellentesque nec enim in suscipit. Ut auctor, neque nec porttitor facilisis, mauris est tincidunt nisi, non rhoncus urna turpis ac eros. Proin massa purus, lacinia vitae metus ac, pulvinar ultricies nibh. Morbi dictum sapien mauris. Quisque sapien odio, mollis rutrum volutpat sit amet, fringilla vitae ante.\r\n\r\nNulla sodales vestibulum porttitor. Pellentesque lacinia id purus non accumsan. Mauris pharetra eros sit amet elementum pretium. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum luctus fringilla mauris, sit amet tristique nisi dignissim tincidunt. Suspendisse vel tincidunt urna, ac pulvinar nisl. Cras tempor, felis vitae porttitor scelerisque, ante ex commodo est, in vestibulum dolor eros nec dui. Pellentesque accumsan nulla a leo congue, eget vestibulum purus laoreet. Sed vulputate vehicula felis, vitae interdum tortor vehicula sit amet. Nulla eu tincidunt mi.', '1. De oorspronkelijke bewoners', '', 'inherit', 'closed', 'closed', '', '8-revision-v1', '', '', '2017-09-06 20:59:40', '2017-09-06 18:59:40', '', '8', 'http://canon.bramperry.nl/8-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('241', '4', '2017-09-06 21:04:40', '2017-09-06 19:04:40', '30 Mei 1969 (Trinta di Mei)\r\n\r\nWereldwijd, en dus ook op Curaçao, staan de jaren 60 bekend als een tijdperk van maatschappelijke verandering. Talrijke sociale bewegingen ageerden tegen sociale machtsstructuren gebaseerd op kleur, klasse, en geslacht. Op Curaçao wordt er geen ander gebeurtenis sterker geassocieerd met deze periode als de opstand van \"Trinta di Mei,\" 30 Mei 1969.\r\n\r\nDe arbeidsconflicten die tot de opstand van 30 mei 1969 hebben geleid vinden hun oorsprong in de ontwikkelingen van de tweede helft van de jaren 1960. DeShell-olieraffinaderij, toen de grootste werkgever op Curaçao, begon met automatisering en uitbesteding naar verschillende onderaannemers zoals, onder andere, \"Werkspoor Caribbean\" (WESCAR). Door de uitbestending moesten werknemers die eerdervoor de Shell hadden gewerkt bij de onderaannemers hetzelfde arbeid verrichten tegen lager loon.\r\n\r\n&nbsp;\r\n\r\nIn de eerste week van mei 1969 ontstond er een impasse in de onderhandelingentussen WESCAR en de Curaçao Federation of Workers (CFW) over decollectieve arbeidersovereenkomst (CAO)die op 6 mei 1969 zou aflopen.CFW hanteerde het principe van \"equal work equal pay\" en eiste een loon dat gelijk was met wat de Shell betaalde voordat de banenaan WESCAR werden uitbesteed. Toen WESCAR ditweigerde, kondigde de CFW in de laatste week van mei een algemene staking af voor alle leden.Al gauw volgde een sympathie-staking van de Shell-arbeidersvakbond \"Petroleum Workers Federation of Curaçao\" (PWFC).Politici, journalisten en activisten zoals Stanley Brown, hoofdredacteur van de linkse antikoloniale tijdschrift<em> Vitó</em>,steunden de stakende arbeiders.\r\n\r\n&nbsp;\r\n\r\nOp de ochtend van 30 mei 1969 verzamelden zichongeveer vijfduizend stakers bij de hoofdingang van de Shell-terrein voor een optocht naar Fort Amsterdam, onder leiding van Ewald Ong-a-Kwie, leider van de CFW.De leiders van de havenarbeiders, Wilson \"Papa\" Godett en Amador Nita, sloten zich toen aan bij de optocht. De optocht escaleerde tot een heuse opstand toen bij Parera twee doden vielen, Manuel Gutierez en Orlando Gerardina.Wilson \"Papa\" Godett werd in de rug geraakt door een politiekogel, toen hij met de handen omhoog de menigte probeerde te kalmeren. Na de escalatie stemdenShell en WESCAR alsnog in met de eisen van gelijk loon voor gelijk werk van de CFW<strong>.</strong> Het was echter al te laat. Een woedende meute stroomde Punda en Otrobanda binnen. Gebouwen werden in brand gestoken, en winkels werden geplunderd. De gouverneur kondigde een noodtoestand af, het leger werd ingeschakeld, en mariniers uit Nederland werden ingevlogen om de opstand te bedwingen. Nadat de vakbondsleiders op de radio hadden bekendgemaakt dat Shell en de onderaannemers met de eisen van de vakbonden hadden ingestemd,keerde de rust terug.In de nasleep van de opstand ontstond er een nieuwe politieke partij, \"Frente Obrero Liberashon Trinta di Mei,\" geleid door Wilson Godett, Stanley Brown en Amador Nita, die zou opkomen voor de belangen van de arbeidersklasse.\r\n\r\nMet de loop der jaren werd \"Trinta di Mei\" een symbool voor een langere periode van sociale veranderingsprocessen van de jaren 60, waarbij de raciaal gesegmenteerde koloniale machtsstructuurmoest plaatsmaken voor een politiek klimaat waarin er meer rekening werd gehouden met de belangen van de Afro-Curaçaosearbeidersklasse.In 1994 werd \"Trinta di Mei\" tot nationale herdenkingsdag verklaard. Alhoewel er onder Curaçaoënaars nog steeds meningsverschillen bestaan over de details, wordt \"Trinta Di Mei\" toch beschouwd als een belangrijk keerpunt in de politieke geschiedenis van Curaçao.', '31. Mei 1969', '', 'inherit', 'closed', 'closed', '', '67-revision-v1', '', '', '2017-09-06 21:04:40', '2017-09-06 19:04:40', '', '67', 'http://canon.bramperry.nl/67-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('242', '8', '2017-09-06 21:09:15', '2017-09-06 19:09:15', '<a href=\"http://weetjewat.nl\">Fusce nunc risus, </a>varius ut ligula id, varius <a href=\"https://www.readinga-z.com/\">readingatoz </a>s. Nulla tincidunt magna id molestie blandit. Nullam non erat dictum arcu imperdiet viverra. Sed eleifend risus felis, nec blandit quam efficitur sed. Phasellus fermentum tortor augue, sit amet interdum turpis congue quis. Aliquam vulputate lacus purus, et tincidunt diam euismod a. Morbi dui nisi, suscipit id nisi quis, ultricies volutpat velit. Integer vehicula lacinia porta. Vestibulum pellentesque nec enim in suscipit. Ut auctor, neque nec porttitor facilisis, mauris est tincidunt nisi, non rhoncus urna turpis ac eros. Proin massa purus, lacinia vitae metus ac, pulvinar ultricies nibh. Morbi dictum sapien mauris. Quisque sapien odio, mollis rutrum volutpat sit amet, fringilla vitae ante.\r\n\r\nNulla sodales vestibulum porttitor. Pellentesque lacinia id purus non accumsan. Mauris pharetra eros sit amet elementum pretium. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum luctus fringilla mauris, sit amet tristique nisi dignissim tincidunt. Suspendisse vel tincidunt urna, ac pulvinar nisl. Cras tempor, felis vitae porttitor scelerisque, ante ex commodo est, in vestibulum dolor eros nec dui. Pellentesque accumsan nulla a leo congue, eget vestibulum purus laoreet. Sed vulputate vehicula felis, vitae interdum tortor vehicula sit amet. Nulla eu tincidunt mi.', '1. De oorspronkelijke bewoners', '', 'inherit', 'closed', 'closed', '', '8-revision-v1', '', '', '2017-09-06 21:09:15', '2017-09-06 19:09:15', '', '8', 'http://canon.bramperry.nl/8-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('243', '7', '2017-09-06 21:09:35', '2017-09-06 19:09:35', '16 Gebouwen\r\n\r\nFort Amsterdam is het oudste gebouw op Curaçao. Het werd in 1635, een jaar nadat de West- Indische Compagnie het eiland op de Spanjaarden had veroverd, gebouwd op de oostelijke oever van de Sint Annabaai. Dit betekent dat op Curaçao geen bouwwerken bewaard zijn gebleven uit de Spaanse periode (1499-1634) en evenmin uit de precolumbiaanse tijd.\r\n\r\nAan de noordzijde van Fort Amsterdam ontstond in de loop van de 17<sup>e</sup> eeuw een kleine nederzetting die ‘De Willemstad’ werd genoemd. De eerste huizen die hier werden gebouwd zijn beïnvloed door de architectuur uit Amsterdam. Kenmerkend zijn de hoge smalle voorgevels en de diepe zijgevels. De voorgevels zijn voorzien van tuitgevels waarop een rechthoekig lijstwerk is geplaatst met daarop een klein fronton. Deze eerste bouwstijl uit de zeventiende eeuw, die de Curaçaos-Hollandse stijl wordt genoemd, werd niet alleen toegepast in Willemstad maar ook bij de huizen op de plantages, de landhuizen.\r\n\r\nEen kenmerkend onderdeel van de traditionele architectuur op Curaçao zijn de galerijen. Dit waren aanvankelijk open houten of stenen constructies die tegen de voorgevels van de huizen in de stad werden geplaatst om de zon te weren. Later werden galerijen een structureel onderdeel van gebouwen zowel binnen als buiten de stad.\r\n\r\nIn de achttiende eeuw kwam de Curaçaose Barok in de mode met zijn sierlijke gebogen gevellijnen en arcades. Deze uitbundige bouwstijl werd in de eerste helft van de 19<sup>e</sup> eeuw afgewisseld door een sobere bouwstijl die weer teruggreep op de tuitgevel uit de 17<sup>e</sup> eeuw. De afmeting en detaillering was echter eenvoudiger geworden en kan daarom onderscheiden worden van de oudere stijl.\r\n\r\nDoor invloeden vanuit Nederland en de VS ontwikkelde zich in de tweede helft van de negentiende eeuw het ‘neoclassicisme’, een bouwstijl die gebaseerd was op de architectuur van de Grieken en Romeinen. De meest kenmerkende elementen van deze stijl waren de toepassing van zuilen en frontons (driehoeken). Het classicisme werd gebruikt voor zowel stadsvilla’s als eenvoudige woonhuizen en eveneens voor landhuizen.\r\n\r\nIn de eerste helft van de twintigste eeuw kwam Curaçao in contact met de internationale bouwstijl, die ook wel het ‘nieuwe bouwen’ wordt genoemd. Ook in deze periode zijn er duidelijke invloeden in de bouwkunst waar te nemen uit zowel Europa als de VS. Zo is bijvoorbeeld de voorgevel van de voormalige bioscoop Cinelandia geïnspireerd door de Art Deco architectuur in Miami en het voormalige KNSM-gebouw door de architectuur van de Nederlandse architect Dudoc.\r\n\r\nDe gebouwen op Curaçao hebben een Caraïbisch karakter gekregen door de invloeden van een multiculturele samenleving en het klimaat. De opvallende bonte kleuren op de gevels gaan terug op een verordening uit 1817, toen gouverneur Kikkert de eigenaren verplichte om de wit gekalkte voorgevels in binnenstad een kleur te geven.\r\n\r\nNB vragen of Gerda een alinea kan toevoegen over de huizen van het ‘gewone volk’, zoals knoekhuizen, houten huizen, huizen van blik.\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\nDe Spaanse periode  Sed accumsan quam suscipit finibus molestie. In sollicitudin augue vitae tellus efficitur mollis. Vivamus vel vulputate tortor. Cras ac massa ex. Pellentesque sit amet massa sed ante consequat condimentum nec laoreet risus. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum in massa vel ex sodales semper in ac urna. Nullam at pulvinar ligula. Integer commodo felis et purus vestibulum, id porta nibh sollicitudin.\r\n\r\nFusce efficitur ac est sit amet ultricies. Maecenas gravida, arcu pellentesque congue tempus, nunc lacus gravida libero, in vestibulum purus tortor vitae elit. Nullam sit amet risus at turpis faucibus scelerisque et dapibus ante. Suspendisse non dolor mattis, finibus diam et, varius est. Curabitur suscipit tincidunt leo vel tristique. Phasellus molestie consectetur orci, eget maximus lorem malesuada ut. Nulla laoreet mattis pretium. Vestibulum placerat eu dolor laoreet accumsan. Ut varius purus in orci tempor vulputate. Curabitur consectetur tellus orci, at finibus enim pharetra sit amet. Vestibulum ligula purus, sodales lacinia magna in, aliquam ultrices ipsum.', '2. De Spaanse periode ??', '', 'inherit', 'closed', 'closed', '', '10-revision-v1', '', '', '2017-09-06 21:09:35', '2017-09-06 19:09:35', '', '10', 'http://canon.bramperry.nl/10-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('244', '4', '2017-09-06 21:11:22', '2017-09-06 19:11:22', '30 Mei 1969 (Trinta di Mei)\r\n\r\nWereldwijd, en dus ook op Curaçao, staan de jaren 60 bekend als een tijdperk van maatschappelijke verandering. Talrijke sociale bewegingen ageerden tegen sociale machtsstructuren gebaseerd op kleur, klasse, en geslacht. Op Curaçao wordt er geen ander gebeurtenis sterker geassocieerd met deze periode als de opstand van \"Trinta di Mei,\" 30 Mei 1969.\r\n\r\nDe arbeidsconflicten die tot de opstand van 30 mei 1969 hebben geleid vinden hun oorsprong in de ontwikkelingen van de tweede helft van de jaren 1960. DeShell-olieraffinaderij, toen de grootste werkgever op Curaçao, begon met automatisering en uitbesteding naar verschillende onderaannemers zoals, onder andere, \"Werkspoor Caribbean\" (WESCAR). Door de uitbestending moesten werknemers die eerdervoor de Shell hadden gewerkt bij de onderaannemers hetzelfde arbeid verrichten tegen lager loon.\r\n\r\n&nbsp;\r\n\r\nIn de eerste week van mei 1969 ontstond er een impasse in de onderhandelingentussen WESCAR en de Curaçao Federation of Workers (CFW) over decollectieve arbeidersovereenkomst (CAO)die op 6 mei 1969 zou aflopen.CFW hanteerde het principe van \"equal work equal pay\" en eiste een loon dat gelijk was met wat de Shell betaalde voordat de banenaan WESCAR werden uitbesteed. Toen WESCAR ditweigerde, kondigde de CFW in de laatste week van mei een algemene staking af voor alle leden.Al gauw volgde een sympathie-staking van de Shell-arbeidersvakbond \"Petroleum Workers Federation of Curaçao\" (PWFC).Politici, journalisten en activisten zoals Stanley Brown, hoofdredacteur van de linkse antikoloniale tijdschrift<em> Vitó</em>,steunden de stakende arbeiders.\r\n\r\n&nbsp;\r\n\r\nOp de ochtend van 30 mei 1969 verzamelden zichongeveer vijfduizend stakers bij de hoofdingang van de Shell-terrein voor een optocht naar Fort Amsterdam, onder leiding van Ewald Ong-a-Kwie, leider van de CFW.De leiders van de havenarbeiders, Wilson \"Papa\" Godett en Amador Nita, sloten zich toen aan bij de optocht. De optocht escaleerde tot een heuse opstand toen bij Parera twee doden vielen, Manuel Gutierez en Orlando Gerardina.Wilson \"Papa\" Godett werd in de rug geraakt door een politiekogel, toen hij met de handen omhoog de menigte probeerde te kalmeren. Na de escalatie stemdenShell en WESCAR alsnog in met de eisen van gelijk loon voor gelijk werk van de CFW<strong>.</strong> Het was echter al te laat. Een woedende meute stroomde Punda en Otrobanda binnen. Gebouwen werden in brand gestoken, en winkels werden geplunderd. De gouverneur kondigde een noodtoestand af, het leger werd ingeschakeld, en mariniers uit Nederland werden ingevlogen om de opstand te bedwingen. Nadat de vakbondsleiders op de radio hadden bekendgemaakt dat Shell en de onderaannemers met de eisen van de vakbonden hadden ingestemd,keerde de rust terug.In de nasleep van de opstand ontstond er een nieuwe politieke partij, \"Frente Obrero Liberashon Trinta di Mei,\" geleid door Wilson Godett, Stanley Brown en Amador Nita, die zou opkomen voor de belangen van de arbeidersklasse.\r\n\r\nMet de loop der jaren werd \"Trinta di Mei\" een symbool voor een langere periode van sociale veranderingsprocessen van de jaren 60, waarbij de raciaal gesegmenteerde koloniale machtsstructuurmoest plaatsmaken voor een politiek klimaat waarin er meer rekening werd gehouden met de belangen van de Afro-Curaçaosearbeidersklasse.In 1994 werd \"Trinta di Mei\" tot nationale herdenkingsdag verklaard. Alhoewel er onder Curaçaoënaars nog steeds meningsverschillen bestaan over de details, wordt \"Trinta Di Mei\" toch beschouwd als een belangrijk keerpunt in de politieke geschiedenis van Curaçao.', '31. Mei 1969', '', 'inherit', 'closed', 'closed', '', '67-revision-v1', '', '', '2017-09-06 21:11:22', '2017-09-06 19:11:22', '', '67', 'http://canon.bramperry.nl/67-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('246', '4', '2017-09-06 21:12:57', '2017-09-06 19:12:57', 'In 1912 had Shell een concessie verworven in het Mene Grande-veld, ten Oosten van het Meer van Maracaibo in Venezuela. Toen in 1914 duidelijk werd dat dit veld boordevol olie zat, had Shell al besloten om een kleine opslagplaats op Curaçao te bouwen. Een jaar later werd besloten er een raffinaderij te vestigen. De slechte bereikbaarheid van het Meer van Maracaibo en het stabiele bestuur van Curaçao, speelde een rol in deze keuze.\r\n\r\nIn de eerste jaren werd op Curaçao nog voor een groot deel olie uit Mexico verwerkt. Nadat Mexico in 1938 de olie industrie nationaliseerde, ging Shell exclusief Venezolaanse olie verwerken.\r\n\r\nTot het einde van 1920 waren er minder dan 300 mensen in dienst van de raffinaderij. Het zou uitgroeien tot 10.924 (inclusief de Curaçaosche Scheepvaart Maatschappij) in 1929. In die jaren werden arbeiders geworven uit de regio en uit Portugal. Al deze arbeiders werden in nieuwe wijken gehuisvest, niet ver van het raffinaderijcomplex. Daarbij werden ook allerlei voorzieningen gebouwd zoals wegen, scholen, winkels, buurtcentra, telefoon- en waterleidingen.\r\n\r\nDe economische crisis van de jaren dertig bracht het personeelsbestand drastisch terug en zou vanaf 1934 geleidelijk weer toenemen. Pas na 1945 kwam het personeelsaantal weer boven de 10.000 uit.\r\n\r\nIn de oorlogsjaren speelden de raffinaderijen op de Antillen een belangrijke rol voor de brandstofvoorziening van de Geallieerden. Duitsland zette vanaf februari 1942 duikboten in rond Curaçao en Aruba om deze brandstoftoevoer af te snijden. In de oorlogsjaren kreeg de raffinaderij toestemming een zogenaamd “asfalt-meer” aan te leggen vanwege het gebrek aan schepen om het te vervoeren.\r\n\r\nIn Venezuela werden de activiteiten op Curaçao en Aruba met jaloezie en afgunst bekeken. Na 1935 was het sentiment gekeerd tegen de “uitverkoop van nationale rijkdom”. In 1943 werd daarom wetgeving aangenomen waardoor de Antilliaanse raffinaderijen geen olie uit nieuwe concessies mochten verwerken. Shell werd gedwongen te investeren in een nieuwe raffinaderij in Venezuela. Dat werd de raffinaderij van Cardón, die in 1947 opstartte.\r\n\r\nZo werd Shell in de jaren vijftig gedwongen haar raffinaderij op Curaçao af te slanken. In 1959 speelde ook de Amerikaanse import restricties op olieproducten de kop op. Op verzoek van m.n. de Texaanse olieproducenten ging Amerika over op importquota.\r\n\r\nIn de jaren zestig werd het systeem van “onderaannemers” ingevoerd waarbij arbeiders via externe bedrijven werden ingehuurd. Doordat de onderaannemers minder betaalden dan Shell, leidde dit tot een uitbarsting die bekend werd onder de naam “<a href=\"http://canoncuracao.cw/31-mei-1969/\">30 mei 1969</a>”.', '21. De komst van de olie-industrie', '', 'inherit', 'closed', 'closed', '', '47-revision-v1', '', '', '2017-09-06 21:12:57', '2017-09-06 19:12:57', '', '47', 'http://canon.bramperry.nl/47-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('247', '8', '2017-09-06 21:19:06', '0000-00-00 00:00:00', 'Op 6 september 2017 werd en workshop georganiseerd door Bram Perry.\n\nBram heeft de website ontwikkeld vvor de canonvensters.\n\nHet is de bedoeling dat de schrijvers van de canonteksten zelf de teksten op de website plaatsen.\n\nAlle geinteresseerden\n\n&nbsp;\n\n&nbsp;', 'Workshop \"teksten invoeren\"', '', 'draft', 'closed', 'closed', '', '', '', '', '2017-09-06 21:19:06', '2017-09-06 19:19:06', '', '0', 'http://canon.bramperry.nl/?page_id=247', '0', 'page', '', '0');
INSERT INTO `wp_posts` VALUES('248', '7', '2017-09-06 21:14:56', '2017-09-06 19:14:56', '<table width=\"690\">\r\n<tbody>\r\n<tr>\r\n<td width=\"30\">1</td>\r\n<td width=\"192\">Claudia Kraan</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/1-de-oorspronkelijke-bewoners/\">De oorspronkelijke bewoners</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">2</td>\r\n<td width=\"192\">Erwin Gibbes</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/2-de-spaanse-periode/\">De Spaanse periode</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">3</td>\r\n<td width=\"192\">Han Jordaan</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/3-verovering-van-curacao-door-de-wic-en-de-komst-van-de-hollanders/\">Verovering van Curaçao door de WIC</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">4</td>\r\n<td width=\"192\">Hans Vlinkervleugel</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/4-nieuwe-bewoners-in-de-zeventiende-eeuw/\">Nieuwe bewoners in de zeventiende eeuw</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">5</td>\r\n<td width=\"192\">Charles do Rego</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/5-de-slavenhandel-en-slaverij/\">De slavenhandel en slavernij</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">6</td>\r\n<td width=\"192\">Charles do Rego</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/6-slavernijverzet/\">Slavernijverzet</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">7</td>\r\n<td width=\"192\">Charles do Rego</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/7-tula/\">Tula</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">8</td>\r\n<td width=\"192\">Ronnie Severing</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/8-papiamentu/\">Papiamentu</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">9</td>\r\n<td width=\"192\">Han Jordaan</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/9-curacao-rond-1800/\">Curaçao rond 1800</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">10</td>\r\n<td width=\"192\">Michael Newton</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/10-ontwikkeling-willemstad/\">De ontwikkeling van Willemstad</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">11</td>\r\n<td width=\"192\">Eddy Baetens</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/11-ontwikkeling-nederzettingen-en-barios-buiten-willemstad/\">De ontwikkeling van bewoning buiten Willemstad</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">12</td>\r\n<td width=\"192\">Ieteke Witteveen</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/12-brion-piar-bolivar/\">Brion, Piar, Bolivar</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">13</td>\r\n<td width=\"192\">Eddy Baetens</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/13-plantagesysteem-op-curacao/\">Het plantagesysteem op Curaçao</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">14</td>\r\n<td width=\"192\">Rose Mary Allen</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/14-afschaffing-slavernij/\">De afschaffing van de slavernij</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">15</td>\r\n<td width=\"192\">Nolda Römer</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/15-opbouw-samenleving-19e-eeuw-verschillende-bevolkingsgroepen/\">De opbouw van de samenleving in de negentiende eeuw: de verschillende bevolkingsgroepen</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">16</td>\r\n<td width=\"192\">Gerda Gehlen</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/16-gebouwen/\">Gebouwen</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">17</td>\r\n<td width=\"192\">Francois van der Hoeven</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/17-verdediging-curacao-en-forten/\">De verdediging van Curaçao</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">18</td>\r\n<td width=\"192\">Rose Mary Allen</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/18-werkgelegenheid-en-emigratie-1863-en-1920/\">Werkgelegenheid en emigratie tussen 1863 en 1920</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">19</td>\r\n<td width=\"192\">Eddy Baetens</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/19-mijnbouw/\">Mijnbouw</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">20</td>\r\n<td width=\"192\">Margo Groenewoud</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/20-komst-religieuze-ordes-nederland-en-betekenis/\">De komst van de religieuze ordes uit Nederland en hun betekenis</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">21</td>\r\n<td width=\"192\">Max Scriwanek</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">De komst van de olie-industrie</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">22</td>\r\n<td width=\"192\">Charles do Rego</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/22-de-nieuwe-immigranten-op-curacao-vanaf-het-begin-van-de-twintigste-eeuw/\">De nieuwe immigranten op Curaçao vanaf het begin van de twintigste eeuw</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">23</td>\r\n<td width=\"192\">Dimitri Cloose</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/23-de-haven/\">De haven</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">24</td>\r\n<td width=\"192\">Frank Quirindongo</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/24-de-arbeidersbeweging/\">De arbeidersbeweging</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">25</td>\r\n<td width=\"192\">Erwin Gibbes</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/25-tweede-wereldoorlog/\">De tweede wereldoorlog</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">26</td>\r\n<td width=\"192\">Eugene Boeldak</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/26-dr-f-da-costa-gomez/\">Dr. M.F. da Costa Gomez</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">27</td>\r\n<td width=\"192\">Gilbert Cijntje</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/27-algemeen-kiesrecht/\">Algemeen kiesrecht</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">28</td>\r\n<td width=\"192\">Nolda Römer</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/28-het-statuut/\">Het statuut</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">29</td>\r\n<td width=\"192\">Margo Groenewoud</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/29-60er-jaren-sfeer-verandering/\">De jaren zestig – een sfeer van verandering</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">30</td>\r\n<td width=\"192\">Luis Römer</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/30-dertig-mei-1969/\">Mei 1969</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">31</td>\r\n<td width=\"192\">Su Girigorie</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/31-vrouwenemancipatie/\">Vrouwenemancipatie</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">32</td>\r\n<td width=\"192\">Rose Mary Allen</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/32-cultureel-levende-culturele-dynamiek-jaren-70/\">De culturele dynamiek in de jaren zeventig</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">33</td>\r\n<td width=\"192\">Max Scriwanek</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/33-vertrek-shell-komst-en-vertrek-pdvsa/\">Vertrek van Shell, komst en vertrek PDVSA</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">34</td>\r\n<td width=\"192\">Eugene Boeldak</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/34-staatkundige-ontwikkelingen-vanaf-statuut-tot-10-oktober-2010/\">De staatkundige ontwikkelingen vanaf het statuut tot 10 oktober 2010</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">35</td>\r\n<td width=\"192\">Charles do Rego</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/35-oil-as-king-tot-tourism-as-king/\">Van ‘Oil as King’ tot ‘Tourism as King’</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">36</td>\r\n<td width=\"192\">Etienne Sillie</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/36-sport-klein-eiland-grote-sportlieden/\">Sport – een klein eiland met grote sportlieden -Andrew Jones</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">37</td>\r\n<td width=\"192\">Nel Casimiri</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/37-kunst-en-cultuur-20e-eeuw/\">Kunst en cultuur in de twintigste eeuw</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">38</td>\r\n<td width=\"192\">Ieteke Witteveen</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/38-carnaval/\">Carnaval</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">39</td>\r\n<td width=\"192\">Eddy Baetens</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/39-water/\">Water</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">40</td>\r\n<td width=\"192\">Ieteke Witteveen</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/40-elis-juliana-en-pater-brenneker/\">Elis Juliana en Pater Brenneker</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">41</td>\r\n<td width=\"192\">Ronald Donk</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/41-onderwijs-op-curacao/\">Het onderwijs op Curaçao</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">42</td>\r\n<td width=\"192\">Nolda Römer</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/42-pluriforme-samenleving/\">De pluriforme samenleving</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">43</td>\r\n<td width=\"192\">Michelle da Costa Gomez</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/43-omgaan-natuur/\">Omgaan met de natuur</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">44</td>\r\n<td width=\"192\">Rose Mary Allen</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/44-religie-en-religieuze-vieringen/\">Religie en religieuze vieringen</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">45</td>\r\n<td width=\"192\">Martin van den Blink</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/45-relatie-venezuela/\">De relatie met Venezuela</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">46</td>\r\n<td width=\"192\">Margo Goenewoud</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/46-het-leven-van-curacaoenaars-in-de-diaspora/\">Het leven van Curaçaoenaars in de diaspora</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">47</td>\r\n<td width=\"192\">Hans Vlinkervleugel</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/47-de-andere-eilanden-van-de-nederlandse-antillen/\">De andere eilanden van de voormalige Nederlandse Antillen</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">48</td>\r\n<td width=\"192\">Max Scriwanek</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/48-de-ontwikkeling-van-het-electriciteitsnet-de-watervoorziening-en-het-telefoonnet/\">De ontwikkeling van de telecommunicatie</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">49</td>\r\n<td width=\"192\">Sharnon Isenia</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/49-transport/\">Transport</a></td>\r\n</tr>\r\n<tr>\r\n<td width=\"30\">50</td>\r\n<td width=\"192\">Renske Pin</td>\r\n<td width=\"468\"><a href=\"https://canoncuracao.cw/50-media/\">Media</a></td>\r\n</tr>\r\n</tbody>\r\n</table>', 'Overzicht van de vensters', '', 'publish', 'closed', 'closed', '', 'overzicht-van-de-vensters', '', '', '2020-11-19 18:12:48', '2020-11-19 17:12:48', '', '0', 'http://canon.bramperry.nl/?page_id=248', '0', 'page', '', '0');
INSERT INTO `wp_posts` VALUES('250', '7', '2017-09-06 21:14:56', '2017-09-06 19:14:56', '<ol>\r\n 	<li>de eerste bewoners</li>\r\n 	<li>de spaanse periode</li>\r\n</ol>', 'overzicht van de vensters', '', 'inherit', 'closed', 'closed', '', '248-revision-v1', '', '', '2017-09-06 21:14:56', '2017-09-06 19:14:56', '', '248', 'http://canon.bramperry.nl/248-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('252', '7', '2017-09-06 21:16:49', '2017-09-06 19:16:49', '<h2>Wat weet jij over Curaçao?</h2>\r\n<a href=\"http://canoncuracao.cw/overzicht-van-de-vensters/\">Aliquam</a> et lectus in nisi commodo feugiat non sed dolor. Ut maximus maximus elit, vel posuere justo molestie molestie. Praesent varius lobortis hendrerit.\r\n<h2>Nieuws</h2>\r\nAliquam et lectus in nisi commodo feugiat non sed dolor. Ut maximus maximus elit, vel posuere justo molestie molestie. Praesent varius lobortis hendrerit.', 'Home', '', 'inherit', 'closed', 'closed', '', '2-revision-v1', '', '', '2017-09-06 21:16:49', '2017-09-06 19:16:49', '', '2', 'http://canon.bramperry.nl/2-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('254', '4', '2017-09-06 21:20:27', '2017-09-06 19:20:27', '<h3>De verovering van Curaçao</h3>\r\nCuraçao werd in 1634 door de West-Indische Compagnie (WIC) veroverd op de Spanjaarden.\r\n\r\nDe Republiek was op dat moment verwikkeld in de Tachtigjarige Oorlog (1568-1648) met Spanje en metPortugal. Deze landen waren sinds 1580 verenigd waren onder één staatshoofd, de Spaanse koning. De WIC was in 1621 opgericht om te dienen als een instrument in die oorlog. Behalve met de uitvoering van een ambitieus plan, het ‘groot desseyn’,dat gericht was op het veroveren van Portugese gebieden in Afrika en Brazilië, was de WIC vooral actief in de kaapvaart. Er bestond daarom behoefte aan een maritiem steunpunt in het operatiegebied van waaruit militaire acties konden worden ondernomen.Het strategisch gunstig gelegen Curaçao was daarvoor uitstekend geschikt. Het eiland was goed verdedigbaar en beschikte over een uitstekende natuurlijke haven, de Sint-Annabaai.\r\n\r\nEen expeditie onder leiding van Johannes van Walbeecken Pierre le Grand slaagde er vrij eenvoudig in om Curaçao te overmeesteren. De kleine Spaanse bezetting werd samen met het grootste deel van de inheemse bevolking gedeporteerd naar Venezuela. Daarna werd een begin gemaakt met het op orde brengen van de verdediging. Aan oostelijke zijde van de ingang van de Sint-Annabaai op een landtong die De Punt (Punda) werd genoemd werd een sterkte gebouwd, fort Amsterdam.\r\n<h3>Van oorlogsbasis naar vestigingskolonie</h3>\r\nGedurende de eerste jaren na de verovering verbleven er op Curaçao in hoofdzaak militairen. In 1635 waren slechts 20 van de 412 compagniesdienaren burgers. Er woonden verder zo’n 50 inheemse bewoners. Spoedig arriveerden ook Afrikaanse slaven. Deze waren aanvankelijk vooral afkomstig van veroverde vijandelijke schepen. Maar hun aantallen waren tot midden zeventiende eeuw nog gering.\r\n\r\nVrijwel direct nadat bekend werd dat Curaçao was veroverd, ontstond er in het moederland belangstelling voor kolonisatieprojecten. Militairen en civiele beambten op het eiland, die hun contract hadden uitgediend, kregen ook de mogelijkheid om zich als landbouwer te vestigen. Maar dit leidde nauwelijks tot concrete resultaten.\r\n\r\nIn de jaren vijftig van zeventiende eeuw vestigden zich joodse kolonisten op het eiland. In 1665 woonden er, de inheemse bevolking niet meegerekend, zo’n 600 personen.Curaçao had inmiddels geen functie meer als oorlogsbasis, maar ontwikkelde zich nu, met de vanaf 1650 opkomende slavenhandel als motor, tot een commercieel centrum.Rond deze tijd ontstond ten noorden van fort Amsterdam een vestiging die uitgroeide tot een ommuurde stad, Willemstad. Het aantal plantages en tuinen groeide ook. Deze richtten zich vooral op de lokale voedselproductie.', '3. Verovering door de WIC en de komst van de Hollanders', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2017-09-06 21:20:27', '2017-09-06 19:20:27', '', '12', 'http://canon.bramperry.nl/12-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('256', '8', '2017-09-06 21:26:56', '2017-09-06 19:26:56', 'Op 6 september 2017 werd een workshop georganiseerd voor\r\n\r\ngeïnteresseerden van de canoncommissie.<img class=\"alignnone  wp-image-201\" src=\"http://canoncuracao.cw/wp-content/uploads/2017/09/bloem-300x300.jpeg\" alt=\"\" width=\"39\" height=\"39\" />', 'Workshop : \"teksten invoeren\"', '', 'publish', 'closed', 'closed', '', 'workshop-teksten-invoeren', '', '', '2017-09-06 21:26:56', '2017-09-06 19:26:56', '', '0', 'http://canon.bramperry.nl/?page_id=256', '0', 'page', '', '0');
INSERT INTO `wp_posts` VALUES('261', '4', '2017-09-06 21:24:51', '2017-09-06 19:24:51', '30 Mei 1969 (Trinta di Mei)\r\n\r\nWereldwijd, en dus ook op Curaçao, staan de jaren 60 bekend als een tijdperk van maatschappelijke verandering. Talrijke sociale bewegingen ageerden tegen sociale machtsstructuren gebaseerd op kleur, klasse, en geslacht. Op Curaçao wordt er geen ander gebeurtenis sterker geassocieerd met deze periode als de opstand van \"Trinta di Mei,\" 30 Mei 1969.\r\n\r\nDe arbeidsconflicten die tot de opstand van 30 mei 1969 hebben geleid vinden hun oorsprong in de ontwikkelingen van de tweede helft van de jaren 1960. De Shell-olieraffinaderij, toen de grootste werkgever op Curaçao, begon met automatisering en uitbesteding naar verschillende onderaannemers zoals, onder andere, \"Werkspoor Caribbean\" (WESCAR). Door de uitbestending moesten werknemers die eerder voor de Shell hadden gewerkt bij de onderaannemers hetzelfde arbeid verrichten tegen lager loon.\r\n\r\nIn de eerste week van mei 1969 ontstond er een impasse in de onderhandelingentussen WESCAR en de Curaçao Federation of Workers (CFW) over decollectieve arbeidersovereenkomst (CAO)die op 6 mei 1969 zou aflopen.CFW hanteerde het principe van \"equal work equal pay\" en eiste een loon dat gelijk was met wat de Shell betaalde voordat de banenaan WESCAR werden uitbesteed. Toen WESCAR ditweigerde, kondigde de CFW in de laatste week van mei een algemene staking af voor alle leden.Al gauw volgde een sympathie-staking van de Shell-arbeidersvakbond \"Petroleum Workers Federation of Curaçao\" (PWFC).Politici, journalisten en activisten zoals Stanley Brown, hoofdredacteur van de linkse antikoloniale tijdschrift<em> Vitó</em>,steunden de stakende arbeiders.\r\n\r\n&nbsp;\r\n\r\nOp de ochtend van 30 mei 1969 verzamelden zichongeveer vijfduizend stakers bij de hoofdingang van de Shell-terrein voor een optocht naar Fort Amsterdam, onder leiding van Ewald Ong-a-Kwie, leider van de CFW.De leiders van de havenarbeiders, Wilson \"Papa\" Godett en Amador Nita, sloten zich toen aan bij de optocht. De optocht escaleerde tot een heuse opstand toen bij Parera twee doden vielen, Manuel Gutierez en Orlando Gerardina.Wilson \"Papa\" Godett werd in de rug geraakt door een politiekogel, toen hij met de handen omhoog de menigte probeerde te kalmeren. Na de escalatie stemdenShell en WESCAR alsnog in met de eisen van gelijk loon voor gelijk werk van de CFW<strong>.</strong> Het was echter al te laat. Een woedende meute stroomde Punda en Otrobanda binnen. Gebouwen werden in brand gestoken, en winkels werden geplunderd. De gouverneur kondigde een noodtoestand af, het leger werd ingeschakeld, en mariniers uit Nederland werden ingevlogen om de opstand te bedwingen. Nadat de vakbondsleiders op de radio hadden bekendgemaakt dat Shell en de onderaannemers met de eisen van de vakbonden hadden ingestemd,keerde de rust terug.In de nasleep van de opstand ontstond er een nieuwe politieke partij, \"Frente Obrero Liberashon Trinta di Mei,\" geleid door Wilson Godett, Stanley Brown en Amador Nita, die zou opkomen voor de belangen van de arbeidersklasse.\r\n\r\nMet de loop der jaren werd \"Trinta di Mei\" een symbool voor een langere periode van sociale veranderingsprocessen van de jaren 60, waarbij de raciaal gesegmenteerde koloniale machtsstructuurmoest plaatsmaken voor een politiek klimaat waarin er meer rekening werd gehouden met de belangen van de Afro-Curaçaosearbeidersklasse.In 1994 werd \"Trinta di Mei\" tot nationale herdenkingsdag verklaard. Alhoewel er onder Curaçaoënaars nog steeds meningsverschillen bestaan over de details, wordt \"Trinta Di Mei\" toch beschouwd als een belangrijk keerpunt in de politieke geschiedenis van Curaçao.', '31. Mei 1969', '', 'inherit', 'closed', 'closed', '', '67-revision-v1', '', '', '2017-09-06 21:24:51', '2017-09-06 19:24:51', '', '67', 'http://canon.bramperry.nl/67-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('264', '4', '2017-09-06 21:26:52', '2017-09-06 19:26:52', '30 Mei 1969 (Trinta di Mei)\r\n\r\nWereldwijd, en dus ook op Curaçao, staan de jaren 60 bekend als een tijdperk van maatschappelijke verandering. Talrijke sociale bewegingen ageerden tegen sociale machtsstructuren gebaseerd op kleur, klasse, en geslacht. Op Curaçao wordt er geen ander gebeurtenis sterker geassocieerd met deze periode als de opstand van \"Trinta di Mei,\" 30 Mei 1969.\r\n\r\nDe arbeidsconflicten die tot de opstand van 30 mei 1969 hebben geleid vinden hun oorsprong in de ontwikkelingen van de tweede helft van de jaren 1960. De Shell-olieraffinaderij, toen de grootste werkgever op Curaçao, begon met automatisering en uitbesteding naar verschillende onderaannemers zoals, onder andere, \"Werkspoor Caribbean\" (WESCAR). Door de uitbestending moesten werknemers die eerder voor de Shell hadden gewerkt bij de onderaannemers hetzelfde arbeid verrichten tegen lager loon.\r\n\r\nIn de eerste week van mei 1969 ontstond er een impasse in de onderhandelingentussen WESCAR en de Curaçao Federation of Workers (CFW) over decollectieve arbeidersovereenkomst (CAO)die op 6 mei 1969 zou aflopen.CFW hanteerde het principe van \"equal work equal pay\" en eiste een loon dat gelijk was met wat de Shell betaalde voordat de banenaan WESCAR werden uitbesteed. Toen WESCAR dit weigerde, kondigde de CFW in de laatste week van mei een algemene staking af voor alle leden. Al gauw volgde een sympathie-staking van de Shell-arbeidersvakbond \"Petroleum Workers Federation of Curaçao\" (PWFC). Politici, journalisten en activisten zoals Stanley Brown, hoofdredacteur van de linkse antikoloniale tijdschrift<em> Vitó</em>, steunden de stakende arbeiders.\r\n\r\n&nbsp;\r\n\r\nOp de ochtend van 30 mei 1969 verzamelden zich ongeveer vijfduizend stakers bij de hoofdingang van de Shell-terrein voor een optocht naar Fort Amsterdam, onder leiding van Ewald Ong-a-Kwie, leider van de CFW. De leiders van de havenarbeiders, Wilson \"Papa\" Godett en Amador Nita, sloten zich toen aan bij de optocht. De optocht escaleerde tot een heuse opstand toen bij Parera twee doden vielen, Manuel Gutierez en Orlando Gerardina. Wilson \"Papa\" Godett werd in de rug geraakt door een politiekogel, toen hij met de handen omhoog de menigte probeerde te kalmeren. Na de escalatie stemden Shell en WESCAR alsnog in met de eisen van gelijk loon voor gelijk werk van de CFW<strong>.</strong> Het was echter al te laat. Een woedende meute stroomde Punda en Otrobanda binnen. Gebouwen werden in brand gestoken, en winkels werden geplunderd. De gouverneur kondigde een noodtoestand af, het leger werd ingeschakeld, en mariniers uit Nederland werden ingevlogen om de opstand te bedwingen. Nadat de vakbondsleiders op de radio hadden bekendgemaakt dat Shell en de onderaannemers met de eisen van de vakbonden hadden ingestemd, keerde de rust terug. In de nasleep van de opstand ontstond er een nieuwe politieke partij, \"Frente Obrero Liberashon Trinta di Mei,\" geleid door Wilson Godett, Stanley Brown en Amador Nita, die zou opkomen voor de belangen van de arbeidersklasse.\r\n\r\nMet de loop der jaren werd \"Trinta di Mei\" een symbool voor een langere periode van sociale veranderingsprocessen van de jaren 60, waarbij de raciaal gesegmenteerde koloniale machtsstructuur moest plaatsmaken voor een politiek klimaat waarin er meer rekening werd gehouden met de belangen van de Afro-Curaçaose arbeidersklasse. In 1994 werd \"Trinta di Mei\" tot nationale herdenkingsdag verklaard. Alhoewel er onder Curaçaoënaars nog steeds meningsverschillen bestaan over de details, wordt \"Trinta Di Mei\" toch beschouwd als een belangrijk keerpunt in de politieke geschiedenis van Curaçao.', '31. Mei 1969', '', 'inherit', 'closed', 'closed', '', '67-revision-v1', '', '', '2017-09-06 21:26:52', '2017-09-06 19:26:52', '', '67', 'http://canon.bramperry.nl/67-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('265', '8', '2017-09-06 21:26:56', '2017-09-06 19:26:56', 'Op 6 september 2017 werd een workshop georganiseerd voor\r\n\r\ngeïnteresseerden van de canoncommissie.<img class=\"alignnone  wp-image-201\" src=\"http://canoncuracao.cw/wp-content/uploads/2017/09/bloem-300x300.jpeg\" alt=\"\" width=\"39\" height=\"39\" />', 'Workshop : \"teksten invoeren\"', '', 'inherit', 'closed', 'closed', '', '256-revision-v1', '', '', '2017-09-06 21:26:56', '2017-09-06 19:26:56', '', '256', 'http://canon.bramperry.nl/256-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('266', '7', '2017-09-06 21:37:53', '2017-09-06 19:37:53', '<a href=\"http://canoncuracao.cw/overzicht-van-de-vensters/\">Klik hier voor het tekstuele overzicht</a>\n\nKlik hier voor een overzicht van de belangrijkste jaartallen\n<h2>Nieuws</h2>\nAliquam et lectus in nisi commodo feugiat non sed dolor. Ut maximus maximus elit, vel posuere justo molestie molestie. Praesent varius lobortis hendrerit.', 'Home', '', 'inherit', 'closed', 'closed', '', '2-autosave-v1', '', '', '2017-09-06 21:37:53', '2017-09-06 19:37:53', '', '2', 'http://canon.bramperry.nl/2-autosave-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('267', '7', '2017-09-06 21:37:59', '2017-09-06 19:37:59', '<a href=\"http://canoncuracao.cw/overzicht-van-de-vensters/\">Klik hier voor het tekstuele overzicht</a>\r\n\r\n<a href=\"http://canoncuracao.cw/13-plantagesysteem-op-curacao/\">Klik hier voor een overzicht van de belangrijkste jaartallen</a>', 'Home', '', 'inherit', 'closed', 'closed', '', '2-revision-v1', '', '', '2017-09-06 21:37:59', '2017-09-06 19:37:59', '', '2', 'http://canon.bramperry.nl/2-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('268', '7', '2017-09-06 21:38:44', '2017-09-06 19:38:44', '<h3>Overzicht</h3>\r\n<a href=\"http://canoncuracao.cw/overzicht-van-de-vensters/\">Klik hier voor het tekstuele overzicht</a>\r\n<h3>Jaartallen</h3>\r\n<a href=\"http://canoncuracao.cw/13-plantagesysteem-op-curacao/\">Klik hier voor een overzicht van de belangrijkste jaartallen</a>', 'Home', '', 'inherit', 'closed', 'closed', '', '2-revision-v1', '', '', '2017-09-06 21:38:44', '2017-09-06 19:38:44', '', '2', 'http://canon.bramperry.nl/2-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('269', '8', '2017-09-06 21:38:50', '2017-09-06 19:38:50', 'Fusce nunc risus, varius ut ligula id, varius <a href=\"https://www.readinga-z.com/\">r</a>eadingatoz s. Nulla tincidunt magna id molestie blandit. Nullam non erat dictum arcu imperdiet viverra. Sed eleifend risus felis, nec blandit quam efficitur sed. Phasellus fermentum tortor augue, sit amet interdum turpis congue quis. Aliquam vulputate lacus purus, et tincidunt diam euismod a. Morbi dui nisi, suscipit id nisi quis, ultricies volutpat velit. Integer vehicula lacinia porta. Vestibulum pellentesque nec enim in suscipit. Ut auctor, neque nec porttitor facilisis, mauris est tincidunt nisi, non rhoncus urna turpis ac eros. Proin massa purus, lacinia vitae metus ac, pulvinar ultricies nibh. Morbi dictum sapien mauris. Quisque sapien odio, mollis rutrum volutpat sit amet, fringilla vitae ante.\r\n\r\nNulla sodales vestibulum porttitor. Pellentesque lacinia id purus non accumsan. Mauris pharetra eros sit amet elementum pretium. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum luctus fringilla mauris, sit amet tristique nisi dignissim tincidunt. Suspendisse vel tincidunt urna, ac pulvinar nisl. Cras tempor, felis vitae porttitor scelerisque, ante ex commodo est, in vestibulum dolor eros nec dui. Pellentesque accumsan nulla a leo congue, eget vestibulum purus laoreet. Sed vulputate vehicula felis, vitae interdum tortor vehicula sit amet. Nulla eu tincidunt mi.', '1. De oorspronkelijke bewoners', '', 'inherit', 'closed', 'closed', '', '8-revision-v1', '', '', '2017-09-06 21:38:50', '2017-09-06 19:38:50', '', '8', 'http://canon.bramperry.nl/8-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('270', '7', '2017-09-06 21:39:07', '2017-09-06 19:39:07', '<h2>Overzicht</h2>\r\n<a href=\"http://canoncuracao.cw/overzicht-van-de-vensters/\">Klik hier voor het tekstuele overzicht</a>\r\n<h2>Jaartallen</h2>\r\n<a href=\"http://canoncuracao.cw/13-plantagesysteem-op-curacao/\">Klik hier voor een overzicht van de belangrijkste jaartallen</a>', 'Home', '', 'inherit', 'closed', 'closed', '', '2-revision-v1', '', '', '2017-09-06 21:39:07', '2017-09-06 19:39:07', '', '2', 'http://canon.bramperry.nl/2-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('271', '8', '2017-09-06 21:40:21', '2017-09-06 19:40:21', 'Fusce nunc risus, varius ut ligula id, varius <a href=\"https://www.readinga-z.com/\">r</a>eadingatoz s. Nulla tincidunt magna id molestie blandit. Nullam non erat dictum arcu imperdiet viverra. Sed eleifend risus felis, nec blandit quam efficitur sed. Phasellus fermentum tortor augue, sit amet interdum turpis congue quis. Aliquam vulputate lacus purus, et tincidunt diam euismod a. Morbi dui nisi, suscipit id nisi quis, ultricies volutpat velit. Integer vehicula lacinia porta. Vestibulum pellentesque nec enim in suscipit. Ut auctor, neque nec porttitor facilisis, mauris est tincidunt nisi, non rhoncus urna turpis ac eros. Proin massa purus, lacinia vitae metus ac, pulvinar ultricies nibh. Morbi dictum sapien mauris. Quisque sapien odio, mollis rutrum volutpat sit amet, fringilla vitae ante.\r\n\r\nNulla sodales vestibulum porttitor. Pellentesque lacinia id purus non accumsan. Mauris pharetra eros sit amet elementum pretium. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum luctus fringilla mauris, sit amet tristique nisi dignissim tincidunt. Suspendisse vel tincidunt urna, ac pulvinar nisl. Cras tempor, felis vitae porttitor scelerisque, ante ex commodo est, in vestibulum dolor eros nec dui. Pellentesque accumsan nulla a leo congue, eget vestibulum purus laoreet. Sed vulputate vehicula felis, vitae interdum tortor vehicula sit amet. Nulla eu tincidunt mi.', '1. De oorspronkelijke bewoners', '', 'inherit', 'closed', 'closed', '', '8-revision-v1', '', '', '2017-09-06 21:40:21', '2017-09-06 19:40:21', '', '8', 'http://canon.bramperry.nl/8-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('272', '8', '2017-09-06 21:40:52', '2017-09-06 19:40:52', 'Fusce nunc risus, varius ut ligula id, varius <a href=\"https://www.readinga-z.com/\">r</a>eadingatoz s. Nulla tincidunt magna id molestie blandit. Nullam non erat dictum arcu imperdiet viverra. Sed eleifend risus felis, nec blandit quam efficitur sed. Phasellus fermentum tortor augue, sit amet interdum turpis congue quis. Aliquam vulputate lacus purus, et tincidunt diam euismod a. Morbi dui nisi, suscipit id nisi quis, ultricies volutpat velit. Integer vehicula lacinia porta. Vestibulum pellentesque nec enim in suscipit. Ut auctor, neque nec porttitor facilisis, mauris est tincidunt nisi, non rhoncus urna turpis ac eros. Proin massa purus, lacinia vitae metus ac, pulvinar ultricies nibh. Morbi dictum sapien mauris. Quisque sapien odio, mollis rutrum volutpat sit amet, fringilla vitae ante.\r\n\r\nNulla sodales vestibulum porttitor. Pellentesque lacinia id purus non accumsan. Mauris pharetra eros sit amet elementum pretium. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum luctus fringilla mauris, sit amet tristique nisi dignissim tincidunt. Suspendisse vel tincidunt urna, ac pulvinar nisl. Cras tempor, felis vitae porttitor scelerisque, ante ex commodo est, in vestibulum dolor eros nec dui. Pellentesque accumsan nulla a leo congue, eget vestibulum purus laoreet. Sed vulputate vehicula felis, vitae interdum tortor vehicula sit amet. Nulla eu tincidunt mi.', '1. De oorspronkelijke bewoners', '', 'inherit', 'closed', 'closed', '', '8-revision-v1', '', '', '2017-09-06 21:40:52', '2017-09-06 19:40:52', '', '8', 'http://canon.bramperry.nl/8-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('273', '8', '2017-09-06 21:41:21', '2017-09-06 19:41:21', 'Fusce nunc risus, varius ut ligula id, varius <a href=\"https://www.readinga-z.com/\">r</a>eadingatoz s. Nulla tincidunt magna id molestie blandit. Nullam non erat dictum arcu imperdiet viverra. Sed eleifend risus felis, nec blandit quam efficitur sed. Phasellus fermentum tortor augue, sit amet interdum turpis congue quis. Aliquam vulputate lacus purus, et tincidunt diam euismod a. Morbi dui nisi, suscipit id nisi quis, ultricies volutpat velit. Integer vehicula lacinia porta. Vestibulum pellentesque nec enim in suscipit. Ut auctor, neque nec porttitor facilisis, mauris est tincidunt nisi, non rhoncus urna turpis ac eros. Proin massa purus, lacinia vitae metus ac, pulvinar ultricies nibh. Morbi dictum sapien mauris. Quisque sapien odio, mollis rutrum volutpat sit amet, fringilla vitae ante.\r\n\r\nNulla sodales vestibulum porttitor. Pellentesque lacinia id purus non accumsan. Mauris pharetra eros sit amet elementum pretium. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum luctus fringilla mauris, sit amet tristique nisi dignissim tincidunt. Suspendisse vel tincidunt urna, ac pulvinar nisl. Cras tempor, felis vitae porttitor scelerisque, ante ex commodo est, in vestibulum dolor eros nec dui. Pellentesque accumsan nulla a leo congue, eget vestibulum purus laoreet. Sed vulputate vehicula felis, vitae interdum tortor vehicula sit amet. Nulla eu tincidunt mi.', '1. De oorspronkelijke bewoners', '', 'inherit', 'closed', 'closed', '', '8-revision-v1', '', '', '2017-09-06 21:41:21', '2017-09-06 19:41:21', '', '8', 'http://canon.bramperry.nl/8-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('274', '8', '2017-09-06 21:44:51', '2017-09-06 19:44:51', 'Fusce nunc risus, varius ut ligula id, varius <a href=\"https://www.readinga-z.com/\">r</a>eadingatoz s. Nulla tincidunt magna id molestie blandit. Nullam non erat dictum arcu imperdiet viverra. Sed eleifend risus felis, nec blandit quam efficitur sed. Phasellus fermentum tortor augue, sit amet interdum turpis congue quis. Aliquam vulputate lacus purus, et tincidunt diam euismod a. Morbi dui nisi, suscipit id nisi quis, ultricies volutpat velit. Integer vehicula lacinia porta. Vestibulum pellentesque nec enim in suscipit. Ut auctor, neque nec porttitor facilisis, mauris est tincidunt nisi, non rhoncus urna turpis ac eros. Proin massa purus, lacinia vitae metus ac, pulvinar ultricies nibh. Morbi dictum sapien mauris. Quisque sapien odio, mollis rutrum volutpat sit amet, fringilla vitae ante.\r\n\r\nNulla sodales vestibulum porttitor. Pellentesque lacinia id purus non accumsan. Mauris pharetra eros sit amet elementum pretium. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum luctus fringilla mauris, sit amet tristique nisi dignissim tincidunt. Suspendisse vel tincidunt urna, ac pulvinar nisl. Cras tempor, felis vitae porttitor scelerisque, ante ex commodo est, in vestibulum dolor eros nec dui. Pellentesque accumsan nulla a leo congue, eget vestibulum purus laoreet. Sed vulputate vehicula felis, vitae interdum tortor vehicula sit amet. Nulla eu tincidunt mi.', '1. De oorspronkelijke bewoners', '', 'inherit', 'closed', 'closed', '', '8-revision-v1', '', '', '2017-09-06 21:44:51', '2017-09-06 19:44:51', '', '8', 'http://canon.bramperry.nl/8-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('275', '1', '2017-09-07 16:50:53', '2017-09-07 14:50:53', '16 Gebouwen\r\n\r\nFort Amsterdam is het oudste gebouw op Curaçao. Het werd in 1635, een jaar nadat de West- Indische Compagnie het eiland op de Spanjaarden had veroverd, gebouwd op de oostelijke oever van de Sint Annabaai. Dit betekent dat op Curaçao geen bouwwerken bewaard zijn gebleven uit de Spaanse periode (1499-1634) en evenmin uit de precolumbiaanse tijd.\r\n\r\nAan de noordzijde van Fort Amsterdam ontstond in de loop van de 17<sup>e</sup> eeuw een kleine nederzetting die ‘De Willemstad’ werd genoemd. De eerste huizen die hier werden gebouwd zijn beïnvloed door de architectuur uit Amsterdam. Kenmerkend zijn de hoge smalle voorgevels en de diepe zijgevels. De voorgevels zijn voorzien van tuitgevels waarop een rechthoekig lijstwerk is geplaatst met daarop een klein fronton. Deze eerste bouwstijl uit de zeventiende eeuw, die de Curaçaos-Hollandse stijl wordt genoemd, werd niet alleen toegepast in Willemstad maar ook bij de huizen op de plantages, de landhuizen.\r\n\r\nEen kenmerkend onderdeel van de traditionele architectuur op Curaçao zijn de galerijen. Dit waren aanvankelijk open houten of stenen constructies die tegen de voorgevels van de huizen in de stad werden geplaatst om de zon te weren. Later werden galerijen een structureel onderdeel van gebouwen zowel binnen als buiten de stad.\r\n\r\nIn de achttiende eeuw kwam de Curaçaose Barok in de mode met zijn sierlijke gebogen gevellijnen en arcades. Deze uitbundige bouwstijl werd in de eerste helft van de 19<sup>e</sup> eeuw afgewisseld door een sobere bouwstijl die weer teruggreep op de tuitgevel uit de 17<sup>e</sup> eeuw. De afmeting en detaillering was echter eenvoudiger geworden en kan daarom onderscheiden worden van de oudere stijl.\r\n\r\nDoor invloeden vanuit Nederland en de VS ontwikkelde zich in de tweede helft van de negentiende eeuw het ‘neoclassicisme’, een bouwstijl die gebaseerd was op de architectuur van de Grieken en Romeinen. De meest kenmerkende elementen van deze stijl waren de toepassing van zuilen en frontons (driehoeken). Het classicisme werd gebruikt voor zowel stadsvilla’s als eenvoudige woonhuizen en eveneens voor landhuizen.\r\n\r\nIn de eerste helft van de twintigste eeuw kwam Curaçao in contact met de internationale bouwstijl, die ook wel het ‘nieuwe bouwen’ wordt genoemd. Ook in deze periode zijn er duidelijke invloeden in de bouwkunst waar te nemen uit zowel Europa als de VS. Zo is bijvoorbeeld de voorgevel van de voormalige bioscoop Cinelandia geïnspireerd door de Art Deco architectuur in Miami en het voormalige KNSM-gebouw door de architectuur van de Nederlandse architect Dudoc.\r\n\r\nDe gebouwen op Curaçao hebben een Caraïbisch karakter gekregen door de invloeden van een multiculturele samenleving en het klimaat. De opvallende bonte kleuren op de gevels gaan terug op een verordening uit 1817, toen gouverneur Kikkert de eigenaren verplichte om de wit gekalkte voorgevels in binnenstad een kleur te geven.\r\n\r\nNB vragen of Gerda een alinea kan toevoegen over de huizen van het ‘gewone volk’, zoals knoekhuizen, houten huizen, huizen van blik.\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\nDe Spaanse periode  Sed accumsan quam suscipit finibus molestie. In sollicitudin augue vitae tellus efficitur mollis. Vivamus vel vulputate tortor. Cras ac massa ex. Pellentesque sit amet massa sed ante consequat condimentum nec laoreet risus. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum in massa vel ex sodales semper in ac urna. Nullam at pulvinar ligula. Integer commodo felis et purus vestibulum, id porta nibh sollicitudin.\r\n\r\nFusce efficitur ac est sit amet ultricies. Maecenas gravida, arcu pellentesque congue tempus, nunc lacus gravida libero, in vestibulum purus tortor vitae elit. Nullam sit amet risus at turpis faucibus scelerisque et dapibus ante. Suspendisse non dolor mattis, finibus diam et, varius est. Curabitur suscipit tincidunt leo vel tristique. Phasellus molestie consectetur orci, eget maximus lorem malesuada ut. Nulla laoreet mattis pretium. Vestibulum placerat eu dolor laoreet accumsan. Ut varius purus in orci tempor vulputate. Curabitur consectetur tellus orci, at finibus enim pharetra sit amet. Vestibulum ligula purus, sodales lacinia magna in, aliquam ultrices ipsum.', '2. De Spaanse periode', '', 'inherit', 'closed', 'closed', '', '10-revision-v1', '', '', '2017-09-07 16:50:53', '2017-09-07 14:50:53', '', '10', 'http://canon.bramperry.nl/10-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('277', '1', '2017-09-07 17:32:51', '2017-09-07 15:32:51', '', 'logo-nl@2x', '', 'inherit', 'open', 'closed', '', 'logo-nl2x', '', '', '2017-09-07 17:32:51', '2017-09-07 15:32:51', '', '0', 'http://canoncuracao.cw/wp-content/uploads/2017/09/logo-nl@2x.png', '0', 'attachment', 'image/png', '0');
INSERT INTO `wp_posts` VALUES('278', '1', '2017-09-07 19:17:06', '2017-09-07 17:17:06', '<h2>Overzicht</h2>\n<a href=\"http://canoncuracao.cw/overzicht-van-de-vensters/\">Klik hier voor het tekstuele overzicht</a>\n<h2>Jaartallen</h2>\n<a href=\"http://canoncuracao.cw/13-plantagesysteem-op-curacao/\">Klik hier voor een overzicht van de belangrijkste jaartallen</a>', 'Home', '', 'inherit', 'closed', 'closed', '', '2-autosave-v1', '', '', '2017-09-07 19:17:06', '2017-09-07 17:17:06', '', '2', 'https://canoncuracao.cw/2-autosave-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('279', '1', '2017-09-07 19:17:48', '2017-09-07 17:17:48', '<ul>\r\n 	<li><a href=\"http://canoncuracao.cw/overzicht-van-de-vensters/\">Tekstuele overzicht van alle vensters</a></li>\r\n 	<li><a href=\"http://canoncuracao.cw/13-plantagesysteem-op-curacao/\">Overzicht van de belangrijkste jaartallen</a></li>\r\n</ul>', 'Home', '', 'inherit', 'closed', 'closed', '', '2-revision-v1', '', '', '2017-09-07 19:17:48', '2017-09-07 17:17:48', '', '2', 'https://canoncuracao.cw/2-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('280', '1', '2017-09-07 19:18:17', '2017-09-07 17:18:17', '<a href=\"http://canoncuracao.cw/overzicht-van-de-vensters/\">Tekstuele overzicht van alle vensters</a>\r\n\r\n<a href=\"http://canoncuracao.cw/13-plantagesysteem-op-curacao/\">Overzicht van de belangrijkste jaartallen</a>', 'Home', '', 'inherit', 'closed', 'closed', '', '2-revision-v1', '', '', '2017-09-07 19:18:17', '2017-09-07 17:18:17', '', '2', 'https://canoncuracao.cw/2-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('281', '1', '2017-09-07 19:25:40', '2017-09-07 17:25:40', '<a href=\"http://canoncuracao.cw/overzicht-van-de-vensters/\">Lijst met alle vensters</a>\r\n\r\n<a href=\"http://canoncuracao.cw/13-plantagesysteem-op-curacao/\">Belangrijkste jaartallen</a>', 'Home', '', 'inherit', 'closed', 'closed', '', '2-revision-v1', '', '', '2017-09-07 19:25:40', '2017-09-07 17:25:40', '', '2', 'https://canoncuracao.cw/2-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('282', '4', '2017-09-10 01:11:07', '2017-09-09 23:11:07', '', '836 Asiento2 - 1918 nr 1 is 1914', '', 'inherit', 'open', 'closed', '', '836-asiento2-1918-nr-1-is-1914', '', '', '2017-09-10 01:11:30', '2017-09-09 23:11:30', '', '47', 'https://canoncuracao.cw/wp-content/uploads/2017/05/836-Asiento2-1918-nr-1-is-1914.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('283', '4', '2017-09-10 01:11:37', '2017-09-09 23:11:37', 'In 1912 had Shell een concessie verworven in het Mene Grande-veld, ten Oosten van het Meer van Maracaibo in Venezuela. Toen in 1914 duidelijk werd dat dit veld boordevol olie zat, had Shell al besloten om een kleine opslagplaats op Curaçao te bouwen. Een jaar later werd besloten er een raffinaderij te vestigen. De slechte bereikbaarheid van het Meer van Maracaibo en het stabiele bestuur van Curaçao, speelde een rol in deze keuze.\r\n\r\nIn de eerste jaren werd op Curaçao nog voor een groot deel olie uit Mexico verwerkt. Nadat Mexico in 1938 de olie industrie nationaliseerde, ging Shell exclusief Venezolaanse olie verwerken.\r\n\r\nTot het einde van 1920 waren er minder dan 300 mensen in dienst van de raffinaderij. Het zou uitgroeien tot 10.924 (inclusief de Curaçaosche Scheepvaart Maatschappij) in 1929. In die jaren werden arbeiders geworven uit de regio en uit Portugal. Al deze arbeiders werden in nieuwe wijken gehuisvest, niet ver van het raffinaderijcomplex. Daarbij werden ook allerlei voorzieningen gebouwd zoals wegen, scholen, winkels, buurtcentra, telefoon- en waterleidingen.\r\n\r\nDe economische crisis van de jaren dertig bracht het personeelsbestand drastisch terug en zou vanaf 1934 geleidelijk weer toenemen. Pas na 1945 kwam het personeelsaantal weer boven de 10.000 uit.\r\n\r\nIn de oorlogsjaren speelden de raffinaderijen op de Antillen een belangrijke rol voor de brandstofvoorziening van de Geallieerden. Duitsland zette vanaf februari 1942 duikboten in rond Curaçao en Aruba om deze brandstoftoevoer af te snijden. In de oorlogsjaren kreeg de raffinaderij toestemming een zogenaamd “asfalt-meer” aan te leggen vanwege het gebrek aan schepen om het te vervoeren.\r\n\r\nIn Venezuela werden de activiteiten op Curaçao en Aruba met jaloezie en afgunst bekeken. Na 1935 was het sentiment gekeerd tegen de “uitverkoop van nationale rijkdom”. In 1943 werd daarom wetgeving aangenomen waardoor de Antilliaanse raffinaderijen geen olie uit nieuwe concessies mochten verwerken. Shell werd gedwongen te investeren in een nieuwe raffinaderij in Venezuela. Dat werd de raffinaderij van Cardón, die in 1947 opstartte.\r\n\r\nZo werd Shell in de jaren vijftig gedwongen haar raffinaderij op Curaçao af te slanken. In 1959 speelde ook de Amerikaanse import restricties op olieproducten de kop op. Op verzoek van m.n. de Texaanse olieproducenten ging Amerika over op importquota.\r\n\r\nIn de jaren zestig werd het systeem van “onderaannemers” ingevoerd waarbij arbeiders via externe bedrijven werden ingehuurd. Doordat de onderaannemers minder betaalden dan Shell, leidde dit tot een uitbarsting die bekend werd onder de naam “<a href=\"http://canoncuracao.cw/31-mei-1969/\">30 mei 1969</a>”.', '21. De komst van de olie-industrie', '', 'inherit', 'closed', 'closed', '', '47-revision-v1', '', '', '2017-09-10 01:11:37', '2017-09-09 23:11:37', '', '47', 'https://canoncuracao.cw/47-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('284', '4', '2017-09-10 01:12:45', '2017-09-09 23:12:45', '', '840 coll van leeuwen', '', 'inherit', 'open', 'closed', '', '840-coll-van-leeuwen', '', '', '2017-09-10 01:12:56', '2017-09-09 23:12:56', '', '47', 'https://canoncuracao.cw/wp-content/uploads/2017/05/840-coll-van-leeuwen.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('285', '4', '2017-09-10 01:13:06', '2017-09-09 23:13:06', 'In 1912 had Shell een concessie verworven in het Mene Grande-veld, ten Oosten van het Meer van Maracaibo in Venezuela. Toen in 1914 duidelijk werd dat dit veld boordevol olie zat, had Shell al besloten om een kleine opslagplaats op Curaçao te bouwen. Een jaar later werd besloten er een raffinaderij te vestigen. De slechte bereikbaarheid van het Meer van Maracaibo en het stabiele bestuur van Curaçao, speelde een rol in deze keuze.\r\n\r\nIn de eerste jaren werd op Curaçao nog voor een groot deel olie uit Mexico verwerkt. Nadat Mexico in 1938 de olie industrie nationaliseerde, ging Shell exclusief Venezolaanse olie verwerken.\r\n\r\nTot het einde van 1920 waren er minder dan 300 mensen in dienst van de raffinaderij. Het zou uitgroeien tot 10.924 (inclusief de Curaçaosche Scheepvaart Maatschappij) in 1929. In die jaren werden arbeiders geworven uit de regio en uit Portugal. Al deze arbeiders werden in nieuwe wijken gehuisvest, niet ver van het raffinaderijcomplex. Daarbij werden ook allerlei voorzieningen gebouwd zoals wegen, scholen, winkels, buurtcentra, telefoon- en waterleidingen.\r\n\r\nDe economische crisis van de jaren dertig bracht het personeelsbestand drastisch terug en zou vanaf 1934 geleidelijk weer toenemen. Pas na 1945 kwam het personeelsaantal weer boven de 10.000 uit.\r\n\r\nIn de oorlogsjaren speelden de raffinaderijen op de Antillen een belangrijke rol voor de brandstofvoorziening van de Geallieerden. Duitsland zette vanaf februari 1942 duikboten in rond Curaçao en Aruba om deze brandstoftoevoer af te snijden. In de oorlogsjaren kreeg de raffinaderij toestemming een zogenaamd “asfalt-meer” aan te leggen vanwege het gebrek aan schepen om het te vervoeren.\r\n\r\nIn Venezuela werden de activiteiten op Curaçao en Aruba met jaloezie en afgunst bekeken. Na 1935 was het sentiment gekeerd tegen de “uitverkoop van nationale rijkdom”. In 1943 werd daarom wetgeving aangenomen waardoor de Antilliaanse raffinaderijen geen olie uit nieuwe concessies mochten verwerken. Shell werd gedwongen te investeren in een nieuwe raffinaderij in Venezuela. Dat werd de raffinaderij van Cardón, die in 1947 opstartte.\r\n\r\nZo werd Shell in de jaren vijftig gedwongen haar raffinaderij op Curaçao af te slanken. In 1959 speelde ook de Amerikaanse import restricties op olieproducten de kop op. Op verzoek van m.n. de Texaanse olieproducenten ging Amerika over op importquota.\r\n\r\nIn de jaren zestig werd het systeem van “onderaannemers” ingevoerd waarbij arbeiders via externe bedrijven werden ingehuurd. Doordat de onderaannemers minder betaalden dan Shell, leidde dit tot een uitbarsting die bekend werd onder de naam “<a href=\"http://canoncuracao.cw/31-mei-1969/\">30 mei 1969</a>”.', '21. De komst van de olie-industrie', '', 'inherit', 'closed', 'closed', '', '47-revision-v1', '', '', '2017-09-10 01:13:06', '2017-09-09 23:13:06', '', '47', 'https://canoncuracao.cw/47-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('287', '4', '2017-09-10 01:16:03', '2017-09-09 23:16:03', '', '847 coll van leeuwen', '', 'inherit', 'open', 'closed', '', '847-coll-van-leeuwen', '', '', '2017-09-10 01:16:19', '2017-09-09 23:16:19', '', '47', 'https://canoncuracao.cw/wp-content/uploads/2017/05/847-coll-van-leeuwen.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('288', '4', '2017-09-10 01:28:15', '2017-09-09 23:28:15', '', '840 coll van leeuwen_1', '', 'inherit', 'open', 'closed', '', '840-coll-van-leeuwen_1', '', '', '2017-09-10 01:28:21', '2017-09-09 23:28:21', '', '47', 'https://canoncuracao.cw/wp-content/uploads/2017/05/840-coll-van-leeuwen_1.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('289', '4', '2017-09-10 01:28:25', '2017-09-09 23:28:25', 'In 1912 had Shell een concessie verworven in het Mene Grande-veld, ten Oosten van het Meer van Maracaibo in Venezuela. Toen in 1914 duidelijk werd dat dit veld boordevol olie zat, had Shell al besloten om een kleine opslagplaats op Curaçao te bouwen. Een jaar later werd besloten er een raffinaderij te vestigen. De slechte bereikbaarheid van het Meer van Maracaibo en het stabiele bestuur van Curaçao, speelde een rol in deze keuze.\r\n\r\nIn de eerste jaren werd op Curaçao nog voor een groot deel olie uit Mexico verwerkt. Nadat Mexico in 1938 de olie industrie nationaliseerde, ging Shell exclusief Venezolaanse olie verwerken.\r\n\r\nTot het einde van 1920 waren er minder dan 300 mensen in dienst van de raffinaderij. Het zou uitgroeien tot 10.924 (inclusief de Curaçaosche Scheepvaart Maatschappij) in 1929. In die jaren werden arbeiders geworven uit de regio en uit Portugal. Al deze arbeiders werden in nieuwe wijken gehuisvest, niet ver van het raffinaderijcomplex. Daarbij werden ook allerlei voorzieningen gebouwd zoals wegen, scholen, winkels, buurtcentra, telefoon- en waterleidingen.\r\n\r\nDe economische crisis van de jaren dertig bracht het personeelsbestand drastisch terug en zou vanaf 1934 geleidelijk weer toenemen. Pas na 1945 kwam het personeelsaantal weer boven de 10.000 uit.\r\n\r\nIn de oorlogsjaren speelden de raffinaderijen op de Antillen een belangrijke rol voor de brandstofvoorziening van de Geallieerden. Duitsland zette vanaf februari 1942 duikboten in rond Curaçao en Aruba om deze brandstoftoevoer af te snijden. In de oorlogsjaren kreeg de raffinaderij toestemming een zogenaamd “asfalt-meer” aan te leggen vanwege het gebrek aan schepen om het te vervoeren.\r\n\r\nIn Venezuela werden de activiteiten op Curaçao en Aruba met jaloezie en afgunst bekeken. Na 1935 was het sentiment gekeerd tegen de “uitverkoop van nationale rijkdom”. In 1943 werd daarom wetgeving aangenomen waardoor de Antilliaanse raffinaderijen geen olie uit nieuwe concessies mochten verwerken. Shell werd gedwongen te investeren in een nieuwe raffinaderij in Venezuela. Dat werd de raffinaderij van Cardón, die in 1947 opstartte.\r\n\r\nZo werd Shell in de jaren vijftig gedwongen haar raffinaderij op Curaçao af te slanken. In 1959 speelde ook de Amerikaanse import restricties op olieproducten de kop op. Op verzoek van m.n. de Texaanse olieproducenten ging Amerika over op importquota.\r\n\r\nIn de jaren zestig werd het systeem van “onderaannemers” ingevoerd waarbij arbeiders via externe bedrijven werden ingehuurd. Doordat de onderaannemers minder betaalden dan Shell, leidde dit tot een uitbarsting die bekend werd onder de naam “<a href=\"http://canoncuracao.cw/31-mei-1969/\">30 mei 1969</a>”.', '21. De komst van de olie-industrie', '', 'inherit', 'closed', 'closed', '', '47-revision-v1', '', '', '2017-09-10 01:28:25', '2017-09-09 23:28:25', '', '47', 'https://canoncuracao.cw/47-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('291', '4', '2017-09-10 01:30:49', '2017-09-09 23:30:49', '', '845 coll van leeuwen_1', '', 'inherit', 'open', 'closed', '', '845-coll-van-leeuwen_1', '', '', '2017-09-10 01:30:55', '2017-09-09 23:30:55', '', '47', 'https://canoncuracao.cw/wp-content/uploads/2017/05/845-coll-van-leeuwen_1.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('292', '4', '2017-09-10 01:31:05', '2017-09-09 23:31:05', 'In 1912 had Shell een concessie verworven in het Mene Grande-veld, ten Oosten van het Meer van Maracaibo in Venezuela. Toen in 1914 duidelijk werd dat dit veld boordevol olie zat, had Shell al besloten om een kleine opslagplaats op Curaçao te bouwen. Een jaar later werd besloten er een raffinaderij te vestigen. De slechte bereikbaarheid van het Meer van Maracaibo en het stabiele bestuur van Curaçao, speelde een rol in deze keuze.\r\n\r\nIn de eerste jaren werd op Curaçao nog voor een groot deel olie uit Mexico verwerkt. Nadat Mexico in 1938 de olie industrie nationaliseerde, ging Shell exclusief Venezolaanse olie verwerken.\r\n\r\nTot het einde van 1920 waren er minder dan 300 mensen in dienst van de raffinaderij. Het zou uitgroeien tot 10.924 (inclusief de Curaçaosche Scheepvaart Maatschappij) in 1929. In die jaren werden arbeiders geworven uit de regio en uit Portugal. Al deze arbeiders werden in nieuwe wijken gehuisvest, niet ver van het raffinaderijcomplex. Daarbij werden ook allerlei voorzieningen gebouwd zoals wegen, scholen, winkels, buurtcentra, telefoon- en waterleidingen.\r\n\r\nDe economische crisis van de jaren dertig bracht het personeelsbestand drastisch terug en zou vanaf 1934 geleidelijk weer toenemen. Pas na 1945 kwam het personeelsaantal weer boven de 10.000 uit.\r\n\r\nIn de oorlogsjaren speelden de raffinaderijen op de Antillen een belangrijke rol voor de brandstofvoorziening van de Geallieerden. Duitsland zette vanaf februari 1942 duikboten in rond Curaçao en Aruba om deze brandstoftoevoer af te snijden. In de oorlogsjaren kreeg de raffinaderij toestemming een zogenaamd “asfalt-meer” aan te leggen vanwege het gebrek aan schepen om het te vervoeren.\r\n\r\nIn Venezuela werden de activiteiten op Curaçao en Aruba met jaloezie en afgunst bekeken. Na 1935 was het sentiment gekeerd tegen de “uitverkoop van nationale rijkdom”. In 1943 werd daarom wetgeving aangenomen waardoor de Antilliaanse raffinaderijen geen olie uit nieuwe concessies mochten verwerken. Shell werd gedwongen te investeren in een nieuwe raffinaderij in Venezuela. Dat werd de raffinaderij van Cardón, die in 1947 opstartte.\r\n\r\nZo werd Shell in de jaren vijftig gedwongen haar raffinaderij op Curaçao af te slanken. In 1959 speelde ook de Amerikaanse import restricties op olieproducten de kop op. Op verzoek van m.n. de Texaanse olieproducenten ging Amerika over op importquota.\r\n\r\nIn de jaren zestig werd het systeem van “onderaannemers” ingevoerd waarbij arbeiders via externe bedrijven werden ingehuurd. Doordat de onderaannemers minder betaalden dan Shell, leidde dit tot een uitbarsting die bekend werd onder de naam “<a href=\"http://canoncuracao.cw/31-mei-1969/\">30 mei 1969</a>”.', '21. De komst van de olie-industrie', '', 'inherit', 'closed', 'closed', '', '47-revision-v1', '', '', '2017-09-10 01:31:05', '2017-09-09 23:31:05', '', '47', 'https://canoncuracao.cw/47-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('294', '4', '2017-09-10 01:34:17', '2017-09-09 23:34:17', 'In 1912 had Shell een concessie verworven in het Mene Grande-veld, ten Oosten van het Meer van Maracaibo in Venezuela. Toen in 1914 duidelijk werd dat dit veld boordevol olie zat, had Shell al besloten om een kleine opslagplaats op Curaçao te bouwen. Een jaar later werd besloten er een raffinaderij te vestigen. De slechte bereikbaarheid van het Meer van Maracaibo en het stabiele bestuur van Curaçao, speelde een rol in deze keuze.\r\n\r\nIn de eerste jaren werd op Curaçao nog voor een groot deel olie uit Mexico verwerkt. Nadat Mexico in 1938 de olie industrie nationaliseerde, ging Shell exclusief Venezolaanse olie verwerken.\r\n\r\nTot het einde van 1920 waren er minder dan 300 mensen in dienst van de raffinaderij. Het zou uitgroeien tot 10.924 (inclusief de Curaçaosche Scheepvaart Maatschappij) in 1929. In die jaren werden arbeiders geworven uit de regio en uit Portugal. Al deze arbeiders werden in nieuwe wijken gehuisvest, niet ver van het raffinaderijcomplex. Daarbij werden ook allerlei voorzieningen gebouwd zoals wegen, scholen, winkels, buurtcentra, telefoon- en waterleidingen.\r\n\r\nDe economische crisis van de jaren dertig bracht het personeelsbestand drastisch terug en zou vanaf 1934 geleidelijk weer toenemen. Pas na 1945 kwam het personeelsaantal weer boven de 10.000 uit.\r\n\r\nIn de oorlogsjaren speelden de raffinaderijen op de Antillen een belangrijke rol voor de brandstofvoorziening van de Geallieerden. Duitsland zette vanaf februari 1942 duikboten in rond Curaçao en Aruba om deze brandstoftoevoer af te snijden. In de oorlogsjaren kreeg de raffinaderij toestemming een zogenaamd “asfalt-meer” aan te leggen vanwege het gebrek aan schepen om het te vervoeren.\r\n\r\nIn Venezuela werden de activiteiten op Curaçao en Aruba met jaloezie en afgunst bekeken. Na 1935 was het sentiment gekeerd tegen de “uitverkoop van nationale rijkdom”. In 1943 werd daarom wetgeving aangenomen waardoor de Antilliaanse raffinaderijen geen olie uit nieuwe concessies mochten verwerken. Shell werd gedwongen te investeren in een nieuwe raffinaderij in Venezuela. Dat werd de raffinaderij van Cardón, die in 1947 opstartte.\r\n\r\nZo werd Shell in de jaren vijftig gedwongen haar raffinaderij op Curaçao af te slanken. In 1959 speelde ook de Amerikaanse import restricties op olieproducten de kop op. Op verzoek van m.n. de Texaanse olieproducenten ging Amerika over op importquota.\r\n\r\nIn de jaren zestig werd het systeem van “onderaannemers” ingevoerd waarbij arbeiders via externe bedrijven werden ingehuurd. Doordat de onderaannemers minder betaalden dan Shell, leidde dit tot een uitbarsting die bekend werd onder de naam “<a href=\"http://canoncuracao.cw/31-mei-1969/\">30 mei 1969</a>”.', '21. De komst van de olie-industrie', '', 'inherit', 'closed', 'closed', '', '47-revision-v1', '', '', '2017-09-10 01:34:17', '2017-09-09 23:34:17', '', '47', 'https://canoncuracao.cw/47-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('297', '4', '2017-09-10 01:52:20', '2017-09-09 23:52:20', '', 'Staatsblad1', '', 'inherit', 'open', 'closed', '', 'staatsblad1', '', '', '2017-09-10 01:52:28', '2017-09-09 23:52:28', '', '33', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Staatsblad1.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('298', '4', '2017-09-10 01:52:44', '2017-09-09 23:52:44', '', '14. De afschaffing van de slavernij', '', 'inherit', 'closed', 'closed', '', '33-revision-v1', '', '', '2017-09-10 01:52:44', '2017-09-09 23:52:44', '', '33', 'https://canoncuracao.cw/33-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('300', '4', '2017-09-10 02:00:31', '2017-09-10 00:00:31', '', 'fischer env 10', '', 'inherit', 'open', 'closed', '', 'fischer-env-10', '', '', '2017-09-10 02:00:38', '2017-09-10 00:00:38', '', '43', 'https://canoncuracao.cw/wp-content/uploads/2017/05/fischer-env-10.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('301', '4', '2017-09-10 02:00:43', '2017-09-10 00:00:43', '', '19. Mijnbouw', '', 'inherit', 'closed', 'closed', '', '43-revision-v1', '', '', '2017-09-10 02:00:43', '2017-09-10 00:00:43', '', '43', 'https://canoncuracao.cw/43-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('303', '4', '2017-09-10 02:04:27', '2017-09-10 00:04:27', '', '19. Mijnbouw', '', 'inherit', 'closed', 'closed', '', '43-revision-v1', '', '', '2017-09-10 02:04:27', '2017-09-10 00:04:27', '', '43', 'https://canoncuracao.cw/43-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('305', '4', '2017-09-10 02:05:46', '2017-09-10 00:05:46', '', '19. Mijnbouw', '', 'inherit', 'closed', 'closed', '', '43-revision-v1', '', '', '2017-09-10 02:05:46', '2017-09-10 00:05:46', '', '43', 'https://canoncuracao.cw/43-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('307', '4', '2017-09-10 02:17:28', '2017-09-10 00:17:28', '', 'Foto 456', '', 'inherit', 'open', 'closed', '', 'foto-456', '', '', '2017-09-10 02:17:34', '2017-09-10 00:17:34', '', '45', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Foto-456.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('308', '4', '2017-09-10 02:17:37', '2017-09-10 00:17:37', '', '20. De komst van de religieuze ordes uit Nederland en hun betekenis', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2017-09-10 02:17:37', '2017-09-10 00:17:37', '', '45', 'https://canoncuracao.cw/45-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('309', '4', '2017-09-10 02:18:43', '2017-09-10 00:18:43', '', '20. De komst van de religieuze ordes uit Nederland en hun betekenis', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2017-09-10 02:18:43', '2017-09-10 00:18:43', '', '45', 'https://canoncuracao.cw/45-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('310', '4', '2017-09-10 02:35:55', '2017-09-10 00:35:55', '', 'Foto 409', '', 'inherit', 'open', 'closed', '', 'foto-409', '', '', '2017-09-10 02:36:01', '2017-09-10 00:36:01', '', '45', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Foto-409.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('311', '4', '2017-09-10 02:36:14', '2017-09-10 00:36:14', '', '20. De komst van de religieuze ordes uit Nederland en hun betekenis', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2017-09-10 02:36:14', '2017-09-10 00:36:14', '', '45', 'https://canoncuracao.cw/45-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('312', '4', '2017-09-10 02:37:43', '2017-09-10 00:37:43', '', 'Foto 382', '', 'inherit', 'open', 'closed', '', 'foto-382', '', '', '2017-09-10 02:37:47', '2017-09-10 00:37:47', '', '45', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Foto-382.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('313', '4', '2017-09-10 02:38:04', '2017-09-10 00:38:04', '', '20. De komst van de religieuze ordes uit Nederland en hun betekenis', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2017-09-10 02:38:04', '2017-09-10 00:38:04', '', '45', 'https://canoncuracao.cw/45-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('316', '4', '2017-09-10 02:46:28', '2017-09-10 00:46:28', '', 'H8 2 Maria met PdVSA mensen', '', 'inherit', 'open', 'closed', '', 'h8-2-maria-met-pdvsa-mensen', '', '', '2017-09-10 02:46:32', '2017-09-10 00:46:32', '', '71', 'https://canoncuracao.cw/wp-content/uploads/2017/05/H8-2-Maria-met-PdVSA-mensen.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('317', '4', '2017-09-10 02:47:04', '2017-09-10 00:47:04', '', 'Refinery Instalation 1989 - 1990 010', '', 'inherit', 'open', 'closed', '', 'refinery-instalation-1989-1990-010', '', '', '2017-09-10 02:47:14', '2017-09-10 00:47:14', '', '71', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Refinery-Instalation-1989-1990-010.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('318', '4', '2017-09-10 02:47:58', '2017-09-10 00:47:58', 'Venezuela nationaliseerde de olie-industrie in 1976. Daarmee werd voor Shell voor het eerst sinds 1915 de keten van productie en verwerking die beide in beheer van Shell waren, verbroken. Samen met de afnemende hoeveelheid olie uit Venezuela en stijgende inkoopprijzen kwam een scenario voor vertrek voor Shell steeds nadrukkelijker in beeld.\r\n\r\nIn 1977 kwam Venezuela met een voorstel tot wederzijdse participatie van de Venezolaanse staatsoliemaatschappij en Shell in de raffinaderijen van Cardón en Curaçao, waar Shell echter niet op in is gegaan. Venezuela daarentegen ging niet in op de wensen van Shell Curaçao om preferente prijzen te berekenen voor de raffinaderij van Curaçao. Vanaf begin jaren tachtig hing er daarom een crisissfeer rond de raffinaderij van Curaçao. De raffinaderij was verliesgevend en sluiting was voor Shell onafwendbaar.\r\n\r\nDe slepende onderhandelingen, waarbij ook de Nederlandse en Nederlands Antilliaanse regeringen betrokken waren, gingen uiteindelijk over het garanderen van werkgelegenheid voor de Antillen. Venezuela wilde alleen participeren in de bedrijfsvoering als Shell zou investeren in een moderniseringsprogramma. Shell wilde alleen een investeringsprogramma inzetten bij een gegarandeerde levering van ruwe olie, het liefst tegen preferente prijzen.\r\n\r\nVenezuela had uit commercieel technische overwegingen de voorkeur uitgesproken voor een voortgezet eigendom van Shell boven een eventueel eigendom van de Antilliaanse overheid. Uiteindelijk verkocht Shell de fabriek in 1985 echter toch aan de eilandelijke overheid van Curaçao en werd de bedrijfsvoering door het Venezolaanse Petróleos de Venezuela S.A. (PdVSA) uitgevoerd op basis van een leasecontract. Minister president Maria Liberia-Peters van de Nederlandse Antillen tekende namens de Antillen het lease contract en gold als redder van de werkgelegenheid.\r\n\r\nDe bedrijfsvoering van de raffinaderij werd in beheer van PdVSA wederom sterk gestroomlijnd. Productieprocessen zijn nu veelal geautomatiseerd. Op het immense raffinaderijterrein zijn slechts hier en daar arbeiders zichtbaar, het leeuwendeel is in de controlebunker te werk gesteld. De door Venezuela verlangde upgrading is echter maar ten dele uitgevoerd. In het midden van de jaren negentig werd een nieuwe elektriciteitscentrale op het terrein van de raffinaderij gebouwd, maar verdere grote investeringen zijn achterwege gebleven; de fabriek draait, op een uitzondering na, op de oude installaties. Er heeft ook geen toename van aanvoer van olie plaatsgevonden.\r\n\r\nDe in de jaren negentig vastgestelde Hinderwetvergunning zorgde voor een veelheid aan rechtzaken tegen de raffinaderij of tegen de overheid, hetzij om aan de milieunormen te voldoen of deze te handhaven. Rond de raffinaderij hangt nog steeds de sfeer van een onzekere toekomst. Grote investeringen voor een schonere en veilige fabriek blijven nodig, en om die reden wordt er gezocht naar kapitaalkrachtige partners.', '33. Het vertrek van de Shell en de komst van de PDVSA', '', 'inherit', 'closed', 'closed', '', '71-revision-v1', '', '', '2017-09-10 02:47:58', '2017-09-10 00:47:58', '', '71', 'https://canoncuracao.cw/71-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('321', '4', '2017-09-14 23:02:31', '2017-09-14 21:02:31', '', '1707', '', 'inherit', 'open', 'closed', '', '1707', '', '', '2017-09-14 23:02:38', '2017-09-14 21:02:38', '', '25', 'https://canoncuracao.cw/wp-content/uploads/2017/05/1707.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('322', '4', '2017-09-14 23:02:43', '2017-09-14 21:02:43', '', '10. De ontwikkeling van Willemstad', '', 'inherit', 'closed', 'closed', '', '25-revision-v1', '', '', '2017-09-14 23:02:43', '2017-09-14 21:02:43', '', '25', 'https://canoncuracao.cw/25-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('324', '4', '2017-09-14 23:06:31', '2017-09-14 21:06:31', '', 'H4 Dorp van Westpunt met kunuku huizen2', '', 'inherit', 'open', 'closed', '', 'h4-dorp-van-westpunt-met-kunuku-huizen2', '', '', '2017-09-14 23:06:35', '2017-09-14 21:06:35', '', '27', 'https://canoncuracao.cw/wp-content/uploads/2017/05/H4-Dorp-van-Westpunt-met-kunuku-huizen2.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('325', '4', '2017-09-14 23:06:37', '2017-09-14 21:06:37', '', '11. De ontwikkeling van nederzettingen en barios buiten Willemstad', '', 'inherit', 'closed', 'closed', '', '27-revision-v1', '', '', '2017-09-14 23:06:37', '2017-09-14 21:06:37', '', '27', 'https://canoncuracao.cw/27-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('327', '4', '2017-09-14 23:08:23', '2017-09-14 21:08:23', '', 'H4 Montagne rey', '', 'inherit', 'open', 'closed', '', 'h4-montagne-rey', '', '', '2017-09-14 23:08:27', '2017-09-14 21:08:27', '', '27', 'https://canoncuracao.cw/wp-content/uploads/2017/05/H4-Montagne-rey.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('328', '4', '2017-09-14 23:09:57', '2017-09-14 21:09:57', '', '11. De ontwikkeling van nederzettingen en barios buiten Willemstad', '', 'inherit', 'closed', 'closed', '', '27-revision-v1', '', '', '2017-09-14 23:09:57', '2017-09-14 21:09:57', '', '27', 'https://canoncuracao.cw/27-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('330', '4', '2017-09-14 23:11:05', '2017-09-14 21:11:05', '', 'H 5 22 doktoor', '', 'inherit', 'open', 'closed', '', 'h-5-22-doktoor', '', '', '2017-09-14 23:11:10', '2017-09-14 21:11:10', '', '57', 'https://canoncuracao.cw/wp-content/uploads/2017/05/H-5-22-doktoor.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('331', '4', '2017-09-14 23:11:15', '2017-09-14 21:11:15', '', '26. Dr. F da Costa Gomez', '', 'inherit', 'closed', 'closed', '', '57-revision-v1', '', '', '2017-09-14 23:11:15', '2017-09-14 21:11:15', '', '57', 'https://canoncuracao.cw/57-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('333', '4', '2017-09-14 23:15:03', '2017-09-14 21:15:03', '', 'Laden Kanon', '', 'inherit', 'open', 'closed', '', 'laden-kanon', '', '', '2017-09-14 23:15:11', '2017-09-14 21:15:11', '', '55', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Laden-Kanon.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('334', '4', '2017-09-14 23:15:16', '2017-09-14 21:15:16', '', '25. De Tweede Wereldoorlog', '', 'inherit', 'closed', 'closed', '', '55-revision-v1', '', '', '2017-09-14 23:15:16', '2017-09-14 21:15:16', '', '55', 'https://canoncuracao.cw/55-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('336', '4', '2017-09-14 23:21:08', '2017-09-14 21:21:08', '', 'election', '', 'inherit', 'open', 'closed', '', 'election', '', '', '2017-09-14 23:21:11', '2017-09-14 21:21:11', '', '59', 'https://canoncuracao.cw/wp-content/uploads/2017/05/election.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('337', '4', '2017-09-14 23:21:13', '2017-09-14 21:21:13', '', '27. Algemeen kiesrecht', '', 'inherit', 'closed', 'closed', '', '59-revision-v1', '', '', '2017-09-14 23:21:13', '2017-09-14 21:21:13', '', '59', 'https://canoncuracao.cw/59-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('339', '4', '2017-09-14 23:23:22', '2017-09-14 21:23:22', '', 'overzicht vanplantage siberie2', '', 'inherit', 'open', 'closed', '', 'overzicht-vanplantage-siberie2', '', '', '2017-09-14 23:23:26', '2017-09-14 21:23:26', '', '31', 'https://canoncuracao.cw/wp-content/uploads/2017/05/overzicht-vanplantage-siberie2.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('340', '4', '2017-09-14 23:23:29', '2017-09-14 21:23:29', 'In 1634 veroverde de West Indische Compagnie het eiland Curaçao. De W.I.C begon al snel met het opzetten van compagnieplantages met als doel het voedsel te verbouwen voor hun personeel en de als slaaf hierheen gebrachte Afrikanen. Naast deze compagnieplantages kwamen er al zeer snel particuliere plantages. Vrienden en familieleden van de bestuurders kregen grote terreinen in bruikleen en al heel snel was het grootste deel van Curacao onderverdeeld in plantages.\r\n\r\nDeze grote landbouwbedrijven oefenden een vorm van gemengd bedrijf uit. Normaal gesproken bestond zo’n bedrijf uit drie onderdelen: een hofje, onbewerkt land (de ‘mondi’) en akkers die in de regentijd werden gebruikt (de ‘kunuku’s).\r\n\r\nHet hofje was bijna altijd gelegen aan het uiteinde van een rooistelsel, waar de verweringslaag veel dikker was en waar de grondwaterspiegel het hoogst was. Daar plantte men de vruchtbomen en werd er wat groente gekweekt. De mondi werd gebruikt om schapen, geiten en koeien te laten grazen. Daarnaast waren er akkertjes voor de regenafhankelijke akkerbouw. Het gewas dat op deze akkers verbouwd werd, was het droogtebestendige sorghum (‘maishi chiki’), afkomstig uit West-Afrika. Als het regenseizoen (van november tot januari) goed was, werd er veel geproduceerd, maar zeer vaak viel het regenseizoen tegen en mislukte de oogst.   De maishi chiki was met name bestemd voor de bewoners van de plantage, zowel voor de tot slaaf gemaakte oorspronkelijk Afrikaanse bevolking en voor de eigenaarsfamilie. Hier werd het volksvoedsel ‘funchi’ van gemaakt. Inkomen verkreeg men door de verkoop van vee en melkproducten en de verkoop van fruit.\r\n\r\nDe meeste plantages waren niet erg rendabel, maar het bezit van een plantage was zeer belangrijk voor de status van de eigenaren.\r\n\r\nDe eigenaren behoorden meestal tot de groep van de “hoge blanke protestanten” en zij woonden meestal in de landhuizen.   De werkbevolking bestond oorspronkelijk uit tot slaaf gemaakte Afrikanen. Zij woonden in een buurtgemeenschap, gebouwd uit “kas di pal’i maishi” (eenvoudige lemen huisjes met een rieten dak) . Na de afschaffing van de slavernij in 1863 bleven vele ex-slaven op de plantages wonen met de verplichting om een aantal dagen in het jaar voor de plantage-eigenaar te werken (het zogenaamde ‘paga tera-systeem’).', '13. Het plantagesysteem op Curaçao', '', 'inherit', 'closed', 'closed', '', '31-revision-v1', '', '', '2017-09-14 23:23:29', '2017-09-14 21:23:29', '', '31', 'https://canoncuracao.cw/31-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('343', '4', '2017-09-15 18:00:14', '2017-09-15 16:00:14', '', '27 sept_89-33', '', 'inherit', 'open', 'closed', '', '27-sept_89-33', '', '', '2017-09-15 18:00:21', '2017-09-15 16:00:21', '', '51', 'https://canoncuracao.cw/wp-content/uploads/2017/05/27-sept_89-33.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('344', '4', '2017-09-15 18:01:00', '2017-09-15 16:01:00', '', 'stuyvesant lossen te willemstad curacao', '', 'inherit', 'open', 'closed', '', 'stuyvesant-lossen-te-willemstad-curacao', '', '', '2017-09-15 18:01:07', '2017-09-15 16:01:07', '', '51', 'https://canoncuracao.cw/wp-content/uploads/2017/05/stuyvesant-lossen-te-willemstad-curacao.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('345', '4', '2017-09-15 18:01:36', '2017-09-15 16:01:36', '', 'containerhaven', '', 'inherit', 'open', 'closed', '', 'containerhaven', '', '', '2017-09-15 18:01:43', '2017-09-15 16:01:43', '', '51', 'https://canoncuracao.cw/wp-content/uploads/2017/05/containerhaven.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('346', '4', '2017-09-15 18:03:18', '2017-09-15 16:03:18', '', '23. De haven', '', 'inherit', 'closed', 'closed', '', '51-revision-v1', '', '', '2017-09-15 18:03:18', '2017-09-15 16:03:18', '', '51', 'https://canoncuracao.cw/51-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('350', '4', '2017-09-15 18:11:48', '2017-09-15 16:11:48', '', 'voorkantstatuut_LR', '', 'inherit', 'open', 'closed', '', 'voorkantstatuut_lr', '', '', '2017-09-15 18:12:00', '2017-09-15 16:12:00', '', '61', 'https://canoncuracao.cw/wp-content/uploads/2017/05/voorkantstatuut_LR.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('351', '4', '2017-09-15 18:12:39', '2017-09-15 16:12:39', '', '28. Het statuut', '', 'inherit', 'closed', 'closed', '', '61-revision-v1', '', '', '2017-09-15 18:12:39', '2017-09-15 16:12:39', '', '61', 'https://canoncuracao.cw/61-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('352', '4', '2017-09-15 18:13:54', '2017-09-15 16:13:54', '', 'voorkantstatuut_LR1', '', 'inherit', 'open', 'closed', '', 'voorkantstatuut_lr1', '', '', '2017-09-15 18:14:01', '2017-09-15 16:14:01', '', '61', 'https://canoncuracao.cw/wp-content/uploads/2017/05/voorkantstatuut_LR1.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('353', '4', '2017-09-15 18:14:05', '2017-09-15 16:14:05', '', '28. Het statuut', '', 'inherit', 'closed', 'closed', '', '61-revision-v1', '', '', '2017-09-15 18:14:05', '2017-09-15 16:14:05', '', '61', 'https://canoncuracao.cw/61-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('355', '4', '2017-09-15 19:49:15', '2017-09-15 17:49:15', '', 'H5 1 felix chacuto', '', 'inherit', 'open', 'closed', '', 'h5-1-felix-chacuto', '', '', '2017-09-15 19:49:21', '2017-09-15 17:49:21', '', '53', 'https://canoncuracao.cw/wp-content/uploads/2017/05/H5-1-felix-chacuto.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('356', '4', '2017-09-15 19:49:32', '2017-09-15 17:49:32', '', '24. De arbeidersbeweging', '', 'inherit', 'closed', 'closed', '', '53-revision-v1', '', '', '2017-09-15 19:49:32', '2017-09-15 17:49:32', '', '53', 'https://canoncuracao.cw/53-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('358', '4', '2017-09-15 19:50:56', '2017-09-15 17:50:56', '', '24. De arbeidersbeweging', '', 'inherit', 'closed', 'closed', '', '53-revision-v1', '', '', '2017-09-15 19:50:56', '2017-09-15 17:50:56', '', '53', 'https://canoncuracao.cw/53-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('359', '4', '2017-09-15 19:54:13', '2017-09-15 17:54:13', '', 'foto 017', '', 'inherit', 'open', 'closed', '', 'foto-017', '', '', '2017-09-15 19:54:20', '2017-09-15 17:54:20', '', '67', 'https://canoncuracao.cw/wp-content/uploads/2017/05/foto-017.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('360', '4', '2017-09-15 20:03:18', '2017-09-15 18:03:18', '', '02. Kop van de mars (Medium)', '', 'inherit', 'open', 'closed', '', '02-kop-van-de-mars-medium', '', '', '2017-09-15 20:03:24', '2017-09-15 18:03:24', '', '67', 'https://canoncuracao.cw/wp-content/uploads/2017/05/02.-Kop-van-de-mars-Medium.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('361', '4', '2017-09-15 20:04:33', '2017-09-15 18:04:33', '', 'H 7 1 in forti', '', 'inherit', 'open', 'closed', '', 'h-7-1-in-forti', '', '', '2017-09-15 20:04:39', '2017-09-15 18:04:39', '', '67', 'https://canoncuracao.cw/wp-content/uploads/2017/05/H-7-1-in-forti.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('362', '4', '2017-09-15 20:08:32', '2017-09-15 18:08:32', '30 Mei 1969 (Trinta di Mei)\r\n\r\nWereldwijd, en dus ook op Curaçao, staan de jaren 60 bekend als een tijdperk van maatschappelijke verandering. Talrijke sociale bewegingen ageerden tegen sociale machtsstructuren gebaseerd op kleur, klasse, en geslacht. Op Curaçao wordt er geen ander gebeurtenis sterker geassocieerd met deze periode als de opstand van \"Trinta di Mei,\" 30 Mei 1969.\r\n\r\nDe arbeidsconflicten die tot de opstand van 30 mei 1969 hebben geleid vinden hun oorsprong in de ontwikkelingen van de tweede helft van de jaren 1960. De Shell-olieraffinaderij, toen de grootste werkgever op Curaçao, begon met automatisering en uitbesteding naar verschillende onderaannemers zoals, onder andere, \"Werkspoor Caribbean\" (WESCAR). Door de uitbestending moesten werknemers die eerder voor de Shell hadden gewerkt bij de onderaannemers hetzelfde arbeid verrichten tegen lager loon.\r\n\r\nIn de eerste week van mei 1969 ontstond er een impasse in de onderhandelingentussen WESCAR en de Curaçao Federation of Workers (CFW) over decollectieve arbeidersovereenkomst (CAO)die op 6 mei 1969 zou aflopen.CFW hanteerde het principe van \"equal work equal pay\" en eiste een loon dat gelijk was met wat de Shell betaalde voordat de banenaan WESCAR werden uitbesteed. Toen WESCAR dit weigerde, kondigde de CFW in de laatste week van mei een algemene staking af voor alle leden. Al gauw volgde een sympathie-staking van de Shell-arbeidersvakbond \"Petroleum Workers Federation of Curaçao\" (PWFC). Politici, journalisten en activisten zoals Stanley Brown, hoofdredacteur van de linkse antikoloniale tijdschrift<em> Vitó</em>, steunden de stakende arbeiders.\r\n\r\n&nbsp;\r\n\r\nOp de ochtend van 30 mei 1969 verzamelden zich ongeveer vijfduizend stakers bij de hoofdingang van de Shell-terrein voor een optocht naar Fort Amsterdam, onder leiding van Ewald Ong-a-Kwie, leider van de CFW. De leiders van de havenarbeiders, Wilson \"Papa\" Godett en Amador Nita, sloten zich toen aan bij de optocht. De optocht escaleerde tot een heuse opstand toen bij Parera twee doden vielen, Manuel Gutierez en Orlando Gerardina. Wilson \"Papa\" Godett werd in de rug geraakt door een politiekogel, toen hij met de handen omhoog de menigte probeerde te kalmeren. Na de escalatie stemden Shell en WESCAR alsnog in met de eisen van gelijk loon voor gelijk werk van de CFW<strong>.</strong> Het was echter al te laat. Een woedende meute stroomde Punda en Otrobanda binnen. Gebouwen werden in brand gestoken, en winkels werden geplunderd. De gouverneur kondigde een noodtoestand af, het leger werd ingeschakeld, en mariniers uit Nederland werden ingevlogen om de opstand te bedwingen. Nadat de vakbondsleiders op de radio hadden bekendgemaakt dat Shell en de onderaannemers met de eisen van de vakbonden hadden ingestemd, keerde de rust terug. In de nasleep van de opstand ontstond er een nieuwe politieke partij, \"Frente Obrero Liberashon Trinta di Mei,\" geleid door Wilson Godett, Stanley Brown en Amador Nita, die zou opkomen voor de belangen van de arbeidersklasse.\r\n\r\nMet de loop der jaren werd \"Trinta di Mei\" een symbool voor een langere periode van sociale veranderingsprocessen van de jaren 60, waarbij de raciaal gesegmenteerde koloniale machtsstructuur moest plaatsmaken voor een politiek klimaat waarin er meer rekening werd gehouden met de belangen van de Afro-Curaçaose arbeidersklasse. In 1994 werd \"Trinta di Mei\" tot nationale herdenkingsdag verklaard. Alhoewel er onder Curaçaoënaars nog steeds meningsverschillen bestaan over de details, wordt \"Trinta Di Mei\" toch beschouwd als een belangrijk keerpunt in de politieke geschiedenis van Curaçao.', '31. Mei 1969', '', 'inherit', 'closed', 'closed', '', '67-revision-v1', '', '', '2017-09-15 20:08:32', '2017-09-15 18:08:32', '', '67', 'https://canoncuracao.cw/67-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('363', '4', '2017-09-15 20:09:14', '2017-09-15 18:09:14', '30 Mei 1969 (Trinta di Mei)\r\n\r\nWereldwijd, en dus ook op Curaçao, staan de jaren 60 bekend als een tijdperk van maatschappelijke verandering. Talrijke sociale bewegingen ageerden tegen sociale machtsstructuren gebaseerd op kleur, klasse, en geslacht. Op Curaçao wordt er geen ander gebeurtenis sterker geassocieerd met deze periode als de opstand van \"Trinta di Mei,\" 30 Mei 1969.\r\n\r\nDe arbeidsconflicten die tot de opstand van 30 mei 1969 hebben geleid vinden hun oorsprong in de ontwikkelingen van de tweede helft van de jaren 1960. De Shell-olieraffinaderij, toen de grootste werkgever op Curaçao, begon met automatisering en uitbesteding naar verschillende onderaannemers zoals, onder andere, \"Werkspoor Caribbean\" (WESCAR). Door de uitbestending moesten werknemers die eerder voor de Shell hadden gewerkt bij de onderaannemers hetzelfde arbeid verrichten tegen lager loon.\r\n\r\nIn de eerste week van mei 1969 ontstond er een impasse in de onderhandelingentussen WESCAR en de Curaçao Federation of Workers (CFW) over decollectieve arbeidersovereenkomst (CAO)die op 6 mei 1969 zou aflopen.CFW hanteerde het principe van \"equal work equal pay\" en eiste een loon dat gelijk was met wat de Shell betaalde voordat de banenaan WESCAR werden uitbesteed. Toen WESCAR dit weigerde, kondigde de CFW in de laatste week van mei een algemene staking af voor alle leden. Al gauw volgde een sympathie-staking van de Shell-arbeidersvakbond \"Petroleum Workers Federation of Curaçao\" (PWFC). Politici, journalisten en activisten zoals Stanley Brown, hoofdredacteur van de linkse antikoloniale tijdschrift<em> Vitó</em>, steunden de stakende arbeiders.\r\n\r\n&nbsp;\r\n\r\nOp de ochtend van 30 mei 1969 verzamelden zich ongeveer vijfduizend stakers bij de hoofdingang van de Shell-terrein voor een optocht naar Fort Amsterdam, onder leiding van Ewald Ong-a-Kwie, leider van de CFW. De leiders van de havenarbeiders, Wilson \"Papa\" Godett en Amador Nita, sloten zich toen aan bij de optocht. De optocht escaleerde tot een heuse opstand toen bij Parera twee doden vielen, Manuel Gutierez en Orlando Gerardina. Wilson \"Papa\" Godett werd in de rug geraakt door een politiekogel, toen hij met de handen omhoog de menigte probeerde te kalmeren. Na de escalatie stemden Shell en WESCAR alsnog in met de eisen van gelijk loon voor gelijk werk van de CFW<strong>.</strong> Het was echter al te laat. Een woedende meute stroomde Punda en Otrobanda binnen. Gebouwen werden in brand gestoken, en winkels werden geplunderd. De gouverneur kondigde een noodtoestand af, het leger werd ingeschakeld, en mariniers uit Nederland werden ingevlogen om de opstand te bedwingen. Nadat de vakbondsleiders op de radio hadden bekendgemaakt dat Shell en de onderaannemers met de eisen van de vakbonden hadden ingestemd, keerde de rust terug. In de nasleep van de opstand ontstond er een nieuwe politieke partij, \"Frente Obrero Liberashon Trinta di Mei,\" geleid door Wilson Godett, Stanley Brown en Amador Nita, die zou opkomen voor de belangen van de arbeidersklasse.\r\n\r\nMet de loop der jaren werd \"Trinta di Mei\" een symbool voor een langere periode van sociale veranderingsprocessen van de jaren 60, waarbij de raciaal gesegmenteerde koloniale machtsstructuur moest plaatsmaken voor een politiek klimaat waarin er meer rekening werd gehouden met de belangen van de Afro-Curaçaose arbeidersklasse. In 1994 werd \"Trinta di Mei\" tot nationale herdenkingsdag verklaard. Alhoewel er onder Curaçaoënaars nog steeds meningsverschillen bestaan over de details, wordt \"Trinta Di Mei\" toch beschouwd als een belangrijk keerpunt in de politieke geschiedenis van Curaçao.', '31. Mei 1969', '', 'inherit', 'closed', 'closed', '', '67-revision-v1', '', '', '2017-09-15 20:09:14', '2017-09-15 18:09:14', '', '67', 'https://canoncuracao.cw/67-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('364', '4', '2017-09-16 17:50:03', '2017-09-16 15:50:03', '', 'Detail hoedenvlechterij', '', 'inherit', 'open', 'closed', '', 'detail-hoedenvlechterij', '', '', '2017-09-16 17:50:12', '2017-09-16 15:50:12', '', '41', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Detail-hoedenvlechterij.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('365', '4', '2017-09-16 17:50:18', '2017-09-16 15:50:18', '', '18. Werkgelegenheid en emigratie tussen 1863 en 1920', '', 'inherit', 'closed', 'closed', '', '41-revision-v1', '', '', '2017-09-16 17:50:18', '2017-09-16 15:50:18', '', '41', 'https://canoncuracao.cw/41-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('366', '4', '2017-09-16 17:51:25', '2017-09-16 15:51:25', '', 'Pontjesvaarders 1', '', 'inherit', 'open', 'closed', '', 'pontjesvaarders-1', '', '', '2017-09-16 17:51:29', '2017-09-16 15:51:29', '', '41', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Pontjesvaarders-1.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('367', '4', '2017-09-16 17:51:51', '2017-09-16 15:51:51', '', 'panama-canal-construction-everett', '', 'inherit', 'open', 'closed', '', 'panama-canal-construction-everett', '', '', '2017-09-16 17:51:55', '2017-09-16 15:51:55', '', '41', 'https://canoncuracao.cw/wp-content/uploads/2017/05/panama-canal-construction-everett.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('368', '4', '2017-09-16 17:53:35', '2017-09-16 15:53:35', '', '18. Werkgelegenheid en emigratie tussen 1863 en 1920', '', 'inherit', 'closed', 'closed', '', '41-revision-v1', '', '', '2017-09-16 17:53:35', '2017-09-16 15:53:35', '', '41', 'https://canoncuracao.cw/41-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('370', '4', '2017-09-16 17:55:14', '2017-09-16 15:55:14', '', '1800canvas', '', 'inherit', 'open', 'closed', '', '1800canvas', '', '', '2017-09-16 17:55:18', '2017-09-16 15:55:18', '', '23', 'https://canoncuracao.cw/wp-content/uploads/2017/05/1800canvas.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('371', '4', '2017-09-16 17:55:21', '2017-09-16 15:55:21', '<h3>Een patriotseputsch</h3>\r\nToen in1795 de slavenopstanduitbrak, was er politieke onrust in Curaçao. Evenals in de Republiek stonden patriotten en Oranjegezinden tegenover elkaar. En evenals in het moederland, waar in 1795 met Franse steun de Bataafse Republiek werd uitgeroepen, wisten patriotten in Curaçao, gesteund door Franse kapers, in 1796 de macht te grijpen. De Bataafse Republiek kwam als bondgenoot van Frankrijk in de oorlog met Groot-Brittannië. Curaçao werd een belangrijk maritiem steunpunt voor de Fransen.\r\n<h3>Hervorming van de defensie</h3>\r\nNa de machtswisseling verkeerde het defensieapparaat in chaos. Oranjegezinde officieren van het garnizoen vertrokken hals over kop vanCuraçao. Kort daarna werd de gouverneur a.i., Jan Jacob Beaujon, die ervan werd verdacht Oranjegezind en pro-Brits te zijn, afgezet. Hij werd opgevolgd door de kapitein van de burgerij Johann RudolfLauffer, die de verdediging van Curaçao reorganiseerde. De oorspronkelijk exclusief blanke burgerwacht werd uitgebreid met vrije niet-blanken en omgedoopt tot Nationale Garde. Deze vrijen waren afkomstig uit de zeevarende bevolking en hadden ervaring met de bediening van scheepsgeschut. Gekleurde schippers kregen officiersrangen bij het onderdeel artillerie. Dit leidde tot spanningen binnen de Nationale Garde.\r\n<h3>Revolutionaire onrust</h3>\r\nGeïnspireerd door de leuzen ‘vrijheid’ en ‘gelijkheid’ van de Franse Revolutie (1789-1799),de succesvolle slavenopstand in de Franse kolonie Saint-Domingue in 1791en de Franse afschaffing van de slavernij in 1792, ontstond in de gehele regio revolutionaire onrust. De leiders van een mislukte opstand in Venezuela vluchtten in 1797 naar Curaçao. Geruchten over hun uitlevering veroorzaakte bijna een muiterij onder artilleristen van de Nationale Garde. In 1799 werden drie Fransen gearresteerd omdat zij, volgens Lauffer, de leiders waren van een complot om een nieuwe slavenopstand te ontketenen en de macht te grijpen. Alle drie werden zij uitgewezen.\r\n<h3>Aangevallen door de bondgenoot en gered door de vijand.</h3>\r\nIn 1800 verscheen een Franse militaire macht uit Guadeloupe voor de haven om, zo werd gemeld, Curaçao tegen de Britten te beschermen. Vermoed werd dat de Fransen uit waren op een machtsovername. Dit bleek inderdaad het geval. Na op aandringen van het gouvernement te zijn vertrokken, landden de Franse troepeneen dag later bij Sint-Michielsbaai. Daarna veroverden zij, gesteund door een groot deel van de Curaçaose slavenbevolking, op Willemstad na vrijwel het gehele eiland. Toen een Brits oorlogsschip voor de haven verscheen en vervolgens ook twee Amerikaanse oorlogsschepen, besloot het gouvernement hun hulp in te roepen. De Fransen werden verdreven, maar een Britse bezetting was het gevolg. In 1802 kwam Curaçao weer in Nederlandse handen.In 1807 veroverden de Britten Curaçao echter opnieuw.\r\n\r\nHan Jordaan', '9. Curaçao rond 1800', '', 'inherit', 'closed', 'closed', '', '23-revision-v1', '', '', '2017-09-16 17:55:21', '2017-09-16 15:55:21', '', '23', 'https://canoncuracao.cw/23-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('373', '4', '2017-09-16 17:58:03', '2017-09-16 15:58:03', '', '1800 canvas2', '', 'inherit', 'open', 'closed', '', '1800-canvas2', '', '', '2017-09-16 17:58:09', '2017-09-16 15:58:09', '', '23', 'https://canoncuracao.cw/wp-content/uploads/2017/05/1800-canvas2.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('374', '4', '2017-09-16 17:58:25', '2017-09-16 15:58:25', '', 'haven van Curacao', '', 'inherit', 'open', 'closed', '', 'haven-van-curacao', '', '', '2017-09-16 17:58:28', '2017-09-16 15:58:28', '', '23', 'https://canoncuracao.cw/wp-content/uploads/2017/05/haven-van-Curacao.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('375', '4', '2017-09-16 17:58:40', '2017-09-16 15:58:40', '<h3>Een patriotseputsch</h3>\r\nToen in1795 de slavenopstanduitbrak, was er politieke onrust in Curaçao. Evenals in de Republiek stonden patriotten en Oranjegezinden tegenover elkaar. En evenals in het moederland, waar in 1795 met Franse steun de Bataafse Republiek werd uitgeroepen, wisten patriotten in Curaçao, gesteund door Franse kapers, in 1796 de macht te grijpen. De Bataafse Republiek kwam als bondgenoot van Frankrijk in de oorlog met Groot-Brittannië. Curaçao werd een belangrijk maritiem steunpunt voor de Fransen.\r\n<h3>Hervorming van de defensie</h3>\r\nNa de machtswisseling verkeerde het defensieapparaat in chaos. Oranjegezinde officieren van het garnizoen vertrokken hals over kop vanCuraçao. Kort daarna werd de gouverneur a.i., Jan Jacob Beaujon, die ervan werd verdacht Oranjegezind en pro-Brits te zijn, afgezet. Hij werd opgevolgd door de kapitein van de burgerij Johann RudolfLauffer, die de verdediging van Curaçao reorganiseerde. De oorspronkelijk exclusief blanke burgerwacht werd uitgebreid met vrije niet-blanken en omgedoopt tot Nationale Garde. Deze vrijen waren afkomstig uit de zeevarende bevolking en hadden ervaring met de bediening van scheepsgeschut. Gekleurde schippers kregen officiersrangen bij het onderdeel artillerie. Dit leidde tot spanningen binnen de Nationale Garde.\r\n<h3>Revolutionaire onrust</h3>\r\nGeïnspireerd door de leuzen ‘vrijheid’ en ‘gelijkheid’ van de Franse Revolutie (1789-1799),de succesvolle slavenopstand in de Franse kolonie Saint-Domingue in 1791en de Franse afschaffing van de slavernij in 1792, ontstond in de gehele regio revolutionaire onrust. De leiders van een mislukte opstand in Venezuela vluchtten in 1797 naar Curaçao. Geruchten over hun uitlevering veroorzaakte bijna een muiterij onder artilleristen van de Nationale Garde. In 1799 werden drie Fransen gearresteerd omdat zij, volgens Lauffer, de leiders waren van een complot om een nieuwe slavenopstand te ontketenen en de macht te grijpen. Alle drie werden zij uitgewezen.\r\n<h3>Aangevallen door de bondgenoot en gered door de vijand.</h3>\r\nIn 1800 verscheen een Franse militaire macht uit Guadeloupe voor de haven om, zo werd gemeld, Curaçao tegen de Britten te beschermen. Vermoed werd dat de Fransen uit waren op een machtsovername. Dit bleek inderdaad het geval. Na op aandringen van het gouvernement te zijn vertrokken, landden de Franse troepeneen dag later bij Sint-Michielsbaai. Daarna veroverden zij, gesteund door een groot deel van de Curaçaose slavenbevolking, op Willemstad na vrijwel het gehele eiland. Toen een Brits oorlogsschip voor de haven verscheen en vervolgens ook twee Amerikaanse oorlogsschepen, besloot het gouvernement hun hulp in te roepen. De Fransen werden verdreven, maar een Britse bezetting was het gevolg. In 1802 kwam Curaçao weer in Nederlandse handen.In 1807 veroverden de Britten Curaçao echter opnieuw.\r\n\r\nHan Jordaan', '9. Curaçao rond 1800', '', 'inherit', 'closed', 'closed', '', '23-revision-v1', '', '', '2017-09-16 17:58:40', '2017-09-16 15:58:40', '', '23', 'https://canoncuracao.cw/23-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('377', '4', '2017-09-16 18:06:54', '2017-09-16 16:06:54', '', 'H 5 24 adele rigeaud', '', 'inherit', 'open', 'closed', '', 'h-5-24-adele-rigeaud', '', '', '2017-09-16 18:06:59', '2017-09-16 16:06:59', '', '63', 'https://canoncuracao.cw/wp-content/uploads/2017/05/H-5-24-adele-rigeaud.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('378', '4', '2017-09-16 18:07:38', '2017-09-16 16:07:38', '', '29. Vrouwenemancipatie', '', 'inherit', 'closed', 'closed', '', '63-revision-v1', '', '', '2017-09-16 18:07:38', '2017-09-16 16:07:38', '', '63', 'https://canoncuracao.cw/63-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('380', '4', '2017-09-16 18:10:06', '2017-09-16 16:10:06', '', 'H 6 6 gomesplein', '', 'inherit', 'open', 'closed', '', 'h-6-6-gomesplein', '', '', '2017-09-16 18:10:11', '2017-09-16 16:10:11', '', '65', 'https://canoncuracao.cw/wp-content/uploads/2017/05/H-6-6-gomesplein.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('381', '4', '2017-09-16 18:11:25', '2017-09-16 16:11:25', '', '30. De 60er jaren - een sfeer van verandering', '', 'inherit', 'closed', 'closed', '', '65-revision-v1', '', '', '2017-09-16 18:11:25', '2017-09-16 16:11:25', '', '65', 'https://canoncuracao.cw/65-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('383', '4', '2017-09-16 18:14:41', '2017-09-16 16:14:41', '', 'H2 NA Cur collectie Vicariaat Dominicanen Foto 576', '', 'inherit', 'open', 'closed', '', 'h2-na-cur-collectie-vicariaat-dominicanen-foto-576', '', '', '2017-09-16 18:14:45', '2017-09-16 16:14:45', '', '87', 'https://canoncuracao.cw/wp-content/uploads/2017/05/H2-NA-Cur-collectie-Vicariaat-Dominicanen-Foto-576.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('384', '4', '2017-09-16 18:15:31', '2017-09-16 16:15:31', '', '41. Het onderwijs op Curaçao', '', 'inherit', 'closed', 'closed', '', '87-revision-v1', '', '', '2017-09-16 18:15:31', '2017-09-16 16:15:31', '', '87', 'https://canoncuracao.cw/87-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('386', '4', '2017-09-16 18:18:06', '2017-09-16 16:18:06', '', 'H7 Nationaal Archief Curacao Collectie Fischer 24-49B', '', 'inherit', 'open', 'closed', '', 'h7-nationaal-archief-curacao-collectie-fischer-24-49b', '', '', '2017-09-16 18:18:14', '2017-09-16 16:18:14', '', '87', 'https://canoncuracao.cw/wp-content/uploads/2017/05/H7-Nationaal-Archief-Curacao-Collectie-Fischer-24-49B.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('387', '4', '2017-09-16 18:19:18', '2017-09-16 16:19:18', '', '41. Het onderwijs op Curaçao', '', 'inherit', 'closed', 'closed', '', '87-revision-v1', '', '', '2017-09-16 18:19:18', '2017-09-16 16:19:18', '', '87', 'https://canoncuracao.cw/87-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('388', '4', '2017-09-16 18:27:01', '2017-09-16 16:27:01', '', 'hendrikschool', '', 'inherit', 'open', 'closed', '', 'hendrikschool', '', '', '2017-09-16 18:27:05', '2017-09-16 16:27:05', '', '87', 'https://canoncuracao.cw/wp-content/uploads/2017/05/hendrikschool.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('389', '4', '2017-09-16 18:28:20', '2017-09-16 16:28:20', '', '41. Het onderwijs op Curaçao', '', 'inherit', 'closed', 'closed', '', '87-revision-v1', '', '', '2017-09-16 18:28:20', '2017-09-16 16:28:20', '', '87', 'https://canoncuracao.cw/87-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('390', '4', '2017-09-16 18:33:40', '2017-09-16 16:33:40', '', 'Plantashi Knip', '', 'inherit', 'open', 'closed', '', 'plantashi-knip', '', '', '2017-09-16 18:33:45', '2017-09-16 16:33:45', '', '16', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Plantashi-Knip.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('391', '4', '2017-09-16 18:33:48', '2017-09-16 16:33:48', '', '6. Slavernijverzet', '', 'inherit', 'closed', 'closed', '', '16-revision-v1', '', '', '2017-09-16 18:33:48', '2017-09-16 16:33:48', '', '16', 'https://canoncuracao.cw/16-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('393', '4', '2017-09-16 18:40:49', '2017-09-16 16:40:49', '', 'H5 4 portugezen', '', 'inherit', 'open', 'closed', '', 'h5-4-portugezen', '', '', '2017-09-16 18:40:53', '2017-09-16 16:40:53', '', '49', 'https://canoncuracao.cw/wp-content/uploads/2017/05/H5-4-portugezen.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('395', '4', '2017-09-16 18:42:41', '2017-09-16 16:42:41', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam blandit ultricies dui, id venenatis purus euismod non. Nullam ultricies pulvinar porttitor. Quisque tempus ornare pellentesque. Vestibulum varius commodo pellentesque. Quisque sit amet commodo neque. Donec nec egestas turpis. Morbi laoreet interdum volutpat. Etiam semper ultrices ultrices. Etiam in massa congue, dapibus lectus fermentum, vulputate neque. Fusce at volutpat ligula, in varius lacus.\r\n\r\nAliquam venenatis, mi vel pellentesque elementum, tortor sem vestibulum libero, ac vulputate mauris nunc eu est. Integer eget lorem bibendum, bibendum purus quis, sodales neque. Aenean tristique dolor eget tortor feugiat, vitae gravida eros ullamcorper. Etiam volutpat pulvinar nunc nec imperdiet. Vestibulum vel odio nec diam posuere ultrices id ac nunc. Sed a odio lectus. Curabitur tincidunt, enim vehicula lobortis lobortis, nunc nibh porttitor tortor, ac cursus urna magna vel tellus. Pellentesque in arcu nec arcu posuere dapibus. Vestibulum orci enim, imperdiet nec viverra a, sollicitudin sed mi. Nullam tempus luctus dapibus. Sed gravida elit eget tellus tincidunt, non posuere purus feugiat. Donec condimentum venenatis orci, placerat viverra neque ornare non. Maecenas vel mi eget enim mattis euismod. Suspendisse a vehicula enim. Vestibulum elit risus, viverra nec dui id, pretium vestibulum sapien.\r\n\r\nDonec eu erat a orci malesuada convallis eu eget dolor. Interdum et malesuada fames ac ante ipsum primis in faucibus. Proin in laoreet nisl, aliquet malesuada urna. Aenean porta molestie dolor, quis vulputate odio. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Pellentesque leo lectus, commodo sed laoreet at, tincidunt pharetra quam. Integer cursus neque quam. Integer non neque metus. Nulla a felis ante. Cras gravida volutpat elit sit amet gravida.\r\n\r\nDuis vitae ipsum arcu. Vivamus id faucibus tellus. Quisque quis dolor ligula. Nunc ligula arcu, fermentum dignissim luctus vitae, imperdiet eu lorem. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sollicitudin diam sit amet venenatis gravida. Curabitur porttitor vel dui non cursus. In hac habitasse platea dictumst.\r\n\r\n&nbsp;', '22. De nieuwe immigranten op Curaçao vanaf het begin van de twintigste eeuw', '', 'inherit', 'closed', 'closed', '', '49-revision-v1', '', '', '2017-09-16 18:42:41', '2017-09-16 16:42:41', '', '49', 'https://canoncuracao.cw/49-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('396', '4', '2017-09-16 18:51:14', '2017-09-16 16:51:14', '', 'verovering_curacao_1634', '', 'inherit', 'open', 'closed', '', 'verovering_curacao_1634', '', '', '2017-09-16 18:51:21', '2017-09-16 16:51:21', '', '12', 'https://canoncuracao.cw/wp-content/uploads/2017/05/verovering_curacao_1634.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('397', '4', '2017-09-16 18:52:21', '2017-09-16 16:52:21', '<h3>De verovering van Curaçao</h3>\r\nCuraçao werd in 1634 door de West-Indische Compagnie (WIC) veroverd op de Spanjaarden.\r\n\r\nDe Republiek was op dat moment verwikkeld in de Tachtigjarige Oorlog (1568-1648) met Spanje en metPortugal. Deze landen waren sinds 1580 verenigd waren onder één staatshoofd, de Spaanse koning. De WIC was in 1621 opgericht om te dienen als een instrument in die oorlog. Behalve met de uitvoering van een ambitieus plan, het ‘groot desseyn’,dat gericht was op het veroveren van Portugese gebieden in Afrika en Brazilië, was de WIC vooral actief in de kaapvaart. Er bestond daarom behoefte aan een maritiem steunpunt in het operatiegebied van waaruit militaire acties konden worden ondernomen.Het strategisch gunstig gelegen Curaçao was daarvoor uitstekend geschikt. Het eiland was goed verdedigbaar en beschikte over een uitstekende natuurlijke haven, de Sint-Annabaai.\r\n\r\nEen expeditie onder leiding van Johannes van Walbeecken Pierre le Grand slaagde er vrij eenvoudig in om Curaçao te overmeesteren. De kleine Spaanse bezetting werd samen met het grootste deel van de inheemse bevolking gedeporteerd naar Venezuela. Daarna werd een begin gemaakt met het op orde brengen van de verdediging. Aan oostelijke zijde van de ingang van de Sint-Annabaai op een landtong die De Punt (Punda) werd genoemd werd een sterkte gebouwd, fort Amsterdam.\r\n<h3>Van oorlogsbasis naar vestigingskolonie</h3>\r\nGedurende de eerste jaren na de verovering verbleven er op Curaçao in hoofdzaak militairen. In 1635 waren slechts 20 van de 412 compagniesdienaren burgers. Er woonden verder zo’n 50 inheemse bewoners. Spoedig arriveerden ook Afrikaanse slaven. Deze waren aanvankelijk vooral afkomstig van veroverde vijandelijke schepen. Maar hun aantallen waren tot midden zeventiende eeuw nog gering.\r\n\r\nVrijwel direct nadat bekend werd dat Curaçao was veroverd, ontstond er in het moederland belangstelling voor kolonisatieprojecten. Militairen en civiele beambten op het eiland, die hun contract hadden uitgediend, kregen ook de mogelijkheid om zich als landbouwer te vestigen. Maar dit leidde nauwelijks tot concrete resultaten.\r\n\r\nIn de jaren vijftig van zeventiende eeuw vestigden zich joodse kolonisten op het eiland. In 1665 woonden er, de inheemse bevolking niet meegerekend, zo’n 600 personen.Curaçao had inmiddels geen functie meer als oorlogsbasis, maar ontwikkelde zich nu, met de vanaf 1650 opkomende slavenhandel als motor, tot een commercieel centrum.Rond deze tijd ontstond ten noorden van fort Amsterdam een vestiging die uitgroeide tot een ommuurde stad, Willemstad. Het aantal plantages en tuinen groeide ook. Deze richtten zich vooral op de lokale voedselproductie.', '3. Verovering door de WIC en de komst van de Hollanders', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2017-09-16 18:52:21', '2017-09-16 16:52:21', '', '12', 'https://canoncuracao.cw/12-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('398', '4', '2017-09-16 18:53:53', '2017-09-16 16:53:53', '', 'H2 Van Walbeeck verovert Cur', '', 'inherit', 'open', 'closed', '', 'h2-van-walbeeck-verovert-cur', '', '', '2017-09-16 18:53:58', '2017-09-16 16:53:58', '', '12', 'https://canoncuracao.cw/wp-content/uploads/2017/05/H2-Van-Walbeeck-verovert-Cur.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('399', '4', '2017-09-16 18:54:44', '2017-09-16 16:54:44', '<h3>De verovering van Curaçao</h3>\r\nCuraçao werd in 1634 door de West-Indische Compagnie (WIC) veroverd op de Spanjaarden.\r\n\r\nDe Republiek was op dat moment verwikkeld in de Tachtigjarige Oorlog (1568-1648) met Spanje en metPortugal. Deze landen waren sinds 1580 verenigd waren onder één staatshoofd, de Spaanse koning. De WIC was in 1621 opgericht om te dienen als een instrument in die oorlog. Behalve met de uitvoering van een ambitieus plan, het ‘groot desseyn’,dat gericht was op het veroveren van Portugese gebieden in Afrika en Brazilië, was de WIC vooral actief in de kaapvaart. Er bestond daarom behoefte aan een maritiem steunpunt in het operatiegebied van waaruit militaire acties konden worden ondernomen.Het strategisch gunstig gelegen Curaçao was daarvoor uitstekend geschikt. Het eiland was goed verdedigbaar en beschikte over een uitstekende natuurlijke haven, de Sint-Annabaai.\r\n\r\nEen expeditie onder leiding van Johannes van Walbeecken Pierre le Grand slaagde er vrij eenvoudig in om Curaçao te overmeesteren. De kleine Spaanse bezetting werd samen met het grootste deel van de inheemse bevolking gedeporteerd naar Venezuela. Daarna werd een begin gemaakt met het op orde brengen van de verdediging. Aan oostelijke zijde van de ingang van de Sint-Annabaai op een landtong die De Punt (Punda) werd genoemd werd een sterkte gebouwd, fort Amsterdam.\r\n<h3>Van oorlogsbasis naar vestigingskolonie</h3>\r\nGedurende de eerste jaren na de verovering verbleven er op Curaçao in hoofdzaak militairen. In 1635 waren slechts 20 van de 412 compagniesdienaren burgers. Er woonden verder zo’n 50 inheemse bewoners. Spoedig arriveerden ook Afrikaanse slaven. Deze waren aanvankelijk vooral afkomstig van veroverde vijandelijke schepen. Maar hun aantallen waren tot midden zeventiende eeuw nog gering.\r\n\r\nVrijwel direct nadat bekend werd dat Curaçao was veroverd, ontstond er in het moederland belangstelling voor kolonisatieprojecten. Militairen en civiele beambten op het eiland, die hun contract hadden uitgediend, kregen ook de mogelijkheid om zich als landbouwer te vestigen. Maar dit leidde nauwelijks tot concrete resultaten.\r\n\r\nIn de jaren vijftig van zeventiende eeuw vestigden zich joodse kolonisten op het eiland. In 1665 woonden er, de inheemse bevolking niet meegerekend, zo’n 600 personen.Curaçao had inmiddels geen functie meer als oorlogsbasis, maar ontwikkelde zich nu, met de vanaf 1650 opkomende slavenhandel als motor, tot een commercieel centrum.Rond deze tijd ontstond ten noorden van fort Amsterdam een vestiging die uitgroeide tot een ommuurde stad, Willemstad. Het aantal plantages en tuinen groeide ook. Deze richtten zich vooral op de lokale voedselproductie.', '3. Verovering door de WIC en de komst van de Hollanders', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2017-09-16 18:54:44', '2017-09-16 16:54:44', '', '12', 'https://canoncuracao.cw/12-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('401', '4', '2017-09-16 18:57:10', '2017-09-16 16:57:10', '<h3>De verovering van Curaçao</h3>\r\nCuraçao werd in 1634 door de West-Indische Compagnie (WIC) veroverd op de Spanjaarden.\r\n\r\nDe Republiek was op dat moment verwikkeld in de Tachtigjarige Oorlog (1568-1648) met Spanje en metPortugal. Deze landen waren sinds 1580 verenigd waren onder één staatshoofd, de Spaanse koning. De WIC was in 1621 opgericht om te dienen als een instrument in die oorlog. Behalve met de uitvoering van een ambitieus plan, het ‘groot desseyn’,dat gericht was op het veroveren van Portugese gebieden in Afrika en Brazilië, was de WIC vooral actief in de kaapvaart. Er bestond daarom behoefte aan een maritiem steunpunt in het operatiegebied van waaruit militaire acties konden worden ondernomen.Het strategisch gunstig gelegen Curaçao was daarvoor uitstekend geschikt. Het eiland was goed verdedigbaar en beschikte over een uitstekende natuurlijke haven, de Sint-Annabaai.\r\n\r\nEen expeditie onder leiding van Johannes van Walbeecken Pierre le Grand slaagde er vrij eenvoudig in om Curaçao te overmeesteren. De kleine Spaanse bezetting werd samen met het grootste deel van de inheemse bevolking gedeporteerd naar Venezuela. Daarna werd een begin gemaakt met het op orde brengen van de verdediging. Aan oostelijke zijde van de ingang van de Sint-Annabaai op een landtong die De Punt (Punda) werd genoemd werd een sterkte gebouwd, fort Amsterdam.\r\n<h3>Van oorlogsbasis naar vestigingskolonie</h3>\r\nGedurende de eerste jaren na de verovering verbleven er op Curaçao in hoofdzaak militairen. In 1635 waren slechts 20 van de 412 compagniesdienaren burgers. Er woonden verder zo’n 50 inheemse bewoners. Spoedig arriveerden ook Afrikaanse slaven. Deze waren aanvankelijk vooral afkomstig van veroverde vijandelijke schepen. Maar hun aantallen waren tot midden zeventiende eeuw nog gering.\r\n\r\nVrijwel direct nadat bekend werd dat Curaçao was veroverd, ontstond er in het moederland belangstelling voor kolonisatieprojecten. Militairen en civiele beambten op het eiland, die hun contract hadden uitgediend, kregen ook de mogelijkheid om zich als landbouwer te vestigen. Maar dit leidde nauwelijks tot concrete resultaten.\r\n\r\nIn de jaren vijftig van zeventiende eeuw vestigden zich joodse kolonisten op het eiland. In 1665 woonden er, de inheemse bevolking niet meegerekend, zo’n 600 personen.Curaçao had inmiddels geen functie meer als oorlogsbasis, maar ontwikkelde zich nu, met de vanaf 1650 opkomende slavenhandel als motor, tot een commercieel centrum.Rond deze tijd ontstond ten noorden van fort Amsterdam een vestiging die uitgroeide tot een ommuurde stad, Willemstad. Het aantal plantages en tuinen groeide ook. Deze richtten zich vooral op de lokale voedselproductie.', '3. Verovering door de WIC en de komst van de Hollanders', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2017-09-16 18:57:10', '2017-09-16 16:57:10', '', '12', 'https://canoncuracao.cw/12-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('402', '4', '2017-09-16 18:57:47', '2017-09-16 16:57:47', '<h3>De verovering van Curaçao</h3>\r\nCuraçao werd in 1634 door de West-Indische Compagnie (WIC) veroverd op de Spanjaarden.\r\n\r\nDe Republiek was op dat moment verwikkeld in de Tachtigjarige Oorlog (1568-1648) met Spanje en metPortugal. Deze landen waren sinds 1580 verenigd waren onder één staatshoofd, de Spaanse koning. De WIC was in 1621 opgericht om te dienen als een instrument in die oorlog. Behalve met de uitvoering van een ambitieus plan, het ‘groot desseyn’,dat gericht was op het veroveren van Portugese gebieden in Afrika en Brazilië, was de WIC vooral actief in de kaapvaart. Er bestond daarom behoefte aan een maritiem steunpunt in het operatiegebied van waaruit militaire acties konden worden ondernomen.Het strategisch gunstig gelegen Curaçao was daarvoor uitstekend geschikt. Het eiland was goed verdedigbaar en beschikte over een uitstekende natuurlijke haven, de Sint-Annabaai.\r\n\r\nEen expeditie onder leiding van Johannes van Walbeeck en Pierre le Grand slaagde er vrij eenvoudig in om Curaçao te overmeesteren. De kleine Spaanse bezetting werd samen met het grootste deel van de inheemse bevolking gedeporteerd naar Venezuela. Daarna werd een begin gemaakt met het op orde brengen van de verdediging. Aan oostelijke zijde van de ingang van de Sint-Annabaai op een landtong die De Punt (Punda) werd genoemd werd een sterkte gebouwd, fort Amsterdam.\r\n<h3>Van oorlogsbasis naar vestigingskolonie</h3>\r\nGedurende de eerste jaren na de verovering verbleven er op Curaçao in hoofdzaak militairen. In 1635 waren slechts 20 van de 412 compagniesdienaren burgers. Er woonden verder zo’n 50 inheemse bewoners. Spoedig arriveerden ook Afrikaanse slaven. Deze waren aanvankelijk vooral afkomstig van veroverde vijandelijke schepen. Maar hun aantallen waren tot midden zeventiende eeuw nog gering.\r\n\r\nVrijwel direct nadat bekend werd dat Curaçao was veroverd, ontstond er in het moederland belangstelling voor kolonisatieprojecten. Militairen en civiele beambten op het eiland, die hun contract hadden uitgediend, kregen ook de mogelijkheid om zich als landbouwer te vestigen. Maar dit leidde nauwelijks tot concrete resultaten.\r\n\r\nIn de jaren vijftig van zeventiende eeuw vestigden zich joodse kolonisten op het eiland. In 1665 woonden er, de inheemse bevolking niet meegerekend, zo’n 600 personen.Curaçao had inmiddels geen functie meer als oorlogsbasis, maar ontwikkelde zich nu, met de vanaf 1650 opkomende slavenhandel als motor, tot een commercieel centrum.Rond deze tijd ontstond ten noorden van fort Amsterdam een vestiging die uitgroeide tot een ommuurde stad, Willemstad. Het aantal plantages en tuinen groeide ook. Deze richtten zich vooral op de lokale voedselproductie.', '3. Verovering door de WIC en de komst van de Hollanders', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2017-09-16 18:57:47', '2017-09-16 16:57:47', '', '12', 'https://canoncuracao.cw/12-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('403', '4', '2017-09-16 19:02:59', '2017-09-16 17:02:59', '', 'Carosa globofoto uit independiente1 (Medium)', '', 'inherit', 'open', 'closed', '', 'carosa-globofoto-uit-independiente1-medium', '', '', '2017-09-16 19:03:06', '2017-09-16 17:03:06', '', '81', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Carosa-globofoto-uit-independiente1-Medium.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('404', '4', '2017-09-16 19:03:41', '2017-09-16 17:03:41', '', '38. Carnaval', '', 'inherit', 'closed', 'closed', '', '81-revision-v1', '', '', '2017-09-16 19:03:41', '2017-09-16 17:03:41', '', '81', 'https://canoncuracao.cw/81-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('405', '4', '2017-09-16 19:04:20', '2017-09-16 17:04:20', '', 'Carosa globofoto uit independiente2', '', 'inherit', 'open', 'closed', '', 'carosa-globofoto-uit-independiente2', '', '', '2017-09-16 19:04:23', '2017-09-16 17:04:23', '', '81', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Carosa-globofoto-uit-independiente2.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('406', '4', '2017-09-16 19:04:26', '2017-09-16 17:04:26', '', '38. Carnaval', '', 'inherit', 'closed', 'closed', '', '81-revision-v1', '', '', '2017-09-16 19:04:26', '2017-09-16 17:04:26', '', '81', 'https://canoncuracao.cw/81-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('409', '4', '2017-09-16 19:08:53', '2017-09-16 17:08:53', '', 'H8 5 Referendum bord', '', 'inherit', 'open', 'closed', '', 'h8-5-referendum-bord-2', '', '', '2017-09-16 19:08:57', '2017-09-16 17:08:57', '', '73', 'https://canoncuracao.cw/wp-content/uploads/2017/05/H8-5-Referendum-bord.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('410', '4', '2017-09-16 19:09:01', '2017-09-16 17:09:01', '', '34. De staatkundige ontwikkelingen vanaf het statuut tot 10 oktober 2010', '', 'inherit', 'closed', 'closed', '', '73-revision-v1', '', '', '2017-09-16 19:09:01', '2017-09-16 17:09:01', '', '73', 'https://canoncuracao.cw/73-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('414', '4', '2017-09-19 21:39:39', '2017-09-19 19:39:39', '', 'H1', '', 'inherit', 'open', 'closed', '', 'h1', '', '', '2017-09-19 21:39:44', '2017-09-19 19:39:44', '', '103', 'https://canoncuracao.cw/wp-content/uploads/2017/05/H1.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('415', '4', '2017-09-19 21:39:51', '2017-09-19 19:39:51', '', '49. De ontwikkeling van het electriciteitsnet, de watervoorziening en het telefoonnet', '', 'inherit', 'closed', 'closed', '', '103-revision-v1', '', '', '2017-09-19 21:39:51', '2017-09-19 19:39:51', '', '103', 'https://canoncuracao.cw/103-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('417', '4', '2017-09-19 21:58:17', '2017-09-19 19:58:17', '', '89-102B Botica excelsior', '', 'inherit', 'open', 'closed', '', '89-102b-botica-excelsior', '', '', '2017-09-19 21:58:23', '2017-09-19 19:58:23', '', '89', 'https://canoncuracao.cw/wp-content/uploads/2017/05/89-102B-Botica-excelsior.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('418', '4', '2017-09-19 21:58:34', '2017-09-19 19:58:34', '', '42. De pluriforme samenleving', '', 'inherit', 'closed', 'closed', '', '89-revision-v1', '', '', '2017-09-19 21:58:34', '2017-09-19 19:58:34', '', '89', 'https://canoncuracao.cw/89-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('420', '4', '2017-09-19 22:22:43', '2017-09-19 20:22:43', '', 'papiamentu1', '', 'inherit', 'open', 'closed', '', 'papiamentu1', '', '', '2017-09-19 22:22:46', '2017-09-19 20:22:46', '', '21', 'https://canoncuracao.cw/wp-content/uploads/2017/05/papiamentu1.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('421', '4', '2017-09-19 22:22:50', '2017-09-19 20:22:51', '', '8. Papiamentu', '', 'inherit', 'closed', 'closed', '', '21-revision-v1', '', '', '2017-09-19 22:22:50', '2017-09-19 20:22:51', '', '21', 'https://canoncuracao.cw/21-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('423', '4', '2017-09-19 22:33:23', '2017-09-19 20:33:23', '', '23 de mayo castro002', '', 'inherit', 'open', 'closed', '', '23-de-mayo-castro002', '', '', '2017-09-19 22:33:33', '2017-09-19 20:33:33', '', '95', 'https://canoncuracao.cw/wp-content/uploads/2017/05/23-de-mayo-castro002.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('424', '4', '2017-09-19 22:38:00', '2017-09-19 20:38:00', '', '45. De relatie met Venezuela', '', 'inherit', 'closed', 'closed', '', '95-revision-v1', '', '', '2017-09-19 22:38:00', '2017-09-19 20:38:00', '', '95', 'https://canoncuracao.cw/95-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('426', '4', '2017-09-19 22:40:17', '2017-09-19 20:40:17', '', '23 de mayo castro_OV', '', 'inherit', 'open', 'closed', '', '23-de-mayo-castro_ov', '', '', '2017-09-19 22:40:23', '2017-09-19 20:40:23', '', '95', 'https://canoncuracao.cw/wp-content/uploads/2017/05/23-de-mayo-castro_OV.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('427', '4', '2017-09-19 22:40:27', '2017-09-19 20:40:27', '', '45. De relatie met Venezuela', '', 'inherit', 'closed', 'closed', '', '95-revision-v1', '', '', '2017-09-19 22:40:27', '2017-09-19 20:40:27', '', '95', 'https://canoncuracao.cw/95-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('437', '5', '2017-11-14 16:16:52', '2017-11-14 15:16:52', 'De allervroegste aanwijzingen voor de aanwezigheid van mensen op Curaçao dateert van ongeveer 3400 voor Christus. Rond deze tijd komen indianen van het vasteland van Venezuela en Colombia per kano richting Curaçao (en later ook naar Aruba en Bonaire). Archeologische resten uit deze vroege (pre-ceramische of Archaïsche) periode vinden we terug bij onder andere Rooi Rincon, de Sint Jorisbaai en Seru Boca. Deze indianen leefden voornamelijk van schelpdieren. Sporen van hun aanwezigheid we dan ook in groten getale terug in de vorm van zogenaamde shell middens (schelphopen). Hierin vinden we ook hun werktuigen van schelp, steen en koraal terug. Ze maakten zelf geen aardewerk en zullen bijvoorbeeld kalebassen gebruikt hebben als schalen. Behalve schelpdieren zullen ze ook vruchten verzameld hebben. \nHoewel onduidelijk is of deze indianen daadwerkelijk op Curaçao hebben gewoond of alleen in bepaalde seizoenen langskwamen, is het vrijwel zeker dat rond 2000 voor Christus echt sprake is van bewoning op Curaçao. De oudste menselijke resten die zijn teruggevonden aan de voet van de Sint Michielsberg (circa 2000-1650 voor Christus), vormen hiervoor een aanwijzing. Het ligt voor de hand dat de verwanten van deze overledenen in de directe omgeving hebben gewoond, aangezien het gebruikelijk was om de overledenen binnen de nederzetting en zelfs binnen huizen te begraven. \nEr zijn aanwijzingen dat rond 1000 voor Christus  onversierd aardewerk wordt gebruikt. Kleine fragmenten hiervan zijn in kleine hoeveelheden  bij het Spaanse Water en de Vlakte van Hato aangetroffen. Het is mogelijk dat dit aardewerk van het vasteland is meegenomen. Vermoedelijk worden vanaf deze periode en mogelijk al eerder, rotstekeningen aangebracht op kalkstenen rotswanden en losse rotsblokken (bijvoorbeeld Savonet).\nDe ceramische periode begint op Curaçao rond 1000 na Christus met grote nederzettingen zoals bijvoorbeeld De Savaan, San Juan en Santa Cruz. Hier vinden we resten terug van bewoning in de vorm van paalgaten, haardplaatsen en graven. Deze Caquetio indianen maakten ‘Dabajuroid’ aardewerk. Dit is te herkennen aan de zwarte, bruine, rode en witte versiering door middel van voornamelijk lijnen en stippen. Soms werden op het aardewerk ook dierenkoppen afgebeeld. Ook de Caquetio hebben shell middens achtergelaten, maar met daarin een grote hoeveelheid aardewerk, sieraden, bijlen, maalstenen, en andere werktuigen van steen, schelp, koraal en dierlijk bot. De taal die de Caquetio spraken is waarschijnlijk een variant van de Arawak taalfamilie geweest. Naast schelpdieren zullen de Caquetio ook maniok, maïs en fruit gegeten hebben dat ze verbouwden in tuinen. Ze stonden bij de Spanjaarden bekend als goede landbouwers en kanovaarders. De aanwezigheid van maïs en maniok blijkt uit resten van vuursteen voor het raspen van maniok en maalstenen voor het bewerken van maïs. \n\n', '1. De oorspronkelijke bewoners', '', 'inherit', 'closed', 'closed', '', '8-autosave-v1', '', '', '2017-11-14 16:16:52', '2017-11-14 15:16:52', '', '8', 'https://canoncuracao.cw/8-autosave-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('438', '5', '2017-11-14 16:17:20', '2017-11-14 15:17:20', 'De allervroegste aanwijzingen voor de aanwezigheid van mensen op Curaçao dateert van ongeveer 3400 voor Christus. Rond deze tijd komen indianen van het vasteland van Venezuela en Colombia per kano richting Curaçao (en later ook naar Aruba en Bonaire). Archeologische resten uit deze vroege (pre-ceramische of Archaïsche) periode vinden we terug bij onder andere Rooi Rincon, de Sint Jorisbaai en Seru Boca. Deze indianen leefden voornamelijk van schelpdieren. Sporen van hun aanwezigheid we dan ook in groten getale terug in de vorm van zogenaamde shell middens (schelphopen). Hierin vinden we ook hun werktuigen van schelp, steen en koraal terug. Ze maakten zelf geen aardewerk en zullen bijvoorbeeld kalebassen gebruikt hebben als schalen. Behalve schelpdieren zullen ze ook vruchten verzameld hebben. \r\n\r\nHoewel onduidelijk is of deze indianen daadwerkelijk op Curaçao hebben gewoond of alleen in bepaalde seizoenen langskwamen, is het vrijwel zeker dat rond 2000 voor Christus echt sprake is van bewoning op Curaçao. De oudste menselijke resten die zijn teruggevonden aan de voet van de Sint Michielsberg (circa 2000-1650 voor Christus), vormen hiervoor een aanwijzing. Het ligt voor de hand dat de verwanten van deze overledenen in de directe omgeving hebben gewoond, aangezien het gebruikelijk was om de overledenen binnen de nederzetting en zelfs binnen huizen te begraven. \r\nEr zijn aanwijzingen dat rond 1000 voor Christus  onversierd aardewerk wordt gebruikt. Kleine fragmenten hiervan zijn in kleine hoeveelheden  bij het Spaanse Water en de Vlakte van Hato aangetroffen. Het is mogelijk dat dit aardewerk van het vasteland is meegenomen. Vermoedelijk worden vanaf deze periode en mogelijk al eerder, rotstekeningen aangebracht op kalkstenen rotswanden en losse rotsblokken (bijvoorbeeld Savonet).\r\nDe ceramische periode begint op Curaçao rond 1000 na Christus met grote nederzettingen zoals bijvoorbeeld De Savaan, San Juan en Santa Cruz. Hier vinden we resten terug van bewoning in de vorm van paalgaten, haardplaatsen en graven. Deze Caquetio indianen maakten ‘Dabajuroid’ aardewerk. Dit is te herkennen aan de zwarte, bruine, rode en witte versiering door middel van voornamelijk lijnen en stippen. Soms werden op het aardewerk ook dierenkoppen afgebeeld. Ook de Caquetio hebben shell middens achtergelaten, maar met daarin een grote hoeveelheid aardewerk, sieraden, bijlen, maalstenen, en andere werktuigen van steen, schelp, koraal en dierlijk bot. De taal die de Caquetio spraken is waarschijnlijk een variant van de Arawak taalfamilie geweest. Naast schelpdieren zullen de Caquetio ook maniok, maïs en fruit gegeten hebben dat ze verbouwden in tuinen. Ze stonden bij de Spanjaarden bekend als goede landbouwers en kanovaarders. De aanwezigheid van maïs en maniok blijkt uit resten van vuursteen voor het raspen van maniok en maalstenen voor het bewerken van maïs. \r\n\r\n', '1. De oorspronkelijke bewoners', '', 'inherit', 'closed', 'closed', '', '8-revision-v1', '', '', '2017-11-14 16:17:20', '2017-11-14 15:17:20', '', '8', 'https://canoncuracao.cw/8-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('439', '5', '2017-11-14 16:18:10', '2017-11-14 15:18:10', 'De allervroegste aanwijzingen voor de aanwezigheid van mensen op Curaçao dateert van ongeveer 3400 voor Christus. Rond deze tijd komen indianen van het vasteland van Venezuela en Colombia per kano richting Curaçao (en later ook naar Aruba en Bonaire). Archeologische resten uit deze vroege (pre-ceramische of Archaïsche) periode vinden we terug bij onder andere Rooi Rincon, de Sint Jorisbaai en Seru Boca. Deze indianen leefden voornamelijk van schelpdieren. Sporen van hun aanwezigheid we dan ook in groten getale terug in de vorm van zogenaamde shell middens (schelphopen). Hierin vinden we ook hun werktuigen van schelp, steen en koraal terug. Ze maakten zelf geen aardewerk en zullen bijvoorbeeld kalebassen gebruikt hebben als schalen. Behalve schelpdieren zullen ze ook vruchten verzameld hebben. \r\n\r\nHoewel onduidelijk is of deze indianen daadwerkelijk op Curaçao hebben gewoond of alleen in bepaalde seizoenen langskwamen, is het vrijwel zeker dat rond 2000 voor Christus echt sprake is van bewoning op Curaçao. De oudste menselijke resten die zijn teruggevonden aan de voet van de Sint Michielsberg (circa 2000-1650 voor Christus), vormen hiervoor een aanwijzing. Het ligt voor de hand dat de verwanten van deze overledenen in de directe omgeving hebben gewoond, aangezien het gebruikelijk was om de overledenen binnen de nederzetting en zelfs binnen huizen te begraven. \r\nEr zijn aanwijzingen dat rond 1000 voor Christus  onversierd aardewerk wordt gebruikt. Kleine fragmenten hiervan zijn in kleine hoeveelheden  bij het Spaanse Water en de Vlakte van Hato aangetroffen. Het is mogelijk dat dit aardewerk van het vasteland is meegenomen. Vermoedelijk worden vanaf deze periode en mogelijk al eerder, rotstekeningen aangebracht op kalkstenen rotswanden en losse rotsblokken (bijvoorbeeld Savonet).\r\nDe ceramische periode begint op Curaçao rond 1000 na Christus met grote nederzettingen zoals bijvoorbeeld De Savaan, San Juan en Santa Cruz. Hier vinden we resten terug van bewoning in de vorm van paalgaten, haardplaatsen en graven. Deze Caquetio indianen maakten ‘Dabajuroid’ aardewerk. Dit is te herkennen aan de zwarte, bruine, rode en witte versiering door middel van voornamelijk lijnen en stippen. Soms werden op het aardewerk ook dierenkoppen afgebeeld. Ook de Caquetio hebben shell middens achtergelaten, maar met daarin een grote hoeveelheid aardewerk, sieraden, bijlen, maalstenen, en andere werktuigen van steen, schelp, koraal en dierlijk bot. De taal die de Caquetio spraken is waarschijnlijk een variant van de Arawak taalfamilie geweest. Naast schelpdieren zullen de Caquetio ook maniok, maïs en fruit gegeten hebben dat ze verbouwden in tuinen. Ze stonden bij de Spanjaarden bekend als goede landbouwers en kanovaarders. De aanwezigheid van maïs en maniok blijkt uit resten van vuursteen voor het raspen van maniok en maalstenen voor het bewerken van maïs. \r\n\r\n', '1. De oorspronkelijke bewoners', '', 'inherit', 'closed', 'closed', '', '8-revision-v1', '', '', '2017-11-14 16:18:10', '2017-11-14 15:18:10', '', '8', 'https://canoncuracao.cw/8-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('440', '5', '2017-11-14 16:21:37', '2017-11-14 15:21:37', 'Van 1499 tot 1634 stond Curaçao onder Spaans gezag.\n\nIn 1499 was Alonso de Ojeda de eerste Spanjaard die Curaçao bezocht. Hij was de leider van een Spaanse expeditie die het Caribisch gebied doorkruiste, waaraan ook Amerigo Vespucci en Juan de la Cosa als ‘pilotos’ (stuurmannen) deelnamen.  \n\nVoor de Spaanse zeelieden waren de Indiaanse bewoners van Curaçao kennelijk erg groot en daarom werd het eiland “Isla de los Gigantes” (eiland der reuzen) genoemd. Over de oorsprong van de naam ‘Curaçao’ is veel gespeculeerd, maar er is geen duidelijke verklaring. Vast staat wel dat de naam van Indiaanse oorsprong is. \n\nVerspreid over  Curaçao lagen een aantal Indiaanse dorpen, waaronder Santa Cruz, waar de ‘cacique’ (opperhoofd) woonde. Er ware in de eerste jaren nadat de Spanjaarden het eiland in 1499 hadden ingenomen geen Spaanse bestuurders op Curaçao. Waarschijnlijk kreeg Alonso de Ojeda van de Spaanse koningen wel de bevoegdheid om Curaçao te besturen, maar hij is nooit als bestuurder op het eiland geweest.\n\nDoor de grote sterfte onder de Indiaanse bevolking van Hispañola, het eiland waarop nu Haïti en de Dominicaanse Republiek liggen, veroorzaakt door de wrede behandelingen de geringe weerstand tegen Europese ziekten, ontstond daar een nijpend tekort aan arbeidskrachten. In 1513 was dit tekort zo groot, dat Don Diego Colon, de zoon van Columbus, toestemming kreeg om Aruba, Curaçao en Bonaire tot’ islas inútiles’, onnutte eilanden, te verklaren. Dit hield in dat officieel werd vastgesteld dat daar geen edele metalen werden gevonden en de eilanden ook niet geschikt warenvoor de landbouw. Dit had als gevolg dat de Indianen van deze eilanden gevangen genomen mochten worden en dat ze allen vervoerd werden naar Hispañola om daar als tot slaaf gemaakte te werken..\n\nIn 1526 kreeg Juan de Ampués, de Gouverneur van Venezuela, Curaçao in leen en de taak om Curaçao te herbevolken. Bovendien moest hij de Indianen kerstenen en het eiland tot een handelspost ontwikkelen voor onder andere verfhout en huiden. Tijdens het gouverneurschap van Juan de Ampués nam de bevolking van Cu¬raçao toe tot ongeveer 150 inwoners.\n\nNa de dood van Juan de Ampués in 1533 werd Curaçao bestuurd door zijn schoonzoon, Lázaro Bejarano, en zijn dochter Maria de Ampués. Lázaro Bejarano zou Curaçao ontwikkelen tot een grote ‘hacienda’, een plaats waar vee wordt gehouden.\nVervolgens kwam Curaçao eerst onder het directe bestuur van de Audiencia van Hispañola en kort daarop viel het eiland onder de gouverneur van Caracas. Curaçao werd toen lokaal bestuurd door ‘veedores’, opzichters. Van 1571-1634 was Curaçao ook een verversings¬station voor kapers, piraten en andere zeelieden.\n\nIn 1634 werd het eiland op de Spanjaarden veroverd door Johan van Walbeeck. Sinds die tijd, met een korte onderbreking in 1800-1803 en 1807-1816, toen de Britten Curaçao bestuurden, is het eiland met Nederland verbonden geweest.\n\n', '2. De Spaanse periode', '', 'inherit', 'closed', 'closed', '', '10-autosave-v1', '', '', '2017-11-14 16:21:37', '2017-11-14 15:21:37', '', '10', 'https://canoncuracao.cw/10-autosave-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('441', '5', '2017-11-14 16:22:06', '2017-11-14 15:22:06', 'Van 1499 tot 1634 stond Curaçao onder Spaans gezag.\r\n\r\nIn 1499 was Alonso de Ojeda de eerste Spanjaard die Curaçao bezocht. Hij was de leider van een Spaanse expeditie die het Caribisch gebied doorkruiste, waaraan ook Amerigo Vespucci en Juan de la Cosa als ‘pilotos’ (stuurmannen) deelnamen.  \r\n\r\nVoor de Spaanse zeelieden waren de Indiaanse bewoners van Curaçao kennelijk erg groot en daarom werd het eiland “Isla de los Gigantes” (eiland der reuzen) genoemd. Over de oorsprong van de naam ‘Curaçao’ is veel gespeculeerd, maar er is geen duidelijke verklaring. Vast staat wel dat de naam van Indiaanse oorsprong is. \r\n\r\nVerspreid over  Curaçao lagen een aantal Indiaanse dorpen, waaronder Santa Cruz, waar de ‘cacique’ (opperhoofd) woonde. Er ware in de eerste jaren nadat de Spanjaarden het eiland in 1499 hadden ingenomen geen Spaanse bestuurders op Curaçao. Waarschijnlijk kreeg Alonso de Ojeda van de Spaanse koningen wel de bevoegdheid om Curaçao te besturen, maar hij is nooit als bestuurder op het eiland geweest.\r\n\r\nDoor de grote sterfte onder de Indiaanse bevolking van Hispañola, het eiland waarop nu Haïti en de Dominicaanse Republiek liggen, veroorzaakt door de wrede behandelingen de geringe weerstand tegen Europese ziekten, ontstond daar een nijpend tekort aan arbeidskrachten. In 1513 was dit tekort zo groot, dat Don Diego Colon, de zoon van Columbus, toestemming kreeg om Aruba, Curaçao en Bonaire tot’ islas inútiles’, onnutte eilanden, te verklaren. Dit hield in dat officieel werd vastgesteld dat daar geen edele metalen werden gevonden en de eilanden ook niet geschikt warenvoor de landbouw. Dit had als gevolg dat de Indianen van deze eilanden gevangen genomen mochten worden en dat ze allen vervoerd werden naar Hispañola om daar als tot slaaf gemaakte te werken..\r\n\r\nIn 1526 kreeg Juan de Ampués, de Gouverneur van Venezuela, Curaçao in leen en de taak om Curaçao te herbevolken. Bovendien moest hij de Indianen kerstenen en het eiland tot een handelspost ontwikkelen voor onder andere verfhout en huiden. Tijdens het gouverneurschap van Juan de Ampués nam de bevolking van Cu¬raçao toe tot ongeveer 150 inwoners.\r\n\r\nNa de dood van Juan de Ampués in 1533 werd Curaçao bestuurd door zijn schoonzoon, Lázaro Bejarano, en zijn dochter Maria de Ampués. Lázaro Bejarano zou Curaçao ontwikkelen tot een grote ‘hacienda’, een plaats waar vee wordt gehouden.\r\nVervolgens kwam Curaçao eerst onder het directe bestuur van de Audiencia van Hispañola en kort daarop viel het eiland onder de gouverneur van Caracas. Curaçao werd toen lokaal bestuurd door ‘veedores’, opzichters. Van 1571-1634 was Curaçao ook een verversings¬station voor kapers, piraten en andere zeelieden.\r\n\r\nIn 1634 werd het eiland op de Spanjaarden veroverd door Johan van Walbeeck. Sinds die tijd, met een korte onderbreking in 1800-1803 en 1807-1816, toen de Britten Curaçao bestuurden, is het eiland met Nederland verbonden geweest.\r\n\r\n', '2. De Spaanse periode', '', 'inherit', 'closed', 'closed', '', '10-revision-v1', '', '', '2017-11-14 16:22:06', '2017-11-14 15:22:06', '', '10', 'https://canoncuracao.cw/10-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('442', '5', '2017-11-14 16:22:50', '2017-11-14 15:22:50', 'Van 1499 tot 1634 stond Curaçao onder Spaans gezag. In 1499 was Alonso de Ojeda de eerste Spanjaard die Curaçao bezocht. Hij was de leider van een Spaanse expeditie die het Caribisch gebied doorkruiste, waaraan ook Amerigo Vespucci en Juan de la Cosa als ‘pilotos’ (stuurmannen) deelnamen.  \r\n\r\nVoor de Spaanse zeelieden waren de Indiaanse bewoners van Curaçao kennelijk erg groot en daarom werd het eiland “Isla de los Gigantes” (eiland der reuzen) genoemd. Over de oorsprong van de naam ‘Curaçao’ is veel gespeculeerd, maar er is geen duidelijke verklaring. Vast staat wel dat de naam van Indiaanse oorsprong is. \r\n\r\nVerspreid over  Curaçao lagen een aantal Indiaanse dorpen, waaronder Santa Cruz, waar de ‘cacique’ (opperhoofd) woonde. Er ware in de eerste jaren nadat de Spanjaarden het eiland in 1499 hadden ingenomen geen Spaanse bestuurders op Curaçao. Waarschijnlijk kreeg Alonso de Ojeda van de Spaanse koningen wel de bevoegdheid om Curaçao te besturen, maar hij is nooit als bestuurder op het eiland geweest.\r\n\r\nDoor de grote sterfte onder de Indiaanse bevolking van Hispañola, het eiland waarop nu Haïti en de Dominicaanse Republiek liggen, veroorzaakt door de wrede behandelingen de geringe weerstand tegen Europese ziekten, ontstond daar een nijpend tekort aan arbeidskrachten. In 1513 was dit tekort zo groot, dat Don Diego Colon, de zoon van Columbus, toestemming kreeg om Aruba, Curaçao en Bonaire tot’ islas inútiles’, onnutte eilanden, te verklaren. Dit hield in dat officieel werd vastgesteld dat daar geen edele metalen werden gevonden en de eilanden ook niet geschikt warenvoor de landbouw. Dit had als gevolg dat de Indianen van deze eilanden gevangen genomen mochten worden en dat ze allen vervoerd werden naar Hispañola om daar als tot slaaf gemaakte te werken..\r\n\r\nIn 1526 kreeg Juan de Ampués, de Gouverneur van Venezuela, Curaçao in leen en de taak om Curaçao te herbevolken. Bovendien moest hij de Indianen kerstenen en het eiland tot een handelspost ontwikkelen voor onder andere verfhout en huiden. Tijdens het gouverneurschap van Juan de Ampués nam de bevolking van Cu¬raçao toe tot ongeveer 150 inwoners.\r\n\r\nNa de dood van Juan de Ampués in 1533 werd Curaçao bestuurd door zijn schoonzoon, Lázaro Bejarano, en zijn dochter Maria de Ampués. Lázaro Bejarano zou Curaçao ontwikkelen tot een grote ‘hacienda’, een plaats waar vee wordt gehouden.\r\nVervolgens kwam Curaçao eerst onder het directe bestuur van de Audiencia van Hispañola en kort daarop viel het eiland onder de gouverneur van Caracas. Curaçao werd toen lokaal bestuurd door ‘veedores’, opzichters. Van 1571-1634 was Curaçao ook een verversings¬station voor kapers, piraten en andere zeelieden.\r\n\r\nIn 1634 werd het eiland op de Spanjaarden veroverd door Johan van Walbeeck. Sinds die tijd, met een korte onderbreking in 1800-1803 en 1807-1816, toen de Britten Curaçao bestuurden, is het eiland met Nederland verbonden geweest.\r\n\r\n', '2. De Spaanse periode', '', 'inherit', 'closed', 'closed', '', '10-revision-v1', '', '', '2017-11-14 16:22:50', '2017-11-14 15:22:50', '', '10', 'https://canoncuracao.cw/10-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('443', '5', '2017-11-14 16:27:38', '2017-11-14 15:27:38', '<h3>De verovering van Curaçao</h3>\nCuraçao werd in 1634 door de West-Indische Compagnie (W.I.C.) veroverd op de Spanjaarden. De Republiek was op dat moment verwikkeld in de Tachtigjarige Oorlog (1568-1648) met Spanje en Portugal. Deze landen waren sinds 1580 verenigd  onder één staatshoofd, de Spaanse koning. De W.I.C. was in 1621 opgericht om te dienen als een instrument in die oorlog. Behalve met de uitvoering van een ambitieus plan, het ‘Groot Desseyn’,dat gericht was op het veroveren van Portugese gebieden in Afrika en Brazilië, was de W.I.C. vooral actief in de kaapvaart. Er bestond daarom behoefte aan een maritiem steunpunt in het operatiegebied van waaruit militaire acties konden worden ondernomen. Het strategisch gunstig gelegen Curaçao was daarvoor uitstekend geschikt. Het eiland leek goed verdedigbaar en beschikte over een uitstekende natuurlijke haven, de Sint-Annabaai.\nEen expeditie onder leiding van Johannes van Walbeeck en Pierre le Grand ontmoette weinig weerstand en nam Curaçao in bezit. De kleine Spaanse bezetting werd samen met het grootste deel van de inheemse bevolking gedeporteerd naar Venezuela. Daarna werd een begin gemaakt met het op orde brengen van de verdediging. Aan de oostelijke zijde van de ingang van de Sint-Annabaai, op een landtong die De Punt (Punda) werd genoemd, werd een sterkte gebouwd, Fort Amsterdam.\n\n<h3>Van oorlogsbasis naar vestigingskolonie</h3>\nGedurende de eerste jaren na de verovering verbleven er op Curaçao in hoofdzaak militairen. In 1635 waren slechts 20 van de 412 compagniesdienaren burgers. Er woonden verder zo’n 50  inheemse bewoners. Spoedig arriveerden ook tot slaaf gemaakte Afrikanen. Dezen waren aanvankelijk vooral afkomstig van veroverde vijandelijke schepen. Maar hun aantallen waren tot midden zeventiende eeuw nog gering.\nVrijwel direct nadat bekend werd dat Curaçao was veroverd, ontstond er in het moederland belangstelling voor kolonisatieprojecten. Militairen en civiele beambten op het eiland, die hun contract hadden uitgediend, kregen ook de mogelijkheid om zich als landbouwer te vestigen. Maar dit leidde nauwelijks tot concrete resultaten.\nIn de jaren vijftig van zeventiende eeuw vestigden zich joodse kolonisten op het eiland. In 1665 woonden er, de inheemse bevolking niet meegerekend, zo’n 600 personen. Curaçao had inmiddels geen functie meer als oorlogsbasis, maar ontwikkelde zich nu, met de vanaf 1650 opkomende slavenhandel als motor, tot een commercieel centrum. Rond deze tijd ontstond ten noorden van Fort Amsterdam een vestiging die uitgroeide tot een ommuurde stad, Willemstad. Het aantal plantages en tuinen groeide ook. Deze richtten zich vooral op de lokale voedselproductie.\n', '3. De verovering van Curaçao door de W.I.C. en de komst van de Hollanders', '', 'inherit', 'closed', 'closed', '', '12-autosave-v1', '', '', '2017-11-14 16:27:38', '2017-11-14 15:27:38', '', '12', 'https://canoncuracao.cw/12-autosave-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('444', '5', '2017-11-14 16:28:27', '2017-11-14 15:28:27', '<h3>De verovering van Curaçao</h3>\r\nCuraçao werd in 1634 door de West-Indische Compagnie (W.I.C.) veroverd op de Spanjaarden. De Republiek was op dat moment verwikkeld in de Tachtigjarige Oorlog (1568-1648) met Spanje en Portugal. Deze landen waren sinds 1580 verenigd  onder één staatshoofd, de Spaanse koning. De W.I.C. was in 1621 opgericht om te dienen als een instrument in die oorlog. Behalve met de uitvoering van een ambitieus plan, het ‘Groot Desseyn’,dat gericht was op het veroveren van Portugese gebieden in Afrika en Brazilië, was de W.I.C. vooral actief in de kaapvaart. Er bestond daarom behoefte aan een maritiem steunpunt in het operatiegebied van waaruit militaire acties konden worden ondernomen. Het strategisch gunstig gelegen Curaçao was daarvoor uitstekend geschikt. Het eiland leek goed verdedigbaar en beschikte over een uitstekende natuurlijke haven, de Sint-Annabaai.\r\nEen expeditie onder leiding van Johannes van Walbeeck en Pierre le Grand ontmoette weinig weerstand en nam Curaçao in bezit. De kleine Spaanse bezetting werd samen met het grootste deel van de inheemse bevolking gedeporteerd naar Venezuela. Daarna werd een begin gemaakt met het op orde brengen van de verdediging. Aan de oostelijke zijde van de ingang van de Sint-Annabaai, op een landtong die De Punt (Punda) werd genoemd, werd een sterkte gebouwd, Fort Amsterdam.\r\n\r\n<h3>Van oorlogsbasis naar vestigingskolonie</h3>\r\nGedurende de eerste jaren na de verovering verbleven er op Curaçao in hoofdzaak militairen. In 1635 waren slechts 20 van de 412 compagniesdienaren burgers. Er woonden verder zo’n 50  inheemse bewoners. Spoedig arriveerden ook tot slaaf gemaakte Afrikanen. Dezen waren aanvankelijk vooral afkomstig van veroverde vijandelijke schepen. Maar hun aantallen waren tot midden zeventiende eeuw nog gering.\r\nVrijwel direct nadat bekend werd dat Curaçao was veroverd, ontstond er in het moederland belangstelling voor kolonisatieprojecten. Militairen en civiele beambten op het eiland, die hun contract hadden uitgediend, kregen ook de mogelijkheid om zich als landbouwer te vestigen. Maar dit leidde nauwelijks tot concrete resultaten.\r\nIn de jaren vijftig van zeventiende eeuw vestigden zich joodse kolonisten op het eiland. In 1665 woonden er, de inheemse bevolking niet meegerekend, zo’n 600 personen. Curaçao had inmiddels geen functie meer als oorlogsbasis, maar ontwikkelde zich nu, met de vanaf 1650 opkomende slavenhandel als motor, tot een commercieel centrum. Rond deze tijd ontstond ten noorden van Fort Amsterdam een vestiging die uitgroeide tot een ommuurde stad, Willemstad. Het aantal plantages en tuinen groeide ook. Deze richtten zich vooral op de lokale voedselproductie.\r\n', '3. De verovering van Curaçao door de W.I.C. en de komst van de Hollanders', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2017-11-14 16:28:27', '2017-11-14 15:28:27', '', '12', 'https://canoncuracao.cw/12-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('445', '5', '2017-11-14 16:36:22', '2017-11-14 15:36:22', '<h3>Een patriotseputsch</h3>\nToen in1795 de slavenopstand uitbrak,was er politieke onrust in Curaçao. Evenals in de Republiek stonden patriotten en Oranjegezinden tegenover elkaar. En evenals in het moederland, waar in 1795 met Franse steun de Bataafse Republiek werd uitgeroepen, wisten patriotten in Curaçao, gesteund door Franse kapers, in 1796 de macht te grijpen. De Bataafse Republiek kwam als bondgenoot van Frankrijk in de oorlog met Groot-Brittannië. Curaçao werd een belangrijk maritiem steunpunt voor de Fransen.\n<h3>Hervorming van de defensie</h3>\nNa de machtswisseling verkeerde het defensieapparaat in chaos. Oranjegezinde officieren van het garnizoen vertrokken hals over kop vanCuraçao. Kort daarna werd de gouverneur a.i., Jan Jacob Beaujon, die ervan werd verdacht Oranjegezind en pro-Brits te zijn, afgezet. Hij werd opgevolgd door de kapitein van de burgerij Johann RudolfLauffer, die de verdediging van Curaçao reorganiseerde. De oorspronkelijk exclusief blanke burgerwacht werd uitgebreid met vrije niet-blanken en omgedoopt tot Nationale Garde. Deze vrijen waren afkomstig uit de zeevarende bevolking en hadden ervaring met de bediening van scheepsgeschut. Gekleurde schippers kregen officiersrangen bij het onderdeel artillerie. Dit leidde tot spanningen binnen de Nationale Garde.\n<h3>Revolutionaire onrust</h3>\nGeïnspireerd door de leuzen ‘vrijheid’ en ‘gelijkheid’ van de Franse Revolutie (1789-1799),de succesvolle slavenopstand in de Franse kolonie Saint-Domingue in 1791en de Franse afschaffing van de slavernij in 1792, ontstond in de gehele regio revolutionaire onrust. De leiders van een mislukte opstand in Venezuela vluchtten in 1797 naar Curaçao. Geruchten over hun uitlevering veroorzaakte bijna een muiterij onder artilleristen van de Nationale Garde. In 1799 werden drie Fransen gearresteerd omdat zij, volgens Lauffer, de leiders waren van een complot om een nieuwe slavenopstand te ontketenen en de macht te grijpen. Alle drie werden zij uitgewezen.\n<h3>Aangevallen door de bondgenoot en gered door de vijand.</h3>\nIn 1800 verscheen een Franse militaire macht uit Guadeloupe voor de haven om, zo werd gemeld, Curaçao tegen de Britten te beschermen. Vermoed werd dat de Fransen uit waren op een machtsovername. Dit bleek inderdaad het geval. Na op aandringen van het gouvernement te zijn vertrokken, landden de Franse troepeneen dag later bij Sint-Michielsbaai. Daarna veroverden zij, gesteund door een groot deel van de Curaçaose slavenbevolking, op Willemstad na vrijwel het gehele eiland. Toen een Brits oorlogsschip voor de haven verscheen en vervolgens ook twee Amerikaanse oorlogsschepen, besloot het gouvernement hun hulp in te roepen. De Fransen werden verdreven, maar een Britse bezetting was het gevolg. In 1802 kwam Curaçao weer in Nederlandse handen.In 1807 veroverden de Britten Curaçao echter opnieuw.\n\nIn 1816 werd het eiland weer aan Nederland teruggegeven.\n\nNB\nRepubliek: De Republiek der Verenigde Nederlanden (1588 – 1795)\nPatriotten en Oranjegezinden: tussen 1781 en 1795 speelde in Nederland een conflict tussen de aanhangers van prins Willem V (oranjegezinden) en mensen die meer macht bij het volk wilden leggen (patriotten). Deze twee groepen stonden ook op Curaçao tegenover elkaar \nBataafse republiek: vanaf 1795 tot 1801 heette Nederland de Bataafse Republiek. Officieel was het land onafhankelijk maar in feite maakte Frankrijk de dienst uit. \n\n\n\n\nHan Jordaan', '9. Curaçao rond 1800', '', 'inherit', 'closed', 'closed', '', '23-autosave-v1', '', '', '2017-11-14 16:36:22', '2017-11-14 15:36:22', '', '23', 'https://canoncuracao.cw/23-autosave-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('446', '5', '2017-11-14 16:36:44', '2017-11-14 15:36:44', '<h3>Een patriotseputsch</h3>\r\nToen in1795 de slavenopstand uitbrak,was er politieke onrust in Curaçao. Evenals in de Republiek stonden patriotten en Oranjegezinden tegenover elkaar. En evenals in het moederland, waar in 1795 met Franse steun de Bataafse Republiek werd uitgeroepen, wisten patriotten in Curaçao, gesteund door Franse kapers, in 1796 de macht te grijpen. De Bataafse Republiek kwam als bondgenoot van Frankrijk in de oorlog met Groot-Brittannië. Curaçao werd een belangrijk maritiem steunpunt voor de Fransen.\r\n<h3>Hervorming van de defensie</h3>\r\nNa de machtswisseling verkeerde het defensieapparaat in chaos. Oranjegezinde officieren van het garnizoen vertrokken hals over kop vanCuraçao. Kort daarna werd de gouverneur a.i., Jan Jacob Beaujon, die ervan werd verdacht Oranjegezind en pro-Brits te zijn, afgezet. Hij werd opgevolgd door de kapitein van de burgerij Johann RudolfLauffer, die de verdediging van Curaçao reorganiseerde. De oorspronkelijk exclusief blanke burgerwacht werd uitgebreid met vrije niet-blanken en omgedoopt tot Nationale Garde. Deze vrijen waren afkomstig uit de zeevarende bevolking en hadden ervaring met de bediening van scheepsgeschut. Gekleurde schippers kregen officiersrangen bij het onderdeel artillerie. Dit leidde tot spanningen binnen de Nationale Garde.\r\n<h3>Revolutionaire onrust</h3>\r\nGeïnspireerd door de leuzen ‘vrijheid’ en ‘gelijkheid’ van de Franse Revolutie (1789-1799),de succesvolle slavenopstand in de Franse kolonie Saint-Domingue in 1791en de Franse afschaffing van de slavernij in 1792, ontstond in de gehele regio revolutionaire onrust. De leiders van een mislukte opstand in Venezuela vluchtten in 1797 naar Curaçao. Geruchten over hun uitlevering veroorzaakte bijna een muiterij onder artilleristen van de Nationale Garde. In 1799 werden drie Fransen gearresteerd omdat zij, volgens Lauffer, de leiders waren van een complot om een nieuwe slavenopstand te ontketenen en de macht te grijpen. Alle drie werden zij uitgewezen.\r\n<h3>Aangevallen door de bondgenoot en gered door de vijand.</h3>\r\nIn 1800 verscheen een Franse militaire macht uit Guadeloupe voor de haven om, zo werd gemeld, Curaçao tegen de Britten te beschermen. Vermoed werd dat de Fransen uit waren op een machtsovername. Dit bleek inderdaad het geval. Na op aandringen van het gouvernement te zijn vertrokken, landden de Franse troepeneen dag later bij Sint-Michielsbaai. Daarna veroverden zij, gesteund door een groot deel van de Curaçaose slavenbevolking, op Willemstad na vrijwel het gehele eiland. Toen een Brits oorlogsschip voor de haven verscheen en vervolgens ook twee Amerikaanse oorlogsschepen, besloot het gouvernement hun hulp in te roepen. De Fransen werden verdreven, maar een Britse bezetting was het gevolg. In 1802 kwam Curaçao weer in Nederlandse handen.In 1807 veroverden de Britten Curaçao echter opnieuw.\r\n\r\nIn 1816 werd het eiland weer aan Nederland teruggegeven.\r\n\r\nNB\r\nRepubliek: De Republiek der Verenigde Nederlanden (1588 – 1795)\r\nPatriotten en Oranjegezinden: tussen 1781 en 1795 speelde in Nederland een conflict tussen de aanhangers van prins Willem V (oranjegezinden) en mensen die meer macht bij het volk wilden leggen (patriotten). Deze twee groepen stonden ook op Curaçao tegenover elkaar \r\nBataafse republiek: vanaf 1795 tot 1801 heette Nederland de Bataafse Republiek. Officieel was het land onafhankelijk maar in feite maakte Frankrijk de dienst uit. \r\n\r\n\r\nHan Jordaan', '9. Curaçao rond 1800', '', 'inherit', 'closed', 'closed', '', '23-revision-v1', '', '', '2017-11-14 16:36:44', '2017-11-14 15:36:44', '', '23', 'https://canoncuracao.cw/23-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('447', '5', '2017-11-14 16:45:47', '2017-11-14 15:45:47', '', '11. De ontwikkeling van bewoning buiten Willemstad', '', 'inherit', 'closed', 'closed', '', '27-autosave-v1', '', '', '2017-11-14 16:45:47', '2017-11-14 15:45:47', '', '27', 'https://canoncuracao.cw/27-autosave-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('448', '5', '2017-11-14 16:46:12', '2017-11-14 15:46:12', 'De eerste activiteit van de WIC na de verovering van Curaçao in 1634 was het bouwen van een versterking, Fort Amsterdam. Rond dit fort ontstond de eerste nederzetting: Punda en de directe omgeving. \r\nOm voedsel voor de lokale bevolking te produceren stimuleerde de WIC de vestiging van plantages, die verspreid kwamen te liggen over het hele eiland. Alleen de minder goede gronden, de zogenaamde ‘savaangronden’, bleven in handen van de overheid. Op alle  plantages  kwamen buurtgemeenschappen of ‘dorpen’ voor, waar de als slaaf werkzame Afrikanen  woonden in ‘kas di pal\'i maishi\' (kleine lemen huisjes met een rieten dak). Dit waren de eerste  nederzettingen buiten het stadsdistrict. Ook na de afschaffing van de slavernij bleven  deze nederzettingskernen veelal bestaan, met name  in Banda\'bou (het westelijk deel van het eiland) het geval. De meeste ex-slaven bleven werken onder ‘paga tera-verhoudingen’, d.w.z. dat zij een eigen stukje grond op de plantage konden bewerken voor eigen gebruik mits zij enige dagen per jaar werkzaamheden voor de plantage-eigenaar verrichtten zonder dat zij daarvoor betaald werden.  Geleidelijk aan, vooral door conflicten met de plantage-eigenaren en achteruitgang van het plantage-gebeuren  verdwenen de meeste van deze buurtgemeenschappen. De dorpjes Knip en Soto zijn hierop uitzonderingen.\r\nIn de negentiende eeuw ontstonden er aanvullende en later deels vervangende nederzettingskernen op initiatief van de R.K. kerk.  Mgr. Niewindt wilde godsdienst en onderwijs brengen aan de buiten de stad woonachtige donkere  bevolking.  Daarom verdeelde  hij het gebied buiten het stadsdistrict in een beperkt aantal grote parochies en hij koos voor de centra van die parochies plaatsen die makkelijk  bereikbaar waren.  In de centra kwamen een kerkje en een kunukuschooltje (plattelandschooltje).  Hier omheen ontwikkelden zich de eerste kerkdorpen, beginnend met Barber, daarna Santa Rosa en Santa Maria. Later werden de parochies opgesplitst en zo ontstonden bijvoorbeeld de parochies San Willibrordo en Montagne. In deze nederzettingen vestigden zich ex-slaven, die zich losmaakten van de plantages en het paga terasysteem. \r\nNaast deze kerkelijke initiatieven waren er ook woonkernen van vrije lieden te Westpunt, San Pedro, Seru Fortuna en Boka Sami. \r\nNaast deze kernen vestigden ontstonden weer andere buurtschappen doordat al in de achttiende eeuw vrije lieden zich verspreid vestigden op de savaangronden. Deze ontwikkeling ging na de afschaffing van de ‎slavernij door. Andere buurtschappen ontstonden doordat de overheid, vooral aan het eind van de negentiende eeuw, percelen domeingrond ging uitgeven.   In het begin van de twintigste eeuw kocht de overheid ook plantages op om deze gronden te verkavelen in kleine percelen, waar men een huisje op kon bouwen en aan kleinlandbouw kon doen. Dit gebeurde bijvoorbeeld o.a. in Pannekoek, Dokterstuin, Phlip en Mahoema. De kleinlandbouw leverde in de meeste gevallen niet voldoende op om van te kunnen leven.\r\nMet de komst van de Shell breidde de stad zelf zich als een inktvlek uit en wel rondom het Schottegat. Naast de zelfbouwactiviteiten van onder andere lokale arbeiders, bouwde de raffinaderij  woonwijken voor het hoger en middenkader en voor de buitenlandse werknemers. \r\n', '11. De ontwikkeling van bewoning buiten Willemstad', '', 'inherit', 'closed', 'closed', '', '27-revision-v1', '', '', '2017-11-14 16:46:12', '2017-11-14 15:46:12', '', '27', 'https://canoncuracao.cw/27-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('449', '5', '2017-11-14 16:49:21', '2017-11-14 15:49:21', 'Manuel Carlos Piar (1774 – 1817) en Luis Brion (1782-1821) waren tijdgenoten die veel met elkaar gemeen hadden. Om te beginnen hun geboorteplaats, ze werden allebei in Otrobanda geboren. Ook deelden ze de belangrijke ideeën van hun tijd over vrijheid,  gelijkheid en onafhankelijke naties. Beiden verdedigden ze Curaçao tegen een Engelse inval in 1804. Ze steunden beiden Simon Bolívar als de leider van de Zuid-Amerikaanse onafhankelijkheidsstrijd onderscheiden zich beiden door het winnen van belangrijke zee- en veldslagen, Brion werd admiraal onder Bolivar en Piar was een van de belangrijkste generaals van zijn bevrijdingsleger. Beiden waren vrijmetselaar. Beiden stierven een tragische dood: Piar werd terechtgesteld en Brion stierf berooid en in de steek gelaten door Bolívar in Curaçao. \r\nHun achtergrond verschilt echter aanzienlijk. Luis Brion, zoon van succesvol zakenman Pierre Brion en María Detrox, vertrok al jong als student naar Nederland en streed in 1799 in dienst van het leger van de Bataafse Republiek  tegen de Engelsen. Toen Curaçao bezet was door de Britten (1800-1803) ging hij economie en scheepvaartkunde studeren in de Verenigde Staten. In 1803, nadat het eiland weer in Nederlandse handen was, keerde hij terug naar Curaçao en werd zakenman en reder. In 1805 werd hij benoemd tot commandant op Fort Beekenburg. Hij wist op 20 juni 1806 de Engelsen, die opnieuw probeerden het eiland te veroveren, te verjagen. In 1813 verbond Brion zijn leven aan de onafhankelijkheidsstrijd van Bolívar en werd één van zijn trouwste volgelingen. \r\nManuel Piar, zoon van María Isabel Gomez, een mulattin, en de zeeman Fernando Piar was, in tegenstelling tot Brion, van eenvoudige komaf. Met zijn moeder en broers vertrok hij als jongen naar Venezuela, waar hij in contact kwam met militairen en jonge revolutionairen. In 1798 was hij in Curaçao waar hij  met Maria Martha Boom trouwde. In 1806 was hij vanuit Aruba betrokken bij een mislukte invasie van Francisco de Miranda in Venezuela. Zijn militaire ervaring stelde hij vanaf 1810 in dienst van de bevrijding van Venezuela.  \r\nHij verschilde echter van strategisch inzicht met Bolívar. Zo wees hij Bolívar er herhaaldelijk op dat voor de bevrijding van Venezuela de bezetting van Guyana nodig was maar Bolívar weigerde dat in te zien. Piar, de hoogste kleurling in de’ independente’ gelederen, veroverde bij de slag bij San Felix op 11 april 1817 Guyana. De eer ging echter naar Bolívar. Piar kon dat niet verkroppen en nam daarom ontslag. Hij werd gearresteerd en door een krijgsraad, onder voorzitterschap van Brion, veroordeeld en met instemming van Bolivar in 1821 geëxecuteerd. In 1827 werd hij echter door Bolívar zelf weer gerehabiliteerd. \r\n\r\nPiar en Brion behoren beiden tot de nationale helden van Venezuela. Beelden van de twee Curaçaoënaars staan op een prominente op de Avenida van los Proceres in Caracas. \r\n', '12. Brion, Piar, Bolivar', '', 'inherit', 'closed', 'closed', '', '29-revision-v1', '', '', '2017-11-14 16:49:21', '2017-11-14 15:49:21', '', '29', 'https://canoncuracao.cw/29-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('450', '5', '2017-11-14 16:54:18', '2017-11-14 15:54:18', 'Op 1 juli 1863 kondigde Koning Willem III de vrijheid van  slavernij  in de Nederlandse kolonies af. Ongeveer een derde deel van de totale bevolking van Curaçao verkreeg op dat moment de vrijheid. De slaveneigenaars  kregen een vergoeding van Nafl. 200,-- voor het vrijlaten van iedere slaafgemaakte, maar de ex-slaafgemaakten kregen zelf niets.  In tegenstelling tot in Suriname bestond op Curaçao niet de verplichting om onder staatstoezicht nog tien jaar te werken voor een plantage-eigenaar. \r\n Direct na de emancipatie was het moeilijk een stuk grond krijgen voor het verbouwen van eigen voedsel en het bouwen van een huis.  De meeste vruchtbare gronden waren reeds in handen van de plantage-eigenaren. Sommige ex-slaafgemaakten bleven om die reden bij de ’shons’ (plantage-eigenaren) wonen op basis van het zogenoemde ‘paga tera’ systeem, waarbij zij verplicht waren in ruil voor dit stuk grond  een aantal dagen per jaar onbetaald voor de plantagehouders te werken. Ook dienden ze, op het moment dat de maïs geoogst was,  de shon dit te laten weten, zodat hij de koeien langs kon sturen om de stengels te eten. Als men weigerde om zich te houden aan deze  paga tera verplichting, doordat men  bijvoorbeeld ergens anders werkte, kreeg men de zogenaamde ora di porta, waarbij  men de aanzegging kreeg om binnen 24 uur te vertrekken van de plantage. Men moest dan met  het gezin heel snel ergens anders onderdak zien te vinden. \r\n Het bezit van een stuk grond was voor velen een garantie voor de fel begeerde onafhankelijkheid ten opzichte van de plantagehouders .Tegen het einde van de negentiende eeuw begon de overheid  een actief beleid te voeren om gouvernementsgronden aan particulieren te verhuren.  \r\nIn de stad konden de vrijgemaakten werk vinden als sjouwer in de haven bij het laden en lossen van schepen. Sommigen  kregen na 1875 werk bij de fosfaatwinning op de Tafelberg bij Nieuwpoort.  Ook de zeevaart vormde voor de vrijgemaakten een belangrijke bron van werkgelegenheid. Vrouwen konden  werken als dienstboden op de plantages of in de stad en in de hoedenvlechterij.  In periode na de emancipatie draaide de economie echter niet goed en er heerste veel armoede, met name onder de zojuist vrijgemaakten \r\nDe koloniale overheid poogde om via regelgeving het, in de ogen van de overheid vaak ongewenste sociale gedrag van de vrijgemaakten, te beïnvloeden. [VOORBEELD]. Ook de Rooms-Katholieke Kerk spande zich in om mensen volgzaam te maken.  Met name de Tambu was een doorn in het oog van de autoriteiten. \r\nMet de komst van de olie-industrie en de industrialisatie in het eerste kwart van de 20se eeuw  ontstond er een breuk in de sociale geschiedenis van het eiland. De standenmaatschappij kwam onder druk te staan en de verhoudingen tussen de groepen verschoof enigszins, waardoor de vrijgelatenen iets meer ruimte kregen om hun plaats in de maatschappij op te eisen.\r\n', '14. De afschaffing van de slavernij', '', 'inherit', 'closed', 'closed', '', '33-revision-v1', '', '', '2017-11-14 16:54:18', '2017-11-14 15:54:18', '', '33', 'https://canoncuracao.cw/33-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('451', '5', '2017-11-14 19:30:03', '2017-11-14 18:30:03', 'Fort Amsterdam is het oudste gebouw op Curaçao. Het werd in 1635, een jaar nadat de West- Indische Compagnie het eiland op de Spanjaarden had veroverd, gebouwd op de oostelijke oever van de Sint Annabaai. Dit betekent dat op Curaçao geen bouwwerken bewaard zijn gebleven uit de Spaanse periode (1499-1634) en evenmin uit de precolumbiaanse tijd. \r\nAan de noordzijde van Fort Amsterdam ontstond in de loop van de 17e eeuw een kleine nederzetting die ‘De Willemstad’ werd genoemd. De eerste huizen die hier werden gebouwd zijn beïnvloed door de architectuur uit Amsterdam. Kenmerkend zijn de hoge smalle voorgevels en de diepe zijgevels. De voorgevels zijn voorzien van tuitgevels waarop een rechthoekig lijstwerk is geplaatst met daarop een klein fronton. Deze eerste bouwstijl uit de zeventiende eeuw, die de Curaçaos-Hollandse stijl wordt genoemd, werd niet alleen toegepast in Willemstad maar ook bij de huizen op de plantages, de landhuizen.\r\nEen kenmerkend onderdeel van de traditionele architectuur op Curaçao zijn de galerijen. Dit waren aanvankelijk open houten of stenen constructies die tegen de voorgevels van de huizen in de stad werden geplaatst om de zon te weren. Later werden galerijen een structureel onderdeel van gebouwen zowel binnen als buiten de stad.\r\nIn de achttiende eeuw kwam de Curaçaose Barok in de mode met zijn sierlijke gebogen gevellijnen en arcades. Deze uitbundige bouwstijl werd in de eerste helft van de 19e eeuw afgewisseld door een sobere bouwstijl die weer teruggreep op de tuitgevel uit de 17e eeuw. De afmeting en detaillering was echter eenvoudiger geworden en kan daarom onderscheiden worden van de oudere stijl. \r\nDoor invloeden vanuit Nederland en de VS ontwikkelde zich in de tweede helft van de negentiende eeuw het ‘neoclassicisme’, een bouwstijl die gebaseerd was op de architectuur van de Grieken en Romeinen. De meest kenmerkende elementen van deze stijl waren de toepassing van zuilen en frontons (driehoeken). Het classicisme werd gebruikt voor zowel stadsvilla’s als eenvoudige woonhuizen en eveneens voor landhuizen.\r\nIn de eerste helft van de twintigste eeuw kwam Curaçao in contact met de internationale bouwstijl, die ook wel het ‘nieuwe bouwen’ wordt genoemd. Ook in deze periode zijn er duidelijke invloeden in de bouwkunst waar te nemen uit zowel Europa als de VS. Zo is bijvoorbeeld de voorgevel van de voormalige bioscoop Cinelandia geïnspireerd door de Art Deco architectuur in Miami en het voormalige KNSM-gebouw door de architectuur van de Nederlandse architect Dudoc.\r\nDe gebouwen op Curaçao hebben een Caraïbisch karakter gekregen door de invloeden van een multiculturele samenleving en het klimaat. De opvallende bonte kleuren op de gevels gaan terug op een verordening uit 1817, toen gouverneur Kikkert de eigenaren verplichte om de wit gekalkte voorgevels in binnenstad een kleur te geven.\r\nNB vragen of Gerda een alinea kan toevoegen over de huizen van het ‘gewone volk’, zoals knoekhuizen, houten huizen, huizen van blik.\r\n\r\n\r\n', '16. Gebouwen', '', 'inherit', 'closed', 'closed', '', '37-revision-v1', '', '', '2017-11-14 19:30:03', '2017-11-14 18:30:03', '', '37', 'https://canoncuracao.cw/37-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('452', '5', '2017-11-14 19:34:21', '2017-11-14 18:34:21', 'De verdediging van Curaçao is altijd een problematische zaak geweest. De Spanjaarden deden nauwelijks moeite om het eiland te verdedigen, maar zij vonden het eiland dan ook niet zo belangrijk. De Nederlanders maakten van de grootste binnenbaai, het Schottegat, een marinebasis, goed verdedigd door Fort Amsterdam aan de ingang van de baai. Maar omdat  baaien die geschikt waren om landingen uit te voeren verspreid lagen over de hele zuidkust, had men een probleem. Dat werd gedeeltelijk opgelost door de baaien die het dichtst bij de stad lagen, te voorzien van forten; Fort Beekenburg, Fort Piscadera en Fort Sint Michiel.\r\n\r\nIn 1713  toonde de Franse admiraal/kaper Cassard echter aan dat het mogelijk was in een van de baaien in het westelijk deel van het eiland te landen, op te trekken naar de stad en die vanaf de landzijde effectief te belegeren. Daarop werd besloten ook forten te bouwen bij o.a. Porto Marie (nu Daaibooibaai), Santa Cruz, Lagun, Knip en Westpunt. In de roerige tijden van de tweede helft van de 18e eeuw kregen bijna alle kleine baaien een klein fort of een batterij. Op een heuvel boven de Sint-Annabaai werd het ‘Fort Republiek’ gebouwd, dat nu Fort Nassau wordt genoemd.\r\n  \r\nToen bleek echter nog meer hoe onverdedigbaar Curaçao eigenlijk was; er was nog net geld beschikbaar voor het bouwen van deze verdedigingswerken, maar er was geen geld om ze te bemannen en te onderhouden. De Engelsen konden dan ook in 1804 zonder tegenstand landen aan de Piscaderabaai omdat de soldaten in het fort niet over kogels beschikten. Daarna konden ze de de stad vanaf de landzijde aanvallen. Na de Engelse periode, die afliep in 1816. werd de verdediging van het eiland weer geconcentreerd op Willemstad. Het Waterfort en het Riffort werden aan de ingang van de Sint Annabaai gebouwd.  Andere plannen werden wegens gebrek aan fondsen niet uitgevoerd.\r\n\r\nDe Venezuelaanse opstandeling Urbina toonde in 1929 aan hoe gemakkelijk het bestuur van Curaçao onder druk gezet kon worden. Hij overviel met zijn manschappen fort ......, maakte wapens buit en slaagde erin naar Venezuela te varen met medeneming van de Gouverneur. De verdediging van het eiland was toen weer eens minimaal. Er was zelf geen stationsschip aanwezig.\r\n\r\nIn de Tweede Wereldoorlog werd de verdediging van het eiland opnieuw aangepakt omdat de raffinaderij belangrijk was voor de brandstofvoorziening van de geallieerden. Om  vijandelijke schepen tegen te houden werden er twee flinke kustbatterijen gebouwd: die van de Nederlanders op Steenrijk en die van de Amerikanen bij Blauwbaai. Bij de olie-installaties van Bullenbaai werd een kleine (Nederlandse) kustbatterij neergezet, die daadwerkelijk in actie kwam tegen een aanvallende Duitse onderzeeboot en die ook wist te verdrijven. Ook kwamen er verschillende luchtafweer- en uitkijkposten.\r\n\r\nNa de Tweede Wereldoorlog werd de verdediging weer ingekrompen, maar er is nog altijd een contingent Nederlandse militairen en een stationsschip op het eiland aanwezig. Ook de Amerikanen hebben een luchtmachtbasis met verkenningsvliegtuigen op het eiland.  \r\n', '17. De verdediging van Curaçao en forten', '', 'inherit', 'closed', 'closed', '', '39-revision-v1', '', '', '2017-11-14 19:34:21', '2017-11-14 18:34:21', '', '39', 'https://canoncuracao.cw/39-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('453', '5', '2017-11-14 19:35:15', '2017-11-14 18:35:15', 'Armoede, gebrek aan werk en weinig mobiliteitskansen fungeerden op Curaçao als  voornaamste push-factoren voor emigratie in de periode na de emancipatie van de tot slaaf gemaakten in 1863.\r\nVele  Curaçaose arbeiders emigreerden naar landen in de regio. De migratie was dus intra-regionaal.  In 1838 werd de emigratie van arbeiskrachten bij wet verboden en dit verbod  bleef tot 1883 in stand. Toch werd er op 9 juli 1863, acht dagen na de afschaffing van de slavernij, een contract opgesteld tussen 25 vrijgemaakten en een Venezolaanse werkgever om te gaan werken in Venezuela. Op 10 juli 1863 werd er opnieuw een contract getekend met 25 Curaçaose mannen, om op de rivier in Venezuela te gaan varen met lichters en producten af te geven [ Rose Mary zou dit nog nader uitzoeken]. Dit gebeurde opnieuw op 16 juli 1863. Velen vertrokken echter ook zonder een contract te tekenen.\r\nLater in de eeuw, in 1882, vertrokken 46 mannen uit Curaçao voor werk bij de bouw van het Panama-kanaal. Daar werden ze opgenomen in een grotere groep van in totaal 130.000 arbeiders uit de Engelse Cariben. In die zelfde periode vertrokken er Curaçaoënaars naar Venezuela, Costa Rica en Colombia. Zij gingen zij daar seizoenarbeid verrichten op de suikerriet- en bananenplantages. \r\nCuraçaose arbeiders  vertrokken ook naar de Dominicaanse Republiek. In 1862, bijvoorbeeld,  gingen enkele metselaars, timmerlieden en dagloners daar een jaar lang  werken. Behalve ambachtslieden  emigreerden er ook arbeiders om te werken op de suikerrietplantages. Dit gebeurde  vooral tijdens de onafhankelijkheidsoorlogen op Cuba, waarbij de suikerproductie aldaar verlegd werd naar de Dominicaanse Republiek.\r\nDe arbeidsmigratie naar Cuba begon in 1917 en kende pieken in de jaren 1918, 1919 en 1920. Deze migratie drukte een onmiskenbaar stempel op Curaçao, omdat toen grote aantallen mensen  vertrokken. Ongeveer 50% van de mannelijke arbeidskrachten op het eiland vertrok in groepsverband. In Cuba werkten zij samen met een nog grotere aantal mensen uit Aruba, Bonaire, de Engelse Cariben, Haïti, Puerto Rico en de Nederlandse Bovenwinden. \r\nMigratie was niet alleen maar een mannenaangelegenheid. Ook vrouwen emigreerden. Soms sloten zij al op Curaçao een contract met hun werkgevers in het buitenland, zoals bijvoorbeeld het geval was met yaya’s (kindermeisjes) en kokkins  van Curaçaose families van Joodse en Protestantse afkomst die naar een ander Caribisch eiland waren verhuisd. Soms  emigreerden deze vrouwen echter ook op eigen gelegenheid en vonden ze in het land van bestemming werk als wasvrouw, werkster, kindermeisje en dergelijke. \r\nZelfs na de komst op Curaçao van de olie-maatschappij in 1915 bleef de migratie van Curaçaose arbeiders naar landen in de Caribische regio aanhouden. Dit bleef tot ongeveer 1923 het geval.\r\n\r\n', '18. Werkgelegenheid en emigratie tussen 1863 en 1920', '', 'inherit', 'closed', 'closed', '', '41-revision-v1', '', '', '2017-11-14 19:35:15', '2017-11-14 18:35:15', '', '41', 'https://canoncuracao.cw/41-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('454', '5', '2017-11-14 19:46:42', '2017-11-14 18:46:42', 'Voor een eiland zijn havens van cruciaal belang.  Vroeger, voor dekomst van de luchtvaart, was de zeevaart de enige mogelijkheid voor verkeer van mensen en goederen. Momenteel vindt veel vervoer van mensen plaats per vliegtuig, maar het vervoer van goederen gebeurt nog steeds veruit het meest per schip. Voor het laden en lossen van goederen zijn faciliteiten in rustig water met voldoende diepgang van essentieel belang. Rustig water vinden we aan de zuidkust van Curaçao en vooral in de handvormige binnenbaaien en de toegang hiernaartoe. Vanaf het begin van de Nederlandse tijd werd dan ook met name de Sint Annabaai  gebruikt als haven en in de twintigste eeuw vooral de handvormige binnenbaai daarachter, het Schottegat. De voornaamste havens zijn op dit moment  het Schottegat, de Sint Annabaai , de megapier (de cruiseport voor het Rif)  en Bullenbaai.  In het verleden waren ook de Caracasbaai en Fuikbaai van belang. \r\nDe goede potentiële havenmogelijkheden van de Sint Annabaai waren  een belangrijke reden voor de Nederlanders om Curaçao op de Spanjaarden te veroveren.  In de tijd van de West Indische Compagnie (1634-1791) diende de Sint Annabaai als uitvalsbasis voor de kaapvaart  en als strategische handelspost voor de slavenhandel en andere handel (o.a. smokkelhandel) en later als  vrijhandelshaven. In de Engelse tijd  (1800-1803 en 1807-1816) werd door de Engelsen besloten dat Curaçao zijn vrijhavenstatus moest opgeven, waardoor de havenactiviteiten drastisch inkrompen.  In de negentiende eeuw fungeerde de haven vooral als transitohaven, en ook was er veel smokkelhandel (contrabanda)  met het nabij gelegen vasteland. \r\nPas met de komst van de raffinaderij in het begin van de twintigste eeuw werd het Schottegat de belangrijkste haven  vanwege de aanvoer van ruwe olie naar de raffinaderij die aan het Schottegat gelegen was. De geraffineerde olieproducten werden deels ook weer via het Schottegat/Annabaai afgevoerd, maar de gevaarlijke lichte producten werden wegens ontploffingsgevaar per pijpleiding naar de Bullenbaai vervoerd, dat een diepe haven heeft en waar er nauwelijks  sprake is van bewoning. De Caracasbaai diende onder andere voor de opslag en afvoer van zware produkten en de brandstofinname van schepen (bunkeren).\r\nTijdens de Tweede wereldoorlog waren  de raffinaderij en de havens van Curaçao zeer belangrijk voor de toevoer van o.a. vliegtuigbenzine naar de Geallieerde  strijdkrachten.  \r\nDoor de sluiting  van het Suezkanaal in 1967 werden de olietankers, die nu weer de lange route langs Zuid Afrika moesten varen, binnen korte tijd veel en veel groter en begon Shell met het ontwikkelen van Bullenbaai als oilterminal, waar zeer grote olietankers  ruwe aardolie vanuit het Midden Oosten kwamen brengen die  vervolgens werd overgeladen in kleinere tankers, die de de ruwe olie daarna naar o.a. de Verenigde staten vervoerden.  Momenteel is Bullenbaai vooral als opslagplaats voor olie zeer belangrijk.\r\n', '23. De haven', '', 'inherit', 'closed', 'closed', '', '51-revision-v1', '', '', '2017-11-14 19:46:42', '2017-11-14 18:46:42', '', '51', 'https://canoncuracao.cw/51-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('455', '5', '2017-11-14 19:48:13', '2017-11-14 18:48:13', 'Op 10 mei 1940, onmiddellijk na de Duitse inval in Nederland, werden zeven Duitse schepen in de buurt van Curaçao in be¬slag genomen. De staat van beleg werd afgekondigd en diverse maatregelen werden genomen. Duitsers en Oostenrijkers, onder wie ook joden die hier woonden of hier¬heen gevlucht waren, werden in interneringskampen op Bonaire ondergebracht. Ook werden personen die verdacht werden van communistische of nationaal-socialistische sympathieën opgepakt.\r\nVanwege het strategische belang van de raffinaderij voor de Geallieerde oorlogs¬voering werden  op verzoek van de naar Londen gevluchte Nederlandse regering vanaf december 1940 Britse troepen op het eiland gestationeerd. Tot begin 1942 ondervond Curaçao weinig last van de oorlog. Dit veranderde spoedig. Na de Japanse aanval op Pearl Harbour, op 7 december 1941, waren ook de Verenigde Staten in de oorlog betrokken. In februari 1942 werden de Britse troepen vervangen door Amerikaanse. De aanwezigheid van de Amerikaanse militairen bracht grote bedrijvigheid met zich mee, ondermeer door de ver¬betering van de infrastructuur van het eiland.\r\nHet Caribisch gebied werd toen ook het doelwit van aanvallen door Duitse duikboten.De duikbotenoorlog in het Caribisch gebied werd “Operation Paukenschlag”genoemd. De Duitse duikboten probeerden de olietransporten van het Lago de Maracaibo naar Curaçao en de levering van olieproducten van Curaçao aan de Geallieerden te ondermijnen.Op 16 februari 1942 werd de eerste van de vele aanvallen uitgevoerd. Veel schepen en mensenlevens zijn door duikbootaanvallen verloren gegaan. Aan het Waaigat staat een monument ter herinnering aan de vele slachtoffers. \r\nHet koloniale bestuur kwam in grote problemen bij de ‘Chinezenkwestie’ in april1942.\r\nNa de eerste aanvallen van de Duitse duikboten weigerden ongeveer 400 Chinese matrozen te gaan varen. Ze eisten meer veiligheid op de tankers en verhoging van hun loon met een oorlogstoeslag, zoals die ook werd toegekend aan andere zeevarenden. Toen er geen oplossing werd gevonden,werden de Chinese stakers in maart 1942 opgesloten in een kamp. Daar ontstond op 20 april een opstand waarbij vijftien Chinezen werden doodgeschoten en vierenveertig gewond raakten. Niemand werd aansprakelijk gesteld voor dit dodelijk geweld.\r\nTijdens de oorlog werden vele hulpacties georganiseerd door verschillende hulporganisaties die opgericht werden met het doel om de oorlogsslachtoffers in Nederland te ondersteunen met geld, hulpgoederen en kleding. Enkele van deze organisaties waren het Comité ‘Steun Aan de Nederlandse Oorlogsslachtoffers Curaçao’ (SANOC), onder leidingvan de arts Chris Engels, het ‘Comité Nederland’ van de werknemers van de C.P.I.M. (raffinaderij) en het Steunfonds Katholiek Nederland. \r\nHet streven naar autonomie werd tijdens de oorlog versterkt met name door een rede die Koningin Wilhelmina hield op 7 december 1942, waarin ze naar autonomie verwees.\r\n\r\n', '25. De Tweede Wereldoorlog', '', 'inherit', 'closed', 'closed', '', '55-revision-v1', '', '', '2017-11-14 19:48:13', '2017-11-14 18:48:13', '', '55', 'https://canoncuracao.cw/55-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('456', '5', '2017-11-14 19:48:49', '2017-11-14 18:48:49', 'Moises Frumencio da Costa Gomez is geboren in Otrobanda op 27 oktober 1907, als zoon van Pedro da Costa Gomez en Braulia Bikker.Het gezin woont eerst in Otrobanda en verhuist later naar de Penstraat in Pietermaai. Op zijn 15e gaat Moises na voltooiing van de MULO naar Nederland, waar hij vanaf 1923 in Nijmegen het gymnasium volgt. Van 1925 tot 1929 studeert Moises rechten aan de Universiteit van Nijmegen. De jonge jurist werkt daarna als substituut-griffier in Den Haag en als advocaat en procureur in Nijmegen. Tegelijkertijd werkt hij aan zijn dissertatie en promoveert hij aan de Universiteit van Amsterdam op 3 december 1935 op het proefschrift ‘Het wetgevend orgaan van Curaçao. Samenstelling en bevoegdheid bezien in het kader van de Nederlandse Koloniale politiek’. Hij pleit als eerste Antilliaan in een proefschrift voor autonomie en algemeen kiesrecht voor de bevolking van de Nederlandse Antillen. Hij is dan 28 jaar oud en vertrekt onmiddellijk na zijn promotie met zijn gezin naar Curaçao, waar zij op 31 december 1935 aankomen.\r\nOp het eiland noemen ze hem al spoedig ’Doktoor’. Da Costa Gomez is een staatsman met grote verdiensten voor Curaçao, de Nederlandse Antillen en het Koninkrijk der Nederlanden. In 1935 formuleert hij de visie dat de bevolking van de Antillen bereid en in staat is zichzelf te besturen. Hij ziet autonomie als een instrument om economische, sociale en culturele vooruitgang te bereiken. Hij stelt zich in de jaren veertig als missie: zelfbestuur voor de Antillen,  een bestuur dat verantwoording verschuldigd is aan een parlement dat via algemeen kiesrecht is verkozen, zelfbestuur door de eilanden voor eilandelijke zaken en samenwerking en bijstand tussen de delen van het koninkrijk. Zijn gedachtegoed paste goed in de tijdgeest: ook op de andere Caribische eilanden leefde de wens om zich los te koppelen van de kolonisator.\r\nTot zijn verdiensten rekenen wij: het inspirerend verwoorden van de wens voor autonomie, bevordering van het politieke bewustzijn in de Antillen, organisatie van acties voor sociale ondersteuning in Kas di Pueblo, oprichting van de N.V.P., de wil tot samenwerken op alle bestuursniveaus, bevordering van zelfwaardering van de arme kunuku-bewoners van Curaçao, promotor van een eigen universiteit, leider van alle delegaties voor het autonomiestreven. Doktoor was de schakel tussen de Staten en de Nederlandse regering in Londen (1943) en in Den Haag (1947-1948). Hij was voorzitter of lid van diverse commissies voor het opstellen van staatsregelingen voor de Antillen en heeft een grote bijdrage geleverd aan de ontwerpen voor de gedeeltelijke autonomie van1948, de interim-regeling van 1951 en het statuut van 1954. Hij werd gezien als een zeer kundig spreker in de Staten. Hij stierf onverwacht op 22 november 1966.\r\n\r\n', '26. Dr. F da Costa Gomez', '', 'inherit', 'closed', 'closed', '', '57-revision-v1', '', '', '2017-11-14 19:48:49', '2017-11-14 18:48:49', '', '57', 'https://canoncuracao.cw/57-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('457', '5', '2017-11-14 19:50:21', '2017-11-14 18:50:21', 'Het Statuut van het Koninkrijk der Nederlanden is de grondwet van het Koninkrijk en regelt de relatie tussen Nederland en de Caribische eilanden. Het Statuut werd ondertekend op 15 december 1954 in de Ridderzaal te Den Haag door  Suriname en het land de Nederlandse Antillen, dat bestond uit de zes eilanden, Aruba, Bonaire, Curaçao, Sint Maarten, Sint Eustatius en Saba. \r\n\r\nIn 1975 werd Suriname een zelfstandig land. Aruba trad in 1986 uit de constellatie van de Nederlandse Antillen en kreeg een aparte status binnen het Koninkrijk. In 2010 werd het land ‘de Nederlandse Antillen’ opgeheven en werden Curaçao en Sint Maarten, net als Aruba, aparte landen binnen het Koninkrijk. Bonaire, Sint Eustatius en Saba kregen gezamenlijk de status van Nederlands gebiedsdeel in de Cariben en vallen nu bestuurlijk direct onder Nederland.\r\n\r\nDe volgende drie grondbeginselen zijn opgenomen in het Statuut:\r\n1.De landen binnen het koninkrijk behartigen zelfstandig hun eigen belangen.\r\n2.Zij verzorgen op voet van gelijkwaardigheid de gemeenschappelijke belangen.\r\n3.Zij verlenen elkaar wederkerig bijstand.\r\n[vraag redactie bij punt 2: klopt dat dat de landen gelijkwaardig zijn bij het verzorgen van de gemeenschappelijke belangen? De eilanden kunen ‘aanwijzingen’ krijgen. Defensie, buitenlandse betrekkingen, deugdelijkheid van bestuur, lijken het prerogatief van Nederland of de rijksministerraad]\r\n\r\nDe gemeenschappelijke belangen die de landen binnen het Koninkrijk gezamenlijk op voet van gelijkwaardigheid behartigen staan bekend als de ‘koninkrijksaangelegenheden’. Hiertoe behoren zaken betrekking hebbende op de handhaving van de onafhankelijkheid en verdediging van het Koninkrijk, buitenlandse betrekkingen, Nederlanderschap, waarborgen van de fundamentele rechten en vrijheden, de rechtszekerheid en de deugdelijkheid van het bestuur.\r\n[noot redactie: klopt de inhoud van deze paragraaf?]\r\n\r\nDe vier voornaamste bestuursorganen van de landen Aruba, Curaçao en St. Maarten zijn:\r\n1. De Gouverneur, vertegenwoordiger van het hoofd van de regering van het koninkrijk en van de regering van het land. [noot redactie: klopt deze omschrijving? voorstel: de gouverneur is de vertegenwoordiger van de Koning en het hoofd van de eilandelijke regering]\r\n2. De Staten, het parlement, bestaande uit hooguit 21 leden. Om de vier jaar worden verkiezingen gehouden om de Staten te kiezen. Zij hebben als taak wetten goed te keuren of te verwerpen en de regering te controleren.\r\n3. De Raad van Ministers, het kabinet, steunt op de meerderheid in de Staten. Samen met de Gouverneur vormen de ministers de Regering. De ministers zijn verantwoording verschuldigd aan de Staten. De gouverneur is onschendbaar.\r\n4. De Raad van Advies adviseert bij het maken van wetten.\r\n\r\nTer behartiging van de belangen van elk der landen maken drie ‘gevolmachtigde ministers’ van respectievelijk Curaçao, Aruba en Sint Maarten deel uit van de Rijksministerraad van het Koninkrijk in Nederland. Ook in de Raad van State, het adviescollege van de regering in Nederland, is een vertegenwoordiger aanwezig van elk der landen.\r\n', '28. Het statuut', '', 'inherit', 'closed', 'closed', '', '61-revision-v1', '', '', '2017-11-14 19:50:21', '2017-11-14 18:50:21', '', '61', 'https://canoncuracao.cw/61-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('458', '5', '2017-11-14 19:52:33', '2017-11-14 18:52:33', 'Carnaval heeft een lange geschiedenis op het eiland, hoewel het pas vanaf de jaren 70 van de vorige eeuw een echt volksfeest  is. De eerste schriftelijke vermelding van de carnavalsviering op Curaçao stamt uit het \"Publicatieblad 1872 nr. 27\". Deze verordening opende de mogelijkheid om carnavalsoptochten te organiseren en deze te reguleren op openbare plaatsen. De Curaçaosche Courant schrijft in  1901 dat  ‘volgens de Latijns-Amerikaanse gewoonten’ carnaval wordt gevierd op het eiland. De viering was een initiatief van Venezolaanse burgers die hier woonden en het vond plaats in een privé club. \r\nDe eerste carnavalsviering op straat in 1945/1946? vond plaats op  initiatief van werknemers van deCPIM, voor¬loper van de Royal Dutch Shell, die afkomstig waren van de Britse Caribische eilanden.  Zij speelden en dansten op steelbandmuziek vanaf Suffisant tot de ingang van Isla. \r\nIn 1949 werd de stichting ‘Stichtingscommissie Carnavalsfeesten’ opgericht om carnaval te vieren met een gekozen Prins Carnaval. De bedoeling was om de gehele bevolking bij de viering te betrekken.  De Chinese bewoners deden toen actief mee met prachtige praalwagens vol draken. \r\nDe viering bleef echter beperkt tot sociale clubs en de interesse vervaagde in de jaren vijftig. \r\n\r\nIn 1961 nam Elias Bronswinkel het initiatief om de belangstelling voor carnaval nieuw leven in te blazen door de oprichting van het Centraal Comité Carnaval Curaçao, de voorloper van het huidige Carnavalscomité.  Er verschenen carnavaleske figu¬ren op het toneel voor de titel van Prins Carnaval, zoals de komische Benjamin Wefer (‘Shon Benchi’) en de figuur van Pancho. In die tijd maakte ook Miss Carnaval furore. Maar nog steeds  beperkte de animo voor de viering van Carnaval  als geheel zich tot hier en daar een feest in clubs van de gegoede burgers.\r\n\r\nHet is mogelijk dat de raciale segregatie en blanke hegemonie de ontwikkeling van carnaval als een massaal volksfeest op Curacao belemmerden. Opvallend is in ieder geval dat er na de volksopstand in Willemstad van 30 mei 1969  er verandering kwam, want het eerstvolgende carnaval, 1970 kende een ongekende omvang. Het carnaval werd gevierd als een massaal volksfeest.  \r\n\r\nNaar mijn mening wordt in de vorige alinea te gemakkelijk een link gelegd tussen segregatie en het onderdrukken van carnaval. Dat verband zou moeten worden onderzocht. Zie suggestie hieronder. \r\n\r\nIn 1970 kende het carnaval  vrij abrupt een ongekende omvang. Het werd ineens gevierd als een massaal volksfeest. Naar de oorzaak van deze plotselinge populariteit kan men gissen. Misschien speelde het gevoel dat men zich van ketenen had ontdaan in mei 1969 een rol, of nam men een voorbeeld aan de carnavalsoptochten op andere Caribische eilanden, bijvoorbeeld Aruba.\r\n\r\nHet was Omalio Merien die eind jaren zestig al voorstelde om een festival te houden waarbij een band als winnaar zou worden gekozen voor het carnaval van dat jaar.  De eerste festivals stonden in het teken van de calypso’s, maar in 1971 maakten die, op voorspraak van ondere andere Boy Dap en Juan Camelia,  plaats voor de tumba als het uitverkoren ritme voor  de carnavalsparade van Curaçao. Het Tumbafestival is in de loop van de jaren uitgegroeid tot één van de grootste muzikale gebeurtenissen van het eiland.  \r\nIn 1981 werd het Kindercarnaval geïntroduceerd en in de jaren negentig werd de Fundashon Karnaval Kòrsou (FKK) opgericht.  In 1995 werd de Teener Parade toegevoegd aan de festiviteiten. Omdat de Emmabrug als te kwetsbaar werd beschouwd voor de grote voertuigen die tijdens de optocht worden gebruikt, werd de route gewijzigd. Deze begint sindsdien in Santa Maria en eindigt in Otrobanda, waar op dindagavond op het Brionplain Momo wordt verbrand. \r\n\r\n', '38. Carnaval', '', 'inherit', 'closed', 'closed', '', '81-revision-v1', '', '', '2017-11-14 19:52:33', '2017-11-14 18:52:33', '', '81', 'https://canoncuracao.cw/81-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('459', '5', '2017-11-14 19:53:11', '2017-11-14 18:53:11', 'Handel vanaf het begin\r\nCuraçao ligt zo dicht voor de kust van Venezuela dat je het op heldere dagen zelfs kunt zien. Al eeuwenlang voeren er indianen op grote kano’s heen en weer tussen Venezuela en Curaçao en ongetwijfeld namen zij fruit en groente mee, zoals de barkjes nu nog steeds doen, maar  nadat Curaçao in het begin van de zestiende eeuw was ingenomen door Spanje en het eiland in 1634 was veroverd door de Hollanders, nam de handel toe. Van Curaçao naar Venezuela werden  wapens, slaven en allerlei handelswaar vervoerd en van Venezuela naar Curaçao vooral cacao, tabak en dierenhuiden. Omdat de Spanjaarden de handel met Venezuela verboden hadden, ontstond er een levendige smokkelhandel (‘contrabanda’) die eeuwen zou duren.\r\n\r\nOnrust na de onafhankelijkheid van Venezuela\r\nDoordat onder leiding van Simón Bolívar Venezuela zich losmaakte van Spanje, werd Curaçao steeds belangrijker voor wat er in Venezuela gebeurde. Na het mislukken van de eerste onafhankelijkheidsstrijd vluchtte Bolívar naar Curaçao, waar hij hulp kreeg van  Curaçaoënaars, onder anderen Brion, die admiraal van zijn vloot werd en Piar, die generaal in zijn leger werd. Uiteindelijk werd de vrijheidsoorlog door Bolívar alsnog gewonnen, maar daarna werd het een onrustige tijd met veel burgeroorlogen in Venezuela. Afgezette leiders vluchtten vaak naar Curaçao, waar ze wapens kochten en weer in Venezuela aan de macht probeerden te komen.Door de nabije ligging had Curaçao zo de mogelijkheid het politieke systeem in Venezuela te beïnvloeden.\r\n\r\nRelatieve rust na de komst van de olie-industrie\r\nDe relatie veranderde toen er veel olie in Venezuela werd gevonden en de Shell na 1914 een grote raffinaderij op Curaçao bouwde waar de ruwe olie uit het Lago de Maracaibo werd verwerkt.Omdat dit economisch zo belangrijk was kwam de relatie tussen Curaçao en Venezuela in een rustiger vaarwater terecht. Deze rust werd nog even verstoord toen de revolutionair Rafael Urbina in 1929 Fort Amsterdam met geweld bezette en met de buitgemaakte wapens en de gegijzelde gouverneur Fruytier op een schip naar Venezuela vertrok. Dit had echter geen langdurig negatief effect op de relatie.\r\n\r\nMeer kans op spanningen in de relatie\r\nIn de jaren 80 verliet de Shell Curaçao en werd de raffinaderij voor lange termijn verhuurd aan de Venezolaanse staatoliemaatschappij PdVSA, waardoor de invloed van Venezuela op Curaçao groter werd. Door de sociaal-economische crisis in Venezuela na de dood van president Hugo Chávez, is nu de kans op spanningen in de relatie weer toegenomen. Mocht ook de PdVSA van Curaçao vertrekken, dan breekt er weer een nieuwe periode in de relatie aan.\r\n\r\nAfgezien van bestuurlijke en handels relaties, zijn er in de loop van de eeuwen zeer veel familierelaties ontstaan tussen de bevolkingen van Curaçao en Venezuela. Ook op cultureel gebied (muziek, keuken) heeft Venezuela een sterke invloed gehad op Curaçao.\r\n\r\n', '44. Religie en religieuze vieringen', '', 'inherit', 'closed', 'closed', '', '93-revision-v1', '', '', '2017-11-14 19:53:11', '2017-11-14 18:53:11', '', '93', 'https://canoncuracao.cw/93-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('463', '3', '2018-01-15 20:48:55', '2018-01-15 19:48:55', '<h3>Een patriotseputsch</h3>\n&nbsp;\n\nToen in 1795 de slavenopstand uitbrak, was er politieke onrust in Curaçao. Evenals in de Republiek stonden patriotten en Oranjegezinden tegenover elkaar. En evenals in het moederland, waar in 1795 met Franse steun de Bataafse Republiek werd uitgeroepen, wisten patriotten in Curaçao, gesteund door Franse kapers, in 1796 de macht te grijpen. De Bataafse Republiek kwam als bondgenoot van Frankrijk in de oorlog met Groot-Brittannië. Curaçao werd een belangrijk maritiem steunpunt voor de Fransen.\n<h3>Hervorming van de defensie</h3>\nNa de machtswisseling verkeerde het defensieapparaat in chaos. Oranjegezinde officieren van het garnizoen vertrokken hals over kop vanCuraçao. Kort daarna werd de gouverneur a.i., Jan Jacob Beaujon, die ervan werd verdacht Oranjegezind en pro-Brits te zijn, afgezet. Hij werd opgevolgd door de kapitein van de burgerij Johann RudolfLauffer, die de verdediging van Curaçao reorganiseerde. De oorspronkelijk exclusief blanke burgerwacht werd uitgebreid met vrije niet-blanken en omgedoopt tot Nationale Garde. Deze vrijen waren afkomstig uit de zeevarende bevolking en hadden ervaring met de bediening van scheepsgeschut. Gekleurde schippers kregen officiersrangen bij het onderdeel artillerie. Dit leidde tot spanningen binnen de Nationale Garde.\n<h3>Revolutionaire onrust</h3>\nGeïnspireerd door de leuzen ‘vrijheid’ en ‘gelijkheid’ van de Franse Revolutie (1789-1799),de succesvolle slavenopstand in de Franse kolonie Saint-Domingue in 1791en de Franse afschaffing van de slavernij in 1792, ontstond in de gehele regio revolutionaire onrust. De leiders van een mislukte opstand in Venezuela vluchtten in 1797 naar Curaçao. Geruchten over hun uitlevering veroorzaakte bijna een muiterij onder artilleristen van de Nationale Garde. In 1799 werden drie Fransen gearresteerd omdat zij, volgens Lauffer, de leiders waren van een complot om een nieuwe slavenopstand te ontketenen en de macht te grijpen. Alle drie werden zij uitgewezen.\n<h3>Aangevallen door de bondgenoot en gered door de vijand.</h3>\nIn 1800 verscheen een Franse militaire macht uit Guadeloupe voor de haven om, zo werd gemeld, Curaçao tegen de Britten te beschermen. Vermoed werd dat de Fransen uit waren op een machtsovername. Dit bleek inderdaad het geval. Na op aandringen van het gouvernement te zijn vertrokken, landden de Franse troepeneen dag later bij Sint-Michielsbaai. Daarna veroverden zij, gesteund door een groot deel van de Curaçaose slavenbevolking, op Willemstad na vrijwel het gehele eiland. Toen een Brits oorlogsschip voor de haven verscheen en vervolgens ook twee Amerikaanse oorlogsschepen, besloot het gouvernement hun hulp in te roepen. De Fransen werden verdreven, maar een Britse bezetting was het gevolg. In 1802 kwam Curaçao weer in Nederlandse handen.In 1807 veroverden de Britten Curaçao echter opnieuw.\n\nIn 1816 werd het eiland weer aan Nederland teruggegeven.\n\nNB\nRepubliek: De Republiek der Verenigde Nederlanden (1588 – 1795)\nPatriotten en Oranjegezinden: tussen 1781 en 1795 speelde in Nederland een conflict tussen de aanhangers van prins Willem V (oranjegezinden) en mensen die meer macht bij het volk wilden leggen (patriotten). Deze twee groepen stonden ook op Curaçao tegenover elkaar\nBataafse republiek: vanaf 1795 tot 1801 heette Nederland de Bataafse Republiek. Officieel was het land onafhankelijk maar in feite maakte Frankrijk de dienst uit.\n\nHan Jordaan', '9. Curaçao rond 1800', '', 'inherit', 'closed', 'closed', '', '23-autosave-v1', '', '', '2018-01-15 20:48:55', '2018-01-15 19:48:55', '', '23', 'https://canoncuracao.cw/23-autosave-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('464', '3', '2018-01-15 20:49:59', '2018-01-15 19:49:59', '<h3>Een patriotseputsch</h3>\r\nToen in 1795 de slavenopstand uitbrak, was er politieke onrust in Curaçao. Evenals in de Republiek stonden patriotten en Oranjegezinden tegenover elkaar. En evenals in het moederland, waar in 1795 met Franse steun de Bataafse Republiek werd uitgeroepen, wisten patriotten in Curaçao, gesteund door Franse kapers, in 1796 de macht te grijpen. De Bataafse Republiek kwam als bondgenoot van Frankrijk in de oorlog met Groot-Brittannië. Curaçao werd een belangrijk maritiem steunpunt voor de Fransen.\r\n<h3>Hervorming van de defensie</h3>\r\nNa de machtswisseling verkeerde het defensieapparaat in chaos. Oranjegezinde officieren van het garnizoen vertrokken hals over kop vanCuraçao. Kort daarna werd de gouverneur a.i., Jan Jacob Beaujon, die ervan werd verdacht Oranjegezind en pro-Brits te zijn, afgezet. Hij werd opgevolgd door de kapitein van de burgerij Johann RudolfLauffer, die de verdediging van Curaçao reorganiseerde. De oorspronkelijk exclusief blanke burgerwacht werd uitgebreid met vrije niet-blanken en omgedoopt tot Nationale Garde. Deze vrijen waren afkomstig uit de zeevarende bevolking en hadden ervaring met de bediening van scheepsgeschut. Gekleurde schippers kregen officiersrangen bij het onderdeel artillerie. Dit leidde tot spanningen binnen de Nationale Garde.\r\n<h3>Revolutionaire onrust</h3>\r\nGeïnspireerd door de leuzen ‘vrijheid’ en ‘gelijkheid’ van de Franse Revolutie (1789-1799), de succesvolle slavenopstand in de Franse kolonie Saint-Domingue in 1791 en de Franse afschaffing van de slavernij in 1792, ontstond in de gehele regio revolutionaire onrust. De leiders van een mislukte opstand in Venezuela vluchtten in 1797 naar Curaçao. Geruchten over hun uitlevering veroorzaakte bijna een muiterij onder artilleristen van de Nationale Garde. In 1799 werden drie Fransen gearresteerd omdat zij, volgens Lauffer, de leiders waren van een complot om een nieuwe slavenopstand te ontketenen en de macht te grijpen. Alle drie werden zij uitgewezen.\r\n<h3>Aangevallen door de bondgenoot en gered door de vijand</h3>\r\nIn 1800 verscheen een Franse militaire macht uit Guadeloupe voor de haven om, zo werd gemeld, Curaçao tegen de Britten te beschermen. Vermoed werd dat de Fransen uit waren op een machtsovername. Dit bleek inderdaad het geval. Na op aandringen van het gouvernement te zijn vertrokken, landden de Franse troepeneen dag later bij Sint-Michielsbaai. Daarna veroverden zij, gesteund door een groot deel van de Curaçaose slavenbevolking, op Willemstad na vrijwel het gehele eiland. Toen een Brits oorlogsschip voor de haven verscheen en vervolgens ook twee Amerikaanse oorlogsschepen, besloot het gouvernement hun hulp in te roepen. De Fransen werden verdreven, maar een Britse bezetting was het gevolg. In 1802 kwam Curaçao weer in Nederlandse handen. In 1807 veroverden de Britten Curaçao echter opnieuw. In 1816 werd het eiland weer aan Nederland teruggegeven.\r\n\r\nNB\r\nRepubliek: De Republiek der Verenigde Nederlanden (1588 – 1795)\r\nPatriotten en Oranjegezinden: tussen 1781 en 1795 speelde in Nederland een conflict tussen de aanhangers van prins Willem V (oranjegezinden) en mensen die meer macht bij het volk wilden leggen (patriotten). Deze twee groepen stonden ook op Curaçao tegenover elkaar\r\nBataafse republiek: vanaf 1795 tot 1801 heette Nederland de Bataafse Republiek. Officieel was het land onafhankelijk maar in feite maakte Frankrijk de dienst uit.\r\n\r\n<em>Han Jordaan</em>', '9. Curaçao rond 1800', '', 'inherit', 'closed', 'closed', '', '23-revision-v1', '', '', '2018-01-15 20:49:59', '2018-01-15 19:49:59', '', '23', 'https://canoncuracao.cw/23-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('465', '3', '2018-01-15 20:51:14', '2018-01-15 19:51:14', 'Manuel Carlos Piar (1774 – 1817) en Luis Brion (1782-1821) waren tijdgenoten die veel met elkaar gemeen hadden. Om te beginnen hun geboorteplaats, ze werden allebei in Otrobanda geboren. Ook deelden ze de belangrijke ideeën van hun tijd over vrijheid, gelijkheid en onafhankelijke naties. Beiden verdedigden ze Curaçao tegen een Engelse inval in 1804. Ze steunden beiden Simon Bolívar als de leider van de Zuid-Amerikaanse onafhankelijkheidsstrijd onderscheiden zich beiden door het winnen van belangrijke zee- en veldslagen, Brion werd admiraal onder Bolivar en Piar was een van de belangrijkste generaals van zijn bevrijdingsleger. Beiden waren vrijmetselaar. Beiden stierven een tragische dood: Piar werd terechtgesteld en Brion stierf berooid en in de steek gelaten door Bolívar in Curaçao.\r\nHun achtergrond verschilt echter aanzienlijk. Luis Brion, zoon van succesvol zakenman Pierre Brion en María Detrox, vertrok al jong als student naar Nederland en streed in 1799 in dienst van het leger van de Bataafse Republiek tegen de Engelsen. Toen Curaçao bezet was door de Britten (1800-1803) ging hij economie en scheepvaartkunde studeren in de Verenigde Staten. In 1803, nadat het eiland weer in Nederlandse handen was, keerde hij terug naar Curaçao en werd zakenman en reder. In 1805 werd hij benoemd tot commandant op Fort Beekenburg. Hij wist op 20 juni 1806 de Engelsen, die opnieuw probeerden het eiland te veroveren, te verjagen. In 1813 verbond Brion zijn leven aan de onafhankelijkheidsstrijd van Bolívar en werd één van zijn trouwste volgelingen.\r\nManuel Piar, zoon van María Isabel Gomez, een mulattin, en de zeeman Fernando Piar was, in tegenstelling tot Brion, van eenvoudige komaf. Met zijn moeder en broers vertrok hij als jongen naar Venezuela, waar hij in contact kwam met militairen en jonge revolutionairen. In 1798 was hij in Curaçao waar hij met Maria Martha Boom trouwde. In 1806 was hij vanuit Aruba betrokken bij een mislukte invasie van Francisco de Miranda in Venezuela. Zijn militaire ervaring stelde hij vanaf 1810 in dienst van de bevrijding van Venezuela.\r\nHij verschilde echter van strategisch inzicht met Bolívar. Zo wees hij Bolívar er herhaaldelijk op dat voor de bevrijding van Venezuela de bezetting van Guyana nodig was maar Bolívar weigerde dat in te zien. Piar, de hoogste kleurling in de’ independente’ gelederen, veroverde bij de slag bij San Felix op 11 april 1817 Guyana. De eer ging echter naar Bolívar. Piar kon dat niet verkroppen en nam daarom ontslag. Hij werd gearresteerd en door een krijgsraad, onder voorzitterschap van Brion, veroordeeld en met instemming van Bolivar in 1821 geëxecuteerd. In 1827 werd hij echter door Bolívar zelf weer gerehabiliteerd.\r\n\r\nPiar en Brion behoren beiden tot de nationale helden van Venezuela. Beelden van de twee Curaçaoënaars staan op een prominente op de Avenida van los Proceres in Caracas.', '12. Brion, Piar en Bolivar', '', 'inherit', 'closed', 'closed', '', '29-revision-v1', '', '', '2018-01-15 20:51:14', '2018-01-15 19:51:14', '', '29', 'https://canoncuracao.cw/29-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('466', '3', '2018-01-15 20:55:11', '2018-01-15 19:55:11', '30 Mei 1969 (Trinta di Mei)\r\n\r\nWereldwijd, en dus ook op Curaçao, staan de jaren 60 bekend als een tijdperk van maatschappelijke verandering. Talrijke sociale bewegingen ageerden tegen sociale machtsstructuren gebaseerd op kleur, klasse, en geslacht. Op Curaçao wordt er geen ander gebeurtenis sterker geassocieerd met deze periode als de opstand van \"Trinta di Mei,\" 30 Mei 1969.\r\n\r\nDe arbeidsconflicten die tot de opstand van 30 mei 1969 hebben geleid vinden hun oorsprong in de ontwikkelingen van de tweede helft van de jaren 1960. De Shell-olieraffinaderij, toen de grootste werkgever op Curaçao, begon met automatisering en uitbesteding naar verschillende onderaannemers zoals, onder andere, \"Werkspoor Caribbean\" (WESCAR). Door de uitbestending moesten werknemers die eerder voor de Shell hadden gewerkt bij de onderaannemers hetzelfde arbeid verrichten tegen lager loon.\r\n\r\nIn de eerste week van mei 1969 ontstond er een impasse in de onderhandelingentussen WESCAR en de Curaçao Federation of Workers (CFW) over decollectieve arbeidersovereenkomst (CAO)die op 6 mei 1969 zou aflopen.CFW hanteerde het principe van \"equal work equal pay\" en eiste een loon dat gelijk was met wat de Shell betaalde voordat de banenaan WESCAR werden uitbesteed. Toen WESCAR dit weigerde, kondigde de CFW in de laatste week van mei een algemene staking af voor alle leden. Al gauw volgde een sympathie-staking van de Shell-arbeidersvakbond \"Petroleum Workers Federation of Curaçao\" (PWFC). Politici, journalisten en activisten zoals Stanley Brown, hoofdredacteur van de linkse antikoloniale tijdschrift<em> Vitó</em>, steunden de stakende arbeiders.\r\n\r\nOp de ochtend van 30 mei 1969 verzamelden zich ongeveer vijfduizend stakers bij de hoofdingang van de Shell-terrein voor een optocht naar Fort Amsterdam, onder leiding van Ewald Ong-a-Kwie, leider van de CFW. De leiders van de havenarbeiders, Wilson \"Papa\" Godett en Amador Nita, sloten zich toen aan bij de optocht. De optocht escaleerde tot een heuse opstand toen bij Parera twee doden vielen, Manuel Gutierez en Orlando Gerardina. Wilson \"Papa\" Godett werd in de rug geraakt door een politiekogel, toen hij met de handen omhoog de menigte probeerde te kalmeren. Na de escalatie stemden Shell en WESCAR alsnog in met de eisen van gelijk loon voor gelijk werk van de CFW<strong>.</strong> Het was echter al te laat. Een woedende meute stroomde Punda en Otrobanda binnen. Gebouwen werden in brand gestoken, en winkels werden geplunderd. De gouverneur kondigde een noodtoestand af, het leger werd ingeschakeld, en mariniers uit Nederland werden ingevlogen om de opstand te bedwingen. Nadat de vakbondsleiders op de radio hadden bekendgemaakt dat Shell en de onderaannemers met de eisen van de vakbonden hadden ingestemd, keerde de rust terug. In de nasleep van de opstand ontstond er een nieuwe politieke partij, \"Frente Obrero Liberashon Trinta di Mei,\" geleid door Wilson Godett, Stanley Brown en Amador Nita, die zou opkomen voor de belangen van de arbeidersklasse.\r\n\r\nMet de loop der jaren werd \"Trinta di Mei\" een symbool voor een langere periode van sociale veranderingsprocessen van de jaren 60, waarbij de raciaal gesegmenteerde koloniale machtsstructuur moest plaatsmaken voor een politiek klimaat waarin er meer rekening werd gehouden met de belangen van de Afro-Curaçaose arbeidersklasse. In 1994 werd \"Trinta di Mei\" tot nationale herdenkingsdag verklaard. Alhoewel er onder Curaçaoënaars nog steeds meningsverschillen bestaan over de details, wordt \"Trinta Di Mei\" toch beschouwd als een belangrijk keerpunt in de politieke geschiedenis van Curaçao.', '31. Mei 1969', '', 'inherit', 'closed', 'closed', '', '67-revision-v1', '', '', '2018-01-15 20:55:11', '2018-01-15 19:55:11', '', '67', 'https://canoncuracao.cw/67-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('467', '3', '2018-01-15 20:57:19', '2018-01-15 19:57:19', '<h3>Handel vanaf het begin</h3>\nCuraçao ligt zo dicht voor de kust van Venezuela dat je het op heldere dagen zelfs kunt zien. Al eeuwenlang voeren er indianen op grote kano’s heen en weer tussen Venezuela en Curaçao en ongetwijfeld namen zij fruit en groente mee, zoals de barkjes nu nog steeds doen, maar nadat Curaçao in het begin van de zestiende eeuw was ingenomen door Spanje en het eiland in 1634 was veroverd door de Hollanders, nam de handel toe. Van Curaçao naar Venezuela werden wapens, slaven en allerlei handelswaar vervoerd en van Venezuela naar Curaçao vooral cacao, tabak en dierenhuiden. Omdat de Spanjaarden de handel met Venezuela verboden hadden, ontstond er een levendige smokkelhandel (‘contrabanda’) die eeuwen zou duren.\n\n<strong>Onrust na de onafhankelijkheid van Venezuela</strong>\nDoordat onder leiding van Simón Bolívar Venezuela zich losmaakte van Spanje, werd Curaçao steeds belangrijker voor wat er in Venezuela gebeurde. Na het mislukken van de eerste onafhankelijkheidsstrijd vluchtte Bolívar naar Curaçao, waar hij hulp kreeg van Curaçaoënaars, onder anderen Brion, die admiraal van zijn vloot werd en Piar, die generaal in zijn leger werd. Uiteindelijk werd de vrijheidsoorlog door Bolívar alsnog gewonnen, maar daarna werd het een onrustige tijd met veel burgeroorlogen in Venezuela. Afgezette leiders vluchtten vaak naar Curaçao, waar ze wapens kochten en weer in Venezuela aan de macht probeerden te komen.Door de nabije ligging had Curaçao zo de mogelijkheid het politieke systeem in Venezuela te beïnvloeden.\n\nRelatieve rust na de komst van de olie-industrie\nDe relatie veranderde toen er veel olie in Venezuela werd gevonden en de Shell na 1914 een grote raffinaderij op Curaçao bouwde waar de ruwe olie uit het Lago de Maracaibo werd verwerkt.Omdat dit economisch zo belangrijk was kwam de relatie tussen Curaçao en Venezuela in een rustiger vaarwater terecht. Deze rust werd nog even verstoord toen de revolutionair Rafael Urbina in 1929 Fort Amsterdam met geweld bezette en met de buitgemaakte wapens en de gegijzelde gouverneur Fruytier op een schip naar Venezuela vertrok. Dit had echter geen langdurig negatief effect op de relatie.\n\nMeer kans op spanningen in de relatie\nIn de jaren 80 verliet de Shell Curaçao en werd de raffinaderij voor lange termijn verhuurd aan de Venezolaanse staatoliemaatschappij PdVSA, waardoor de invloed van Venezuela op Curaçao groter werd. Door de sociaal-economische crisis in Venezuela na de dood van president Hugo Chávez, is nu de kans op spanningen in de relatie weer toegenomen. Mocht ook de PdVSA van Curaçao vertrekken, dan breekt er weer een nieuwe periode in de relatie aan.\n\nAfgezien van bestuurlijke en handels relaties, zijn er in de loop van de eeuwen zeer veel familierelaties ontstaan tussen de bevolkingen van Curaçao en Venezuela. Ook op cultureel gebied (muziek, keuken) heeft Venezuela een sterke invloed gehad op Curaçao.', '44. Religie en religieuze vieringen', '', 'inherit', 'closed', 'closed', '', '93-autosave-v1', '', '', '2018-01-15 20:57:19', '2018-01-15 19:57:19', '', '93', 'https://canoncuracao.cw/93-autosave-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('468', '3', '2018-01-15 20:57:42', '2018-01-15 19:57:42', '<h3>Handel vanaf het begin</h3>\r\nCuraçao ligt zo dicht voor de kust van Venezuela dat je het op heldere dagen zelfs kunt zien. Al eeuwenlang voeren er indianen op grote kano’s heen en weer tussen Venezuela en Curaçao en ongetwijfeld namen zij fruit en groente mee, zoals de barkjes nu nog steeds doen, maar nadat Curaçao in het begin van de zestiende eeuw was ingenomen door Spanje en het eiland in 1634 was veroverd door de Hollanders, nam de handel toe. Van Curaçao naar Venezuela werden wapens, slaven en allerlei handelswaar vervoerd en van Venezuela naar Curaçao vooral cacao, tabak en dierenhuiden. Omdat de Spanjaarden de handel met Venezuela verboden hadden, ontstond er een levendige smokkelhandel (‘contrabanda’) die eeuwen zou duren.\r\n\r\nOnrust na de onafhankelijkheid van Venezuela\r\nDoordat onder leiding van Simón Bolívar Venezuela zich losmaakte van Spanje, werd Curaçao steeds belangrijker voor wat er in Venezuela gebeurde. Na het mislukken van de eerste onafhankelijkheidsstrijd vluchtte Bolívar naar Curaçao, waar hij hulp kreeg van Curaçaoënaars, onder anderen Brion, die admiraal van zijn vloot werd en Piar, die generaal in zijn leger werd. Uiteindelijk werd de vrijheidsoorlog door Bolívar alsnog gewonnen, maar daarna werd het een onrustige tijd met veel burgeroorlogen in Venezuela. Afgezette leiders vluchtten vaak naar Curaçao, waar ze wapens kochten en weer in Venezuela aan de macht probeerden te komen.Door de nabije ligging had Curaçao zo de mogelijkheid het politieke systeem in Venezuela te beïnvloeden.\r\n\r\nRelatieve rust na de komst van de olie-industrie\r\nDe relatie veranderde toen er veel olie in Venezuela werd gevonden en de Shell na 1914 een grote raffinaderij op Curaçao bouwde waar de ruwe olie uit het Lago de Maracaibo werd verwerkt.Omdat dit economisch zo belangrijk was kwam de relatie tussen Curaçao en Venezuela in een rustiger vaarwater terecht. Deze rust werd nog even verstoord toen de revolutionair Rafael Urbina in 1929 Fort Amsterdam met geweld bezette en met de buitgemaakte wapens en de gegijzelde gouverneur Fruytier op een schip naar Venezuela vertrok. Dit had echter geen langdurig negatief effect op de relatie.\r\n\r\nMeer kans op spanningen in de relatie\r\nIn de jaren 80 verliet de Shell Curaçao en werd de raffinaderij voor lange termijn verhuurd aan de Venezolaanse staatoliemaatschappij PdVSA, waardoor de invloed van Venezuela op Curaçao groter werd. Door de sociaal-economische crisis in Venezuela na de dood van president Hugo Chávez, is nu de kans op spanningen in de relatie weer toegenomen. Mocht ook de PdVSA van Curaçao vertrekken, dan breekt er weer een nieuwe periode in de relatie aan.\r\n\r\nAfgezien van bestuurlijke en handels relaties, zijn er in de loop van de eeuwen zeer veel familierelaties ontstaan tussen de bevolkingen van Curaçao en Venezuela. Ook op cultureel gebied (muziek, keuken) heeft Venezuela een sterke invloed gehad op Curaçao.', '44. Religie en religieuze vieringen', '', 'inherit', 'closed', 'closed', '', '93-revision-v1', '', '', '2018-01-15 20:57:42', '2018-01-15 19:57:42', '', '93', 'https://canoncuracao.cw/93-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('469', '3', '2018-01-15 20:58:46', '2018-01-15 19:58:46', '', '45. De relatie met Venezuela', '', 'inherit', 'closed', 'closed', '', '95-revision-v1', '', '', '2018-01-15 20:58:46', '2018-01-15 19:58:46', '', '95', 'https://canoncuracao.cw/95-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('470', '3', '2018-01-15 21:05:17', '2018-01-15 20:05:17', '', '20. De komst van de religieuze ordes uit Nederland en hun betekenis', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2018-01-15 21:05:17', '2018-01-15 20:05:17', '', '45', 'https://canoncuracao.cw/45-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('471', '3', '2018-01-15 21:05:51', '2018-01-15 20:05:51', '<h3>De verovering van Curaçao</h3>\r\nCuraçao werd in 1634 door de West-Indische Compagnie (W.I.C.) veroverd op de Spanjaarden. De Republiek was op dat moment verwikkeld in de Tachtigjarige Oorlog (1568-1648) met Spanje en Portugal. Deze landen waren sinds 1580 verenigd onder één staatshoofd, de Spaanse koning. De W.I.C. was in 1621 opgericht om te dienen als een instrument in die oorlog. Behalve met de uitvoering van een ambitieus plan, het ‘Groot Desseyn’,dat gericht was op het veroveren van Portugese gebieden in Afrika en Brazilië, was de W.I.C. vooral actief in de kaapvaart. Er bestond daarom behoefte aan een maritiem steunpunt in het operatiegebied van waaruit militaire acties konden worden ondernomen. Het strategisch gunstig gelegen Curaçao was daarvoor uitstekend geschikt. Het eiland leek goed verdedigbaar en beschikte over een uitstekende natuurlijke haven, de Sint-Annabaai.\r\nEen expeditie onder leiding van Johannes van Walbeeck en Pierre le Grand ontmoette weinig weerstand en nam Curaçao in bezit. De kleine Spaanse bezetting werd samen met het grootste deel van de inheemse bevolking gedeporteerd naar Venezuela. Daarna werd een begin gemaakt met het op orde brengen van de verdediging. Aan de oostelijke zijde van de ingang van de Sint-Annabaai, op een landtong die De Punt (Punda) werd genoemd, werd een sterkte gebouwd, Fort Amsterdam.\r\n<h3>Van oorlogsbasis naar vestigingskolonie</h3>\r\nGedurende de eerste jaren na de verovering verbleven er op Curaçao in hoofdzaak militairen. In 1635 waren slechts 20 van de 412 compagniesdienaren burgers. Er woonden verder zo’n 50 inheemse bewoners. Spoedig arriveerden ook tot slaaf gemaakte Afrikanen. Dezen waren aanvankelijk vooral afkomstig van veroverde vijandelijke schepen. Maar hun aantallen waren tot midden zeventiende eeuw nog gering.\r\nVrijwel direct nadat bekend werd dat Curaçao was veroverd, ontstond er in het moederland belangstelling voor kolonisatieprojecten. Militairen en civiele beambten op het eiland, die hun contract hadden uitgediend, kregen ook de mogelijkheid om zich als landbouwer te vestigen. Maar dit leidde nauwelijks tot concrete resultaten.\r\nIn de jaren vijftig van zeventiende eeuw vestigden zich joodse kolonisten op het eiland. In 1665 woonden er, de inheemse bevolking niet meegerekend, zo’n 600 personen. Curaçao had inmiddels geen functie meer als oorlogsbasis, maar ontwikkelde zich nu, met de vanaf 1650 opkomende slavenhandel als motor, tot een commercieel centrum. Rond deze tijd ontstond ten noorden van Fort Amsterdam een vestiging die uitgroeide tot een ommuurde stad, Willemstad. Het aantal plantages en tuinen groeide ook. Deze richtten zich vooral op de lokale voedselproductie.', '3. De verovering van Curaçao door de W.I.C. en de komst van de Hollanders', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2018-01-15 21:05:51', '2018-01-15 20:05:51', '', '12', 'https://canoncuracao.cw/12-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('472', '3', '2018-01-15 21:06:36', '2018-01-15 20:06:36', '', '15. De opbouw van de samenleving in de 19e eeuw: de verschillende bevolkingsgroepen', '', 'inherit', 'closed', 'closed', '', '35-revision-v1', '', '', '2018-01-15 21:06:36', '2018-01-15 20:06:36', '', '35', 'https://canoncuracao.cw/35-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('473', '3', '2018-01-15 21:07:19', '2018-01-15 20:07:19', '', '22. De nieuwe immigranten op Curaçao vanaf het begin van de twintigste eeuw', '', 'inherit', 'closed', 'closed', '', '49-revision-v1', '', '', '2018-01-15 21:07:19', '2018-01-15 20:07:19', '', '49', 'https://canoncuracao.cw/49-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('474', '3', '2018-01-15 21:08:56', '2018-01-15 20:08:56', '', '49. De ontwikkeling van het electriciteitsnet, de watervoorziening en het telefoonnet', '', 'inherit', 'closed', 'closed', '', '103-revision-v1', '', '', '2018-01-15 21:08:56', '2018-01-15 20:08:56', '', '103', 'https://canoncuracao.cw/103-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('475', '3', '2018-01-15 21:09:42', '2018-01-15 20:09:42', '', '49. De ontwikkeling van het electriciteitsnet, de watervoorziening en het telefoonnet', '', 'inherit', 'closed', 'closed', '', '103-revision-v1', '', '', '2018-01-15 21:09:42', '2018-01-15 20:09:42', '', '103', 'https://canoncuracao.cw/103-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('478', '3', '2018-01-17 18:38:25', '2018-01-17 17:38:25', '<ol>\r\n 	<li>de eerste bewoners</li>\r\n 	<li>de spaanse periode</li>\r\n 	<li>De verovering van Curaçao door de W.I.C. en de komst van de Hollanders</li>\r\n 	<li>Nieuwe bewoners in de zeventiende eeuw</li>\r\n 	<li>De slavenhandel en slaverij</li>\r\n 	<li>Slavernijverzet</li>\r\n 	<li>Tula</li>\r\n 	<li>Papiamentu</li>\r\n 	<li>Curaçao rond 1800</li>\r\n 	<li>De ontwikkeling van Willemstad</li>\r\n 	<li>De ontwikkeling van bewoning buiten Willemstad</li>\r\n 	<li>Brion, Piar en Bolivar</li>\r\n 	<li>Het plantagesysteem op Curaçao</li>\r\n 	<li>De afschaffing van de slavernij</li>\r\n 	<li>De opbouw van de samenleving in de 19e eeuw: de verschillende bevolkingsgroepen</li>\r\n</ol>', 'Overzicht van de vensters', '', 'inherit', 'closed', 'closed', '', '248-revision-v1', '', '', '2018-01-17 18:38:25', '2018-01-17 17:38:25', '', '248', 'https://canoncuracao.cw/248-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('479', '3', '2018-01-17 18:39:03', '2018-01-17 17:39:03', '<ol>\r\n 	<li>De eerste bewoners</li>\r\n 	<li>De spaanse periode</li>\r\n 	<li>De verovering van Curaçao door de W.I.C. en de komst van de Hollanders</li>\r\n 	<li>Nieuwe bewoners in de zeventiende eeuw</li>\r\n 	<li>De slavenhandel en slaverij</li>\r\n 	<li>Slavernijverzet</li>\r\n 	<li>Tula</li>\r\n 	<li>Papiamentu</li>\r\n 	<li>Curaçao rond 1800</li>\r\n 	<li>De ontwikkeling van Willemstad</li>\r\n 	<li>De ontwikkeling van bewoning buiten Willemstad</li>\r\n 	<li>Brion, Piar en Bolivar</li>\r\n 	<li>Het plantagesysteem op Curaçao</li>\r\n 	<li>De afschaffing van de slavernij</li>\r\n 	<li>De opbouw van de samenleving in de 19e eeuw: de verschillende bevolkingsgroepen</li>\r\n</ol>', 'Overzicht van de vensters', '', 'inherit', 'closed', 'closed', '', '248-revision-v1', '', '', '2018-01-17 18:39:03', '2018-01-17 17:39:03', '', '248', 'https://canoncuracao.cw/248-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('482', '4', '2018-04-27 15:57:48', '2018-04-27 13:57:48', 'Moises Frumencio da Costa Gomez is geboren in Otrobanda op 27 oktober 1907, als zoon van Pedro da Costa Gomez en Braulia Bikker.Het gezin woont eerst in Otrobanda en verhuist later naar de Penstraat in Pietermaai. Op zijn 15e gaat Moises na voltooiing van de MULO naar Nederland, waar hij vanaf 1923 in Nijmegen het gymnasium volgt. Van 1925 tot 1929 studeert Moises rechten aan de Universiteit van Nijmegen. De jonge jurist werkt daarna als substituut-griffier in Den Haag en als advocaat en procureur in Nijmegen. Tegelijkertijd werkt hij aan zijn dissertatie en promoveert hij aan de Universiteit van Amsterdam op 3 december 1935 op het proefschrift ‘Het wetgevend orgaan van Curaçao. Samenstelling en bevoegdheid bezien in het kader van de Nederlandse Koloniale politiek’. Hij pleit als eerste Antilliaan in een proefschrift voor autonomie en algemeen kiesrecht voor de bevolking van de Nederlandse Antillen. Hij is dan 28 jaar oud en vertrekt onmiddellijk na zijn promotie met zijn gezin naar Curaçao, waar zij op 31 december 1935 aankomen.\r\nOp het eiland noemen ze hem al spoedig ’Doktoor’. Da Costa Gomez is een staatsman met grote verdiensten voor Curaçao, de Nederlandse Antillen en het Koninkrijk der Nederlanden. In 1935 formuleert hij de visie dat de bevolking van de Antillen bereid en in staat is zichzelf te besturen. Hij ziet autonomie als een instrument om economische, sociale en culturele vooruitgang te bereiken. Hij stelt zich in de jaren veertig als missie: zelfbestuur voor de Antillen, een bestuur dat verantwoording verschuldigd is aan een parlement dat via algemeen kiesrecht is verkozen, zelfbestuur door de eilanden voor eilandelijke zaken en samenwerking en bijstand tussen de delen van het koninkrijk. Zijn gedachtegoed paste goed in de tijdgeest: ook op de andere Caribische eilanden leefde de wens om zich los te koppelen van de kolonisator.\r\nTot zijn verdiensten rekenen wij: het inspirerend verwoorden van de wens voor autonomie, bevordering van het politieke bewustzijn in de Antillen, organisatie van acties voor sociale ondersteuning in Kas di Pueblo, oprichting van de N.V.P., de wil tot samenwerken op alle bestuursniveaus, bevordering van zelfwaardering van de arme kunuku-bewoners van Curaçao, promotor van een eigen universiteit, leider van alle delegaties voor het autonomiestreven. Doktoor was de schakel tussen de Staten en de Nederlandse regering in Londen (1943) en in Den Haag (1947-1948). Hij was voorzitter of lid van diverse commissies voor het opstellen van staatsregelingen voor de Antillen en heeft een grote bijdrage geleverd aan de ontwerpen voor de gedeeltelijke autonomie van1948, de interim-regeling van 1951 en het statuut van 1954. Hij werd gezien als een zeer kundig spreker in de Staten. Hij stierf onverwacht op 22 november 1966.', '26. Dr. M. F. da Costa Gomez', '', 'inherit', 'closed', 'closed', '', '57-revision-v1', '', '', '2018-04-27 15:57:48', '2018-04-27 13:57:48', '', '57', 'https://canoncuracao.cw/57-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('483', '4', '2018-04-27 16:04:58', '2018-04-27 14:04:58', 'Van 1499 tot 1634 stond Curaçao onder Spaans gezag. In 1499 was Alonso de Ojeda de eerste Spanjaard die Curaçao bezocht. Hij was de leider van een Spaanse expeditie die het Caribisch gebied doorkruiste, waaraan ook Amerigo Vespucci en Juan de la Cosa als ‘pilotos’ (stuurmannen) deelnamen.\r\n\r\nVoor de Spaanse zeelieden waren de Indiaanse bewoners van Curaçao kennelijk erg groot en daarom werd het eiland “Isla de los Gigantes” (eiland der reuzen) genoemd. Over de oorsprong van de naam ‘Curaçao’ is veel gespeculeerd, maar er is geen duidelijke verklaring. Vast staat wel dat de naam van Indiaanse oorsprong is.\r\n\r\nVerspreid over Curaçao lagen een aantal Indiaanse dorpen, waaronder Santa Cruz, waar de ‘cacique’ (opperhoofd) woonde. Er ware in de eerste jaren nadat de Spanjaarden het eiland in 1499 hadden ingenomen geen Spaanse bestuurders op Curaçao. Waarschijnlijk kreeg Alonso de Ojeda van de Spaanse koningen wel de bevoegdheid om Curaçao te besturen, maar hij is nooit als bestuurder op het eiland geweest.\r\n\r\nDoor de grote sterfte onder de Indiaanse bevolking van Hispañola, het eiland waarop nu Haïti en de Dominicaanse Republiek liggen, veroorzaakt door de wrede behandelingen de geringe weerstand tegen Europese ziekten, ontstond daar een nijpend tekort aan arbeidskrachten. In 1513 was dit tekort zo groot, dat Don Diego Colon, de zoon van Columbus, toestemming kreeg om Aruba, Curaçao en Bonaire tot’ islas inútiles’, onnutte eilanden, te verklaren. Dit hield in dat officieel werd vastgesteld dat daar geen edele metalen werden gevonden en de eilanden ook niet geschikt warenvoor de landbouw. Dit had als gevolg dat de Indianen van deze eilanden gevangen genomen mochten worden en dat ze allen vervoerd werden naar Hispañola om daar als tot slaaf gemaakte te werken..\r\n\r\nIn 1526 kreeg Juan de Ampués, de Gouverneur van Venezuela, Curaçao in leen en de taak om Curaçao te herbevolken. Bovendien moest hij de Indianen kerstenen en het eiland tot een handelspost ontwikkelen voor onder andere verfhout en huiden. Tijdens het gouverneurschap van Juan de Ampués nam de bevolking van Cu¬raçao toe tot ongeveer 150 inwoners.\r\n\r\nNa de dood van Juan de Ampués in 1533 werd Curaçao bestuurd door zijn schoonzoon, Lázaro Bejarano, en zijn dochter Maria de Ampués. Lázaro Bejarano zou Curaçao ontwikkelen tot een grote ‘hacienda’, een plaats waar vee wordt gehouden.\r\nVervolgens kwam Curaçao eerst onder het directe bestuur van de Audiencia van Hispañola en kort daarop viel het eiland onder de gouverneur van Caracas. Curaçao werd toen lokaal bestuurd door ‘veedores’, opzichters. Van 1571-1634 was Curaçao ook een verversings¬station voor kapers, piraten en andere zeelieden.\r\n\r\nIn 1634 werd het eiland op de Spanjaarden veroverd door Johan van Walbeeck. Sinds die tijd, met een korte onderbreking in 1800-1803 en 1807-1816, toen de Britten Curaçao bestuurden, is het eiland met Nederland verbonden geweest.', '2. De Spaanse periode', '', 'inherit', 'closed', 'closed', '', '10-revision-v1', '', '', '2018-04-27 16:04:58', '2018-04-27 14:04:58', '', '10', 'https://canoncuracao.cw/10-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('485', '4', '2018-04-27 16:09:42', '2018-04-27 14:09:42', 'Van 1499 tot 1634 stond Curaçao onder Spaans gezag. In 1499 was Alonso de Ojeda de eerste Spanjaard die Curaçao bezocht. Hij was de leider van een Spaanse expeditie die het Caribisch gebied doorkruiste, waaraan ook Amerigo Vespucci en Juan de la Cosa als ‘pilotos’ (stuurmannen) deelnamen.\r\n\r\nVoor de Spaanse zeelieden waren de Indiaanse bewoners van Curaçao kennelijk erg groot en daarom werd het eiland “Isla de los Gigantes” (eiland der reuzen) genoemd. Over de oorsprong van de naam ‘Curaçao’ is veel gespeculeerd, maar er is geen duidelijke verklaring. Vast staat wel dat de naam van Indiaanse oorsprong is.\r\n\r\nVerspreid over Curaçao lagen een aantal Indiaanse dorpen, waaronder Santa Cruz, waar de ‘cacique’ (opperhoofd) woonde. Er ware in de eerste jaren nadat de Spanjaarden het eiland in 1499 hadden ingenomen geen Spaanse bestuurders op Curaçao. Waarschijnlijk kreeg Alonso de Ojeda van de Spaanse koningen wel de bevoegdheid om Curaçao te besturen, maar hij is nooit als bestuurder op het eiland geweest.\r\n\r\nDoor de grote sterfte onder de Indiaanse bevolking van Hispañola, het eiland waarop nu Haïti en de Dominicaanse Republiek liggen, veroorzaakt door de wrede behandelingen de geringe weerstand tegen Europese ziekten, ontstond daar een nijpend tekort aan arbeidskrachten. In 1513 was dit tekort zo groot, dat Don Diego Colon, de zoon van Columbus, toestemming kreeg om Aruba, Curaçao en Bonaire tot’ islas inútiles’, onnutte eilanden, te verklaren. Dit hield in dat officieel werd vastgesteld dat daar geen edele metalen werden gevonden en de eilanden ook niet geschikt warenvoor de landbouw. Dit had als gevolg dat de Indianen van deze eilanden gevangen genomen mochten worden en dat ze allen vervoerd werden naar Hispañola om daar als tot slaaf gemaakte te werken..\r\n\r\nIn 1526 kreeg Juan de Ampués, de Gouverneur van Venezuela, Curaçao in leen en de taak om Curaçao te herbevolken. Bovendien moest hij de Indianen kerstenen en het eiland tot een handelspost ontwikkelen voor onder andere verfhout en huiden. Tijdens het gouverneurschap van Juan de Ampués nam de bevolking van Cu¬raçao toe tot ongeveer 150 inwoners.\r\n\r\nNa de dood van Juan de Ampués in 1533 werd Curaçao bestuurd door zijn schoonzoon, Lázaro Bejarano, en zijn dochter Maria de Ampués. Lázaro Bejarano zou Curaçao ontwikkelen tot een grote ‘hacienda’, een plaats waar vee wordt gehouden.\r\nVervolgens kwam Curaçao eerst onder het directe bestuur van de Audiencia van Hispañola en kort daarop viel het eiland onder de gouverneur van Caracas. Curaçao werd toen lokaal bestuurd door ‘veedores’, opzichters. Van 1571-1634 was Curaçao ook een verversings¬station voor kapers, piraten en andere zeelieden.\r\n\r\nIn 1634 werd het eiland op de Spanjaarden veroverd door Johan van Walbeeck. Sinds die tijd, met een korte onderbreking in 1800-1803 en 1807-1816, toen de Britten Curaçao bestuurden, is het eiland met Nederland verbonden geweest.', '2. De Spaanse periode', '', 'inherit', 'closed', 'closed', '', '10-revision-v1', '', '', '2018-04-27 16:09:42', '2018-04-27 14:09:42', '', '10', 'https://canoncuracao.cw/10-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('486', '4', '2018-04-27 16:14:12', '2018-04-27 14:14:12', 'Van 1499 tot 1634 stond Curaçao onder Spaans gezag. In 1499 was Alonso de Ojeda de eerste Spanjaard die Curaçao bezocht. Hij was de leider van een Spaanse expeditie die het Caribisch gebied doorkruiste, waaraan ook Amerigo Vespucci en Juan de la Cosa als ‘pilotos’ (stuurmannen) deelnamen.\r\n\r\nVoor de Spaanse zeelieden waren de Indiaanse bewoners van Curaçao kennelijk erg groot en daarom werd het eiland “Isla de los Gigantes” (eiland der reuzen) genoemd. Over de oorsprong van de naam ‘Curaçao’ is veel gespeculeerd, maar er is geen duidelijke verklaring. Vast staat wel dat de naam van Indiaanse oorsprong is.\r\n\r\nVerspreid over Curaçao lagen een aantal Indiaanse dorpen, waaronder Santa Cruz, waar de ‘cacique’ (opperhoofd) woonde. Er ware in de eerste jaren nadat de Spanjaarden het eiland in 1499 hadden ingenomen geen Spaanse bestuurders op Curaçao. Waarschijnlijk kreeg Alonso de Ojeda van de Spaanse koningen wel de bevoegdheid om Curaçao te besturen, maar hij is nooit als bestuurder op het eiland geweest.\r\n\r\nDoor de grote sterfte onder de Indiaanse bevolking van Hispañola, het eiland waarop nu Haïti en de Dominicaanse Republiek liggen, veroorzaakt door de wrede behandelingen de geringe weerstand tegen Europese ziekten, ontstond daar een nijpend tekort aan arbeidskrachten. In 1513 was dit tekort zo groot, dat Don Diego Colon, de zoon van Columbus, toestemming kreeg om Aruba, Curaçao en Bonaire tot’ islas inútiles’, onnutte eilanden, te verklaren. Dit hield in dat officieel werd vastgesteld dat daar geen edele metalen werden gevonden en de eilanden ook niet geschikt warenvoor de landbouw. Dit had als gevolg dat de Indianen van deze eilanden gevangen genomen mochten worden en dat ze allen vervoerd werden naar Hispañola om daar als tot slaaf gemaakte te werken..\r\n\r\nIn 1526 kreeg Juan de Ampués, de Gouverneur van Venezuela, Curaçao in leen en de taak om Curaçao te herbevolken. Bovendien moest hij de Indianen kerstenen en het eiland tot een handelspost ontwikkelen voor onder andere verfhout en huiden. Tijdens het gouverneurschap van Juan de Ampués nam de bevolking van Cu¬raçao toe tot ongeveer 150 inwoners.\r\n\r\nNa de dood van Juan de Ampués in 1533 werd Curaçao bestuurd door zijn schoonzoon, Lázaro Bejarano, en zijn dochter Maria de Ampués. Lázaro Bejarano zou Curaçao ontwikkelen tot een grote ‘hacienda’, een plaats waar vee wordt gehouden.\r\nVervolgens kwam Curaçao eerst onder het directe bestuur van de Audiencia van Hispañola en kort daarop viel het eiland onder de gouverneur van Caracas. Curaçao werd toen lokaal bestuurd door ‘veedores’, opzichters. Van 1571-1634 was Curaçao ook een verversings¬station voor kapers, piraten en andere zeelieden.\r\n\r\nIn 1634 werd het eiland op de Spanjaarden veroverd door Johan van Walbeeck. Sinds die tijd, met een korte onderbreking in 1800-1803 en 1807-1816, toen de Britten Curaçao bestuurden, is het eiland met Nederland verbonden geweest.', '2. De Spaanse periode', '', 'inherit', 'closed', 'closed', '', '10-revision-v1', '', '', '2018-04-27 16:14:12', '2018-04-27 14:14:12', '', '10', 'https://canoncuracao.cw/10-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('488', '4', '2018-04-27 16:19:01', '2018-04-27 14:19:01', 'Van 1499 tot 1634 stond Curaçao onder Spaans gezag. In 1499 was Alonso de Ojeda de eerste Spanjaard die Curaçao bezocht. Hij was de leider van een Spaanse expeditie die het Caribisch gebied doorkruiste, waaraan ook Amerigo Vespucci en Juan de la Cosa als ‘pilotos’ (stuurmannen) deelnamen.\r\n\r\nVoor de Spaanse zeelieden waren de Indiaanse bewoners van Curaçao kennelijk erg groot en daarom werd het eiland “Isla de los Gigantes” (eiland der reuzen) genoemd. Over de oorsprong van de naam ‘Curaçao’ is veel gespeculeerd, maar er is geen duidelijke verklaring. Vast staat wel dat de naam van Indiaanse oorsprong is.\r\n\r\nVerspreid over Curaçao lagen een aantal Indiaanse dorpen, waaronder Santa Cruz, waar de ‘cacique’ (opperhoofd) woonde. Er ware in de eerste jaren nadat de Spanjaarden het eiland in 1499 hadden ingenomen geen Spaanse bestuurders op Curaçao. Waarschijnlijk kreeg Alonso de Ojeda van de Spaanse koningen wel de bevoegdheid om Curaçao te besturen, maar hij is nooit als bestuurder op het eiland geweest.\r\n\r\nDoor de grote sterfte onder de Indiaanse bevolking van Hispañola, het eiland waarop nu Haïti en de Dominicaanse Republiek liggen, veroorzaakt door de wrede behandelingen de geringe weerstand tegen Europese ziekten, ontstond daar een nijpend tekort aan arbeidskrachten. In 1513 was dit tekort zo groot, dat Don Diego Colon, de zoon van Columbus, toestemming kreeg om Aruba, Curaçao en Bonaire tot’ islas inútiles’, onnutte eilanden, te verklaren. Dit hield in dat officieel werd vastgesteld dat daar geen edele metalen werden gevonden en de eilanden ook niet geschikt warenvoor de landbouw. Dit had als gevolg dat de Indianen van deze eilanden gevangen genomen mochten worden en dat ze allen vervoerd werden naar Hispañola om daar als tot slaaf gemaakte te werken..\r\n\r\nIn 1526 kreeg Juan de Ampués, de Gouverneur van Venezuela, Curaçao in leen en de taak om Curaçao te herbevolken. Bovendien moest hij de Indianen kerstenen en het eiland tot een handelspost ontwikkelen voor onder andere verfhout en huiden. Tijdens het gouverneurschap van Juan de Ampués nam de bevolking van Cu¬raçao toe tot ongeveer 150 inwoners.\r\n\r\nNa de dood van Juan de Ampués in 1533 werd Curaçao bestuurd door zijn schoonzoon, Lázaro Bejarano, en zijn dochter Maria de Ampués. Lázaro Bejarano zou Curaçao ontwikkelen tot een grote ‘hacienda’, een plaats waar vee wordt gehouden.\r\nVervolgens kwam Curaçao eerst onder het directe bestuur van de Audiencia van Hispañola en kort daarop viel het eiland onder de gouverneur van Caracas. Curaçao werd toen lokaal bestuurd door ‘veedores’, opzichters. Van 1571-1634 was Curaçao ook een verversings¬station voor kapers, piraten en andere zeelieden.\r\n\r\nIn 1634 werd het eiland op de Spanjaarden veroverd door Johan van Walbeeck. Sinds die tijd, met een korte onderbreking in 1800-1803 en 1807-1816, toen de Britten Curaçao bestuurden, is het eiland met Nederland verbonden geweest.', '2. De Spaanse periode', '', 'inherit', 'closed', 'closed', '', '10-revision-v1', '', '', '2018-04-27 16:19:01', '2018-04-27 14:19:01', '', '10', 'https://canoncuracao.cw/10-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('491', '4', '2018-04-27 16:27:34', '2018-04-27 14:27:34', 'Van 1499 tot 1634 stond Curaçao onder Spaans gezag. In 1499 was Alonso de Ojeda de eerste Spanjaard die Curaçao bezocht. Hij was de leider van een Spaanse expeditie die het Caribisch gebied doorkruiste, waaraan ook Amerigo Vespucci en Juan de la Cosa als ‘pilotos’ (stuurmannen) deelnamen.\r\n\r\nVoor de Spaanse zeelieden waren de Indiaanse bewoners van Curaçao kennelijk erg groot en daarom werd het eiland “Isla de los Gigantes” (eiland der reuzen) genoemd. Over de oorsprong van de naam ‘Curaçao’ is veel gespeculeerd, maar er is geen duidelijke verklaring. Vast staat wel dat de naam van Indiaanse oorsprong is.\r\n\r\nVerspreid over Curaçao lagen een aantal Indiaanse dorpen, waaronder Santa Cruz, waar de ‘cacique’ (opperhoofd) woonde. Er ware in de eerste jaren nadat de Spanjaarden het eiland in 1499 hadden ingenomen geen Spaanse bestuurders op Curaçao. Waarschijnlijk kreeg Alonso de Ojeda van de Spaanse koningen wel de bevoegdheid om Curaçao te besturen, maar hij is nooit als bestuurder op het eiland geweest.\r\n\r\nDoor de grote sterfte onder de Indiaanse bevolking van Hispañola, het eiland waarop nu Haïti en de Dominicaanse Republiek liggen, veroorzaakt door de wrede behandelingen de geringe weerstand tegen Europese ziekten, ontstond daar een nijpend tekort aan arbeidskrachten. In 1513 was dit tekort zo groot, dat Don Diego Colon, de zoon van Columbus, toestemming kreeg om Aruba, Curaçao en Bonaire tot’ islas inútiles’, onnutte eilanden, te verklaren. Dit hield in dat officieel werd vastgesteld dat daar geen edele metalen werden gevonden en de eilanden ook niet geschikt warenvoor de landbouw. Dit had als gevolg dat de Indianen van deze eilanden gevangen genomen mochten worden en dat ze allen vervoerd werden naar Hispañola om daar als tot slaaf gemaakte te werken..\r\n\r\nIn 1526 kreeg Juan de Ampués, de Gouverneur van Venezuela, Curaçao in leen en de taak om Curaçao te herbevolken. Bovendien moest hij de Indianen kerstenen en het eiland tot een handelspost ontwikkelen voor onder andere verfhout en huiden. Tijdens het gouverneurschap van Juan de Ampués nam de bevolking van Cu¬raçao toe tot ongeveer 150 inwoners.\r\n\r\nNa de dood van Juan de Ampués in 1533 werd Curaçao bestuurd door zijn schoonzoon, Lázaro Bejarano, en zijn dochter Maria de Ampués. Lázaro Bejarano zou Curaçao ontwikkelen tot een grote ‘hacienda’, een plaats waar vee wordt gehouden.\r\nVervolgens kwam Curaçao eerst onder het directe bestuur van de Audiencia van Hispañola en kort daarop viel het eiland onder de gouverneur van Caracas. Curaçao werd toen lokaal bestuurd door ‘veedores’, opzichters. Van 1571-1634 was Curaçao ook een verversings¬station voor kapers, piraten en andere zeelieden.\r\n\r\nIn 1634 werd het eiland op de Spanjaarden veroverd door Johan van Walbeeck. Sinds die tijd, met een korte onderbreking in 1800-1803 en 1807-1816, toen de Britten Curaçao bestuurden, is het eiland met Nederland verbonden geweest.', '2. De Spaanse periode', '', 'inherit', 'closed', 'closed', '', '10-revision-v1', '', '', '2018-04-27 16:27:34', '2018-04-27 14:27:34', '', '10', 'https://canoncuracao.cw/10-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('492', '4', '2018-04-27 16:29:56', '2018-04-27 14:29:56', '', 'H1 5 alonso', '', 'inherit', 'open', 'closed', '', 'h1-5-alonso', '', '', '2018-04-27 16:30:02', '2018-04-27 14:30:02', '', '10', 'https://canoncuracao.cw/wp-content/uploads/2017/05/H1-5-alonso.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('493', '4', '2018-04-27 16:30:16', '2018-04-27 14:30:16', '', 'H1 12 kerk bejarano sta barbara', '', 'inherit', 'open', 'closed', '', 'h1-12-kerk-bejarano-sta-barbara', '', '', '2018-04-27 16:30:19', '2018-04-27 14:30:19', '', '10', 'https://canoncuracao.cw/wp-content/uploads/2017/05/H1-12-kerk-bejarano-sta-barbara.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('494', '4', '2018-04-27 16:30:22', '2018-04-27 14:30:22', 'Van 1499 tot 1634 stond Curaçao onder Spaans gezag. In 1499 was Alonso de Ojeda de eerste Spanjaard die Curaçao bezocht. Hij was de leider van een Spaanse expeditie die het Caribisch gebied doorkruiste, waaraan ook Amerigo Vespucci en Juan de la Cosa als ‘pilotos’ (stuurmannen) deelnamen.\r\n\r\nVoor de Spaanse zeelieden waren de Indiaanse bewoners van Curaçao kennelijk erg groot en daarom werd het eiland “Isla de los Gigantes” (eiland der reuzen) genoemd. Over de oorsprong van de naam ‘Curaçao’ is veel gespeculeerd, maar er is geen duidelijke verklaring. Vast staat wel dat de naam van Indiaanse oorsprong is.\r\n\r\nVerspreid over Curaçao lagen een aantal Indiaanse dorpen, waaronder Santa Cruz, waar de ‘cacique’ (opperhoofd) woonde. Er ware in de eerste jaren nadat de Spanjaarden het eiland in 1499 hadden ingenomen geen Spaanse bestuurders op Curaçao. Waarschijnlijk kreeg Alonso de Ojeda van de Spaanse koningen wel de bevoegdheid om Curaçao te besturen, maar hij is nooit als bestuurder op het eiland geweest.\r\n\r\nDoor de grote sterfte onder de Indiaanse bevolking van Hispañola, het eiland waarop nu Haïti en de Dominicaanse Republiek liggen, veroorzaakt door de wrede behandelingen de geringe weerstand tegen Europese ziekten, ontstond daar een nijpend tekort aan arbeidskrachten. In 1513 was dit tekort zo groot, dat Don Diego Colon, de zoon van Columbus, toestemming kreeg om Aruba, Curaçao en Bonaire tot’ islas inútiles’, onnutte eilanden, te verklaren. Dit hield in dat officieel werd vastgesteld dat daar geen edele metalen werden gevonden en de eilanden ook niet geschikt warenvoor de landbouw. Dit had als gevolg dat de Indianen van deze eilanden gevangen genomen mochten worden en dat ze allen vervoerd werden naar Hispañola om daar als tot slaaf gemaakte te werken..\r\n\r\nIn 1526 kreeg Juan de Ampués, de Gouverneur van Venezuela, Curaçao in leen en de taak om Curaçao te herbevolken. Bovendien moest hij de Indianen kerstenen en het eiland tot een handelspost ontwikkelen voor onder andere verfhout en huiden. Tijdens het gouverneurschap van Juan de Ampués nam de bevolking van Cu¬raçao toe tot ongeveer 150 inwoners.\r\n\r\nNa de dood van Juan de Ampués in 1533 werd Curaçao bestuurd door zijn schoonzoon, Lázaro Bejarano, en zijn dochter Maria de Ampués. Lázaro Bejarano zou Curaçao ontwikkelen tot een grote ‘hacienda’, een plaats waar vee wordt gehouden.\r\nVervolgens kwam Curaçao eerst onder het directe bestuur van de Audiencia van Hispañola en kort daarop viel het eiland onder de gouverneur van Caracas. Curaçao werd toen lokaal bestuurd door ‘veedores’, opzichters. Van 1571-1634 was Curaçao ook een verversings¬station voor kapers, piraten en andere zeelieden.\r\n\r\nIn 1634 werd het eiland op de Spanjaarden veroverd door Johan van Walbeeck. Sinds die tijd, met een korte onderbreking in 1800-1803 en 1807-1816, toen de Britten Curaçao bestuurden, is het eiland met Nederland verbonden geweest.', '2. De Spaanse periode', '', 'inherit', 'closed', 'closed', '', '10-revision-v1', '', '', '2018-04-27 16:30:22', '2018-04-27 14:30:22', '', '10', 'https://canoncuracao.cw/10-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('495', '4', '2018-04-27 16:38:44', '2018-04-27 14:38:44', 'De allervroegste aanwijzingen voor de aanwezigheid van mensen op Curaçao dateert van ongeveer 3400 voor Christus. Rond deze tijd komen indianen van het vasteland van Venezuela en Colombia per kano richting Curaçao (en later ook naar Aruba en Bonaire). Archeologische resten uit deze vroege (pre-ceramische of Archaïsche) periode vinden we terug bij onder andere Rooi Rincon, de Sint Jorisbaai en Seru Boca. Deze indianen leefden voornamelijk van schelpdieren. Sporen van hun aanwezigheid we dan ook in groten getale terug in de vorm van zogenaamde shell middens (schelphopen). Hierin vinden we ook hun werktuigen van schelp, steen en koraal terug. Ze maakten zelf geen aardewerk en zullen bijvoorbeeld kalebassen gebruikt hebben als schalen. Behalve schelpdieren zullen ze ook vruchten verzameld hebben.\r\n\r\nHoewel onduidelijk is of deze indianen daadwerkelijk op Curaçao hebben gewoond of alleen in bepaalde seizoenen langskwamen, is het vrijwel zeker dat rond 2000 voor Christus echt sprake is van bewoning op Curaçao. De oudste menselijke resten die zijn teruggevonden aan de voet van de Sint Michielsberg (circa 2000-1650 voor Christus), vormen hiervoor een aanwijzing. Het ligt voor de hand dat de verwanten van deze overledenen in de directe omgeving hebben gewoond, aangezien het gebruikelijk was om de overledenen binnen de nederzetting en zelfs binnen huizen te begraven.\r\nEr zijn aanwijzingen dat rond 1000 voor Christus onversierd aardewerk wordt gebruikt. Kleine fragmenten hiervan zijn in kleine hoeveelheden bij het Spaanse Water en de Vlakte van Hato aangetroffen. Het is mogelijk dat dit aardewerk van het vasteland is meegenomen. Vermoedelijk worden vanaf deze periode en mogelijk al eerder, rotstekeningen aangebracht op kalkstenen rotswanden en losse rotsblokken (bijvoorbeeld Savonet).\r\n\r\nDe ceramische periode begint op Curaçao rond 1000 na Christus met grote nederzettingen zoals bijvoorbeeld De Savaan, San Juan en Santa Cruz. Hier vinden we resten terug van bewoning in de vorm van paalgaten, haardplaatsen en graven. Deze Caquetio indianen maakten ‘Dabajuroid’ aardewerk. Dit is te herkennen aan de zwarte, bruine, rode en witte versiering door middel van voornamelijk lijnen en stippen. Soms werden op het aardewerk ook dierenkoppen afgebeeld. Ook de Caquetio hebben shell middens achtergelaten, maar met daarin een grote hoeveelheid aardewerk, sieraden, bijlen, maalstenen, en andere werktuigen van steen, schelp, koraal en dierlijk bot. De taal die de Caquetio spraken is waarschijnlijk een variant van de Arawak taalfamilie geweest. Naast schelpdieren zullen de Caquetio ook maniok, maïs en fruit gegeten hebben dat ze verbouwden in tuinen. Ze stonden bij de Spanjaarden bekend als goede landbouwers en kanovaarders. De aanwezigheid van maïs en maniok blijkt uit resten van vuursteen voor het raspen van maniok en maalstenen voor het bewerken van maïs.', '1. De oorspronkelijke bewoners', '', 'inherit', 'closed', 'closed', '', '8-revision-v1', '', '', '2018-04-27 16:38:44', '2018-04-27 14:38:44', '', '8', 'https://canoncuracao.cw/8-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('496', '4', '2018-04-27 16:44:30', '2018-04-27 14:44:30', 'Tot de komst van de West-Indische Compagnie in 1634 werden de Benedenwindse Eilanden bewoond door  Caquetio, die na 1499 werden bestuurd door Spanjaarden. Johan van Walbeeck stuurde alle Spanjaarden en een groot gedeelte van de Caiquetio naar het vasteland. Daardoor raakte Curaçao vrijwel ontvolkt. De komst van de WIC zorgt ervoor dat de bevolking in de eerste Nederlandse jaren voornamelijk uit Europese mannen bestaat. Dat leidt tot een nogal woeste samenleving, waar de dominee regelmatig over klaagt. De opeenvolgende Directeuren van de WIC vragen de WIC regelmatig om ‘nette’ vrouwen te sturen, maar er is nog weinig aantrekkelijks voor deze vrouwen om naar Curaçao te komen. Pas als Peter Stuyvesant en zijn opvolger Mathias Beck het Directeurschap op zich nemen rond 1645, let men meer op de leefomstandigheden op de eilanden. Vooral de zorgelijke voedselsituatie krijgt aandacht: de WIC is een bedrijf dat winst moet maken, en voedsel importeren is een kostbare zaak. Daarom nodigt Stuyvesant tijdens zijn bewind Sefardische joden, die oorspronkelijk uit Spanje en Portugal vanwege de inquisitie naar Nederland waren gevlucht voor de Inquisitie, uit om plantages te starten op de eilanden om lokaal voedsel te produceren. Ook verandert de manier waarop de Compagnie Curaçao wil gebruiken: was eerst de Kaapvaart een belangrijk argument om Curaçao  in bezit te nemen, in de praktijk blijkt dat die te weinig oplevert. Maar, door de in Brazilië opgedane kennis over de Transatlantische Slavenhandel realiseert de WIC zich dat Curaçao ideaal is als regionale slavenmarkt. Dit leidt uiteindelijk tot vier groepen bewoners op het eiland: de overgebleven Caiquetio, de Europeanen, de Sefardische Joden en de tot slaaf gemaakte Afrikanen vormen vanaf de tweede helft van de zeventiende eeuw de bevolking. Deze samenleving ontwikkelt zich tot een ‘gesegmenteerde’ maatschappij. Een segment is een groep mensen die daartoe behoren door geboorte, afkomst, huidskleur en geloof, waarbij het wisselen van segment vrijwel onmogelijk is. Tevens hebben de leden van sommige segmenten meer rechten dan anderen. De indeling loopt van de hoge blanke protestant, zoals de kooplieden en hoge WIC-ambtenaren met veel rechten tot de tot slaaf gemaakt Afrikanen die geen enkel recht hebben. Daartussen bewegen zich de andere groepen, zoals de Sefardische Joden, lage blanke protestanten en de kleurlingen, de laatste groep het gevolg van gemengde relaties.', '4. Nieuwe bewoners in de zeventiende eeuw', '', 'inherit', 'closed', 'closed', '', '4-revision-v1', '', '', '2018-04-27 16:44:30', '2018-04-27 14:44:30', '', '4', 'https://canoncuracao.cw/4-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('497', '4', '2018-04-27 16:50:23', '2018-04-27 14:50:23', '', 'peter-paul-rubens-vier-studies-van-het-hoofd-van-een-neger-i20648', '', 'inherit', 'open', 'closed', '', 'peter-paul-rubens-vier-studies-van-het-hoofd-van-een-neger-i20648', '', '', '2018-04-27 16:50:35', '2018-04-27 14:50:35', '', '4', 'https://canoncuracao.cw/wp-content/uploads/2017/05/peter-paul-rubens-vier-studies-van-het-hoofd-van-een-neger-i20648.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('498', '4', '2018-04-27 16:51:14', '2018-04-27 14:51:14', 'Tot de komst van de West-Indische Compagnie in 1634 werden de Benedenwindse Eilanden bewoond door  Caquetio, die na 1499 werden bestuurd door Spanjaarden. Johan van Walbeeck stuurde alle Spanjaarden en een groot gedeelte van de Caiquetio naar het vasteland. Daardoor raakte Curaçao vrijwel ontvolkt. De komst van de WIC zorgt ervoor dat de bevolking in de eerste Nederlandse jaren voornamelijk uit Europese mannen bestaat. Dat leidt tot een nogal woeste samenleving, waar de dominee regelmatig over klaagt. De opeenvolgende Directeuren van de WIC vragen de WIC regelmatig om ‘nette’ vrouwen te sturen, maar er is nog weinig aantrekkelijks voor deze vrouwen om naar Curaçao te komen. Pas als Peter Stuyvesant en zijn opvolger Mathias Beck het Directeurschap op zich nemen rond 1645, let men meer op de leefomstandigheden op de eilanden. Vooral de zorgelijke voedselsituatie krijgt aandacht: de WIC is een bedrijf dat winst moet maken, en voedsel importeren is een kostbare zaak. Daarom nodigt Stuyvesant tijdens zijn bewind Sefardische joden, die oorspronkelijk uit Spanje en Portugal vanwege de inquisitie naar Nederland waren gevlucht voor de Inquisitie, uit om plantages te starten op de eilanden om lokaal voedsel te produceren. Ook verandert de manier waarop de Compagnie Curaçao wil gebruiken: was eerst de Kaapvaart een belangrijk argument om Curaçao  in bezit te nemen, in de praktijk blijkt dat die te weinig oplevert. Maar, door de in Brazilië opgedane kennis over de Transatlantische Slavenhandel realiseert de WIC zich dat Curaçao ideaal is als regionale slavenmarkt. Dit leidt uiteindelijk tot vier groepen bewoners op het eiland: de overgebleven Caiquetio, de Europeanen, de Sefardische Joden en de tot slaaf gemaakte Afrikanen vormen vanaf de tweede helft van de zeventiende eeuw de bevolking. Deze samenleving ontwikkelt zich tot een ‘gesegmenteerde’ maatschappij. Een segment is een groep mensen die daartoe behoren door geboorte, afkomst, huidskleur en geloof, waarbij het wisselen van segment vrijwel onmogelijk is. Tevens hebben de leden van sommige segmenten meer rechten dan anderen. De indeling loopt van de hoge blanke protestant, zoals de kooplieden en hoge WIC-ambtenaren met veel rechten tot de tot slaaf gemaakt Afrikanen die geen enkel recht hebben. Daartussen bewegen zich de andere groepen, zoals de Sefardische Joden, lage blanke protestanten en de kleurlingen, de laatste groep het gevolg van gemengde relaties.', '4. Nieuwe bewoners in de zeventiende eeuw', '', 'inherit', 'closed', 'closed', '', '4-revision-v1', '', '', '2018-04-27 16:51:14', '2018-04-27 14:51:14', '', '4', 'https://canoncuracao.cw/4-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('499', '4', '2018-04-27 17:14:05', '2018-04-27 15:14:05', 'Tot de komst van de West-Indische Compagnie in 1634 werden de Benedenwindse Eilanden bewoond door  Caquetio, die na 1499 werden bestuurd door Spanjaarden. Johan van Walbeeck stuurde alle Spanjaarden en een groot gedeelte van de Caiquetio naar het vasteland. Daardoor raakte Curaçao vrijwel ontvolkt. De komst van de WIC zorgt ervoor dat de bevolking in de eerste Nederlandse jaren voornamelijk uit Europese mannen bestaat. Dat leidt tot een nogal woeste samenleving, waar de dominee regelmatig over klaagt. De opeenvolgende Directeuren van de WIC vragen de WIC regelmatig om ‘nette’ vrouwen te sturen, maar er is nog weinig aantrekkelijks voor deze vrouwen om naar Curaçao te komen. Pas als Peter Stuyvesant en zijn opvolger Mathias Beck het Directeurschap op zich nemen rond 1645, let men meer op de leefomstandigheden op de eilanden. Vooral de zorgelijke voedselsituatie krijgt aandacht: de WIC is een bedrijf dat winst moet maken, en voedsel importeren is een kostbare zaak. Daarom nodigt Stuyvesant tijdens zijn bewind Sefardische joden, die oorspronkelijk uit Spanje en Portugal vanwege de inquisitie naar Nederland waren gevlucht voor de Inquisitie, uit om plantages te starten op de eilanden om lokaal voedsel te produceren. Ook verandert de manier waarop de Compagnie Curaçao wil gebruiken: was eerst de Kaapvaart een belangrijk argument om Curaçao  in bezit te nemen, in de praktijk blijkt dat die te weinig oplevert. Maar, door de in Brazilië opgedane kennis over de Transatlantische Slavenhandel realiseert de WIC zich dat Curaçao ideaal is als regionale slavenmarkt. Dit leidt uiteindelijk tot vier groepen bewoners op het eiland: de overgebleven Caiquetio, de Europeanen, de Sefardische Joden en de tot slaaf gemaakte Afrikanen vormen vanaf de tweede helft van de zeventiende eeuw de bevolking. Deze samenleving ontwikkelt zich tot een ‘gesegmenteerde’ maatschappij. Een segment is een groep mensen die daartoe behoren door geboorte, afkomst, huidskleur en geloof, waarbij het wisselen van segment vrijwel onmogelijk is. Tevens hebben de leden van sommige segmenten meer rechten dan anderen. De indeling loopt van de hoge blanke protestant, zoals de kooplieden en hoge WIC-ambtenaren met veel rechten tot de tot slaaf gemaakt Afrikanen die geen enkel recht hebben. Daartussen bewegen zich de andere groepen, zoals de Sefardische Joden, lage blanke protestanten en de kleurlingen, de laatste groep het gevolg van gemengde relaties.', '4. Nieuwe bewoners in de zeventiende eeuw', '', 'inherit', 'closed', 'closed', '', '4-revision-v1', '', '', '2018-04-27 17:14:05', '2018-04-27 15:14:05', '', '4', 'https://canoncuracao.cw/4-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('500', '4', '2018-04-27 17:19:49', '2018-04-27 15:19:49', '', 'Beth Haim Fischer', '', 'inherit', 'open', 'closed', '', 'beth-haim-fischer', '', '', '2018-04-27 17:19:56', '2018-04-27 15:19:56', '', '4', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Beth-Haim-Fischer.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('501', '4', '2018-04-27 17:20:03', '2018-04-27 15:20:03', 'Tot de komst van de West-Indische Compagnie in 1634 werden de Benedenwindse Eilanden bewoond door  Caquetio, die na 1499 werden bestuurd door Spanjaarden. Johan van Walbeeck stuurde alle Spanjaarden en een groot gedeelte van de Caiquetio naar het vasteland. Daardoor raakte Curaçao vrijwel ontvolkt. De komst van de WIC zorgt ervoor dat de bevolking in de eerste Nederlandse jaren voornamelijk uit Europese mannen bestaat. Dat leidt tot een nogal woeste samenleving, waar de dominee regelmatig over klaagt. De opeenvolgende Directeuren van de WIC vragen de WIC regelmatig om ‘nette’ vrouwen te sturen, maar er is nog weinig aantrekkelijks voor deze vrouwen om naar Curaçao te komen. Pas als Peter Stuyvesant en zijn opvolger Mathias Beck het Directeurschap op zich nemen rond 1645, let men meer op de leefomstandigheden op de eilanden. Vooral de zorgelijke voedselsituatie krijgt aandacht: de WIC is een bedrijf dat winst moet maken, en voedsel importeren is een kostbare zaak. Daarom nodigt Stuyvesant tijdens zijn bewind Sefardische joden, die oorspronkelijk uit Spanje en Portugal vanwege de inquisitie naar Nederland waren gevlucht voor de Inquisitie, uit om plantages te starten op de eilanden om lokaal voedsel te produceren. Ook verandert de manier waarop de Compagnie Curaçao wil gebruiken: was eerst de Kaapvaart een belangrijk argument om Curaçao  in bezit te nemen, in de praktijk blijkt dat die te weinig oplevert. Maar, door de in Brazilië opgedane kennis over de Transatlantische Slavenhandel realiseert de WIC zich dat Curaçao ideaal is als regionale slavenmarkt. Dit leidt uiteindelijk tot vier groepen bewoners op het eiland: de overgebleven Caiquetio, de Europeanen, de Sefardische Joden en de tot slaaf gemaakte Afrikanen vormen vanaf de tweede helft van de zeventiende eeuw de bevolking. Deze samenleving ontwikkelt zich tot een ‘gesegmenteerde’ maatschappij. Een segment is een groep mensen die daartoe behoren door geboorte, afkomst, huidskleur en geloof, waarbij het wisselen van segment vrijwel onmogelijk is. Tevens hebben de leden van sommige segmenten meer rechten dan anderen. De indeling loopt van de hoge blanke protestant, zoals de kooplieden en hoge WIC-ambtenaren met veel rechten tot de tot slaaf gemaakt Afrikanen die geen enkel recht hebben. Daartussen bewegen zich de andere groepen, zoals de Sefardische Joden, lage blanke protestanten en de kleurlingen, de laatste groep het gevolg van gemengde relaties.', '4. Nieuwe bewoners in de zeventiende eeuw', '', 'inherit', 'closed', 'closed', '', '4-revision-v1', '', '', '2018-04-27 17:20:03', '2018-04-27 15:20:03', '', '4', 'https://canoncuracao.cw/4-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('502', '4', '2018-04-27 17:22:26', '2018-04-27 15:22:26', 'Tot de komst van de West-Indische Compagnie in 1634 werden de Benedenwindse Eilanden bewoond door  Caquetio, die na 1499 werden bestuurd door Spanjaarden. Johan van Walbeeck stuurde alle Spanjaarden en een groot gedeelte van de Caiquetio naar het vasteland. Daardoor raakte Curaçao vrijwel ontvolkt. De komst van de WIC zorgt ervoor dat de bevolking in de eerste Nederlandse jaren voornamelijk uit Europese mannen bestaat. Dat leidt tot een nogal woeste samenleving, waar de dominee regelmatig over klaagt. De opeenvolgende Directeuren van de WIC vragen de WIC regelmatig om ‘nette’ vrouwen te sturen, maar er is nog weinig aantrekkelijks voor deze vrouwen om naar Curaçao te komen. Pas als Peter Stuyvesant en zijn opvolger Mathias Beck het Directeurschap op zich nemen rond 1645, let men meer op de leefomstandigheden op de eilanden. Vooral de zorgelijke voedselsituatie krijgt aandacht: de WIC is een bedrijf dat winst moet maken, en voedsel importeren is een kostbare zaak. Daarom nodigt Stuyvesant tijdens zijn bewind Sefardische joden, die oorspronkelijk uit Spanje en Portugal vanwege de inquisitie naar Nederland waren gevlucht voor de Inquisitie, uit om plantages te starten op de eilanden om lokaal voedsel te produceren. Ook verandert de manier waarop de Compagnie Curaçao wil gebruiken: was eerst de Kaapvaart een belangrijk argument om Curaçao  in bezit te nemen, in de praktijk blijkt dat die te weinig oplevert. Maar, door de in Brazilië opgedane kennis over de Transatlantische Slavenhandel realiseert de WIC zich dat Curaçao ideaal is als regionale slavenmarkt. Dit leidt uiteindelijk tot vier groepen bewoners op het eiland: de overgebleven Caiquetio, de Europeanen, de Sefardische Joden en de tot slaaf gemaakte Afrikanen vormen vanaf de tweede helft van de zeventiende eeuw de bevolking. Deze samenleving ontwikkelt zich tot een ‘gesegmenteerde’ maatschappij. Een segment is een groep mensen die daartoe behoren door geboorte, afkomst, huidskleur en geloof, waarbij het wisselen van segment vrijwel onmogelijk is. Tevens hebben de leden van sommige segmenten meer rechten dan anderen. De indeling loopt van de hoge blanke protestant, zoals de kooplieden en hoge WIC-ambtenaren met veel rechten tot de tot slaaf gemaakt Afrikanen die geen enkel recht hebben. Daartussen bewegen zich de andere groepen, zoals de Sefardische Joden, lage blanke protestanten en de kleurlingen, de laatste groep het gevolg van gemengde relaties.', '4. Nieuwe bewoners in de zeventiende eeuw', '', 'inherit', 'closed', 'closed', '', '4-revision-v1', '', '', '2018-04-27 17:22:26', '2018-04-27 15:22:26', '', '4', 'https://canoncuracao.cw/4-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('503', '4', '2018-04-27 17:29:28', '2018-04-27 15:29:28', '', 'Weijtenburg2', '', 'inherit', 'open', 'closed', '', 'weijtenburg2', '', '', '2018-04-27 17:29:31', '2018-04-27 15:29:31', '', '4', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Weijtenburg2.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('504', '4', '2018-04-27 17:32:15', '2018-04-27 15:32:15', 'Tot de komst van de West-Indische Compagnie in 1634 werden de Benedenwindse Eilanden bewoond door  Caquetio, die na 1499 werden bestuurd door Spanjaarden. Johan van Walbeeck stuurde alle Spanjaarden en een groot gedeelte van de Caiquetio naar het vasteland. Daardoor raakte Curaçao vrijwel ontvolkt. De komst van de WIC zorgt ervoor dat de bevolking in de eerste Nederlandse jaren voornamelijk uit Europese mannen bestaat. Dat leidt tot een nogal woeste samenleving, waar de dominee regelmatig over klaagt. De opeenvolgende Directeuren van de WIC vragen de WIC regelmatig om ‘nette’ vrouwen te sturen, maar er is nog weinig aantrekkelijks voor deze vrouwen om naar Curaçao te komen. Pas als Peter Stuyvesant en zijn opvolger Mathias Beck het Directeurschap op zich nemen rond 1645, let men meer op de leefomstandigheden op de eilanden. Vooral de zorgelijke voedselsituatie krijgt aandacht: de WIC is een bedrijf dat winst moet maken, en voedsel importeren is een kostbare zaak. Daarom nodigt Stuyvesant tijdens zijn bewind Sefardische joden, die oorspronkelijk uit Spanje en Portugal vanwege de inquisitie naar Nederland waren gevlucht voor de Inquisitie, uit om plantages te starten op de eilanden om lokaal voedsel te produceren. Ook verandert de manier waarop de Compagnie Curaçao wil gebruiken: was eerst de Kaapvaart een belangrijk argument om Curaçao  in bezit te nemen, in de praktijk blijkt dat die te weinig oplevert. Maar, door de in Brazilië opgedane kennis over de Transatlantische Slavenhandel realiseert de WIC zich dat Curaçao ideaal is als regionale slavenmarkt. Dit leidt uiteindelijk tot vier groepen bewoners op het eiland: de overgebleven Caiquetio, de Europeanen, de Sefardische Joden en de tot slaaf gemaakte Afrikanen vormen vanaf de tweede helft van de zeventiende eeuw de bevolking. Deze samenleving ontwikkelt zich tot een ‘gesegmenteerde’ maatschappij. Een segment is een groep mensen die daartoe behoren door geboorte, afkomst, huidskleur en geloof, waarbij het wisselen van segment vrijwel onmogelijk is. Tevens hebben de leden van sommige segmenten meer rechten dan anderen. De indeling loopt van de hoge blanke protestant, zoals de kooplieden en hoge WIC-ambtenaren met veel rechten tot de tot slaaf gemaakt Afrikanen die geen enkel recht hebben. Daartussen bewegen zich de andere groepen, zoals de Sefardische Joden, lage blanke protestanten en de kleurlingen, de laatste groep het gevolg van gemengde relaties.', '4. Nieuwe bewoners in de zeventiende eeuw', '', 'inherit', 'closed', 'closed', '', '4-revision-v1', '', '', '2018-04-27 17:32:15', '2018-04-27 15:32:15', '', '4', 'https://canoncuracao.cw/4-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('505', '4', '2018-04-27 17:37:25', '2018-04-27 15:37:25', 'Tot de komst van de West-Indische Compagnie in 1634 werden de Benedenwindse Eilanden bewoond door  Caquetio, die na 1499 werden bestuurd door Spanjaarden. Johan van Walbeeck stuurde alle Spanjaarden en een groot gedeelte van de Caiquetio naar het vasteland. Daardoor raakte Curaçao vrijwel ontvolkt. De komst van de WIC zorgt ervoor dat de bevolking in de eerste Nederlandse jaren voornamelijk uit Europese mannen bestaat. Dat leidt tot een nogal woeste samenleving, waar de dominee regelmatig over klaagt. De opeenvolgende Directeuren van de WIC vragen de WIC regelmatig om ‘nette’ vrouwen te sturen, maar er is nog weinig aantrekkelijks voor deze vrouwen om naar Curaçao te komen. Pas als Peter Stuyvesant en zijn opvolger Mathias Beck het Directeurschap op zich nemen rond 1645, let men meer op de leefomstandigheden op de eilanden. Vooral de zorgelijke voedselsituatie krijgt aandacht: de WIC is een bedrijf dat winst moet maken, en voedsel importeren is een kostbare zaak. Daarom nodigt Stuyvesant tijdens zijn bewind Sefardische joden, die oorspronkelijk uit Spanje en Portugal vanwege de inquisitie naar Nederland waren gevlucht voor de Inquisitie, uit om plantages te starten op de eilanden om lokaal voedsel te produceren. Ook verandert de manier waarop de Compagnie Curaçao wil gebruiken: was eerst de Kaapvaart een belangrijk argument om Curaçao  in bezit te nemen, in de praktijk blijkt dat die te weinig oplevert. Maar, door de in Brazilië opgedane kennis over de Transatlantische Slavenhandel realiseert de WIC zich dat Curaçao ideaal is als regionale slavenmarkt. Dit leidt uiteindelijk tot vier groepen bewoners op het eiland: de overgebleven Caiquetio, de Europeanen, de Sefardische Joden en de tot slaaf gemaakte Afrikanen vormen vanaf de tweede helft van de zeventiende eeuw de bevolking. Deze samenleving ontwikkelt zich tot een ‘gesegmenteerde’ maatschappij. Een segment is een groep mensen die daartoe behoren door geboorte, afkomst, huidskleur en geloof, waarbij het wisselen van segment vrijwel onmogelijk is. Tevens hebben de leden van sommige segmenten meer rechten dan anderen. De indeling loopt van de hoge blanke protestant, zoals de kooplieden en hoge WIC-ambtenaren met veel rechten tot de tot slaaf gemaakt Afrikanen die geen enkel recht hebben. Daartussen bewegen zich de andere groepen, zoals de Sefardische Joden, lage blanke protestanten en de kleurlingen, de laatste groep het gevolg van gemengde relaties.', '4. Nieuwe bewoners in de zeventiende eeuw', '', 'inherit', 'closed', 'closed', '', '4-revision-v1', '', '', '2018-04-27 17:37:25', '2018-04-27 15:37:25', '', '4', 'https://canoncuracao.cw/4-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('506', '4', '2018-04-27 17:39:53', '2018-04-27 15:39:53', '', 'H1 9 indians', '', 'inherit', 'open', 'closed', '', 'h1-9-indians', '', '', '2018-04-27 17:39:57', '2018-04-27 15:39:57', '', '8', 'https://canoncuracao.cw/wp-content/uploads/2017/05/H1-9-indians.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('507', '4', '2018-04-27 17:40:07', '2018-04-27 15:40:07', 'De allervroegste aanwijzingen voor de aanwezigheid van mensen op Curaçao dateert van ongeveer 3400 voor Christus. Rond deze tijd komen indianen van het vasteland van Venezuela en Colombia per kano richting Curaçao (en later ook naar Aruba en Bonaire). Archeologische resten uit deze vroege (pre-ceramische of Archaïsche) periode vinden we terug bij onder andere Rooi Rincon, de Sint Jorisbaai en Seru Boca. Deze indianen leefden voornamelijk van schelpdieren. Sporen van hun aanwezigheid we dan ook in groten getale terug in de vorm van zogenaamde shell middens (schelphopen). Hierin vinden we ook hun werktuigen van schelp, steen en koraal terug. Ze maakten zelf geen aardewerk en zullen bijvoorbeeld kalebassen gebruikt hebben als schalen. Behalve schelpdieren zullen ze ook vruchten verzameld hebben.\r\n\r\nHoewel onduidelijk is of deze indianen daadwerkelijk op Curaçao hebben gewoond of alleen in bepaalde seizoenen langskwamen, is het vrijwel zeker dat rond 2000 voor Christus echt sprake is van bewoning op Curaçao. De oudste menselijke resten die zijn teruggevonden aan de voet van de Sint Michielsberg (circa 2000-1650 voor Christus), vormen hiervoor een aanwijzing. Het ligt voor de hand dat de verwanten van deze overledenen in de directe omgeving hebben gewoond, aangezien het gebruikelijk was om de overledenen binnen de nederzetting en zelfs binnen huizen te begraven.\r\nEr zijn aanwijzingen dat rond 1000 voor Christus onversierd aardewerk wordt gebruikt. Kleine fragmenten hiervan zijn in kleine hoeveelheden bij het Spaanse Water en de Vlakte van Hato aangetroffen. Het is mogelijk dat dit aardewerk van het vasteland is meegenomen. Vermoedelijk worden vanaf deze periode en mogelijk al eerder, rotstekeningen aangebracht op kalkstenen rotswanden en losse rotsblokken (bijvoorbeeld Savonet).\r\n\r\nDe ceramische periode begint op Curaçao rond 1000 na Christus met grote nederzettingen zoals bijvoorbeeld De Savaan, San Juan en Santa Cruz. Hier vinden we resten terug van bewoning in de vorm van paalgaten, haardplaatsen en graven. Deze Caquetio indianen maakten ‘Dabajuroid’ aardewerk. Dit is te herkennen aan de zwarte, bruine, rode en witte versiering door middel van voornamelijk lijnen en stippen. Soms werden op het aardewerk ook dierenkoppen afgebeeld. Ook de Caquetio hebben shell middens achtergelaten, maar met daarin een grote hoeveelheid aardewerk, sieraden, bijlen, maalstenen, en andere werktuigen van steen, schelp, koraal en dierlijk bot. De taal die de Caquetio spraken is waarschijnlijk een variant van de Arawak taalfamilie geweest. Naast schelpdieren zullen de Caquetio ook maniok, maïs en fruit gegeten hebben dat ze verbouwden in tuinen. Ze stonden bij de Spanjaarden bekend als goede landbouwers en kanovaarders. De aanwezigheid van maïs en maniok blijkt uit resten van vuursteen voor het raspen van maniok en maalstenen voor het bewerken van maïs.', '1. De oorspronkelijke bewoners', '', 'inherit', 'closed', 'closed', '', '8-revision-v1', '', '', '2018-04-27 17:40:07', '2018-04-27 15:40:07', '', '8', 'https://canoncuracao.cw/8-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('509', '4', '2018-04-27 17:43:31', '2018-04-27 15:43:31', 'Tot de komst van de West-Indische Compagnie in 1634 werden de Benedenwindse Eilanden bewoond door  Caquetio, die na 1499 werden bestuurd door Spanjaarden. Johan van Walbeeck stuurde alle Spanjaarden en een groot gedeelte van de Caiquetio naar het vasteland. Daardoor raakte Curaçao vrijwel ontvolkt.\r\n\r\nDe komst van de WIC zorgt ervoor dat de bevolking in de eerste Nederlandse jaren voornamelijk uit Europese mannen bestaat. Dat leidt tot een nogal woeste samenleving, waar de dominee regelmatig over klaagt. De opeenvolgende Directeuren van de WIC vragen de WIC regelmatig om ‘nette’ vrouwen te sturen, maar er is nog weinig aantrekkelijks voor deze vrouwen om naar Curaçao te komen. Pas als Peter Stuyvesant en zijn opvolger Mathias Beck het Directeurschap op zich nemen rond 1645, let men meer op de leefomstandigheden op de eilanden.\r\n\r\nVooral de zorgelijke voedselsituatie krijgt aandacht: de WIC is een bedrijf dat winst moet maken, en voedsel importeren is een kostbare zaak. Daarom nodigt Stuyvesant tijdens zijn bewind Sefardische joden, die oorspronkelijk uit Spanje en Portugal vanwege de inquisitie naar Nederland waren gevlucht voor de Inquisitie, uit om plantages te starten op de eilanden om lokaal voedsel te produceren. Ook verandert de manier waarop de Compagnie Curaçao wil gebruiken: was eerst de Kaapvaart een belangrijk argument om Curaçao  in bezit te nemen, in de praktijk blijkt dat die te weinig oplevert. Maar, door de in Brazilië opgedane kennis over de Transatlantische Slavenhandel realiseert de WIC zich dat Curaçao ideaal is als regionale slavenmarkt.\r\n\r\nDit leidt uiteindelijk tot vier groepen bewoners op het eiland: de overgebleven Caiquetio, de Europeanen, de Sefardische Joden en de tot slaaf gemaakte Afrikanen vormen vanaf de tweede helft van de zeventiende eeuw de bevolking. Deze samenleving ontwikkelt zich tot een ‘gesegmenteerde’ maatschappij. Een segment is een groep mensen die daartoe behoren door geboorte, afkomst, huidskleur en geloof, waarbij het wisselen van segment vrijwel onmogelijk is. Tevens hebben de leden van sommige segmenten meer rechten dan anderen.\r\n\r\nDe indeling loopt van de hoge blanke protestant, zoals de kooplieden en hoge WIC-ambtenaren met veel rechten tot de tot slaaf gemaakt Afrikanen die geen enkel recht hebben. Daartussen bewegen zich de andere groepen, zoals de Sefardische Joden, lage blanke protestanten en de kleurlingen, de laatste groep het gevolg van gemengde relaties.', '4. Nieuwe bewoners in de zeventiende eeuw', '', 'inherit', 'closed', 'closed', '', '4-revision-v1', '', '', '2018-04-27 17:43:31', '2018-04-27 15:43:31', '', '4', 'https://canoncuracao.cw/4-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('510', '4', '2018-04-27 17:54:42', '2018-04-27 15:54:42', '', 'H2 7 slaven transport', '', 'inherit', 'open', 'closed', '', 'h2-7-slaven-transport', '', '', '2018-04-27 17:54:45', '2018-04-27 15:54:45', '', '14', 'https://canoncuracao.cw/wp-content/uploads/2017/05/H2-7-slaven-transport.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('511', '4', '2018-04-27 17:55:11', '2018-04-27 15:55:11', '', '07. Landhuis Slavenwoningen-1', '', 'inherit', 'open', 'closed', '', '07-landhuis-slavenwoningen-1', '', '', '2018-04-27 17:55:18', '2018-04-27 15:55:18', '', '14', 'https://canoncuracao.cw/wp-content/uploads/2017/05/07.-Landhuis-Slavenwoningen-1.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('512', '4', '2018-04-27 17:57:33', '2018-04-27 15:57:33', '<p class=\"p1\"><span class=\"s1\">Om in de nieuwe koloniën zoveel mogelijk goud en zilver te ontginnen en landbouwproducten voor de export te verbouwen waren veel arbeidskrachten nodig en werden ruim 11 miljoen tot slaaf gemaakte Afrikanen, geïmporteerd.<span class=\"Apple-converted-space\">  </span>Aan de kusten van Afrika werden handelsposten gebouwd voor deze Trans Atlantische Slavenhandel en de vraag naar menselijk koopwaar werd zo groot dat grote delen van West Afrika ontvolkt raakten door rooftochten en oorlogen. </span></p>\r\n<p class=\"p1\"><span class=\"s1\">Curaçao werd een belangrijk centrum voor de slavenhandel door de WIC, welke van 1662 tot 1713 het monopolie voor de levering aan de Spaanse gebieden had. De meeste slaven werden doorverkocht en degenen die achterbleven moesten alle soorten werk doen. In de stad en haven moesten de slaven onder meer goederen in- en uitladen, helpen op de werven en bij bouwwerkzaamheden, op de schepen als matrozen werken en in de huishoudingen dienen.<span class=\"Apple-converted-space\"> </span></span></p>\r\n<p class=\"p1\"><span class=\"s1\">Op de plantages werd onderscheid gemaakt tussen de huisslaven en veldslaven. De huisslaven waren vooral bedienden en had een iets betere positie. De veldslaven, de meerderheid, moesten al het zware werk doen zoals het schoonmaken van terreinen en deze bewerken met de <i>chapi</i> en oogsten. Zij moesten ook zorgen voor het vee, en scheidingsmuren bouwen en diepe putten graven</span><span class=\"s2\">. </span></p>\r\n<p class=\"p1\"><span class=\"s1\">De <i>shon </i>of zijn <i>fitó</i> bepaalde welke werkzaamheden uitgevoerd moesten worden onder leiding van een opzichter, de <i>bomba</i>, meestal zelf een slaaf</span><span class=\"s2\">.</span><span class=\"s1\"> De gewassen die het meest werden verbouwd waren maïs, bonen en pompoenen</span><span class=\"s2\">,</span><span class=\"s1\"> maar het belangrijkst was wel de extensieve veehouderij. Iedere plantage had een schaduwrijk hofje waar vruchten en groenten werden verbouwd met water uit putten. Een tussenpositie namen de ambachtsslaven in; onder meer timmerlieden, metselaars, kleermakers en smeden. Zij werden ook vaak verhuurd voor werkzaamheden op andere plantages of in de stad en hierdoor hadden zij meer bewegingsvrijheid. Zij moesten altijd een deel van hun opbrengst aan hun meester geven, maar konden zich ook vrij kopen door te sparen van wat zij zelf mochten houden. De ambachtslieden konden echter ook voor ander werk worden ingezet wanneer nodig. </span></p>\r\n<p class=\"p1\"><span class=\"s1\">Door de droogte en algemene economische malaise hadden de slaven vaak gebrek aan alles, vooral voedsel. De slaaf werd als inferieur beschouwd en moest zo lang mogelijk in een situatie van onderworpenheid en onwetendheid blijven. Hij was nagenoeg rechteloos en eigendom van zijn meester, de <i>shon</i>. Zijn leven stond geheel in het teken van dienstbaarheid en werd volledig bepaald door de meester. Hij had ook geen eigen familienaam en mocht niet trouwen.</span></p>', '5. De slavenhandel en slaverij', '', 'inherit', 'closed', 'closed', '', '14-revision-v1', '', '', '2018-04-27 17:57:33', '2018-04-27 15:57:33', '', '14', 'https://canoncuracao.cw/14-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('513', '4', '2018-04-27 17:59:21', '2018-04-27 15:59:21', '<p class=\"p1\"><span class=\"s1\">Om in de nieuwe koloniën zoveel mogelijk goud en zilver te ontginnen en landbouwproducten voor de export te verbouwen waren veel arbeidskrachten nodig en werden ruim 11 miljoen tot slaaf gemaakte Afrikanen, geïmporteerd.<span class=\"Apple-converted-space\">  </span>Aan de kusten van Afrika werden handelsposten gebouwd voor deze Trans Atlantische Slavenhandel en de vraag naar menselijk koopwaar werd zo groot dat grote delen van West Afrika ontvolkt raakten door rooftochten en oorlogen. </span></p>\r\n<p class=\"p1\"><span class=\"s1\">Curaçao werd een belangrijk centrum voor de slavenhandel door de WIC, welke van 1662 tot 1713 het monopolie voor de levering aan de Spaanse gebieden had. De meeste slaven werden doorverkocht en degenen die achterbleven moesten alle soorten werk doen. In de stad en haven moesten de slaven onder meer goederen in- en uitladen, helpen op de werven en bij bouwwerkzaamheden, op de schepen als matrozen werken en in de huishoudingen dienen.<span class=\"Apple-converted-space\"> </span></span></p>\r\n<p class=\"p1\"><span class=\"s1\">Op de plantages werd onderscheid gemaakt tussen de huisslaven en veldslaven. De huisslaven waren vooral bedienden en had een iets betere positie. De veldslaven, de meerderheid, moesten al het zware werk doen zoals het schoonmaken van terreinen en deze bewerken met de <i>chapi</i> en oogsten. Zij moesten ook zorgen voor het vee, en scheidingsmuren bouwen en diepe putten graven</span><span class=\"s2\">. </span></p>\r\n<p class=\"p1\"><span class=\"s1\">De <i>shon </i>of zijn <i>fitó</i> bepaalde welke werkzaamheden uitgevoerd moesten worden onder leiding van een opzichter, de <i>bomba</i>, meestal zelf een slaaf</span><span class=\"s2\">.</span><span class=\"s1\"> De gewassen die het meest werden verbouwd waren maïs, bonen en pompoenen</span><span class=\"s2\">,</span><span class=\"s1\"> maar het belangrijkst was wel de extensieve veehouderij. Iedere plantage had een schaduwrijk hofje waar vruchten en groenten werden verbouwd met water uit putten. Een tussenpositie namen de ambachtsslaven in; onder meer timmerlieden, metselaars, kleermakers en smeden. Zij werden ook vaak verhuurd voor werkzaamheden op andere plantages of in de stad en hierdoor hadden zij meer bewegingsvrijheid. Zij moesten altijd een deel van hun opbrengst aan hun meester geven, maar konden zich ook vrij kopen door te sparen van wat zij zelf mochten houden. De ambachtslieden konden echter ook voor ander werk worden ingezet wanneer nodig. </span></p>\r\n<p class=\"p1\"><span class=\"s1\">Door de droogte en algemene economische malaise hadden de slaven vaak gebrek aan alles, vooral voedsel. De slaaf werd als inferieur beschouwd en moest zo lang mogelijk in een situatie van onderworpenheid en onwetendheid blijven. Hij was nagenoeg rechteloos en eigendom van zijn meester, de <i>shon</i>. Zijn leven stond geheel in het teken van dienstbaarheid en werd volledig bepaald door de meester. Hij had ook geen eigen familienaam en mocht niet trouwen.</span></p>', '5. De slavenhandel en slaverij', '', 'inherit', 'closed', 'closed', '', '14-revision-v1', '', '', '2018-04-27 17:59:21', '2018-04-27 15:59:21', '', '14', 'https://canoncuracao.cw/14-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('515', '4', '2018-04-27 18:03:40', '2018-04-27 16:03:40', 'Er waren veel arbeidskrachten nodig  in de nieuwe koloniën in Noord- en Zuid-Amerika en het Caribisch gebied  voor het werk in de goud- en zilvermijnen en om landbouwproducten voor de export  te verbouwen en om die reden werden ruim 11 miljoen tot slaaf gemaakte Afrikanen geïmporteerd.  Aan de kusten van Afrika werden handelsposten gebouwd voor deze trans-Atlantische slavenhandel en de vraag naar menselijke koopwaar werd daar zo groot dat grote delen van West Afrika ontvolkt raakten. Curaçao werd een belangrijk centrum voor de slavenhandel door de WIC, welke van 1662 tot 1713 het monopolie voor de levering van slaven aan de Spaanse gebieden had, het zogenaamde ‘asiento’. In 1713 verloor de WIC het ‘asiento’ aan Engeland bij de Vrede van Utrecht. Daardoor verloor Curaçao aan belang als handelscentrum voor slaven, hoewel het eiland, toen ook al een smokkelbolwerk, nog steeds een rol bleef spelen in de illegale slavenhandel.\r\n\r\nDe meeste slaven werden doorverkocht naar andere gebieden. Degenen die op Curaçao achterbleven moesten alle soorten werk doen. In de stad en haven moesten de slaven onder meer goederen in- en uitladen, helpen op de werven en bij bouwwerkzaamheden, op de schepen als matrozen werken en in de huishouding werken.  Op de plantages werd onderscheid gemaakt tussen de ‘huisslaven’ en de ‘veldslaven’. De huisslaven waren vooral bedienden en hadden een iets betere positie. De veldslaven, de meerderheid, moesten al het zware werk doen zoals het schoonmaken van terreinen en deze bewerken met de ’<em>chapi’ </em>(hak, schoffel) en oogsten. Zij moesten ook zorgen voor het vee, scheidingsmuren bouwen tussen de plantages en diepe putten graven. De <em>shon </em>of zijn <em>fitó</em> (bedrijfsleider) bepaalde welke werkzaamheden uitgevoerd moesten worden onder leiding van een opzichter, de <em>bomba</em>,die  meestal zelf ook slaaf was. De gewassen die het meest werden verbouwd waren kleine maïs, bonen en pompoenen, en iedere plantage had een schaduwrijk hofje waar vruchten en groenten werden verbouwd met water uit putten. maar het belangrijkste was wel de extensieve veehouderij.\r\n\r\nEr was nog een derde categorie slaven, de ‘ambachtsslaven’. Dit waren bijvoorbeeld  timmerlieden, metselaars, kleermakers en smeden en ze namen een tussenpositie in. Zij werden  vaak verhuurd voor werkzaamheden op andere plantages of in de stad en hierdoor hadden zij meer bewegingsvrijheid. Zij moesten wel altijd een deel van hun opbrengst aan hun meester geven, maar ze konden zich ook vrij kopen door te sparen van wat zij zelf mochten houden. De ambachtslieden konden echter ook voor ander werk worden ingezet wanneer dat nodig werd geacht.\r\n\r\nDoor de veelvoorkomende droogte en algemene economische malaise hadden de slaven vaak gebrek aan alles, vooral voedsel. De slaaf werd als inferieur beschouwd en moest zo lang mogelijk in een situatie van onderworpenheid en onwetendheid blijven. Hij was nagenoeg rechteloos en eigendom van zijn meester, de <em>shon</em>. Zijn leven stond geheel in het teken van dienstbaarheid en werd volledig bepaald door de meester. Hij had ook geen eigen familienaam en mocht niet trouwen. In de loop van de tijd werden wel wettelijke regels opgesteld die betere bescherming boden voor de slaven. Ook was het mogelijk dat slaven zichzelf vrij kochten of door hun meester werden vrijgesteld. (manumissie).', '5. De slavenhandel en slaverij', '', 'inherit', 'closed', 'closed', '', '14-revision-v1', '', '', '2018-04-27 18:03:40', '2018-04-27 16:03:40', '', '14', 'https://canoncuracao.cw/14-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('516', '4', '2018-04-27 18:05:21', '2018-04-27 16:05:21', 'De tot slaaf gemaakte Afrikanen hebben zich, waar mogelijk, verzet tegen hun gevangenneming en transport. In het land van bestemming werden zij onder meer tewerkgesteld op plantages, in mijnen en in de woningen van hun nieuwe eigenaren. Zij kregen de status van slaaf, eigendom van degenen die hen gekocht hadden. Zij moesten gehoorzaam zijn en eventueel verzet werd op allerlei mogelijke manieren gebroken. Hierbij werden veelvuldig zware lichamelijke straffen toegepast, ook om hen er steeds op te wijzen dat zij niets anders waren dan het bezit van de meester. Men  probeerde  hen ook geestelijk te breken zodat zij niet al te kritisch en zelfstandig zouden zijn.\r\n\r\nToch kwamen de slaven steeds weer in verzet tegen de mensonterende behandeling, ook op Curaҫao.Dit verzet nam vele vormen aan, bijvoorbeeld door zich ziek voor te doen,  door te weigeren opgedragen taken uit te voeren, door opzettelijk langzaam te werken, door sabotage, zelfmoordpogingen, hongerstaking, weglopen en door gif te doen in het eten van hun eigenaren. Ook werden weleens wapens opgenomen tegen de eigenaren. Er waren georganiseerde slavenopstanden in 1716 te Sint Marie, in 1750 op de plantage Hato, en in 1795 vond de grote slavenopstand onder leiding van Tula plaats.\r\n\r\nOmdat Curaçao klein was en er geen dichte oerwouden, moerassen of hoge bergen waren, konden gevluchte slaven zich niet verbergen en nieuwe, vrije gemeenschappen vormen, zoals dat wel het geval was in bijvoorbeeld Suriname, Colombia, Hispaniola, Dominica en Jamaica. Weggelopen slaven werden meestal vrij snel gepakt en slechts enkelen wisten met grote moeite moeite te overleven in het droge en relatief open Curaçaose landschap. De vele grotten boden soms een goede schuilplaats, maar deze waren ook bekend bij de slaveneigenaren. Om te overleven bleef de’ <em>katibu shimaron’ (</em> de gevluchte slaaf) afhankelijk van de plantages voor voedsel, water, kleding en andere artikelen. Belangrijk was dat hij daarbij hulp kreeg en vooral niet verraden werd. Tijdens de slavenopstand in 1795 bleken er toch een aantal  <em>katibu shimarons</em> te zijn, die al jaren in vrijheid buiten de plantages leefden.\r\n\r\nEr werden ook pogingen ondernomen om met bootjes de kust van Venezuela te bereiken en velen slaagden daar ook in, vooral nadat de Koning van Spanje had besloten om deze mensen niet terug te sturen indien zij de bedoeling hadden om katholiek te worden gedoopt. In Coro, een Venezolaanse stad, relatief gemakkelijk te bereiken vanuit Curaçao, woonde een behoorlijke groep voormalige Curaçcaose slaven. Slaven werkten ook als matrozen aan boord van zeilschepen en kregen, als zij uitzeilden, een vrijbrief zodat zij, in het geval dat hun schip gekaapt werd, niet als slaaf konden worden doorverkocht. Deze vrijbief werd weer ingetrokken zodra zij weer op Curaçao waren, maar sommigen maakten van de gelegenheid gebruik door niet terug te keren naar Curaçao.\r\n\r\nHet slavenverzet zien wij ook terug in verhalen, zoals de bekende Nanzi-verhalen, en liedjes waarin de meester werd bespot  en er afbreuk werd gedaan aan zijn gezag,  waarbij aangespoord werd tot ongehoorzaamheid.', '6. Slavernijverzet', '', 'inherit', 'closed', 'closed', '', '16-revision-v1', '', '', '2018-04-27 18:05:21', '2018-04-27 16:05:21', '', '16', 'https://canoncuracao.cw/16-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('517', '4', '2018-04-27 18:09:34', '2018-04-27 16:09:34', '', 'H3 Register weggelopen slaven1', '', 'inherit', 'open', 'closed', '', 'h3-register-weggelopen-slaven1', '', '', '2018-04-30 22:09:16', '2018-04-30 20:09:16', '', '16', 'https://canoncuracao.cw/wp-content/uploads/2017/05/H3-Register-weggelopen-slaven1.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('518', '4', '2018-04-27 18:09:47', '2018-04-27 16:09:47', '', 'H2 Strafregister', '', 'inherit', 'open', 'closed', '', 'h2-strafregister', '', '', '2018-04-27 18:09:50', '2018-04-27 16:09:50', '', '16', 'https://canoncuracao.cw/wp-content/uploads/2017/05/H2-Strafregister.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('519', '4', '2018-04-27 18:10:46', '2018-04-27 16:10:46', 'De tot slaaf gemaakte Afrikanen hebben zich, waar mogelijk, verzet tegen hun gevangenneming en transport. In het land van bestemming werden zij onder meer tewerkgesteld op plantages, in mijnen en in de woningen van hun nieuwe eigenaren. Zij kregen de status van slaaf, eigendom van degenen die hen gekocht hadden. Zij moesten gehoorzaam zijn en eventueel verzet werd op allerlei mogelijke manieren gebroken. Hierbij werden veelvuldig zware lichamelijke straffen toegepast, ook om hen er steeds op te wijzen dat zij niets anders waren dan het bezit van de meester. Men  probeerde  hen ook geestelijk te breken zodat zij niet al te kritisch en zelfstandig zouden zijn.\r\n\r\nToch kwamen de slaven steeds weer in verzet tegen de mensonterende behandeling, ook op Curaҫao.Dit verzet nam vele vormen aan, bijvoorbeeld door zich ziek voor te doen,  door te weigeren opgedragen taken uit te voeren, door opzettelijk langzaam te werken, door sabotage, zelfmoordpogingen, hongerstaking, weglopen en door gif te doen in het eten van hun eigenaren. Ook werden weleens wapens opgenomen tegen de eigenaren. Er waren georganiseerde slavenopstanden in 1716 te Sint Marie, in 1750 op de plantage Hato, en in 1795 vond de grote slavenopstand onder leiding van Tula plaats.\r\n\r\nOmdat Curaçao klein was en er geen dichte oerwouden, moerassen of hoge bergen waren, konden gevluchte slaven zich niet verbergen en nieuwe, vrije gemeenschappen vormen, zoals dat wel het geval was in bijvoorbeeld Suriname, Colombia, Hispaniola, Dominica en Jamaica. Weggelopen slaven werden meestal vrij snel gepakt en slechts enkelen wisten met grote moeite moeite te overleven in het droge en relatief open Curaçaose landschap. De vele grotten boden soms een goede schuilplaats, maar deze waren ook bekend bij de slaveneigenaren. Om te overleven bleef de’ <em>katibu shimaron’ (</em> de gevluchte slaaf) afhankelijk van de plantages voor voedsel, water, kleding en andere artikelen. Belangrijk was dat hij daarbij hulp kreeg en vooral niet verraden werd. Tijdens de slavenopstand in 1795 bleken er toch een aantal  <em>katibu shimarons</em> te zijn, die al jaren in vrijheid buiten de plantages leefden.\r\n\r\nEr werden ook pogingen ondernomen om met bootjes de kust van Venezuela te bereiken en velen slaagden daar ook in, vooral nadat de Koning van Spanje had besloten om deze mensen niet terug te sturen indien zij de bedoeling hadden om katholiek te worden gedoopt. In Coro, een Venezolaanse stad, relatief gemakkelijk te bereiken vanuit Curaçao, woonde een behoorlijke groep voormalige Curaçcaose slaven. Slaven werkten ook als matrozen aan boord van zeilschepen en kregen, als zij uitzeilden, een vrijbrief zodat zij, in het geval dat hun schip gekaapt werd, niet als slaaf konden worden doorverkocht. Deze vrijbief werd weer ingetrokken zodra zij weer op Curaçao waren, maar sommigen maakten van de gelegenheid gebruik door niet terug te keren naar Curaçao.\r\n\r\nHet slavenverzet zien wij ook terug in verhalen, zoals de bekende Nanzi-verhalen, en liedjes waarin de meester werd bespot  en er afbreuk werd gedaan aan zijn gezag,  waarbij aangespoord werd tot ongehoorzaamheid.', '6. Slavernijverzet', '', 'inherit', 'closed', 'closed', '', '16-revision-v1', '', '', '2018-04-27 18:10:46', '2018-04-27 16:10:46', '', '16', 'https://canoncuracao.cw/16-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('520', '4', '2018-04-27 18:12:17', '2018-04-27 16:12:17', 'De tot slaaf gemaakte Afrikanen hebben zich, waar mogelijk, verzet tegen hun gevangenneming en transport. In het land van bestemming werden zij onder meer tewerkgesteld op plantages, in mijnen en in de woningen van hun nieuwe eigenaren. Zij kregen de status van slaaf, eigendom van degenen die hen gekocht hadden. Zij moesten gehoorzaam zijn en eventueel verzet werd op allerlei mogelijke manieren gebroken. Hierbij werden veelvuldig zware lichamelijke straffen toegepast, ook om hen er steeds op te wijzen dat zij niets anders waren dan het bezit van de meester. Men  probeerde  hen ook geestelijk te breken zodat zij niet al te kritisch en zelfstandig zouden zijn.\r\n\r\nToch kwamen de slaven steeds weer in verzet tegen de mensonterende behandeling, ook op Curaҫao.Dit verzet nam vele vormen aan, bijvoorbeeld door zich ziek voor te doen,  door te weigeren opgedragen taken uit te voeren, door opzettelijk langzaam te werken, door sabotage, zelfmoordpogingen, hongerstaking, weglopen en door gif te doen in het eten van hun eigenaren. Ook werden weleens wapens opgenomen tegen de eigenaren. Er waren georganiseerde slavenopstanden in 1716 te Sint Marie, in 1750 op de plantage Hato, en in 1795 vond de grote slavenopstand onder leiding van Tula plaats.\r\n\r\nOmdat Curaçao klein was en er geen dichte oerwouden, moerassen of hoge bergen waren, konden gevluchte slaven zich niet verbergen en nieuwe, vrije gemeenschappen vormen, zoals dat wel het geval was in bijvoorbeeld Suriname, Colombia, Hispaniola, Dominica en Jamaica. Weggelopen slaven werden meestal vrij snel gepakt en slechts enkelen wisten met grote moeite moeite te overleven in het droge en relatief open Curaçaose landschap. De vele grotten boden soms een goede schuilplaats, maar deze waren ook bekend bij de slaveneigenaren. Om te overleven bleef de’ <em>katibu shimaron’ (</em> de gevluchte slaaf) afhankelijk van de plantages voor voedsel, water, kleding en andere artikelen. Belangrijk was dat hij daarbij hulp kreeg en vooral niet verraden werd. Tijdens de slavenopstand in 1795 bleken er toch een aantal  <em>katibu shimarons</em> te zijn, die al jaren in vrijheid buiten de plantages leefden.\r\n\r\nEr werden ook pogingen ondernomen om met bootjes de kust van Venezuela te bereiken en velen slaagden daar ook in, vooral nadat de Koning van Spanje had besloten om deze mensen niet terug te sturen indien zij de bedoeling hadden om katholiek te worden gedoopt. In Coro, een Venezolaanse stad, relatief gemakkelijk te bereiken vanuit Curaçao, woonde een behoorlijke groep voormalige Curaçcaose slaven. Slaven werkten ook als matrozen aan boord van zeilschepen en kregen, als zij uitzeilden, een vrijbrief zodat zij, in het geval dat hun schip gekaapt werd, niet als slaaf konden worden doorverkocht. Deze vrijbief werd weer ingetrokken zodra zij weer op Curaçao waren, maar sommigen maakten van de gelegenheid gebruik door niet terug te keren naar Curaçao.\r\n\r\nHet slavenverzet zien wij ook terug in verhalen, zoals de bekende Nanzi-verhalen, en liedjes waarin de meester werd bespot  en er afbreuk werd gedaan aan zijn gezag,  waarbij aangespoord werd tot ongehoorzaamheid.', '6. Slavernijverzet', '', 'inherit', 'closed', 'closed', '', '16-revision-v1', '', '', '2018-04-27 18:12:17', '2018-04-27 16:12:17', '', '16', 'https://canoncuracao.cw/16-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('521', '4', '2018-04-27 18:14:48', '2018-04-27 16:14:48', 'De tot slaaf gemaakte Afrikanen hebben zich, waar mogelijk, verzet tegen hun gevangenneming en transport. In het land van bestemming werden zij onder meer tewerkgesteld op plantages, in mijnen en in de woningen van hun nieuwe eigenaren. Zij kregen de status van slaaf, eigendom van degenen die hen gekocht hadden. Zij moesten gehoorzaam zijn en eventueel verzet werd op allerlei mogelijke manieren gebroken. Hierbij werden veelvuldig zware lichamelijke straffen toegepast, ook om hen er steeds op te wijzen dat zij niets anders waren dan het bezit van de meester. Men  probeerde  hen ook geestelijk te breken zodat zij niet al te kritisch en zelfstandig zouden zijn.\r\n\r\nToch kwamen de slaven steeds weer in verzet tegen de mensonterende behandeling, ook op Curaҫao.Dit verzet nam vele vormen aan, bijvoorbeeld door zich ziek voor te doen,  door te weigeren opgedragen taken uit te voeren, door opzettelijk langzaam te werken, door sabotage, zelfmoordpogingen, hongerstaking, weglopen en door gif te doen in het eten van hun eigenaren. Ook werden weleens wapens opgenomen tegen de eigenaren. Er waren georganiseerde slavenopstanden in 1716 te Sint Marie, in 1750 op de plantage Hato, en in 1795 vond de grote slavenopstand onder leiding van Tula plaats.\r\n\r\nOmdat Curaçao klein was en er geen dichte oerwouden, moerassen of hoge bergen waren, konden gevluchte slaven zich niet verbergen en nieuwe, vrije gemeenschappen vormen, zoals dat wel het geval was in bijvoorbeeld Suriname, Colombia, Hispaniola, Dominica en Jamaica. Weggelopen slaven werden meestal vrij snel gepakt en slechts enkelen wisten met grote moeite moeite te overleven in het droge en relatief open Curaçaose landschap. De vele grotten boden soms een goede schuilplaats, maar deze waren ook bekend bij de slaveneigenaren. Om te overleven bleef de’ <em>katibu shimaron’ (</em> de gevluchte slaaf) afhankelijk van de plantages voor voedsel, water, kleding en andere artikelen. Belangrijk was dat hij daarbij hulp kreeg en vooral niet verraden werd. Tijdens de slavenopstand in 1795 bleken er toch een aantal  <em>katibu shimarons</em> te zijn, die al jaren in vrijheid buiten de plantages leefden.\r\n\r\nEr werden ook pogingen ondernomen om met bootjes de kust van Venezuela te bereiken en velen slaagden daar ook in, vooral nadat de Koning van Spanje had besloten om deze mensen niet terug te sturen indien zij de bedoeling hadden om katholiek te worden gedoopt. In Coro, een Venezolaanse stad, relatief gemakkelijk te bereiken vanuit Curaçao, woonde een behoorlijke groep voormalige Curaçcaose slaven. Slaven werkten ook als matrozen aan boord van zeilschepen en kregen, als zij uitzeilden, een vrijbrief zodat zij, in het geval dat hun schip gekaapt werd, niet als slaaf konden worden doorverkocht. Deze vrijbief werd weer ingetrokken zodra zij weer op Curaçao waren, maar sommigen maakten van de gelegenheid gebruik door niet terug te keren naar Curaçao.\r\n\r\nHet slavenverzet zien wij ook terug in verhalen, zoals de bekende Nanzi-verhalen, en liedjes waarin de meester werd bespot  en er afbreuk werd gedaan aan zijn gezag,  waarbij aangespoord werd tot ongehoorzaamheid.', '6. Slavernijverzet', '', 'inherit', 'closed', 'closed', '', '16-revision-v1', '', '', '2018-04-27 18:14:48', '2018-04-27 16:14:48', '', '16', 'https://canoncuracao.cw/16-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('522', '4', '2018-04-27 18:16:26', '2018-04-27 16:16:26', 'Op 17 augustus 1795 weigerden de slaven, onder aanvoering van Tula, op de plantage Knip om aan het werk te gaan. De opstand  strekte zich al snel uit over heel Bandabou (het westelijk gedeelte van het eiland) en er waren ook  sympathisanten op de rest van het eiland. Binnen een paar dagen kwamen nagenoeg 2000 slaven in beweging en hun leiders, waarvan Tula de belangrijkste was, stelden duidelijke eisen. De opstand was een bewuste en geplande actie.\r\n\r\nDe omstandigheden waarin de bevolking moest leven verslechterden aan het eind van de 18e eeuw sterk en vooral de slaven leden veel gebrek. Tegelijkertijd waren er grote politieke spanningen binnen de plaatselijke blanke burgerij, die samenhingen met gebeurtenissen in Nederland,  die op straat uitgevochten werden. Aan de ene kant stonden de ‘<em>oranjegezinden’,ook </em>wel de<em> ‘prinsgezinden’ </em>genoemd, die als conservatieven de bestaande toestand wilden handhaven en aan de andere kant stonden  de’ <em>patriotten’</em> die republikeins gezind waren en veranderingen in de geest van vrijheid, gelijkheid en broederschap nastreefden.\r\n\r\n&nbsp;\r\n\r\nDeze nieuwe ideeën hadden geleid tot de Franse Revolutie (1789) en in de nasleep daarvan tot de grote slavenopstanden op St Domingue (het huidige Haiti). Deze ontwikkelingen vergrootten de spanningen op Curaçao en veroorzaakten angst onder de slaveneigenaren, die hun slaven om die reden juist steeds harder begonnen te onderdrukken.\r\n\r\nFeit was dat Nederland in januari 1795 bezet werd door Frankrijk en dat in Frankrijk op dat moment de slavernij was afgeschaft. In de ogen van de slaven stond Curaçao op dat moment dus feitelijk onder Frans gezag en diende er daarom een einde te komen aan de slavernij. Tula bleek goed op de hoogte te zijn van deze ontwikkelingen, hetgeen erop wijst dat hij over goede contacten beschikte. Zeer waarschijnlijk bestond er een  band tussen hem en  bepaalde patriotten op het eiland, waaronder de plantage-eigenaresse Johanna Lesire. Zij stond toe dat opstandelingen zich verscholen in haar huizen in Scharloo en Kwartier en haar plantage Porto Marie werd het hoofdkwartier van Tula. Uit deze contacten blijkt dat Tula geen geïsoleerd bestaan leidde op Bandabou. Hij had waarschijnlijk meer bewegingsvrijheid dan andere slaven. Nadat Tula op 19 september 1795 werd gearresteerd, nadat hij was verraden door een andere slaaf, werd hij langdurig gemarteld en verhoord, omdat de autoriteiten meer wilden weten over de betrokkenheid van anderen bij de opstand.\r\n\r\nTula bezat een behoorlijke kennis van het katholicisme en kon een lang gesprek voeren met pater Schinck die hem probeerde over te halen de strijd te staken. Zijn woorden zijn toen opgetekend: “Heer pater, zijn wij niet allen uit Adam en Eva voortgekomen?\". Hij was vastberaden, getuige zijn opstelling tegenover kapitein Van Westerholt, die de slavenopstand uiteindelijk neersloeg, aan wie hij liet weten: \"wij zijn hier om te overwinnen of te sterven\".\r\n\r\nHij was een leider met een duidelijke visie, hij kon grote groepen slaven mobiliseren en had charisma en overwicht. In 2010 werd hij officieel erkend als nationale held en werden hij en zijn volgelingen gerehabiliteerd.', '7. Tula', '', 'inherit', 'closed', 'closed', '', '19-revision-v1', '', '', '2018-04-27 18:16:26', '2018-04-27 16:16:26', '', '19', 'https://canoncuracao.cw/19-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('523', '4', '2018-04-27 18:21:47', '2018-04-27 16:21:47', 'Op 17 augustus 1795 weigerden de slaven, onder aanvoering van Tula, op de plantage Knip om aan het werk te gaan. De opstand  strekte zich al snel uit over heel Bandabou (het westelijk gedeelte van het eiland) en er waren ook  sympathisanten op de rest van het eiland. Binnen een paar dagen kwamen nagenoeg 2000 slaven in beweging en hun leiders, waarvan Tula de belangrijkste was, stelden duidelijke eisen. De opstand was een bewuste en geplande actie.\r\n\r\nDe omstandigheden waarin de bevolking moest leven verslechterden aan het eind van de 18e eeuw sterk en vooral de slaven leden veel gebrek. Tegelijkertijd waren er grote politieke spanningen binnen de plaatselijke blanke burgerij, die samenhingen met gebeurtenissen in Nederland,  die op straat uitgevochten werden. Aan de ene kant stonden de ‘<em>oranjegezinden’,ook </em>wel de<em> ‘prinsgezinden’ </em>genoemd, die als conservatieven de bestaande toestand wilden handhaven en aan de andere kant stonden  de’ <em>patriotten’</em> die republikeins gezind waren en veranderingen in de geest van vrijheid, gelijkheid en broederschap nastreefden.\r\n\r\n&nbsp;\r\n\r\nDeze nieuwe ideeën hadden geleid tot de Franse Revolutie (1789) en in de nasleep daarvan tot de grote slavenopstanden op St Domingue (het huidige Haiti). Deze ontwikkelingen vergrootten de spanningen op Curaçao en veroorzaakten angst onder de slaveneigenaren, die hun slaven om die reden juist steeds harder begonnen te onderdrukken.\r\n\r\nFeit was dat Nederland in januari 1795 bezet werd door Frankrijk en dat in Frankrijk op dat moment de slavernij was afgeschaft. In de ogen van de slaven stond Curaçao op dat moment dus feitelijk onder Frans gezag en diende er daarom een einde te komen aan de slavernij. Tula bleek goed op de hoogte te zijn van deze ontwikkelingen, hetgeen erop wijst dat hij over goede contacten beschikte. Zeer waarschijnlijk bestond er een  band tussen hem en  bepaalde patriotten op het eiland, waaronder de plantage-eigenaresse Johanna Lesire. Zij stond toe dat opstandelingen zich verscholen in haar huizen in Scharloo en Kwartier en haar plantage Porto Marie werd het hoofdkwartier van Tula. Uit deze contacten blijkt dat Tula geen geïsoleerd bestaan leidde op Bandabou. Hij had waarschijnlijk meer bewegingsvrijheid dan andere slaven. Nadat Tula op 19 september 1795 werd gearresteerd, nadat hij was verraden door een andere slaaf, werd hij langdurig gemarteld en verhoord, omdat de autoriteiten meer wilden weten over de betrokkenheid van anderen bij de opstand.\r\n\r\nTula bezat een behoorlijke kennis van het katholicisme en kon een lang gesprek voeren met pater Schinck die hem probeerde over te halen de strijd te staken. Zijn woorden zijn toen opgetekend: “Heer pater, zijn wij niet allen uit Adam en Eva voortgekomen?\". Hij was vastberaden, getuige zijn opstelling tegenover kapitein Van Westerholt, die de slavenopstand uiteindelijk neersloeg, aan wie hij liet weten: \"wij zijn hier om te overwinnen of te sterven\".\r\n\r\nHij was een leider met een duidelijke visie, hij kon grote groepen slaven mobiliseren en had charisma en overwicht. In 2010 werd hij officieel erkend als nationale held en werden hij en zijn volgelingen gerehabiliteerd.', '7. Tula', '', 'inherit', 'closed', 'closed', '', '19-revision-v1', '', '', '2018-04-27 18:21:47', '2018-04-27 16:21:47', '', '19', 'https://canoncuracao.cw/19-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('524', '4', '2018-04-27 18:22:42', '2018-04-27 16:22:42', 'Op 17 augustus 1795 weigerden de slaven, onder aanvoering van Tula, op de plantage Knip om aan het werk te gaan. De opstand  strekte zich al snel uit over heel Bandabou (het westelijk gedeelte van het eiland) en er waren ook  sympathisanten op de rest van het eiland. Binnen een paar dagen kwamen nagenoeg 2000 slaven in beweging en hun leiders, waarvan Tula de belangrijkste was, stelden duidelijke eisen. De opstand was een bewuste en geplande actie.\r\n\r\nDe omstandigheden waarin de bevolking moest leven verslechterden aan het eind van de 18e eeuw sterk en vooral de slaven leden veel gebrek. Tegelijkertijd waren er grote politieke spanningen binnen de plaatselijke blanke burgerij, die samenhingen met gebeurtenissen in Nederland,  die op straat uitgevochten werden. Aan de ene kant stonden de ‘<em>oranjegezinden’,ook </em>wel de<em> ‘prinsgezinden’ </em>genoemd, die als conservatieven de bestaande toestand wilden handhaven en aan de andere kant stonden  de’ <em>patriotten’</em> die republikeins gezind waren en veranderingen in de geest van vrijheid, gelijkheid en broederschap nastreefden.\r\n\r\n&nbsp;\r\n\r\nDeze nieuwe ideeën hadden geleid tot de Franse Revolutie (1789) en in de nasleep daarvan tot de grote slavenopstanden op St Domingue (het huidige Haiti). Deze ontwikkelingen vergrootten de spanningen op Curaçao en veroorzaakten angst onder de slaveneigenaren, die hun slaven om die reden juist steeds harder begonnen te onderdrukken.\r\n\r\nFeit was dat Nederland in januari 1795 bezet werd door Frankrijk en dat in Frankrijk op dat moment de slavernij was afgeschaft. In de ogen van de slaven stond Curaçao op dat moment dus feitelijk onder Frans gezag en diende er daarom een einde te komen aan de slavernij. Tula bleek goed op de hoogte te zijn van deze ontwikkelingen, hetgeen erop wijst dat hij over goede contacten beschikte. Zeer waarschijnlijk bestond er een  band tussen hem en  bepaalde patriotten op het eiland, waaronder de plantage-eigenaresse Johanna Lesire. Zij stond toe dat opstandelingen zich verscholen in haar huizen in Scharloo en Kwartier en haar plantage Porto Marie werd het hoofdkwartier van Tula. Uit deze contacten blijkt dat Tula geen geïsoleerd bestaan leidde op Bandabou. Hij had waarschijnlijk meer bewegingsvrijheid dan andere slaven. Nadat Tula op 19 september 1795 werd gearresteerd, nadat hij was verraden door een andere slaaf, werd hij langdurig gemarteld en verhoord, omdat de autoriteiten meer wilden weten over de betrokkenheid van anderen bij de opstand.\r\n\r\nTula bezat een behoorlijke kennis van het katholicisme en kon een lang gesprek voeren met pater Schinck die hem probeerde over te halen de strijd te staken. Zijn woorden zijn toen opgetekend: “Heer pater, zijn wij niet allen uit Adam en Eva voortgekomen?\". Hij was vastberaden, getuige zijn opstelling tegenover kapitein Van Westerholt, die de slavenopstand uiteindelijk neersloeg, aan wie hij liet weten: \"wij zijn hier om te overwinnen of te sterven\".\r\n\r\nHij was een leider met een duidelijke visie, hij kon grote groepen slaven mobiliseren en had charisma en overwicht. In 2010 werd hij officieel erkend als nationale held en werden hij en zijn volgelingen gerehabiliteerd.', '7. Tula', '', 'inherit', 'closed', 'closed', '', '19-revision-v1', '', '', '2018-04-27 18:22:42', '2018-04-27 16:22:42', '', '19', 'https://canoncuracao.cw/19-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('525', '4', '2020-01-28 16:12:13', '2020-01-28 15:12:13', '<em>Een patriotse machtsovername</em>\n\nToen in 1795 de <a href=\"https://canoncuracao.cw/6-slavernijverzet/\">slavenopstand</a> uitbrak, was er politieke onrust in Curaçao. Evenals in de Republiek der Zeven Verenigde Nederlanden (1588-1795) stonden patriotten en conservatieve Oranjegezinden tegenover elkaar. De patriotten streefden naar meer democratie, meer invloed van het volk, en keerden zich tegen de absolute macht van stadhouder Willem V en zijn aanhang. Binnen de Curaçaose koloniale context, waar onvrijheid en huidskleur bepalend waren voor de maatschappelijke verhoudingen, kreeg deze politieke tegenstelling een eigen karakter. Evenals in Nederland, waar in 1795 met Franse steun de stadhouder werd verdreven en de Bataafse Republiek (1795-1801) werd uitgeroepen, wisten ook patriotten in Curaçao, gesteund door Franse kapers, in 1796 de macht te grijpen. De Bataafse Republiek, een Franse vazalstaat, kwam als bondgenoot van Frankrijk in de oorlog met Groot-Brittannië. Curaçao werd een belangrijk maritiem steunpunt voor de Fransen.\n\n<em>Hervorming van de defensie</em>\n\nNa de machtswisseling verkeerde het defensieapparaat in chaos. Oranjegezinde officieren van het garnizoen vertrokken hals over kop van Curaçao. Kort daarna werd de gouverneur a.i., Jan Jacob Beaujon, die ervan werd verdacht Oranjegezind en pro-Brits te zijn, afgezet. Hij werd opgevolgd door de kapitein van de burgerij Johann Rudolf Lauffer, die de verdediging van Curaçao reorganiseerde. De oorspronkelijk exclusief blanke burgerwacht werd uitgebreid met vrije Afro-Curaçaoenaars en omgedoopt tot Nationale Garde. Deze ‘vrijen’ waren afkomstig uit de zeevarende bevolking en hadden ervaring met de bediening van scheepsgeschut. Afro-Curaçaose schippers kregen officiersrangen bij het onderdeel artillerie.\n\n<em>Revolutionaire onrust</em>\n\nGeïnspireerd door de leuzen ‘vrijheid’ en ‘gelijkheid’ van de Franse Revolutie (1789-1799), de succesvolle slavenopstand in de Franse kolonie Saint-Domingue (het huidige Haïti) in 1791, die overging in de Haïtiaanse Revolutie (1791-1804) en de Franse afschaffing van de slavernij in 1792, ontstond in de gehele regio revolutionaire onrust. Het streven van de patriotten naar politieke en maatschappelijke verandering raakte op Curaçao vervlochten met het verlangen van de Afro-Curaçaoënaars naar vrijheid en een gelijke behandeling. Dit leidde op het eiland tot spanningen. Ook de <a href=\"https://canoncuracao.cw/7-tula/\">grote slavenopstand</a> op Curaçao in 1795 moet in deze context worden bezien. De leiders van een mislukte opstand in Venezuela vluchtten in 1797 naar Curaçao en vonden onderdak in Otrobanda. Geruchten over hun uitlevering veroorzaakte bijna een muiterij onder het voornamelijk uit Afro-Curaçaoënaars bestaande onderdeel artillerie van de Nationale Garde. In 1799 werden drie Fransen gearresteerd omdat zij, volgens Lauffer, de leiders waren van een complot om een nieuwe slavenopstand te ontketenen en de macht te grijpen. Alle drie werden zij uitgewezen.\n\n<em>Aangevallen door de bondgenoot en gered door de vijand</em>\n\nIn 1800 verscheen een Franse militaire macht uit Guadeloupe voor de haven om, zo werd gemeld, Curaçao tegen de Britten te beschermen. Vermoed werd dat de Fransen uit waren op een machtsovername. Dit bleek inderdaad het geval. Na eerst op aandringen van het gouvernement te zijn vertrokken, landden de Fransen een dag later bij Sint Michielsbaai. Daarna veroverden deze voornamelijk uit zwarte soldaten bestaande troepenmacht, gesteund door een groot deel van de Curaçaose slavenbevolking, op Willemstad na vrijwel het gehele eiland. Toen een Brits oorlogsschip voor de haven verscheen en vervolgens ook twee Amerikaanse oorlogsschepen, besloot het gouvernement om hun hulp in te roepen. De Fransen werden verdreven, maar een Britse bezetting, die tot 1803 zou duren, was het gevolg.\n\n&nbsp;', '9. Curaçao rond 1800', '', 'inherit', 'closed', 'closed', '', '23-autosave-v1', '', '', '2020-01-28 16:12:13', '2020-01-28 15:12:13', '', '23', 'https://canoncuracao.cw/23-autosave-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('526', '4', '2018-04-27 18:27:19', '2018-04-27 16:27:19', '<h3>Een patriotse putsch</h3>\r\nToen in 1795 de slavenopstand uitbrak, was er politieke onrust in Curaçao. Evenals in de Republiek stonden patriotten en Oranjegezinden tegenover elkaar. En evenals in het moederland, waar in 1795 met Franse steun de Bataafse Republiek werd uitgeroepen, wisten patriotten in Curaçao, gesteund door Franse kapers, in 1796 de macht te grijpen. De Bataafse Republiek kwam als bondgenoot van Frankrijk in de oorlog met Groot-Brittannië. Curaçao werd een belangrijk maritiem steunpunt voor de Fransen.\r\n<h3>Hervorming van de defensie</h3>\r\nNa de machtswisseling verkeerde het defensieapparaat in chaos. Oranjegezinde officieren van het garnizoen vertrokken hals over kop vanCuraçao. Kort daarna werd de gouverneur a.i., Jan Jacob Beaujon, die ervan werd verdacht Oranjegezind en pro-Brits te zijn, afgezet. Hij werd opgevolgd door de kapitein van de burgerij Johann RudolfLauffer, die de verdediging van Curaçao reorganiseerde. De oorspronkelijk exclusief blanke burgerwacht werd uitgebreid met vrije niet-blanken en omgedoopt tot Nationale Garde. Deze vrijen waren afkomstig uit de zeevarende bevolking en hadden ervaring met de bediening van scheepsgeschut. Gekleurde schippers kregen officiersrangen bij het onderdeel artillerie. Dit leidde tot spanningen binnen de Nationale Garde.\r\n<h3>Revolutionaire onrust</h3>\r\nGeïnspireerd door de leuzen ‘vrijheid’ en ‘gelijkheid’ van de Franse Revolutie (1789-1799), de succesvolle slavenopstand in de Franse kolonie Saint-Domingue in 1791 en de Franse afschaffing van de slavernij in 1792, ontstond in de gehele regio revolutionaire onrust. De leiders van een mislukte opstand in Venezuela vluchtten in 1797 naar Curaçao. Geruchten over hun uitlevering veroorzaakte bijna een muiterij onder artilleristen van de Nationale Garde. In 1799 werden drie Fransen gearresteerd omdat zij, volgens Lauffer, de leiders waren van een complot om een nieuwe slavenopstand te ontketenen en de macht te grijpen. Alle drie werden zij uitgewezen.\r\n<h3>Aangevallen door de bondgenoot en gered door de vijand</h3>\r\nIn 1800 verscheen een Franse militaire macht uit Guadeloupe voor de haven om, zo werd gemeld, Curaçao tegen de Britten te beschermen. Vermoed werd dat de Fransen uit waren op een machtsovername. Dit bleek inderdaad het geval. Na op aandringen van het gouvernement te zijn vertrokken, landden de Franse troepeneen dag later bij Sint-Michielsbaai. Daarna veroverden zij, gesteund door een groot deel van de Curaçaose slavenbevolking, op Willemstad na vrijwel het gehele eiland. Toen een Brits oorlogsschip voor de haven verscheen en vervolgens ook twee Amerikaanse oorlogsschepen, besloot het gouvernement hun hulp in te roepen. De Fransen werden verdreven, maar een Britse bezetting was het gevolg. In 1802 kwam Curaçao weer in Nederlandse handen. In 1807 veroverden de Britten Curaçao echter opnieuw. In 1816 werd het eiland weer aan Nederland teruggegeven.\r\n\r\nNB\r\nRepubliek: De Republiek der Verenigde Nederlanden (1588 – 1795)\r\nPatriotten en Oranjegezinden: tussen 1781 en 1795 speelde in Nederland een conflict tussen de aanhangers van prins Willem V (oranjegezinden) en mensen die meer macht bij het volk wilden leggen (patriotten). Deze twee groepen stonden ook op Curaçao tegenover elkaar\r\nBataafse republiek: vanaf 1795 tot 1801 heette Nederland de Bataafse Republiek. Officieel was het land onafhankelijk maar in feite maakte Frankrijk de dienst uit.\r\n\r\n<em>Han Jordaan</em>', '9. Curaçao rond 1800', '', 'inherit', 'closed', 'closed', '', '23-revision-v1', '', '', '2018-04-27 18:27:19', '2018-04-27 16:27:19', '', '23', 'https://canoncuracao.cw/23-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('527', '4', '2018-04-27 18:27:58', '2018-04-27 16:27:58', '<h3>Een patriotse putsch</h3>\r\nToen in 1795 de slavenopstand uitbrak, was er politieke onrust in Curaçao. Evenals in de Republiek stonden patriotten en Oranjegezinden tegenover elkaar. En evenals in het moederland, waar in 1795 met Franse steun de Bataafse Republiek werd uitgeroepen, wisten patriotten in Curaçao, gesteund door Franse kapers, in 1796 de macht te grijpen. De Bataafse Republiek kwam als bondgenoot van Frankrijk in de oorlog met Groot-Brittannië. Curaçao werd een belangrijk maritiem steunpunt voor de Fransen.\r\n<h3>Hervorming van de defensie</h3>\r\nNa de machtswisseling verkeerde het defensieapparaat in chaos. Oranjegezinde officieren van het garnizoen vertrokken hals over kop vanCuraçao. Kort daarna werd de gouverneur a.i., Jan Jacob Beaujon, die ervan werd verdacht Oranjegezind en pro-Brits te zijn, afgezet. Hij werd opgevolgd door de kapitein van de burgerij Johann RudolfLauffer, die de verdediging van Curaçao reorganiseerde. De oorspronkelijk exclusief blanke burgerwacht werd uitgebreid met vrije niet-blanken en omgedoopt tot Nationale Garde. Deze vrijen waren afkomstig uit de zeevarende bevolking en hadden ervaring met de bediening van scheepsgeschut. Gekleurde schippers kregen officiersrangen bij het onderdeel artillerie. Dit leidde tot spanningen binnen de Nationale Garde.\r\n<h3>Revolutionaire onrust</h3>\r\nGeïnspireerd door de leuzen ‘vrijheid’ en ‘gelijkheid’ van de Franse Revolutie (1789-1799), de succesvolle slavenopstand in de Franse kolonie Saint-Domingue in 1791 en de Franse afschaffing van de slavernij in 1792, ontstond in de gehele regio revolutionaire onrust. De leiders van een mislukte opstand in Venezuela vluchtten in 1797 naar Curaçao. Geruchten over hun uitlevering veroorzaakte bijna een muiterij onder artilleristen van de Nationale Garde. In 1799 werden drie Fransen gearresteerd omdat zij, volgens Lauffer, de leiders waren van een complot om een nieuwe slavenopstand te ontketenen en de macht te grijpen. Alle drie werden zij uitgewezen.\r\n<h3>Aangevallen door de bondgenoot en gered door de vijand</h3>\r\nIn 1800 verscheen een Franse militaire macht uit Guadeloupe voor de haven om, zo werd gemeld, Curaçao tegen de Britten te beschermen. Vermoed werd dat de Fransen uit waren op een machtsovername. Dit bleek inderdaad het geval. Na op aandringen van het gouvernement te zijn vertrokken, landden de Franse troepeneen dag later bij Sint-Michielsbaai. Daarna veroverden zij, gesteund door een groot deel van de Curaçaose slavenbevolking, op Willemstad na vrijwel het gehele eiland. Toen een Brits oorlogsschip voor de haven verscheen en vervolgens ook twee Amerikaanse oorlogsschepen, besloot het gouvernement hun hulp in te roepen. De Fransen werden verdreven, maar een Britse bezetting was het gevolg. In 1802 kwam Curaçao weer in Nederlandse handen. In 1807 veroverden de Britten Curaçao echter opnieuw. In 1816 werd het eiland weer aan Nederland teruggegeven.\r\n\r\nNB\r\nRepubliek: De Republiek der Verenigde Nederlanden (1588 – 1795)\r\nPatriotten en Oranjegezinden: tussen 1781 en 1795 speelde in Nederland een conflict tussen de aanhangers van prins Willem V (oranjegezinden) en mensen die meer macht bij het volk wilden leggen (patriotten). Deze twee groepen stonden ook op Curaçao tegenover elkaar\r\nBataafse republiek: vanaf 1795 tot 1801 heette Nederland de Bataafse Republiek. Officieel was het land onafhankelijk maar in feite maakte Frankrijk de dienst uit.\r\n\r\n<em>Han Jordaan</em>', '9. Curaçao rond 1800', '', 'inherit', 'closed', 'closed', '', '23-revision-v1', '', '', '2018-04-27 18:27:58', '2018-04-27 16:27:58', '', '23', 'https://canoncuracao.cw/23-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('528', '4', '2018-04-27 18:30:19', '2018-04-27 16:30:19', '<h3>Een patriotse putsch</h3>\r\nToen in 1795 de slavenopstand uitbrak, was er politieke onrust in Curaçao. Evenals in de Republiek stonden patriotten en Oranjegezinden tegenover elkaar. En evenals in het moederland, waar in 1795 met Franse steun de Bataafse Republiek werd uitgeroepen, wisten patriotten in Curaçao, gesteund door Franse kapers, in 1796 de macht te grijpen. De Bataafse Republiek kwam als bondgenoot van Frankrijk in de oorlog met Groot-Brittannië. Curaçao werd een belangrijk maritiem steunpunt voor de Fransen.\r\n<h3>Hervorming van de defensie</h3>\r\nNa de machtswisseling verkeerde het defensieapparaat in chaos. Oranjegezinde officieren van het garnizoen vertrokken hals over kop van Curaçao. Kort daarna werd de gouverneur a.i., Jan Jacob Beaujon, die ervan werd verdacht Oranjegezind en pro-Brits te zijn, afgezet. Hij werd opgevolgd door de kapitein van de burgerij Johann Rudolf Lauffer, die de verdediging van Curaçao reorganiseerde. De oorspronkelijk exclusief blanke burgerwacht werd uitgebreid met vrije niet-blanken en omgedoopt tot Nationale Garde. Deze vrijen waren afkomstig uit de zeevarende bevolking en hadden ervaring met de bediening van scheepsgeschut. Gekleurde schippers kregen officiersrangen bij het onderdeel artillerie. Dit leidde tot spanningen binnen de Nationale Garde.\r\n<h3>Revolutionaire onrust</h3>\r\nGeïnspireerd door de leuzen ‘vrijheid’ en ‘gelijkheid’ van de Franse Revolutie (1789-1799), de succesvolle slavenopstand in de Franse kolonie Saint-Domingue in 1791 en de Franse afschaffing van de slavernij in 1792, ontstond in de gehele regio revolutionaire onrust. De leiders van een mislukte opstand in Venezuela vluchtten in 1797 naar Curaçao. Geruchten over hun uitlevering veroorzaakte bijna een muiterij onder artilleristen van de Nationale Garde. In 1799 werden drie Fransen gearresteerd omdat zij, volgens Lauffer, de leiders waren van een complot om een nieuwe slavenopstand te ontketenen en de macht te grijpen. Alle drie werden zij uitgewezen.\r\n<h3>Aangevallen door de bondgenoot en gered door de vijand</h3>\r\nIn 1800 verscheen een Franse militaire macht uit Guadeloupe voor de haven om, zo werd gemeld, Curaçao tegen de Britten te beschermen. Vermoed werd dat de Fransen uit waren op een machtsovername. Dit bleek inderdaad het geval. Na op aandringen van het gouvernement te zijn vertrokken, landden de Franse troepen een dag later bij Sint-Michielsbaai. Daarna veroverden zij, gesteund door een groot deel van de Curaçaose slavenbevolking, op Willemstad na vrijwel het gehele eiland. Toen een Brits oorlogsschip voor de haven verscheen en vervolgens ook twee Amerikaanse oorlogsschepen, besloot het gouvernement hun hulp in te roepen. De Fransen werden verdreven, maar een Britse bezetting was het gevolg. In 1802 kwam Curaçao weer in Nederlandse handen. In 1807 veroverden de Britten Curaçao echter opnieuw. In 1816 werd het eiland weer aan Nederland teruggegeven.\r\n\r\nNB\r\nRepubliek: De Republiek der Verenigde Nederlanden (1588 – 1795).\r\nPatriotten en Oranjegezinden: tussen 1781 en 1795 speelde in Nederland een conflict tussen de aanhangers van prins Willem V (oranjegezinden) en mensen die meer macht bij het volk wilden leggen (patriotten). Deze twee groepen stonden ook op Curaçao tegenover elkaar.\r\nBataafse republiek: vanaf 1795 tot 1801 heette Nederland de Bataafse Republiek. Officieel was het land onafhankelijk maar in feite maakte Frankrijk de dienst uit.\r\n\r\n<em>Han Jordaan</em>', '9. Curaçao rond 1800', '', 'inherit', 'closed', 'closed', '', '23-revision-v1', '', '', '2018-04-27 18:30:19', '2018-04-27 16:30:19', '', '23', 'https://canoncuracao.cw/23-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('529', '4', '2018-04-27 18:36:57', '2018-04-27 16:36:57', '<h3>Een patriotse putsch (opstand)</h3>\r\nToen in 1795 de slavenopstand uitbrak, was er politieke onrust in Curaçao. Evenals in de Republiek stonden patriotten en Oranjegezinden tegenover elkaar. En evenals in het moederland, waar in 1795 met Franse steun de Bataafse Republiek werd uitgeroepen, wisten patriotten in Curaçao, gesteund door Franse kapers, in 1796 de macht te grijpen. De Bataafse Republiek kwam als bondgenoot van Frankrijk in de oorlog met Groot-Brittannië. Curaçao werd een belangrijk maritiem steunpunt voor de Fransen.\r\n<h3>Hervorming van de defensie</h3>\r\nNa de machtswisseling verkeerde het defensieapparaat in chaos. Oranjegezinde officieren van het garnizoen vertrokken hals over kop van Curaçao. Kort daarna werd de gouverneur a.i., Jan Jacob Beaujon, die ervan werd verdacht Oranjegezind en pro-Brits te zijn, afgezet. Hij werd opgevolgd door de kapitein van de burgerij Johann Rudolf Lauffer, die de verdediging van Curaçao reorganiseerde. De oorspronkelijk exclusief blanke burgerwacht werd uitgebreid met vrije niet-blanken en omgedoopt tot Nationale Garde. Deze vrijen waren afkomstig uit de zeevarende bevolking en hadden ervaring met de bediening van scheepsgeschut. Gekleurde schippers kregen officiersrangen bij het onderdeel artillerie. Dit leidde tot spanningen binnen de Nationale Garde.\r\n<h3>Revolutionaire onrust</h3>\r\nGeïnspireerd door de leuzen ‘vrijheid’ en ‘gelijkheid’ van de Franse Revolutie (1789-1799), de succesvolle slavenopstand in de Franse kolonie Saint-Domingue in 1791 en de Franse afschaffing van de slavernij in 1792, ontstond in de gehele regio revolutionaire onrust. Ook de grote slavenopstand op Curaçao in 1795  (zie vensters 6 en 7) moet in deze context worden bezien. De leiders van een mislukte opstand in Venezuela vluchtten in 1797 naar Curaçao. Geruchten over hun uitlevering veroorzaakte bijna een muiterij onder artilleristen van de Nationale Garde. In 1799 werden drie Fransen gearresteerd omdat zij, volgens Lauffer, de leiders waren van een complot om een nieuwe slavenopstand te ontketenen en de macht te grijpen. Alle drie werden zij uitgewezen.\r\n<h3>Aangevallen door de bondgenoot en gered door de vijand</h3>\r\nIn 1800 verscheen een Franse militaire macht uit Guadeloupe voor de haven om, zo werd gemeld, Curaçao tegen de Britten te beschermen. Vermoed werd dat de Fransen uit waren op een machtsovername. Dit bleek inderdaad het geval. Na op aandringen van het gouvernement te zijn vertrokken, landden de Franse troepen een dag later bij Sint-Michielsbaai. Daarna veroverden zij, gesteund door een groot deel van de Curaçaose slavenbevolking, op Willemstad na vrijwel het gehele eiland. Toen een Brits oorlogsschip voor de haven verscheen en vervolgens ook twee Amerikaanse oorlogsschepen, besloot het gouvernement hun hulp in te roepen. De Fransen werden verdreven, maar een Britse bezetting was het gevolg. In 1802 kwam Curaçao weer in Nederlandse handen. In 1807 veroverden de Britten Curaçao echter opnieuw. In 1816 werd het eiland weer aan Nederland teruggegeven.\r\n\r\nNB\r\nRepubliek: De Republiek der Verenigde Nederlanden (1588 – 1795).\r\nPatriotten en Oranjegezinden: tussen 1781 en 1795 speelde in Nederland een conflict tussen de aanhangers van prins Willem V (oranjegezinden) en mensen die meer macht bij het volk wilden leggen (patriotten). Deze twee groepen stonden ook op Curaçao tegenover elkaar.\r\nBataafse republiek: vanaf 1795 tot 1801 heette Nederland de Bataafse Republiek. Officieel was het land onafhankelijk maar in feite maakte Frankrijk de dienst uit.\r\n\r\n<em>Han Jordaan</em>', '9. Curaçao rond 1800', '', 'inherit', 'closed', 'closed', '', '23-revision-v1', '', '', '2018-04-27 18:36:57', '2018-04-27 16:36:57', '', '23', 'https://canoncuracao.cw/23-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('530', '4', '2018-04-27 18:38:42', '2018-04-27 16:38:42', '<h3>Een patriotse putsch (opstand)</h3>\r\nToen in 1795 de slavenopstand uitbrak, was er politieke onrust in Curaçao. Evenals in de Republiek stonden patriotten en Oranjegezinden tegenover elkaar. En evenals in het moederland, waar in 1795 met Franse steun de Bataafse Republiek werd uitgeroepen, wisten patriotten in Curaçao, gesteund door Franse kapers, in 1796 de macht te grijpen. De Bataafse Republiek kwam als bondgenoot van Frankrijk in de oorlog met Groot-Brittannië. Curaçao werd een belangrijk maritiem steunpunt voor de Fransen.\r\n<h3>Hervorming van de defensie</h3>\r\nNa de machtswisseling verkeerde het defensieapparaat in chaos. Oranjegezinde officieren van het garnizoen vertrokken hals over kop van Curaçao. Kort daarna werd de gouverneur a.i., Jan Jacob Beaujon, die ervan werd verdacht Oranjegezind en pro-Brits te zijn, afgezet. Hij werd opgevolgd door de kapitein van de burgerij Johann Rudolf Lauffer, die de verdediging van Curaçao reorganiseerde. De oorspronkelijk exclusief blanke burgerwacht werd uitgebreid met vrije niet-blanken en omgedoopt tot Nationale Garde. Deze vrijen waren afkomstig uit de zeevarende bevolking en hadden ervaring met de bediening van scheepsgeschut. Gekleurde schippers kregen officiersrangen bij het onderdeel artillerie. Dit leidde tot spanningen binnen de Nationale Garde.\r\n<h3>Revolutionaire onrust</h3>\r\nGeïnspireerd door de leuzen ‘vrijheid’ en ‘gelijkheid’ van de Franse Revolutie (1789-1799), de succesvolle slavenopstand in de Franse kolonie Saint-Domingue in 1791 en de Franse afschaffing van de slavernij in 1792, ontstond in de gehele regio revolutionaire onrust. Ook de grote slavenopstand op Curaçao in 1795  (zie venster 7) moet in deze context worden bezien. De leiders van een mislukte opstand in Venezuela vluchtten in 1797 naar Curaçao. Geruchten over hun uitlevering veroorzaakte bijna een muiterij onder artilleristen van de Nationale Garde. In 1799 werden drie Fransen gearresteerd omdat zij, volgens Lauffer, de leiders waren van een complot om een nieuwe slavenopstand te ontketenen en de macht te grijpen. Alle drie werden zij uitgewezen.\r\n<h3>Aangevallen door de bondgenoot en gered door de vijand</h3>\r\nIn 1800 verscheen een Franse militaire macht uit Guadeloupe voor de haven om, zo werd gemeld, Curaçao tegen de Britten te beschermen. Vermoed werd dat de Fransen uit waren op een machtsovername. Dit bleek inderdaad het geval. Na op aandringen van het gouvernement te zijn vertrokken, landden de Franse troepen een dag later bij Sint-Michielsbaai. Daarna veroverden zij, gesteund door een groot deel van de Curaçaose slavenbevolking, op Willemstad na vrijwel het gehele eiland. Toen een Brits oorlogsschip voor de haven verscheen en vervolgens ook twee Amerikaanse oorlogsschepen, besloot het gouvernement hun hulp in te roepen. De Fransen werden verdreven, maar een Britse bezetting was het gevolg. In 1802 kwam Curaçao weer in Nederlandse handen. In 1807 veroverden de Britten Curaçao echter opnieuw. In 1816 werd het eiland weer aan Nederland teruggegeven.\r\n\r\nNB\r\nRepubliek: De Republiek der Verenigde Nederlanden (1588 – 1795).\r\nPatriotten en Oranjegezinden: tussen 1781 en 1795 speelde in Nederland een conflict tussen de aanhangers van prins Willem V (oranjegezinden) en mensen die meer macht bij het volk wilden leggen (patriotten). Deze twee groepen stonden ook op Curaçao tegenover elkaar.\r\nBataafse republiek: vanaf 1795 tot 1801 heette Nederland de Bataafse Republiek. Officieel was het land onafhankelijk maar in feite maakte Frankrijk de dienst uit.\r\n\r\n<em>Han Jordaan</em>', '9. Curaçao rond 1800', '', 'inherit', 'closed', 'closed', '', '23-revision-v1', '', '', '2018-04-27 18:38:42', '2018-04-27 16:38:42', '', '23', 'https://canoncuracao.cw/23-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('531', '4', '2018-04-27 18:39:56', '2018-04-27 16:39:56', '<h3>Een patriotse putsch (opstand)</h3>\r\nToen in 1795 de slavenopstand uitbrak, was er politieke onrust in Curaçao. Evenals in de Republiek stonden patriotten en Oranjegezinden tegenover elkaar. En evenals in het moederland, waar in 1795 met Franse steun de Bataafse Republiek werd uitgeroepen, wisten patriotten in Curaçao, gesteund door Franse kapers, in 1796 de macht te grijpen. De Bataafse Republiek kwam als bondgenoot van Frankrijk in de oorlog met Groot-Brittannië. Curaçao werd een belangrijk maritiem steunpunt voor de Fransen.\r\n<h3>Hervorming van de defensie</h3>\r\nNa de machtswisseling verkeerde het defensieapparaat in chaos. Oranjegezinde officieren van het garnizoen vertrokken hals over kop van Curaçao. Kort daarna werd de gouverneur a.i., Jan Jacob Beaujon, die ervan werd verdacht Oranjegezind en pro-Brits te zijn, afgezet. Hij werd opgevolgd door de kapitein van de burgerij Johann Rudolf Lauffer, die de verdediging van Curaçao reorganiseerde. De oorspronkelijk exclusief blanke burgerwacht werd uitgebreid met vrije niet-blanken en omgedoopt tot Nationale Garde. Deze vrijen waren afkomstig uit de zeevarende bevolking en hadden ervaring met de bediening van scheepsgeschut. Gekleurde schippers kregen officiersrangen bij het onderdeel artillerie. Dit leidde tot spanningen binnen de Nationale Garde.\r\n<h3>Revolutionaire onrust</h3>\r\nGeïnspireerd door de leuzen ‘vrijheid’ en ‘gelijkheid’ van de Franse Revolutie (1789-1799), de succesvolle slavenopstand in de Franse kolonie Saint-Domingue in 1791 en de Franse afschaffing van de slavernij in 1792, ontstond in de gehele regio revolutionaire onrust. Ook de grote slavenopstand op Curaçao in 1795  (zie <a href=\"https://canoncuracao.cw/7-tula/\">venster 7</a>) moet in deze context worden bezien. De leiders van een mislukte opstand in Venezuela vluchtten in 1797 naar Curaçao. Geruchten over hun uitlevering veroorzaakte bijna een muiterij onder artilleristen van de Nationale Garde. In 1799 werden drie Fransen gearresteerd omdat zij, volgens Lauffer, de leiders waren van een complot om een nieuwe slavenopstand te ontketenen en de macht te grijpen. Alle drie werden zij uitgewezen.\r\n<h3>Aangevallen door de bondgenoot en gered door de vijand</h3>\r\nIn 1800 verscheen een Franse militaire macht uit Guadeloupe voor de haven om, zo werd gemeld, Curaçao tegen de Britten te beschermen. Vermoed werd dat de Fransen uit waren op een machtsovername. Dit bleek inderdaad het geval. Na op aandringen van het gouvernement te zijn vertrokken, landden de Franse troepen een dag later bij Sint-Michielsbaai. Daarna veroverden zij, gesteund door een groot deel van de Curaçaose slavenbevolking, op Willemstad na vrijwel het gehele eiland. Toen een Brits oorlogsschip voor de haven verscheen en vervolgens ook twee Amerikaanse oorlogsschepen, besloot het gouvernement hun hulp in te roepen. De Fransen werden verdreven, maar een Britse bezetting was het gevolg. In 1802 kwam Curaçao weer in Nederlandse handen. In 1807 veroverden de Britten Curaçao echter opnieuw. In 1816 werd het eiland weer aan Nederland teruggegeven.\r\n\r\nNB\r\nRepubliek: De Republiek der Verenigde Nederlanden (1588 – 1795).\r\nPatriotten en Oranjegezinden: tussen 1781 en 1795 speelde in Nederland een conflict tussen de aanhangers van prins Willem V (oranjegezinden) en mensen die meer macht bij het volk wilden leggen (patriotten). Deze twee groepen stonden ook op Curaçao tegenover elkaar.\r\nBataafse republiek: vanaf 1795 tot 1801 heette Nederland de Bataafse Republiek. Officieel was het land onafhankelijk maar in feite maakte Frankrijk de dienst uit.\r\n\r\n<em>Han Jordaan</em>', '9. Curaçao rond 1800', '', 'inherit', 'closed', 'closed', '', '23-revision-v1', '', '', '2018-04-27 18:39:56', '2018-04-27 16:39:56', '', '23', 'https://canoncuracao.cw/23-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('532', '4', '2020-01-28 16:20:39', '2020-01-28 15:20:39', 'De eerste activiteit van de <a href=\"https://canoncuracao.cw/3-verovering-van-curacao-door-de-wic-en-de-komst-van-de-hollanders/\">West-Indische Compagnie</a> na de verovering van Curaçao in 1634 was het bouwen van een versterking, Fort Amsterdam. Rond dit fort ontstond de eerste nederzetting: Punda en de directe omgeving.\n\nOm voedsel voor de lokale bevolking te produceren stimuleerde de W.I.C. de vestiging van <a href=\"https://canoncuracao.cw/13-plantagesysteem-op-curacao/\">plantages</a>, die verspreid kwamen te liggen over het hele eiland. Alleen de minder goede gronden, de zogenaamde ‘savaangronden’, bleven in handen van de overheid. Op alle plantages werden in het zicht van de eigenaarswoning kleine lemen huisjes met daken van maisstrengels voor de slaafgemaakte bevolking neergezet, de zogenaamde <em>kas di pal’i maishi</em>. Na de afschaffing van de slavernij bleven deze dorpskernen meestal bestaan, met name in Bandabou (het westelijk deel van het eiland). De meeste ex-slaven bleven werken onder <a href=\"https://canoncuracao.cw/14-afschaffing-slavernij/\"><em>paga tera</em></a>-verhoudingen, d.w.z. dat zij een hun toegewezen stukje grond op de plantage konden bewerken voor eigen gebruik mits zij enige dagen per jaar zonder betaling werkzaamheden voor de plantage-eigenaar verrichtten en een deel van hun productie afstonden. Geleidelijk aan, vooral door conflicten met de plantage-eigenaren en achteruitgang van de plantage-productie verdwenen de meeste van deze buurtgemeenschappen. De dorpjes Knip en Soto zijn hierop uitzonderingen.\n\nIn de negentiende eeuw ontstonden er aanvullende en later deels vervangende nederzettingskernen op initiatief van de R.K. kerk. <a href=\"https://canoncuracao.cw/20-komst-religieuze-ordes-nederland-en-betekenis/\">Mgr. Niewindt</a> wilde godsdienst en <a href=\"https://canoncuracao.cw/41-onderwijs-op-curacao/\">onderwijs </a>brengen aan de buiten de stad woonachtige donkere bevolking. Daarom verdeelde hij het gebied buiten het stadsdistrict in een beperkt aantal grote parochies op goed bereikbare plaatsen. In de centra kwamen een kerkje en een <em>kunukuschooltje</em> (plattelandschooltje). Hier omheen ontwikkelden zich de eerste kerkdorpen, beginnend met Barber, daarna Santa Rosa en Santa Maria. Later werden de parochies opgesplitst en zo ontstonden bijvoorbeeld de parochies San Willibrordo en Montagne. In deze nederzettingen vestigden zich ex-slaven, die zich losmaakten van de plantages en het paga tera-systeem.\n\nNaast deze kerkelijke initiatieven waren er ook woonkernen van vrije lieden te Westpunt, San Pedro, Seru Fortuna en Boka Sami.\n\nNaast deze kernen ontstonden weer andere buurtschappen doordat al in de achttiende eeuw vrije lieden zich verspreid vestigden op de savaangronden. Deze ontwikkeling ging na de afschaffing van de slavernij door. Andere buurtschappen ontstonden doordat de overheid, vooral aan het eind van de negentiende eeuw, percelen domeingrond ging uitgeven. In het begin van de twintigste eeuw kocht de overheid ook plantages op om deze gronden te verkavelen in kleine percelen, waar men een huisje op kon bouwen en aan kleinlandbouw kon doen. Dit gebeurde bijvoorbeeld o.a. in Pannekoek, Dokterstuin, Flip en Mahuma. De kleinlandbouw leverde in de meeste gevallen niet voldoende op om van te kunnen leven.\n\nMet de komst van de <a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">Shell</a> breidde de stad zelf zich als een inktvlek uit en wel rondom het Schottegat. Naast de zelfbouwactiviteiten van onder andere lokale arbeiders, bouwde de raffinaderij woonwijken voor het hoger en middenkader en voor de buitenlandse werknemers.', '11. De ontwikkeling van bewoning buiten Willemstad', '', 'inherit', 'closed', 'closed', '', '27-autosave-v1', '', '', '2020-01-28 16:20:39', '2020-01-28 15:20:39', '', '27', 'https://canoncuracao.cw/27-autosave-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('533', '4', '2018-04-27 18:42:56', '2018-04-27 16:42:56', 'De eerste activiteit van de WIC na de verovering van Curaçao in 1634 was het bouwen van een versterking, Fort Amsterdam. Rond dit fort ontstond de eerste nederzetting: Punda en de directe omgeving.\r\n\r\nOm voedsel voor de lokale bevolking te produceren stimuleerde de WIC de vestiging van plantages, die verspreid kwamen te liggen over het hele eiland. Alleen de minder goede gronden, de zogenaamde ‘savaangronden’, bleven in handen van de overheid. Op alle plantages kwamen buurtgemeenschappen of ‘dorpen’ voor, waar de als slaaf werkzame Afrikanen woonden in ‘kas di pal\'i maishi\' (kleine lemen huisjes met een rieten dak). Dit waren de eerste nederzettingen buiten het stadsdistrict. Ook na de afschaffing van de slavernij bleven deze nederzettingskernen veelal bestaan, met name in Banda\'bou (het westelijk deel van het eiland) het geval. De meeste ex-slaven bleven werken onder ‘paga tera-verhoudingen’, d.w.z. dat zij een eigen stukje grond op de plantage konden bewerken voor eigen gebruik mits zij enige dagen per jaar werkzaamheden voor de plantage-eigenaar verrichtten zonder dat zij daarvoor betaald werden. Geleidelijk aan, vooral door conflicten met de plantage-eigenaren en achteruitgang van het plantage-gebeuren verdwenen de meeste van deze buurtgemeenschappen. De dorpjes Knip en Soto zijn hierop uitzonderingen.\r\n\r\nIn de negentiende eeuw ontstonden er aanvullende en later deels vervangende nederzettingskernen op initiatief van de R.K. kerk. Mgr. Niewindt wilde godsdienst en onderwijs brengen aan de buiten de stad woonachtige donkere bevolking. Daarom verdeelde hij het gebied buiten het stadsdistrict in een beperkt aantal grote parochies en hij koos voor de centra van die parochies plaatsen die makkelijk bereikbaar waren. In de centra kwamen een kerkje en een kunukuschooltje (plattelandschooltje). Hier omheen ontwikkelden zich de eerste kerkdorpen, beginnend met Barber, daarna Santa Rosa en Santa Maria. Later werden de parochies opgesplitst en zo ontstonden bijvoorbeeld de parochies San Willibrordo en Montagne. In deze nederzettingen vestigden zich ex-slaven, die zich losmaakten van de plantages en het paga terasysteem.\r\n\r\nNaast deze kerkelijke initiatieven waren er ook woonkernen van vrije lieden te Westpunt, San Pedro, Seru Fortuna en Boka Sami.\r\nNaast deze kernen vestigden ontstonden weer andere buurtschappen doordat al in de achttiende eeuw vrije lieden zich verspreid vestigden op de savaangronden. Deze ontwikkeling ging na de afschaffing van de ‎slavernij door. Andere buurtschappen ontstonden doordat de overheid, vooral aan het eind van de negentiende eeuw, percelen domeingrond ging uitgeven. In het begin van de twintigste eeuw kocht de overheid ook plantages op om deze gronden te verkavelen in kleine percelen, waar men een huisje op kon bouwen en aan kleinlandbouw kon doen. Dit gebeurde bijvoorbeeld o.a. in Pannekoek, Dokterstuin, Phlip en Mahoema. De kleinlandbouw leverde in de meeste gevallen niet voldoende op om van te kunnen leven.\r\n\r\nMet de komst van de Shell breidde de stad zelf zich als een inktvlek uit en wel rondom het Schottegat. Naast de zelfbouwactiviteiten van onder andere lokale arbeiders, bouwde de raffinaderij woonwijken voor het hoger en middenkader en voor de buitenlandse werknemers.', '11. De ontwikkeling van bewoning buiten Willemstad', '', 'inherit', 'closed', 'closed', '', '27-revision-v1', '', '', '2018-04-27 18:42:56', '2018-04-27 16:42:56', '', '27', 'https://canoncuracao.cw/27-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('534', '4', '2018-04-27 18:58:12', '2018-04-27 16:58:12', '', 'H4 contract 2 ha 43', '', 'inherit', 'open', 'closed', '', 'h4-contract-2-ha-43', '', '', '2018-04-27 18:58:14', '2018-04-27 16:58:14', '', '27', 'https://canoncuracao.cw/wp-content/uploads/2017/05/H4-contract-2-ha-43.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('535', '4', '2018-04-27 19:02:25', '2018-04-27 17:02:25', 'De eerste activiteit van de WIC na de verovering van Curaçao in 1634 was het bouwen van een versterking, Fort Amsterdam. Rond dit fort ontstond de eerste nederzetting: Punda en de directe omgeving.\r\n\r\nOm voedsel voor de lokale bevolking te produceren stimuleerde de WIC de vestiging van plantages, die verspreid kwamen te liggen over het hele eiland. Alleen de minder goede gronden, de zogenaamde ‘savaangronden’, bleven in handen van de overheid. Op alle plantages kwamen buurtgemeenschappen of ‘dorpen’ voor, waar de als slaaf werkzame Afrikanen woonden in ‘kas di pal\'i maishi\' (kleine lemen huisjes met een rieten dak). Dit waren de eerste nederzettingen buiten het stadsdistrict. Ook na de afschaffing van de slavernij bleven deze nederzettingskernen veelal bestaan, met name in Banda\'bou (het westelijk deel van het eiland) het geval. De meeste ex-slaven bleven werken onder ‘paga tera-verhoudingen’, d.w.z. dat zij een eigen stukje grond op de plantage konden bewerken voor eigen gebruik mits zij enige dagen per jaar werkzaamheden voor de plantage-eigenaar verrichtten zonder dat zij daarvoor betaald werden. Geleidelijk aan, vooral door conflicten met de plantage-eigenaren en achteruitgang van het plantage-gebeuren verdwenen de meeste van deze buurtgemeenschappen. De dorpjes Knip en Soto zijn hierop uitzonderingen.\r\n\r\nIn de negentiende eeuw ontstonden er aanvullende en later deels vervangende nederzettingskernen op initiatief van de R.K. kerk. Mgr. Niewindt wilde godsdienst en onderwijs brengen aan de buiten de stad woonachtige donkere bevolking. Daarom verdeelde hij het gebied buiten het stadsdistrict in een beperkt aantal grote parochies en hij koos voor de centra van die parochies plaatsen die makkelijk bereikbaar waren. In de centra kwamen een kerkje en een kunukuschooltje (plattelandschooltje). Hier omheen ontwikkelden zich de eerste kerkdorpen, beginnend met Barber, daarna Santa Rosa en Santa Maria. Later werden de parochies opgesplitst en zo ontstonden bijvoorbeeld de parochies San Willibrordo en Montagne. In deze nederzettingen vestigden zich ex-slaven, die zich losmaakten van de plantages en het paga terasysteem.\r\n\r\nNaast deze kerkelijke initiatieven waren er ook woonkernen van vrije lieden te Westpunt, San Pedro, Seru Fortuna en Boka Sami.\r\nNaast deze kernen vestigden ontstonden weer andere buurtschappen doordat al in de achttiende eeuw vrije lieden zich verspreid vestigden op de savaangronden. Deze ontwikkeling ging na de afschaffing van de ‎slavernij door. Andere buurtschappen ontstonden doordat de overheid, vooral aan het eind van de negentiende eeuw, percelen domeingrond ging uitgeven. In het begin van de twintigste eeuw kocht de overheid ook plantages op om deze gronden te verkavelen in kleine percelen, waar men een huisje op kon bouwen en aan kleinlandbouw kon doen. Dit gebeurde bijvoorbeeld o.a. in Pannekoek, Dokterstuin, Phlip en Mahoema. De kleinlandbouw leverde in de meeste gevallen niet voldoende op om van te kunnen leven.\r\n\r\nMet de komst van de Shell breidde de stad zelf zich als een inktvlek uit en wel rondom het Schottegat. Naast de zelfbouwactiviteiten van onder andere lokale arbeiders, bouwde de raffinaderij woonwijken voor het hoger en middenkader en voor de buitenlandse werknemers.', '11. De ontwikkeling van bewoning buiten Willemstad', '', 'inherit', 'closed', 'closed', '', '27-revision-v1', '', '', '2018-04-27 19:02:25', '2018-04-27 17:02:25', '', '27', 'https://canoncuracao.cw/27-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('536', '4', '2018-04-27 19:04:06', '2018-04-27 17:04:06', 'De eerste activiteit van de WIC na de verovering van Curaçao in 1634 was het bouwen van een versterking, Fort Amsterdam. Rond dit fort ontstond de eerste nederzetting: Punda en de directe omgeving.\r\n\r\nOm voedsel voor de lokale bevolking te produceren stimuleerde de WIC de vestiging van plantages, die verspreid kwamen te liggen over het hele eiland. Alleen de minder goede gronden, de zogenaamde ‘savaangronden’, bleven in handen van de overheid. Op alle plantages kwamen buurtgemeenschappen of ‘dorpen’ voor, waar de als slaaf werkzame Afrikanen woonden in ‘kas di pal\'i maishi\' (kleine lemen huisjes met een rieten dak). Dit waren de eerste nederzettingen buiten het stadsdistrict. Ook na de afschaffing van de slavernij bleven deze nederzettingskernen veelal bestaan, met name in Banda\'bou (het westelijk deel van het eiland) het geval. De meeste ex-slaven bleven werken onder ‘paga tera-verhoudingen’, d.w.z. dat zij een eigen stukje grond op de plantage konden bewerken voor eigen gebruik mits zij enige dagen per jaar werkzaamheden voor de plantage-eigenaar verrichtten zonder dat zij daarvoor betaald werden. Geleidelijk aan, vooral door conflicten met de plantage-eigenaren en achteruitgang van het plantage-gebeuren verdwenen de meeste van deze buurtgemeenschappen. De dorpjes Knip en Soto zijn hierop uitzonderingen.\r\n\r\nIn de negentiende eeuw ontstonden er aanvullende en later deels vervangende nederzettingskernen op initiatief van de R.K. kerk. Mgr. Niewindt wilde godsdienst en onderwijs brengen aan de buiten de stad woonachtige donkere bevolking. Daarom verdeelde hij het gebied buiten het stadsdistrict in een beperkt aantal grote parochies en hij koos voor de centra van die parochies plaatsen die makkelijk bereikbaar waren. In de centra kwamen een kerkje en een kunukuschooltje (plattelandschooltje). Hier omheen ontwikkelden zich de eerste kerkdorpen, beginnend met Barber, daarna Santa Rosa en Santa Maria. Later werden de parochies opgesplitst en zo ontstonden bijvoorbeeld de parochies San Willibrordo en Montagne. In deze nederzettingen vestigden zich ex-slaven, die zich losmaakten van de plantages en het paga terasysteem.\r\n\r\nNaast deze kerkelijke initiatieven waren er ook woonkernen van vrije lieden te Westpunt, San Pedro, Seru Fortuna en Boka Sami.\r\nNaast deze kernen vestigden ontstonden weer andere buurtschappen doordat al in de achttiende eeuw vrije lieden zich verspreid vestigden op de savaangronden. Deze ontwikkeling ging na de afschaffing van de ‎slavernij door. Andere buurtschappen ontstonden doordat de overheid, vooral aan het eind van de negentiende eeuw, percelen domeingrond ging uitgeven. In het begin van de twintigste eeuw kocht de overheid ook plantages op om deze gronden te verkavelen in kleine percelen, waar men een huisje op kon bouwen en aan kleinlandbouw kon doen. Dit gebeurde bijvoorbeeld o.a. in Pannekoek, Dokterstuin, Phlip en Mahoema. De kleinlandbouw leverde in de meeste gevallen niet voldoende op om van te kunnen leven.\r\n\r\nMet de komst van de Shell breidde de stad zelf zich als een inktvlek uit en wel rondom het Schottegat. Naast de zelfbouwactiviteiten van onder andere lokale arbeiders, bouwde de raffinaderij woonwijken voor het hoger en middenkader en voor de buitenlandse werknemers.', '11. De ontwikkeling van bewoning buiten Willemstad', '', 'inherit', 'closed', 'closed', '', '27-revision-v1', '', '', '2018-04-27 19:04:06', '2018-04-27 17:04:06', '', '27', 'https://canoncuracao.cw/27-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('538', '4', '2018-04-27 19:06:13', '2018-04-27 17:06:13', 'Manuel Carlos Piar (1774 – 1817) en Luis Brion (1782-1821) waren tijdgenoten die veel met elkaar gemeen hadden. Om te beginnen hun geboorteplaats, ze werden allebei in Otrobanda geboren. Ook deelden ze de belangrijke ideeën van hun tijd over vrijheid,  gelijkheid en onafhankelijke naties. Beiden verdedigden ze Curaçao tegen een Engelse inval in 1804. Ze steunden beiden Simon Bolívar als de leider van de Zuid-Amerikaanse onafhankelijkheidsstrijd onderscheiden zich beiden door het winnen van belangrijke zee- en veldslagen, Brion werd admiraal onder Bolivar en Piar was een van de belangrijkste generaals van zijn bevrijdingsleger. Beiden waren vrijmetselaar. Beiden stierven een tragische dood: Piar werd terechtgesteld en Brion stierf berooid en in de steek gelaten door Bolívar in Curaçao.\r\n\r\nHun achtergrond verschilt echter aanzienlijk. Luis Brion, zoon van succesvol zakenman Pierre Brion en María Detrox, vertrok al jong als student naar Nederland en streed in 1799 in dienst van het leger van de Bataafse Republiek  tegen de Engelsen. Toen Curaçao bezet was door de Britten (1800-1803) ging hij economie en scheepvaartkunde studeren in de Verenigde Staten. In 1803, nadat het eiland weer in Nederlandse handen was, keerde hij terug naar Curaçao en werd zakenman en reder. In 1805 werd hij benoemd tot commandant op Fort Beekenburg. Hij wist op 20 juni 1806 de Engelsen, die opnieuw probeerden het eiland te veroveren, te verjagen. In 1813 verbond Brion zijn leven aan de onafhankelijkheidsstrijd van Bolívar en werd één van zijn trouwste volgelingen.\r\n\r\nManuel Piar, zoon van María Isabel Gomez, een mulattin, en de zeeman Fernando Piar was, in tegenstelling tot Brion, van eenvoudige komaf. Met zijn moeder en broers vertrok hij als jongen naar Venezuela, waar hij in contact kwam met militairen en jonge revolutionairen. In 1798 was hij in Curaçao waar hij  met Maria Martha Boom trouwde. In 1806 was hij vanuit Aruba betrokken bij een mislukte invasie van Francisco de Miranda in Venezuela. Zijn militaire ervaring stelde hij vanaf 1810 in dienst van de bevrijding van Venezuela.  Hij verschilde echter van strategisch inzicht met Bolívar. Zo wees hij Bolívar er herhaaldelijk op dat voor de bevrijding van Venezuela de bezetting van Guyana nodig was maar Bolívar weigerde dat in te zien. Piar, de hoogste kleurling in de’ independente’ gelederen, veroverde bij de slag bij San Felix op 11 april 1817 Guyana. De eer ging echter naar Bolívar. Piar kon dat niet verkroppen en nam daarom ontslag. Hij werd gearresteerd en door een krijgsraad, onder voorzitterschap van Brion, veroordeeld en met instemming van Bolivar in 1821 geëxecuteerd. In 1827 werd hij echter door Bolívar zelf weer gerehabiliteerd.  Piar en Brion behoren beiden tot de nationale helden van Venezuela. Beelden van de twee Curaçaoënaars staan op een prominente op de Avenida van los Proceres in Caracas.', '12. Brion, Piar en Bolivar', '', 'inherit', 'closed', 'closed', '', '29-revision-v1', '', '', '2018-04-27 19:06:13', '2018-04-27 17:06:13', '', '29', 'https://canoncuracao.cw/29-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('539', '4', '2018-04-27 19:06:56', '2018-04-27 17:06:56', 'Manuel Carlos Piar (1774 – 1817) en Luis Brion (1782-1821) waren tijdgenoten die veel met elkaar gemeen hadden. Om te beginnen hun geboorteplaats, ze werden allebei in Otrobanda geboren. Ook deelden ze de belangrijke ideeën van hun tijd over vrijheid,  gelijkheid en onafhankelijke naties. Beiden verdedigden ze Curaçao tegen een Engelse inval in 1804. Ze steunden beiden Simon Bolívar als de leider van de Zuid-Amerikaanse onafhankelijkheidsstrijd onderscheiden zich beiden door het winnen van belangrijke zee- en veldslagen, Brion werd admiraal onder Bolivar en Piar was een van de belangrijkste generaals van zijn bevrijdingsleger. Beiden waren vrijmetselaar. Beiden stierven een tragische dood: Piar werd terechtgesteld en Brion stierf berooid en in de steek gelaten door Bolívar in Curaçao.\r\n\r\nHun achtergrond verschilt echter aanzienlijk. Luis Brion, zoon van succesvol zakenman Pierre Brion en María Detrox, vertrok al jong als student naar Nederland en streed in 1799 in dienst van het leger van de Bataafse Republiek  tegen de Engelsen. Toen Curaçao bezet was door de Britten (1800-1803) ging hij economie en scheepvaartkunde studeren in de Verenigde Staten. In 1803, nadat het eiland weer in Nederlandse handen was, keerde hij terug naar Curaçao en werd zakenman en reder. In 1805 werd hij benoemd tot commandant op Fort Beekenburg. Hij wist op 20 juni 1806 de Engelsen, die opnieuw probeerden het eiland te veroveren, te verjagen. In 1813 verbond Brion zijn leven aan de onafhankelijkheidsstrijd van Bolívar en werd één van zijn trouwste volgelingen.\r\n\r\nManuel Piar, zoon van María Isabel Gomez, een mulattin, en de zeeman Fernando Piar was, in tegenstelling tot Brion, van eenvoudige komaf. Met zijn moeder en broers vertrok hij als jongen naar Venezuela, waar hij in contact kwam met militairen en jonge revolutionairen. In 1798 was hij in Curaçao waar hij  met Maria Martha Boom trouwde. In 1806 was hij vanuit Aruba betrokken bij een mislukte invasie van Francisco de Miranda in Venezuela. Zijn militaire ervaring stelde hij vanaf 1810 in dienst van de bevrijding van Venezuela.  Hij verschilde echter van strategisch inzicht met Bolívar. Zo wees hij Bolívar er herhaaldelijk op dat voor de bevrijding van Venezuela de bezetting van Guyana nodig was maar Bolívar weigerde dat in te zien. Piar, de hoogste kleurling in de’ independente’ gelederen, veroverde bij de slag bij San Felix op 11 april 1817 Guyana. De eer ging echter naar Bolívar. Piar kon dat niet verkroppen en nam daarom ontslag. Hij werd gearresteerd en door een krijgsraad, onder voorzitterschap van Brion, veroordeeld en met instemming van Bolivar in 1821 geëxecuteerd. In 1827 werd hij echter door Bolívar zelf weer gerehabiliteerd.\r\n\r\nPiar en Brion behoren beiden tot de nationale helden van Venezuela. Beelden van de twee Curaçaoënaars staan op een prominente op de Avenida van los Proceres in Caracas.', '12. Brion, Piar en Bolivar', '', 'inherit', 'closed', 'closed', '', '29-revision-v1', '', '', '2018-04-27 19:06:56', '2018-04-27 17:06:56', '', '29', 'https://canoncuracao.cw/29-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('541', '4', '2018-04-27 19:13:56', '2018-04-27 17:13:56', '', 'simon-bolivar-3', '', 'inherit', 'open', 'closed', '', 'simon-bolivar-3', '', '', '2018-04-27 19:13:56', '2018-04-27 17:13:56', '', '29', 'https://canoncuracao.cw/wp-content/uploads/2017/05/simon-bolivar-3.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('542', '4', '2018-04-27 19:17:10', '2018-04-27 17:17:10', 'Manuel Carlos Piar (1774 – 1817) en Luis Brion (1782-1821) waren tijdgenoten die veel met elkaar gemeen hadden. Om te beginnen hun geboorteplaats, ze werden allebei in Otrobanda geboren. Ook deelden ze de belangrijke ideeën van hun tijd over vrijheid,  gelijkheid en onafhankelijke naties. Beiden verdedigden ze Curaçao tegen een Engelse inval in 1804. Ze steunden beiden Simon Bolívar als de leider van de Zuid-Amerikaanse onafhankelijkheidsstrijd onderscheiden zich beiden door het winnen van belangrijke zee- en veldslagen, Brion werd admiraal onder Bolivar en Piar was een van de belangrijkste generaals van zijn bevrijdingsleger. Beiden waren vrijmetselaar. Beiden stierven een tragische dood: Piar werd terechtgesteld en Brion stierf berooid en in de steek gelaten door Bolívar in Curaçao.\r\n\r\nHun achtergrond verschilt echter aanzienlijk. Luis Brion, zoon van succesvol zakenman Pierre Brion en María Detrox, vertrok al jong als student naar Nederland en streed in 1799 in dienst van het leger van de Bataafse Republiek  tegen de Engelsen. Toen Curaçao bezet was door de Britten (1800-1803) ging hij economie en scheepvaartkunde studeren in de Verenigde Staten. In 1803, nadat het eiland weer in Nederlandse handen was, keerde hij terug naar Curaçao en werd zakenman en reder. In 1805 werd hij benoemd tot commandant op Fort Beekenburg. Hij wist op 20 juni 1806 de Engelsen, die opnieuw probeerden het eiland te veroveren, te verjagen. In 1813 verbond Brion zijn leven aan de onafhankelijkheidsstrijd van Bolívar en werd één van zijn trouwste volgelingen.\r\n\r\nManuel Piar, zoon van María Isabel Gomez, een mulattin, en de zeeman Fernando Piar was, in tegenstelling tot Brion, van eenvoudige komaf. Met zijn moeder en broers vertrok hij als jongen naar Venezuela, waar hij in contact kwam met militairen en jonge revolutionairen. In 1798 was hij in Curaçao waar hij  met Maria Martha Boom trouwde. In 1806 was hij vanuit Aruba betrokken bij een mislukte invasie van Francisco de Miranda in Venezuela. Zijn militaire ervaring stelde hij vanaf 1810 in dienst van de bevrijding van Venezuela.  Hij verschilde echter van strategisch inzicht met Bolívar. Zo wees hij Bolívar er herhaaldelijk op dat voor de bevrijding van Venezuela de bezetting van Guyana nodig was maar Bolívar weigerde dat in te zien. Piar, de hoogste kleurling in de’ independente’ gelederen, veroverde bij de slag bij San Felix op 11 april 1817 Guyana. De eer ging echter naar Bolívar. Piar kon dat niet verkroppen en nam daarom ontslag. Hij werd gearresteerd en door een krijgsraad, onder voorzitterschap van Brion, veroordeeld en met instemming van Bolivar in 1821 geëxecuteerd. In 1827 werd hij echter door Bolívar zelf weer gerehabiliteerd.\r\n\r\nPiar en Brion behoren beiden tot de nationale helden van Venezuela. Beelden van de twee Curaçaoënaars staan op een prominente op de Avenida van los Proceres in Caracas.', '12. Brion, Piar en Bolivar', '', 'inherit', 'closed', 'closed', '', '29-revision-v1', '', '', '2018-04-27 19:17:10', '2018-04-27 17:17:10', '', '29', 'https://canoncuracao.cw/29-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('544', '4', '2018-04-27 19:19:29', '2018-04-27 17:19:29', 'Manuel Carlos Piar (1774 – 1817) en Luis Brion (1782-1821) waren tijdgenoten die veel met elkaar gemeen hadden. Om te beginnen hun geboorteplaats, ze werden allebei in Otrobanda geboren. Ook deelden ze de belangrijke ideeën van hun tijd over vrijheid,  gelijkheid en onafhankelijke naties. Beiden verdedigden ze Curaçao tegen een Engelse inval in 1804. Ze steunden beiden Simon Bolívar als de leider van de Zuid-Amerikaanse onafhankelijkheidsstrijd onderscheiden zich beiden door het winnen van belangrijke zee- en veldslagen, Brion werd admiraal onder Bolivar en Piar was een van de belangrijkste generaals van zijn bevrijdingsleger. Beiden waren vrijmetselaar. Beiden stierven een tragische dood: Piar werd terechtgesteld en Brion stierf berooid en in de steek gelaten door Bolívar in Curaçao.\r\n\r\nHun achtergrond verschilt echter aanzienlijk. Luis Brion, zoon van succesvol zakenman Pierre Brion en María Detrox, vertrok al jong als student naar Nederland en streed in 1799 in dienst van het leger van de Bataafse Republiek  tegen de Engelsen. Toen Curaçao bezet was door de Britten (1800-1803) ging hij economie en scheepvaartkunde studeren in de Verenigde Staten. In 1803, nadat het eiland weer in Nederlandse handen was, keerde hij terug naar Curaçao en werd zakenman en reder. In 1805 werd hij benoemd tot commandant op Fort Beekenburg. Hij wist op 20 juni 1806 de Engelsen, die opnieuw probeerden het eiland te veroveren, te verjagen. In 1813 verbond Brion zijn leven aan de onafhankelijkheidsstrijd van Bolívar en werd één van zijn trouwste volgelingen.\r\n\r\nManuel Piar, zoon van María Isabel Gomez, een mulattin, en de zeeman Fernando Piar was, in tegenstelling tot Brion, van eenvoudige komaf. Met zijn moeder en broers vertrok hij als jongen naar Venezuela, waar hij in contact kwam met militairen en jonge revolutionairen. In 1798 was hij in Curaçao waar hij  met Maria Martha Boom trouwde. In 1806 was hij vanuit Aruba betrokken bij een mislukte invasie van Francisco de Miranda in Venezuela. Zijn militaire ervaring stelde hij vanaf 1810 in dienst van de bevrijding van Venezuela.  Hij verschilde echter van strategisch inzicht met Bolívar. Zo wees hij Bolívar er herhaaldelijk op dat voor de bevrijding van Venezuela de bezetting van Guyana nodig was maar Bolívar weigerde dat in te zien. Piar, de hoogste kleurling in de’ independente’ gelederen, veroverde bij de slag bij San Felix op 11 april 1817 Guyana. De eer ging echter naar Bolívar. Piar kon dat niet verkroppen en nam daarom ontslag. Hij werd gearresteerd en door een krijgsraad, onder voorzitterschap van Brion, veroordeeld en met instemming van Bolivar in 1821 geëxecuteerd. In 1827 werd hij echter door Bolívar zelf weer gerehabiliteerd.\r\n\r\nPiar en Brion behoren beiden tot de nationale helden van Venezuela. Beelden van de twee Curaçaoënaars staan op een prominente op de Avenida van los Proceres in Caracas.', '12. Brion, Piar en Bolivar', '', 'inherit', 'closed', 'closed', '', '29-revision-v1', '', '', '2018-04-27 19:19:29', '2018-04-27 17:19:29', '', '29', 'https://canoncuracao.cw/29-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('546', '4', '2018-04-27 19:21:19', '2018-04-27 17:21:19', 'Manuel Carlos Piar (1774 – 1817) en Luis Brion (1782-1821) waren tijdgenoten die veel met elkaar gemeen hadden. Om te beginnen hun geboorteplaats, ze werden allebei in Otrobanda geboren. Ook deelden ze de belangrijke ideeën van hun tijd over vrijheid,  gelijkheid en onafhankelijke naties. Beiden verdedigden ze Curaçao tegen een Engelse inval in 1804. Ze steunden beiden Simon Bolívar als de leider van de Zuid-Amerikaanse onafhankelijkheidsstrijd onderscheiden zich beiden door het winnen van belangrijke zee- en veldslagen, Brion werd admiraal onder Bolivar en Piar was een van de belangrijkste generaals van zijn bevrijdingsleger. Beiden waren vrijmetselaar. Beiden stierven een tragische dood: Piar werd terechtgesteld en Brion stierf berooid en in de steek gelaten door Bolívar in Curaçao.\r\n\r\nHun achtergrond verschilt echter aanzienlijk. Luis Brion, zoon van succesvol zakenman Pierre Brion en María Detrox, vertrok al jong als student naar Nederland en streed in 1799 in dienst van het leger van de Bataafse Republiek  tegen de Engelsen. Toen Curaçao bezet was door de Britten (1800-1803) ging hij economie en scheepvaartkunde studeren in de Verenigde Staten. In 1803, nadat het eiland weer in Nederlandse handen was, keerde hij terug naar Curaçao en werd zakenman en reder. In 1805 werd hij benoemd tot commandant op Fort Beekenburg. Hij wist op 20 juni 1806 de Engelsen, die opnieuw probeerden het eiland te veroveren, te verjagen. In 1813 verbond Brion zijn leven aan de onafhankelijkheidsstrijd van Bolívar en werd één van zijn trouwste volgelingen.\r\n\r\nManuel Piar, zoon van María Isabel Gomez, een mulattin, en de zeeman Fernando Piar was, in tegenstelling tot Brion, van eenvoudige komaf. Met zijn moeder en broers vertrok hij als jongen naar Venezuela, waar hij in contact kwam met militairen en jonge revolutionairen. In 1798 was hij in Curaçao waar hij  met Maria Martha Boom trouwde. In 1806 was hij vanuit Aruba betrokken bij een mislukte invasie van Francisco de Miranda in Venezuela. Zijn militaire ervaring stelde hij vanaf 1810 in dienst van de bevrijding van Venezuela.  Hij verschilde echter van strategisch inzicht met Bolívar. Zo wees hij Bolívar er herhaaldelijk op dat voor de bevrijding van Venezuela de bezetting van Guyana nodig was maar Bolívar weigerde dat in te zien. Piar, de hoogste kleurling in de’ independente’ gelederen, veroverde bij de slag bij San Felix op 11 april 1817 Guyana. De eer ging echter naar Bolívar. Piar kon dat niet verkroppen en nam daarom ontslag. Hij werd gearresteerd en door een krijgsraad, onder voorzitterschap van Brion, veroordeeld en met instemming van Bolivar in 1821 geëxecuteerd. In 1827 werd hij echter door Bolívar zelf weer gerehabiliteerd.\r\n\r\nPiar en Brion behoren beiden tot de nationale helden van Venezuela. Beelden van de twee Curaçaoënaars staan op een prominente op de Avenida van los Proceres in Caracas.', '12. Brion, Piar en Bolivar', '', 'inherit', 'closed', 'closed', '', '29-revision-v1', '', '', '2018-04-27 19:21:19', '2018-04-27 17:21:19', '', '29', 'https://canoncuracao.cw/29-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('547', '4', '2018-04-27 19:23:58', '2018-04-27 17:23:58', '', 'H3 6 piar', '', 'inherit', 'open', 'closed', '', 'h3-6-piar', '', '', '2018-04-27 19:23:58', '2018-04-27 17:23:58', '', '29', 'https://canoncuracao.cw/wp-content/uploads/2017/05/H3-6-piar.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('548', '4', '2018-04-27 19:24:06', '2018-04-27 17:24:06', 'Manuel Carlos Piar (1774 – 1817) en Luis Brion (1782-1821) waren tijdgenoten die veel met elkaar gemeen hadden. Om te beginnen hun geboorteplaats, ze werden allebei in Otrobanda geboren. Ook deelden ze de belangrijke ideeën van hun tijd over vrijheid,  gelijkheid en onafhankelijke naties. Beiden verdedigden ze Curaçao tegen een Engelse inval in 1804. Ze steunden beiden Simon Bolívar als de leider van de Zuid-Amerikaanse onafhankelijkheidsstrijd onderscheiden zich beiden door het winnen van belangrijke zee- en veldslagen, Brion werd admiraal onder Bolivar en Piar was een van de belangrijkste generaals van zijn bevrijdingsleger. Beiden waren vrijmetselaar. Beiden stierven een tragische dood: Piar werd terechtgesteld en Brion stierf berooid en in de steek gelaten door Bolívar in Curaçao.\r\n\r\nHun achtergrond verschilt echter aanzienlijk. Luis Brion, zoon van succesvol zakenman Pierre Brion en María Detrox, vertrok al jong als student naar Nederland en streed in 1799 in dienst van het leger van de Bataafse Republiek  tegen de Engelsen. Toen Curaçao bezet was door de Britten (1800-1803) ging hij economie en scheepvaartkunde studeren in de Verenigde Staten. In 1803, nadat het eiland weer in Nederlandse handen was, keerde hij terug naar Curaçao en werd zakenman en reder. In 1805 werd hij benoemd tot commandant op Fort Beekenburg. Hij wist op 20 juni 1806 de Engelsen, die opnieuw probeerden het eiland te veroveren, te verjagen. In 1813 verbond Brion zijn leven aan de onafhankelijkheidsstrijd van Bolívar en werd één van zijn trouwste volgelingen.\r\n\r\nManuel Piar, zoon van María Isabel Gomez, een mulattin, en de zeeman Fernando Piar was, in tegenstelling tot Brion, van eenvoudige komaf. Met zijn moeder en broers vertrok hij als jongen naar Venezuela, waar hij in contact kwam met militairen en jonge revolutionairen. In 1798 was hij in Curaçao waar hij  met Maria Martha Boom trouwde. In 1806 was hij vanuit Aruba betrokken bij een mislukte invasie van Francisco de Miranda in Venezuela. Zijn militaire ervaring stelde hij vanaf 1810 in dienst van de bevrijding van Venezuela.  Hij verschilde echter van strategisch inzicht met Bolívar. Zo wees hij Bolívar er herhaaldelijk op dat voor de bevrijding van Venezuela de bezetting van Guyana nodig was maar Bolívar weigerde dat in te zien. Piar, de hoogste kleurling in de’ independente’ gelederen, veroverde bij de slag bij San Felix op 11 april 1817 Guyana. De eer ging echter naar Bolívar. Piar kon dat niet verkroppen en nam daarom ontslag. Hij werd gearresteerd en door een krijgsraad, onder voorzitterschap van Brion, veroordeeld en met instemming van Bolivar in 1821 geëxecuteerd. In 1827 werd hij echter door Bolívar zelf weer gerehabiliteerd.\r\n\r\nPiar en Brion behoren beiden tot de nationale helden van Venezuela. Beelden van de twee Curaçaoënaars staan op een prominente op de Avenida van los Proceres in Caracas.', '12. Brion, Piar en Bolivar', '', 'inherit', 'closed', 'closed', '', '29-revision-v1', '', '', '2018-04-27 19:24:06', '2018-04-27 17:24:06', '', '29', 'https://canoncuracao.cw/29-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('549', '4', '2018-04-27 19:24:59', '2018-04-27 17:24:59', 'Manuel Carlos Piar (1774 – 1817) en Luis Brion (1782-1821) waren tijdgenoten die veel met elkaar gemeen hadden. Om te beginnen hun geboorteplaats, ze werden allebei in Otrobanda geboren. Ook deelden ze de belangrijke ideeën van hun tijd over vrijheid,  gelijkheid en onafhankelijke naties. Beiden verdedigden ze Curaçao tegen een Engelse inval in 1804. Ze steunden beiden Simon Bolívar als de leider van de Zuid-Amerikaanse onafhankelijkheidsstrijd onderscheiden zich beiden door het winnen van belangrijke zee- en veldslagen, Brion werd admiraal onder Bolivar en Piar was een van de belangrijkste generaals van zijn bevrijdingsleger. Beiden waren vrijmetselaar. Beiden stierven een tragische dood: Piar werd terechtgesteld en Brion stierf berooid en in de steek gelaten door Bolívar in Curaçao.\r\n\r\nHun achtergrond verschilt echter aanzienlijk. Luis Brion, zoon van succesvol zakenman Pierre Brion en María Detrox, vertrok al jong als student naar Nederland en streed in 1799 in dienst van het leger van de Bataafse Republiek  tegen de Engelsen. Toen Curaçao bezet was door de Britten (1800-1803) ging hij economie en scheepvaartkunde studeren in de Verenigde Staten. In 1803, nadat het eiland weer in Nederlandse handen was, keerde hij terug naar Curaçao en werd zakenman en reder. In 1805 werd hij benoemd tot commandant op Fort Beekenburg. Hij wist op 20 juni 1806 de Engelsen, die opnieuw probeerden het eiland te veroveren, te verjagen. In 1813 verbond Brion zijn leven aan de onafhankelijkheidsstrijd van Bolívar en werd één van zijn trouwste volgelingen.\r\n\r\nManuel Piar, zoon van María Isabel Gomez, een mulattin, en de zeeman Fernando Piar was, in tegenstelling tot Brion, van eenvoudige komaf. Met zijn moeder en broers vertrok hij als jongen naar Venezuela, waar hij in contact kwam met militairen en jonge revolutionairen. In 1798 was hij in Curaçao waar hij  met Maria Martha Boom trouwde. In 1806 was hij vanuit Aruba betrokken bij een mislukte invasie van Francisco de Miranda in Venezuela. Zijn militaire ervaring stelde hij vanaf 1810 in dienst van de bevrijding van Venezuela.  Hij verschilde echter van strategisch inzicht met Bolívar. Zo wees hij Bolívar er herhaaldelijk op dat voor de bevrijding van Venezuela de bezetting van Guyana nodig was maar Bolívar weigerde dat in te zien. Piar, de hoogste kleurling in de’ independente’ gelederen, veroverde bij de slag bij San Felix op 11 april 1817 Guyana. De eer ging echter naar Bolívar. Piar kon dat niet verkroppen en nam daarom ontslag. Hij werd gearresteerd en door een krijgsraad, onder voorzitterschap van Brion, veroordeeld en met instemming van Bolivar in 1821 geëxecuteerd. In 1827 werd hij echter door Bolívar zelf weer gerehabiliteerd.\r\n\r\nPiar en Brion behoren beiden tot de nationale helden van Venezuela. Beelden van de twee Curaçaoënaars staan op een prominente op de Avenida van los Proceres in Caracas.', '12. Brion, Piar en Bolivar', '', 'inherit', 'closed', 'closed', '', '29-revision-v1', '', '', '2018-04-27 19:24:59', '2018-04-27 17:24:59', '', '29', 'https://canoncuracao.cw/29-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('550', '4', '2018-04-27 19:25:48', '2018-04-27 17:25:48', 'Manuel Carlos Piar (1774 – 1817) en Luis Brion (1782-1821) waren tijdgenoten die veel met elkaar gemeen hadden. Om te beginnen hun geboorteplaats, ze werden allebei in Otrobanda geboren. Ook deelden ze de belangrijke ideeën van hun tijd over vrijheid,  gelijkheid en onafhankelijke naties. Beiden verdedigden ze Curaçao tegen een Engelse inval in 1804. Ze steunden beiden Simon Bolívar als de leider van de Zuid-Amerikaanse onafhankelijkheidsstrijd onderscheiden zich beiden door het winnen van belangrijke zee- en veldslagen, Brion werd admiraal onder Bolivar en Piar was een van de belangrijkste generaals van zijn bevrijdingsleger. Beiden waren vrijmetselaar. Beiden stierven een tragische dood: Piar werd terechtgesteld en Brion stierf berooid en in de steek gelaten door Bolívar in Curaçao.\r\n\r\nHun achtergrond verschilt echter aanzienlijk. Luis Brion, zoon van succesvol zakenman Pierre Brion en María Detrox, vertrok al jong als student naar Nederland en streed in 1799 in dienst van het leger van de Bataafse Republiek  tegen de Engelsen. Toen Curaçao bezet was door de Britten (1800-1803) ging hij economie en scheepvaartkunde studeren in de Verenigde Staten. In 1803, nadat het eiland weer in Nederlandse handen was, keerde hij terug naar Curaçao en werd zakenman en reder. In 1805 werd hij benoemd tot commandant op Fort Beekenburg. Hij wist op 20 juni 1806 de Engelsen, die opnieuw probeerden het eiland te veroveren, te verjagen. In 1813 verbond Brion zijn leven aan de onafhankelijkheidsstrijd van Bolívar en werd één van zijn trouwste volgelingen.\r\n\r\nManuel Piar, zoon van María Isabel Gomez, een mulattin, en de zeeman Fernando Piar was, in tegenstelling tot Brion, van eenvoudige komaf. Met zijn moeder en broers vertrok hij als jongen naar Venezuela, waar hij in contact kwam met militairen en jonge revolutionairen. In 1798 was hij in Curaçao waar hij  met Maria Martha Boom trouwde. In 1806 was hij vanuit Aruba betrokken bij een mislukte invasie van Francisco de Miranda in Venezuela. Zijn militaire ervaring stelde hij vanaf 1810 in dienst van de bevrijding van Venezuela.  Hij verschilde echter van strategisch inzicht met Bolívar. Zo wees hij Bolívar er herhaaldelijk op dat voor de bevrijding van Venezuela de bezetting van Guyana nodig was maar Bolívar weigerde dat in te zien. Piar, de hoogste kleurling in de’ independente’ gelederen, veroverde bij de slag bij San Felix op 11 april 1817 Guyana. De eer ging echter naar Bolívar. Piar kon dat niet verkroppen en nam daarom ontslag. Hij werd gearresteerd en door een krijgsraad, onder voorzitterschap van Brion, veroordeeld en met instemming van Bolivar in 1821 geëxecuteerd. In 1827 werd hij echter door Bolívar zelf weer gerehabiliteerd.\r\n\r\nPiar en Brion behoren beiden tot de nationale helden van Venezuela. Beelden van de twee Curaçaoënaars staan op een prominente op de Avenida van los Proceres in Caracas.', '12. Brion, Piar en Bolivar', '', 'inherit', 'closed', 'closed', '', '29-revision-v1', '', '', '2018-04-27 19:25:48', '2018-04-27 17:25:48', '', '29', 'https://canoncuracao.cw/29-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('551', '4', '2018-04-27 19:32:30', '2018-04-27 17:32:30', 'In 1634 veroverde de West Indische Compagnie het eiland Curaçao. De W.I.C begon al snel met het opzetten van compagnieplantages met als doel het voedsel te verbouwen voor hun personeel en de als slaaf hierheen gebrachte Afrikanen. Naast deze compagnieplantages kwamen er al zeer snel particuliere plantages. Vrienden en familieleden van de bestuurders kregen grote terreinen in bruikleen en al heel snel was het grootste deel van Curacao onderverdeeld in plantages.\r\n\r\nDeze grote landbouwbedrijven oefenden een vorm van gemengd bedrijf uit. Normaal gesproken bestond zo’n bedrijf uit drie onderdelen: een hofje, onbewerkt land (de ‘mondi’) en akkers die in de regentijd werden gebruikt (de ‘kunuku’s).\r\n\r\nHet hofje was bijna altijd gelegen aan het uiteinde van een rooistelsel, waar de verweringslaag veel dikker was en waar de grondwaterspiegel het hoogst was. Daar plantte men de vruchtbomen en werd er wat groente gekweekt. De mondi werd gebruikt om schapen, geiten en koeien te laten grazen. Daarnaast waren er akkertjes voor de regenafhankelijke akkerbouw. Het gewas dat op deze akkers verbouwd werd, was het droogtebestendige sorghum (‘maishi chiki’), afkomstig uit West-Afrika. Als het regenseizoen (van november tot januari) goed was, werd er veel geproduceerd, maar zeer vaak viel het regenseizoen tegen en mislukte de oogst.   De maishi chiki was met name bestemd voor de bewoners van de plantage, zowel voor de tot slaaf gemaakte oorspronkelijk Afrikaanse bevolking en voor de eigenaarsfamilie. Hier werd het volksvoedsel ‘funchi’ van gemaakt. Inkomen verkreeg men door de verkoop van vee en melkproducten en de verkoop van fruit.\r\n\r\nDe meeste plantages waren niet erg rendabel, maar het bezit van een plantage was zeer belangrijk voor de status van de eigenaren.\r\n\r\nDe eigenaren behoorden meestal tot de groep van de “hoge blanke protestanten” en zij woonden meestal in de landhuizen.   De werkbevolking bestond oorspronkelijk uit tot slaaf gemaakte Afrikanen. Zij woonden in een buurtgemeenschap, gebouwd uit “kas di pal’i maishi” (eenvoudige lemen huisjes met een rieten dak) . Na de afschaffing van de slavernij in 1863 bleven vele ex-slaven op de plantages wonen met de verplichting om een aantal dagen in het jaar voor de plantage-eigenaar te werken (het zogenaamde ‘paga tera-systeem’).', '13. Het plantagesysteem op Curaçao', '', 'inherit', 'closed', 'closed', '', '31-revision-v1', '', '', '2018-04-27 19:32:30', '2018-04-27 17:32:30', '', '31', 'https://canoncuracao.cw/31-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('552', '4', '2018-04-27 19:39:03', '2018-04-27 17:39:03', '', 'H3 Intereur Savonet1', '', 'inherit', 'open', 'closed', '', 'h3-intereur-savonet1', '', '', '2018-04-27 19:39:08', '2018-04-27 17:39:08', '', '31', 'https://canoncuracao.cw/wp-content/uploads/2017/05/H3-Intereur-Savonet1.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('553', '4', '2018-04-27 19:40:11', '2018-04-27 17:40:11', 'In 1634 veroverde de West Indische Compagnie het eiland Curaçao. De W.I.C begon al snel met het opzetten van compagnieplantages met als doel het voedsel te verbouwen voor hun personeel en de als slaaf hierheen gebrachte Afrikanen. Naast deze compagnieplantages kwamen er al zeer snel particuliere plantages. Vrienden en familieleden van de bestuurders kregen grote terreinen in bruikleen en al heel snel was het grootste deel van Curacao onderverdeeld in plantages.\r\n\r\nDeze grote landbouwbedrijven oefenden een vorm van gemengd bedrijf uit. Normaal gesproken bestond zo’n bedrijf uit drie onderdelen: een hofje, onbewerkt land (de ‘mondi’) en akkers die in de regentijd werden gebruikt (de ‘kunuku’s).\r\n\r\nHet hofje was bijna altijd gelegen aan het uiteinde van een rooistelsel, waar de verweringslaag veel dikker was en waar de grondwaterspiegel het hoogst was. Daar plantte men de vruchtbomen en werd er wat groente gekweekt. De mondi werd gebruikt om schapen, geiten en koeien te laten grazen. Daarnaast waren er akkertjes voor de regenafhankelijke akkerbouw. Het gewas dat op deze akkers verbouwd werd, was het droogtebestendige sorghum (‘maishi chiki’), afkomstig uit West-Afrika. Als het regenseizoen (van november tot januari) goed was, werd er veel geproduceerd, maar zeer vaak viel het regenseizoen tegen en mislukte de oogst.   De maishi chiki was met name bestemd voor de bewoners van de plantage, zowel voor de tot slaaf gemaakte oorspronkelijk Afrikaanse bevolking en voor de eigenaarsfamilie. Hier werd het volksvoedsel ‘funchi’ van gemaakt. Inkomen verkreeg men door de verkoop van vee en melkproducten en de verkoop van fruit.\r\n\r\nDe meeste plantages waren niet erg rendabel, maar het bezit van een plantage was zeer belangrijk voor de status van de eigenaren.\r\n\r\nDe eigenaren behoorden meestal tot de groep van de “hoge blanke protestanten” en zij woonden meestal in de landhuizen.   De werkbevolking bestond oorspronkelijk uit tot slaaf gemaakte Afrikanen. Zij woonden in een buurtgemeenschap, gebouwd uit “kas di pal’i maishi” (eenvoudige lemen huisjes met een rieten dak) . Na de afschaffing van de slavernij in 1863 bleven vele ex-slaven op de plantages wonen met de verplichting om een aantal dagen in het jaar voor de plantage-eigenaar te werken (het zogenaamde ‘paga tera-systeem’).', '13. Het plantagesysteem op Curaçao', '', 'inherit', 'closed', 'closed', '', '31-revision-v1', '', '', '2018-04-27 19:40:11', '2018-04-27 17:40:11', '', '31', 'https://canoncuracao.cw/31-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('554', '4', '2020-01-28 16:25:33', '2020-01-28 15:25:33', 'In 1634 veroverde de <a href=\"https://canoncuracao.cw/3-verovering-van-curacao-door-de-wic-en-de-komst-van-de-hollanders/\">West-Indische Compagnie</a> het eiland Curaçao. De W.I.C. begon al snel met het opzetten van compagnieplantages met als doel het voedsel te verbouwen voor hun personeel en de als <a href=\"https://canoncuracao.cw/5-de-slavenhandel-en-slaverij/\">tot slaaf gemaakte</a> hierheen gebrachte Afrikanen. Naast deze compagnieplantages kwamen er al zeer snel particuliere plantages. Vrienden en familieleden van de bestuurders kregen grote terreinen in bruikleen en al heel snel was het grootste deel van Curaçao onderverdeeld in plantages.\n\nDeze grote landbouwbedrijven oefenden een vorm van gemengd bedrijf uit. Normaal gesproken bestond zo’n bedrijf uit drie onderdelen: een hofje, onbewerkt land (de ‘mondi’) en akkers die in de regentijd werden gebruikt (de ‘kunuku’s).\n\nHet hofje was bijna altijd gelegen aan het uiteinde van een rooistelsel, waar de verweringslaag veel dikker was en waar de grondwaterspiegel het hoogst was. Daar plantte men de vruchtbomen en werd er wat groente gekweekt. De mondi werd gebruikt om schapen, geiten en koeien te laten grazen. Daarnaast waren er akkertjes voor de regenafhankelijke akkerbouw. Het gewas dat op deze akkers verbouwd werd, was het droogtebestendige sorghum (‘maishi chikí’), afkomstig uit West-Afrika. Als het regenseizoen (van november tot januari) goed was, werd er veel geproduceerd, maar zeer vaak viel het regenseizoen tegen en mislukte de oogst. De maishi chikíwas met name bestemd voor de bewoners van de plantage, zowel voor de tot slaaf gemaakte oorspronkelijk Afrikaanse bevolking als voor de eigenaarsfamilie. Hier werd het volksvoedsel ‘funchi’ van gemaakt. Inkomen verkreeg men door de verkoop van vee en melkproducten, fruit, houtskool, watapana peulen, die gebruikt werden bij het vervaardigen van looistof. Op sommige plantages werd ook verdiend aan de zoutwinning.\n\nDe meeste plantages waren niet erg rendabel, maar het bezit van een plantage was zeer belangrijk voor de status van de eigenaren.\n\nDe eigenaren behoorden meestal tot de groep van “hoge <a href=\"https://canoncuracao.cw/15-opbouw-samenleving-19e-eeuw-verschillende-bevolkingsgroepen/\">blanke protestanten</a>” en zij woonden meestal in de landhuizen. De werkbevolking bestond oorspronkelijk uit tot slaaf gemaakte Afrikanen. Zij woonden in een buurtgemeenschap, gebouwd uit <em>kas di pal’i maishi</em> (eenvoudige huisjes, meestal met leem bestreken en met een dak dat meestal bestond uit maisstengels). Na de afschaffing van de <a href=\"https://canoncuracao.cw/5-de-slavenhandel-en-slaverij/\">slavernij</a> in 1863 bleven vele ex-slaven op de plantages wonen met de verplichting om een aantal dagen in het jaar voor de plantage-eigenaar te werken (het zogenaamde <em>paga tera-systeem</em>).', '13. Het plantagesysteem op Curaçao', '', 'inherit', 'closed', 'closed', '', '31-autosave-v1', '', '', '2020-01-28 16:25:33', '2020-01-28 15:25:33', '', '31', 'https://canoncuracao.cw/31-autosave-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('555', '4', '2018-04-27 19:42:50', '2018-04-27 17:42:50', '', 'Zout001', '', 'inherit', 'open', 'closed', '', 'zout001', '', '', '2018-04-27 19:42:54', '2018-04-27 17:42:54', '', '31', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Zout001.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('556', '4', '2018-04-27 19:43:42', '2018-04-27 17:43:42', 'In 1634 veroverde de West Indische Compagnie het eiland Curaçao. De W.I.C begon al snel met het opzetten van compagnieplantages met als doel het voedsel te verbouwen voor hun personeel en de als slaaf hierheen gebrachte Afrikanen. Naast deze compagnieplantages kwamen er al zeer snel particuliere plantages. Vrienden en familieleden van de bestuurders kregen grote terreinen in bruikleen en al heel snel was het grootste deel van Curacao onderverdeeld in plantages.\r\n\r\nDeze grote landbouwbedrijven oefenden een vorm van gemengd bedrijf uit. Normaal gesproken bestond zo’n bedrijf uit drie onderdelen: een hofje, onbewerkt land (de ‘mondi’) en akkers die in de regentijd werden gebruikt (de ‘kunuku’s).\r\n\r\nHet hofje was bijna altijd gelegen aan het uiteinde van een rooistelsel, waar de verweringslaag veel dikker was en waar de grondwaterspiegel het hoogst was. Daar plantte men de vruchtbomen en werd er wat groente gekweekt. De mondi werd gebruikt om schapen, geiten en koeien te laten grazen. Daarnaast waren er akkertjes voor de regenafhankelijke akkerbouw. Het gewas dat op deze akkers verbouwd werd, was het droogtebestendige sorghum (‘maishi chiki’), afkomstig uit West-Afrika. Als het regenseizoen (van november tot januari) goed was, werd er veel geproduceerd, maar zeer vaak viel het regenseizoen tegen en mislukte de oogst. De maishi chiki was met name bestemd voor de bewoners van de plantage, zowel voor de tot slaaf gemaakte oorspronkelijk Afrikaanse bevolking en voor de eigenaarsfamilie. Hier werd het volksvoedsel ‘funchi’ van gemaakt. Inkomen verkreeg men door de verkoop van vee en melkproducten en de verkoop van fruit.\r\n\r\nDe meeste plantages waren niet erg rendabel, maar het bezit van een plantage was zeer belangrijk voor de status van de eigenaren.\r\n\r\nDe eigenaren behoorden meestal tot de groep van de “hoge blanke protestanten” en zij woonden meestal in de landhuizen.   De werkbevolking bestond oorspronkelijk uit tot slaaf gemaakte Afrikanen. Zij woonden in een buurtgemeenschap, gebouwd uit “kas di pal’i maishi” (eenvoudige lemen huisjes met een rieten dak) . Na de afschaffing van de slavernij in 1863 bleven vele ex-slaven op de plantages wonen met de verplichting om een aantal dagen in het jaar voor de plantage-eigenaar te werken (het zogenaamde ‘paga tera-systeem’).', '13. Het plantagesysteem op Curaçao', '', 'inherit', 'closed', 'closed', '', '31-revision-v1', '', '', '2018-04-27 19:43:42', '2018-04-27 17:43:42', '', '31', 'https://canoncuracao.cw/31-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('557', '4', '2018-04-27 19:49:30', '2018-04-27 17:49:30', 'In 1634 veroverde de West Indische Compagnie het eiland Curaçao. De W.I.C begon al snel met het opzetten van compagnieplantages met als doel het voedsel te verbouwen voor hun personeel en de als slaaf hierheen gebrachte Afrikanen. Naast deze compagnieplantages kwamen er al zeer snel particuliere plantages. Vrienden en familieleden van de bestuurders kregen grote terreinen in bruikleen en al heel snel was het grootste deel van Curaçao onderverdeeld in plantages.\r\n\r\n&nbsp;\r\n\r\nDeze grote landbouwbedrijven oefenden een vorm van gemengd bedrijf uit. Normaal gesproken bestond zo’n bedrijf uit drie onderdelen: een hofje, onbewerkt land (de ‘mondi’) en akkers die in de regentijd werden gebruikt (de ‘kunuku’s).\r\n\r\n&nbsp;\r\n\r\nHet hofje was bijna altijd gelegen aan het uiteinde van een rooistelsel, waar de verweringslaag veel dikker was en waar de grondwaterspiegel het hoogst was. Daar plantte men de vruchtbomen  en werd er wat groente gekweekt. De mondi werd gebruikt om schapen, geiten en koeien te laten grazen. Daarnaast waren er akkertjes voor de regenafhankelijke akkerbouw. Het gewas dat op deze akkers verbouwd werd, was het droogtebestendige sorghum (‘maishi chiki’), afkomstig uit West-Afrika. Als het regenseizoen (van november tot januari) goed was, werd er veel geproduceerd, maar zeer vaak viel het regenseizoen tegen en mislukte de oogst. De maishi chiki was met name bestemd voor de bewoners van de plantage, zowel voor de tot slaaf gemaakte oorspronkelijk Afrikaanse bevolking en voor de eigenaarsfamilie. Hier werd het volksvoedsel ‘funchi’ van gemaakt. Inkomen verkreeg men door de verkoop van vee en melkproducten en de verkoop van fruit.\r\n\r\n&nbsp;\r\n\r\nDe meeste plantages waren niet erg rendabel, maar het bezit van een plantage was zeer belangrijk voor de status van de eigenaren.\r\n\r\nDe eigenaren behoorden meestal tot de groep van de “hoge blanke protestanten” en zij woonden meestal in de landhuizen. De werkbevolking bestond oorspronkelijk uit tot slaaf gemaakte Afrikanen. Zij woonden in een buurtgemeenschap, gebouwd uit “kas di pal’i maishi” (eenvoudige lemen huisjes met een rieten dak). Na de afschaffing van de slavernij in 1863 bleven vele ex-slaven op de plantages wonen met de verplichting om een aantal dagen in het jaar voor de plantage-eigenaar te werken (het zogenaamde ‘paga tera-systeem’).', '13. Het plantagesysteem op Curaçao', '', 'inherit', 'closed', 'closed', '', '31-revision-v1', '', '', '2018-04-27 19:49:30', '2018-04-27 17:49:30', '', '31', 'https://canoncuracao.cw/31-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('558', '4', '2018-04-27 20:01:44', '2018-04-27 18:01:44', '', 'Interieur2', '', 'inherit', 'open', 'closed', '', 'interieur2', '', '', '2018-04-27 20:01:47', '2018-04-27 18:01:47', '', '31', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Interieur2.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('559', '4', '2018-04-27 20:02:36', '2018-04-27 18:02:36', 'In 1634 veroverde de West Indische Compagnie het eiland Curaçao. De W.I.C begon al snel met het opzetten van compagnieplantages met als doel het voedsel te verbouwen voor hun personeel en de als slaaf hierheen gebrachte Afrikanen. Naast deze compagnieplantages kwamen er al zeer snel particuliere plantages. Vrienden en familieleden van de bestuurders kregen grote terreinen in bruikleen en al heel snel was het grootste deel van Curaçao onderverdeeld in plantages.\r\n\r\n&nbsp;\r\n\r\nDeze grote landbouwbedrijven oefenden een vorm van gemengd bedrijf uit. Normaal gesproken bestond zo’n bedrijf uit drie onderdelen: een hofje, onbewerkt land (de ‘mondi’) en akkers die in de regentijd werden gebruikt (de ‘kunuku’s).\r\n\r\n&nbsp;\r\n\r\nHet hofje was bijna altijd gelegen aan het uiteinde van een rooistelsel, waar de verweringslaag veel dikker was en waar de grondwaterspiegel het hoogst was. Daar plantte men de vruchtbomen  en werd er wat groente gekweekt. De mondi werd gebruikt om schapen, geiten en koeien te laten grazen. Daarnaast waren er akkertjes voor de regenafhankelijke akkerbouw. Het gewas dat op deze akkers verbouwd werd, was het droogtebestendige sorghum (‘maishi chiki’), afkomstig uit West-Afrika. Als het regenseizoen (van november tot januari) goed was, werd er veel geproduceerd, maar zeer vaak viel het regenseizoen tegen en mislukte de oogst. De maishi chiki was met name bestemd voor de bewoners van de plantage, zowel voor de tot slaaf gemaakte oorspronkelijk Afrikaanse bevolking en voor de eigenaarsfamilie. Hier werd het volksvoedsel ‘funchi’ van gemaakt. Inkomen verkreeg men door de verkoop van vee en melkproducten en de verkoop van fruit.\r\n\r\n&nbsp;\r\n\r\nDe meeste plantages waren niet erg rendabel, maar het bezit van een plantage was zeer belangrijk voor de status van de eigenaren.\r\n\r\nDe eigenaren behoorden meestal tot de groep van de “hoge blanke protestanten” en zij woonden meestal in de landhuizen. De werkbevolking bestond oorspronkelijk uit tot slaaf gemaakte Afrikanen. Zij woonden in een buurtgemeenschap, gebouwd uit “kas di pal’i maishi” (eenvoudige lemen huisjes met een rieten dak). Na de afschaffing van de slavernij in 1863 bleven vele ex-slaven op de plantages wonen met de verplichting om een aantal dagen in het jaar voor de plantage-eigenaar te werken (het zogenaamde ‘paga tera-systeem’).', '13. Het plantagesysteem op Curaçao', '', 'inherit', 'closed', 'closed', '', '31-revision-v1', '', '', '2018-04-27 20:02:36', '2018-04-27 18:02:36', '', '31', 'https://canoncuracao.cw/31-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('560', '4', '2018-04-27 20:12:48', '2018-04-27 18:12:48', 'Op 1 juli 1863 kondigde Koning Willem III de vrijheid van  slavernij  in de Nederlandse kolonies af. Ongeveer een derde deel van de totale bevolking van Curaçao verkreeg op dat moment de vrijheid. De slaveneigenaars  kregen een vergoeding van Nafl. 200,-- voor het vrijlaten van iedere slaafgemaakte, maar de ex-slaafgemaakten kregen zelf niets. In tegenstelling tot in Suriname bestond op Curaçao niet de verplichting om onder staatstoezicht nog tien jaar te werken voor een plantage-eigenaar.\r\n\r\n&nbsp;\r\n\r\nDirect na de emancipatie was het moeilijk een stuk grond krijgen voor het verbouwen van eigen voedsel en het bouwen van een huis. De meeste vruchtbare gronden waren reeds in handen van de plantage-eigenaren. Sommige ex-slaafgemaakten bleven om die reden bij de ’shons’ (plantage-eigenaren) wonen op basis van het zogenoemde <em>‘paga tera’</em> systeem, waarbij zij verplicht waren in ruil voor dit stuk grond  een aantal dagen per jaar onbetaald voor de plantagehouders te werken. Ook dienden ze, op het moment dat de maïs geoogst was, de shon dit te laten weten, zodat hij de koeien langs kon sturen om de stengels te eten. Als men weigerde om zich te houden aan deze  <em>paga tera</em> verplichting, doordat men  bijvoorbeeld ergens anders werkte, kreeg men de zogenaamde <em>ora di porta</em>, waarbij  men de aanzegging kreeg om binnen 24 uur te vertrekken van de plantage. Men moest dan met het gezin heel snel ergens anders onderdak zien te vinden.\r\n\r\n&nbsp;\r\n\r\nHet bezit van een stuk grond was voor velen een garantie voor de fel begeerde onafhankelijkheid ten opzichte van de plantagehouders. Tegen het einde van de negentiende eeuw begon de overheid een actief beleid te voeren om gouvernementsgronden aan particulieren te verhuren. (Zie <a href=\"https://canoncuracao.cw/11-ontwikkeling-nederzettingen-en-barios-buiten-willemstad/\">venster 11</a>)\r\n\r\n&nbsp;\r\n\r\nIn de stad konden de vrijgemaakten werk vinden als sjouwer in de haven bij het laden en lossen van schepen. Sommigen  kregen na 1875 werk bij de fosfaatwinning op de Tafelberg bij Nieuwpoort.  Ook de zeevaart vormde voor de vrijgemaakten een belangrijke bron van werkgelegenheid. Vrouwen konden werken als dienstboden op de plantages of in de stad en in de hoedenvlechterij. In periode na de emancipatie draaide de economie echter niet goed en er heerste veel armoede, met name onder de zojuist vrijgemaakten.\r\n\r\n&nbsp;\r\n\r\nDe koloniale overheid poogde om via regelgeving het, in de ogen van de overheid vaak ongewenste sociale gedrag van de vrijgemaakten, te beïnvloeden. [VOORBEELD]. Ook de Rooms-Katholieke Kerk spande zich in om mensen volgzaam te maken. Met name de Tambu was een doorn in het oog van de autoriteiten.\r\n\r\n&nbsp;\r\n\r\nMet de komst van de olie-industrie en de industrialisatie in het eerste kwart van de 20se eeuw ontstond er een breuk in de sociale geschiedenis van het eiland. De standenmaatschappij kwam onder druk te staan en de verhoudingen tussen de groepen verschoof enigszins, waardoor de vrijgelatenen iets meer ruimte kregen om hun plaats in de maatschappij op te eisen.', '14. De afschaffing van de slavernij', '', 'inherit', 'closed', 'closed', '', '33-revision-v1', '', '', '2018-04-27 20:12:48', '2018-04-27 18:12:48', '', '33', 'https://canoncuracao.cw/33-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('561', '4', '2018-04-27 20:13:45', '2018-04-27 18:13:45', 'Op 1 juli 1863 kondigde Koning Willem III de vrijheid van  slavernij  in de Nederlandse kolonies af. Ongeveer een derde deel van de totale bevolking van Curaçao verkreeg op dat moment de vrijheid. De slaveneigenaars  kregen een vergoeding van Nafl. 200,-- voor het vrijlaten van iedere slaafgemaakte, maar de ex-slaafgemaakten kregen zelf niets. In tegenstelling tot in Suriname bestond op Curaçao niet de verplichting om onder staatstoezicht nog tien jaar te werken voor een plantage-eigenaar.\r\n\r\nDirect na de emancipatie was het moeilijk een stuk grond krijgen voor het verbouwen van eigen voedsel en het bouwen van een huis. De meeste vruchtbare gronden waren reeds in handen van de plantage-eigenaren. Sommige ex-slaafgemaakten bleven om die reden bij de ’shons’ (plantage-eigenaren) wonen op basis van het zogenoemde <em>‘paga tera’</em> systeem, waarbij zij verplicht waren in ruil voor dit stuk grond  een aantal dagen per jaar onbetaald voor de plantagehouders te werken. Ook dienden ze, op het moment dat de maïs geoogst was, de shon dit te laten weten, zodat hij de koeien langs kon sturen om de stengels te eten. Als men weigerde om zich te houden aan deze  <em>paga tera</em> verplichting, doordat men  bijvoorbeeld ergens anders werkte, kreeg men de zogenaamde <em>ora di porta</em>, waarbij  men de aanzegging kreeg om binnen 24 uur te vertrekken van de plantage. Men moest dan met het gezin heel snel ergens anders onderdak zien te vinden.\r\n\r\nHet bezit van een stuk grond was voor velen een garantie voor de fel begeerde onafhankelijkheid ten opzichte van de plantagehouders. Tegen het einde van de negentiende eeuw begon de overheid een actief beleid te voeren om gouvernementsgronden aan particulieren te verhuren. (Zie <a href=\"https://canoncuracao.cw/11-ontwikkeling-nederzettingen-en-barios-buiten-willemstad/\">venster 11</a>)\r\n\r\nIn de stad konden de vrijgemaakten werk vinden als sjouwer in de haven bij het laden en lossen van schepen. Sommigen  kregen na 1875 werk bij de fosfaatwinning op de Tafelberg bij Nieuwpoort.  Ook de zeevaart vormde voor de vrijgemaakten een belangrijke bron van werkgelegenheid. Vrouwen konden werken als dienstboden op de plantages of in de stad en in de hoedenvlechterij. In periode na de emancipatie draaide de economie echter niet goed en er heerste veel armoede, met name onder de zojuist vrijgemaakten.\r\n\r\nDe koloniale overheid poogde om via regelgeving het, in de ogen van de overheid vaak ongewenste sociale gedrag van de vrijgemaakten, te beïnvloeden. [VOORBEELD]. Ook de Rooms-Katholieke Kerk spande zich in om mensen volgzaam te maken. Met name de Tambu was een doorn in het oog van de autoriteiten.\r\n\r\nMet de komst van de olie-industrie en de industrialisatie in het eerste kwart van de 20se eeuw ontstond er een breuk in de sociale geschiedenis van het eiland. De standenmaatschappij kwam onder druk te staan en de verhoudingen tussen de groepen verschoof enigszins, waardoor de vrijgelatenen iets meer ruimte kregen om hun plaats in de maatschappij op te eisen.', '14. De afschaffing van de slavernij', '', 'inherit', 'closed', 'closed', '', '33-revision-v1', '', '', '2018-04-27 20:13:45', '2018-04-27 18:13:45', '', '33', 'https://canoncuracao.cw/33-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('563', '4', '2018-04-27 20:25:03', '2018-04-27 18:25:03', 'Op 1 juli 1863 kondigde Koning Willem III de vrijheid van  slavernij  in de Nederlandse kolonies af. Ongeveer een derde deel van de totale bevolking van Curaçao verkreeg op dat moment de vrijheid. De slaveneigenaars  kregen een vergoeding van Nafl. 200,-- voor het vrijlaten van iedere slaafgemaakte, maar de ex-slaafgemaakten kregen zelf niets. In tegenstelling tot in Suriname bestond op Curaçao niet de verplichting om onder staatstoezicht nog tien jaar te werken voor een plantage-eigenaar.\r\n\r\nDirect na de emancipatie was het moeilijk een stuk grond krijgen voor het verbouwen van eigen voedsel en het bouwen van een huis. De meeste vruchtbare gronden waren reeds in handen van de plantage-eigenaren. Sommige ex-slaafgemaakten bleven om die reden bij de ’shons’ (plantage-eigenaren) wonen op basis van het zogenoemde <em>‘paga tera’</em> systeem, waarbij zij verplicht waren in ruil voor dit stuk grond  een aantal dagen per jaar onbetaald voor de plantagehouders te werken. Ook dienden ze, op het moment dat de maïs geoogst was, de shon dit te laten weten, zodat hij de koeien langs kon sturen om de stengels te eten. Als men weigerde om zich te houden aan deze  <em>paga tera</em> verplichting, doordat men  bijvoorbeeld ergens anders werkte, kreeg men de zogenaamde <em>ora di porta</em>, waarbij  men de aanzegging kreeg om binnen 24 uur te vertrekken van de plantage. Men moest dan met het gezin heel snel ergens anders onderdak zien te vinden.\r\n\r\nHet bezit van een stuk grond was voor velen een garantie voor de fel begeerde onafhankelijkheid ten opzichte van de plantagehouders. Tegen het einde van de negentiende eeuw begon de overheid een actief beleid te voeren om gouvernementsgronden aan particulieren te verhuren. (Zie <a href=\"https://canoncuracao.cw/11-ontwikkeling-nederzettingen-en-barios-buiten-willemstad/\">venster 11</a>)\r\n\r\nIn de stad konden de vrijgemaakten werk vinden als sjouwer in de haven bij het laden en lossen van schepen. Sommigen  kregen na 1875 werk bij de fosfaatwinning op de Tafelberg bij Nieuwpoort.  Ook de zeevaart vormde voor de vrijgemaakten een belangrijke bron van werkgelegenheid. Vrouwen konden werken als dienstboden op de plantages of in de stad en in de hoedenvlechterij. In periode na de emancipatie draaide de economie echter niet goed en er heerste veel armoede, met name onder de zojuist vrijgemaakten.\r\n\r\nDe koloniale overheid poogde om via regelgeving het, in de ogen van de overheid vaak ongewenste sociale gedrag van de vrijgemaakten, te beïnvloeden. Zo werd bijvoorbeeld een verordening tegen zwerverij \"ledigloperij\" aangenomen. Ook de Rooms-Katholieke Kerk spande zich in om mensen volgzaam te maken. Met name de Tambu was een doorn in het oog van de autoriteiten.\r\n\r\nMet de komst van de olie-industrie en de industrialisatie in het eerste kwart van de 20se eeuw ontstond er een breuk in de sociale geschiedenis van het eiland. De standenmaatschappij kwam onder druk te staan en de verhoudingen tussen de groepen verschoof enigszins, waardoor de vrijgelatenen iets meer ruimte kregen om hun plaats in de maatschappij op te eisen.', '14. De afschaffing van de slavernij', '', 'inherit', 'closed', 'closed', '', '33-revision-v1', '', '', '2018-04-27 20:25:03', '2018-04-27 18:25:03', '', '33', 'https://canoncuracao.cw/33-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('565', '4', '2018-04-27 20:31:58', '2018-04-27 18:31:58', '', 'Sjouwers in de haven2', '', 'inherit', 'open', 'closed', '', 'sjouwers-in-de-haven2-2', '', '', '2018-04-27 20:32:01', '2018-04-27 18:32:01', '', '33', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Sjouwers-in-de-haven2.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('566', '4', '2018-04-27 20:32:18', '2018-04-27 18:32:18', '', 'Pontjesvaarders', '', 'inherit', 'open', 'closed', '', 'pontjesvaarders', '', '', '2018-04-27 20:32:22', '2018-04-27 18:32:22', '', '33', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Pontjesvaarders.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('567', '4', '2018-04-27 20:32:33', '2018-04-27 18:32:33', '', 'Hoedenvlechterij detail', '', 'inherit', 'open', 'closed', '', 'hoedenvlechterij-detail', '', '', '2018-04-27 20:32:37', '2018-04-27 18:32:37', '', '33', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Hoedenvlechterij-detail.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('568', '4', '2018-04-27 20:34:30', '2018-04-27 18:34:30', 'Op 1 juli 1863 kondigde Koning Willem III de vrijheid van  slavernij  in de Nederlandse kolonies af. Ongeveer een derde deel van de totale bevolking van Curaçao verkreeg op dat moment de vrijheid. De slaveneigenaars  kregen een vergoeding van Nafl. 200,-- voor het vrijlaten van iedere slaafgemaakte, maar de ex-slaafgemaakten kregen zelf niets. In tegenstelling tot in Suriname bestond op Curaçao niet de verplichting om onder staatstoezicht nog tien jaar te werken voor een plantage-eigenaar.\r\n\r\nDirect na de emancipatie was het moeilijk een stuk grond krijgen voor het verbouwen van eigen voedsel en het bouwen van een huis. De meeste vruchtbare gronden waren reeds in handen van de plantage-eigenaren. Sommige ex-slaafgemaakten bleven om die reden bij de ’shons’ (plantage-eigenaren) wonen op basis van het zogenoemde <em>‘paga tera’</em> systeem, waarbij zij verplicht waren in ruil voor dit stuk grond  een aantal dagen per jaar onbetaald voor de plantagehouders te werken. Ook dienden ze, op het moment dat de maïs geoogst was, de shon dit te laten weten, zodat hij de koeien langs kon sturen om de stengels te eten. Als men weigerde om zich te houden aan deze  <em>paga tera</em> verplichting, doordat men  bijvoorbeeld ergens anders werkte, kreeg men de zogenaamde <em>ora di porta</em>, waarbij  men de aanzegging kreeg om binnen 24 uur te vertrekken van de plantage. Men moest dan met het gezin heel snel ergens anders onderdak zien te vinden.\r\n\r\nHet bezit van een stuk grond was voor velen een garantie voor de fel begeerde onafhankelijkheid ten opzichte van de plantagehouders. Tegen het einde van de negentiende eeuw begon de overheid een actief beleid te voeren om gouvernementsgronden aan particulieren te verhuren. (Zie <a href=\"https://canoncuracao.cw/11-ontwikkeling-nederzettingen-en-barios-buiten-willemstad/\">venster 11</a>)\r\n\r\nIn de stad konden de vrijgemaakten werk vinden als sjouwer in de haven bij het laden en lossen van schepen. Sommigen  kregen na 1875 werk bij de fosfaatwinning op de Tafelberg bij Nieuwpoort.  Ook de zeevaart vormde voor de vrijgemaakten een belangrijke bron van werkgelegenheid. Vrouwen konden werken als dienstboden op de plantages of in de stad en in de hoedenvlechterij. In periode na de emancipatie draaide de economie echter niet goed en er heerste veel armoede, met name onder de zojuist vrijgemaakten.\r\n\r\nDe koloniale overheid poogde om via regelgeving het, in de ogen van de overheid vaak ongewenste sociale gedrag van de vrijgemaakten, te beïnvloeden. Zo werd bijvoorbeeld een verordening tegen zwerverij \"ledigloperij\" aangenomen. Ook de Rooms-Katholieke Kerk spande zich in om mensen volgzaam te maken. Met name de Tambu was een doorn in het oog van de autoriteiten.\r\n\r\nMet de komst van de olie-industrie en de industrialisatie in het eerste kwart van de 20se eeuw ontstond er een breuk in de sociale geschiedenis van het eiland. De standenmaatschappij kwam onder druk te staan en de verhoudingen tussen de groepen verschoof enigszins, waardoor de vrijgelatenen iets meer ruimte kregen om hun plaats in de maatschappij op te eisen.', '14. De afschaffing van de slavernij', '', 'inherit', 'closed', 'closed', '', '33-revision-v1', '', '', '2018-04-27 20:34:30', '2018-04-27 18:34:30', '', '33', 'https://canoncuracao.cw/33-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('569', '4', '2018-04-27 20:35:26', '2018-04-27 18:35:26', 'Op 1 juli 1863 kondigde Koning Willem III de vrijheid van  slavernij  in de Nederlandse kolonies af. Ongeveer een derde deel van de totale bevolking van Curaçao verkreeg op dat moment de vrijheid. De slaveneigenaars  kregen een vergoeding van Nafl. 200,-- voor het vrijlaten van iedere slaafgemaakte, maar de ex-slaafgemaakten kregen zelf niets. In tegenstelling tot in Suriname bestond op Curaçao niet de verplichting om onder staatstoezicht nog tien jaar te werken voor een plantage-eigenaar.\r\n\r\nDirect na de emancipatie was het moeilijk een stuk grond krijgen voor het verbouwen van eigen voedsel en het bouwen van een huis. De meeste vruchtbare gronden waren reeds in handen van de plantage-eigenaren. Sommige ex-slaafgemaakten bleven om die reden bij de ’shons’ (plantage-eigenaren) wonen op basis van het zogenoemde <em>‘paga tera’</em> systeem, waarbij zij verplicht waren in ruil voor dit stuk grond  een aantal dagen per jaar onbetaald voor de plantagehouders te werken. Ook dienden ze, op het moment dat de maïs geoogst was, de shon dit te laten weten, zodat hij de koeien langs kon sturen om de stengels te eten. Als men weigerde om zich te houden aan deze  <em>paga tera</em> verplichting, doordat men  bijvoorbeeld ergens anders werkte, kreeg men de zogenaamde <em>ora di porta</em>, waarbij  men de aanzegging kreeg om binnen 24 uur te vertrekken van de plantage. Men moest dan met het gezin heel snel ergens anders onderdak zien te vinden.\r\n\r\nHet bezit van een stuk grond was voor velen een garantie voor de fel begeerde onafhankelijkheid ten opzichte van de plantagehouders. Tegen het einde van de negentiende eeuw begon de overheid een actief beleid te voeren om gouvernementsgronden aan particulieren te verhuren. (Zie <a href=\"https://canoncuracao.cw/11-ontwikkeling-nederzettingen-en-barios-buiten-willemstad/\">venster 11</a>)\r\n\r\nIn de stad konden de vrijgemaakten werk vinden als sjouwer in de haven bij het laden en lossen van schepen. Sommigen  kregen na 1875 werk bij de fosfaatwinning op de Tafelberg bij Nieuwpoort.  Ook de zeevaart vormde voor de vrijgemaakten een belangrijke bron van werkgelegenheid. Vrouwen konden werken als dienstboden op de plantages of in de stad en in de hoedenvlechterij. In periode na de emancipatie draaide de economie echter niet goed en er heerste veel armoede, met name onder de zojuist vrijgemaakten.\r\n\r\nDe koloniale overheid poogde om via regelgeving het, in de ogen van de overheid vaak ongewenste sociale gedrag van de vrijgemaakten, te beïnvloeden. Zo werd bijvoorbeeld een verordening tegen zwerverij \"ledigloperij\" aangenomen. Ook de Rooms-Katholieke Kerk spande zich in om mensen volgzaam te maken. Met name de Tambu was een doorn in het oog van de autoriteiten.\r\n\r\nMet de komst van de olie-industrie en de industrialisatie in het eerste kwart van de 20se eeuw ontstond er een breuk in de sociale geschiedenis van het eiland. De standenmaatschappij kwam onder druk te staan en de verhoudingen tussen de groepen verschoof enigszins, waardoor de vrijgelatenen iets meer ruimte kregen om hun plaats in de maatschappij op te eisen.', '14. De afschaffing van de slavernij', '', 'inherit', 'closed', 'closed', '', '33-revision-v1', '', '', '2018-04-27 20:35:26', '2018-04-27 18:35:26', '', '33', 'https://canoncuracao.cw/33-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('570', '4', '2018-04-27 20:37:12', '2018-04-27 18:37:12', 'Op 1 juli 1863 kondigde Koning Willem III de vrijheid van  slavernij  in de Nederlandse kolonies af. Ongeveer een derde deel van de totale bevolking van Curaçao verkreeg op dat moment de vrijheid. De slaveneigenaars  kregen een vergoeding van Nafl. 200,-- voor het vrijlaten van iedere slaafgemaakte, maar de ex-slaafgemaakten kregen zelf niets. In tegenstelling tot in Suriname bestond op Curaçao niet de verplichting om onder staatstoezicht nog tien jaar te werken voor een plantage-eigenaar.\r\n\r\nDirect na de emancipatie was het moeilijk een stuk grond krijgen voor het verbouwen van eigen voedsel en het bouwen van een huis. De meeste vruchtbare gronden waren reeds in handen van de plantage-eigenaren. Sommige ex-slaafgemaakten bleven om die reden bij de ’shons’ (plantage-eigenaren) wonen op basis van het zogenoemde <em>‘paga tera’</em> systeem, waarbij zij verplicht waren in ruil voor dit stuk grond  een aantal dagen per jaar onbetaald voor de plantagehouders te werken. Ook dienden ze, op het moment dat de maïs geoogst was, de shon dit te laten weten, zodat hij de koeien langs kon sturen om de stengels te eten. Als men weigerde om zich te houden aan deze  <em>paga tera</em> verplichting, doordat men  bijvoorbeeld ergens anders werkte, kreeg men de zogenaamde <em>ora di porta</em>, waarbij  men de aanzegging kreeg om binnen 24 uur te vertrekken van de plantage. Men moest dan met het gezin heel snel ergens anders onderdak zien te vinden.\r\n\r\nHet bezit van een stuk grond was voor velen een garantie voor de fel begeerde onafhankelijkheid ten opzichte van de plantagehouders. Tegen het einde van de negentiende eeuw begon de overheid een actief beleid te voeren om gouvernementsgronden aan particulieren te verhuren. (Zie <a href=\"https://canoncuracao.cw/11-ontwikkeling-nederzettingen-en-barios-buiten-willemstad/\">venster 11</a>)\r\n\r\nIn de stad konden de vrijgemaakten werk vinden als sjouwer in de haven bij het laden en lossen van schepen. Sommigen  kregen na 1875 werk bij de fosfaatwinning op de Tafelberg bij Nieuwpoort.  Ook de zeevaart vormde voor de vrijgemaakten een belangrijke bron van werkgelegenheid. Vrouwen konden werken als dienstboden op de plantages of in de stad en in de hoedenvlechterij. In periode na de emancipatie draaide de economie echter niet goed en er heerste veel armoede, met name onder de zojuist vrijgemaakten.\r\n\r\nDe koloniale overheid poogde om via regelgeving het, in de ogen van de overheid vaak ongewenste sociale gedrag van de vrijgemaakten, te beïnvloeden. Zo werd bijvoorbeeld een verordening tegen zwerverij \"ledigloperij\" aangenomen. Ook de Rooms-Katholieke Kerk spande zich in om mensen volgzaam te maken. Met name de Tambu was een doorn in het oog van de autoriteiten.\r\n\r\nMet de komst van de olie-industrie en de industrialisatie in het eerste kwart van de 20se eeuw ontstond er een breuk in de sociale geschiedenis van het eiland. De standenmaatschappij kwam onder druk te staan en de verhoudingen tussen de groepen verschoof enigszins, waardoor de vrijgelatenen iets meer ruimte kregen om hun plaats in de maatschappij op te eisen.', '14. De afschaffing van de slavernij', '', 'inherit', 'closed', 'closed', '', '33-revision-v1', '', '', '2018-04-27 20:37:12', '2018-04-27 18:37:12', '', '33', 'https://canoncuracao.cw/33-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('571', '4', '2018-04-27 20:38:47', '2018-04-27 18:38:47', '', 'nadeslavernij', '', 'inherit', 'open', 'closed', '', 'nadeslavernij', '', '', '2018-04-27 20:41:15', '2018-04-27 18:41:15', '', '35', 'https://canoncuracao.cw/wp-content/uploads/2017/05/nadeslavernij.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('572', '4', '2018-04-27 20:38:57', '2018-04-27 18:38:57', '', '15. De opbouw van de samenleving in de 19e eeuw: de verschillende bevolkingsgroepen', '', 'inherit', 'closed', 'closed', '', '35-revision-v1', '', '', '2018-04-27 20:38:57', '2018-04-27 18:38:57', '', '35', 'https://canoncuracao.cw/35-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('573', '4', '2018-04-27 20:44:11', '2018-04-27 18:44:11', '', '15. De opbouw van de samenleving in de 19e eeuw: de verschillende bevolkingsgroepen', '', 'inherit', 'closed', 'closed', '', '35-revision-v1', '', '', '2018-04-27 20:44:11', '2018-04-27 18:44:11', '', '35', 'https://canoncuracao.cw/35-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('574', '4', '2018-04-27 20:44:45', '2018-04-27 18:44:45', '', '15. De opbouw van de samenleving in de 19e eeuw: de verschillende bevolkingsgroepen', '', 'inherit', 'closed', 'closed', '', '35-revision-v1', '', '', '2018-04-27 20:44:45', '2018-04-27 18:44:45', '', '35', 'https://canoncuracao.cw/35-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('575', '4', '2020-01-28 16:38:48', '2020-01-28 15:38:48', 'Fort Amsterdam is het oudste gebouw op Curaçao. Het werd in 1635, een jaar nadat de <a href=\"https://canoncuracao.cw/3-verovering-van-curacao-door-de-wic-en-de-komst-van-de-hollanders/\">West- Indische Compagnie</a> het eiland op de Spanjaarden had veroverd, gebouwd op de oostelijke oever van de Sint Annabaai. Dit betekent dat op Curaçao geen bouwwerken bewaard zijn gebleven uit de <a href=\"https://canoncuracao.cw/1-de-oorspronkelijke-bewoners/\">precolumbiaanse tijd</a> en de <a href=\"https://canoncuracao.cw/2-de-spaanse-periode/\">Spaanse periode (1499-1634)</a>.\n\nAan de noordzijde van Fort Amsterdam ontstond in de loop van de zeventiende eeuw een kleine nederzetting die ‘<a href=\"https://canoncuracao.cw/10-ontwikkeling-willemstad/\">De Willemstad</a>’ werd genoemd. De eerste huizen die hier werden gebouwd zijn beïnvloed door de architectuur uit Amsterdam. Kenmerkend zijn de hoge smalle voorgevels en de diepe zijgevels. De voorgevels zijn voorzien van tuitgevels waarop een rechthoekig lijstwerk is geplaatst met daarop een klein fronton. Deze eerste bouwstijl uit de zeventiende eeuw, die de Curaçaos-Hollandse stijl wordt genoemd, werd niet alleen toegepast in Willemstad maar ook bij de huizen op de plantages, de landhuizen.\n\nEen kenmerkend onderdeel van de traditionele architectuur op Curaçao zijn de galerijen. Dit waren aanvankelijk open houten of stenen constructies die tegen de voorgevels van de huizen in de stad werden geplaatst. Later werden galerijen een structureel onderdeel van gebouwen zowel binnen als buiten de stad.\n\nIn de achttiende eeuw kwam de Curaçaose Barok in de mode met zijn sierlijke gebogen gevellijnen en arcades. Deze uitbundige bouwstijl werd in de eerste helft van de negentiende eeuw afgewisseld door een sobere bouwstijl die weer teruggreep op de tuitgevel uit de zeventiende eeuw. De afmeting en detaillering waren echter eenvoudiger geworden, waardoor deze stijl te onderscheiden is van de oudere stijl.\n\nDoor invloeden vanuit Nederland en de Verenigde Staten ontwikkelde zich in de tweede helft van de negentiende eeuw het neoclassicisme, een bouwstijl die gebaseerd was op de architectuur van de Grieken en Romeinen. De meest kenmerkende elementen van deze stijl zijn de toepassing van zuilen en frontons (driehoeken). Het neoclassicisme is gebruikt voor zowel stadsvilla’s als eenvoudige woonhuizen en eveneens voor landhuizen.\n\nIn de eerste helft van de twintigste eeuw kwam Curaçao in contact met de internationale bouwstijl die ook wel het ‘nieuwe bouwen’ wordt genoemd. Ook in deze periode zijn er duidelijke invloeden in de bouwkunst waar te nemen uit zowel Europa als de Verenigde Staten. Zo is bijvoorbeeld de voorgevel van de voormalige bioscoop Cinelandia geïnspireerd door de Art Deco in Miami en het voormalige KNSM-gebouw door de architectuur van de Nederlandse architect Dudok.\n\nNaast de formele westerse bouwstijlen ontwikkelde zich ook een architectuur met duidelijke Afrikaanse invloeden. Op de <a href=\"https://canoncuracao.cw/13-plantagesysteem-op-curacao/\">plantages</a> bouwden de slaven hutten van leem die met stro van maïs werden afgedekt, de zogenaamde <em>kas di pal’i maishi</em>. Na de afschaffing van de <a href=\"https://canoncuracao.cw/5-de-slavenhandel-en-slaverij/\">slavernij</a> heeft dit gebouwtype zich ontwikkeld tot kleine eenvoudige woonhuizen van steen en later ook van hout. De indeling van de <em>kas di yerba</em> bleef lang het uitgangspunt. Verspreid over het eiland ziet men nog veel van deze huizen, met hun schuin aflopende muren, staan.\n\nDe gebouwen op Curaçao hebben een Caribisch karakter gekregen door de invloeden van een multiculturele samenleving en het klimaat. De opvallende bonte kleuren op de gevels gaan terug op een verordening uit 1817, waarmee gouverneur Kikkert de eigenaren verplichtte om de wit gekalkte voorgevels in de binnenstad een kleur te geven.', '16. Gebouwen', '', 'inherit', 'closed', 'closed', '', '37-autosave-v1', '', '', '2020-01-28 16:38:48', '2020-01-28 15:38:48', '', '37', 'https://canoncuracao.cw/37-autosave-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('576', '4', '2018-04-27 20:55:31', '2018-04-27 18:55:31', '', '35.A. Bejaardenhuisvesting. Huize Puerto Rico2. Collectie FKP.-1-1', '', 'inherit', 'open', 'closed', '', '35-a-bejaardenhuisvesting-huize-puerto-rico2-collectie-fkp-1-1', '', '', '2018-04-27 20:55:42', '2018-04-27 18:55:42', '', '37', 'https://canoncuracao.cw/wp-content/uploads/2017/05/35.A.-Bejaardenhuisvesting.-Huize-Puerto-Rico2.-Collectie-FKP.-1-1.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('577', '4', '2018-04-27 20:55:46', '2018-04-27 18:55:46', 'Fort Amsterdam is het oudste gebouw op Curaçao. Het werd in 1635, een jaar nadat de West Indische Compagnie het eiland op de Spanjaarden had veroverd, gebouwd op de oostelijke oever van de Sint Annabaai. Dit betekent dat op Curaçao geen bouwwerken bewaard zijn gebleven uit de Spaanse periode (1499-1634) en evenmin uit de precolumbiaanse tijd.\r\n\r\n&nbsp;\r\n\r\nAan de noordzijde van Fort Amsterdam ontstond in de loop van de 17<sup>e</sup> eeuw een kleine nederzetting die ‘De Willemstad’ werd genoemd. De eerste huizen die hier werden gebouwd zijn beïnvloed door de architectuur uit Amsterdam. Kenmerkend zijn de hoge smalle voorgevels en de diepe zijgevels. De voorgevels zijn voorzien van tuitgevels waarop een rechthoekig lijstwerk is geplaatst met daarop een klein fronton. Deze eerste bouwstijl uit de zeventiende eeuw, die de Curaçaos-Hollandse stijl wordt genoemd, werd niet alleen toegepast in Willemstad maar ook bij de huizen op de plantages, de landhuizen.\r\n\r\n&nbsp;\r\n\r\nEen kenmerkend onderdeel van de traditionele architectuur op Curaçao zijn de galerijen. Dit waren aanvankelijk open houten of stenen constructies die tegen de voorgevels van de huizen in de stad werden geplaatst. Later werden galerijen een structureel onderdeel van gebouwen zowel binnen als buiten de stad.\r\n\r\n&nbsp;\r\n\r\nIn de achttiende eeuw kwam de Curaçaose Barok in de mode met zijn sierlijke gebogen gevellijnen en arcades. Deze uitbundige bouwstijl werd in de eerste helft van de 19<sup>e</sup> eeuw afgewisseld door een sobere bouwstijl die weer teruggreep op de tuitgevel uit de 17<sup>e</sup> eeuw. De afmeting en detaillering waren echter eenvoudiger geworden, waardoor deze stijl te onderscheiden is van de oudere stijl.\r\n\r\n&nbsp;\r\n\r\nDoor invloeden vanuit Nederland en de VS ontwikkelde zich in de tweede helft van de negentiende eeuw het neoclassicisme, een bouwstijl die gebaseerd was op de architectuur van de Grieken en Romeinen. De meest kenmerkende elementen van deze stijl zijn de toepassing van zuilen en frontons (driehoeken). Het neoclassicisme is gebruikt voor zowel stadsvilla’s als eenvoudige woonhuizen en eveneens voor landhuizen.\r\n\r\nIn de eerste helft van de twintigste eeuw kwam Curaçao in contact met de internationale bouwstijl, die ook wel het ‘nieuwe bouwen’ wordt genoemd. Ook in deze periode zijn er duidelijke invloeden in de bouwkunst waar te nemen uit zowel Europa als de VS. Zo is bijvoorbeeld de voorgevel van de voormalige bioscoop Cinelandia geïnspireerd door de Art Deco in Miami en het voormalige KNSM-gebouw door de architectuur van de Nederlandse architect Dudoc.\r\n\r\nDe gebouwen op Curaçao hebben een Caribisch karakter gekregen door de invloeden van een multiculturele samenleving en het klimaat. De opvallende bonte kleuren op de gevels gaan terug op een verordening uit 1817, waarmee gouverneur Kikkert de eigenaren verplichtte om de wit gekalkte voorgevels in de binnenstad een kleur te geven.', '16. Gebouwen', '', 'inherit', 'closed', 'closed', '', '37-revision-v1', '', '', '2018-04-27 20:55:46', '2018-04-27 18:55:46', '', '37', 'https://canoncuracao.cw/37-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('578', '4', '2018-04-27 21:28:29', '2018-04-27 19:28:29', '30 Mei 1969 (Trinta di Mei)\r\n\r\nWereldwijd, en dus ook op Curaçao, staan de jaren 60 bekend als een tijdperk van maatschappelijke verandering. Talrijke sociale bewegingen ageerden tegen sociale machtsstructuren gebaseerd op kleur, klasse, en geslacht. Op Curaçao wordt er geen ander gebeurtenis sterker geassocieerd met deze periode als de opstand van \"Trinta di Mei,\" 30 Mei 1969.\r\n\r\nDe arbeidsconflicten die tot de opstand van 30 mei 1969 hebben geleid vinden hun oorsprong in de ontwikkelingen van de tweede helft van de jaren 1960. De Shell-olieraffinaderij, toen de grootste werkgever op Curaçao, begon met automatisering en uitbesteding naar verschillende onderaannemers zoals, onder andere, \"Werkspoor Caribbean\" (WESCAR). Door de uitbestending moesten werknemers die eerder voor de Shell hadden gewerkt bij de onderaannemers hetzelfde arbeid verrichten tegen lager loon.\r\n\r\nIn de eerste week van mei 1969 ontstond er een impasse in de onderhandelingentussen WESCAR en de Curaçao Federation of Workers (CFW) over decollectieve arbeidersovereenkomst (CAO)die op 6 mei 1969 zou aflopen.CFW hanteerde het principe van \"equal work equal pay\" en eiste een loon dat gelijk was met wat de Shell betaalde voordat de banenaan WESCAR werden uitbesteed. Toen WESCAR dit weigerde, kondigde de CFW in de laatste week van mei een algemene staking af voor alle leden. Al gauw volgde een sympathie-staking van de Shell-arbeidersvakbond \"Petroleum Workers Federation of Curaçao\" (PWFC). Politici, journalisten en activisten zoals Stanley Brown, hoofdredacteur van de linkse antikoloniale tijdschrift<em> Vitó</em>, steunden de stakende arbeiders.\r\n\r\nOp de ochtend van 30 mei 1969 verzamelden zich ongeveer vijfduizend stakers bij de hoofdingang van de Shell-terrein voor een optocht naar Fort Amsterdam, onder leiding van Ewald Ong-a-Kwie, leider van de CFW. De leiders van de havenarbeiders, Wilson \"Papa\" Godett en Amador Nita, sloten zich toen aan bij de optocht. De optocht escaleerde tot een heuse opstand toen bij Parera twee doden vielen, Manuel Gutierez en Orlando Gerardina. Wilson \"Papa\" Godett werd in de rug geraakt door een politiekogel, toen hij met de handen omhoog de menigte probeerde te kalmeren. Na de escalatie stemden Shell en WESCAR alsnog in met de eisen van gelijk loon voor gelijk werk van de CFW<strong>.</strong> Het was echter al te laat. Een woedende meute stroomde Punda en Otrobanda binnen. Gebouwen werden in brand gestoken, en winkels werden geplunderd. De gouverneur kondigde een noodtoestand af, het leger werd ingeschakeld, en mariniers uit Nederland werden ingevlogen om de opstand te bedwingen. Nadat de vakbondsleiders op de radio hadden bekendgemaakt dat Shell en de onderaannemers met de eisen van de vakbonden hadden ingestemd, keerde de rust terug. In de nasleep van de opstand ontstond er een nieuwe politieke partij, \"Frente Obrero Liberashon Trinta di Mei,\" geleid door Wilson Godett, Stanley Brown en Amador Nita, die zou opkomen voor de belangen van de arbeidersklasse.\r\n\r\nMet de loop der jaren werd \"Trinta di Mei\" een symbool voor een langere periode van sociale veranderingsprocessen van de jaren 60, waarbij de raciaal gesegmenteerde koloniale machtsstructuur moest plaatsmaken voor een politiek klimaat waarin er meer rekening werd gehouden met de belangen van de Afro-Curaçaose arbeidersklasse. In 1994 werd \"Trinta di Mei\" tot nationale herdenkingsdag verklaard. Alhoewel er onder Curaçaoënaars nog steeds meningsverschillen bestaan over de details, wordt \"Trinta Di Mei\" toch beschouwd als een belangrijk keerpunt in de politieke geschiedenis van Curaçao.', '31. Dertig Mei 1969', '', 'inherit', 'closed', 'closed', '', '67-revision-v1', '', '', '2018-04-27 21:28:29', '2018-04-27 19:28:29', '', '67', 'https://canoncuracao.cw/67-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('580', '4', '2018-04-27 23:14:11', '2018-04-27 21:14:11', '', 'no 96 opnamen Waterfort 20 sept \'55 - 734-1-1', '', 'inherit', 'open', 'closed', '', 'no-96-opnamen-waterfort-20-sept-55-734-1-1', '', '', '2018-04-27 23:14:15', '2018-04-27 21:14:15', '', '39', 'https://canoncuracao.cw/wp-content/uploads/2017/05/no-96-opnamen-Waterfort-20-sept-55-734-1-1.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('581', '4', '2018-04-27 23:14:20', '2018-04-27 21:14:20', 'De verdediging van Curaçao is altijd een problematische zaak geweest. De Spanjaarden deden nauwelijks moeite om het eiland te verdedigen, maar zij vonden het eiland dan ook niet zo belangrijk. De Nederlanders maakten van de grootste binnenbaai, het Schottegat, een marinebasis, goed verdedigd door Fort Amsterdam aan de ingang van de baai. Maar omdat baaien die geschikt waren om landingen uit te voeren verspreid lagen over de hele zuidkust, had men een probleem. Dat werd gedeeltelijk opgelost door de baaien die het dichtst bij de stad lagen, te voorzien van forten; Fort Beekenburg, Fort Piscadera en Fort Sint Michiel.\r\n\r\nIn 1713 toonde de Franse admiraal/kaper Cassard echter aan dat het mogelijk was in een van de baaien in het westelijk deel van het eiland te landen, op te trekken naar de stad en die vanaf de landzijde effectief te belegeren. Daarop werd besloten ook forten te bouwen bij o.a. Porto Marie (nu Daaibooibaai), Santa Cruz, Lagun, Knip en Westpunt. In de roerige tijden van de tweede helft van de 18e eeuw kregen bijna alle kleine baaien een klein fort of een batterij. Op een heuvel boven de Sint-Annabaai werd het ‘Fort Republiek’ gebouwd, dat nu Fort Nassau wordt genoemd.\r\n\r\nToen bleek echter nog meer hoe onverdedigbaar Curaçao eigenlijk was; er was nog net geld beschikbaar voor het bouwen van deze verdedigingswerken, maar er was geen geld om ze te bemannen en te onderhouden. De Engelsen konden dan ook in 1804 zonder tegenstand landen aan de Piscaderabaai omdat de soldaten in het fort niet over kogels beschikten. Daarna konden ze de de stad vanaf de landzijde aanvallen. Na de Engelse periode, die afliep in 1816. werd de verdediging van het eiland weer geconcentreerd op Willemstad. Het Waterfort en het Riffort werden aan de ingang van de Sint Annabaai gebouwd. Andere plannen werden wegens gebrek aan fondsen niet uitgevoerd.\r\n\r\nDe Venezuelaanse opstandeling Urbina toonde in 1929 aan hoe gemakkelijk het bestuur van Curaçao onder druk gezet kon worden. Hij overviel met zijn manschappen fort ......, maakte wapens buit en slaagde erin naar Venezuela te varen met medeneming van de Gouverneur. De verdediging van het eiland was toen weer eens minimaal. Er was zelf geen stationsschip aanwezig.\r\n\r\nIn de Tweede Wereldoorlog werd de verdediging van het eiland opnieuw aangepakt omdat de raffinaderij belangrijk was voor de brandstofvoorziening van de geallieerden. Om vijandelijke schepen tegen te houden werden er twee flinke kustbatterijen gebouwd: die van de Nederlanders op Steenrijk en die van de Amerikanen bij Blauwbaai. Bij de olie-installaties van Bullenbaai werd een kleine (Nederlandse) kustbatterij neergezet, die daadwerkelijk in actie kwam tegen een aanvallende Duitse onderzeeboot en die ook wist te verdrijven. Ook kwamen er verschillende luchtafweer- en uitkijkposten.\r\n\r\nNa de Tweede Wereldoorlog werd de verdediging weer ingekrompen, maar er is nog altijd een contingent Nederlandse militairen en een stationsschip op het eiland aanwezig. Ook de Amerikanen hebben een luchtmachtbasis met verkenningsvliegtuigen op het eiland.', '17. De verdediging van Curaçao en forten', '', 'inherit', 'closed', 'closed', '', '39-revision-v1', '', '', '2018-04-27 23:14:20', '2018-04-27 21:14:20', '', '39', 'https://canoncuracao.cw/39-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('582', '4', '2018-04-27 23:26:21', '2018-04-27 21:26:21', '', 'Caracasbaai Fort Bekenburg 2', '', 'inherit', 'open', 'closed', '', 'caracasbaai-fort-bekenburg-2', '', '', '2018-04-27 23:26:29', '2018-04-27 21:26:29', '', '39', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Caracasbaai-Fort-Bekenburg-2.jpeg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('583', '4', '2018-04-27 23:26:34', '2018-04-27 21:26:34', 'De verdediging van Curaçao is altijd een problematische zaak geweest. De Spanjaarden deden nauwelijks moeite om het eiland te verdedigen, maar zij vonden het eiland dan ook niet zo belangrijk. De Nederlanders maakten van de grootste binnenbaai, het Schottegat, een marinebasis, goed verdedigd door Fort Amsterdam aan de ingang van de baai. Maar omdat baaien die geschikt waren om landingen uit te voeren verspreid lagen over de hele zuidkust, had men een probleem. Dat werd gedeeltelijk opgelost door de baaien die het dichtst bij de stad lagen, te voorzien van forten; Fort Beekenburg, Fort Piscadera en Fort Sint Michiel.\r\n\r\nIn 1713 toonde de Franse admiraal/kaper Cassard echter aan dat het mogelijk was in een van de baaien in het westelijk deel van het eiland te landen, op te trekken naar de stad en die vanaf de landzijde effectief te belegeren. Daarop werd besloten ook forten te bouwen bij o.a. Porto Marie (nu Daaibooibaai), Santa Cruz, Lagun, Knip en Westpunt. In de roerige tijden van de tweede helft van de 18e eeuw kregen bijna alle kleine baaien een klein fort of een batterij. Op een heuvel boven de Sint-Annabaai werd het ‘Fort Republiek’ gebouwd, dat nu Fort Nassau wordt genoemd.\r\n\r\nToen bleek echter nog meer hoe onverdedigbaar Curaçao eigenlijk was; er was nog net geld beschikbaar voor het bouwen van deze verdedigingswerken, maar er was geen geld om ze te bemannen en te onderhouden. De Engelsen konden dan ook in 1804 zonder tegenstand landen aan de Piscaderabaai omdat de soldaten in het fort niet over kogels beschikten. Daarna konden ze de de stad vanaf de landzijde aanvallen. Na de Engelse periode, die afliep in 1816. werd de verdediging van het eiland weer geconcentreerd op Willemstad. Het Waterfort en het Riffort werden aan de ingang van de Sint Annabaai gebouwd. Andere plannen werden wegens gebrek aan fondsen niet uitgevoerd.\r\n\r\nDe Venezuelaanse opstandeling Urbina toonde in 1929 aan hoe gemakkelijk het bestuur van Curaçao onder druk gezet kon worden. Hij overviel met zijn manschappen fort ......, maakte wapens buit en slaagde erin naar Venezuela te varen met medeneming van de Gouverneur. De verdediging van het eiland was toen weer eens minimaal. Er was zelf geen stationsschip aanwezig.\r\n\r\nIn de Tweede Wereldoorlog werd de verdediging van het eiland opnieuw aangepakt omdat de raffinaderij belangrijk was voor de brandstofvoorziening van de geallieerden. Om vijandelijke schepen tegen te houden werden er twee flinke kustbatterijen gebouwd: die van de Nederlanders op Steenrijk en die van de Amerikanen bij Blauwbaai. Bij de olie-installaties van Bullenbaai werd een kleine (Nederlandse) kustbatterij neergezet, die daadwerkelijk in actie kwam tegen een aanvallende Duitse onderzeeboot en die ook wist te verdrijven. Ook kwamen er verschillende luchtafweer- en uitkijkposten.\r\n\r\nNa de Tweede Wereldoorlog werd de verdediging weer ingekrompen, maar er is nog altijd een contingent Nederlandse militairen en een stationsschip op het eiland aanwezig. Ook de Amerikanen hebben een luchtmachtbasis met verkenningsvliegtuigen op het eiland.', '17. De verdediging van Curaçao en forten', '', 'inherit', 'closed', 'closed', '', '39-revision-v1', '', '', '2018-04-27 23:26:34', '2018-04-27 21:26:34', '', '39', 'https://canoncuracao.cw/39-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('584', '4', '2018-04-27 23:28:33', '2018-04-27 21:28:33', '', 'no 96 opnamen Waterfort 20 sept \'55 - 734-1-1', '', 'inherit', 'open', 'closed', '', 'no-96-opnamen-waterfort-20-sept-55-734-1-1-2', '', '', '2018-04-27 23:28:44', '2018-04-27 21:28:44', '', '39', 'https://canoncuracao.cw/wp-content/uploads/2017/05/no-96-opnamen-Waterfort-20-sept-55-734-1-1-1.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('585', '4', '2018-04-27 23:31:35', '2018-04-27 21:31:35', '', 'no 96 opnamen Waterfort 20 sept \'55 - 734-1-1', '', 'inherit', 'open', 'closed', '', 'no-96-opnamen-waterfort-20-sept-55-734-1-1-3', '', '', '2018-04-27 23:31:39', '2018-04-27 21:31:39', '', '39', 'https://canoncuracao.cw/wp-content/uploads/2017/05/no-96-opnamen-Waterfort-20-sept-55-734-1-1-2.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('586', '4', '2018-04-27 23:31:59', '2018-04-27 21:31:59', '', 'no 96 - 735-1', '', 'inherit', 'open', 'closed', '', 'no-96-735-1', '', '', '2018-04-27 23:32:01', '2018-04-27 21:32:01', '', '39', 'https://canoncuracao.cw/wp-content/uploads/2017/05/no-96-735-1.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('587', '4', '2018-04-27 23:34:46', '2018-04-27 21:34:46', 'De verdediging van Curaçao is altijd een problematische zaak geweest. De Spanjaarden deden nauwelijks moeite om het eiland te verdedigen, maar zij vonden het eiland dan ook niet zo belangrijk. De Nederlanders maakten van de grootste binnenbaai, het Schottegat, een marinebasis, goed verdedigd door Fort Amsterdam aan de ingang van de baai. Maar omdat baaien die geschikt waren om landingen uit te voeren verspreid lagen over de hele zuidkust, had men een probleem. Dat werd gedeeltelijk opgelost door de baaien die het dichtst bij de stad lagen, te voorzien van forten; Fort Beekenburg, Fort Piscadera en Fort Sint Michiel.\r\n\r\nIn 1713 toonde de Franse admiraal/kaper Cassard echter aan dat het mogelijk was in een van de baaien in het westelijk deel van het eiland te landen, op te trekken naar de stad en die vanaf de landzijde effectief te belegeren. Daarop werd besloten ook forten te bouwen bij o.a. Porto Marie (nu Daaibooibaai), Santa Cruz, Lagun, Knip en Westpunt. In de roerige tijden van de tweede helft van de 18e eeuw kregen bijna alle kleine baaien een klein fort of een batterij. Op een heuvel boven de Sint-Annabaai werd het ‘Fort Republiek’ gebouwd, dat nu Fort Nassau wordt genoemd.\r\n\r\nToen bleek echter nog meer hoe onverdedigbaar Curaçao eigenlijk was; er was nog net geld beschikbaar voor het bouwen van deze verdedigingswerken, maar er was geen geld om ze te bemannen en te onderhouden. De Engelsen konden dan ook in 1804 zonder tegenstand landen aan de Piscaderabaai omdat de soldaten in het fort niet over kogels beschikten. Daarna konden ze de de stad vanaf de landzijde aanvallen. Na de Engelse periode, die afliep in 1816. werd de verdediging van het eiland weer geconcentreerd op Willemstad. Het Waterfort en het Riffort werden aan de ingang van de Sint Annabaai gebouwd. Andere plannen werden wegens gebrek aan fondsen niet uitgevoerd.\r\n\r\nDe Venezuelaanse opstandeling Urbina toonde in 1929 aan hoe gemakkelijk het bestuur van Curaçao onder druk gezet kon worden. Hij overviel met zijn manschappen fort ......, maakte wapens buit en slaagde erin naar Venezuela te varen met medeneming van de Gouverneur. De verdediging van het eiland was toen weer eens minimaal. Er was zelf geen stationsschip aanwezig.\r\n\r\nIn de Tweede Wereldoorlog werd de verdediging van het eiland opnieuw aangepakt omdat de raffinaderij belangrijk was voor de brandstofvoorziening van de geallieerden. Om vijandelijke schepen tegen te houden werden er twee flinke kustbatterijen gebouwd: die van de Nederlanders op Steenrijk en die van de Amerikanen bij Blauwbaai. Bij de olie-installaties van Bullenbaai werd een kleine (Nederlandse) kustbatterij neergezet, die daadwerkelijk in actie kwam tegen een aanvallende Duitse onderzeeboot en die ook wist te verdrijven. Ook kwamen er verschillende luchtafweer- en uitkijkposten.\r\n\r\nNa de Tweede Wereldoorlog werd de verdediging weer ingekrompen, maar er is nog altijd een contingent Nederlandse militairen en een stationsschip op het eiland aanwezig. Ook de Amerikanen hebben een luchtmachtbasis met verkenningsvliegtuigen op het eiland.', '17. De verdediging van Curaçao en forten', '', 'inherit', 'closed', 'closed', '', '39-revision-v1', '', '', '2018-04-27 23:34:46', '2018-04-27 21:34:46', '', '39', 'https://canoncuracao.cw/39-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('588', '4', '2018-04-27 23:37:02', '2018-04-27 21:37:02', 'De verdediging van Curaçao is altijd een problematische zaak geweest. De Spanjaarden deden nauwelijks moeite om het eiland te verdedigen, maar zij vonden het eiland dan ook niet zo belangrijk. De Nederlanders maakten van de grootste binnenbaai, het Schottegat, een marinebasis, goed verdedigd door Fort Amsterdam aan de ingang van de baai. Maar omdat baaien die geschikt waren om landingen uit te voeren verspreid lagen over de hele zuidkust, had men een probleem. Dat werd gedeeltelijk opgelost door de baaien die het dichtst bij de stad lagen, te voorzien van forten; Fort Beekenburg, Fort Piscadera en Fort Sint Michiel.\r\n\r\nIn 1713 toonde de Franse admiraal/kaper Cassard echter aan dat het mogelijk was in een van de baaien in het westelijk deel van het eiland te landen, op te trekken naar de stad en die vanaf de landzijde effectief te belegeren. Daarop werd besloten ook forten te bouwen bij o.a. Porto Marie (nu Daaibooibaai), Santa Cruz, Lagun, Knip en Westpunt. In de roerige tijden van de tweede helft van de 18e eeuw kregen bijna alle kleine baaien een klein fort of een batterij. Op een heuvel boven de Sint-Annabaai werd het ‘Fort Republiek’ gebouwd, dat nu Fort Nassau wordt genoemd.\r\n\r\nToen bleek echter nog meer hoe onverdedigbaar Curaçao eigenlijk was; er was nog net geld beschikbaar voor het bouwen van deze verdedigingswerken, maar er was geen geld om ze te bemannen en te onderhouden. De Engelsen konden dan ook in 1804 zonder tegenstand landen aan de Piscaderabaai omdat de soldaten in het fort niet over kogels beschikten. Daarna konden ze de de stad vanaf de landzijde aanvallen. Na de Engelse periode, die afliep in 1816. werd de verdediging van het eiland weer geconcentreerd op Willemstad. Het Waterfort en het Riffort werden aan de ingang van de Sint Annabaai gebouwd. Andere plannen werden wegens gebrek aan fondsen niet uitgevoerd.\r\n\r\nDe Venezuelaanse opstandeling Urbina toonde in 1929 aan hoe gemakkelijk het bestuur van Curaçao onder druk gezet kon worden. Hij overviel met zijn manschappen fort ......, maakte wapens buit en slaagde erin naar Venezuela te varen met medeneming van de Gouverneur. De verdediging van het eiland was toen weer eens minimaal. Er was zelf geen stationsschip aanwezig.\r\n\r\nIn de Tweede Wereldoorlog werd de verdediging van het eiland opnieuw aangepakt omdat de raffinaderij belangrijk was voor de brandstofvoorziening van de geallieerden. Om vijandelijke schepen tegen te houden werden er twee flinke kustbatterijen gebouwd: die van de Nederlanders op Steenrijk en die van de Amerikanen bij Blauwbaai. Bij de olie-installaties van Bullenbaai werd een kleine (Nederlandse) kustbatterij neergezet, die daadwerkelijk in actie kwam tegen een aanvallende Duitse onderzeeboot en die ook wist te verdrijven. Ook kwamen er verschillende luchtafweer- en uitkijkposten.\r\n\r\nNa de Tweede Wereldoorlog werd de verdediging weer ingekrompen, maar er is nog altijd een contingent Nederlandse militairen en een stationsschip op het eiland aanwezig. Ook de Amerikanen hebben een luchtmachtbasis met verkenningsvliegtuigen op het eiland.', '17. De verdediging van Curaçao en forten', '', 'inherit', 'closed', 'closed', '', '39-revision-v1', '', '', '2018-04-27 23:37:02', '2018-04-27 21:37:02', '', '39', 'https://canoncuracao.cw/39-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('589', '4', '2018-04-27 23:38:22', '2018-04-27 21:38:22', 'De verdediging van Curaçao is altijd een problematische zaak geweest. De Spanjaarden deden nauwelijks moeite om het eiland te verdedigen, maar zij vonden het eiland dan ook niet zo belangrijk. De Nederlanders maakten van de grootste binnenbaai, het Schottegat, een marinebasis, goed verdedigd door Fort Amsterdam aan de ingang van de baai. Maar omdat baaien die geschikt waren om landingen uit te voeren verspreid lagen over de hele zuidkust, had men een probleem. Dat werd gedeeltelijk opgelost door de baaien die het dichtst bij de stad lagen, te voorzien van forten; Fort Beekenburg, Fort Piscadera en Fort Sint Michiel.\r\n\r\nIn 1713 toonde de Franse admiraal/kaper Cassard echter aan dat het mogelijk was in een van de baaien in het westelijk deel van het eiland te landen, op te trekken naar de stad en die vanaf de landzijde effectief te belegeren. Daarop werd besloten ook forten te bouwen bij o.a. Porto Marie (nu Daaibooibaai), Santa Cruz, Lagun, Knip en Westpunt. In de roerige tijden van de tweede helft van de 18e eeuw kregen bijna alle kleine baaien een klein fort of een batterij. Op een heuvel boven de Sint-Annabaai werd het ‘Fort Republiek’ gebouwd, dat nu Fort Nassau wordt genoemd.\r\n\r\nToen bleek echter nog meer hoe onverdedigbaar Curaçao eigenlijk was; er was nog net geld beschikbaar voor het bouwen van deze verdedigingswerken, maar er was geen geld om ze te bemannen en te onderhouden. De Engelsen konden dan ook in 1804 zonder tegenstand landen aan de Piscaderabaai omdat de soldaten in het fort niet over kogels beschikten. Daarna konden ze de de stad vanaf de landzijde aanvallen. Na de Engelse periode, die afliep in 1816. werd de verdediging van het eiland weer geconcentreerd op Willemstad. Het Waterfort en het Riffort werden aan de ingang van de Sint Annabaai gebouwd. Andere plannen werden wegens gebrek aan fondsen niet uitgevoerd.\r\n\r\nDe Venezuelaanse opstandeling Urbina toonde in 1929 aan hoe gemakkelijk het bestuur van Curaçao onder druk gezet kon worden. Hij overviel met zijn manschappen fort ......, maakte wapens buit en slaagde erin naar Venezuela te varen met medeneming van de Gouverneur. De verdediging van het eiland was toen weer eens minimaal. Er was zelf geen stationsschip aanwezig.\r\n\r\nIn de Tweede Wereldoorlog werd de verdediging van het eiland opnieuw aangepakt omdat de raffinaderij belangrijk was voor de brandstofvoorziening van de geallieerden. Om vijandelijke schepen tegen te houden werden er twee flinke kustbatterijen gebouwd: die van de Nederlanders op Steenrijk en die van de Amerikanen bij Blauwbaai. Bij de olie-installaties van Bullenbaai werd een kleine (Nederlandse) kustbatterij neergezet, die daadwerkelijk in actie kwam tegen een aanvallende Duitse onderzeeboot en die ook wist te verdrijven. Ook kwamen er verschillende luchtafweer- en uitkijkposten.\r\n\r\nNa de Tweede Wereldoorlog werd de verdediging weer ingekrompen, maar er is nog altijd een contingent Nederlandse militairen en een stationsschip op het eiland aanwezig. Ook de Amerikanen hebben een luchtmachtbasis met verkenningsvliegtuigen op het eiland.', '17. De verdediging van Curaçao en forten', '', 'inherit', 'closed', 'closed', '', '39-revision-v1', '', '', '2018-04-27 23:38:22', '2018-04-27 21:38:22', '', '39', 'https://canoncuracao.cw/39-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('591', '4', '2018-04-27 23:43:18', '2018-04-27 21:43:18', 'Armoede, gebrek aan werk en weinig mobiliteitskansen fungeerden op Curaçao als voornaamste push-factoren voor emigratie in de periode na de emancipatie van de tot slaaf gemaakten in 1863.\r\nVele Curaçaose arbeiders emigreerden naar landen in de regio. De migratie was dus intra-regionaal. In 1838 werd de emigratie van arbeiskrachten bij wet verboden en dit verbod bleef tot 1883 in stand. Toch werd er op 9 juli 1863, acht dagen na de afschaffing van de slavernij, een contract opgesteld tussen 25 vrijgemaakten en een Venezolaanse werkgever om te gaan werken in Venezuela. Op 10 juli 1863 werd er opnieuw een contract getekend met 25 Curaçaose mannen, om op de rivier in Venezuela te gaan varen met lichters en producten af te geven. Dit gebeurde opnieuw op 16 juli 1863. Velen vertrokken echter ook zonder een contract te tekenen.\r\n\r\nLater in de eeuw, in 1882, vertrokken 46 mannen uit Curaçao voor werk bij de bouw van het Panama-kanaal. Daar werden ze opgenomen in een grotere groep van in totaal 130.000 arbeiders uit de Engelse Cariben. In die zelfde periode vertrokken er Curaçaoënaars naar Venezuela, Costa Rica en Colombia. Zij gingen zij daar seizoenarbeid verrichten op de suikerriet- en bananenplantages.\r\n\r\nCuraçaose arbeiders vertrokken ook naar de Dominicaanse Republiek. In 1862, bijvoorbeeld, gingen enkele metselaars, timmerlieden en dagloners daar een jaar lang werken. Behalve ambachtslieden emigreerden er ook arbeiders om te werken op de suikerrietplantages. Dit gebeurde vooral tijdens de onafhankelijkheidsoorlogen op Cuba, waarbij de suikerproductie aldaar verlegd werd naar de Dominicaanse Republiek.\r\n\r\nDe arbeidsmigratie naar Cuba begon in 1917 en kende pieken in de jaren 1918, 1919 en 1920. Deze migratie drukte een onmiskenbaar stempel op Curaçao, omdat toen grote aantallen mensen vertrokken. Ongeveer 50% van de mannelijke arbeidskrachten op het eiland vertrok in groepsverband. In Cuba werkten zij samen met een nog grotere aantal mensen uit Aruba, Bonaire, de Engelse Cariben, Haïti, Puerto Rico en de Nederlandse Bovenwinden.\r\nMigratie was niet alleen maar een mannenaangelegenheid. Ook vrouwen emigreerden. Soms sloten zij al op Curaçao een contract met hun werkgevers in het buitenland, zoals bijvoorbeeld het geval was met yaya’s (kindermeisjes) en kokkins van Curaçaose families van Joodse en Protestantse afkomst die naar een ander Caribisch eiland waren verhuisd. Soms emigreerden deze vrouwen echter ook op eigen gelegenheid en vonden ze in het land van bestemming werk als wasvrouw, werkster, kindermeisje en dergelijke.\r\n\r\nZelfs na de komst op Curaçao van de olie-maatschappij in 1915 bleef de migratie van Curaçaose arbeiders naar landen in de Caribische regio aanhouden. Dit bleef tot ongeveer 1923 het geval.', '18. Werkgelegenheid en emigratie tussen 1863 en 1920', '', 'inherit', 'closed', 'closed', '', '41-revision-v1', '', '', '2018-04-27 23:43:18', '2018-04-27 21:43:18', '', '41', 'https://canoncuracao.cw/41-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('592', '4', '2018-04-27 23:45:22', '2018-04-27 21:45:22', 'Armoede, gebrek aan werk en weinig mobiliteitskansen fungeerden op Curaçao als voornaamste push-factoren voor emigratie in de periode na de emancipatie van de tot slaaf gemaakten in 1863.\r\nVele Curaçaose arbeiders emigreerden naar landen in de regio. De migratie was dus intra-regionaal. In 1838 werd de emigratie van arbeidskrachten bij wet verboden en dit verbod bleef tot 1883 in stand. Toch werd er op 9 juli 1863, acht dagen na de afschaffing van de slavernij, een contract opgesteld tussen 25 vrijgemaakten en een Venezolaanse werkgever om te gaan werken in Venezuela. Op 10 juli 1863 werd er opnieuw een contract getekend met 25 Curaçaose mannen, om op de rivier in Venezuela te gaan varen met lichters en producten af te geven. Dit gebeurde opnieuw op 16 juli 1863. Velen vertrokken echter ook zonder een contract te tekenen.\r\n\r\nLater in de eeuw, in 1882, vertrokken 46 mannen uit Curaçao voor werk bij de bouw van het Panama-kanaal. Daar werden ze opgenomen in een grotere groep van in totaal 130.000 arbeiders uit de Engelse Cariben. In die zelfde periode vertrokken er Curaçaoënaars naar Venezuela, Costa Rica en Colombia. Zij gingen zij daar seizoenarbeid verrichten op de suikerriet- en bananenplantages.\r\n\r\nCuraçaose arbeiders vertrokken ook naar de Dominicaanse Republiek. In 1862, bijvoorbeeld, gingen enkele metselaars, timmerlieden en dagloners daar een jaar lang werken. Behalve ambachtslieden emigreerden er ook arbeiders om te werken op de suikerrietplantages. Dit gebeurde vooral tijdens de onafhankelijkheidsoorlogen op Cuba, waarbij de suikerproductie aldaar verlegd werd naar de Dominicaanse Republiek.\r\n\r\nDe arbeidsmigratie naar Cuba begon in 1917 en kende pieken in de jaren 1918, 1919 en 1920. Deze migratie drukte een onmiskenbaar stempel op Curaçao, omdat toen grote aantallen mensen vertrokken. Ongeveer 50% van de mannelijke arbeidskrachten op het eiland vertrok in groepsverband. In Cuba werkten zij samen met een nog grotere aantal mensen uit Aruba, Bonaire, de Engelse Cariben, Haïti, Puerto Rico en de Nederlandse Bovenwinden.\r\n\r\nMigratie was niet alleen maar een mannenaangelegenheid. Ook vrouwen emigreerden. Soms sloten zij al op Curaçao een contract met hun werkgevers in het buitenland, zoals bijvoorbeeld het geval was met yaya’s (kindermeisjes) en kokkins van Curaçaose families van Joodse en Protestantse afkomst die naar een ander Caribisch eiland waren verhuisd. Soms emigreerden deze vrouwen echter ook op eigen gelegenheid en vonden ze in het land van bestemming werk als wasvrouw, werkster, kindermeisje en dergelijke.\r\n\r\nZelfs na de komst op Curaçao van de olie-maatschappij in 1915 bleef de migratie van Curaçaose arbeiders naar landen in de Caribische regio aanhouden. Dit bleef tot ongeveer 1923 het geval.', '18. Werkgelegenheid en emigratie tussen 1863 en 1920', '', 'inherit', 'closed', 'closed', '', '41-revision-v1', '', '', '2018-04-27 23:45:22', '2018-04-27 21:45:22', '', '41', 'https://canoncuracao.cw/41-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('593', '4', '2018-04-27 23:49:29', '2018-04-27 21:49:29', '', 'PANAMA CANAL 2 MCT', 'Spanish laborers at work on the Panama Canal, 1909. (Library of Congress/MCT)', 'inherit', 'open', 'closed', '', 'panama-canal-2-mct', '', '', '2018-04-27 23:49:35', '2018-04-27 21:49:35', '', '41', 'https://canoncuracao.cw/wp-content/uploads/2017/05/panama-kanaal.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('594', '4', '2018-04-27 23:49:41', '2018-04-27 21:49:41', 'Armoede, gebrek aan werk en weinig mobiliteitskansen fungeerden op Curaçao als voornaamste push-factoren voor emigratie in de periode na de emancipatie van de tot slaaf gemaakten in 1863.\r\nVele Curaçaose arbeiders emigreerden naar landen in de regio. De migratie was dus intra-regionaal. In 1838 werd de emigratie van arbeidskrachten bij wet verboden en dit verbod bleef tot 1883 in stand. Toch werd er op 9 juli 1863, acht dagen na de afschaffing van de slavernij, een contract opgesteld tussen 25 vrijgemaakten en een Venezolaanse werkgever om te gaan werken in Venezuela. Op 10 juli 1863 werd er opnieuw een contract getekend met 25 Curaçaose mannen, om op de rivier in Venezuela te gaan varen met lichters en producten af te geven. Dit gebeurde opnieuw op 16 juli 1863. Velen vertrokken echter ook zonder een contract te tekenen.\r\n\r\nLater in de eeuw, in 1882, vertrokken 46 mannen uit Curaçao voor werk bij de bouw van het Panama-kanaal. Daar werden ze opgenomen in een grotere groep van in totaal 130.000 arbeiders uit de Engelse Cariben. In die zelfde periode vertrokken er Curaçaoënaars naar Venezuela, Costa Rica en Colombia. Zij gingen zij daar seizoenarbeid verrichten op de suikerriet- en bananenplantages.\r\n\r\nCuraçaose arbeiders vertrokken ook naar de Dominicaanse Republiek. In 1862, bijvoorbeeld, gingen enkele metselaars, timmerlieden en dagloners daar een jaar lang werken. Behalve ambachtslieden emigreerden er ook arbeiders om te werken op de suikerrietplantages. Dit gebeurde vooral tijdens de onafhankelijkheidsoorlogen op Cuba, waarbij de suikerproductie aldaar verlegd werd naar de Dominicaanse Republiek.\r\n\r\nDe arbeidsmigratie naar Cuba begon in 1917 en kende pieken in de jaren 1918, 1919 en 1920. Deze migratie drukte een onmiskenbaar stempel op Curaçao, omdat toen grote aantallen mensen vertrokken. Ongeveer 50% van de mannelijke arbeidskrachten op het eiland vertrok in groepsverband. In Cuba werkten zij samen met een nog grotere aantal mensen uit Aruba, Bonaire, de Engelse Cariben, Haïti, Puerto Rico en de Nederlandse Bovenwinden.\r\n\r\nMigratie was niet alleen maar een mannenaangelegenheid. Ook vrouwen emigreerden. Soms sloten zij al op Curaçao een contract met hun werkgevers in het buitenland, zoals bijvoorbeeld het geval was met yaya’s (kindermeisjes) en kokkins van Curaçaose families van Joodse en Protestantse afkomst die naar een ander Caribisch eiland waren verhuisd. Soms emigreerden deze vrouwen echter ook op eigen gelegenheid en vonden ze in het land van bestemming werk als wasvrouw, werkster, kindermeisje en dergelijke.\r\n\r\nZelfs na de komst op Curaçao van de olie-maatschappij in 1915 bleef de migratie van Curaçaose arbeiders naar landen in de Caribische regio aanhouden. Dit bleef tot ongeveer 1923 het geval.', '18. Werkgelegenheid en emigratie tussen 1863 en 1920', '', 'inherit', 'closed', 'closed', '', '41-revision-v1', '', '', '2018-04-27 23:49:41', '2018-04-27 21:49:41', '', '41', 'https://canoncuracao.cw/41-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('595', '4', '2018-04-27 23:54:18', '2018-04-27 21:54:18', '', 'coro railroad2', '', 'inherit', 'open', 'closed', '', 'coro-railroad2', '', '', '2018-04-27 23:54:20', '2018-04-27 21:54:20', '', '41', 'https://canoncuracao.cw/wp-content/uploads/2017/05/coro-railroad2.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('596', '4', '2018-04-27 23:55:08', '2018-04-27 21:55:08', 'Armoede, gebrek aan werk en weinig mobiliteitskansen fungeerden op Curaçao als voornaamste push-factoren voor emigratie in de periode na de emancipatie van de tot slaaf gemaakten in 1863.\r\nVele Curaçaose arbeiders emigreerden naar landen in de regio. De migratie was dus intra-regionaal. In 1838 werd de emigratie van arbeidskrachten bij wet verboden en dit verbod bleef tot 1883 in stand. Toch werd er op 9 juli 1863, acht dagen na de afschaffing van de slavernij, een contract opgesteld tussen 25 vrijgemaakten en een Venezolaanse werkgever om te gaan werken in Venezuela. Op 10 juli 1863 werd er opnieuw een contract getekend met 25 Curaçaose mannen, om op de rivier in Venezuela te gaan varen met lichters en producten af te geven. Dit gebeurde opnieuw op 16 juli 1863. Velen vertrokken echter ook zonder een contract te tekenen.\r\n\r\nLater in de eeuw, in 1882, vertrokken 46 mannen uit Curaçao voor werk bij de bouw van het Panama-kanaal. Daar werden ze opgenomen in een grotere groep van in totaal 130.000 arbeiders uit de Engelse Cariben. In die zelfde periode vertrokken er Curaçaoënaars naar Venezuela, Costa Rica en Colombia. Zij gingen zij daar seizoenarbeid verrichten op de suikerriet- en bananenplantages.\r\n\r\nCuraçaose arbeiders vertrokken ook naar de Dominicaanse Republiek. In 1862, bijvoorbeeld, gingen enkele metselaars, timmerlieden en dagloners daar een jaar lang werken. Behalve ambachtslieden emigreerden er ook arbeiders om te werken op de suikerrietplantages. Dit gebeurde vooral tijdens de onafhankelijkheidsoorlogen op Cuba, waarbij de suikerproductie aldaar verlegd werd naar de Dominicaanse Republiek.\r\n\r\nDe arbeidsmigratie naar Cuba begon in 1917 en kende pieken in de jaren 1918, 1919 en 1920. Deze migratie drukte een onmiskenbaar stempel op Curaçao, omdat toen grote aantallen mensen vertrokken. Ongeveer 50% van de mannelijke arbeidskrachten op het eiland vertrok in groepsverband. In Cuba werkten zij samen met een nog grotere aantal mensen uit Aruba, Bonaire, de Engelse Cariben, Haïti, Puerto Rico en de Nederlandse Bovenwinden.\r\n\r\nMigratie was niet alleen maar een mannenaangelegenheid. Ook vrouwen emigreerden. Soms sloten zij al op Curaçao een contract met hun werkgevers in het buitenland, zoals bijvoorbeeld het geval was met yaya’s (kindermeisjes) en kokkins van Curaçaose families van Joodse en Protestantse afkomst die naar een ander Caribisch eiland waren verhuisd. Soms emigreerden deze vrouwen echter ook op eigen gelegenheid en vonden ze in het land van bestemming werk als wasvrouw, werkster, kindermeisje en dergelijke.\r\n\r\nZelfs na de komst op Curaçao van de olie-maatschappij in 1915 bleef de migratie van Curaçaose arbeiders naar landen in de Caribische regio aanhouden. Dit bleef tot ongeveer 1923 het geval.', '18. Werkgelegenheid en emigratie tussen 1863 en 1920', '', 'inherit', 'closed', 'closed', '', '41-revision-v1', '', '', '2018-04-27 23:55:08', '2018-04-27 21:55:08', '', '41', 'https://canoncuracao.cw/41-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('597', '4', '2018-04-27 23:57:18', '2018-04-27 21:57:18', 'Armoede, gebrek aan werk en weinig mobiliteitskansen fungeerden op Curaçao als voornaamste push-factoren voor emigratie in de periode na de emancipatie van de tot slaaf gemaakten in 1863.\r\nVele Curaçaose arbeiders emigreerden naar landen in de regio. De migratie was dus intra-regionaal. In 1838 werd de emigratie van arbeidskrachten bij wet verboden en dit verbod bleef tot 1883 in stand. Toch werd er op 9 juli 1863, acht dagen na de afschaffing van de slavernij, een contract opgesteld tussen 25 vrijgemaakten en een Venezolaanse werkgever om te gaan werken in Venezuela. Op 10 juli 1863 werd er opnieuw een contract getekend met 25 Curaçaose mannen, om op de rivier in Venezuela te gaan varen met lichters en producten af te geven. Dit gebeurde opnieuw op 16 juli 1863. Velen vertrokken echter ook zonder een contract te tekenen.\r\n\r\nLater in de eeuw, in 1882, vertrokken 46 mannen uit Curaçao voor werk bij de bouw van het Panama-kanaal. Daar werden ze opgenomen in een grotere groep van in totaal 130.000 arbeiders uit de Engelse Cariben. In die zelfde periode vertrokken er Curaçaoënaars naar Venezuela, Costa Rica en Colombia. Zij gingen zij daar seizoenarbeid verrichten op de suikerriet- en bananenplantages.\r\n\r\nCuraçaose arbeiders vertrokken ook naar de Dominicaanse Republiek. In 1862, bijvoorbeeld, gingen enkele metselaars, timmerlieden en dagloners daar een jaar lang werken. Behalve ambachtslieden emigreerden er ook arbeiders om te werken op de suikerrietplantages. Dit gebeurde vooral tijdens de onafhankelijkheidsoorlogen op Cuba, waarbij de suikerproductie aldaar verlegd werd naar de Dominicaanse Republiek.\r\n\r\nDe arbeidsmigratie naar Cuba begon in 1917 en kende pieken in de jaren 1918, 1919 en 1920. Deze migratie drukte een onmiskenbaar stempel op Curaçao, omdat toen grote aantallen mensen vertrokken. Ongeveer 50% van de mannelijke arbeidskrachten op het eiland vertrok in groepsverband. In Cuba werkten zij samen met een nog grotere aantal mensen uit Aruba, Bonaire, de Engelse Cariben, Haïti, Puerto Rico en de Nederlandse Bovenwinden.\r\n\r\nMigratie was niet alleen maar een mannenaangelegenheid. Ook vrouwen emigreerden. Soms sloten zij al op Curaçao een contract met hun werkgevers in het buitenland, zoals bijvoorbeeld het geval was met yaya’s (kindermeisjes) en kokkins van Curaçaose families van Joodse en Protestantse afkomst die naar een ander Caribisch eiland waren verhuisd. Soms emigreerden deze vrouwen echter ook op eigen gelegenheid en vonden ze in het land van bestemming werk als wasvrouw, werkster, kindermeisje en dergelijke.\r\n\r\nZelfs na de komst op Curaçao van de olie-maatschappij in 1915 bleef de migratie van Curaçaose arbeiders naar landen in de Caribische regio aanhouden. Dit bleef tot ongeveer 1923 het geval.', '18. Werkgelegenheid en emigratie tussen 1863 en 1920', '', 'inherit', 'closed', 'closed', '', '41-revision-v1', '', '', '2018-04-27 23:57:18', '2018-04-27 21:57:18', '', '41', 'https://canoncuracao.cw/41-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('598', '4', '2018-04-27 23:57:54', '2018-04-27 21:57:54', 'Armoede, gebrek aan werk en weinig mobiliteitskansen fungeerden op Curaçao als voornaamste push-factoren voor emigratie in de periode na de emancipatie van de tot slaaf gemaakten in 1863.\r\nVele Curaçaose arbeiders emigreerden naar landen in de regio. De migratie was dus intra-regionaal. In 1838 werd de emigratie van arbeidskrachten bij wet verboden en dit verbod bleef tot 1883 in stand. Toch werd er op 9 juli 1863, acht dagen na de afschaffing van de slavernij, een contract opgesteld tussen 25 vrijgemaakten en een Venezolaanse werkgever om te gaan werken in Venezuela. Op 10 juli 1863 werd er opnieuw een contract getekend met 25 Curaçaose mannen, om op de rivier in Venezuela te gaan varen met lichters en producten af te geven. Dit gebeurde opnieuw op 16 juli 1863. Velen vertrokken echter ook zonder een contract te tekenen.\r\n\r\nLater in de eeuw, in 1882, vertrokken 46 mannen uit Curaçao voor werk bij de bouw van het Panama-kanaal. Daar werden ze opgenomen in een grotere groep van in totaal 130.000 arbeiders uit de Engelse Cariben. In die zelfde periode vertrokken er Curaçaoënaars naar Venezuela, Costa Rica en Colombia. Zij gingen zij daar seizoenarbeid verrichten op de suikerriet- en bananenplantages.\r\n\r\nCuraçaose arbeiders vertrokken ook naar de Dominicaanse Republiek. In 1862, bijvoorbeeld, gingen enkele metselaars, timmerlieden en dagloners daar een jaar lang werken. Behalve ambachtslieden emigreerden er ook arbeiders om te werken op de suikerrietplantages. Dit gebeurde vooral tijdens de onafhankelijkheidsoorlogen op Cuba, waarbij de suikerproductie aldaar verlegd werd naar de Dominicaanse Republiek.\r\n\r\nDe arbeidsmigratie naar Cuba begon in 1917 en kende pieken in de jaren 1918, 1919 en 1920. Deze migratie drukte een onmiskenbaar stempel op Curaçao, omdat toen grote aantallen mensen vertrokken. Ongeveer 50% van de mannelijke arbeidskrachten op het eiland vertrok in groepsverband. In Cuba werkten zij samen met een nog grotere aantal mensen uit Aruba, Bonaire, de Engelse Cariben, Haïti, Puerto Rico en de Nederlandse Bovenwinden.\r\n\r\nMigratie was niet alleen maar een mannenaangelegenheid. Ook vrouwen emigreerden. Soms sloten zij al op Curaçao een contract met hun werkgevers in het buitenland, zoals bijvoorbeeld het geval was met yaya’s (kindermeisjes) en kokkins van Curaçaose families van Joodse en Protestantse afkomst die naar een ander Caribisch eiland waren verhuisd. Soms emigreerden deze vrouwen echter ook op eigen gelegenheid en vonden ze in het land van bestemming werk als wasvrouw, werkster, kindermeisje en dergelijke.\r\n\r\nZelfs na de komst op Curaçao van de olie-maatschappij in 1915 bleef de migratie van Curaçaose arbeiders naar landen in de Caribische regio aanhouden. Dit bleef tot ongeveer 1923 het geval.', '18. Werkgelegenheid en emigratie tussen 1863 en 1920', '', 'inherit', 'closed', 'closed', '', '41-revision-v1', '', '', '2018-04-27 23:57:54', '2018-04-27 21:57:54', '', '41', 'https://canoncuracao.cw/41-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('600', '4', '2018-04-28 01:17:18', '2018-04-27 23:17:18', 'In het verleden waren de twee belangrijkste vormen van mijnbouw op Curaçao: de zoutwinning en de fosfaatwinning.\r\n\r\nIn Nederland was in de zeventiende eeuw de haringvisserij een belangrijk bestaansmiddel, waarbij zout diende om de haring te conserveren. Door de Tachtigjarige Oorlog kon men geen zout in Portugal en Spanje meer kopen. Men moest op andere plaatsen zout gaan zoeken  en  onder andere  om deze reden  werd Curaçao veroverd. Na het einde van deze oorlog was de zoutwinning op deze eilanden veel minder belangrijk voor Nederland en het Curaçaose zout ging vanaf toen vooral naar de Verenigde Staten en de Caribische eilanden.\r\n\r\nPas in de negentiende eeuw ging men over tot de aanleg van zoutpannen. De resten hiervan kunnen nog steeds bij vele binnenbaaien gevonden worden.   In de Saliña Sint Marie hadden de vier plantages  Hermanus, Jan Kok,  Rif Sint Marie en Siberië ieder hun eigen zoutpan. In de Santa Marthabaai lagen de zoutpannen van de plantages  Groot Santa Martha, Klein Santa Martha en San Nicolas. De plantages die naast hun agrarische activiteiten ook zout wonnen, werden zoutplantages genoemd.   Door vele problemen  met de afzet van het zout en het gebrek aan arbeidskrachten ging de zoutwinning in de twintigste eeuw op Curaçao ten onder.\r\n\r\nIn 1871 werd op Klein Curaçao ‘guano’ (dat voornamelijk uit vogel-uitwerpselen bestaat) ontdekt door de Engelse ingenieur John Godden en in de jaren daarna werd de laag, die ongeveer een halve meter dik was, afgegraven en als mes voor landbouw verkocht.\r\n\r\nIn 1875 werden rijke fosfaatafzettingen gevonden bij de Tafelberg op Santa Barbara. Fosfaat ontstaat  uit  guano-afzettingen.  Dit  drong  het kalkgesteente in  en werd omgevormd tot fosfaat.  De fosfaat op Curaçao had een hoge marktwaarde, omdat het weinig fluor bevatte en daardoor ook gebruikt kon worden als  pluimveevoer.  Aan de Fuikbaai bouwde Godden de infrastructuur en de gebouwen bij het dorpje Nieuwpoort die nodig waren om de fosfaatproduktie op poten te zetten.  In de tachtiger jaren van de negentiende eeuw  ontstonden er echter conflicten tussen  Godden  en  de mede-eigenaren: de  wereldmarktprijzen daalden  en  John Godden wilde  daarom minder royalties uitkeren aan de mede-eigenaren.  Dit leidde toen toch niet tot een oplossing van de problemen  en Godden stopte daarom in 1895 met de uitvoer. Dit had fatale gevolgen voor de werkgelegenheid en overheidsinkomsten.  Pas na 17 jaren  werd in 1912 de fosfaatwinning hervat .  In de jaren daarna ging men verder met de ontginning.  Het gehalte van fosfaat werd echter steeds minder en uiteindelijk werd in 1979 de fosfaatwinning stopgezet. De mijnmaatschappij is nog steeds actief, maar de produktie werd beperkt tot kalksteen dat vooral voor de lokale bouwmarkt bestemd is.', '19. Mijnbouw', '', 'inherit', 'closed', 'closed', '', '43-revision-v1', '', '', '2018-04-28 01:17:18', '2018-04-27 23:17:18', '', '43', 'https://canoncuracao.cw/43-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('601', '4', '2018-04-28 01:22:39', '2018-04-27 23:22:39', '', 'Zout001', '', 'inherit', 'open', 'closed', '', 'zout001-2', '', '', '2018-04-28 01:22:43', '2018-04-27 23:22:43', '', '43', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Zout001-1.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('602', '4', '2018-04-28 01:23:45', '2018-04-27 23:23:45', '', 'Fischer-e10-1024x829', '', 'inherit', 'open', 'closed', '', 'fischer-e10-1024x829', '', '', '2018-04-28 01:23:48', '2018-04-27 23:23:48', '', '43', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Fischer-e10-1024x829.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('603', '4', '2018-04-28 01:26:35', '2018-04-27 23:26:35', 'In het verleden waren de twee belangrijkste vormen van mijnbouw op Curaçao: de zoutwinning en de fosfaatwinning.\r\n\r\nIn Nederland was in de zeventiende eeuw de haringvisserij een belangrijk bestaansmiddel, waarbij zout diende om de haring te conserveren. Door de Tachtigjarige Oorlog kon men geen zout in Portugal en Spanje meer kopen. Men moest op andere plaatsen zout gaan zoeken  en  onder andere  om deze reden  werd Curaçao veroverd. Na het einde van deze oorlog was de zoutwinning op deze eilanden veel minder belangrijk voor Nederland en het Curaçaose zout ging vanaf toen vooral naar de Verenigde Staten en de Caribische eilanden.\r\n\r\nPas in de negentiende eeuw ging men over tot de aanleg van zoutpannen. De resten hiervan kunnen nog steeds bij vele binnenbaaien gevonden worden.   In de Saliña Sint Marie hadden de vier plantages  Hermanus, Jan Kok,  Rif Sint Marie en Siberië ieder hun eigen zoutpan. In de Santa Marthabaai lagen de zoutpannen van de plantages  Groot Santa Martha, Klein Santa Martha en San Nicolas. De plantages die naast hun agrarische activiteiten ook zout wonnen, werden zoutplantages genoemd.   Door vele problemen  met de afzet van het zout en het gebrek aan arbeidskrachten ging de zoutwinning in de twintigste eeuw op Curaçao ten onder.\r\n\r\nIn 1871 werd op Klein Curaçao ‘guano’ (dat voornamelijk uit vogel-uitwerpselen bestaat) ontdekt door de Engelse ingenieur John Godden en in de jaren daarna werd de laag, die ongeveer een halve meter dik was, afgegraven en als mes voor landbouw verkocht.\r\n\r\nIn 1875 werden rijke fosfaatafzettingen gevonden bij de Tafelberg op Santa Barbara. Fosfaat ontstaat  uit  guano-afzettingen.  Dit  drong  het kalkgesteente in  en werd omgevormd tot fosfaat.  De fosfaat op Curaçao had een hoge marktwaarde, omdat het weinig fluor bevatte en daardoor ook gebruikt kon worden als  pluimveevoer.  Aan de Fuikbaai bouwde Godden de infrastructuur en de gebouwen bij het dorpje Nieuwpoort die nodig waren om de fosfaatproduktie op poten te zetten.  In de tachtiger jaren van de negentiende eeuw  ontstonden er echter conflicten tussen  Godden  en  de mede-eigenaren: de  wereldmarktprijzen daalden  en  John Godden wilde  daarom minder royalties uitkeren aan de mede-eigenaren.  Dit leidde toen toch niet tot een oplossing van de problemen  en Godden stopte daarom in 1895 met de uitvoer. Dit had fatale gevolgen voor de werkgelegenheid en overheidsinkomsten.  Pas na 17 jaren  werd in 1912 de fosfaatwinning hervat .  In de jaren daarna ging men verder met de ontginning.  Het gehalte van fosfaat werd echter steeds minder en uiteindelijk werd in 1979 de fosfaatwinning stopgezet. De mijnmaatschappij is nog steeds actief, maar de produktie werd beperkt tot kalksteen dat vooral voor de lokale bouwmarkt bestemd is.', '19. Mijnbouw', '', 'inherit', 'closed', 'closed', '', '43-revision-v1', '', '', '2018-04-28 01:26:35', '2018-04-27 23:26:35', '', '43', 'https://canoncuracao.cw/43-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('604', '4', '2020-10-31 13:32:46', '2020-10-31 12:32:46', 'Vanaf de vroege Spaanse tijd werd Curaçao bezocht door overwegend uit de regio afkomstige Spaanssprekende katholieke priesters. Deze priesters verbleven tijdelijk op het eiland om de tot slaaf gemaakten te dopen en zielzorg te bieden. In 1715 werd Curaçao formeel een katholiek missiegebied. Pas na 1800 ging de zielzorg gaandeweg over van regionale priesters naar de Nederlandse katholieke kerk.\n\nDat de Nederlandse katholieke missie in deze kolonie begin negentiende eeuw werd versterkt hing waarschijnlijk samen met de grote onrust in de regio na de succesvolle <a href=\"https://canoncuracao.cw/9-curacao-rond-1800/\">slavenopstand in Haïti</a> aan het eind van de achttiende eeuw. Uiteindelijk werd in 1824 voor Curaçao een doortastende geestelijke aangesteld: monseigneur Martinus Niewindt. Hij bleef hier tot zijn dood in 1860 en legde het fundament voor een duurzame katholieke missie. Zijn prioriteit werd het dopen van alle Afro-Curaçaoënaars en de vorming van leefgemeenschappen in parochies. In deze periode legden enkele priesters zich toe op de ontwikkeling van het geschreven Papiaments.\n\nToen Rome in 1868 besloot om de verantwoordelijkheid voor dit vicariaat aan de Nederlandse provincie van de orde der Dominicanen te geven, was dat met als doel het ‘beschaven’ van de overwegend arme, maar gedoopte Afro-Curaçaose bevolking, circa 85% van de totale bevolking. De priesters waren overwegend Nederlanders; dit was tot 1970 een contractueel vastgelegde afspraak. De missie kreeg daarmee een koloniale inslag: niet het ontwikkelen van een lokale katholieke kerk, maar het ‘beschavingswerk’ binnen een Nederlands katholiek kader stond centraal.\n\nDe invloed van de katholieke kerk op de bevolking werd in de loop van de negentiende eeuw aanzienlijk met de komst van de Zusters van Breda in de gezondheidszorg en de Zusters van Roosendaal en Fraters van Tilburg in het onderwijs. In 1920 werden ook de Zusters van Schijndel aangetrokken om het onderwijs in de <a href=\"https://canoncuracao.cw/11-ontwikkeling-nederzettingen-en-barios-buiten-willemstad/\">buitendistricten</a> en op de <a href=\"https://canoncuracao.cw/41-onderwijs-op-curacao/\">arme scholen</a> in de stad over te nemen. Dit maakte deel uit van een steeds verder doorgevoerd klassenonderscheid.\n\nDe katholieke kerk droeg op deze wijze onmiskenbaar bij aan klassenonderscheid binnen de Curaçaose maatschappij.\n\nVooral de door de <a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">raffinaderij</a> ontstane katholieke middenklasse, rond 1935 circa 15% van de bevolking, kon medio twintigste eeuw op de aandacht van de katholieke kerk rekenen. Deze aandacht bestond uit de ontwikkeling van een katholiek stedelijk verenigingsleven en de uitbreiding van de <a href=\"https://canoncuracao.cw/51-media/\">katholieke pers</a>. In de politiek was de <a href=\"https://canoncuracao.cw/48-de-politieke-partijen/\">Katholieke Partij</a> tussen 1937 en 1962 actief. <span lang=\"NL\">Een brede </span><span lang=\"NL\">‘</span><span lang=\"NL\">volkspartij</span><span lang=\"NL\">’</span><span lang=\"NL\"> is de KVP nooit geworden; voor de katholieke volksklasse was het steunen van de KVP op geen enkele wijze vanzelfsprekend.</span>', '20. De komst van katholieke religieuzen uit Nederland', '', 'inherit', 'closed', 'closed', '', '45-autosave-v1', '', '', '2020-10-31 13:32:46', '2020-10-31 12:32:46', '', '45', 'https://canoncuracao.cw/45-autosave-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('605', '4', '2018-04-28 02:14:09', '2018-04-28 00:14:09', 'Vanaf de vroege Spaanse tijd werd Curaçao bezocht door overwegend uit de regio afkomstige Spaanssprekende katholieke priesters. Deze priesters verbleven tijdelijk op het eiland om de tot slaaf gemaakten te dopen en zielzorg te bieden. In 1715 werd Curaçao formeel een katholiek missiegebied. Pas na 1800 ging de zielzorg gaandeweg over van regionale priesters naar de Nederlandse katholieke kerk.\r\n\r\nDat de Nederlandse katholieke missie in deze kolonie begin negentiende eeuw werd versterkt hing waarschijnlijk samen met de grote onrust in de regio na de succesvolle slavenopstand in Haïti aan het eind van de achttiende eeuw. (zie ook venster 9) Uiteindelijk werd in 1824 voor Curaçao een doortastende geestelijke aangesteld: monseigneur Martinus Niewindt. Hij bleef hier tot zijn dood in 1860 en legde het fundament voor een duurzame katholieke missie. Zijn prioriteit werd het dopen van alle Afro-Curaçaoënaars en de vorming van leefgemeenschappen rond parochies. In deze periode legden enkele priesters zich toe op de ontwikkeling van het geschreven Papiaments.\r\n\r\nToen Rome in 1868 besloot om de verantwoordelijkheid voor dit vicariaat aan de Nederlandse provincie van de orde der Dominicanen te geven, was dat met als doel het ‘beschaven’ van de overwegend arme, maar gedoopte Afro-Curaçaose bevolking, circa 85% van de totale bevolking. De priesters waren overwegend Nederlanders; dit was tot 1970 een contractueel vastgelegde afspraak.De missie kreeg daarmee een koloniale inslag: niet het ontwikkelen van een lokale katholieke kerk, maar het ‘beschavingswerk’ binnen een Nederlands katholiek kader stond centraal.\r\n\r\nDe invloed van de katholieke kerk op de bevolking werd in de loop van de negentiende eeuw aanzienlijk met de komst van de Zusters van Breda in de gezondheidszorg en de Zusters van Roosendaal en Fraters van Tilburg in het onderwijs. In 1920 werden ook de Zusters van Schijndel aangetrokken om het onderwijs in de buitendistricten en op de arme scholen in de stad over te nemen. Dit maakte deel uit van een steeds verder doorgevoerd klassenonderscheid.\r\n\r\nDe katholieke kerk droeg op deze wijze onmiskenbaar bij aan klassenonderscheid binnen de Curaçaose maatschappij. Aan de andere kant moet worden gezegd dat de inspanningen van de priesters, fraters, broeders en zusters een grote bijdrage hebben geleverd aan het onderwijs en de gezondheidszorg op het eiland. Veel inwoners van Curaçao hebben de kans gekregen om te stijgen op de sociale ladder dankzij de inzet van de katholiek kerk.\r\n\r\nVooral de door de raffinaderij ontstane katholieke middenklasse, rond 1935 circa 15% van de bevolking, kon medio twintigste eeuw op de aandacht van de katholieke kerk rekenen. Deze aandacht bestond uit de ontwikkeling van een katholiek stedelijk verenigingsleven en de uitbreiding van de katholieke pers. In de politiek was de Katholieke Partij tussen 1937 en 1962 actief. Een brede volkspartij is dit nooit geworden. De katholieke volksklasse stond op afstand van politiek-maatschappelijke participatie en voor hen was loyaliteit aan katholieke politiek niet vanzelfsprekend.', '20. De komst van priesters en andere katholieke religieuzen uit Nederland', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2018-04-28 02:14:09', '2018-04-28 00:14:09', '', '45', 'https://canoncuracao.cw/45-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('606', '4', '2018-04-28 02:15:49', '2018-04-28 00:15:49', 'Vanaf de vroege Spaanse tijd werd Curaçao bezocht door overwegend uit de regio afkomstige Spaanssprekende katholieke priesters. Deze priesters verbleven tijdelijk op het eiland om de tot slaaf gemaakten te dopen en zielzorg te bieden. In 1715 werd Curaçao formeel een katholiek missiegebied. Pas na 1800 ging de zielzorg gaandeweg over van regionale priesters naar de Nederlandse katholieke kerk.\r\n\r\nDat de Nederlandse katholieke missie in deze kolonie begin negentiende eeuw werd versterkt hing waarschijnlijk samen met de grote onrust in de regio na de succesvolle slavenopstand in Haïti aan het eind van de achttiende eeuw. (zie ook venster 9) Uiteindelijk werd in 1824 voor Curaçao een doortastende geestelijke aangesteld: monseigneur Martinus Niewindt. Hij bleef hier tot zijn dood in 1860 en legde het fundament voor een duurzame katholieke missie. Zijn prioriteit werd het dopen van alle Afro-Curaçaoënaars en de vorming van leefgemeenschappen rond parochies. In deze periode legden enkele priesters zich toe op de ontwikkeling van het geschreven Papiaments.\r\n\r\nToen Rome in 1868 besloot om de verantwoordelijkheid voor dit vicariaat aan de Nederlandse provincie van de orde der Dominicanen te geven, was dat met als doel het ‘beschaven’ van de overwegend arme, maar gedoopte Afro-Curaçaose bevolking, circa 85% van de totale bevolking. De priesters waren overwegend Nederlanders; dit was tot 1970 een contractueel vastgelegde afspraak.De missie kreeg daarmee een koloniale inslag: niet het ontwikkelen van een lokale katholieke kerk, maar het ‘beschavingswerk’ binnen een Nederlands katholiek kader stond centraal.\r\n\r\nDe invloed van de katholieke kerk op de bevolking werd in de loop van de negentiende eeuw aanzienlijk met de komst van de Zusters van Breda in de gezondheidszorg en de Zusters van Roosendaal en Fraters van Tilburg in het onderwijs. In 1920 werden ook de Zusters van Schijndel aangetrokken om het onderwijs in de buitendistricten en op de arme scholen in de stad over te nemen. Dit maakte deel uit van een steeds verder doorgevoerd klassenonderscheid.\r\n\r\nDe katholieke kerk droeg op deze wijze onmiskenbaar bij aan klassenonderscheid binnen de Curaçaose maatschappij. Aan de andere kant moet worden gezegd dat de inspanningen van de priesters, fraters, broeders en zusters een grote bijdrage hebben geleverd aan het onderwijs en de gezondheidszorg op het eiland. Veel inwoners van Curaçao hebben de kans gekregen om te stijgen op de sociale ladder dankzij de inzet van de katholiek kerk.\r\n\r\nVooral de door de raffinaderij ontstane katholieke middenklasse, rond 1935 circa 15% van de bevolking, kon medio twintigste eeuw op de aandacht van de katholieke kerk rekenen. Deze aandacht bestond uit de ontwikkeling van een katholiek stedelijk verenigingsleven en de uitbreiding van de katholieke pers. In de politiek was de Katholieke Partij tussen 1937 en 1962 actief. Een brede volkspartij is dit nooit geworden. De katholieke volksklasse stond op afstand van politiek-maatschappelijke participatie en voor hen was loyaliteit aan katholieke politiek niet vanzelfsprekend.', '20. De komst van priesters en andere katholieke religieuzen uit Nederland', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2018-04-28 02:15:49', '2018-04-28 00:15:49', '', '45', 'https://canoncuracao.cw/45-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('607', '4', '2018-04-28 02:17:15', '2018-04-28 00:17:15', 'Vanaf de vroege Spaanse tijd werd Curaçao bezocht door overwegend uit de regio afkomstige Spaanssprekende katholieke priesters. Deze priesters verbleven tijdelijk op het eiland om de tot slaaf gemaakten te dopen en zielzorg te bieden. In 1715 werd Curaçao formeel een katholiek missiegebied. Pas na 1800 ging de zielzorg gaandeweg over van regionale priesters naar de Nederlandse katholieke kerk.\r\n\r\nDat de Nederlandse katholieke missie in deze kolonie begin negentiende eeuw werd versterkt hing waarschijnlijk samen met de grote onrust in de regio na de succesvolle slavenopstand in Haïti aan het eind van de achttiende eeuw. (zie ook <a href=\"https://canoncuracao.cw/9-curacao-rond-1800/\">venster 9</a>) Uiteindelijk werd in 1824 voor Curaçao een doortastende geestelijke aangesteld: monseigneur Martinus Niewindt. Hij bleef hier tot zijn dood in 1860 en legde het fundament voor een duurzame katholieke missie. Zijn prioriteit werd het dopen van alle Afro-Curaçaoënaars en de vorming van leefgemeenschappen rond parochies. In deze periode legden enkele priesters zich toe op de ontwikkeling van het geschreven Papiaments.\r\n\r\nToen Rome in 1868 besloot om de verantwoordelijkheid voor dit vicariaat aan de Nederlandse provincie van de orde der Dominicanen te geven, was dat met als doel het ‘beschaven’ van de overwegend arme, maar gedoopte Afro-Curaçaose bevolking, circa 85% van de totale bevolking. De priesters waren overwegend Nederlanders; dit was tot 1970 een contractueel vastgelegde afspraak.De missie kreeg daarmee een koloniale inslag: niet het ontwikkelen van een lokale katholieke kerk, maar het ‘beschavingswerk’ binnen een Nederlands katholiek kader stond centraal.\r\n\r\nDe invloed van de katholieke kerk op de bevolking werd in de loop van de negentiende eeuw aanzienlijk met de komst van de Zusters van Breda in de gezondheidszorg en de Zusters van Roosendaal en Fraters van Tilburg in het onderwijs. In 1920 werden ook de Zusters van Schijndel aangetrokken om het onderwijs in de buitendistricten en op de arme scholen in de stad over te nemen. Dit maakte deel uit van een steeds verder doorgevoerd klassenonderscheid.\r\n\r\nDe katholieke kerk droeg op deze wijze onmiskenbaar bij aan klassenonderscheid binnen de Curaçaose maatschappij. Aan de andere kant moet worden gezegd dat de inspanningen van de priesters, fraters, broeders en zusters een grote bijdrage hebben geleverd aan het onderwijs en de gezondheidszorg op het eiland. Veel inwoners van Curaçao hebben de kans gekregen om te stijgen op de sociale ladder dankzij de inzet van de katholiek kerk.\r\n\r\nVooral de door de raffinaderij ontstane katholieke middenklasse, rond 1935 circa 15% van de bevolking, kon medio twintigste eeuw op de aandacht van de katholieke kerk rekenen. Deze aandacht bestond uit de ontwikkeling van een katholiek stedelijk verenigingsleven en de uitbreiding van de katholieke pers. In de politiek was de Katholieke Partij tussen 1937 en 1962 actief. Een brede volkspartij is dit nooit geworden. De katholieke volksklasse stond op afstand van politiek-maatschappelijke participatie en voor hen was loyaliteit aan katholieke politiek niet vanzelfsprekend.', '20. De komst van priesters en andere katholieke religieuzen uit Nederland', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2018-04-28 02:17:15', '2018-04-28 00:17:15', '', '45', 'https://canoncuracao.cw/45-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('608', '4', '2018-04-28 02:21:18', '2018-04-28 00:21:18', 'Vanaf de vroege Spaanse tijd werd Curaçao bezocht door overwegend uit de regio afkomstige Spaanssprekende katholieke priesters. Deze priesters verbleven tijdelijk op het eiland om de tot slaaf gemaakten te dopen en zielzorg te bieden. In 1715 werd Curaçao formeel een katholiek missiegebied. Pas na 1800 ging de zielzorg gaandeweg over van regionale priesters naar de Nederlandse katholieke kerk.\r\n\r\nDat de Nederlandse katholieke missie in deze kolonie begin negentiende eeuw werd versterkt hing waarschijnlijk samen met de grote onrust in de regio na de succesvolle slavenopstand in Haïti aan het eind van de achttiende eeuw. (zie ook <a href=\"https://canoncuracao.cw/9-curacao-rond-1800/\">venster 9</a>) Uiteindelijk werd in 1824 voor Curaçao een doortastende geestelijke aangesteld: monseigneur Martinus Niewindt. Hij bleef hier tot zijn dood in 1860 en legde het fundament voor een duurzame katholieke missie. Zijn prioriteit werd het dopen van alle Afro-Curaçaoënaars en de vorming van leefgemeenschappen rond parochies. In deze periode legden enkele priesters zich toe op de ontwikkeling van het geschreven Papiaments.\r\n\r\nToen Rome in 1868 besloot om de verantwoordelijkheid voor dit vicariaat aan de Nederlandse provincie van de orde der Dominicanen te geven, was dat met als doel het ‘beschaven’ van de overwegend arme, maar gedoopte Afro-Curaçaose bevolking, circa 85% van de totale bevolking. De priesters waren overwegend Nederlanders; dit was tot 1970 een contractueel vastgelegde afspraak.De missie kreeg daarmee een koloniale inslag: niet het ontwikkelen van een lokale katholieke kerk, maar het ‘beschavingswerk’ binnen een Nederlands katholiek kader stond centraal.\r\n\r\nDe invloed van de katholieke kerk op de bevolking werd in de loop van de negentiende eeuw aanzienlijk met de komst van de Zusters van Breda in de gezondheidszorg en de Zusters van Roosendaal en Fraters van Tilburg in het onderwijs. In 1920 werden ook de Zusters van Schijndel aangetrokken om het onderwijs in de buitendistricten en op de arme scholen in de stad over te nemen. Dit maakte deel uit van een steeds verder doorgevoerd klassenonderscheid.\r\n\r\nDe katholieke kerk droeg op deze wijze onmiskenbaar bij aan klassenonderscheid binnen de Curaçaose maatschappij. Aan de andere kant moet worden gezegd dat de inspanningen van de priesters, fraters, broeders en zusters een grote bijdrage hebben geleverd aan het onderwijs en de gezondheidszorg op het eiland. Veel inwoners van Curaçao hebben de kans gekregen om te stijgen op de sociale ladder dankzij de inzet van de katholiek kerk.\r\n\r\nVooral de door de raffinaderij ontstane katholieke middenklasse, rond 1935 circa 15% van de bevolking, kon medio twintigste eeuw op de aandacht van de katholieke kerk rekenen. Deze aandacht bestond uit de ontwikkeling van een katholiek stedelijk verenigingsleven en de uitbreiding van de katholieke pers. In de politiek was de Katholieke Partij tussen 1937 en 1962 actief. Een brede volkspartij is dit nooit geworden. De katholieke volksklasse stond op afstand van politiek-maatschappelijke participatie en voor hen was loyaliteit aan katholieke politiek niet vanzelfsprekend.', '20. De komst van katholieke religieuzen uit Nederland', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2018-04-28 02:21:18', '2018-04-28 00:21:18', '', '45', 'https://canoncuracao.cw/45-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('610', '4', '2018-04-28 02:26:38', '2018-04-28 00:26:38', 'In het begin van de 20ste eeuw zien wij een grote immigratiestroom richting Curaçao op gang komen. Dit was het direct gevolg van de vestiging van een grote Shell raffinaderij op het eiland (<a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">venster 21</a>), die behoefte had aan veel arbeidskrachten, zowel om de olieraffinaderij te bouwen als om deze te laten draaien. Veel Curaçaoënaars werden in dienst genomen, maar al gauw  moesten noodgedwongen ook werklieden uit andere landen gehaald worden. Velen kwamen op contractbasis.\r\n\r\nNaast veel Nederlandse employees en werklieden kwamen de werknemers vooral van de andere eilanden van de Nederlandse Antillen, uit Suriname, Venezuela en Colombia, maar ook van de Britse en Franse eilanden in het Caribisch gebied en zelfs van Madeira. In het begin kwamen voornamelijk mannen maar later ook vrouwen, in het kader van de gezinshereniging. Zij gingen vaak als hulp in de huishouding werken. Er kwamen in deze tijd niet alleen arbeidsimmigranten naar Curaçao, maar ook kleine handelaren uit Libanon, Oost Europa (met name de Ashkenazische joden), India en China, die door de economische vooruitgang werden aangetrokken.\r\n\r\nAlleen in jaren van crisis (1930-1935) en oorlog (1939-1944) daalde de immigratie, maar direct daarna  werd Curaçao weer een echt vestigingsland met  zeer veel verschillende nationaliteiten. In 1936 waren de meeste immigranten afkomstig van Engelssprekende eilanden, Nederland en Suriname, maar de Portugezen uit Madeira vormden in 1951 het grootse contingent.  Aangezien het voornamelijk arbeidsmigranten betrof, bleven de meesten maar korte tijd hier. De nakomelingen van degenen die zich hier permanent vestigden, wonen nu al meerdere generaties hier en zijn goed geïntegreerd.\r\n\r\nDoordat de oliemarkt veranderde en door automatisering liep de werkgelegenheid op de raffinaderij sterk terug  in de jaren 50 en 60, met als gevolg dat veel arbeidscontractanten werden ontslagen en naar elders vertrokken. Maar omdat de economie redelijk stabiel was, er relatief goede sociale voorzieningen waren, goede mogelijkheden voor opwaartse sociale  mobiliteit en relatieve politieke rust, kwamen vanaf de jaren 80 weer veel immigranten uit de regio naar Curaçao. Deze nieuwe instroom bestaat voornamelijk uit Colombianen, Dominicanen, Haitianen en Jamaicanen. Zij werken vooral in de dienstverlenende sector en in de bouw. Een aantal van hen beschikt over de juiste immigratiedocumenten, maar er zijn ook veel ongedocumenteerde personen. In de laatste 20 jaar zien wij veel Chinese immigranten en meer recentelijk veel Venezolanen. In 2017 heeft van alle in Curaçao geboren personen 60%  minstens één ouder die elders geboren is.', '22. De nieuwe immigranten op Curaçao vanaf het begin van de twintigste eeuw', '', 'inherit', 'closed', 'closed', '', '49-revision-v1', '', '', '2018-04-28 02:26:38', '2018-04-28 00:26:38', '', '49', 'https://canoncuracao.cw/49-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('611', '4', '2018-04-28 02:33:23', '2018-04-28 00:33:23', '', 'Toeristen in de straat 006', '', 'inherit', 'open', 'closed', '', 'toeristen-in-de-straat-006', '', '', '2018-04-28 02:33:25', '2018-04-28 00:33:25', '', '49', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Toeristen-in-de-straat-006.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('612', '4', '2018-04-28 02:33:39', '2018-04-28 00:33:39', '', 'Heerenstraat met Toeristen 004', '', 'inherit', 'open', 'closed', '', 'heerenstraat-met-toeristen-004', '', '', '2018-04-28 02:33:41', '2018-04-28 00:33:41', '', '49', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Heerenstraat-met-Toeristen-004.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('613', '4', '2018-04-28 02:42:20', '2018-04-28 00:42:20', 'In het begin van de 20ste eeuw zien wij een grote immigratiestroom richting Curaçao op gang komen. Dit was het direct gevolg van de vestiging van een grote Shell raffinaderij op het eiland (<a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">venster 21</a>), die behoefte had aan veel arbeidskrachten, zowel om de olieraffinaderij te bouwen als om deze te laten draaien. Veel Curaçaoënaars werden in dienst genomen, maar al gauw  moesten noodgedwongen ook werklieden uit andere landen gehaald worden. Velen kwamen op contractbasis.\r\n\r\nNaast veel Nederlandse employees en werklieden kwamen de werknemers vooral van de andere eilanden van de Nederlandse Antillen, uit Suriname, Venezuela en Colombia, maar ook van de Britse en Franse eilanden in het Caribisch gebied en zelfs van Madeira. In het begin kwamen voornamelijk mannen maar later ook vrouwen, in het kader van de gezinshereniging. Zij gingen vaak als hulp in de huishouding werken. Er kwamen in deze tijd niet alleen arbeidsimmigranten naar Curaçao, maar ook kleine handelaren uit Libanon, Oost Europa (met name de Ashkenazische joden), India en China, die door de economische vooruitgang werden aangetrokken.\r\n\r\nAlleen in jaren van crisis (1930-1935) en oorlog (1939-1944) daalde de immigratie, maar direct daarna  werd Curaçao weer een echt vestigingsland met  zeer veel verschillende nationaliteiten. In 1936 waren de meeste immigranten afkomstig van Engelssprekende eilanden, Nederland en Suriname, maar de Portugezen uit Madeira vormden in 1951 het grootse contingent.  Aangezien het voornamelijk arbeidsmigranten betrof, bleven de meesten maar korte tijd hier. De nakomelingen van degenen die zich hier permanent vestigden, wonen nu al meerdere generaties hier en zijn goed geïntegreerd.\r\n\r\nDoordat de oliemarkt veranderde en door automatisering liep de werkgelegenheid op de raffinaderij sterk terug  in de jaren 50 en 60, met als gevolg dat veel arbeidscontractanten werden ontslagen en naar elders vertrokken. Maar omdat de economie redelijk stabiel was, er relatief goede sociale voorzieningen waren, goede mogelijkheden voor opwaartse sociale  mobiliteit en relatieve politieke rust, kwamen vanaf de jaren 80 weer veel immigranten uit de regio naar Curaçao. Deze nieuwe instroom bestaat voornamelijk uit Colombianen, Dominicanen, Haitianen en Jamaicanen. Zij werken vooral in de dienstverlenende sector en in de bouw. Een aantal van hen beschikt over de juiste immigratiedocumenten, maar er zijn ook veel ongedocumenteerde personen. In de laatste 20 jaar zien wij veel Chinese immigranten en meer recentelijk veel Venezolanen. In 2017 heeft van alle in Curaçao geboren personen 60%  minstens één ouder die elders geboren is.', '22. De nieuwe immigranten op Curaçao vanaf het begin van de twintigste eeuw', '', 'inherit', 'closed', 'closed', '', '49-revision-v1', '', '', '2018-04-28 02:42:20', '2018-04-28 00:42:20', '', '49', 'https://canoncuracao.cw/49-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('614', '4', '2018-04-28 02:43:28', '2018-04-28 00:43:28', 'In het begin van de 20ste eeuw zien wij een grote immigratiestroom richting Curaçao op gang komen. Dit was het direct gevolg van de vestiging van een grote Shell raffinaderij op het eiland (<a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">venster 21</a>), die behoefte had aan veel arbeidskrachten, zowel om de olieraffinaderij te bouwen als om deze te laten draaien. Veel Curaçaoënaars werden in dienst genomen, maar al gauw  moesten noodgedwongen ook werklieden uit andere landen gehaald worden. Velen kwamen op contractbasis.\r\n\r\nNaast veel Nederlandse employees en werklieden kwamen de werknemers vooral van de andere eilanden van de Nederlandse Antillen, uit Suriname, Venezuela en Colombia, maar ook van de Britse en Franse eilanden in het Caribisch gebied en zelfs van Madeira. In het begin kwamen voornamelijk mannen maar later ook vrouwen, in het kader van de gezinshereniging. Zij gingen vaak als hulp in de huishouding werken. Er kwamen in deze tijd niet alleen arbeidsimmigranten naar Curaçao, maar ook kleine handelaren uit Libanon, Oost Europa (met name de Ashkenazische joden), India en China, die door de economische vooruitgang werden aangetrokken.\r\n\r\nAlleen in jaren van crisis (1930-1935) en oorlog (1939-1944) daalde de immigratie, maar direct daarna  werd Curaçao weer een echt vestigingsland met  zeer veel verschillende nationaliteiten. In 1936 waren de meeste immigranten afkomstig van Engelssprekende eilanden, Nederland en Suriname, maar de Portugezen uit Madeira vormden in 1951 het grootse contingent.  Aangezien het voornamelijk arbeidsmigranten betrof, bleven de meesten maar korte tijd hier. De nakomelingen van degenen die zich hier permanent vestigden, wonen nu al meerdere generaties hier en zijn goed geïntegreerd.\r\n\r\nDoordat de oliemarkt veranderde en door automatisering liep de werkgelegenheid op de raffinaderij sterk terug  in de jaren 50 en 60, met als gevolg dat veel arbeidscontractanten werden ontslagen en naar elders vertrokken. Maar omdat de economie redelijk stabiel was, er relatief goede sociale voorzieningen waren, goede mogelijkheden voor opwaartse sociale  mobiliteit en relatieve politieke rust, kwamen vanaf de jaren 80 weer veel immigranten uit de regio naar Curaçao. Deze nieuwe instroom bestaat voornamelijk uit Colombianen, Dominicanen, Haitianen en Jamaicanen. Zij werken vooral in de dienstverlenende sector en in de bouw. Een aantal van hen beschikt over de juiste immigratiedocumenten, maar er zijn ook veel ongedocumenteerde personen. In de laatste 20 jaar zien wij veel Chinese immigranten en meer recentelijk veel Venezolanen. In 2017 heeft van alle in Curaçao geboren personen 60%  minstens één ouder die elders geboren is.', '22. De nieuwe immigranten op Curaçao vanaf het begin van de twintigste eeuw', '', 'inherit', 'closed', 'closed', '', '49-revision-v1', '', '', '2018-04-28 02:43:28', '2018-04-28 00:43:28', '', '49', 'https://canoncuracao.cw/49-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('615', '4', '2020-01-28 18:16:54', '2020-01-28 17:16:54', 'Voor een eiland zijn havens van cruciaal belang. Vroeger, voor de komst van de luchtvaart, was de zeevaart de enige mogelijkheid voor verkeer van personen en goederen. Momenteel vindt veel vervoer van mensen plaats per vliegtuig, maar het vervoer van goederen gebeurt nog steeds veruit het meest per schip. Voor het laden en lossen van goederen zijn faciliteiten in rustig water met voldoende diepgang van essentieel belang.\n\nRustig water vinden we aan de zuidkust van Curaçao en vooral in de handvormige binnenbaaien en de toegang hiernaartoe. Vanaf het begin van de Nederlandse tijd werd dan ook met name de Sint Annabaai gebruikt als haven en in de twintigste eeuw vooral de handvormige binnenbaai daarachter, het Schottegat. De voornaamste havens zijn op dit moment de Sint Annabaai, het Schottegat, de <a href=\"https://canoncuracao.cw/35-oil-as-king-tot-tourism-as-king/\">megapieren</a> (de cruiseport voor het Rif) en Bullenbaai. In het verleden waren ook de Caracasbaai en Fuikbaai van belang.\n\nDe goede potentiële havenmogelijkheden van de Sint Annabaai waren een belangrijke reden voor de Nederlanders om Curaçao op de Spanjaarden te <a href=\"https://canoncuracao.cw/3-verovering-van-curacao-door-de-wic-en-de-komst-van-de-hollanders/\">veroveren</a>. In de tijd van de <a href=\"https://canoncuracao.cw/3-verovering-van-curacao-door-de-wic-en-de-komst-van-de-hollanders/\">West Indische Compagnie</a> (1634-1791) diende de Sint Annabaai als uitvalsbasis voor de kaapvaart en als strategische handelspost voor de <a href=\"https://canoncuracao.cw/5-de-slavenhandel-en-slaverij/\">slavenhandel</a> en andere handel (o.a. smokkelhandel) en later als vrijhandelshaven. In de <a href=\"https://canoncuracao.cw/9-curacao-rond-1800/\">Engelse tijd</a> (1800-1803 en 1807-1816) werd door de Engelsen besloten dat Curaçao zijn vrijhavenstatus moest opgeven, waardoor de havenactiviteiten drastisch inkrompen.\n\nIn de negentiende eeuw fungeerde de haven vooral als transitohaven, en ook was er veel smokkelhandel (contrabanda) met het nabij gelegen vasteland.\n\nPas met de komst van de <a href=\"https://canoncuracao.cw/21-de-komst-van-de-olie-industrie/\">raffinaderij</a> in het begin van de twintigste eeuw werd het Schottegat de belangrijkste haven vanwege de aanvoer van ruwe olie naar de raffinaderij die aan het Schottegat gelegen was. De geraffineerde olieproducten werden deels ook weer via het Schottegat/Sint Annabaai afgevoerd, maar de gevaarlijke lichte producten werden wegens ontploffingsgevaar per pijpleiding naar de Bullenbaai vervoerd, dat een diepe haven heeft en waar er nauwelijks sprake is van bewoning. De Caracasbaai diende onder andere voor de opslag en afvoer van zware producten en de brandstofinname van schepen (bunkeren).\n\nTijdens de <a href=\"https://canoncuracao.cw/25-tweede-wereldoorlog/\">Tweede wereldoorlog</a> waren de raffinaderij en de havens van Curaçao zeer belangrijk voor de toevoer van o.a. vliegtuigbenzine naar de geallieerde strijdkrachten. In de jaren vijftig werd de nieuwe containerhaven aangelegd in het oostelijk deel van het Schottegat, waardoor de werven aan de Sint Annabaai vooral voor passagiersschepen konden worden gebruikt. In het Schottegat is scheepsreparatie ook een belangrijke havenactiviteit.\n\nDoor de sluiting van het Suezkanaal in 1967 werden de olietankers, die nu weer de lange route langs Zuid-Afrika moesten varen, binnen korte tijd veel en veel groter en begon Shell met het ontwikkelen van Bullenbaai als overslaghaven, waar zeer grote olietankers ruwe aardolie vanuit het Midden-Oosten kwamen brengen die vervolgens werd overgeladen in kleinere tankers, die de ruwe olie daarna naar o.a. de Verenigde Staten vervoerden. Momenteel is Bullenbaai vooral als opslagplaats voor olie zeer belangrijk.', '23. De haven', '', 'inherit', 'closed', 'closed', '', '51-autosave-v1', '', '', '2020-01-28 18:16:54', '2020-01-28 17:16:54', '', '51', 'https://canoncuracao.cw/51-autosave-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('616', '4', '2018-04-28 02:59:08', '2018-04-28 00:59:08', 'Voor een eiland zijn havens van cruciaal belang. Vroeger, voor de komst van de luchtvaart, was de zeevaart de enige mogelijkheid voor verkeer van mensen en goederen. Momenteel vindt veel vervoer van mensen plaats per vliegtuig, maar het vervoer van goederen gebeurt nog steeds veruit het meest per schip. Voor het laden en lossen van goederen zijn faciliteiten in rustig water met voldoende diepgang van essentieel belang.\r\n\r\nRustig water vinden we aan de zuidkust van Curaçao en vooral in de handvormige binnenbaaien en de toegang hiernaartoe. Vanaf het begin van de Nederlandse tijd werd dan ook met name de Sint Annabaai gebruikt als haven en in de twintigste eeuw vooral de handvormige binnenbaai daarachter, het Schottegat. De voornaamste havens zijn op dit moment  het Schottegat, de Sint Annabaai , de megapier (de cruiseport voor het Rif)  en Bullenbaai.  In het verleden waren ook de Caracasbaai en Fuikbaai van belang.\r\n\r\nDe goede potentiële havenmogelijkheden van de Sint Annabaai waren een belangrijke reden voor de Nederlanders om Curaçao op de Spanjaarden te veroveren. In de tijd van de West Indische Compagnie (1634-1791) diende de Sint Annabaai als uitvalsbasis voor de kaapvaart  en als strategische handelspost voor de slavenhandel en andere handel (o.a. smokkelhandel) en later als  vrijhandelshaven. In de Engelse tijd (1800-1803 en 1807-1816) werd door de Engelsen besloten dat Curaçao zijn vrijhavenstatus moest opgeven, waardoor de havenactiviteiten drastisch inkrompen.\r\n\r\nIn de negentiende eeuw fungeerde de haven vooral als transitohaven, en ook was er veel smokkelhandel (contrabanda) met het nabij gelegen vasteland.\r\n\r\nPas met de komst van de raffinaderij in het begin van de twintigste eeuw werd het Schottegat de belangrijkste haven vanwege de aanvoer van ruwe olie naar de raffinaderij die aan het Schottegat gelegen was. De geraffineerde olieproducten werden deels ook weer via het Schottegat/Annabaai afgevoerd, maar de gevaarlijke lichte producten werden wegens ontploffingsgevaar per pijpleiding naar de Bullenbaai vervoerd, dat een diepe haven heeft en waar er nauwelijks  sprake is van bewoning. De Caracasbaai diende onder andere voor de opslag en afvoer van zware produkten en de brandstofinname van schepen (bunkeren).\r\n\r\nTijdens de Tweede wereldoorlog waren de raffinaderij en de havens van Curaçao zeer belangrijk voor de toevoer van o.a. vliegtuigbenzine naar de Geallieerde strijdkrachten. In de jaren vijftig werd de nieuwe containerhaven aangelegd in het oostelijk deel van het Schottegat, waardoor de werven aan de Annabaai vooral voor passagiersschepen kon worden gebruikt.\r\n\r\nDoor de sluiting van het Suezkanaal in 1967 werden de olietankers, die nu weer de lange route langs Zuid Afrika moesten varen, binnen korte tijd veel en veel groter en begon Shell met het ontwikkelen van Bullenbaai als oilterminal, waar zeer grote olietankers ruwe aardolie vanuit het Midden Oosten kwamen brengen die vervolgens werd overgeladen in kleinere tankers, die de de ruwe olie daarna naar o.a. de Verenigde staten vervoerden. Momenteel is Bullenbaai vooral als opslagplaats voor olie zeer belangrijk.', '23. De haven', '', 'inherit', 'closed', 'closed', '', '51-revision-v1', '', '', '2018-04-28 02:59:08', '2018-04-28 00:59:08', '', '51', 'https://canoncuracao.cw/51-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('617', '4', '2018-04-28 03:01:26', '2018-04-28 01:01:26', 'Voor een eiland zijn havens van cruciaal belang. Vroeger, voor de komst van de luchtvaart, was de zeevaart de enige mogelijkheid voor verkeer van mensen en goederen. Momenteel vindt veel vervoer van mensen plaats per vliegtuig, maar het vervoer van goederen gebeurt nog steeds veruit het meest per schip. Voor het laden en lossen van goederen zijn faciliteiten in rustig water met voldoende diepgang van essentieel belang.\r\n\r\nRustig water vinden we aan de zuidkust van Curaçao en vooral in de handvormige binnenbaaien en de toegang hiernaartoe. Vanaf het begin van de Nederlandse tijd werd dan ook met name de Sint Annabaai gebruikt als haven en in de twintigste eeuw vooral de handvormige binnenbaai daarachter, het Schottegat. De voornaamste havens zijn op dit moment  het Schottegat, de Sint Annabaai , de megapier (de cruiseport voor het Rif)  en Bullenbaai.  In het verleden waren ook de Caracasbaai en Fuikbaai van belang.\r\n\r\nDe goede potentiële havenmogelijkheden van de Sint Annabaai waren een belangrijke reden voor de Nederlanders om Curaçao op de Spanjaarden te veroveren. In de tijd van de West Indische Compagnie (1634-1791) diende de Sint Annabaai als uitvalsbasis voor de kaapvaart  en als strategische handelspost voor de slavenhandel en andere handel (o.a. smokkelhandel) en later als  vrijhandelshaven. In de Engelse tijd (1800-1803 en 1807-1816) werd door de Engelsen besloten dat Curaçao zijn vrijhavenstatus moest opgeven, waardoor de havenactiviteiten drastisch inkrompen.\r\n\r\nIn de negentiende eeuw fungeerde de haven vooral als transitohaven, en ook was er veel smokkelhandel (contrabanda) met het nabij gelegen vasteland.\r\n\r\nPas met de komst van de raffinaderij in het begin van de twintigste eeuw werd het Schottegat de belangrijkste haven vanwege de aanvoer van ruwe olie naar de raffinaderij die aan het Schottegat gelegen was. De geraffineerde olieproducten werden deels ook weer via het Schottegat/Annabaai afgevoerd, maar de gevaarlijke lichte producten werden wegens ontploffingsgevaar per pijpleiding naar de Bullenbaai vervoerd, dat een diepe haven heeft en waar er nauwelijks  sprake is van bewoning. De Caracasbaai diende onder andere voor de opslag en afvoer van zware produkten en de brandstofinname van schepen (bunkeren).\r\n\r\nTijdens de Tweede wereldoorlog waren de raffinaderij en de havens van Curaçao zeer belangrijk voor de toevoer van o.a. vliegtuigbenzine naar de Geallieerde strijdkrachten. In de jaren vijftig werd de nieuwe containerhaven aangelegd in het oostelijk deel van het Schottegat, waardoor de werven aan de Annabaai vooral voor passagiersschepen konden worden gebruikt.\r\n\r\nDoor de sluiting van het Suezkanaal in 1967 werden de olietankers, die nu weer de lange route langs Zuid Afrika moesten varen, binnen korte tijd veel en veel groter en begon Shell met het ontwikkelen van Bullenbaai als oilterminal, waar zeer grote olietankers ruwe aardolie vanuit het Midden Oosten kwamen brengen die vervolgens werd overgeladen in kleinere tankers, die de de ruwe olie daarna naar o.a. de Verenigde staten vervoerden. Momenteel is Bullenbaai vooral als opslagplaats voor olie zeer belangrijk.', '23. De haven', '', 'inherit', 'closed', 'closed', '', '51-revision-v1', '', '', '2018-04-28 03:01:26', '2018-04-28 01:01:26', '', '51', 'https://canoncuracao.cw/51-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('619', '4', '2018-04-28 03:03:53', '2018-04-28 01:03:53', 'Op 10 mei 1940, onmiddellijk na de Duitse inval in Nederland, werden zeven Duitse schepen in de buurt van Curaçao in be¬slag genomen. De staat van beleg werd afgekondigd en diverse maatregelen werden genomen. Duitsers en Oostenrijkers, onder wie ook joden die hier woonden of hier¬heen gevlucht waren, werden in interneringskampen op Bonaire ondergebracht. Ook werden personen die verdacht werden van communistische of nationaal-socialistische sympathieën opgepakt.\r\n\r\nVanwege het strategische belang van de raffinaderij voor de Geallieerde oorlogs¬voering werden op verzoek van de naar Londen gevluchte Nederlandse regering vanaf december 1940 Britse troepen op het eiland gestationeerd. Tot begin 1942 ondervond Curaçao weinig last van de oorlog. Dit veranderde spoedig. Na de Japanse aanval op Pearl Harbour, op 7 december 1941, waren ook de Verenigde Staten in de oorlog betrokken. In februari 1942 werden de Britse troepen vervangen door Amerikaanse. De aanwezigheid van de Amerikaanse militairen bracht grote bedrijvigheid met zich mee, ondermeer door de ver¬betering van de infrastructuur van het eiland.\r\nHet Caribisch gebied werd toen ook het doelwit van aanvallen door Duitse duikboten.De duikbotenoorlog in het Caribisch gebied werd “Operation Paukenschlag”genoemd. De Duitse duikboten probeerden de olietransporten van het Lago de Maracaibo naar Curaçao en de levering van olieproducten van Curaçao aan de Geallieerden te ondermijnen.Op 16 februari 1942 werd de eerste van de vele aanvallen uitgevoerd. Veel schepen en mensenlevens zijn door duikbootaanvallen verloren gegaan. Aan het Waaigat staat een monument ter herinnering aan de vele slachtoffers.\r\n\r\nHet koloniale bestuur kwam in grote problemen bij de ‘Chinezenkwestie’ in april1942.\r\nNa de eerste aanvallen van de Duitse duikboten weigerden ongeveer 400 Chinese matrozen te gaan varen. Ze eisten meer veiligheid op de tankers en verhoging van hun loon met een oorlogstoeslag, zoals die ook werd toegekend aan andere zeevarenden. Toen er geen oplossing werd gevonden,werden de Chinese stakers in maart 1942 opgesloten in een kamp. Daar ontstond op 20 april een opstand waarbij vijftien Chinezen werden doodgeschoten en vierenveertig gewond raakten. Niemand werd aansprakelijk gesteld voor dit dodelijk geweld.\r\nTijdens de oorlog werden vele hulpacties georganiseerd door verschillende hulporganisaties die opgericht werden met het doel om de oorlogsslachtoffers in Nederland te ondersteunen met geld, hulpgoederen en kleding. Enkele van deze organisaties waren het Comité ‘Steun Aan de Nederlandse Oorlogsslachtoffers Curaçao’ (SANOC), onder leidingvan de arts Chris Engels, het ‘Comité Nederland’ van de werknemers van de C.P.I.M. (raffinaderij) en het Steunfonds Katholiek Nederland.\r\n\r\nHet streven naar autonomie werd tijdens de oorlog versterkt met name door een rede die Koningin Wilhelmina hield op 7 december 1942, waarin ze naar autonomie verwees.', '25. De Tweede Wereldoorlog', '', 'inherit', 'closed', 'closed', '', '55-revision-v1', '', '', '2018-04-28 03:03:53', '2018-04-28 01:03:53', '', '55', 'https://canoncuracao.cw/55-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('620', '4', '2018-04-28 03:07:08', '2018-04-28 01:07:08', 'Op 10 mei 1940, onmiddellijk na de Duitse inval in Nederland, werden zeven Duitse schepen in de buurt van Curaçao in beslag genomen. De staat van beleg werd afgekondigd en diverse maatregelen werden genomen. Duitsers en Oostenrijkers, onder wie ook joden die hier woonden of hierheen gevlucht waren, werden in interneringskampen op Bonaire ondergebracht. Ook werden personen die verdacht werden van communistische of nationaal-socialistische sympathieën opgepakt.\r\n\r\nVanwege het strategische belang van de raffinaderij voor de Geallieerde oorlogsvoering werden op verzoek van de naar Londen gevluchte Nederlandse regering vanaf december 1940 Britse troepen op het eiland gestationeerd. Tot begin 1942 ondervond Curaçao weinig last van de oorlog. Dit veranderde spoedig. Na de Japanse aanval op Pearl Harbour, op 7 december 1941, waren ook de Verenigde Staten in de oorlog betrokken. In februari 1942 werden de Britse troepen vervangen door Amerikaanse. De aanwezigheid van de Amerikaanse militairen bracht grote bedrijvigheid met zich mee, ondermeer door de verbetering van de infrastructuur van het eiland.\r\n\r\nHet Caribisch gebied werd toen ook het doelwit van aanvallen door Duitse duikboten. De duikbotenoorlog in het Caribisch gebied werd “Operation Paukenschlag”genoemd. De Duitse duikboten probeerden de olietransporten van het Lago de Maracaibo naar Curaçao en de levering van olieproducten van Curaçao aan de Geallieerden te ondermijnen. Op 16 februari 1942 werd de eerste van de vele aanvallen uitgevoerd. Veel schepen en mensenlevens zijn door duikbootaanvallen verloren gegaan. Aan het Waaigat staat een monument ter herinnering aan de vele slachtoffers.\r\n\r\nHet koloniale bestuur kwam in grote problemen bij de ‘Chinezenkwestie’ in april1942.\r\nNa de eerste aanvallen van de Duitse duikboten weigerden ongeveer 400 Chinese matrozen te gaan varen. Ze eisten meer veiligheid op de tankers en verhoging van hun loon met een oorlogstoeslag, zoals die ook werd toegekend aan andere zeevarenden. Toen er geen oplossing werd gevonden, werden de Chinese stakers in maart 1942 opgesloten in een kamp. Daar ontstond op 20 april een opstand waarbij vijftien Chinezen werden doodgeschoten en vierenveertig gewond raakten. Niemand werd aansprakelijk gesteld voor dit dodelijk geweld.\r\n\r\nTijdens de oorlog werden vele hulpacties georganiseerd door verschillende hulporganisaties die opgericht werden met het doel om de oorlogsslachtoffers in Nederland te ondersteunen met geld, hulpgoederen en kleding. Enkele van deze organisaties waren het Comité ‘Steun Aan de Nederlandse Oorlogsslachtoffers Curaçao’ (SANOC), onder leidingvan de arts Chris Engels, het ‘Comité Nederland’ van de werknemers van de C.P.I.M. (raffinaderij) en het Steunfonds Katholiek Nederland.\r\n\r\nHet streven naar autonomie werd tijdens de oorlog versterkt met name door een rede die Koningin Wilhelmina hield op 7 december 1942, waarin ze naar autonomie verwees.', '25. De Tweede Wereldoorlog', '', 'inherit', 'closed', 'closed', '', '55-revision-v1', '', '', '2018-04-28 03:07:08', '2018-04-28 01:07:08', '', '55', 'https://canoncuracao.cw/55-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('624', '4', '2018-04-28 03:18:14', '2018-04-28 01:18:14', 'Op 10 mei 1940, onmiddellijk na de Duitse inval in Nederland, werden zeven Duitse schepen in de buurt van Curaçao in beslag genomen. De staat van beleg werd afgekondigd en diverse maatregelen werden genomen. Duitsers en Oostenrijkers, onder wie ook joden die hier woonden of hierheen gevlucht waren, werden in interneringskampen op Bonaire ondergebracht. Ook werden personen die verdacht werden van communistische of nationaal-socialistische sympathieën opgepakt.\r\n\r\nVanwege het strategische belang van de raffinaderij voor de Geallieerde oorlogsvoering werden op verzoek van de naar Londen gevluchte Nederlandse regering vanaf december 1940 Britse troepen op het eiland gestationeerd. Tot begin 1942 ondervond Curaçao weinig last van de oorlog. Dit veranderde spoedig. Na de Japanse aanval op Pearl Harbour, op 7 december 1941, waren ook de Verenigde Staten in de oorlog betrokken. In februari 1942 werden de Britse troepen vervangen door Amerikaanse. De aanwezigheid van de Amerikaanse militairen bracht grote bedrijvigheid met zich mee, ondermeer door de verbetering van de infrastructuur van het eiland.\r\n\r\nHet Caribisch gebied werd toen ook het doelwit van aanvallen door Duitse duikboten. De duikbotenoorlog in het Caribisch gebied werd “Operation Paukenschlag”genoemd. De Duitse duikboten probeerden de olietransporten van het Lago de Maracaibo naar Curaçao en de levering van olieproducten van Curaçao aan de Geallieerden te ondermijnen. Op 16 februari 1942 werd de eerste van de vele aanvallen uitgevoerd. Veel schepen en mensenlevens zijn door duikbootaanvallen verloren gegaan. Aan het Waaigat staat een monument ter herinnering aan de vele slachtoffers.\r\n\r\nHet koloniale bestuur kwam in grote problemen bij de ‘Chinezenkwestie’ in april1942.\r\nNa de eerste aanvallen van de Duitse duikboten weigerden ongeveer 400 Chinese matrozen te gaan varen. Ze eisten meer veiligheid op de tankers en verhoging van hun loon met een oorlogstoeslag, zoals die ook werd toegekend aan andere zeevarenden. Toen er geen oplossing werd gevonden, werden de Chinese stakers in maart 1942 opgesloten in een kamp. Daar ontstond op 20 april een opstand waarbij vijftien Chinezen werden doodgeschoten en vierenveertig gewond raakten. Niemand werd aansprakelijk gesteld voor dit dodelijk geweld.\r\n\r\nTijdens de oorlog werden vele hulpacties georganiseerd door verschillende hulporganisaties die opgericht werden met het doel om de oorlogsslachtoffers in Nederland te ondersteunen met geld, hulpgoederen en kleding. Enkele van deze organisaties waren het Comité ‘Steun Aan de Nederlandse Oorlogsslachtoffers Curaçao’ (SANOC), onder leidingvan de arts Chris Engels, het ‘Comité Nederland’ van de werknemers van de C.P.I.M. (raffinaderij) en het Steunfonds Katholiek Nederland.\r\n\r\nHet streven naar autonomie werd tijdens de oorlog versterkt met name door een rede die Koningin Wilhelmina hield op 7 december 1942, waarin ze naar autonomie verwees.', '25. De Tweede Wereldoorlog', '', 'inherit', 'closed', 'closed', '', '55-revision-v1', '', '', '2018-04-28 03:18:14', '2018-04-28 01:18:14', '', '55', 'https://canoncuracao.cw/55-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('625', '4', '2018-04-28 03:19:05', '2018-04-28 01:19:05', 'Op 10 mei 1940, onmiddellijk na de Duitse inval in Nederland, werden zeven Duitse schepen in de buurt van Curaçao in beslag genomen. De staat van beleg werd afgekondigd en diverse maatregelen werden genomen. Duitsers en Oostenrijkers, onder wie ook joden die hier woonden of hierheen gevlucht waren, werden in interneringskampen op Bonaire ondergebracht. Ook werden personen die verdacht werden van communistische of nationaal-socialistische sympathieën opgepakt.\r\n\r\nVanwege het strategische belang van de raffinaderij voor de Geallieerde oorlogsvoering werden op verzoek van de naar Londen gevluchte Nederlandse regering vanaf december 1940 Britse troepen op het eiland gestationeerd. Tot begin 1942 ondervond Curaçao weinig last van de oorlog. Dit veranderde spoedig. Na de Japanse aanval op Pearl Harbour, op 7 december 1941, waren ook de Verenigde Staten in de oorlog betrokken. In februari 1942 werden de Britse troepen vervangen door Amerikaanse. De aanwezigheid van de Amerikaanse militairen bracht grote bedrijvigheid met zich mee, ondermeer door de verbetering van de infrastructuur van het eiland.\r\n\r\nHet Caribisch gebied werd toen ook het doelwit van aanvallen door Duitse duikboten. De duikbotenoorlog in het Caribisch gebied werd “Operation Paukenschlag”genoemd. De Duitse duikboten probeerden de olietransporten van het Lago de Maracaibo naar Curaçao en de levering van olieproducten van Curaçao aan de Geallieerden te ondermijnen. Op 16 februari 1942 werd de eerste van de vele aanvallen uitgevoerd. Veel schepen en mensenlevens zijn door duikbootaanvallen verloren gegaan. Aan het Waaigat staat een monument ter herinnering aan de vele slachtoffers.\r\n\r\nHet koloniale bestuur kwam in grote problemen bij de ‘Chinezenkwestie’ in april1942.\r\nNa de eerste aanvallen van de Duitse duikboten weigerden ongeveer 400 Chinese matrozen te gaan varen. Ze eisten meer veiligheid op de tankers en verhoging van hun loon met een oorlogstoeslag, zoals die ook werd toegekend aan andere zeevarenden. Toen er geen oplossing werd gevonden, werden de Chinese stakers in maart 1942 opgesloten in een kamp. Daar ontstond op 20 april een opstand waarbij vijftien Chinezen werden doodgeschoten en vierenveertig gewond raakten. Niemand werd aansprakelijk gesteld voor dit dodelijk geweld.\r\n\r\nTijdens de oorlog werden vele hulpacties georganiseerd door verschillende hulporganisaties die opgericht werden met het doel om de oorlogsslachtoffers in Nederland te ondersteunen met geld, hulpgoederen en kleding. Enkele van deze organisaties waren het Comité ‘Steun Aan de Nederlandse Oorlogsslachtoffers Curaçao’ (SANOC), onder leidingvan de arts Chris Engels, het ‘Comité Nederland’ van de werknemers van de C.P.I.M. (raffinaderij) en het Steunfonds Katholiek Nederland.\r\n\r\nHet streven naar autonomie werd tijdens de oorlog versterkt met name door een rede die Koningin Wilhelmina hield op 7 december 1942, waarin ze naar autonomie verwees.', '25. De Tweede Wereldoorlog', '', 'inherit', 'closed', 'closed', '', '55-revision-v1', '', '', '2018-04-28 03:19:05', '2018-04-28 01:19:05', '', '55', 'https://canoncuracao.cw/55-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('626', '4', '2018-04-28 03:29:17', '2018-04-28 01:29:17', '', 'Foto 003', '', 'inherit', 'open', 'closed', '', 'foto-003', '', '', '2018-04-28 03:40:17', '2018-04-28 01:40:17', '', '55', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Foto-003.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('629', '4', '2018-04-28 03:40:36', '2018-04-28 01:40:36', 'Op 10 mei 1940, onmiddellijk na de Duitse inval in Nederland, werden zeven Duitse schepen in de buurt van Curaçao in beslag genomen. De staat van beleg werd afgekondigd en diverse maatregelen werden genomen. Duitsers en Oostenrijkers, onder wie ook joden die hier woonden of hierheen gevlucht waren, werden in interneringskampen op Bonaire ondergebracht. Ook werden personen die verdacht werden van communistische of nationaal-socialistische sympathieën opgepakt.\r\n\r\nVanwege het strategische belang van de raffinaderij voor de Geallieerde oorlogsvoering werden op verzoek van de naar Londen gevluchte Nederlandse regering vanaf december 1940 Britse troepen op het eiland gestationeerd. Tot begin 1942 ondervond Curaçao weinig last van de oorlog. Dit veranderde spoedig. Na de Japanse aanval op Pearl Harbour, op 7 december 1941, waren ook de Verenigde Staten in de oorlog betrokken. In februari 1942 werden de Britse troepen vervangen door Amerikaanse. De aanwezigheid van de Amerikaanse militairen bracht grote bedrijvigheid met zich mee, ondermeer door de verbetering van de infrastructuur van het eiland.\r\n\r\nHet Caribisch gebied werd toen ook het doelwit van aanvallen door Duitse duikboten. De duikbotenoorlog in het Caribisch gebied werd “Operation Paukenschlag”genoemd. De Duitse duikboten probeerden de olietransporten van het Lago de Maracaibo naar Curaçao en de levering van olieproducten van Curaçao aan de Geallieerden te ondermijnen. Op 16 februari 1942 werd de eerste van de vele aanvallen uitgevoerd. Veel schepen en mensenlevens zijn door duikbootaanvallen verloren gegaan. Aan het Waaigat staat een monument ter herinnering aan de vele slachtoffers.\r\n\r\nHet koloniale bestuur kwam in grote problemen bij de ‘Chinezenkwestie’ in april1942.\r\nNa de eerste aanvallen van de Duitse duikboten weigerden ongeveer 400 Chinese matrozen te gaan varen. Ze eisten meer veiligheid op de tankers en verhoging van hun loon met een oorlogstoeslag, zoals die ook werd toegekend aan andere zeevarenden. Toen er geen oplossing werd gevonden, werden de Chinese stakers in maart 1942 opgesloten in een kamp. Daar ontstond op 20 april een opstand waarbij vijftien Chinezen werden doodgeschoten en vierenveertig gewond raakten. Niemand werd aansprakelijk gesteld voor dit dodelijk geweld.\r\n\r\nTijdens de oorlog werden vele hulpacties georganiseerd door verschillende hulporganisaties die opgericht werden met het doel om de oorlogsslachtoffers in Nederland te ondersteunen met geld, hulpgoederen en kleding. Enkele van deze organisaties waren het Comité ‘Steun Aan de Nederlandse Oorlogsslachtoffers Curaçao’ (SANOC), onder leidingvan de arts Chris Engels, het ‘Comité Nederland’ van de werknemers van de C.P.I.M. (raffinaderij) en het Steunfonds Katholiek Nederland.\r\n\r\nHet streven naar autonomie werd tijdens de oorlog versterkt met name door een rede die Koningin Wilhelmina hield op 7 december 1942, waarin ze naar autonomie verwees.', '25. De Tweede Wereldoorlog', '', 'inherit', 'closed', 'closed', '', '55-revision-v1', '', '', '2018-04-28 03:40:36', '2018-04-28 01:40:36', '', '55', 'https://canoncuracao.cw/55-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('630', '4', '2018-04-28 03:42:15', '2018-04-28 01:42:15', 'Op 10 mei 1940, onmiddellijk na de Duitse inval in Nederland, werden zeven Duitse schepen in de buurt van Curaçao in beslag genomen. De staat van beleg werd afgekondigd en diverse maatregelen werden genomen. Duitsers en Oostenrijkers, onder wie ook joden die hier woonden of hierheen gevlucht waren, werden in interneringskampen op Bonaire ondergebracht. Ook werden personen die verdacht werden van communistische of nationaal-socialistische sympathieën opgepakt.\r\n\r\nVanwege het strategische belang van de raffinaderij voor de Geallieerde oorlogsvoering werden op verzoek van de naar Londen gevluchte Nederlandse regering vanaf december 1940 Britse troepen op het eiland gestationeerd. Tot begin 1942 ondervond Curaçao weinig last van de oorlog. Dit veranderde spoedig. Na de Japanse aanval op Pearl Harbour, op 7 december 1941, waren ook de Verenigde Staten in de oorlog betrokken. In februari 1942 werden de Britse troepen vervangen door Amerikaanse. De aanwezigheid van de Amerikaanse militairen bracht grote bedrijvigheid met zich mee, ondermeer door de verbetering van de infrastructuur van het eiland.\r\n\r\nHet Caribisch gebied werd toen ook het doelwit van aanvallen door Duitse duikboten. De duikbotenoorlog in het Caribisch gebied werd “Operation Paukenschlag”genoemd. De Duitse duikboten probeerden de olietransporten van het Lago de Maracaibo naar Curaçao en de levering van olieproducten van Curaçao aan de Geallieerden te ondermijnen. Op 16 februari 1942 werd de eerste van de vele aanvallen uitgevoerd. Veel schepen en mensenlevens zijn door duikbootaanvallen verloren gegaan. Aan het Waaigat staat een monument ter herinnering aan de vele slachtoffers.\r\n\r\nHet koloniale bestuur kwam in grote problemen bij de ‘Chinezenkwestie’ in april1942.\r\nNa de eerste aanvallen van de Duitse duikboten weigerden ongeveer 400 Chinese matrozen te gaan varen. Ze eisten meer veiligheid op de tankers en verhoging van hun loon met een oorlogstoeslag, zoals die ook werd toegekend aan andere zeevarenden. Toen er geen oplossing werd gevonden, werden de Chinese stakers in maart 1942 opgesloten in een kamp. Daar ontstond op 20 april een opstand waarbij vijftien Chinezen werden doodgeschoten en vierenveertig gewond raakten. Niemand werd aansprakelijk gesteld voor dit dodelijk geweld.\r\n\r\nTijdens de oorlog werden vele hulpacties georganiseerd door verschillende hulporganisaties die opgericht werden met het doel om de oorlogsslachtoffers in Nederland te ondersteunen met geld, hulpgoederen en kleding. Enkele van deze organisaties waren het Comité ‘Steun Aan de Nederlandse Oorlogsslachtoffers Curaçao’ (SANOC), onder leidingvan de arts Chris Engels, het ‘Comité Nederland’ van de werknemers van de C.P.I.M. (raffinaderij) en het Steunfonds Katholiek Nederland.\r\n\r\nHet streven naar autonomie werd tijdens de oorlog versterkt met name door een rede die Koningin Wilhelmina hield op 7 december 1942, waarin ze naar autonomie verwees.', '25. De Tweede Wereldoorlog', '', 'inherit', 'closed', 'closed', '', '55-revision-v1', '', '', '2018-04-28 03:42:15', '2018-04-28 01:42:15', '', '55', 'https://canoncuracao.cw/55-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('631', '4', '2018-04-28 03:47:25', '2018-04-28 01:47:25', '', 'env 119 001', '', 'inherit', 'open', 'closed', '', 'env-119-001', '', '', '2018-04-28 03:47:28', '2018-04-28 01:47:28', '', '55', 'https://canoncuracao.cw/wp-content/uploads/2017/05/env-119-001.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('633', '4', '2018-04-28 03:47:58', '2018-04-28 01:47:58', 'Op 10 mei 1940, onmiddellijk na de Duitse inval in Nederland, werden zeven Duitse schepen in de buurt van Curaçao in beslag genomen. De staat van beleg werd afgekondigd en diverse maatregelen werden genomen. Duitsers en Oostenrijkers, onder wie ook joden die hier woonden of hierheen gevlucht waren, werden in interneringskampen op Bonaire ondergebracht. Ook werden personen die verdacht werden van communistische of nationaal-socialistische sympathieën opgepakt.\r\n\r\nVanwege het strategische belang van de raffinaderij voor de Geallieerde oorlogsvoering werden op verzoek van de naar Londen gevluchte Nederlandse regering vanaf december 1940 Britse troepen op het eiland gestationeerd. Tot begin 1942 ondervond Curaçao weinig last van de oorlog. Dit veranderde spoedig. Na de Japanse aanval op Pearl Harbour, op 7 december 1941, waren ook de Verenigde Staten in de oorlog betrokken. In februari 1942 werden de Britse troepen vervangen door Amerikaanse. De aanwezigheid van de Amerikaanse militairen bracht grote bedrijvigheid met zich mee, ondermeer door de verbetering van de infrastructuur van het eiland.\r\n\r\nHet Caribisch gebied werd toen ook het doelwit van aanvallen door Duitse duikboten. De duikbotenoorlog in het Caribisch gebied werd “Operation Paukenschlag”genoemd. De Duitse duikboten probeerden de olietransporten van het Lago de Maracaibo naar Curaçao en de levering van olieproducten van Curaçao aan de Geallieerden te ondermijnen. Op 16 februari 1942 werd de eerste van de vele aanvallen uitgevoerd. Veel schepen en mensenlevens zijn door duikbootaanvallen verloren gegaan. Aan het Waaigat staat een monument ter herinnering aan de vele slachtoffers.\r\n\r\nHet koloniale bestuur kwam in grote problemen bij de ‘Chinezenkwestie’ in april1942.\r\nNa de eerste aanvallen van de Duitse duikboten weigerden ongeveer 400 Chinese matrozen te gaan varen. Ze eisten meer veiligheid op de tankers en verhoging van hun loon met een oorlogstoeslag, zoals die ook werd toegekend aan andere zeevarenden. Toen er geen oplossing werd gevonden, werden de Chinese stakers in maart 1942 opgesloten in een kamp. Daar ontstond op 20 april een opstand waarbij vijftien Chinezen werden doodgeschoten en vierenveertig gewond raakten. Niemand werd aansprakelijk gesteld voor dit dodelijk geweld.\r\n\r\nTijdens de oorlog werden vele hulpacties georganiseerd door verschillende hulporganisaties die opgericht werden met het doel om de oorlogsslachtoffers in Nederland te ondersteunen met geld, hulpgoederen en kleding. Enkele van deze organisaties waren het Comité ‘Steun Aan de Nederlandse Oorlogsslachtoffers Curaçao’ (SANOC), onder leidingvan de arts Chris Engels, het ‘Comité Nederland’ van de werknemers van de C.P.I.M. (raffinaderij) en het Steunfonds Katholiek Nederland.\r\n\r\nHet streven naar autonomie werd tijdens de oorlog versterkt met name door een rede die Koningin Wilhelmina hield op 7 december 1942, waarin ze naar autonomie verwees.', '25. De Tweede Wereldoorlog', '', 'inherit', 'closed', 'closed', '', '55-revision-v1', '', '', '2018-04-28 03:47:58', '2018-04-28 01:47:58', '', '55', 'https://canoncuracao.cw/55-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('634', '4', '2018-04-28 03:50:22', '2018-04-28 01:50:22', '', 'env 133 001', '', 'inherit', 'open', 'closed', '', 'env-133-001', '', '', '2018-04-28 03:50:24', '2018-04-28 01:50:24', '', '55', 'https://canoncuracao.cw/wp-content/uploads/2017/05/env-133-001.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('635', '4', '2018-04-28 03:50:28', '2018-04-28 01:50:28', 'Op 10 mei 1940, onmiddellijk na de Duitse inval in Nederland, werden zeven Duitse schepen in de buurt van Curaçao in beslag genomen. De staat van beleg werd afgekondigd en diverse maatregelen werden genomen. Duitsers en Oostenrijkers, onder wie ook joden die hier woonden of hierheen gevlucht waren, werden in interneringskampen op Bonaire ondergebracht. Ook werden personen die verdacht werden van communistische of nationaal-socialistische sympathieën opgepakt.\r\n\r\nVanwege het strategische belang van de raffinaderij voor de Geallieerde oorlogsvoering werden op verzoek van de naar Londen gevluchte Nederlandse regering vanaf december 1940 Britse troepen op het eiland gestationeerd. Tot begin 1942 ondervond Curaçao weinig last van de oorlog. Dit veranderde spoedig. Na de Japanse aanval op Pearl Harbour, op 7 december 1941, waren ook de Verenigde Staten in de oorlog betrokken. In februari 1942 werden de Britse troepen vervangen door Amerikaanse. De aanwezigheid van de Amerikaanse militairen bracht grote bedrijvigheid met zich mee, ondermeer door de verbetering van de infrastructuur van het eiland.\r\n\r\nHet Caribisch gebied werd toen ook het doelwit van aanvallen door Duitse duikboten. De duikbotenoorlog in het Caribisch gebied werd “Operation Paukenschlag”genoemd. De Duitse duikboten probeerden de olietransporten van het Lago de Maracaibo naar Curaçao en de levering van olieproducten van Curaçao aan de Geallieerden te ondermijnen. Op 16 februari 1942 werd de eerste van de vele aanvallen uitgevoerd. Veel schepen en mensenlevens zijn door duikbootaanvallen verloren gegaan. Aan het Waaigat staat een monument ter herinnering aan de vele slachtoffers.\r\n\r\nHet koloniale bestuur kwam in grote problemen bij de ‘Chinezenkwestie’ in april1942.\r\nNa de eerste aanvallen van de Duitse duikboten weigerden ongeveer 400 Chinese matrozen te gaan varen. Ze eisten meer veiligheid op de tankers en verhoging van hun loon met een oorlogstoeslag, zoals die ook werd toegekend aan andere zeevarenden. Toen er geen oplossing werd gevonden, werden de Chinese stakers in maart 1942 opgesloten in een kamp. Daar ontstond op 20 april een opstand waarbij vijftien Chinezen werden doodgeschoten en vierenveertig gewond raakten. Niemand werd aansprakelijk gesteld voor dit dodelijk geweld.\r\n\r\nTijdens de oorlog werden vele hulpacties georganiseerd door verschillende hulporganisaties die opgericht werden met het doel om de oorlogsslachtoffers in Nederland te ondersteunen met geld, hulpgoederen en kleding. Enkele van deze organisaties waren het Comité ‘Steun Aan de Nederlandse Oorlogsslachtoffers Curaçao’ (SANOC), onder leidingvan de arts Chris Engels, het ‘Comité Nederland’ van de werknemers van de C.P.I.M. (raffinaderij) en het Steunfonds Katholiek Nederland.\r\n\r\nHet streven naar autonomie werd tijdens de oorlog versterkt met name door een rede die Koningin Wilhelmina hield op 7 december 1942, waarin ze naar autonomie verwees.', '25. De Tweede Wereldoorlog', '', 'inherit', 'closed', 'closed', '', '55-revision-v1', '', '', '2018-04-28 03:50:28', '2018-04-28 01:50:28', '', '55', 'https://canoncuracao.cw/55-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('637', '4', '2018-04-28 03:55:27', '2018-04-28 01:55:27', 'Moises Frumencio da Costa Gomez is geboren in Otrobanda op 27 oktober 1907, als zoon van Pedro da Costa Gomez en Braulia Bikker. Het gezin woont eerst in Otrobanda en verhuist later naar de Penstraat in Pietermaai. Op zijn 15e gaat Moises na voltooiing van de MULO naar Nederland, waar hij vanaf 1923 in Nijmegen het gymnasium volgt. Van 1925 tot 1929 studeert Moises rechten aan de Universiteit van Nijmegen. De jonge jurist werkt daarna als substituut-griffier in Den Haag en als advocaat en procureur in Nijmegen. Tegelijkertijd werkt hij aan zijn dissertatie en promoveert hij aan de Universiteit van Amsterdam op 3 december 1935 op het proefschrift <em>‘Het wetgevend orgaan van Curaçao. Samenstelling en bevoegdheid bezien in het kader van de Nederlandse Koloniale politiek’</em>. Hij pleit als eerste Antilliaan in een proefschrift voor autonomie en algemeen kiesrecht voor de bevolking van de Nederlandse Antillen. Hij is dan 28 jaar oud en vertrekt onmiddellijk na zijn promotie met zijn gezin naar Curaçao, waar zij op 31 december 1935 aankomen.\r\n\r\nOp het eiland noemen ze hem al spoedig ’Doktoor’. Da Costa Gomez is een staatsman met grote verdiensten voor Curaçao, de Nederlandse Antillen en het Koninkrijk der Nederlanden. In 1935 formuleert hij de visie dat de bevolking van de Antillen bereid en in staat is zichzelf te besturen. Hij ziet autonomie als een instrument om economische, sociale en culturele vooruitgang te bereiken. Hij stelt zich in de jaren veertig als missie: zelfbestuur voor de Antillen, een bestuur dat verantwoording verschuldigd is aan een parlement dat via algemeen kiesrecht is verkozen, zelfbestuur door de eilanden voor eilandelijke zaken en samenwerking en bijstand tussen de delen van het koninkrijk. Zijn gedachtegoed paste goed in de tijdgeest: ook op de andere Caribische eilanden leefde de wens om zich los te koppelen van de kolonisator.\r\n\r\nTot zijn verdiensten rekenen wij: het inspirerend verwoorden van de wens voor autonomie, bevordering van het politieke bewustzijn in de Antillen, organisatie van acties voor sociale ondersteuning in Kas di Pueblo, oprichting van de N.V.P., de wil tot samenwerken op alle bestuursniveaus, bevordering van zelfwaardering van de arme kunuku-bewoners van Curaçao, promotor van een eigen universiteit, leider van alle delegaties voor het autonomiestreven. Doktoor was de schakel tussen de Staten en de Nederlandse regering in Londen (1943) en in Den Haag (1947-1948). Hij was voorzitter of lid van diverse commissies voor het opstellen van staatsregelingen voor de Antillen en heeft een grote bijdrage geleverd aan de ontwerpen voor de gedeeltelijke autonomie van 1948, de interim-regeling van 1951 en het statuut van 1954. Hij werd gezien als een zeer kundig spreker in de Staten. Hij stierf onverwacht op 22 november 1966.', '26. Dr. M. F. da Costa Gomez', '', 'inherit', 'closed', 'closed', '', '57-revision-v1', '', '', '2018-04-28 03:55:27', '2018-04-28 01:55:27', '', '57', 'https://canoncuracao.cw/57-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('638', '4', '2018-04-28 16:57:28', '2018-04-28 14:57:28', '', 'Doktoor jonge man', '', 'inherit', 'open', 'closed', '', 'doktoor-jonge-man', '', '', '2018-04-28 16:57:35', '2018-04-28 14:57:35', '', '57', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Doktoor-jonge-man.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('639', '4', '2018-04-28 17:00:44', '2018-04-28 15:00:44', '', 'Foto 218_1', '', 'inherit', 'open', 'closed', '', 'foto-218_1', '', '', '2018-04-28 17:00:47', '2018-04-28 15:00:47', '', '57', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Foto-218_1.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('640', '4', '2018-04-28 17:00:53', '2018-04-28 15:00:53', 'Moises Frumencio da Costa Gomez is geboren in Otrobanda op 27 oktober 1907, als zoon van Pedro da Costa Gomez en Braulia Bikker. Het gezin woont eerst in Otrobanda en verhuist later naar de Penstraat in Pietermaai. Op zijn 15e gaat Moises na voltooiing van de MULO naar Nederland, waar hij vanaf 1923 in Nijmegen het gymnasium volgt. Van 1925 tot 1929 studeert Moises rechten aan de Universiteit van Nijmegen. De jonge jurist werkt daarna als substituut-griffier in Den Haag en als advocaat en procureur in Nijmegen. Tegelijkertijd werkt hij aan zijn dissertatie en promoveert hij aan de Universiteit van Amsterdam op 3 december 1935 op het proefschrift <em>‘Het wetgevend orgaan van Curaçao. Samenstelling en bevoegdheid bezien in het kader van de Nederlandse Koloniale politiek’</em>. Hij pleit als eerste Antilliaan in een proefschrift voor autonomie en algemeen kiesrecht voor de bevolking van de Nederlandse Antillen. Hij is dan 28 jaar oud en vertrekt onmiddellijk na zijn promotie met zijn gezin naar Curaçao, waar zij op 31 december 1935 aankomen.\r\n\r\nOp het eiland noemen ze hem al spoedig ’Doktoor’. Da Costa Gomez is een staatsman met grote verdiensten voor Curaçao, de Nederlandse Antillen en het Koninkrijk der Nederlanden. In 1935 formuleert hij de visie dat de bevolking van de Antillen bereid en in staat is zichzelf te besturen. Hij ziet autonomie als een instrument om economische, sociale en culturele vooruitgang te bereiken. Hij stelt zich in de jaren veertig als missie: zelfbestuur voor de Antillen, een bestuur dat verantwoording verschuldigd is aan een parlement dat via algemeen kiesrecht is verkozen, zelfbestuur door de eilanden voor eilandelijke zaken en samenwerking en bijstand tussen de delen van het koninkrijk. Zijn gedachtegoed paste goed in de tijdgeest: ook op de andere Caribische eilanden leefde de wens om zich los te koppelen van de kolonisator.\r\n\r\nTot zijn verdiensten rekenen wij: het inspirerend verwoorden van de wens voor autonomie, bevordering van het politieke bewustzijn in de Antillen, organisatie van acties voor sociale ondersteuning in Kas di Pueblo, oprichting van de N.V.P., de wil tot samenwerken op alle bestuursniveaus, bevordering van zelfwaardering van de arme kunuku-bewoners van Curaçao, promotor van een eigen universiteit, leider van alle delegaties voor het autonomiestreven. Doktoor was de schakel tussen de Staten en de Nederlandse regering in Londen (1943) en in Den Haag (1947-1948). Hij was voorzitter of lid van diverse commissies voor het opstellen van staatsregelingen voor de Antillen en heeft een grote bijdrage geleverd aan de ontwerpen voor de gedeeltelijke autonomie van 1948, de interim-regeling van 1951 en het statuut van 1954. Hij werd gezien als een zeer kundig spreker in de Staten. Hij stierf onverwacht op 22 november 1966.', '26. Dr. M. F. da Costa Gomez', '', 'inherit', 'closed', 'closed', '', '57-revision-v1', '', '', '2018-04-28 17:00:53', '2018-04-28 15:00:53', '', '57', 'https://canoncuracao.cw/57-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('641', '4', '2018-04-28 17:03:49', '2018-04-28 15:03:49', 'Moises Frumencio da Costa Gomez is geboren in Otrobanda op 27 oktober 1907, als zoon van Pedro da Costa Gomez en Braulia Bikker. Het gezin woont eerst in Otrobanda en verhuist later naar de Penstraat in Pietermaai. Op zijn 15e gaat Moises na voltooiing van de MULO naar Nederland, waar hij vanaf 1923 in Nijmegen het gymnasium volgt. Van 1925 tot 1929 studeert Moises rechten aan de Universiteit van Nijmegen. De jonge jurist werkt daarna als substituut-griffier in Den Haag en als advocaat en procureur in Nijmegen. Tegelijkertijd werkt hij aan zijn dissertatie en promoveert hij aan de Universiteit van Amsterdam op 3 december 1935 op het proefschrift <em>‘Het wetgevend orgaan van Curaçao. Samenstelling en bevoegdheid bezien in het kader van de Nederlandse Koloniale politiek’</em>. Hij pleit als eerste Antilliaan in een proefschrift voor autonomie en algemeen kiesrecht voor de bevolking van de Nederlandse Antillen. Hij is dan 28 jaar oud en vertrekt onmiddellijk na zijn promotie met zijn gezin naar Curaçao, waar zij op 31 december 1935 aankomen.\r\n\r\nOp het eiland noemen ze hem al spoedig ’Doktoor’. Da Costa Gomez is een staatsman met grote verdiensten voor Curaçao, de Nederlandse Antillen en het Koninkrijk der Nederlanden. In 1935 formuleert hij de visie dat de bevolking van de Antillen bereid en in staat is zichzelf te besturen. Hij ziet autonomie als een instrument om economische, sociale en culturele vooruitgang te bereiken. Hij stelt zich in de jaren veertig als missie: zelfbestuur voor de Antillen, een bestuur dat verantwoording verschuldigd is aan een parlement dat via algemeen kiesrecht is verkozen, zelfbestuur door de eilanden voor eilandelijke zaken en samenwerking en bijstand tussen de delen van het koninkrijk. Zijn gedachtegoed paste goed in de tijdgeest: ook op de andere Caribische eilanden leefde de wens om zich los te koppelen van de kolonisator.\r\n\r\nTot zijn verdiensten rekenen wij: het inspirerend verwoorden van de wens voor autonomie, bevordering van het politieke bewustzijn in de Antillen, organisatie van acties voor sociale ondersteuning in Kas di Pueblo, oprichting van de N.V.P., de wil tot samenwerken op alle bestuursniveaus, bevordering van zelfwaardering van de arme kunuku-bewoners van Curaçao, promotor van een eigen universiteit, leider van alle delegaties voor het autonomiestreven. Doktoor was de schakel tussen de Staten en de Nederlandse regering in Londen (1943) en in Den Haag (1947-1948). Hij was voorzitter of lid van diverse commissies voor het opstellen van staatsregelingen voor de Antillen en heeft een grote bijdrage geleverd aan de ontwerpen voor de gedeeltelijke autonomie van 1948, de interim-regeling van 1951 en het statuut van 1954. Hij werd gezien als een zeer kundig spreker in de Staten. Hij stierf onverwacht op 22 november 1966.', '26. Dr. M. F. da Costa Gomez', '', 'inherit', 'closed', 'closed', '', '57-revision-v1', '', '', '2018-04-28 17:03:49', '2018-04-28 15:03:49', '', '57', 'https://canoncuracao.cw/57-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('642', '4', '2018-04-28 17:04:40', '2018-04-28 15:04:40', 'Moises Frumencio da Costa Gomez is geboren in Otrobanda op 27 oktober 1907, als zoon van Pedro da Costa Gomez en Braulia Bikker. Het gezin woont eerst in Otrobanda en verhuist later naar de Penstraat in Pietermaai. Op zijn 15e gaat Moises na voltooiing van de MULO naar Nederland, waar hij vanaf 1923 in Nijmegen het gymnasium volgt. Van 1925 tot 1929 studeert Moises rechten aan de Universiteit van Nijmegen. De jonge jurist werkt daarna als substituut-griffier in Den Haag en als advocaat en procureur in Nijmegen. Tegelijkertijd werkt hij aan zijn dissertatie en promoveert hij aan de Universiteit van Amsterdam op 3 december 1935 op het proefschrift <em>‘Het wetgevend orgaan van Curaçao. Samenstelling en bevoegdheid bezien in het kader van de Nederlandse Koloniale politiek’</em>. Hij pleit als eerste Antilliaan in een proefschrift voor autonomie en algemeen kiesrecht voor de bevolking van de Nederlandse Antillen. Hij is dan 28 jaar oud en vertrekt onmiddellijk na zijn promotie met zijn gezin naar Curaçao, waar zij op 31 december 1935 aankomen.\r\n\r\nOp het eiland noemen ze hem al spoedig ’Doktoor’. Da Costa Gomez is een staatsman met grote verdiensten voor Curaçao, de Nederlandse Antillen en het Koninkrijk der Nederlanden. In 1935 formuleert hij de visie dat de bevolking van de Antillen bereid en in staat is zichzelf te besturen. Hij ziet autonomie als een instrument om economische, sociale en culturele vooruitgang te bereiken. Hij stelt zich in de jaren veertig als missie: zelfbestuur voor de Antillen, een bestuur dat verantwoording verschuldigd is aan een parlement dat via algemeen kiesrecht is verkozen, zelfbestuur door de eilanden voor eilandelijke zaken en samenwerking en bijstand tussen de delen van het koninkrijk. Zijn gedachtegoed paste goed in de tijdgeest: ook op de andere Caribische eilanden leefde de wens om zich los te koppelen van de kolonisator.\r\n\r\nTot zijn verdiensten rekenen wij: het inspirerend verwoorden van de wens voor autonomie, bevordering van het politieke bewustzijn in de Antillen, organisatie van acties voor sociale ondersteuning in Kas di Pueblo, oprichting van de N.V.P., de wil tot samenwerken op alle bestuursniveaus, bevordering van zelfwaardering van de arme kunuku-bewoners van Curaçao, promotor van een eigen universiteit, leider van alle delegaties voor het autonomiestreven. Doktoor was de schakel tussen de Staten en de Nederlandse regering in Londen (1943) en in Den Haag (1947-1948). Hij was voorzitter of lid van diverse commissies voor het opstellen van staatsregelingen voor de Antillen en heeft een grote bijdrage geleverd aan de ontwerpen voor de gedeeltelijke autonomie van 1948, de interim-regeling van 1951 en het statuut van 1954. Hij werd gezien als een zeer kundig spreker in de Staten. Hij stierf onverwacht op 22 november 1966.', '26. Dr. M. F. da Costa Gomez', '', 'inherit', 'closed', 'closed', '', '57-revision-v1', '', '', '2018-04-28 17:04:40', '2018-04-28 15:04:40', '', '57', 'https://canoncuracao.cw/57-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('643', '4', '2018-04-28 17:10:44', '2018-04-28 15:10:44', 'Het Statuut van het Koninkrijk der Nederlanden is de grondwet van het Koninkrijk en regelt de relatie tussen Nederland en de Caribische eilanden. Het Statuut werd ondertekend op 15 december 1954 in de Ridderzaal te Den Haag door Suriname en het land de Nederlandse Antillen, dat bestond uit de zes eilanden, Aruba, Bonaire, Curaçao, Sint Maarten, Sint Eustatius en Saba.\r\n\r\nIn 1975 werd Suriname een zelfstandig land. Aruba trad in 1986 uit de constellatie van de Nederlandse Antillen en kreeg een aparte status binnen het Koninkrijk. In 2010 werd het land ‘de Nederlandse Antillen’ opgeheven en werden Curaçao en Sint Maarten, net als Aruba, aparte landen binnen het Koninkrijk. Bonaire, Sint Eustatius en Saba kregen gezamenlijk de status van Nederlands gebiedsdeel in de Cariben en vallen nu bestuurlijk direct onder Nederland.\r\n\r\nDe volgende drie grondbeginselen zijn opgenomen in het Statuut:\r\n1.De landen binnen het koninkrijk behartigen zelfstandig hun eigen belangen.\r\n2.Zij verzorgen op voet van gelijkwaardigheid de gemeenschappelijke belangen.\r\n3.Zij verlenen elkaar wederkerig bijstand.\r\n\r\nDe gemeenschappelijke belangen die de landen binnen het Koninkrijk gezamenlijk op voet van gelijkwaardigheid behartigen staan bekend als de ‘koninkrijksaangelegenheden’. Hiertoe behoren zaken betrekking hebbende op de handhaving van de onafhankelijkheid en verdediging van het Koninkrijk, buitenlandse betrekkingen, Nederlanderschap, waarborgen van de fundamentele rechten en vrijheden, de rechtszekerheid en de deugdelijkheid van het bestuur.\r\n\r\nDe vier voornaamste bestuursorganen van de landen Aruba, Curaçao en St. Maarten zijn:\r\n1. De Gouverneur, vertegenwoordiger van het hoofd van de regering van het koninkrijk en van de regering van het land.\r\n2. De Staten, het parlement, bestaande uit hooguit 21 leden. Om de vier jaar worden verkiezingen gehouden om de Staten te kiezen. Zij hebben als taak wetten goed te keuren of te verwerpen en de regering te controleren.\r\n3. De Raad van Ministers, het kabinet, steunt op de meerderheid in de Staten. Samen met de Gouverneur vormen de ministers de Regering. De ministers zijn verantwoording verschuldigd aan de Staten. De gouverneur is onschendbaar.\r\n4. De Raad van Advies adviseert bij het maken van wetten.\r\n\r\nTer behartiging van de belangen van elk der landen maken drie ‘gevolmachtigde ministers’ van respectievelijk Curaçao, Aruba en Sint Maarten deel uit van de Rijksministerraad van het Koninkrijk in Nederland. Ook in de Raad van State, het adviescollege van de regering in Nederland, is een vertegenwoordiger aanwezig van elk der landen.', '28. Het statuut', '', 'inherit', 'closed', 'closed', '', '61-revision-v1', '', '', '2018-04-28 17:10:44', '2018-04-28 15:10:44', '', '61', 'https://canoncuracao.cw/61-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('644', '4', '2018-04-28 17:13:29', '2018-04-28 15:13:29', '', 'Foto 249', '', 'inherit', 'open', 'closed', '', 'foto-249', '', '', '2018-04-28 17:13:32', '2018-04-28 15:13:32', '', '61', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Foto-249.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('645', '4', '2018-04-28 17:13:49', '2018-04-28 15:13:49', '', 'H 5 27 jonckheer met statuut', '', 'inherit', 'open', 'closed', '', 'h-5-27-jonckheer-met-statuut', '', '', '2018-04-28 17:13:52', '2018-04-28 15:13:52', '', '61', 'https://canoncuracao.cw/wp-content/uploads/2017/05/H-5-27-jonckheer-met-statuut.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('646', '4', '2018-04-28 17:13:56', '2018-04-28 15:13:56', 'Het Statuut van het Koninkrijk der Nederlanden is de grondwet van het Koninkrijk en regelt de relatie tussen Nederland en de Caribische eilanden. Het Statuut werd ondertekend op 15 december 1954 in de Ridderzaal te Den Haag door Suriname en het land de Nederlandse Antillen, dat bestond uit de zes eilanden, Aruba, Bonaire, Curaçao, Sint Maarten, Sint Eustatius en Saba.\r\n\r\nIn 1975 werd Suriname een zelfstandig land. Aruba trad in 1986 uit de constellatie van de Nederlandse Antillen en kreeg een aparte status binnen het Koninkrijk. In 2010 werd het land ‘de Nederlandse Antillen’ opgeheven en werden Curaçao en Sint Maarten, net als Aruba, aparte landen binnen het Koninkrijk. Bonaire, Sint Eustatius en Saba kregen gezamenlijk de status van Nederlands gebiedsdeel in de Cariben en vallen nu bestuurlijk direct onder Nederland.\r\n\r\nDe volgende drie grondbeginselen zijn opgenomen in het Statuut:\r\n1.De landen binnen het koninkrijk behartigen zelfstandig hun eigen belangen.\r\n2.Zij verzorgen op voet van gelijkwaardigheid de gemeenschappelijke belangen.\r\n3.Zij verlenen elkaar wederkerig bijstand.\r\n\r\nDe gemeenschappelijke belangen die de landen binnen het Koninkrijk gezamenlijk op voet van gelijkwaardigheid behartigen staan bekend als de ‘koninkrijksaangelegenheden’. Hiertoe behoren zaken betrekking hebbende op de handhaving van de onafhankelijkheid en verdediging van het Koninkrijk, buitenlandse betrekkingen, Nederlanderschap, waarborgen van de fundamentele rechten en vrijheden, de rechtszekerheid en de deugdelijkheid van het bestuur.\r\n\r\nDe vier voornaamste bestuursorganen van de landen Aruba, Curaçao en St. Maarten zijn:\r\n1. De Gouverneur, vertegenwoordiger van het hoofd van de regering van het koninkrijk en van de regering van het land.\r\n2. De Staten, het parlement, bestaande uit hooguit 21 leden. Om de vier jaar worden verkiezingen gehouden om de Staten te kiezen. Zij hebben als taak wetten goed te keuren of te verwerpen en de regering te controleren.\r\n3. De Raad van Ministers, het kabinet, steunt op de meerderheid in de Staten. Samen met de Gouverneur vormen de ministers de Regering. De ministers zijn verantwoording verschuldigd aan de Staten. De gouverneur is onschendbaar.\r\n4. De Raad van Advies adviseert bij het maken van wetten.\r\n\r\nTer behartiging van de belangen van elk der landen maken drie ‘gevolmachtigde ministers’ van respectievelijk Curaçao, Aruba en Sint Maarten deel uit van de Rijksministerraad van het Koninkrijk in Nederland. Ook in de Raad van State, het adviescollege van de regering in Nederland, is een vertegenwoordiger aanwezig van elk der landen.', '28. Het statuut', '', 'inherit', 'closed', 'closed', '', '61-revision-v1', '', '', '2018-04-28 17:13:56', '2018-04-28 15:13:56', '', '61', 'https://canoncuracao.cw/61-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('647', '4', '2018-04-28 17:18:53', '2018-04-28 15:18:53', 'Het Statuut van het Koninkrijk der Nederlanden is de grondwet van het Koninkrijk en regelt de relatie tussen Nederland en de Caribische eilanden. Het Statuut werd ondertekend op 15 december 1954 in de Ridderzaal te Den Haag door Suriname en het land de Nederlandse Antillen, dat bestond uit de zes eilanden, Aruba, Bonaire, Curaçao, Sint Maarten, Sint Eustatius en Saba.\r\n\r\nIn 1975 werd Suriname een zelfstandig land. Aruba trad in 1986 uit de constellatie van de Nederlandse Antillen en kreeg een aparte status binnen het Koninkrijk. In 2010 werd het land ‘de Nederlandse Antillen’ opgeheven en werden Curaçao en Sint Maarten, net als Aruba, aparte landen binnen het Koninkrijk. Bonaire, Sint Eustatius en Saba kregen gezamenlijk de status van Nederlands gebiedsdeel in de Cariben en vallen nu bestuurlijk direct onder Nederland.\r\n\r\nDe volgende drie grondbeginselen zijn opgenomen in het Statuut:\r\n1.De landen binnen het koninkrijk behartigen zelfstandig hun eigen belangen.\r\n2.Zij verzorgen op voet van gelijkwaardigheid de gemeenschappelijke belangen.\r\n3.Zij verlenen elkaar wederkerig bijstand.\r\n\r\nDe gemeenschappelijke belangen die de landen binnen het Koninkrijk gezamenlijk op voet van gelijkwaardigheid behartigen staan bekend als de ‘koninkrijksaangelegenheden’. Hiertoe behoren zaken betrekking hebbende op de handhaving van de onafhankelijkheid en verdediging van het Koninkrijk, buitenlandse betrekkingen, Nederlanderschap, waarborgen van de fundamentele rechten en vrijheden, de rechtszekerheid en de deugdelijkheid van het bestuur.\r\n\r\nDe vier voornaamste bestuursorganen van de landen Aruba, Curaçao en St. Maarten zijn:\r\n1. De Gouverneur, vertegenwoordiger van het hoofd van de regering van het koninkrijk en van de regering van het land.\r\n2. De Staten, het parlement, bestaande uit hooguit 21 leden. Om de vier jaar worden verkiezingen gehouden om de Staten te kiezen. Zij hebben als taak wetten goed te keuren of te verwerpen en de regering te controleren.\r\n3. De Raad van Ministers, het kabinet, steunt op de meerderheid in de Staten. Samen met de Gouverneur vormen de ministers de Regering. De ministers zijn verantwoording verschuldigd aan de Staten. De gouverneur is onschendbaar.\r\n4. De Raad van Advies adviseert bij het maken van wetten.\r\n\r\nTer behartiging van de belangen van elk der landen maken drie ‘gevolmachtigde ministers’ van respectievelijk Curaçao, Aruba en Sint Maarten deel uit van de Rijksministerraad van het Koninkrijk in Nederland. Ook in de Raad van State, het adviescollege van de regering in Nederland, is een vertegenwoordiger aanwezig van elk der landen.', '28. Het statuut', '', 'inherit', 'closed', 'closed', '', '61-revision-v1', '', '', '2018-04-28 17:18:53', '2018-04-28 15:18:53', '', '61', 'https://canoncuracao.cw/61-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('648', '4', '2018-04-28 17:19:35', '2018-04-28 15:19:35', 'Het Statuut van het Koninkrijk der Nederlanden is de grondwet van het Koninkrijk en regelt de relatie tussen Nederland en de Caribische eilanden. Het Statuut werd ondertekend op 15 december 1954 in de Ridderzaal te Den Haag door Suriname en het land de Nederlandse Antillen, dat bestond uit de zes eilanden, Aruba, Bonaire, Curaçao, Sint Maarten, Sint Eustatius en Saba.\r\n\r\nIn 1975 werd Suriname een zelfstandig land. Aruba trad in 1986 uit de constellatie van de Nederlandse Antillen en kreeg een aparte status binnen het Koninkrijk. In 2010 werd het land ‘de Nederlandse Antillen’ opgeheven en werden Curaçao en Sint Maarten, net als Aruba, aparte landen binnen het Koninkrijk. Bonaire, Sint Eustatius en Saba kregen gezamenlijk de status van Nederlands gebiedsdeel in de Cariben en vallen nu bestuurlijk direct onder Nederland.\r\n\r\nDe volgende drie grondbeginselen zijn opgenomen in het Statuut:\r\n1.De landen binnen het koninkrijk behartigen zelfstandig hun eigen belangen.\r\n2.Zij verzorgen op voet van gelijkwaardigheid de gemeenschappelijke belangen.\r\n3.Zij verlenen elkaar wederkerig bijstand.\r\n\r\nDe gemeenschappelijke belangen die de landen binnen het Koninkrijk gezamenlijk op voet van gelijkwaardigheid behartigen staan bekend als de ‘koninkrijksaangelegenheden’. Hiertoe behoren zaken betrekking hebbende op de handhaving van de onafhankelijkheid en verdediging van het Koninkrijk, buitenlandse betrekkingen, Nederlanderschap, waarborgen van de fundamentele rechten en vrijheden, de rechtszekerheid en de deugdelijkheid van het bestuur.\r\n\r\nDe vier voornaamste bestuursorganen van de landen Aruba, Curaçao en St. Maarten zijn:\r\n1. De Gouverneur, vertegenwoordiger van het hoofd van de regering van het koninkrijk en van de regering van het land.\r\n2. De Staten, het parlement, bestaande uit hooguit 21 leden. Om de vier jaar worden verkiezingen gehouden om de Staten te kiezen. Zij hebben als taak wetten goed te keuren of te verwerpen en de regering te controleren.\r\n3. De Raad van Ministers, het kabinet, steunt op de meerderheid in de Staten. Samen met de Gouverneur vormen de ministers de Regering. De ministers zijn verantwoording verschuldigd aan de Staten. De gouverneur is onschendbaar.\r\n4. De Raad van Advies adviseert bij het maken van wetten.\r\n\r\nTer behartiging van de belangen van elk der landen maken drie ‘gevolmachtigde ministers’ van respectievelijk Curaçao, Aruba en Sint Maarten deel uit van de Rijksministerraad van het Koninkrijk in Nederland. Ook in de Raad van State, het adviescollege van de regering in Nederland, is een vertegenwoordiger aanwezig van elk der landen.', '28. Het statuut', '', 'inherit', 'closed', 'closed', '', '61-revision-v1', '', '', '2018-04-28 17:19:35', '2018-04-28 15:19:35', '', '61', 'https://canoncuracao.cw/61-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('649', '4', '2018-04-28 17:25:21', '2018-04-28 15:25:21', '', 'env 107 005', '', 'inherit', 'open', 'closed', '', 'env-107-005', '', '', '2018-04-28 17:25:26', '2018-04-28 15:25:26', '', '59', 'https://canoncuracao.cw/wp-content/uploads/2017/05/env-107-005.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('650', '4', '2018-04-28 17:25:41', '2018-04-28 15:25:41', '', 'Foto 001', '', 'inherit', 'open', 'closed', '', 'foto-001', '', '', '2018-04-28 17:25:47', '2018-04-28 15:25:47', '', '59', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Foto-001.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('651', '4', '2018-04-28 17:30:11', '2018-04-28 15:30:11', '', '27. Algemeen kiesrecht', '', 'inherit', 'closed', 'closed', '', '59-revision-v1', '', '', '2018-04-28 17:30:11', '2018-04-28 15:30:11', '', '59', 'https://canoncuracao.cw/59-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('652', '4', '2018-04-28 17:31:51', '2018-04-28 15:31:51', '', '27. Algemeen kiesrecht', '', 'inherit', 'closed', 'closed', '', '59-revision-v1', '', '', '2018-04-28 17:31:51', '2018-04-28 15:31:51', '', '59', 'https://canoncuracao.cw/59-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('653', '4', '2018-04-28 17:38:50', '2018-04-28 15:38:50', '', 'Foto 143', '', 'inherit', 'open', 'closed', '', 'foto-143', '', '', '2018-04-28 17:38:53', '2018-04-28 15:38:53', '', '63', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Foto-143.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('654', '4', '2018-04-28 17:39:06', '2018-04-28 15:39:06', '', 'Foto 191', '', 'inherit', 'open', 'closed', '', 'foto-191', '', '', '2018-04-28 17:39:11', '2018-04-28 15:39:11', '', '63', 'https://canoncuracao.cw/wp-content/uploads/2017/05/Foto-191.jpg', '0', 'attachment', 'image/jpeg', '0');
INSERT INTO `wp_posts` VALUES('655', '4', '2018-04-28 17:41:27', '2018-04-28 15:41:27', '', '29. Vrouwenemancipatie', '', 'inherit', 'closed', 'closed', '', '63-revision-v1', '', '', '2018-04-28 17:41:27', '2018-04-28 15:41:27', '', '63', 'https://canoncuracao.cw/63-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('656', '4', '2018-04-28 17:42:11', '2018-04-28 15:42:11', '', '29. Vrouwenemancipatie', '', 'inherit', 'closed', 'closed', '', '63-revision-v1', '', '', '2018-04-28 17:42:11', '2018-04-28 15:42:11', '', '63', 'https://canoncuracao.cw/63-revision-v1/', '0', 'revision', '', '0');
INSERT INTO `wp_posts` VALUES('657', '4', '2018-04-28 17:46:42', '2018-04-28 15:46:42', 'Vroeg in de jaren ’60 werd duidelijk dat bestaande verhoudingen in de Curaçaose samenleving ter discussie kwamen te staan. De verkiezingen voor het parlement van de Nederlandse Antillen van 1962 leverden een vurige strijd op tussen de Democratische Partij (DP), de partij van het lokale establishment, en de voorheen machtige bisschop. Deze keerde zich openlijk tegen alle grote partijen nu deze kritischer werden over de kerkelijke instellingen en kerkelijke invloed. De strijd kende enkel verliezers. De Katholieke Volks Partij verloor dusdanig, dat de partij voorgoed de politieke arena verliet. De DP liep een zware deuk op, maar kon toch de regering vormen door een gunstige coalitievorming. Zoals reeds vaker was gebeurd, was de grootste winnaar ook de grootste verliezer: de Nationale Volks Partij (NVP) won op het eiland Curaçao, maar belandde op landelijk niveau in de oppositie en maakte dus geen deel uit van de regering van het land de Nederlandse Antillen.\r\n\r\nDe lagere volksklasse – overwegend Afro-Curaçaos, laaggeschoold, katholiek en de NVP aanhangend – had in 1962 al veertien jaar stemrecht, maar zag haar stem niet terug in het centrum van de macht. Dezelfde groep werd vanaf eind jaren ‘50 het meest getroffen door de economische crisis als gevolg van de veranderende oliemarkt. Deze crisis zou gedurende de gehele jaren ’60 aanhouden. Van de hoge verwachtingen van de Curaçaose volksklasse, dat zij zou kunnen delen in de economische en maatschappelijke voorspoed, die in de jaren ’40 tot ontwikkeling waren gekomen, was bitter weinig terecht gekomen.\r\n\r\nMede onder invloed van het Tweede Vaticaanse Concilie, dat in 1962 van start ging, veranderde ook op Curaçao de aard van de maatschappelijke inspanningen van de katholieke kerk. Een centrale figuur hierin was pater Amado Römer, die zich inzette voor het vormen van vakbondsleiders en de motor was achter coöperatieve verenigingen zoals de Credit Unions. Structurele armoedebestrijding gericht op de laagste volksklasse kwam echter niet tot stand, ook niet vanuit de overheid.\r\n\r\nIn de tweede helft van de jaren ’60 nam het protest van de vakbonden tegen de loonpolitiek van de grote bedrijven toe. Ook groeide het maatschappelijk protest tegen de structurele armoede en achterstand op het eiland.Hoogopgeleide jongeren uitten felle kritiek op het politieke establishment en de sociale ongelijkheid via nieuw opgerichte tijdschriften, zoals <em>Vitó</em> en <em>Ruku</em>.\r\n\r\nZoals op veel plaatsen in de wereld (denk bijvoorbeeld aan de studentenrevoltes in de zomer van 1968 in Parijs, de provobeweging in Nederland, Black Power, Black Panthers, ‘flowerpower’)\r\n\r\nontstond er in de zestiger jaren op Curaçao een beweging die streefde naar verandering, een radicale breuk met het verleden. Deze tijdgeest was duidelijk herkenbaar op bijeenkomsten op het Gomezplein in Punda waar mensen bij elkaar kwamen rond de verkoop van het radicale tijdschrift Vitó.\r\n\r\nMet zware economische omstandigheden en een toenemende werkloosheid brak het jaar 1969 aan. Op 30 mei van dat jaar vond op Curaçao een grote protestmars plaats die ontaardde in een geweldsexplosie.Vanaf deze dag viel niet meer te ontkennen dat Curaçao een groot probleem had met een structureel maatschappelijk karakter.', '30. De 60er jaren - een sfeer van verande